/*
 * Copyright Staffan Gimåker 2008-2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_RENDERER_OBJECT_ENTITY_HH_INCLUDED
#define PEEKABOT_RENDERER_OBJECT_ENTITY_HH_INCLUDED


#include <Eigen/Geometry>
#include <boost/signals2.hpp>

#include "Types.hh"
#include "State.hh"
#include "Entity.hh"


namespace peekabot
{
    namespace renderer
    {
        class PrepareRenderContext;

        class ObjectEntity : public Entity
        {
        public:
            ObjectEntity();

            void set_transformation(const Eigen::Transform3f &mtow);

            inline const Eigen::Transform3f &get_transformation() const throw()
            {
                return m_mtow;
            }

            float get_x_scale() const throw();

            float get_y_scale() const throw();

            float get_z_scale() const throw();

            virtual void set_opacity(float alpha);

            virtual void set_color(const RGBColor &color);

            void set_name(uint32_t name);

            void set_layer(uint32_t layer);

            uint32_t get_layer() const throw();

            void set_visibility(bool visible);

            inline bool is_visible() const throw()
            {
                return m_is_visible;
            }

            void set_selected(bool is_selected) throw();

            void set_has_selected_ancestor(bool has_selected_ancestor) throw();

            inline bool is_selected() const throw()
            {
                return m_is_selected;
            }

            inline bool has_selected_ancestor() const throw()
            {
                return m_has_selected_ancestor;
            }

            inline const State &get_template_state() const throw()
            {
                return m_template_state;
            }

            virtual void get_renderables(PrepareRenderContext &context) const = 0;

            ObjectEntity *get_parent();

            const ObjectEntity *get_parent() const;

            void set_parent(ObjectEntity *parent);

            const Eigen::Transform3f &get_parent_transformation() const throw();


            /// \name Signals
            /// @{

            typedef boost::signals2::signal<void (const ObjectEntity *)> OnTransformationSet;
            mutable OnTransformationSet m_on_transformation_set;

            typedef boost::signals2::signal<void (const ObjectEntity *)> OnVisibilitySet;
            mutable OnVisibilitySet m_on_visibility_set;

            typedef boost::signals2::signal<void (const ObjectEntity *)> OnSelectedSet;
            mutable OnSelectedSet m_on_selected_set;

            /// @}

        protected:
            virtual void on_transformation_set() {}

        private:
            Eigen::Transform3f m_mtow;

            uint32_t m_layer;

            bool m_is_visible;

            State m_template_state;

            bool m_is_selected;

            bool m_has_selected_ancestor;

            ObjectEntity *m_parent;
        };
    }
}


#endif // PEEKABOT_RENDERER_OBJECT_ENTITY_HH_INCLUDED
