/*
 * Copyright Staffan Gimåker 2007-2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef PEEKABOT_RENDERER_PBMF_LOADER_HH_INCLUDED
#define PEEKABOT_RENDERER_PBMF_LOADER_HH_INCLUDED


#include <GL/glew.h>
#include <stdexcept>
#include <fstream>
#include <boost/cstdint.hpp>

#include "ResourceLoader.hh"
#include "../Types.hh"

#include "entities/MeshBased.hh"


namespace peekabot
{
    class Path;

    namespace serialization
    {
        class DeserializationInterface;
    }

    using serialization::DeserializationInterface;

    namespace renderer
    {
        // Note: it shouldn't output ModelNodes, no...
        class PbmfLoader : public ResourceLoader<MeshBased>
        {
        public:
            PbmfLoader() throw();

            virtual ResourceType *load(const Path &path)
                throw(std::runtime_error);

        private:
            void reset() throw();

            // return true if big endian
            bool read_preamble(std::ifstream &ifs);

            void read_header(DeserializationInterface &buf);

            void read_material(DeserializationInterface &buf);

            void read_data(DeserializationInterface &buf);


            static std::string get_expanded_path(
                const std::string &path,
                const std::list<std::string> &search_dirs) throw();

        private:
            int m_version;

            uint32_t m_vertex_count;

            uint32_t m_tri_count;

            bool m_has_uv_coords;

            bool m_has_colors;


            float m_bsphere_radius;

            Eigen::Vector3f m_bsphere_center;


            /*bool m_use_texture;

            bool m_use_colors;*/

            
            bool m_disable_backface_culling;

            bool m_always_draw_back_to_front;


            RGBColor m_ambient_reflectance;

            RGBColor m_diffuse_reflectance;

            RGBColor m_specular_reflectance;

            RGBColor m_emissitivity;

            float m_shininess;

            std::string m_texture_filename;


            GLfloat *m_vertices;
            GLfloat *m_normals;
            GLfloat *m_uv_coords;
            boost::uint8_t *m_colors;
            uint32_t  *m_indices;
        };


    }
}



#endif // PEEKABOT_RENDERER_PBMF_LOADER_HH_INCLUDED
