/*
 * Copyright Staffan Gimåker 2007-2008.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_RENDERER_RENDERABLE_HH_INCLUDED
#define PEEKABOT_RENDERER_RENDERABLE_HH_INCLUDED


#include "State.hh"


namespace peekabot
{
namespace renderer
{
    class RenderContext;
    

    /**
     * \brief An interface class to be implemented by anything that's 
     * renderable.
     *
     * By implementing the Renderable interface, the class can use the state 
     * management framework provided by the State and Statelet classes.
     * It also makes it possible to cooperate with a class implementing the
     * Cullable interface (and thereby gaining indirect access to culling 
     * facilities).
     *
     * Each Renderable has a State, accessed by get_state(), that it can setup
     * and manipulate in order to yield its desired appearance.
     * The actual rendering operation is specified by implementing the render()
     * method - note that it should typically \e not contain state changing 
     * code, that should be handled by the State!
     */
    class Renderable
    {
    public:
        Renderable() {}

        /*Renderable(const Renderable &renderable)
          : m_state(renderable.m_state) {} */

        virtual ~Renderable() {}

        /**
         * \copydoc get_state()
         */
        const State &get_state() const throw() { return m_state; }

        /**
         * \brief Get a reference to the renderable's rendering state.
         *
         * This is the state is applied before rendering, along with
         * parts of the baseline state (see State), and is used to control
         * rendering attributes (e.g., no lighting) as well as data sources
         * (vertex buffers, for example).
         *
         * \sa State
         */
        State &get_state() throw() { return m_state; }
        
        /**
         * \brief Change the renderable's state to the state specified.
         */
        void set_state(const State &state) throw() { m_state = state; }

        /**
         * \brief Render the renderable.
         */
        virtual void render(RenderContext &context) const = 0;

        /*inline bool is_always_on_top() const throw() { return m_always_on_top; }

        void toggle_always_on_top(bool always_on_top) throw()
        {
            m_always_on_top = always_on_top;
        }

        inline bool selection_effects_enabled() const throw()
        {
            return m_enable_selection_effects;
        }

        void toggle_selection_effects(bool enable_selection_effects) throw()
        {
            m_enable_selection_effects = enable_selection_effects;
            }*/

    private:
        /**
         * \brief The renderable's "required" OpenGL rendering state.
         */
        State m_state;

        //bool m_always_on_top:1;
        //bool m_enable_selection_effects:1;
    };
}
}


#endif // PEEKABOT_RENDERER_RENDERABLE_HH_INCLUDED
