/*
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_RENDERER_RESOURCE_LOADER_HH_INCLUDED
#define PEEKABOT_RENDERER_RESOURCE_LOADER_HH_INCLUDED


namespace peekabot
{
    class Path;

    namespace renderer
    {
        /**
         * \brief Resource loader inteface.
         *
         * Used to implement resource loaders that can be registered with a \c ResourceFactory.
         */
        template<class T>
        class ResourceLoader
        {
        public:
            typedef T ResourceType;

            virtual ~ResourceLoader() {}

            virtual ResourceType *load(const Path &) = 0;
        };
    }
}


#endif // PEEKABOT_RENDERER_RESOURCE_LOADER_HH_INCLUDED
