/*
 * Copyright Staffan Gimåker 2008-2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_RENDERER_SCENE_MANAGER_HH_INCLUDED
#define PEEKABOT_RENDERER_SCENE_MANAGER_HH_INCLUDED


#include <set>

#include "Octree.hh"


namespace peekabot
{
    namespace renderer
    {
        class Entity;
        class ObjectEntity;
        class SceneTraverser;

        class SceneManager
        {
        public:
            SceneManager();

            ~SceneManager();

            void traverse(const Camera &camera, SceneTraverser &traverser);

            typedef std::set<const ObjectEntity *> SelectedSet;

            const SelectedSet &get_selected() const throw();

            void add_entity(const Entity *entity);

            void remove_entity(const Entity *entity);

        private:
            void on_visibility_set(const ObjectEntity *entity);

            void on_world_bv_set(const CullableEntity *entity);

            void on_selected_set(const ObjectEntity *entity);

        private:
            Octree m_octree;

            typedef std::set<const Entity *> NonCullableContainer;

            NonCullableContainer m_non_cullable;

            SelectedSet m_selected;
        };
    }
}


#endif // PEEKABOT_RENDERER_SCENE_MANAGER_HH_INCLUDED
