/*
 * Copyright Staffan Gimåker 2007-2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef PEEKABOT_RENDERER_VERTEX_BUFFER_HH_INCLUDED
#define PEEKABOT_RENDERER_VERTEX_BUFFER_HH_INCLUDED


#include "ArrayBuffer.hh"


namespace peekabot
{
    namespace renderer
    {
        class VertexBuffer : public ArrayBuffer
        {
        public:
            explicit VertexBuffer(bool force_no_vbos = false);

            VertexBuffer(const VertexBuffer &other);

            // use this VBO to source vertices
            void source_vertex_data(
                std::size_t size, GLenum type,
                std::size_t stride, std::size_t off) const;

            // use this VBO to source UV-coords
            void source_texcoord_data(
                std::size_t size, GLenum type,
                std::size_t stride, std::size_t offs) const;

            // use this VBO to source normals
            void source_normal_data(
                GLenum type, std::size_t stride, std::size_t off) const;

            // use this VBO to source colors
            void source_color_data(
                std::size_t size, GLenum type,
                std::size_t stride, std::size_t off) const;
        };
    }
}


#endif // PEEKABOT_RENDERER_VERTEX_BUFFER_HH_INCLUDED
