/*
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __PEEKABOT_RENDERER_PRIMITIVES_CIRCLE_HH
#define __PEEKABOT_RENDERER_PRIMITIVES_CIRCLE_HH


#include "MeshBased.hh"
#include "../Statelet.hh"
#include "../LineBased.hh"


namespace peekabot
{
    namespace renderer
    {
        class Circle : public MeshBased, public LineBased
        {
        public:
            Circle(uint8_t lod_count, 
                   const BoundingSphere &bsphere, 
                   float hysteresis) throw()
                : MeshBased(lod_count, bsphere, hysteresis) {}

            Circle(const Circle &x) throw()
                : MeshBased(x) {}

            Circle *clone() const throw()
            {
                return new Circle(*this);
            }

            virtual void set_line_style(
                float line_width, 
                uint16_t stipple_pattern, 
                int stipple_factor)
            {
                for( uint8_t i = 0; i < m_n_lods; ++i )
                {
                    m_lods[i].m_mesh->get_state().set(
                        new statelets::LineParams(
                            line_width, stipple_pattern != 0xFFFF,
                            stipple_factor, stipple_pattern));
                }
            }
        };
    }
}


#endif // __PEEKABOT_RENDERER_PRIMITIVES_CIRCLE_HH
