/*
 * Copyright Staffan Gimåker 2007-2008.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_RENDERER_PRIMITIVES_MESH_BASED_HH_INCLUDED
#define PEEKABOT_RENDERER_PRIMITIVES_MESH_BASED_HH_INCLUDED


#include "../../Types.hh"
#include "../CullableEntity.hh"
#include "../BoundingVolumes.hh"
#include "../Mesh.hh"


namespace peekabot
{
    namespace renderer
    {
        class MeshBased : public CullableEntity
        {
        public:
            MeshBased(uint8_t lod_count, 
                      const BoundingSphere &bsphere, 
                      float hysteresis) throw();

            virtual ~MeshBased();

            MeshBased(const MeshBased &x) throw();

            virtual MeshBased *clone() const throw();

            void set_lod(uint8_t lod_no, uint16_t coverage, const Mesh *mesh) throw();

            virtual void get_renderables(PrepareRenderContext &context) const;
    
        protected:
            struct LOD
            {
                LOD() throw() : m_mesh(0), m_threshold(0) {}
                ~LOD() throw() { if( m_mesh != 0 ) delete m_mesh; }

                Mesh   *m_mesh;
                uint16_t  m_threshold;
            };

            uint8_t m_n_lods;
            mutable uint8_t m_curr_lod;
            // 0-100
            uint8_t m_hysteresis;

            LOD *m_lods;
        };
    }
}


#endif // PEEKABOT_RENDERER_PRIMITIVES_MESH_BASED_HH_INCLUDED
