/*
 * Copyright Staffan Gimåker 2007-2008, 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_RENDERER_PRIMITIVES_MESH_ENTITIES_HH_INCLUDED
#define PEEKABOT_RENDERER_PRIMITIVES_MESH_ENTITIES_HH_INCLUDED


#include "../../Types.hh"
#include "../CullableEntity.hh"
#include "../VertexBased.hh"
#include "../LineBased.hh"
#include "../IndexBased.hh"

#include <vector>
#include <Eigen/Core>
#include <boost/shared_ptr.hpp>



namespace peekabot
{
    namespace renderer
    {
        class Mesh;

        class MeshEntity : public CullableEntity,
                           public VertexBased
        {
        public:
            MeshEntity(boost::shared_ptr<Mesh> mesh) throw();

            virtual ~MeshEntity();

            virtual void get_renderables(PrepareRenderContext &context) const;

            virtual void set_vertices(
                const Vertices &vertices) throw();

            virtual void add_vertices(
                const Vertices &new_vertices,
                const Vertices &all_vertices) throw();

            virtual void get_vertices(Vertices &vertices) const throw();

            virtual void set_colored_vertices(
                const Vertices &vertices,
                const VertexColors &colors);

            virtual void add_colored_vertices(
                const Vertices &new_vertices,
                const Vertices &all_vertices,
                const VertexColors &new_colors,
                const VertexColors &all_colors);

            boost::shared_ptr<Mesh> get_mesh() throw();

            const boost::shared_ptr<Mesh> get_mesh() const throw();

        protected:
            void calculate_bvs(const Vertices &vertices) throw();

            void extend_bvs(const Vertices &new_vertices) throw();

        protected:
            boost::shared_ptr<Mesh> m_mesh;
        };


        class PointMeshEntity : public MeshEntity
        {
        public:
            PointMeshEntity() throw();

            PointMeshEntity(const PointMeshEntity &x) throw();

            virtual ~PointMeshEntity();

            virtual PointMeshEntity *clone() const throw();
        };


        class LineMeshEntity : public MeshEntity,
                               public LineBased
        {
        public:
            LineMeshEntity() throw();

            LineMeshEntity(const LineMeshEntity &x) throw();

            virtual ~LineMeshEntity();

            virtual LineMeshEntity *clone() const throw();

            virtual void set_line_style(
                float line_width,
                uint16_t stipple_pattern,
                int stipple_factor);
        };
    }
}


#endif // PEEKABOT_RENDERER_PRIMITIVES_MESH_ENTITIES_HH_INCLUDED
