/*
 * Copyright Staffan Gimåker 2009.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_RENDERER_TRANSFORMATION_GUIDES_HH_INCLUDED
#define PEEKABOT_RENDERER_TRANSFORMATION_GUIDES_HH_INCLUDED


#include "../Types.hh"
#include "../Entity.hh"


namespace peekabot
{
    namespace renderer
    {
        class SceneManager;

        class TransformationGuides : public Entity
        {
        public:
            TransformationGuides(const SceneManager &scene_manager);

            virtual void get_renderables(PrepareRenderContext &context) const;

            void set_mode(TransformationGuidesMode mode);

            void set_coord_sys(CoordinateSystem coord_sys);

            void set_pivot(RotationCenterpoint pivot);

            void set_axes(Axis axes);

        private:
            void generate_move_guides(PrepareRenderContext &context) const;

            void generate_rotate_guides(PrepareRenderContext &context) const;

        private:
            const SceneManager &m_scene_manager;

            TransformationGuidesMode m_mode;

            CoordinateSystem m_coord_sys;

            RotationCenterpoint m_pivot;

            Axis m_axes;
        };
    }
}


#endif // PEEKABOT_RENDERER_TRANSFORMATION_GUIDES_HH_INCLUDED
