/*
 * Copyright Staffan Gimåker 2007-2008.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_RENDERER_STATELETS_TEXTURE_2D_HH_INCLUDED
#define PEEKABOT_RENDERER_STATELETS_TEXTURE_2D_HH_INCLUDED


#include "../Statelet.hh"
#include "../Texture.hh"


namespace peekabot
{
    namespace renderer
    {  
        namespace statelets
        {
            /**
             * \brief Class that handles storage and binding of textures.
             */
            class Texture2D : public TypedStatelet<Texture2D>
            {
                class Impl : public StateletImpl
                {
                    bool m_enable;

                    boost::shared_ptr<Texture> m_texture;

                public:
                    Impl(bool enable = true);

                    Impl(boost::shared_ptr<Texture> texture, bool enable = true);

                    virtual void activate() throw();
                };

            public :
                Texture2D(boost::shared_ptr<Texture> texture)
                    : TypedStatelet<Texture2D>(
                        boost::shared_ptr<StateletImpl>(
                            new Impl( texture ))) {}

                Texture2D()
                    : TypedStatelet<Texture2D>(
                        boost::shared_ptr<StateletImpl>(
                            new Impl( false ))) {}
            };
        }
    }
}


#endif // PEEKABOT_RENDERER_STATELETS_TEXTURE_2D_HH_INCLUDED
