/*
 * Copyright Staffan Gimåker 2007-2009.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_RENDERER_STATELETS_TRANSFORMATION_HH_INCLUDED
#define PEEKABOT_RENDERER_STATELETS_TRANSFORMATION_HH_INCLUDED


#include <GL/glew.h>
#include <Eigen/Geometry>

#include "../Statelet.hh"


namespace peekabot
{
    namespace renderer
    {
        namespace statelets
        {
            class Transformation : public TypedStatelet<Transformation>
            {
                class TransformationImpl : public StateletImpl
                {
                    const Eigen::Transform3f &m_transformation;
                public:
                    TransformationImpl(const Eigen::Transform3f &transformation) throw()
                        : m_transformation(transformation) {}

                    virtual void activate() throw()
                    {
                        glPushMatrix();
                        glMultMatrixf(reinterpret_cast<const GLfloat *>(
                                          m_transformation.data()));
                    }

                    virtual void deactivate() throw()
                    {
                        glPopMatrix();
                    }
                };

            public:
                Transformation(const Eigen::Transform3f &transformation) throw()
                    : TypedStatelet<Transformation>(
                        boost::shared_ptr<StateletImpl>(
                            new TransformationImpl(transformation))) {}

                // This is dangerous/ugly.. passing a reference to a static matrix...
                Transformation() throw()
                : TypedStatelet<Transformation>(
                    boost::shared_ptr<StateletImpl>(
                        new TransformationImpl(ms_eye))) {}

            private:
                static Eigen::Transform3f ms_eye;
            };
        }
    }
}

#endif // PEEKABOT_RENDERER_STATELETS_TRANSFORMATION_HH_INCLUDED
