/*
 * Copyright Staffan Gimåker 2008-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_SERIALIZATION_ACCESS_HH_INCLUDED
#define PEEKABOT_SERIALIZATION_ACCESS_HH_INCLUDED


#include <boost/mpl/int.hpp>


namespace peekabot
{
    namespace serialization
    {
        class SerializableFactory;
        template<typename> class SerializableInfo;
        class SerializationInterface;
        class DeserializationInterface;

        namespace detail
        {
            template<typename T> struct VersionTag
            {
                typedef boost::mpl::int_<0> value;
            };
        }
    }
}

#define PEEKABOT_SERIALIZABLE \
    friend class peekabot::serialization::SerializableFactory; \
    template<typename> friend class peekabot::serialization::SerializableInfo; \
    friend class peekabot::serialization::SerializationInterface; \
    friend class peekabot::serialization::DeserializationInterface;

#define PEEKABOT_CLASS_VERSION(CLASS, VERSION)                  \
    namespace peekabot                                          \
    {                                                           \
        namespace serialization                                 \
        {                                                       \
            namespace detail                                    \
            {                                                   \
                template<> struct VersionTag<CLASS>             \
                {                                               \
                    typedef boost::mpl::int_<VERSION> value;    \
                };                                              \
            }                                                   \
        }                                                       \
    }


#endif // PEEKABOT_SERIALIZATION_ACCESS_HH_INCLUDED
