/*
 * Copyright Staffan Gimåker 2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_SERIALIZATION_SMART_PTRS_HH_INCLUDED
#define PEEKABOT_SERIALIZATION_SMART_PTRS_HH_INCLUDED


#include <boost/shared_ptr.hpp>

#include "SerializationInterface.hh"
#include "DeserializationInterface.hh"


namespace peekabot
{
    template<typename T> inline
    SerializationInterface &operator<<(
        SerializationInterface &ar, const boost::shared_ptr<T> &x)
    {
        ar << x.get();
        return ar;
    }

    template<typename T> inline
    DeserializationInterface &operator>>(
        DeserializationInterface &ar, boost::shared_ptr<T> &x)
    {
        T *t;
        ar >> t;
        x.reset(t);
        return ar;
    }
}


#endif // PEEKABOT_SERIALIZATION_SMART_PTRS_HH_INCLUDED
