/*
 * Copyright Staffan Gimåker 2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_STREAMBUF_ADAPTER_HH_INCLUDED
#define PEEKABOT_STREAMBUF_ADAPTER_HH_INCLUDED


#include <streambuf>
#include <stdexcept>

#include "DeserializationBuffer.hh"
#include "SerializationBuffer.hh"


namespace peekabot
{
    class StreambufAdapter :
        public serialization::DeserializationBuffer,
        public serialization::SerializationBuffer
    {
    public:
        StreambufAdapter(std::basic_streambuf<char> &buf)
            : m_buf(buf)
        {
        }

        virtual void read(void *x, std::size_t n)
        {
            if( (std::size_t)m_buf.sgetn((char *)x, n) != n )
                throw std::runtime_error(
                    "Failed to load data, buffer exhausted");
        }

        virtual void write(const void *x, std::size_t n)
        {
            if( (std::size_t)m_buf.sputn((const char *)x, n) != n )
                throw std::runtime_error("Failed to write data");
        }

    private:
        std::basic_streambuf<char> &m_buf;
    };
}


#endif // PEEKABOT_STREAMBUF_ADAPTER_HH_INCLUDED
