/*
 * Copyright Staffan Gimåker 2008-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_SERIALIZATION_TYPES_HH_INCLUDED
#define PEEKABOT_SERIALIZATION_TYPES_HH_INCLUDED


#include "../Types.hh"
#include "DeserializationInterface.hh"
#include "SerializationInterface.hh"


namespace peekabot
{
    inline SerializationInterface &operator<<(
        SerializationInterface &ar, const RGBColor &x)
    {
        ar << x.r << x.g << x.b;
        return ar;
    }

    inline DeserializationInterface &operator>>(
        DeserializationInterface &ar, RGBColor &x)
    {
        ar >> x.r >> x.g >> x.b;
        return ar;
    }

    inline void save(SerializationInterface &ar, const RGBAColor &x)
    {
        ar << x.r << x.g << x.b << x.a;
    }

    inline void load(DeserializationInterface &ar, RGBAColor &x, int version)
    {
        ar >> x.r >> x.g >> x.b >> x.a;
    }

    inline void save(SerializationInterface &ar, const Opacity &x)
    {
        ar << x.is_absolute << x.opacity;
    }

    inline void load(DeserializationInterface &ar, Opacity &x, int version)
    {
        ar >> x.is_absolute >> x.opacity;
    }

    inline void save(SerializationInterface &ar, const Vector3 &x)
    {
        ar << x.x << x.y << x.z;
    }

    inline void load(DeserializationInterface &ar, Vector3 &x, int version)
    {
        ar >> x.x >> x.y >> x.z;
    }

    inline void save(SerializationInterface &ar, const Transformation &x)
    {
        ar << x.x << x.y << x.z << x.pos;
    }

    inline void load(
        DeserializationInterface &ar, Transformation &x, int version)
    {
        ar >> x.x >> x.y >> x.z >> x.pos;
    }
}


#endif // PEEKABOT_SERIALIZATION_TYPES_HH_INCLUDED
