/*
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <string>
#include <boost/test/unit_test.hpp>

#include "Fixture.hh"


using namespace peekabot;


BOOST_AUTO_TEST_SUITE( Serialization_String );


BOOST_FIXTURE_TEST_CASE( save_load_string, Fixture )
{
    const std::string data = "crunky funky test string";
    {
        SerializationInterface *ret;

        BOOST_CHECK_NO_THROW( ret = &(m_ser << data) );
        // Check returned serialization interface, should be the same as
        // the one we passed along (or m_ser << foo << bar; won't work)
        BOOST_CHECK_EQUAL( ret, &m_ser );
        // Check to see that the buffer has grown accordingly
        // after we've saved a value in it
        BOOST_CHECK_EQUAL( m_buf.get_size(), data.length() + sizeof(uint32_t) );
    }
    {
        DeserializationInterface *ret;
        std::string read_back;

        BOOST_CHECK_NO_THROW( ret = &(m_deser >> read_back) );
        BOOST_CHECK_EQUAL( ret, &m_deser );
        BOOST_CHECK_EQUAL( read_back.length(), data.length() );
        BOOST_CHECK_EQUAL( read_back, data );
        BOOST_CHECK_EQUAL( m_buf.get_size(), 0u );
    }
}

BOOST_FIXTURE_TEST_CASE( save_load_string_array, Fixture )
{
    const size_t n = 5;
    const std::string data[n] = {
        "",
        "a",
        "crunky funky test string",
        "foobar",
        "krink krank spink spank boink kroink"
    };

    {
        SerializationInterface *ret;

        BOOST_CHECK_NO_THROW( ret = &(m_ser << data) );
        // Check returned serialization interface, should be the same as
        // the one we passed along (or m_ser << foo << bar; won't work)
        BOOST_CHECK_EQUAL( ret, &m_ser );
    }
    {
        DeserializationInterface *ret;
        std::string read_back[n];

        BOOST_CHECK_NO_THROW( ret = &(m_deser >> read_back) );
        BOOST_CHECK_EQUAL( ret, &m_deser );
        BOOST_CHECK_EQUAL( m_buf.get_size(), 0u );

        for( size_t i = 0; i < n; ++i )
        {
            BOOST_CHECK_EQUAL( read_back[i].length(), data[i].length() );
            BOOST_CHECK_EQUAL( read_back[i], data[i] );
        }

        BOOST_CHECK( m_buf.is_empty() );
    }
}


BOOST_AUTO_TEST_SUITE_END();
