#!/bin/bash

#
# Copyright Staffan Gimåker 2008-2009.
#
# ---
#
# This file is part of peekabot.
#
# peekabot is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# peekabot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

if [ $# -lt 1 ]; then
    echo "Usage: check_actions.sh <source-dir> [ignore-file]"
    exit 1
fi

reg_count=0
unreg_count=0
ignored_count=0
dir="$1"
ignore_file="$2"


for file in $( grep -o -e "actions/[A-Za-z0-9\/]\+\.\(hh\)" $dir/Makefile.am ); do
    file="$(echo $dir/$file | sed "s/\/\//\//g")"
    foo="$(grep -o -e "PEEKABOT_REGISTER_SERIALIZABLE[[:space:]]\+[[:digit:]]\+" $file)"

    if [ -z "$foo" ]; then
	class="$(echo $file | sed "s/.*actions\/\(\w*\)\.hh/\1/g")"

	if [ -e "$ignore_file" ] && [ -n "$(grep -x -e "[[:space:]]*$class[[:space:]]*" $ignore_file)" ]; then
	    let ignored_count=$ignored_count+1
	else
	    echo "Action $class is not exported ($file)"
	    let unreg_count=$unreg_count+1
	fi    
    else
	let reg_count=$reg_count+1
    fi
done

echo "$unreg_count non-registered classes found"
echo "$reg_count registered classes found"
echo "$ignored_count classes ignored"

if [ $unreg_count -gt 0 ]; then
    exit -1
else
    exit 0
fi
