#!/bin/bash

#
# Copyright Staffan Gimåker 2008-2009.
#
# ---
#
# This file is part of peekabot.
#
# peekabot is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# peekabot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

if [ $# -lt 1 ]; then
    echo "Usage: gen_action_registry.sh <source-dir> [output-file] [wiki-page]"
    exit 1
fi

dir="$1"
export_count=0

if [ -z "$2" ]; then
    outfile="$dir/ActionRegistry.cc"
else
    outfile="$2"
fi


for f in $( grep -o -e "actions/[A-Z0-9]\w*\.hh" $dir/Makefile.am ); do
    file="$(echo $dir/$f | sed "s/\/\//\//g")"
    foo="$(grep -o -e "PEEKABOT_REGISTER_SERIALIZABLE[[:space:]]\+[[:digit:]]\+" $file)"

    if [ -n "$foo" ]; then
	class="$(echo $f | sed "s/^actions\/\([[:alnum:]]\{0,\}\)\.hh/\1/g")"
	id="$(echo $foo | sed "s/PEEKABOT_REGISTER_SERIALIZABLE[[:space:]]\{1,\}//g")"

	echo "Found action $class, id=$id ($file)"

	class_tab[$export_count]=$class
	file_tab[$export_count]=$f
	id_tab[$export_count]=$id

	let export_count=$export_count+1
    fi
done


# Check ID uniquness
for ((i=0;i<$export_count;i++)); do
    for ((j=0;j<$export_count;j++)); do
	if [ $i -ne $j ] && [ ${id_tab[${i}]} -eq ${id_tab[${j}]} ]; then
	    id=${id_tab[${i}]}

	    class1=${class_tab[${j}]}
	    file1=${file_tab[${j}]}
	    class2=${class_tab[${i}]}
	    file2=${file_tab[${i}]}

	    echo ""
	    echo "ERROR: Duplicate ID $id found, in actions/files:"
	    echo "  $class1 ($file1)"
	    echo "  $class2 ($file2)"
	    echo ""

	    exit -1
	fi
    done
done


echo ""
echo "Success! $export_count actions found."
echo ""



# Generate the registration code
echo "/*
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * THIS FILE IS AUTOMATICALLY GENERATED - DO NOT EDIT!
 */

#include \"serialization/SerializableFactory.hh\"
#include \"ActionRegistry.hh\"

using namespace peekabot;
" > $outfile

for ((i=0;i<$export_count;i++)); do
    file=${file_tab[${i}]}
    echo "#include \"$file\"" >> $outfile
done

echo "
void peekabot::register_actions()
{" >> $outfile

for ((i=0;i<$export_count;i++)); do
    id=${id_tab[${i}]}
    class=${class_tab[${i}]}
    echo "    TheSerializableFactory::instance().register_type<$class>($id);" >> $outfile
done

echo "}" >> $outfile


# Output wiki page?
if [ -n "$3" ]; then
    touch "$3"
    rm "$3"

    for ((i=0;i<$export_count;i++)); do
	id=${id_tab[${i}]}
	class=${class_tab[${i}]}
	echo "$id || !$class" >> "$3"
    done

    sort -g "$3" -o "$3"
    sed -i 's/.*/|| \0 ||/g' "$3"
fi

exit 0