#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.20';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CNTH',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoG5XII',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoR6',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData10',
	'Image::ExifTool::Canon::ColorData11',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::LogInfo',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::RawBurstInfo',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::Canon::WBInfo',
	'Image::ExifTool::Canon::uuid',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::ColorSpec',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type5',
	'Image::ExifTool::Kodak::Type6',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Microsoft::Xtra',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFInfo2V0400',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::AutoCaptureInfo',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::BracketingInfoD500',
	'Image::ExifTool::Nikon::BracketingInfoD810',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::ColorBalanceUnknown2',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::DistortionInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::FlashInfo0300',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::HDRInfo2',
	'Image::ExifTool::Nikon::ISOAutoInfoD810',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::IntervalInfoD6',
	'Image::ExifTool::Nikon::IntervalInfoZ7II',
	'Image::ExifTool::Nikon::JPGInfoD500',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LensData0402',
	'Image::ExifTool::Nikon::LensData0403',
	'Image::ExifTool::Nikon::LensData0800',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MakerNotes0x51',
	'Image::ExifTool::Nikon::MakerNotes0x56',
	'Image::ExifTool::Nikon::MenuSettingsD850',
	'Image::ExifTool::Nikon::MenuSettingsZ7II',
	'Image::ExifTool::Nikon::MenuSettingsZ8',
	'Image::ExifTool::Nikon::MenuSettingsZ8v2',
	'Image::ExifTool::Nikon::MenuSettingsZ9',
	'Image::ExifTool::Nikon::MenuSettingsZ9v3',
	'Image::ExifTool::Nikon::MenuSettingsZ9v4',
	'Image::ExifTool::Nikon::MoreSettingsD850',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::MultiExposure2',
	'Image::ExifTool::Nikon::Offset13InfoZ9',
	'Image::ExifTool::Nikon::OrientationInfo',
	'Image::ExifTool::Nikon::OtherInfoD500',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PictureControl3',
	'Image::ExifTool::Nikon::PortraitInfoZ7II',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::RotationInfoD500',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::SeqInfoD6',
	'Image::ExifTool::Nikon::SeqInfoZ9',
	'Image::ExifTool::Nikon::SettingsInfoD810',
	'Image::ExifTool::Nikon::ShootingMenuD500',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::VignetteInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::NikonCustom::SettingsZ8',
	'Image::ExifTool::NikonCustom::SettingsZ9',
	'Image::ExifTool::NikonCustom::SettingsZ9v4',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::DSA',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::ItemList',
	'Image::ExifTool::QuickTime::ItemPropCont',
	'Image::ExifTool::QuickTime::Keys',
	'Image::ExifTool::QuickTime::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::QuickTime::UserData',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Reconyx::Type3',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sigma::WBSettings',
	'Image::ExifTool::Sigma::WBSettings2',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::HiddenInfo',
	'Image::ExifTool::Sony::ISOInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::SR2SubIFD',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9050c',
	'Image::ExifTool::Sony::Tag9050d',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag9406b',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::ACDSeeRegions',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Device',
	'Image::ExifTool::XMP::ExifTool',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GCamera',
	'Image::ExifTool::XMP::GCreations',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crd',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::hdr',
	'Image::ExifTool::XMP::hdrgm',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::panorama',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 112 => 0x69 },
	'about' => { 534 => 'about' },
	'aboutcvterm' => { 525 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 525 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 525 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 525 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 525 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 119 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 540 => 'absPeakAudioFilePath' },
	'academicfield' => { 530 => 'academicField' },
	'acceleration' => { 122 => 0x9404, 518 => 'Acceleration' },
	'accelerationtracking' => { 87 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 418 => 0x3 },
	'accelerometerdata' => { 408 => 'vrot' },
	'accelerometerx' => { 348 => 0x8d },
	'accelerometery' => { 348 => 0x8e },
	'accelerometerz' => { 348 => 0x8c },
	'accessoryserialnumber' => { 348 => 0x54 },
	'accessorytype' => { 348 => 0x53 },
	'acdseeregion' => { 487 => [\'Regions','RegionsRegionList'] },
	'acdseeregionalgarea' => { 487 => [\'Regions','RegionsRegionListALGArea'] },
	'acdseeregionalgareah' => { 487 => [\'Regions','RegionsRegionListALGAreaH'] },
	'acdseeregionalgareaw' => { 487 => [\'Regions','RegionsRegionListALGAreaW'] },
	'acdseeregionalgareax' => { 487 => [\'Regions','RegionsRegionListALGAreaX'] },
	'acdseeregionalgareay' => { 487 => [\'Regions','RegionsRegionListALGAreaY'] },
	'acdseeregionappliedtodimensions' => { 487 => [\'Regions','RegionsAppliedToDimensions'] },
	'acdseeregionappliedtodimensionsh' => { 487 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'acdseeregionappliedtodimensionsunit' => { 487 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'acdseeregionappliedtodimensionsw' => { 487 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'acdseeregiondlyarea' => { 487 => [\'Regions','RegionsRegionListDLYArea'] },
	'acdseeregiondlyareah' => { 487 => [\'Regions','RegionsRegionListDLYAreaH'] },
	'acdseeregiondlyareaw' => { 487 => [\'Regions','RegionsRegionListDLYAreaW'] },
	'acdseeregiondlyareax' => { 487 => [\'Regions','RegionsRegionListDLYAreaX'] },
	'acdseeregiondlyareay' => { 487 => [\'Regions','RegionsRegionListDLYAreaY'] },
	'acdseeregionname' => { 487 => [\'Regions','RegionsRegionListName'] },
	'acdseeregionnameassigntype' => { 487 => [\'Regions','RegionsRegionListNameAssignType'] },
	'acdseeregiontype' => { 487 => [\'Regions','RegionsRegionListType'] },
	'actionadvised' => { 134 => 0x2a },
	'activearea' => { 122 => 0xc68d },
	'actived-lighting' => { 239 => 0x22, 295 => 0x24 },
	'actived-lightingmode' => { 295 => 0x25 },
	'adaptervoltage' => { 141 => 0x407 },
	'addaspectratioinfo' => { 87 => 0x80e },
	'addiptcinformation' => { 87 => 0x815 },
	'additionalmodelinformation' => { 525 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 87 => 0x80f, 88 => 0x11, 89 => 0x13, 92 => 0x14 },
	'address' => { 164 => 'Address' },
	'adjustmentmode' => { 425 => 0x15 },
	'adlbracketingstep' => { 201 => 0x17 },
	'adlbracketingtype' => { 201 => 0x18 },
	'adobe' => { 123 => 'Adobe' },
	'adultcontentwarning' => { 334 => 'AdultContentWarning', 533 => 'adultContentWarning' },
	'advancedfilter' => { 130 => 0x1201 },
	'advancedraw' => { 297 => 0x76a43203 },
	'advancedscenetype' => { 348 => 0x3d },
	'advisory' => { 538 => 'Advisory' },
	'ae_iso' => { 356 => 0x2, 357 => 0x4, 358 => 0x12 },
	'aeaperture' => { 356 => 0x1, 357 => 0x3, 358 => 0x11 },
	'aeaperturesteps' => { 356 => 0x8, 357 => 0xb },
	'aeaverage' => { 1 => 0x6 },
	'aebautocancel' => { 87 => 0x104 },
	'aebbracketvalue' => { 79 => 0x11 },
	'aebracketingsteps' => { 201 => 0xf, 202 => 0xf, 277 => 0x174c },
	'aebsequence' => { 87 => 0x105 },
	'aebsequenceautocancel' => { 85 => 0x9, 86 => 0x9, 88 => 0x8, 89 => 0x9, 92 => 0x9, 93 => 0x7 },
	'aebshotcount' => { 87 => 0x106 },
	'aebxv' => { 356 => 0x4, 357 => 0x6 },
	'aeerror' => { 357 => 0x8 },
	'aeexposuretime' => { 356 => 0x0, 357 => 0x2, 358 => 0x10 },
	'aelbutton' => { 187 => 0x45 },
	'aelexposureindicator' => { 187 => 0x51 },
	'aelock' => { 187 => 0x5b, 306 => '4.2', 315 => '4.2', 324 => 0x201, 383 => 0x48, 435 => 0x40, 436 => 0x40, 437 => [0x86,0x286] },
	'aelockbutton' => { 304 => '16.1', 306 => '4.1', 309 => '15.1', 310 => '16.1', 311 => '16.1', 313 => '30.1', 314 => '16.1', 315 => '4.1', 317 => '17.1', 319 => '17.1' },
	'aelockbuttonplusdials' => { 304 => '16.2', 313 => '32.1', 317 => '44.1' },
	'aelockformb-d80' => { 319 => '3.1' },
	'aelockmetermodeafterfocus' => { 87 => 0x114 },
	'aematrix' => { 1 => 0x2 },
	'aemaxaperture' => { 356 => 0x9, 357 => 0x10, 358 => 0x1c },
	'aemaxaperture2' => { 356 => 0xa, 357 => 0x11, 358 => 0x1d },
	'aemeteringmode' => { 356 => 0xc },
	'aemeteringmode2' => { 356 => '13.1' },
	'aemeteringsegments' => { 190 => 0x628, 383 => 0x209 },
	'aemicroadjustment' => { 87 => 0x110 },
	'aeminaperture' => { 356 => 0xb, 357 => 0x12, 358 => 0x1e },
	'aeminexposuretime' => { 356 => 0x5, 357 => 0x13, 358 => 0x1f },
	'aeprogrammode' => { 356 => 0x6 },
	'aeprojectlink' => { 512 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 512 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 512 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 512 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 512 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 512 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 36 => 0x21 },
	'aestable' => { 1 => 0x4 },
	'aestheticscore' => { 337 => 'aesthetic_score' },
	'aetarget' => { 1 => 0x5 },
	'aewhitebalance' => { 356 => 0xd },
	'aexv' => { 356 => 0x3, 357 => 0x5 },
	'af-assistilluminator' => { 320 => 0x19, 321 => 0x19, 322 => 0x19 },
	'af-cfocusdisplay' => { 320 => 0x234, 321 => 0x234, 322 => 0x24c },
	'af-cpriority' => { 131 => '0.2' },
	'af-cpriorityselection' => { 304 => '1.1', 305 => '1.1', 307 => '1.1', 308 => '1.1', 310 => '0.1', 311 => '0.1', 312 => '0.1', 313 => '1.1', 314 => '0.1', 317 => '1.1', 318 => '1.1', 320 => 0x3, 321 => 0x3, 322 => 0x3 },
	'af-csetting' => { 127 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 127 => '0.2' },
	'af-ctrackingsensitivity' => { 127 => '0.1' },
	'af-czoneareaswitching' => { 127 => '0.3' },
	'af-onbutton' => { 307 => '70.1', 308 => '70.1', 318 => '70.1' },
	'af-onformb-d10' => { 304 => '3.3', 313 => '3.2' },
	'af-onformb-d11' => { 314 => '2.2' },
	'af-onformb-d12' => { 317 => '50.1' },
	'af-onoutoffocusrelease' => { 320 => 0x10, 321 => 0x10, 322 => 0x10 },
	'af-spriority' => { 131 => '0.1' },
	'af-spriorityselection' => { 304 => '1.2', 305 => '1.2', 307 => '1.2', 308 => '1.2', 312 => '0.2', 313 => '1.2', 314 => '0.2', 317 => '1.2', 318 => '1.2', 320 => 0x5, 321 => 0x5, 322 => 0x5 },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 304 => '2.1', 305 => '2.1', 307 => '78.3', 308 => '78.3', 313 => '2.1', 317 => '2.1', 318 => '78.3', 320 => 0xf, 321 => 0xf, 322 => 0xf },
	'afadjustment' => { 383 => 0x72, 392 => 0x267 },
	'afandmeteringbuttons' => { 87 => 0x701 },
	'afaperture' => { 232 => 0x5, 233 => 0x5, 237 => 0x5 },
	'afareaheight' => { 196 => [0x1a,0x34,0x50], 197 => 0x48 },
	'afareaillumination' => { 187 => 0x4b, 315 => '15.3' },
	'afareainitialheight' => { 252 => 0xbeb },
	'afareainitialwidth' => { 252 => 0xbea },
	'afareainitialxposition' => { 252 => 0xbe8 },
	'afareainitialyposition' => { 252 => 0xbe9 },
	'afareamode' => { 129 => '0.3', 183 => 0x33, 187 => 0xe, 195 => 0x0, 196 => 0x5, 197 => 0x5, 244 => 0x224, 245 => 0x224, 246 => 0x210, 247 => 0x224, 248 => 0x224, 348 => 0xf, 415 => 0x1205, 428 => [0xa,0x3a], 435 => 0x11, 436 => 0x10, 437 => 0x24, 449 => 0xb043, 475 => 0x17 },
	'afareamodesetting' => { 306 => '11.1', 309 => '0.1', 315 => '16.1', 319 => '2.1', 449 => 0x201c },
	'afareapointsize' => { 129 => '0.4' },
	'afareas' => { 324 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 87 => 0x51b },
	'afareawidth' => { 196 => [0x18,0x32,0x4e], 197 => 0x46 },
	'afareaxposition' => { 196 => [0x14,0x2e,0x4a], 197 => 0x42, 415 => 0x1203 },
	'afareaxposition1' => { 415 => 0x1201 },
	'afareayposition' => { 196 => [0x16,0x30,0x4c], 197 => 0x44, 415 => 0x1204 },
	'afareayposition1' => { 415 => 0x1202 },
	'afareazonesize' => { 129 => '0.5' },
	'afassist' => { 85 => 0x5, 93 => 0x5, 187 => 0x48, 304 => '2.5', 306 => '0.2', 309 => '0.2', 310 => '1.1', 311 => '1.1', 312 => '1.3', 313 => '2.4', 314 => '1.3', 315 => '0.2', 317 => '2.4', 319 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 87 => 0x50e, 88 => 0x4, 89 => 0x5, 90 => 0x4, 91 => 0x4, 92 => 0x5 },
	'afassistlamp' => { 348 => 0x31 },
	'afbuttonpressed' => { 437 => [0x83,0x283] },
	'afconfidence' => { 1 => 0x3d },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 359 => 0x6 },
	'afduringliveview' => { 87 => 0x511 },
	'affinea' => { 505 => 'AffineA' },
	'affineb' => { 505 => 'AffineB' },
	'affinec' => { 505 => 'AffineC' },
	'affined' => { 505 => 'AffineD' },
	'affinetune' => { 198 => 0x0, 244 => 0x6b0, 245 => 0x6c0, 246 => 0x5b0, 247 => 0x5e0, 248 => 0x5f8, 324 => 0x306 },
	'affinetuneadj' => { 198 => 0x2, 270 => 0x2d1, 271 => 0x2dc, 324 => 0x307 },
	'affinetuneadjtele' => { 198 => 0x3 },
	'affinetuneindex' => { 198 => 0x1 },
	'affinex' => { 505 => 'AffineX' },
	'affiney' => { 505 => 'AffineY' },
	'afhold' => { 359 => 0x1fd },
	'afilluminator' => { 435 => 0x29, 449 => 0xb044 },
	'afimageheight' => { 196 => [0x12,0x2c,0x48], 197 => 0x40 },
	'afimagewidth' => { 196 => [0x10,0x2a,0x46], 197 => 0x3e },
	'afintegrationtime' => { 359 => 0x7 },
	'afmeasureddepth' => { 1 => 0x38 },
	'afmicroadj' => { 428 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 432 => 0x131 },
	'afmicroadjregisteredlenses' => { 432 => '305.1' },
	'afmicroadjustment' => { 87 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 432 => 0x130 },
	'afmode' => { 116 => 0x3009, 130 => 0x1022, 183 => 0x16, 425 => 0x5 },
	'afmoderestrictions' => { 305 => '50.3', 307 => '48.3', 308 => '48.3', 317 => '48.3', 318 => '48.3' },
	'afonaelockbuttonswitch' => { 87 => 0x702 },
	'afonbutton' => { 304 => '3.1', 305 => '47.1', 320 => 0x83, 321 => 0x83, 322 => 0x83 },
	'afpoint' => { 36 => 0x13, 115 => 0x18, 183 => 0x15, 195 => 0x1, 327 => 0x308, 425 => 0x1f, 428 => [0x37,0x7], 432 => 0x19, 433 => 0x18, 434 => [0x18,0x20] },
	'afpointactivationarea' => { 86 => 0x11, 92 => 0x11 },
	'afpointareaexpansion' => { 87 => 0x508 },
	'afpointatshutterrelease' => { 428 => [0x39,0x9] },
	'afpointautoselection' => { 87 => 0x50b },
	'afpointbrightness' => { 87 => 0x50d, 304 => '2.4', 305 => '46.5', 307 => '2.2', 308 => '2.2', 317 => '2.3', 318 => '2.2' },
	'afpointdetails' => { 327 => 0x31b },
	'afpointdisplayduringfocus' => { 2 => 0x10, 87 => 0x50c },
	'afpointillumination' => { 86 => 0xa, 304 => '2.3', 305 => '46.2', 307 => '47.2', 308 => '47.2', 312 => '1.2', 313 => '2.3', 314 => '1.2', 317 => '47.2', 318 => '47.2', 319 => '2.4' },
	'afpointinfocus' => { 428 => [0x38,0x8] },
	'afpointmode' => { 364 => 0x3 },
	'afpointposition' => { 116 => 0x2021, 348 => 0x4d },
	'afpointregistration' => { 85 => 0x7 },
	'afpoints' => { 186 => 0x10 },
	'afpointsel' => { 320 => 0xb, 321 => 0xb, 322 => 0xb },
	'afpointselected' => { 187 => 0xd, 324 => 0x305, 383 => 0xe, 432 => 0x15, 433 => 0x14, 434 => [0x14,0x1c], 449 => 0x201e },
	'afpointselected2' => { 364 => 0x4 },
	'afpointselection' => { 86 => 0xb, 304 => '1.3', 305 => '1.3', 313 => '1.3', 317 => '1.3', 318 => '1.3' },
	'afpointselectionmethod' => { 87 => 0x50f, 88 => 0xc, 89 => 0xd, 92 => 0xd },
	'afpointsetting' => { 435 => 0x12, 436 => 0x11 },
	'afpointsinfocus' => { 79 => 0xe, 195 => 0x2, 196 => 0x30, 359 => 0xb, 360 => 0x4, 383 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 19 => 0x38 },
	'afpointspotmetering' => { 86 => 0xd },
	'afpointsselected' => { 196 => 0x1c, 360 => '4.1', 484 => 0x4 },
	'afpointsspecial' => { 360 => '4.2' },
	'afpointsunknown1' => { 359 => 0x0 },
	'afpointsunknown2' => { 359 => 0x2 },
	'afpointsused' => { 196 => [0xa,0x8], 197 => 0xa, 428 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 359 => 0x4 },
	'afresponse' => { 239 => 0xad },
	'afresult' => { 329 => 0x1038 },
	'afsearch' => { 324 => 0x303 },
	'afsensoractive' => { 183 => 0x1 },
	'afstable' => { 1 => 0x7 },
	'afstatus' => { 415 => 0x1200 },
	'afstatus_00_b4' => { 431 => 0x0 },
	'afstatus_01_c4' => { 431 => 0x2 },
	'afstatus_02_d4' => { 431 => 0x4 },
	'afstatus_03_e4' => { 431 => 0x6 },
	'afstatus_04_f4' => { 431 => 0x8 },
	'afstatus_05_g4' => { 431 => 0xa },
	'afstatus_06_h4' => { 431 => 0xc },
	'afstatus_07_b3' => { 431 => 0xe },
	'afstatus_08_c3' => { 431 => 0x10 },
	'afstatus_09_d3' => { 431 => 0x12 },
	'afstatus_10_e3' => { 431 => 0x14 },
	'afstatus_11_f3' => { 431 => 0x16 },
	'afstatus_12_g3' => { 431 => 0x18 },
	'afstatus_13_h3' => { 431 => 0x1a },
	'afstatus_14_b2' => { 431 => 0x1c },
	'afstatus_15_c2' => { 431 => 0x1e },
	'afstatus_16_d2' => { 431 => 0x20 },
	'afstatus_17_e2' => { 431 => 0x22 },
	'afstatus_18_f2' => { 431 => 0x24 },
	'afstatus_19_g2' => { 431 => 0x26 },
	'afstatus_20_h2' => { 431 => 0x28 },
	'afstatus_21_c1' => { 431 => 0x2a },
	'afstatus_22_d1' => { 431 => 0x2c },
	'afstatus_23_e1' => { 431 => 0x2e },
	'afstatus_24_f1' => { 431 => 0x30 },
	'afstatus_25_g1' => { 431 => 0x32 },
	'afstatus_26_a7_vertical' => { 431 => 0x34 },
	'afstatus_27_a6_vertical' => { 431 => 0x36 },
	'afstatus_28_a5_vertical' => { 431 => 0x38 },
	'afstatus_29_c7_vertical' => { 431 => 0x3a },
	'afstatus_30_c6_vertical' => { 431 => 0x3c },
	'afstatus_31_c5_vertical' => { 431 => 0x3e },
	'afstatus_32_e7_vertical' => { 431 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 431 => 0x42 },
	'afstatus_34_e5_vertical' => { 431 => 0x44 },
	'afstatus_35_g7_vertical' => { 431 => 0x46 },
	'afstatus_36_g6_vertical' => { 431 => 0x48 },
	'afstatus_37_g5_vertical' => { 431 => 0x4a },
	'afstatus_38_i7_vertical' => { 431 => 0x4c },
	'afstatus_39_i6_vertical' => { 431 => 0x4e },
	'afstatus_40_i5_vertical' => { 431 => 0x50 },
	'afstatus_41_a7' => { 431 => 0x52 },
	'afstatus_42_b7' => { 431 => 0x54 },
	'afstatus_43_c7' => { 431 => 0x56 },
	'afstatus_44_d7' => { 431 => 0x58 },
	'afstatus_45_e7' => { 431 => 0x5a },
	'afstatus_46_f7' => { 431 => 0x5c },
	'afstatus_47_g7' => { 431 => 0x5e },
	'afstatus_48_h7' => { 431 => 0x60 },
	'afstatus_49_i7' => { 431 => 0x62 },
	'afstatus_50_a6' => { 431 => 0x64 },
	'afstatus_51_b6' => { 431 => 0x66 },
	'afstatus_52_c6' => { 431 => 0x68 },
	'afstatus_53_d6' => { 431 => 0x6a },
	'afstatus_54_e6_center' => { 431 => 0x6c },
	'afstatus_55_f6' => { 431 => 0x6e },
	'afstatus_56_g6' => { 431 => 0x70 },
	'afstatus_57_h6' => { 431 => 0x72 },
	'afstatus_58_i6' => { 431 => 0x74 },
	'afstatus_59_a5' => { 431 => 0x76 },
	'afstatus_60_b5' => { 431 => 0x78 },
	'afstatus_61_c5' => { 431 => 0x7a },
	'afstatus_62_d5' => { 431 => 0x7c },
	'afstatus_63_e5' => { 431 => 0x7e },
	'afstatus_64_f5' => { 431 => 0x80 },
	'afstatus_65_g5' => { 431 => 0x82 },
	'afstatus_66_h5' => { 431 => 0x84 },
	'afstatus_67_i5' => { 431 => 0x86 },
	'afstatus_68_c11' => { 431 => 0x88 },
	'afstatus_69_d11' => { 431 => 0x8a },
	'afstatus_70_e11' => { 431 => 0x8c },
	'afstatus_71_f11' => { 431 => 0x8e },
	'afstatus_72_g11' => { 431 => 0x90 },
	'afstatus_73_b10' => { 431 => 0x92 },
	'afstatus_74_c10' => { 431 => 0x94 },
	'afstatus_75_d10' => { 431 => 0x96 },
	'afstatus_76_e10' => { 431 => 0x98 },
	'afstatus_77_f10' => { 431 => 0x9a },
	'afstatus_78_g10' => { 431 => 0x9c },
	'afstatus_79_h10' => { 431 => 0x9e },
	'afstatus_80_b9' => { 431 => 0xa0 },
	'afstatus_81_c9' => { 431 => 0xa2 },
	'afstatus_82_d9' => { 431 => 0xa4 },
	'afstatus_83_e9' => { 431 => 0xa6 },
	'afstatus_84_f9' => { 431 => 0xa8 },
	'afstatus_85_g9' => { 431 => 0xaa },
	'afstatus_86_h9' => { 431 => 0xac },
	'afstatus_87_b8' => { 431 => 0xae },
	'afstatus_88_c8' => { 431 => 0xb0 },
	'afstatus_89_d8' => { 431 => 0xb2 },
	'afstatus_90_e8' => { 431 => 0xb4 },
	'afstatus_91_f8' => { 431 => 0xb6 },
	'afstatus_92_g8' => { 431 => 0xb8 },
	'afstatus_93_h8' => { 431 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 431 => 0xbc },
	'afstatusactivesensor' => { 183 => 0x2, 428 => [0x4,0x3b], 432 => 0x1e, 433 => 0x1b, 434 => [0x1b,0x21] },
	'afstatusbottom' => { 183 => 0x8, 432 => 0x2a, 433 => 0x21, 434 => 0x21 },
	'afstatusbottom-left' => { 183 => 0x12, 433 => 0x2b, 434 => 0x2b },
	'afstatusbottom-right' => { 183 => 0x6, 433 => 0x1f, 434 => 0x1f },
	'afstatusbottomassist-left' => { 432 => 0x28 },
	'afstatusbottomassist-right' => { 432 => 0x2c },
	'afstatusbottomhorizontal' => { 429 => 0x10, 430 => 0x1c },
	'afstatusbottomvertical' => { 429 => 0x16, 430 => 0x26 },
	'afstatuscenter-10' => { 432 => 0x34 },
	'afstatuscenter-11' => { 432 => 0x36 },
	'afstatuscenter-12' => { 432 => 0x38 },
	'afstatuscenter-14' => { 432 => 0x3c },
	'afstatuscenter-7' => { 432 => 0x2e },
	'afstatuscenter-9' => { 432 => 0x32 },
	'afstatuscenter-horizontal' => { 432 => 0x30 },
	'afstatuscenter-vertical' => { 432 => 0x3a },
	'afstatuscenterf2-8' => { 432 => 0x4c },
	'afstatuscenterhorizontal' => { 183 => 0x2f, 429 => 0xc, 430 => 0x18, 433 => 0x2f, 434 => 0x2f },
	'afstatuscentervertical' => { 183 => 0xc, 429 => 0x14, 430 => 0x22, 433 => 0x25, 434 => 0x25 },
	'afstatusfarleft' => { 429 => 0x6, 432 => 0x26 },
	'afstatusfarlefthorizontal' => { 430 => 0x4 },
	'afstatusfarleftvertical' => { 430 => 0x12 },
	'afstatusfarright' => { 429 => 0x18, 432 => 0x44 },
	'afstatusfarrighthorizontal' => { 430 => 0x2c },
	'afstatusfarrightvertical' => { 430 => 0x34 },
	'afstatusleft' => { 183 => 0x2d, 429 => 0x2, 432 => 0x22, 433 => 0x2d, 434 => 0x2d },
	'afstatuslefthorizontal' => { 430 => 0x6 },
	'afstatusleftvertical' => { 430 => 0xe },
	'afstatuslower-left' => { 429 => 0x4, 432 => 0x24 },
	'afstatuslower-lefthorizontal' => { 430 => 0xa },
	'afstatuslower-leftvertical' => { 430 => 0x10 },
	'afstatuslower-middle' => { 429 => 0x22, 430 => 0x24 },
	'afstatuslower-right' => { 429 => 0x1e, 432 => 0x4a },
	'afstatuslower-righthorizontal' => { 430 => 0x32 },
	'afstatuslower-rightvertical' => { 430 => 0x3a },
	'afstatuslowerfarleft' => { 430 => 0x8 },
	'afstatuslowerfarright' => { 430 => 0x30 },
	'afstatusmiddlehorizontal' => { 183 => 0xa, 433 => 0x23, 434 => 0x23 },
	'afstatusnearleft' => { 429 => 0xe, 430 => 0x1a },
	'afstatusnearright' => { 429 => 0xa, 430 => 0x16 },
	'afstatusright' => { 183 => 0x31, 429 => 0x1c, 432 => 0x48, 433 => 0x31, 434 => 0x31 },
	'afstatusrighthorizontal' => { 430 => 0x2e },
	'afstatusrightvertical' => { 430 => 0x38 },
	'afstatustop' => { 183 => 0xe, 432 => 0x40, 433 => 0x27, 434 => 0x27 },
	'afstatustop-left' => { 183 => 0x10, 433 => 0x29, 434 => 0x29 },
	'afstatustop-right' => { 183 => 0x4, 433 => 0x1d, 434 => 0x1d },
	'afstatustopassist-left' => { 432 => 0x3e },
	'afstatustopassist-right' => { 432 => 0x42 },
	'afstatustophorizontal' => { 429 => 0x8, 430 => 0x14 },
	'afstatustopvertical' => { 429 => 0x12, 430 => 0x1e },
	'afstatusupper-left' => { 429 => 0x0, 432 => 0x20 },
	'afstatusupper-lefthorizontal' => { 430 => 0x2 },
	'afstatusupper-leftvertical' => { 430 => 0xc },
	'afstatusupper-middle' => { 429 => 0x20, 430 => 0x20 },
	'afstatusupper-right' => { 429 => 0x1a, 432 => 0x46 },
	'afstatusupper-righthorizontal' => { 430 => 0x2a },
	'afstatusupper-rightvertical' => { 430 => 0x36 },
	'afstatusupperfarleft' => { 430 => 0x0 },
	'afstatusupperfarright' => { 430 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftracking' => { 449 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 428 => 0x2 },
	'afwithshutter' => { 435 => 0x2a },
	'aggregateissuenumber' => { 530 => 'aggregateIssueNumber' },
	'aggregationtype' => { 530 => 'aggregationType' },
	'agreement' => { 533 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 141 => 0xe4e },
	'airplanemode' => { 244 => 0x722, 245 => 0x732, 246 => 0x624, 247 => 0x654, 248 => 0x6bc },
	'aiservocontinuousshooting' => { 86 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 87 => 0x519 },
	'aiservoimagepriority' => { 87 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 87 => 0x51a },
	'aiservotrackingmethod' => { 87 => 0x504 },
	'aiservotrackingsensitivity' => { 86 => 0x14, 87 => 0x502 },
	'aisubjecttrackingmode' => { 324 => 0x309 },
	'album' => { 400 => ['albm',"\xa9alb"], 402 => 'album', 408 => ['albm',"\xa9alb"], 540 => 'album' },
	'albumartist' => { 182 => 'WM/AlbumArtist', 400 => 'aART', 408 => 'albr' },
	'albumcoverurl' => { 182 => 'WM/AlbumCoverURL' },
	'albumid' => { 400 => 'plID' },
	'albumtitle' => { 182 => 'WM/AlbumTitle' },
	'alreadyapplied' => { 511 => 'AlreadyApplied', 513 => 'AlreadyApplied' },
	'alternatetitle' => { 530 => 'alternateTitle' },
	'alternatetitlea-lang' => { 530 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 530 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 530 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 200 => 0x6 },
	'alttapename' => { 540 => 'altTapeName' },
	'alttextaccessibility' => { 524 => 'AltTextAccessibility' },
	'alttimecode' => { 540 => 'altTimecode' },
	'alttimecodetimeformat' => { 540 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 540 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 540 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambientinfrared' => { 411 => 0x5c },
	'ambientlight' => { 411 => 0x5e },
	'ambienttemperature' => { 122 => 0x9400, 409 => 0x14, 410 => 0x46, 411 => 0x50, 475 => 0x4, 518 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 409 => 0x13, 410 => 0x44, 411 => 0x4e },
	'analogbalance' => { 122 => 0xc627 },
	'analogcaptureiso' => { 141 => 0x89e },
	'analogisotable' => { 141 => 0x89d },
	'androidcapturefps' => { 402 => 'com.android.capture.fps' },
	'androidversion' => { 402 => 'com.android.version' },
	'angleadj' => { 106 => 0x10003, 112 => 0x8b },
	'angleinforoll' => { 507 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 507 => 'AngleInfoYaw' },
	'anti-blur' => { 449 => 0xb04b },
	'antialiasstrength' => { 122 => 0xc632 },
	'aperturelock' => { 305 => '38.2', 307 => '38.2', 308 => '38.2', 317 => '38.2', 318 => '38.2', 320 => 0xb8, 321 => 0xb8, 322 => 0xb8 },
	'aperturemode' => { 408 => 'apmd' },
	'aperturerange' => { 87 => 0x10d },
	'apertureringuse' => { 364 => '1.4' },
	'aperturesetting' => { 187 => 0x7, 435 => 0x30, 436 => 0x29, 437 => 0x1 },
	'aperturevalue' => { 96 => 0x2, 122 => 0x9202, 329 => 0x1002, 392 => 0x401, 517 => 'ApertureValue' },
	'appinfo' => { 490 => 'AppInfo' },
	'appinfoapplication' => { 490 => [\'AppInfo','AppInfoApplication'] },
	'appinfoitemuri' => { 490 => [\'AppInfo','AppInfoItemURI'] },
	'appinfoversion' => { 490 => [\'AppInfo','AppInfoVersion'] },
	'applekeywords' => { 333 => 'AAPL:Keywords' },
	'applephotosvariationidentifier' => { 402 => 'apple.photos.variation-identifier' },
	'applestoreaccount' => { 400 => 'apID' },
	'applestoreaccounttype' => { 400 => 'akID' },
	'applestorecatalogid' => { 400 => 'cnID' },
	'applestorecountry' => { 400 => 'sfID' },
	'applicationkeystring' => { 141 => 0x400 },
	'applicationnotes' => { 122 => 0x2bc, 353 => 0x2bc },
	'applicationrecordversion' => { 134 => 0x0 },
	'applyautomatically' => { 338 => 'ApplyAutomatically' },
	'applyshootingmeteringmode' => { 87 => 0x10e },
	'approved' => { 519 => 'Approved' },
	'approvedby' => { 519 => 'ApprovedBy' },
	'approximatefnumber' => { 343 => 0x313, 350 => 0x3406 },
	'approximatefocusdistance' => { 508 => 'ApproximateFocusDistance' },
	'appversion' => { 523 => 'AppVersion' },
	'aps-csizecapture' => { 468 => 0x114, 469 => [0x114,0x1eb,0x1ee,0x21a,0x21c] },
	'aquahsl' => { 106 => 0x20914 },
	'armidentifier' => { 135 => 0x78 },
	'armversion' => { 135 => 0x7a },
	'arranger' => { 400 => "\xa9arg", 408 => "\xa9arg" },
	'arrangerkeywords' => { 408 => "\xa9ark" },
	'artdirector' => { 400 => "\xa9ard" },
	'artfilter' => { 324 => 0x529 },
	'artfiltereffect' => { 324 => 0x52f },
	'artist' => { 122 => 0x13b, 337 => 'Artist', 353 => 0x13b, 383 => 0x22e, 400 => "\xa9ART", 402 => 'artist', 408 => "\xa9ART", 536 => 'Artist', 540 => 'artist' },
	'artistid' => { 400 => 'atID' },
	'artmode' => { 116 => 0x301b },
	'artmodeparameters' => { 116 => 0x310b },
	'artwork' => { 402 => 'artwork' },
	'artworkcircadatecreated' => { 525 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 525 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 525 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 525 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 525 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 525 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 525 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 525 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 525 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 525 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 525 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 525 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 525 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 525 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 525 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 525 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 525 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 525 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 328 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 328 => 0x1112, 383 => 0x80, 435 => 0x55, 436 => 0x55, 437 => 0xa, 462 => [0x192c,0x1a88], 463 => 0x192c, 464 => 0x1958, 465 => 0x192c, 466 => 0x188c },
	'assetid' => { 501 => 'AssetID' },
	'asshoticcprofile' => { 122 => 0xc68f },
	'asshotneutral' => { 122 => 0xc628 },
	'asshotpreprofilematrix' => { 122 => 0xc690 },
	'asshotprofilename' => { 122 => 0xc6f6 },
	'asshotwhitexy' => { 122 => 0xc629 },
	'assignbktbutton' => { 304 => '4.2', 305 => '16.1', 307 => '16.1', 308 => '16.1', 317 => '16.1', 318 => '16.1' },
	'assignfuncbutton' => { 87 => 0x70b },
	'assignmb-d17af-onbutton' => { 308 => '79.1' },
	'assignmb-d17funcbutton' => { 308 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 308 => '68.1' },
	'assignmb-d18af-onbutton' => { 318 => '79.1' },
	'assignmb-d18funcbutton' => { 318 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 318 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 307 => '75.1', 308 => '75.1', 318 => '75.1' },
	'assignmoviefunc2button' => { 307 => '82.1', 308 => '82.1', 318 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 307 => '75.2', 308 => '75.2', 318 => '75.2' },
	'assignmovierecordbutton' => { 305 => '43.2', 317 => '45.1', 320 => 0x9b, 321 => 0x9b, 322 => 0x9b },
	'assignmovierecordbuttonplusdials' => { 307 => '45.1', 308 => '45.1', 318 => '45.1' },
	'assignmoviesubselector' => { 307 => '74.1', 308 => '74.1', 318 => '74.1' },
	'assignmoviesubselectorplusdials' => { 307 => '76.1', 308 => '76.1', 318 => '76.1' },
	'assignremotefnbutton' => { 305 => '54.1', 317 => '51.1' },
	'assistbuttonfunction' => { 85 => 0xd },
	'atcaptureusercrop' => { 141 => 0x943 },
	'attributionname' => { 509 => 'attributionName' },
	'attributionurl' => { 509 => 'attributionURL' },
	'audio' => { 348 => 0x20 },
	'audiobitrate' => { 69 => 0x6c, 525 => 'audioBitRate' },
	'audiobitratemode' => { 525 => 'audioBitRateMode' },
	'audiobitspersample' => { 525 => 'audioBitsPerSample' },
	'audiobutton' => { 321 => 0x17b, 322 => 0x193 },
	'audiobuttonplaybackmode' => { 321 => 0x1b9, 322 => 0x1d1 },
	'audiochannelcount' => { 525 => 'audioChannelCount' },
	'audiochannels' => { 69 => 0x70 },
	'audiochanneltype' => { 540 => 'audioChannelType' },
	'audiocompression' => { 87 => 0x816, 158 => 'Compression' },
	'audiocompressor' => { 540 => 'audioCompressor' },
	'audiodata' => { 493 => 'Data' },
	'audioduration' => { 134 => 0x99 },
	'audiogain' => { 402 => 'player.movie.audio.gain' },
	'audiomimetype' => { 493 => 'Mime' },
	'audiomoddate' => { 540 => 'audioModDate' },
	'audiooutcue' => { 134 => 0x9a },
	'audiosamplerate' => { 69 => 0x6e, 540 => 'audioSampleRate' },
	'audiosampletype' => { 540 => 'audioSampleType' },
	'audiosamplingrate' => { 134 => 0x97 },
	'audiosamplingresolution' => { 134 => 0x98 },
	'audiotype' => { 134 => 0x96 },
	'author' => { 160 => 'Author', 333 => 'Author', 337 => 'Author', 399 => 'Author', 400 => ['auth',"\xa9aut"], 402 => 'author', 408 => 'auth', 506 => 'author', 527 => 'Author', 538 => 'Author' },
	'authorsposition' => { 528 => 'AuthorsPosition' },
	'authorurl' => { 182 => 'WM/AuthorURL' },
	'autoafpointcolortracking' => { 87 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 374 => '0.1' },
	'autobracket' => { 425 => 0x19 },
	'autobracketing' => { 130 => 0x1100, 383 => 0x18, 415 => 0x1007 },
	'autobracketingmode' => { 316 => '12.3' },
	'autobracketingset' => { 316 => '12.1' },
	'autobracketmodem' => { 304 => '21.2', 305 => '13.3', 307 => '13.2', 308 => '13.2', 313 => '26.2', 317 => '13.3', 318 => '13.2', 320 => 0x5f, 321 => 0x5f, 322 => 0x5f },
	'autobracketorder' => { 187 => 0x43, 304 => '21.3', 305 => '13.2', 307 => '13.1', 308 => '13.1', 313 => '26.3', 314 => '12.2', 315 => '2.2', 316 => '12.2', 317 => '13.2', 318 => '13.1', 319 => '13.2', 320 => 0x61, 321 => 0x61, 322 => 0x61 },
	'autobracketset' => { 304 => '21.1', 305 => '13.1', 309 => '11.1', 310 => '12.1', 311 => '12.1', 313 => '26.1', 314 => '12.1', 315 => '2.1', 317 => '13.1', 319 => '13.1' },
	'autobrightness' => { 511 => 'AutoBrightness', 513 => 'AutoBrightness' },
	'autocapturecriteria' => { 199 => 0x1 },
	'autocapturecriteriamotiondirection' => { 199 => 0x5f },
	'autocapturecriteriamotionsize' => { 199 => 0x64 },
	'autocapturecriteriamotionspeed' => { 199 => 0x63 },
	'autocapturecriteriasubjectsize' => { 199 => 0x69 },
	'autocapturecriteriasubjecttype' => { 199 => 0x6a },
	'autocapturedframe' => { 199 => 0x0 },
	'autocapturedistancefar' => { 199 => 0x4a },
	'autocapturedistancenear' => { 199 => 0x4e },
	'autocapturepreset' => { 248 => 0x746 },
	'autocapturerecordingtime' => { 199 => 0x37 },
	'autocapturewaittime' => { 199 => 0x38 },
	'autocontrast' => { 511 => 'AutoContrast', 513 => 'AutoContrast' },
	'autodistortioncontrol' => { 213 => 0x4, 243 => 0x143 },
	'autodynamicrange' => { 130 => 0x140b },
	'autoexposure' => { 511 => 'AutoExposure', 513 => 'AutoExposure' },
	'autoexposurebracketing' => { 79 => 0x10 },
	'autoflashisosensitivity' => { 307 => '38.5', 308 => '38.5', 318 => '38.5', 320 => 0x5b, 321 => 0x5b, 322 => 0x5b },
	'autofocus' => { 327 => 0x209 },
	'autofocusmoderestrictions' => { 320 => 0x107, 321 => 0x107, 322 => 0x11d },
	'autofp' => { 315 => '7.3', 319 => '31.4' },
	'autoiso' => { 79 => 0x1, 116 => 0x3008, 244 => 0x152, 245 => 0x152, 246 => 0x142, 247 => 0x156, 248 => 0x156, 306 => '1.1', 315 => '1.1' },
	'autoisomax' => { 306 => '1.2', 315 => '1.2' },
	'autoisominshutterspeed' => { 306 => '1.3', 315 => '1.3' },
	'autolateralca' => { 511 => 'AutoLateralCA', 513 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 16 => 0xbe, 17 => 0xbf, 20 => 0xbf, 64 => 0x2, 87 => 0x204, 106 => 0x20500, 112 => 0x6f },
	'autolightingoptimizeron' => { 106 => '0x20500.0', 112 => 0x6e },
	'autoportraitframed' => { 449 => 0x2016 },
	'autoredeye' => { 297 => 0xfe28a44f },
	'autorotate' => { 79 => 0x1b },
	'autoshadows' => { 511 => 'AutoShadows', 513 => 'AutoShadows' },
	'autotone' => { 511 => 'AutoTone', 513 => 'AutoTone' },
	'autotonedigest' => { 511 => 'AutoToneDigest', 513 => 'AutoToneDigest' },
	'autotonedigestnosat' => { 511 => 'AutoToneDigestNoSat', 513 => 'AutoToneDigestNoSat' },
	'autowhiteversion' => { 511 => 'AutoWhiteVersion', 513 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 239 => 0x82 },
	'avaperturesetting' => { 364 => 0x13 },
	'averageblacklevel' => { 47 => 0xe7, 49 => 0xfb, 50 => 0x114, 51 => 0x146 },
	'averagelv' => { 190 => 0x38 },
	'avsettingwithoutlens' => { 87 => 0x707 },
	'azimuth' => { 168 => 'Azimuth' },
	'babyage' => { 348 => [0x8010,0x33] },
	'babyname' => { 348 => 0x66 },
	'backgroundalpha' => { 535 => 'bgalpha' },
	'balance' => { 402 => 'player.movie.audio.balance' },
	'baseexposurecompensation' => { 364 => 0x15 },
	'baseiso' => { 79 => 0x2, 100 => 0x101c, 141 => 0x903, 350 => 0x312a, 481 => 0x6 },
	'baseisodaylight' => { 141 => 0x910 },
	'baseisoflash' => { 141 => 0x913 },
	'baseisofluorescent' => { 141 => 0x912 },
	'baseisotungsten' => { 141 => 0x911 },
	'baselineexposure' => { 122 => 0xc62a },
	'baselineexposureoffset' => { 122 => 0xc7a5 },
	'baselinenoise' => { 122 => 0xc62b },
	'baselinesharpness' => { 122 => 0xc62c },
	'baserenditionishdr' => { 522 => 'BaseRenditionIsHDR' },
	'baseurl' => { 538 => 'BaseURL' },
	'bass' => { 402 => 'player.movie.audio.bass' },
	'batterylevel' => { 348 => 0x38, 435 => 0x51, 439 => 0xc, 440 => 0x4, 441 => 0x4, 482 => 0x7, 483 => 0x5 },
	'batterylevel2' => { 483 => 0x7 },
	'batterylevelgrip1' => { 482 => 0x6 },
	'batterylevelgrip2' => { 482 => 0x8 },
	'batteryorder' => { 304 => '12.5', 313 => '13.2', 314 => '2.1', 317 => '3.1' },
	'batterystate' => { 187 => 0x60, 435 => 0x50, 441 => 0x14 },
	'batterytemperature' => { 439 => 0x1, 441 => 0x2, 482 => 0x5 },
	'batterytype' => { 66 => 0x38, 411 => 0x66 },
	'batteryunknown' => { 439 => 0x2, 441 => 0x0 },
	'batteryvoltage' => { 141 => 0x408, 409 => 0x2a, 410 => 0x49, 411 => 0x62, 439 => 0x8 },
	'batteryvoltage1' => { 441 => 0x6 },
	'batteryvoltage2' => { 441 => 0x8 },
	'batteryvoltageavg' => { 411 => 0x64 },
	'bayergreensplit' => { 122 => 0xc62d },
	'bayerpattern' => { 140 => 0xf902, 191 => 0x17 },
	'beatsperminute' => { 400 => 'tmpo' },
	'beatspliceparams' => { 540 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 540 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 540 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 540 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 540 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 540 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 304 => '13.1', 305 => '5.4', 306 => '0.1', 309 => '2.1', 310 => '3.1', 311 => '3.1', 313 => '10.1', 315 => '0.1', 317 => '5.5', 319 => '4.1' },
	'beeppitch' => { 314 => '3.1' },
	'beepvolume' => { 314 => '4.5' },
	'bestqualityscale' => { 122 => 0xc65c },
	'bestshotmode' => { 116 => 0x3007 },
	'bitdepth' => { 165 => 'BitDepth', 191 => 0x11, 263 => 0x41 },
	'bitspercomponent' => { 136 => 0x87 },
	'bitspersample' => { 122 => 0x102, 353 => 0xa, 536 => 'BitsPerSample' },
	'blackacquirerows' => { 141 => 0x18ba },
	'blacklevel' => { 122 => [0x7310,0xc61a], 210 => 0x20, 239 => 0x3d, 329 => [0x401,0x1012], 392 => 0x21d, 456 => [0x7300,0x7310] },
	'blacklevel2' => { 328 => 0x600, 332 => 0x600 },
	'blacklevelblue' => { 353 => 0x1e },
	'blacklevelbottom' => { 141 => 0x3f0 },
	'blackleveldata' => { 392 => 0x223 },
	'blackleveldeltah' => { 122 => 0xc61b },
	'blackleveldeltav' => { 122 => 0xc61c },
	'blacklevelgreen' => { 353 => 0x1d },
	'blacklevelred' => { 353 => 0x1c },
	'blacklevelrepeatdim' => { 122 => 0xc619 },
	'blacklevelrough' => { 141 => 0x40e },
	'blacklevelroughafter' => { 141 => 0x416 },
	'blacklevels' => { 37 => 0x1d },
	'blackleveltop' => { 141 => 0x3ef },
	'blackpoint' => { 383 => 0x200 },
	'blacks2012' => { 511 => 'Blacks2012', 513 => 'Blacks2012' },
	'blacksadj' => { 486 => 0x9018 },
	'bleachbypasstoning' => { 383 => 0x7f },
	'blockshotafresponse' => { 307 => '1.5', 308 => '1.5', 318 => '1.5', 320 => 0x7, 321 => 0x7, 322 => 0x7 },
	'blogtitle' => { 530 => 'blogTitle' },
	'blogurl' => { 530 => 'blogURL' },
	'bluebalance' => { 329 => 0x1018, 353 => 0x12, 383 => 0x1b },
	'bluecurvelimits' => { 111 => 0x1fe },
	'bluecurvepoints' => { 110 => 0x79, 111 => 0x1d4 },
	'bluehsl' => { 106 => 0x20915 },
	'bluehue' => { 511 => 'BlueHue', 513 => 'BlueHue' },
	'bluesaturation' => { 511 => 'BlueSaturation', 513 => 'BlueSaturation' },
	'bluratinfinity' => { 497 => 'BlurAtInfinity' },
	'blurcontrol' => { 383 => 0x82 },
	'blurwarning' => { 130 => 0x1300 },
	'bodybatteryadload' => { 362 => 0x3 },
	'bodybatteryadnoload' => { 362 => 0x2 },
	'bodybatterystate' => { 362 => '1.1' },
	'bodybatteryvoltage1' => { 362 => 0x2 },
	'bodybatteryvoltage2' => { 362 => 0x4 },
	'bodybatteryvoltage3' => { 362 => 0x6 },
	'bodybatteryvoltage4' => { 362 => 0x8 },
	'bodyfirmware' => { 416 => 0x0 },
	'bodyfirmwareversion' => { 325 => 0x104, 326 => 0x100, 329 => 0x104 },
	'bodyserialnumber' => { 416 => 0x10 },
	'bookedition' => { 530 => 'bookEdition' },
	'bootloaderversion' => { 410 => 0x26 },
	'bracketbutton' => { 245 => 0x808, 248 => 0x80c },
	'bracketbuttonplaybackmode' => { 245 => 0x810, 248 => 0x816 },
	'bracketincrement' => { 244 => 0x22e, 245 => 0x22e, 246 => 0x21a, 247 => 0x22e, 248 => 0x22e },
	'bracketmode' => { 59 => 0x3 },
	'bracketprogram' => { 244 => 0x22c, 245 => 0x22c, 246 => 0x218, 247 => 0x22c, 248 => 0x22c },
	'bracketsequence' => { 116 => 0x301d },
	'bracketset' => { 244 => 0x22a, 245 => 0x22a, 246 => 0x216, 247 => 0x22a, 248 => 0x22a },
	'bracketsettings' => { 348 => 0x45 },
	'bracketshotnumber' => { 59 => 0x5, 364 => 0x9, 446 => 0x2b },
	'bracketshotnumber2' => { 446 => 0x2d },
	'bracketstep' => { 184 => 0xe },
	'bracketvalue' => { 59 => 0x4 },
	'brightness' => { 122 => 0xfe53, 159 => 'Brightness', 179 => 'Brightness', 184 => 0x2c, 255 => 0x34, 256 => 0x39, 257 => 0x41, 402 => 'player.movie.visual.brightness', 409 => 0x25, 411 => 0x54, 435 => 0x22, 449 => 0x2007, 511 => 'Brightness', 513 => 'Brightness' },
	'brightnessadj' => { 111 => 0x114, 290 => 0x0, 300 => 0x2d, 486 => 0x8018 },
	'brightnessvalue' => { 122 => 0x9203, 190 => [0x691,0x49c3], 329 => 0x1003, 454 => 0x1e, 458 => 0x1140, 459 => 0x1140, 460 => 0x111c, 461 => 0x1198, 462 => 0x1174, 463 => 0x102c, 464 => 0x224, 465 => 0x224, 466 => 0x219, 517 => 'BrightnessValue' },
	'buildnumber' => { 194 => 0x5500 },
	'bulbduration' => { 79 => 0x18 },
	'burstcount' => { 141 => 0x40d },
	'burstgroupid' => { 241 => 0x4 },
	'burstid' => { 494 => 'BurstID' },
	'burstmode' => { 143 => 0xa, 348 => 0x2a },
	'burstmode2' => { 143 => 0x18 },
	'burstprimary' => { 494 => 'BurstPrimary' },
	'burstshot' => { 425 => 0x34 },
	'burstspeed' => { 348 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 87 => 0x70a },
	'bwadjustment' => { 130 => 0x1049 },
	'bwfilter' => { 184 => 0x2a, 192 => 0x39 },
	'bwmagentagreen' => { 130 => 0x104b },
	'bwmode' => { 329 => 0x203 },
	'by-line' => { 134 => 0x50 },
	'by-linetitle' => { 134 => 0x55 },
	'bytecount' => { 530 => 'byteCount' },
	'c14configuration' => { 141 => 0x1964 },
	'cacheversion' => { 122 => 0xc7aa },
	'calibratedfocallength' => { 119 => 'CalibratedFocalLength' },
	'calibratedopticalcenterx' => { 119 => 'CalibratedOpticalCenterX' },
	'calibratedopticalcentery' => { 119 => 'CalibratedOpticalCenterY' },
	'calibration' => { 425 => [0x24,0x30] },
	'calibrationhistory' => { 141 => 0x9c9 },
	'calibrationilluminant1' => { 122 => 0xc65a },
	'calibrationilluminant2' => { 122 => 0xc65b },
	'calibrationilluminant3' => { 122 => 0xcd31 },
	'calibrationversion' => { 141 => 0x9c6 },
	'callforimage' => { 501 => 'CallForImage' },
	'camera' => { 490 => [\'Cameras','CamerasCamera'] },
	'cameraangle' => { 408 => 'angl', 540 => 'cameraAngle' },
	'cameraappinfo' => { 490 => [\'Cameras','CamerasCameraAppInfo'] },
	'cameraappinfoapplication' => { 490 => [\'Cameras','CamerasCameraAppInfoApplication'] },
	'cameraappinfoitemuri' => { 490 => [\'Cameras','CamerasCameraAppInfoItemURI'] },
	'cameraappinfoversion' => { 490 => [\'Cameras','CamerasCameraAppInfoVersion'] },
	'cameraburstid' => { 495 => 'CameraBurstID' },
	'cameracalibration' => { 425 => 0x11f },
	'cameracalibration1' => { 122 => 0xc623 },
	'cameracalibration2' => { 122 => 0xc624 },
	'cameracalibration3' => { 122 => 0xcd32 },
	'cameracalibrationsig' => { 122 => 0xc6f3 },
	'cameracolorcalibration01' => { 38 => 0x0, 39 => 0x0 },
	'cameracolorcalibration02' => { 38 => 0x4, 39 => 0x5 },
	'cameracolorcalibration03' => { 38 => 0x8, 39 => 0xa },
	'cameracolorcalibration04' => { 38 => 0xc, 39 => 0xf },
	'cameracolorcalibration05' => { 38 => 0x10, 39 => 0x14 },
	'cameracolorcalibration06' => { 38 => 0x14, 39 => 0x19 },
	'cameracolorcalibration07' => { 38 => 0x18, 39 => 0x1e },
	'cameracolorcalibration08' => { 38 => 0x1c, 39 => 0x23 },
	'cameracolorcalibration09' => { 38 => 0x20, 39 => 0x28 },
	'cameracolorcalibration10' => { 38 => 0x24, 39 => 0x2d },
	'cameracolorcalibration11' => { 38 => 0x28, 39 => 0x32 },
	'cameracolorcalibration12' => { 38 => 0x2c, 39 => 0x37 },
	'cameracolorcalibration13' => { 38 => 0x30, 39 => 0x3c },
	'cameracolorcalibration14' => { 38 => 0x34, 39 => 0x41 },
	'cameracolorcalibration15' => { 38 => 0x38, 39 => 0x46 },
	'cameradepthmap' => { 490 => [\'Cameras','CamerasCameraDepthMap'] },
	'cameradepthmapconfidenceuri' => { 490 => [\'Cameras','CamerasCameraDepthMapConfidenceURI'] },
	'cameradepthmapdepthuri' => { 490 => [\'Cameras','CamerasCameraDepthMapDepthURI'] },
	'cameradepthmapfar' => { 490 => [\'Cameras','CamerasCameraDepthMapFar'] },
	'cameradepthmapfocaltable' => { 490 => [\'Cameras','CamerasCameraDepthMapFocalTable'] },
	'cameradepthmapfocaltableentrycount' => { 490 => [\'Cameras','CamerasCameraDepthMapFocalTableEntryCount'] },
	'cameradepthmapformat' => { 490 => [\'Cameras','CamerasCameraDepthMapFormat'] },
	'cameradepthmapitemsemantic' => { 490 => [\'Cameras','CamerasCameraDepthMapItemSemantic'] },
	'cameradepthmapmeasuretype' => { 490 => [\'Cameras','CamerasCameraDepthMapMeasureType'] },
	'cameradepthmapnear' => { 490 => [\'Cameras','CamerasCameraDepthMapNear'] },
	'cameradepthmapsoftware' => { 490 => [\'Cameras','CamerasCameraDepthMapSoftware'] },
	'cameradepthmapunits' => { 490 => [\'Cameras','CamerasCameraDepthMapUnits'] },
	'cameradirection' => { 402 => 'direction.facing' },
	'camerae-mountversion' => { 485 => 0xb },
	'cameraelevationangle' => { 122 => 0x9405, 518 => 'CameraElevationAngle' },
	'camerafilename' => { 501 => 'CameraFilename' },
	'camerafirmware' => { 122 => 0xa439 },
	'cameraid' => { 329 => 0x209, 408 => 'cmid', 424 => 0x209 },
	'cameraidentifier' => { 402 => 'camera.identifier' },
	'cameraimage' => { 490 => [\'Cameras','CamerasCameraImage'] },
	'cameraimageitemsemantic' => { 490 => [\'Cameras','CamerasCameraImageItemSemantic'] },
	'cameraimageitemuri' => { 490 => [\'Cameras','CamerasCameraImageItemURI'] },
	'cameraimagingmodel' => { 490 => [\'Cameras','CamerasCameraImagingModel'] },
	'cameraimagingmodeldistortion' => { 490 => [\'Cameras','CamerasCameraImagingModelDistortion'] },
	'cameraimagingmodeldistortioncount' => { 490 => [\'Cameras','CamerasCameraImagingModelDistortionCount'] },
	'cameraimagingmodelfocallengthx' => { 490 => [\'Cameras','CamerasCameraImagingModelFocalLengthX'] },
	'cameraimagingmodelfocallengthy' => { 490 => [\'Cameras','CamerasCameraImagingModelFocalLengthY'] },
	'cameraimagingmodelimageheight' => { 490 => [\'Cameras','CamerasCameraImagingModelImageHeight'] },
	'cameraimagingmodelimagewidth' => { 490 => [\'Cameras','CamerasCameraImagingModelImageWidth'] },
	'cameraimagingmodelpixelaspectratio' => { 490 => [\'Cameras','CamerasCameraImagingModelPixelAspectRatio'] },
	'cameraimagingmodelprincipalpointx' => { 490 => [\'Cameras','CamerasCameraImagingModelPrincipalPointX'] },
	'cameraimagingmodelprincipalpointy' => { 490 => [\'Cameras','CamerasCameraImagingModelPrincipalPointY'] },
	'cameraimagingmodelskew' => { 490 => [\'Cameras','CamerasCameraImagingModelSkew'] },
	'cameraiso' => { 36 => 0x10 },
	'cameralabel' => { 122 => 0xc7a1, 540 => 'cameraLabel' },
	'cameralightestimate' => { 490 => [\'Cameras','CamerasCameraLightEstimate'] },
	'cameralightestimatecolorcorrectionb' => { 490 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionB'] },
	'cameralightestimatecolorcorrectiong' => { 490 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionG'] },
	'cameralightestimatecolorcorrectionr' => { 490 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionR'] },
	'cameralightestimatepixelintensity' => { 490 => [\'Cameras','CamerasCameraLightEstimatePixelIntensity'] },
	'cameramakemodel' => { 501 => 'CameraMakeModel' },
	'cameramodel' => { 392 => 0x410, 540 => 'cameraModel' },
	'cameramodelid' => { 179 => 'CameraModelID' },
	'cameramodelrestriction' => { 511 => 'CameraModelRestriction', 513 => 'CameraModelRestriction' },
	'cameramotion' => { 402 => 'direction.motion' },
	'cameramove' => { 540 => 'cameraMove' },
	'cameraorientation' => { 7 => 0x30, 9 => 0x7d, 11 => 0x30, 13 => 0x35, 14 => 0x30, 15 => 0x30, 16 => 0x31, 17 => 0x31, 18 => 0x35, 19 => 0x27, 20 => 0x31, 21 => 0x7d, 22 => 0x38, 23 => [0x36,0x3a], 24 => 0x7d, 25 => 0x83, 26 => 0x84, 27 => 0x96, 28 => 0x35, 29 => 0x96, 348 => 0x8f, 387 => 0x1, 392 => 0x100, 441 => [0x16,0x18], 472 => 0x28, 473 => 0x24, 474 => 0x29 },
	'cameraowner' => { 144 => 0xc353 },
	'cameraparameters' => { 329 => 0x2050 },
	'camerapicturestyle' => { 28 => 0xaf },
	'camerapitch' => { 118 => 0x9, 408 => "\xa9gpt" },
	'camerapointcloud' => { 490 => [\'Cameras','CamerasCameraPointCloud'] },
	'camerapointcloudmetric' => { 490 => [\'Cameras','CamerasCameraPointCloudMetric'] },
	'camerapointcloudpointcloud' => { 490 => [\'Cameras','CamerasCameraPointCloudPointCloud'] },
	'camerapointcloudpoints' => { 490 => [\'Cameras','CamerasCameraPointCloudPoints'] },
	'camerapose' => { 490 => [\'Cameras','CamerasCameraPose'] },
	'cameraposepositionx' => { 490 => [\'Cameras','CamerasCameraPosePositionX'] },
	'cameraposepositiony' => { 490 => [\'Cameras','CamerasCameraPosePositionY'] },
	'cameraposepositionz' => { 490 => [\'Cameras','CamerasCameraPosePositionZ'] },
	'cameraposerotationw' => { 490 => [\'Cameras','CamerasCameraPoseRotationW'] },
	'cameraposerotationx' => { 490 => [\'Cameras','CamerasCameraPoseRotationX'] },
	'cameraposerotationy' => { 490 => [\'Cameras','CamerasCameraPoseRotationY'] },
	'cameraposerotationz' => { 490 => [\'Cameras','CamerasCameraPoseRotationZ'] },
	'cameraposetimestamp' => { 490 => [\'Cameras','CamerasCameraPoseTimestamp'] },
	'cameraprofile' => { 511 => 'CameraProfile', 513 => 'CameraProfile' },
	'cameraprofiledigest' => { 511 => 'CameraProfileDigest', 513 => 'CameraProfileDigest' },
	'cameraprofiles' => { 528 => 'CameraProfiles' },
	'cameraprofilesaperturevalue' => { 528 => [\'CameraProfiles','CameraProfilesApertureValue'] },
	'cameraprofilesauthor' => { 528 => [\'CameraProfiles','CameraProfilesAuthor'] },
	'cameraprofilesautoscale' => { 528 => [\'CameraProfiles','CameraProfilesAutoScale'] },
	'cameraprofilescameraprettyname' => { 528 => [\'CameraProfiles','CameraProfilesCameraPrettyName'] },
	'cameraprofilescamerarawprofile' => { 528 => [\'CameraProfiles','CameraProfilesCameraRawProfile'] },
	'cameraprofilesfocallength' => { 528 => [\'CameraProfiles','CameraProfilesFocalLength'] },
	'cameraprofilesfocusdistance' => { 528 => [\'CameraProfiles','CameraProfilesFocusDistance'] },
	'cameraprofileslens' => { 528 => [\'CameraProfiles','CameraProfilesLens'] },
	'cameraprofileslensprettyname' => { 528 => [\'CameraProfiles','CameraProfilesLensPrettyName'] },
	'cameraprofilesmake' => { 528 => [\'CameraProfiles','CameraProfilesMake'] },
	'cameraprofilesmodel' => { 528 => [\'CameraProfiles','CameraProfilesModel'] },
	'cameraprofilesperspectivemodel' => { 528 => [\'CameraProfiles','CameraProfilesPerspectiveModel'] },
	'cameraprofilesperspectivemodelimagexcenter' => { 528 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageXCenter'] },
	'cameraprofilesperspectivemodelimageycenter' => { 528 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageYCenter'] },
	'cameraprofilesperspectivemodelradialdistortparam1' => { 528 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam1'] },
	'cameraprofilesperspectivemodelradialdistortparam2' => { 528 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam2'] },
	'cameraprofilesperspectivemodelradialdistortparam3' => { 528 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam3'] },
	'cameraprofilesperspectivemodelscalefactor' => { 528 => [\'CameraProfiles','CameraProfilesPerspectiveModelScaleFactor'] },
	'cameraprofilesperspectivemodelversion' => { 528 => [\'CameraProfiles','CameraProfilesPerspectiveModelVersion'] },
	'cameraprofilesprofilename' => { 528 => [\'CameraProfiles','CameraProfilesProfileName'] },
	'cameraprofilessensorformatfactor' => { 528 => [\'CameraProfiles','CameraProfilesSensorFormatFactor'] },
	'cameraprofilesuniquecameramodel' => { 528 => [\'CameraProfiles','CameraProfilesUniqueCameraModel'] },
	'camerarawcolortone' => { 112 => 0xe1 },
	'camerarawcontrast' => { 112 => 0xe3 },
	'camerarawhighlightpoint' => { 112 => 0xe6 },
	'camerarawlinear' => { 112 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 112 => 0xe8 },
	'camerarawoutputshadowpoint' => { 112 => 0xe9 },
	'camerarawsaturation' => { 112 => 0xe2 },
	'camerarawshadowpoint' => { 112 => 0xe7 },
	'camerarawsharpness' => { 112 => 0xe5 },
	'cameraroll' => { 118 => 0xb, 408 => "\xa9grl" },
	'cameras' => { 490 => 'Cameras' },
	'cameraserialnumber' => { 122 => 0xc62f, 181 => 'CameraSerialNumber', 501 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 324 => 0x0 },
	'cameratemperature' => { 7 => 0x18, 9 => 0x1b, 11 => 0x18, 13 => 0x19, 14 => 0x18, 15 => 0x18, 16 => 0x19, 17 => 0x19, 18 => 0x19, 19 => 0x17, 20 => 0x19, 21 => 0x1b, 22 => 0x19, 23 => 0x19, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x1b, 28 => 0x19, 29 => 0x1b, 31 => [0x87,0x91], 32 => [0x99,0x9f,0xa4,0xa8,0x105], 35 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 79 => 0xc, 141 => 0x406, 328 => 0x1306, 343 => 0x320, 350 => 0x3402, 383 => 0x47, 422 => 0x43, 476 => 0x5 },
	'cameratemperature4' => { 388 => 0x14 },
	'cameratemperature5' => { 388 => 0x16 },
	'cameratemperaturerangemax' => { 124 => 0x5 },
	'cameratemperaturerangemin' => { 124 => 0x6 },
	'cameratrait' => { 490 => [\'Cameras','CamerasCameraTrait'] },
	'cameratype' => { 79 => 0x1a, 329 => 0x207 },
	'cameratype2' => { 325 => 0x100 },
	'cameravendorinfo' => { 490 => [\'Cameras','CamerasCameraVendorInfo'] },
	'cameravendorinfomanufacturer' => { 490 => [\'Cameras','CamerasCameraVendorInfoManufacturer'] },
	'cameravendorinfomodel' => { 490 => [\'Cameras','CamerasCameraVendorInfoModel'] },
	'cameravendorinfonotes' => { 490 => [\'Cameras','CamerasCameraVendorInfoNotes'] },
	'camerayaw' => { 118 => 0xa, 408 => "\xa9gyw" },
	'camreverse' => { 119 => 'CamReverse' },
	'canondr4' => { 123 => 'CanonDR4' },
	'canonexposuremode' => { 36 => 0x14 },
	'canonfiledescription' => { 100 => 0x805 },
	'canonfilelength' => { 66 => 0xe },
	'canonfirmwareversion' => { 66 => 0x7, 100 => 0x80b },
	'canonflashinfo' => { 100 => 0x1028 },
	'canonflashmode' => { 36 => 0x4 },
	'canonimagesize' => { 10 => 0x39, 36 => 0xa },
	'canonimagetype' => { 66 => 0x6, 100 => 0x815 },
	'canonlogversion' => { 65 => 0xb },
	'canonmodelid' => { 66 => 0x10, 100 => 0x1834 },
	'canonvrd' => { 123 => 'CanonVRD' },
	'caption' => { 506 => 'caption' },
	'caption-abstract' => { 134 => 0x78 },
	'captionsauthornames' => { 516 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 516 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 528 => 'CaptionWriter' },
	'captureframerate' => { 116 => 0x4001 },
	'captureheightnormal' => { 141 => 0x1839 },
	'capturelook' => { 141 => 0xc48 },
	'capturemode' => { 402 => 'com.apple.photos.captureMode' },
	'capturesoftware' => { 499 => 'CaptureSoftware' },
	'capturewidthnormal' => { 141 => 0x1838 },
	'capturewidthtest' => { 141 => 0x1842 },
	'cardshutterlock' => { 187 => 0x49 },
	'casioimagesize' => { 116 => 0x9 },
	'catalogsets' => { 134 => 0xff, 492 => 'CatalogSets', 504 => 'CatalogSets' },
	'categories' => { 66 => 0x23, 506 => 'categories' },
	'category' => { 134 => 0xf, 182 => 'WM/Category', 323 => 0x30, 400 => 'catg', 528 => 'Category' },
	'cbcrgain' => { 422 => 0xa036 },
	'cbcrgaindefault' => { 422 => 0xa035 },
	'cbcrmatrix' => { 422 => 0xa034 },
	'cbcrmatrixdefault' => { 422 => 0xa033 },
	'ccdboardversion' => { 343 => 0x331 },
	'ccdscanmode' => { 329 => 0x1039 },
	'ccdsensitivity' => { 286 => 0x6 },
	'ccdversion' => { 343 => 0x330 },
	'ccvavgluminancenits' => { 521 => 'ccv_avg_luminance_nits' },
	'ccvmaxluminancenits' => { 521 => 'ccv_max_luminance_nits' },
	'ccvminluminancenits' => { 521 => 'ccv_min_luminance_nits' },
	'ccvprimariesxy' => { 521 => 'ccv_primaries_xy' },
	'ccvwhitexy' => { 521 => 'ccv_white_xy' },
	'cellglobalid' => { 510 => 'cgi' },
	'celllength' => { 122 => 0x109 },
	'cellr' => { 510 => 'r' },
	'celltowerid' => { 510 => 'cellid' },
	'cellwidth' => { 122 => 0x108 },
	'centerafarea' => { 315 => '15.1' },
	'centerfocuspoint' => { 319 => '2.2' },
	'centerpixel' => { 141 => 0x40c },
	'centerweightedareasize' => { 304 => '7.1', 305 => '8.1', 307 => '8.1', 308 => '8.1', 312 => '7.1', 313 => '5.1', 314 => '7.1', 315 => '6.3', 317 => '8.1', 318 => '8.1', 319 => '8.1', 320 => 0x1f, 321 => 0x1f, 322 => 0x1f },
	'certificate' => { 544 => 'Certificate' },
	'cfainterpolationalgorithm' => { 141 => 0xe60 },
	'cfainterpolationmetric' => { 141 => 0xe61 },
	'cfaoffsetcols' => { 141 => 0xc71 },
	'cfaoffsetrows' => { 141 => 0xc6f },
	'cfapattern' => { 122 => 0xa302, 353 => 0x9, 517 => 'CFAPattern' },
	'cfapattern2' => { 122 => 0x828e },
	'cfapatterncolumns' => { 517 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 517 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 517 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 122 => 0x828d },
	'cfazipperfixthreshold' => { 141 => 0xe62 },
	'channel' => { 530 => 'channel' },
	'channela-lang' => { 530 => [\'channel','channelA-lang'] },
	'channelchannel' => { 530 => [\'channel','channelChannel'] },
	'channels' => { 158 => 'Channels' },
	'channelsubchannel1' => { 530 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 530 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 530 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 530 => [\'channel','channelSubchannel4'] },
	'chapterlist' => { 408 => 'chpl' },
	'checkmark' => { 106 => 0x10101, 111 => 0x26a },
	'checkmark2' => { 112 => 0x8e },
	'childfontfiles' => { 545 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 304 => '10.3', 305 => '11.2', 320 => 0x10b, 321 => 0x10b, 322 => 0x121 },
	'chromablurradius' => { 122 => 0xc631 },
	'chromanoisecolorspace' => { 141 => 0xe6d },
	'chromanoiseedgemapthresh' => { 141 => 0xe6c },
	'chromanoisehighfthresh' => { 141 => 0xe6a },
	'chromanoiselowfthresh' => { 141 => 0xe6b },
	'chromaticaberration' => { 106 => 0x20703, 112 => 0x66, 422 => 0xa051 },
	'chromaticaberrationb' => { 511 => 'ChromaticAberrationB', 513 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 106 => 0x20708, 112 => 0x6b },
	'chromaticaberrationcorr' => { 81 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 122 => 0x7034, 373 => 0x1, 486 => 0x900d },
	'chromaticaberrationcorrparams' => { 122 => 0x7035, 480 => 0x66a, 481 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 106 => '0x20703.0', 112 => 0x62 },
	'chromaticaberrationr' => { 511 => 'ChromaticAberrationR', 513 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 106 => 0x20707, 112 => 0x6a },
	'chromaticaberrationsetting' => { 82 => 0x6 },
	'chrominancenoisereduction' => { 106 => 0x20601, 112 => 0x5e, 425 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 112 => 0x60 },
	'circadatecreated' => { 525 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrblacks2012' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'] },
	'circgradbasedcorrbrightness' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrcorrectionname' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'] },
	'circgradbasedcorrcorrectionsyncid' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'] },
	'circgradbasedcorrdefringe' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrdehaze' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'] },
	'circgradbasedcorrexposure' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'] },
	'circgradbasedcorrluminancenoise' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskinputdigest' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'circgradbasedcorrmaskleft' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmaskactive' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'circgradbasedcorrmaskmaskblendmode' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmaskdigest' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'circgradbasedcorrmaskmaskinverted' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'circgradbasedcorrmaskmaskname' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'] },
	'circgradbasedcorrmaskmasks' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'] },
	'circgradbasedcorrmaskmasksalpha' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'circgradbasedcorrmaskmasksangle' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'circgradbasedcorrmaskmasksbottom' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'circgradbasedcorrmaskmaskscentervalue' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'circgradbasedcorrmaskmaskscenterweight' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'circgradbasedcorrmaskmasksdabs' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'circgradbasedcorrmaskmasksfeather' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'circgradbasedcorrmaskmasksflipped' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'circgradbasedcorrmaskmasksflow' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'circgradbasedcorrmaskmasksfullx' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'circgradbasedcorrmaskmasksfully' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'circgradbasedcorrmaskmasksinputdigest' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'circgradbasedcorrmaskmasksleft' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'circgradbasedcorrmaskmasksmaskactive' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'circgradbasedcorrmaskmasksmaskblendmode' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmasksmaskdigest' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'circgradbasedcorrmaskmasksmaskinverted' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'circgradbasedcorrmaskmasksmaskname' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'circgradbasedcorrmaskmasksmasksubtype' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksmasksyncid' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'circgradbasedcorrmaskmasksmaskversion' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'circgradbasedcorrmaskmasksmidpoint' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'circgradbasedcorrmaskmasksorigin' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'circgradbasedcorrmaskmasksperimetervalue' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'circgradbasedcorrmaskmasksradius' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'circgradbasedcorrmaskmasksreferencepoint' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'circgradbasedcorrmaskmasksright' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'circgradbasedcorrmaskmasksroundness' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'circgradbasedcorrmaskmaskssizex' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'circgradbasedcorrmaskmaskssizey' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'circgradbasedcorrmaskmaskstop' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'circgradbasedcorrmaskmasksubtype' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksvalue' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'circgradbasedcorrmaskmasksversion' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'circgradbasedcorrmaskmaskswhat' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'circgradbasedcorrmaskmaskswholeimagearea' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'circgradbasedcorrmaskmasksx' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'] },
	'circgradbasedcorrmaskmasksy' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'] },
	'circgradbasedcorrmaskmasksyncid' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'circgradbasedcorrmaskmaskszerox' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'circgradbasedcorrmaskmaskszeroy' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'circgradbasedcorrmaskmaskversion' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'circgradbasedcorrmaskmidpoint' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskorigin' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'] },
	'circgradbasedcorrmaskperimetervalue' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskrange' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'circgradbasedcorrmaskrangeareamodels' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrmaskrangeareamodelscolorsampleinfo' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrmaskrangeareamodelscomponents' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrmaskrangecoloramount' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrmaskrangedepthfeather' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrmaskrangedepthmax' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrmaskrangedepthmin' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrmaskrangeinvert' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'circgradbasedcorrmaskrangelumfeather' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrmaskrangeluminancedepthsampleinfo' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrmaskrangelummax' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrmaskrangelummin' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrmaskrangelumrange' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrmaskrangesampletype' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrmaskrangetype' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'circgradbasedcorrmaskrangeversion' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'circgradbasedcorrmaskreferencepoint' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'circgradbasedcorrmaskright' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskwholeimagearea' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'circgradbasedcorrmaskx' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrrangemask' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'] },
	'circgradbasedcorrrangemaskareamodels' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrrangemaskareamodelscolorsampleinfo' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrrangemaskareamodelscomponents' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrrangemaskcoloramount' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrrangemaskdepthfeather' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrrangemaskdepthmax' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrrangemaskdepthmin' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrrangemaskinvert' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'circgradbasedcorrrangemasklumfeather' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrrangemaskluminancedepthsampleinfo' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrrangemasklummax' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrrangemasklummin' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrrangemasklumrange' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrrangemasksampletype' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrrangemasktype' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'] },
	'circgradbasedcorrrangemaskversion' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'circgradbasedcorrsaturation' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'] },
	'circgradbasedcorrshadows2012' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtexture' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'] },
	'circgradbasedcorrtint' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrtoninghue' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrtoningsaturation' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrwhat' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circgradbasedcorrwhites2012' => { 511 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'], 513 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'] },
	'circulargradientbasedcorrections' => { 511 => 'CircularGradientBasedCorrections', 513 => 'CircularGradientBasedCorrections' },
	'city' => { 134 => 0x5a, 164 => 'City', 348 => 0x6d, 528 => 'City' },
	'city2' => { 348 => 0x80 },
	'clarity' => { 130 => 0x100f, 256 => 0x35, 257 => 0x3d, 449 => 0x2036, 511 => 'Clarity', 513 => 'Clarity' },
	'clarity2012' => { 511 => 'Clarity2012', 513 => 'Clarity2012' },
	'claritycontrol' => { 383 => 0x96 },
	'classification' => { 408 => 'clsf' },
	'classifystate' => { 134 => 0xe1 },
	'clearretouch' => { 348 => 0x7c },
	'clearretouchvalue' => { 348 => 0xa3 },
	'client' => { 540 => 'client' },
	'clientname' => { 519 => 'ClientName' },
	'clipboardaspectratio' => { 511 => 'ClipboardAspectRatio', 513 => 'ClipboardAspectRatio' },
	'clipboardorientation' => { 511 => 'ClipboardOrientation', 513 => 'ClipboardOrientation' },
	'clipfilename' => { 408 => 'clfn' },
	'clipid' => { 408 => 'clid' },
	'clmodeshootingspeed' => { 304 => '10.2', 305 => '11.3', 307 => '11.2', 308 => '11.2', 313 => '11.2', 314 => '10.2', 317 => '11.2', 318 => '11.2', 319 => '11.1', 320 => 0x3b, 321 => 0x3b, 322 => 0x3b },
	'cluster' => { 511 => 'Cluster', 513 => 'Cluster' },
	'cmcontrast' => { 332 => 0x2022 },
	'cmddialsreverserotation' => { 320 => 0xba, 321 => 0xba, 322 => 0xba },
	'cmexposurecompensation' => { 332 => 0x2000 },
	'cmhue' => { 332 => 0x2021 },
	'cmsaturation' => { 332 => 0x2020 },
	'cmsharpness' => { 332 => 0x2023 },
	'cmwhitebalance' => { 332 => 0x2001 },
	'cmwhitebalancecomp' => { 332 => 0x2002 },
	'cmwhitebalancegraypoint' => { 332 => 0x2010 },
	'codec' => { 172 => 'Codec' },
	'codedcharacterset' => { 135 => 0x5a },
	'codeversion' => { 408 => 'cver' },
	'collection' => { 337 => 'Collection' },
	'collectionname' => { 173 => [\'Collections','CollectionsCollectionName'], 408 => 'coll' },
	'collections' => { 173 => 'Collections', 506 => 'collections' },
	'collectionuri' => { 173 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 402 => 'player.movie.visual.color', 529 => 'color' },
	'coloraberrationcontrol' => { 297 => 0xc89224b },
	'coloradjustment' => { 425 => 0x14 },
	'coloradjustmentmode' => { 424 => 0x210 },
	'coloranta' => { 545 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 545 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 545 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 545 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 545 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 545 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 545 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 545 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 545 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 545 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 545 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 545 => 'Colorants' },
	'colorantswatchname' => { 545 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 545 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 545 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 545 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 159 => 'ColorBalance' },
	'colorbalanceadj' => { 297 => 0x76a43202 },
	'colorbalanceblue' => { 184 => 0x1e },
	'colorbalancegreen' => { 184 => 0x1d },
	'colorbalancered' => { 184 => 0x1c },
	'colorbalanceversion' => { 209 => 0x4, 210 => 0x4, 211 => 0x0, 212 => 0x0 },
	'colorblur' => { 112 => 0x65 },
	'colorbluron' => { 106 => 0x20704 },
	'colorbooster' => { 297 => 0x5f0e7d23 },
	'colorboostlevel' => { 291 => 0x1 },
	'colorboosttype' => { 291 => 0x0 },
	'colorchromeeffect' => { 130 => 0x1048 },
	'colorchromefxblue' => { 130 => 0x104e },
	'colorclass' => { 394 => 0xde, 395 => 'ColorClass' },
	'colorcompensationfilter' => { 187 => [0x3a,0x5f], 189 => 0x111, 449 => 0xb022 },
	'colorcompensationfiltercustom' => { 435 => 0xd, 436 => 0xc },
	'colorcompensationfilterset' => { 435 => 0x8, 436 => 0x7, 437 => 0x18, 454 => 0xf },
	'colorcontrol' => { 329 => 0x102b },
	'colorcorrection' => { 486 => 0x8015 },
	'colorcorrectionmatrix' => { 1 => 0x3e },
	'colorcreatoreffect' => { 324 => 0x532 },
	'colordataversion' => { 43 => 0x0, 44 => 0x0, 46 => 0x0, 47 => 0x0, 48 => 0x0, 49 => 0x0, 50 => 0x0, 51 => 0x0, 52 => 0x0 },
	'coloreffect' => { 348 => 0x28 },
	'colorfilter' => { 115 => 0x17, 116 => 0x3017, 184 => 0x29, 192 => [0x38,0x4d,0x4f], 390 => 0x17 },
	'colorgain' => { 263 => 0x51 },
	'colorgradeblending' => { 511 => 'ColorGradeBlending', 513 => 'ColorGradeBlending' },
	'colorgradeglobalhue' => { 511 => 'ColorGradeGlobalHue', 513 => 'ColorGradeGlobalHue' },
	'colorgradegloballum' => { 511 => 'ColorGradeGlobalLum', 513 => 'ColorGradeGlobalLum' },
	'colorgradeglobalsat' => { 511 => 'ColorGradeGlobalSat', 513 => 'ColorGradeGlobalSat' },
	'colorgradehighlightlum' => { 511 => 'ColorGradeHighlightLum', 513 => 'ColorGradeHighlightLum' },
	'colorgrademidtonehue' => { 511 => 'ColorGradeMidtoneHue', 513 => 'ColorGradeMidtoneHue' },
	'colorgrademidtonelum' => { 511 => 'ColorGradeMidtoneLum', 513 => 'ColorGradeMidtoneLum' },
	'colorgrademidtonesat' => { 511 => 'ColorGradeMidtoneSat', 513 => 'ColorGradeMidtoneSat' },
	'colorgradeshadowlum' => { 511 => 'ColorGradeShadowLum', 513 => 'ColorGradeShadowLum' },
	'colorhue' => { 106 => 0x20900, 239 => 0x8d },
	'colorimetricreference' => { 122 => 0xc6bf },
	'colorlabel' => { 516 => 'ColorLabel' },
	'colormatrix' => { 65 => 0xa, 328 => 0x200, 329 => 0x1011, 422 => 0xa030 },
	'colormatrix1' => { 122 => 0xc621, 392 => 0x106 },
	'colormatrix2' => { 122 => 0xc622, 332 => 0x200, 392 => 0x226 },
	'colormatrix3' => { 122 => 0xcd33 },
	'colormatrixa' => { 383 => 0x203 },
	'colormatrixa2' => { 383 => 0x21c },
	'colormatrixadobergb' => { 422 => 0xa032 },
	'colormatrixb' => { 383 => 0x204 },
	'colormatrixb2' => { 383 => 0x21d },
	'colormatrixnumber' => { 329 => 0x1019 },
	'colormatrixsrgb' => { 422 => 0xa031 },
	'colormode' => { 116 => 0x3015, 130 => 0x1210, 143 => 0x66, 184 => 0x28, 187 => 0x16, 189 => 0x101, 190 => 0x36, 192 => 0x7, 239 => 0x3, 286 => 0x4, 348 => 0x32, 425 => 0x2c, 449 => 0xb029, 528 => 'ColorMode' },
	'colormoirereduction' => { 106 => 0x20670, 298 => 0x15 },
	'colormoirereductionmode' => { 298 => 0x5 },
	'colormoirereductionon' => { 106 => '0x20670.0' },
	'colornoisereduction' => { 486 => 0x8029, 511 => 'ColorNoiseReduction', 513 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 511 => 'ColorNoiseReductionDetail', 513 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 298 => 0x18 },
	'colornoisereductionsharpness' => { 298 => 0x1c },
	'colornoisereductionsmoothness' => { 511 => 'ColorNoiseReductionSmoothness', 513 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 126 => 0x2 },
	'colorprofile' => { 184 => 0x33 },
	'colorprofilesettings' => { 324 => 0x539 },
	'colorrepresentation' => { 136 => 0x3c },
	'colorsaturationadj' => { 106 => 0x20305 },
	'colorsequence' => { 136 => 0x41 },
	'colorspace' => { 53 => 0x3, 66 => 0xb4, 100 => 0x10b4, 122 => 0xa001, 138 => 0x3, 165 => 'ColorSpace', 185 => 0x2f, 186 => 0x25, 187 => 0x17, 239 => 0x1e, 324 => 0x507, 383 => 0x37, 422 => 0xa011, 425 => 0xb, 435 => 0x1b, 436 => 0x83, 437 => 0xe, 454 => 0x6, 517 => 'ColorSpace' },
	'colorspace2' => { 65 => 0x9 },
	'colorspecapproximation' => { 138 => 0x2 },
	'colorspecdata' => { 138 => 0x3 },
	'colorspecmethod' => { 138 => 0x0 },
	'colorspecprecedence' => { 138 => 0x1 },
	'colortempasshot' => { 40 => 0x4, 41 => 0x7, 42 => 0x1d, 43 => 0x59, 44 => 0x6d, 45 => 0x26, 46 => 0x43, 49 => 0x43, 50 => 0x43, 51 => 0x43, 52 => 0x4b },
	'colortempauto' => { 40 => 0x9, 41 => 0xf, 42 => 0x22, 43 => 0x5e, 44 => 0x72, 45 => 0x1c, 46 => 0x48, 49 => 0x48, 50 => 0x48, 51 => 0x48, 52 => 0x50 },
	'colortempcloudy' => { 40 => 0x22, 41 => 0x37, 42 => 0x31, 43 => 0xa4, 44 => 0xdb, 45 => 0x35, 46 => 0x5c, 49 => 0x75, 50 => 0x8e, 51 => 0x93, 52 => 0x96, 383 => 0x55 },
	'colortempcustom' => { 46 => 0x84 },
	'colortempcustom1' => { 42 => 0x45 },
	'colortempcustom2' => { 42 => 0x4a },
	'colortempdaylight' => { 40 => 0x18, 41 => 0x27, 42 => 0x27, 43 => 0x9a, 44 => 0xd1, 45 => 0x2b, 46 => 0x52, 49 => 0x6b, 50 => 0x84, 51 => 0x89, 52 => 0x8c, 383 => 0x53 },
	'colortemperature' => { 7 => 0x73, 8 => [0x48,0x4e], 9 => 0xc0, 10 => 0x37, 11 => 0x62, 12 => 0x37, 13 => 0x7c, 14 => 0x73, 15 => 0x73, 16 => 0x77, 17 => 0x73, 18 => 0x7c, 19 => 0x58, 20 => 0x73, 21 => 0xc0, 22 => 0x7f, 23 => 0x7d, 24 => 0xc0, 25 => 0xc6, 26 => 0xc7, 27 => 0x135, 28 => 0x7b, 29 => 0x13a, 66 => 0xae, 76 => 0x9, 100 => 0x10ae, 130 => 0x1005, 141 => 0x846, 159 => 'ColorTemperature', 185 => [0x6e,0x49], 186 => 0x3f, 187 => [0x39,0x5e], 189 => 0x10b, 192 => [0x3c,0x4c,0x4e], 343 => 0x321, 383 => 0x50, 415 => 0x1308, 449 => 0xb021, 511 => 'Temperature', 513 => 'Temperature' },
	'colortemperatureadj' => { 486 => 0x8013 },
	'colortemperatureauto' => { 239 => 0x4f },
	'colortemperaturebg' => { 329 => 0x1013 },
	'colortemperaturecustom' => { 435 => 0xc, 436 => 0xb },
	'colortemperaturerg' => { 329 => 0x1014 },
	'colortemperatureset' => { 435 => 0x7, 436 => 0x6 },
	'colortemperaturesetting' => { 187 => 0x25, 437 => 0x17, 454 => 0xe },
	'colortempflash' => { 40 => 0x36, 41 => 0x57, 42 => 0x40, 43 => 0xb8, 44 => 0xef, 45 => 0x49, 46 => 0x70, 49 => 0x89, 50 => 0xa2, 51 => 0xa7, 52 => 0xaa, 383 => 0x5a },
	'colortempflashdata' => { 46 => 0x24a },
	'colortempfluorescent' => { 40 => 0x2c, 41 => 0x47, 42 => 0x3b, 43 => 0xae, 44 => 0xe5, 45 => 0x3f, 46 => 0x66, 49 => 0x7f, 50 => 0x98, 51 => 0x9d, 52 => 0xa0 },
	'colortempfluorescentd' => { 383 => 0x57 },
	'colortempfluorescentn' => { 383 => 0x58 },
	'colortempfluorescentw' => { 383 => 0x59 },
	'colortempkelvin' => { 40 => 0x31, 41 => 0x4f, 43 => 0xb3, 44 => 0xea, 45 => 0x44, 46 => 0x6b, 49 => 0x84, 50 => 0x9d, 51 => 0xa2, 52 => 0xa5, 348 => 0x44, 415 => 0x1307 },
	'colortempmeasured' => { 40 => 0xe, 41 => 0x17, 43 => 0x63, 44 => 0x77, 46 => 0x4d, 49 => 0x4d, 50 => 0x4d, 51 => 0x4d, 52 => 0x55 },
	'colortemppc1' => { 45 => 0x94, 46 => 0x75 },
	'colortemppc2' => { 45 => 0x99, 46 => 0x7a },
	'colortemppc3' => { 45 => 0x9e, 46 => 0x7f },
	'colortempshade' => { 40 => 0x1d, 41 => 0x2f, 42 => 0x2c, 43 => 0x9f, 44 => 0xd6, 45 => 0x30, 46 => 0x57, 49 => 0x70, 50 => 0x89, 51 => 0x8e, 52 => 0x91, 383 => 0x54 },
	'colortemptungsten' => { 40 => 0x27, 41 => 0x3f, 42 => 0x36, 43 => 0xa9, 44 => 0xe0, 45 => 0x3a, 46 => 0x61, 49 => 0x7a, 50 => 0x93, 51 => 0x98, 52 => 0x9b, 383 => 0x56 },
	'colortempunknown' => { 40 => 0x13, 41 => 0x1f, 43 => 0x68, 44 => 0x7c, 45 => 0x21, 49 => 0x52, 50 => 0x52, 51 => 0x52, 52 => 0x5a },
	'colortempunknown10' => { 40 => 0x63, 41 => 0x9f, 43 => 0x95, 44 => 0xa9, 45 => 0x76, 49 => 0xa2, 50 => 0x7f, 51 => 0x7f, 52 => 0x87 },
	'colortempunknown11' => { 40 => 0x68, 41 => 0xa7, 43 => 0xbd, 44 => [0xae,0xb3], 45 => 0x7b, 49 => 0xa7, 50 => 0xa7, 51 => 0x84, 52 => 0xaf },
	'colortempunknown12' => { 40 => 0x6d, 41 => 0xaf, 43 => 0xc2, 44 => 0xb8, 45 => 0x80, 49 => 0xac, 50 => 0xac, 51 => 0xac, 52 => 0xb4 },
	'colortempunknown13' => { 40 => 0x72, 41 => 0xb7, 43 => 0xc7, 44 => 0xbd, 45 => 0x85, 49 => 0xb1, 50 => 0xb1, 51 => 0xb1, 52 => 0xb9 },
	'colortempunknown14' => { 43 => 0xcc, 44 => 0xc2, 45 => 0x8a, 49 => 0xb6, 50 => 0xb6, 51 => 0xb6, 52 => 0xbe },
	'colortempunknown15' => { 43 => 0xd1, 44 => 0xc7, 45 => 0x8f, 49 => 0xbb, 50 => 0xbb, 51 => 0xbb, 52 => 0xc3 },
	'colortempunknown16' => { 43 => 0xd6, 44 => 0xcc, 45 => 0xa3, 50 => 0xc0, 51 => 0xc0, 52 => 0xc8 },
	'colortempunknown17' => { 43 => 0xdb, 44 => 0xf4, 50 => 0xc5, 51 => 0xc5, 52 => 0xcd },
	'colortempunknown18' => { 43 => 0xe0, 44 => 0xf9, 50 => 0xca, 51 => 0xca, 52 => 0xd2 },
	'colortempunknown19' => { 43 => 0xe5, 44 => 0xfe, 50 => 0xcf, 51 => 0xcf, 52 => 0xd7 },
	'colortempunknown2' => { 40 => 0x3b, 41 => 0x5f, 43 => 0x6d, 44 => 0x81, 45 => 0x4e, 49 => 0x57, 50 => 0x57, 51 => 0x57, 52 => 0x5f },
	'colortempunknown20' => { 43 => 0xea, 44 => 0x103, 50 => 0xd4, 51 => 0xd4, 52 => 0xdc },
	'colortempunknown21' => { 43 => 0xef, 44 => 0x108, 51 => 0xd9, 52 => 0xe1 },
	'colortempunknown22' => { 43 => 0xf4, 44 => 0x10d, 51 => 0xde, 52 => 0xe6 },
	'colortempunknown23' => { 43 => 0xf9, 44 => 0x112, 51 => 0xe3, 52 => 0xeb },
	'colortempunknown24' => { 43 => 0xfe, 44 => 0x117, 51 => 0xe8, 52 => 0xf0 },
	'colortempunknown25' => { 43 => 0x103, 44 => 0x11c, 51 => 0xed, 52 => 0xf5 },
	'colortempunknown26' => { 43 => 0x108, 44 => 0x121, 51 => 0xf2, 52 => 0xfa },
	'colortempunknown27' => { 43 => 0x10d, 44 => 0x126, 51 => 0xf7, 52 => 0xff },
	'colortempunknown28' => { 43 => 0x112, 51 => 0xfc, 52 => 0x104 },
	'colortempunknown29' => { 43 => 0x117, 51 => 0x101, 52 => 0x109 },
	'colortempunknown3' => { 40 => 0x40, 41 => 0x67, 43 => 0x72, 44 => 0x86, 45 => 0x53, 49 => 0x5c, 50 => 0x5c, 51 => 0x5c, 52 => 0x64 },
	'colortempunknown30' => { 51 => 0x106 },
	'colortempunknown4' => { 40 => 0x45, 41 => 0x6f, 43 => 0x77, 44 => 0x8b, 45 => 0x58, 49 => 0x61, 50 => 0x61, 51 => 0x61, 52 => 0x69 },
	'colortempunknown5' => { 40 => 0x4a, 41 => 0x77, 43 => 0x7c, 44 => 0x90, 45 => 0x5d, 49 => 0x66, 50 => 0x66, 51 => 0x66, 52 => 0x6e },
	'colortempunknown6' => { 40 => 0x4f, 41 => 0x7f, 43 => 0x81, 44 => 0x95, 45 => 0x62, 49 => 0x8e, 50 => 0x6b, 51 => 0x6b, 52 => 0x73 },
	'colortempunknown7' => { 40 => 0x54, 41 => 0x87, 43 => 0x86, 44 => 0x9a, 45 => 0x67, 49 => 0x93, 50 => 0x70, 51 => 0x70, 52 => 0x78 },
	'colortempunknown8' => { 40 => 0x59, 41 => 0x8f, 43 => 0x8b, 44 => 0x9f, 45 => 0x6c, 49 => 0x98, 50 => 0x75, 51 => 0x75, 52 => 0x7d },
	'colortempunknown9' => { 40 => 0x5e, 41 => 0x97, 43 => 0x90, 44 => 0xa4, 45 => 0x71, 49 => 0x9d, 50 => 0x7a, 51 => 0x7a, 52 => 0x82 },
	'colortint' => { 347 => 0x35c },
	'colortone' => { 10 => 0x6f, 12 => 0x77, 36 => 0x2a, 53 => 0x2, 65 => 0x8 },
	'colortoneadj' => { 106 => 0x20304, 111 => 0x11e },
	'colortoneauto' => { 73 => 0x9c },
	'colortonefaithful' => { 19 => 0x107, 72 => 0x6c, 73 => 0x6c },
	'colortonelandscape' => { 19 => 0x105, 72 => 0x3c, 73 => 0x3c },
	'colortonemonochrome' => { 72 => 0x84, 73 => 0x84 },
	'colortoneneutral' => { 19 => 0x106, 72 => 0x54, 73 => 0x54 },
	'colortoneportrait' => { 19 => 0x104, 72 => 0x24, 73 => 0x24 },
	'colortonestandard' => { 19 => 0x103, 72 => 0xc, 73 => 0xc },
	'colortoneuserdef1' => { 19 => 0x109, 72 => 0x9c, 73 => 0xb4 },
	'colortoneuserdef2' => { 19 => 0x10a, 72 => 0xb4, 73 => 0xcc },
	'colortoneuserdef3' => { 19 => 0x10b, 72 => 0xcc, 73 => 0xe4 },
	'columninterleavefactor' => { 122 => 0xcd43 },
	'comlenblksize' => { 141 => 0xfde8 },
	'commanddialframeadvancezoom' => { 248 => 0x804 },
	'commanddialplaybackmode' => { 320 => 0x1cb, 321 => 0x1cb, 322 => 0x1e3 },
	'commanddials' => { 315 => '5.1' },
	'commanddialsaperturesetting' => { 304 => '17.3', 305 => '18.3', 307 => '18.3', 308 => '18.3', 313 => '33.3', 314 => '17.3', 317 => '18.3', 318 => '18.3' },
	'commanddialschangemainsub' => { 304 => '17.2', 305 => '18.1', 307 => '18.1', 308 => '18.1', 313 => '33.2', 314 => '17.2', 317 => '18.1', 318 => '18.1' },
	'commanddialsmenuandplayback' => { 304 => '17.4', 305 => '18.2', 307 => '18.2', 308 => '18.2', 313 => '33.4', 314 => '17.4', 317 => '18.2', 318 => '18.2' },
	'commanddialsreverserotation' => { 304 => '17.1', 305 => '6.4', 307 => '6.2', 308 => '6.2', 309 => '16.2', 310 => '17.2', 313 => '33.1', 314 => '17.1', 317 => '6.2', 318 => '6.2', 319 => '18.1' },
	'commanddialvideoplaybackmode' => { 320 => 0x1cd, 322 => 0x1e5 },
	'commanderchannel' => { 315 => '10.2', 316 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 315 => '13.1', 316 => '31.1' },
	'commandergroupa_ttlcomp' => { 319 => '32.1' },
	'commandergroupamanualoutput' => { 315 => '13.2', 316 => '28.2' },
	'commandergroupamode' => { 315 => '11.2', 316 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 315 => '14.1', 316 => '32.1' },
	'commandergroupb_ttlcomp' => { 319 => '33.1' },
	'commandergroupbmanualoutput' => { 315 => '14.2', 316 => '29.2' },
	'commandergroupbmode' => { 315 => '11.3', 316 => '29.1' },
	'commanderinternalflash' => { 315 => '11.1', 316 => '27.1' },
	'commanderinternalmanualoutput' => { 315 => '12.2', 316 => '27.2' },
	'commanderinternalttlchannel' => { 313 => '18.2' },
	'commanderinternalttlcomp' => { 315 => '12.1', 316 => '30.2', 319 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 313 => '20.1', 314 => '26.1' },
	'commanderinternalttlcompgroupa' => { 313 => '21.1', 314 => '27.1' },
	'commanderinternalttlcompgroupb' => { 313 => '22.1', 314 => '28.1' },
	'comment' => { 0 => 0x2, 123 => 'Comment', 160 => 'Comment', 337 => 'Comment', 400 => "\xa9cmt", 402 => 'comment', 408 => "\xa9cmt" },
	'compass' => { 418 => 0x4 },
	'compatiblebrands' => { 402 => 'compatible_brands' },
	'compatibleversion' => { 511 => 'CompatibleVersion', 513 => 'CompatibleVersion' },
	'compilation' => { 400 => 'cpil' },
	'compimageimagespersequence' => { 518 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfImagesInSequences'] },
	'compimagemaxexposureall' => { 518 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfAll'] },
	'compimagemaxexposureused' => { 518 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfUsed'] },
	'compimageminexposureall' => { 518 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfAll'] },
	'compimageminexposureused' => { 518 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfUsed'] },
	'compimagenumsequences' => { 518 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfSequences'] },
	'compimagesumexposureall' => { 518 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfAll'] },
	'compimagesumexposureused' => { 518 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfUsed'] },
	'compimagetotalexposureperiod' => { 518 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesTotalExposurePeriod'] },
	'compimagevalues' => { 518 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesValues'] },
	'complianceprofile' => { 530 => 'complianceProfile' },
	'componentsconfiguration' => { 122 => 0x9101, 165 => 'Components', 517 => 'ComponentsConfiguration' },
	'componentversion' => { 100 => 0x80c },
	'composer' => { 182 => 'WM/Composer', 400 => ["\xa9com","\xa9wrt"], 408 => ["\xa9com","\xa9wrt"], 540 => 'composer' },
	'composerid' => { 400 => 'cmID' },
	'composerkeywords' => { 408 => "\xa9cok" },
	'compositeimage' => { 122 => 0xa460, 518 => 'CompositeImage' },
	'compositeimagecount' => { 122 => 0xa461, 518 => 'CompositeImageCount' },
	'compositeimageexposuretimes' => { 122 => 0xa462, 518 => 'CompositeImageExposureTimes' },
	'composition' => { 501 => 'Composition' },
	'compositionadjust' => { 382 => '0.1' },
	'compositionadjustrotation' => { 382 => 0x7 },
	'compositionadjustx' => { 382 => 0x5 },
	'compositionadjusty' => { 382 => 0x6 },
	'compressedbitsperpixel' => { 122 => 0x9102, 517 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 189 => 0x40, 329 => 0x40 },
	'compression' => { 122 => 0x103, 353 => 0xb, 536 => 'Compression' },
	'compressionfactor' => { 324 => 0x50d },
	'compressionformat' => { 65 => 0x4 },
	'compressionratio' => { 165 => 'Compression', 329 => 0x1034 },
	'compressorversion' => { 408 => 'CNCV' },
	'condadobvfactor' => { 141 => 0xf3e },
	'condadodaybvthresh' => { 141 => 0xf3c },
	'condadodayoffsets' => { 141 => 0xf42 },
	'condadofluoffsets' => { 141 => 0xf44 },
	'condadofluthresh' => { 141 => 0xf41 },
	'condadoillfactor' => { 141 => 0xf3f },
	'condadoneurange' => { 141 => 0xf3d },
	'condadotunoffsets' => { 141 => 0xf43 },
	'condadotunthresh' => { 141 => 0xf40 },
	'conductor' => { 182 => 'WM/Conductor', 400 => "\xa9con" },
	'confidence' => { 496 => 'Confidence' },
	'confidencelevel' => { 507 => 'ConfidenceLevel' },
	'confidencemime' => { 496 => 'ConfidenceMime' },
	'constrainedcropheight' => { 111 => 0x266, 394 => 0xd6 },
	'constrainedcropwidth' => { 111 => 0x262, 394 => 0xd5 },
	'contact' => { 134 => 0x76 },
	'contactinfo' => { 511 => 'ContactInfo', 513 => 'ContactInfo', 529 => 'contactInfo' },
	'container' => { 490 => 'Container' },
	'containerdirectory' => { 490 => [\'Container','ContainerDirectory'] },
	'containerdirectoryitem' => { 490 => [\'Container','ContainerDirectoryItem'] },
	'containerdirectoryitemdatauri' => { 490 => [\'Container','ContainerDirectoryItemDataURI'] },
	'containerdirectoryitemlength' => { 490 => [\'Container','ContainerDirectoryItemLength'] },
	'containerdirectoryitemmime' => { 490 => [\'Container','ContainerDirectoryItemMime'] },
	'containerdirectoryitempadding' => { 490 => [\'Container','ContainerDirectoryItemPadding'] },
	'containerformat' => { 525 => 'ContainerFormat' },
	'containerformatidentifier' => { 525 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 525 => [\'ContainerFormat','ContainerFormatName'] },
	'contentcreatedate' => { 400 => "\xa9day", 408 => ['@day',"\xa9day"] },
	'contentdistributor' => { 182 => 'WM/ContentDistributor' },
	'contentdistributorid' => { 408 => 'cdis' },
	'contentid' => { 408 => 'ccid' },
	'contentidentifier' => { 1 => 0x11, 402 => 'content.identifier' },
	'contentlocationcode' => { 134 => 0x1a },
	'contentlocationname' => { 134 => 0x1b },
	'contenttype' => { 530 => 'contentType' },
	'continuousbracketing' => { 187 => 0x20 },
	'continuousdrive' => { 36 => 0x5 },
	'continuousmodedisplay' => { 320 => 0x51, 321 => 0x51, 322 => 0x51 },
	'continuousmodeliveview' => { 318 => '77.2' },
	'continuousshootingspeed' => { 87 => 0x610 },
	'continuousshotlimit' => { 87 => 0x611 },
	'contrast' => { 10 => 0x73, 12 => 0x75, 36 => 0xd, 115 => 0xc, 116 => [0x3012,0x20], 122 => [0xa408,0xfe54], 130 => [0x1004,0x1006], 159 => 'Contrast', 179 => 'Contrast', 184 => 0x20, 185 => 0x31, 186 => 0x27, 187 => 0x19, 192 => 0x2, 255 => 0x33, 256 => 0x37, 257 => 0x3f, 329 => 0x1029, 348 => 0x39, 350 => 0x300a, 383 => 0x20, 390 => 0xc, 402 => 'player.movie.visual.contrast', 409 => 0x24, 411 => 0x52, 415 => 0x1012, 425 => 0xd, 435 => 0x1d, 436 => 0x1a, 449 => 0x2004, 511 => 'Contrast', 513 => 'Contrast', 517 => 'Contrast' },
	'contrast2012' => { 511 => 'Contrast2012', 513 => 'Contrast2012' },
	'contrastadj' => { 106 => 0x20303, 111 => 0x115, 300 => 0x2c, 486 => 0x8017 },
	'contrastauto' => { 73 => 0x90 },
	'contrastcurve' => { 239 => 0x8c },
	'contrastdetectaf' => { 196 => 0x4 },
	'contrastdetectafarea' => { 383 => 0x231 },
	'contrastdetectafinfocus' => { 196 => [0x1c,0x52] },
	'contrastfaithful' => { 19 => 0xec, 72 => 0x60, 73 => 0x60 },
	'contrasthighlight' => { 383 => 0x6d },
	'contrasthighlightshadowadj' => { 383 => 0x6f },
	'contrastlandscape' => { 19 => 0xea, 72 => 0x30, 73 => 0x30 },
	'contrastmode' => { 348 => 0x2c },
	'contrastmonochrome' => { 19 => 0xed, 72 => 0x78, 73 => 0x78 },
	'contrastneutral' => { 19 => 0xeb, 72 => 0x48, 73 => 0x48 },
	'contrastportrait' => { 19 => 0xe9, 72 => 0x18, 73 => 0x18 },
	'contrastsetting' => { 324 => 0x505, 332 => 0x1012, 437 => 0x10, 454 => 0x8 },
	'contrastshadow' => { 383 => 0x6e },
	'contraststandard' => { 19 => 0xe8, 72 => 0x0, 73 => 0x0 },
	'contrastuserdef1' => { 19 => 0xee, 72 => 0x90, 73 => 0xa8 },
	'contrastuserdef2' => { 19 => 0xef, 72 => 0xa8, 73 => 0xc0 },
	'contrastuserdef3' => { 19 => 0xf0, 72 => 0xc0, 73 => 0xd8 },
	'contributedmedia' => { 540 => 'contributedMedia' },
	'contributedmediaduration' => { 540 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 540 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 540 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 540 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 540 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 540 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 540 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 540 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 540 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 540 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 514 => 'contributor', 525 => 'Contributor' },
	'contributoridentifier' => { 525 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 525 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 525 => [\'Contributor','ContributorRole'] },
	'contributors' => { 160 => 'Contributors' },
	'controldialset' => { 187 => 0x46 },
	'controlledvocabularyterm' => { 525 => 'CVterm' },
	'controllerboardversion' => { 343 => 0x332 },
	'controlmode' => { 79 => 0x12 },
	'controlringresponse' => { 320 => 0x1d5, 321 => 0x1d5, 322 => 0x1ed },
	'controlringrotation' => { 87 => 0x712 },
	'conversionlens' => { 325 => 0x403, 348 => 0x35 },
	'converter' => { 122 => 0xfe4d, 286 => 0xb, 511 => 'Converter', 513 => 'Converter' },
	'converttograyscale' => { 511 => 'ConvertToGrayscale', 513 => 'ConvertToGrayscale' },
	'cookingequipment' => { 532 => 'cookingEquipment' },
	'cookingmethod' => { 532 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 122 => 0x8298, 160 => 'Copyright', 337 => 'Copyright', 353 => 0x8298, 383 => 0x22f, 399 => 'Copyright', 400 => ['cprt',"\xa9cpy"], 402 => 'copyright', 408 => ['cprt',"\xa9cpy"], 511 => 'Copyright', 513 => 'Copyright', 527 => 'Copyright', 533 => 'copyright', 536 => 'Copyright', 540 => 'copyright' },
	'copyrightflag' => { 397 => 0x40a },
	'copyrightnotice' => { 134 => 0x74 },
	'copyrightowner' => { 334 => 'CopyrightOwner' },
	'copyrightownerid' => { 334 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 334 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 334 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 334 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 334 => 'CopyrightStatus' },
	'copyrightyear' => { 525 => 'CopyrightYear', 530 => 'copyrightYear' },
	'coringfilter' => { 328 => 0x310, 329 => 0x102d, 332 => 0x310 },
	'coringvalues' => { 328 => 0x311, 332 => 0x311 },
	'corporateentity' => { 530 => 'corporateEntity' },
	'correctionalreadyapplied' => { 338 => 'CorrectionAlreadyApplied' },
	'correlatedcolortemp' => { 347 => 0x35b },
	'country' => { 164 => 'Country', 348 => 0x69, 528 => 'Country' },
	'country-primarylocationcode' => { 134 => 0x64 },
	'country-primarylocationname' => { 134 => 0x65 },
	'countrycode' => { 238 => 0x5, 395 => 'CountryCode', 524 => 'CountryCode' },
	'course' => { 532 => 'course' },
	'coverage' => { 514 => 'coverage' },
	'coverart' => { 400 => 'covr' },
	'coverdate' => { 530 => 'coverDate' },
	'coverdisplaydate' => { 530 => 'coverDisplayDate' },
	'coveruri' => { 408 => 'cvru' },
	'cpufirmwareversion' => { 383 => 0x28 },
	'crc32' => { 515 => 'crc32' },
	'createdate' => { 122 => 0x9004, 160 => 'CreateDate', 333 => 'CreationDate', 337 => 'create-date', 399 => 'CreationDate', 405 => 0x1, 538 => 'CreateDate' },
	'creationdate' => { 402 => 'creationdate', 527 => 'CreationDate', 530 => 'creationDate' },
	'creationtime' => { 337 => 'Creation Time', 402 => 'creation_time' },
	'creativestyle' => { 435 => 0x1a, 436 => 0x18, 446 => 0x41, 449 => 0xb020, 481 => 0x4a },
	'creativestylesetting' => { 437 => 0xf, 454 => 0x7 },
	'creativestylewaschanged' => { 486 => 0x8001 },
	'creator' => { 333 => 'Creator', 399 => 'Creator', 514 => 'creator', 525 => 'Creator', 527 => 'Creator' },
	'creatoraddress' => { 524 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 181 => 'CreatorAppId' },
	'creatorcity' => { 524 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 524 => 'CreatorContactInfo' },
	'creatorcountry' => { 524 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 525 => [\'Creator','CreatorIdentifier'] },
	'creatoridentity' => { 395 => 'CreatorIdentity' },
	'creatorname' => { 525 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 181 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 524 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 524 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 525 => [\'Creator','CreatorRole'] },
	'creatortool' => { 538 => 'CreatorTool' },
	'creatorworkemail' => { 524 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 524 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 524 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 134 => 0x6e, 528 => 'Credit' },
	'creditline' => { 533 => 'creditLine' },
	'creditlinereq' => { 543 => 'CreditLineReq' },
	'creditlinerequired' => { 334 => 'CreditLineRequired' },
	'cropactive' => { 104 => 0x0, 111 => 0x244 },
	'cropangle' => { 511 => 'CropAngle', 513 => 'CropAngle' },
	'croparea' => { 239 => 0x45, 486 => 0x9011 },
	'cropaspectratio' => { 106 => 0x30101, 111 => 0x260 },
	'cropaspectratiocustom' => { 106 => 0x30102 },
	'cropbottom' => { 126 => 0x9, 292 => 0x36, 353 => 0x31, 394 => 0xdc, 511 => 'CropBottom', 513 => 'CropBottom' },
	'cropbottommargin' => { 55 => 0x3 },
	'cropcircleactive' => { 112 => 0xd6 },
	'cropcircleradius' => { 112 => 0xd9 },
	'cropcirclex' => { 112 => 0xd7 },
	'cropcircley' => { 112 => 0xd8 },
	'cropconstraintowarp' => { 511 => 'CropConstrainToWarp', 513 => 'CropConstrainToWarp' },
	'croph' => { 505 => 'CropH' },
	'cropheight' => { 104 => 0x6, 111 => 0x24c, 328 => 0x615, 332 => 0x615, 511 => 'CropHeight', 513 => 'CropHeight' },
	'crophispeed' => { 239 => 0x1b },
	'cropleft' => { 111 => 0x246, 126 => 0x6, 292 => 0x1e, 328 => 0x612, 332 => 0x612, 353 => 0x30, 394 => 0xd9, 511 => 'CropLeft', 513 => 'CropLeft' },
	'cropleftmargin' => { 55 => 0x0 },
	'cropmode' => { 130 => 0x104d, 415 => 0x1018 },
	'croporiginalheight' => { 104 => 0xb },
	'croporiginalwidth' => { 104 => 0xa },
	'cropoutputheight' => { 292 => 0xce },
	'cropoutputheightinches' => { 292 => 0x96 },
	'cropoutputpixels' => { 292 => 0xd6 },
	'cropoutputresolution' => { 292 => 0xb6 },
	'cropoutputscale' => { 292 => 0xbe },
	'cropoutputwidth' => { 292 => 0xc6 },
	'cropoutputwidthinches' => { 292 => 0x8e },
	'cropped' => { 130 => 0x1051 },
	'croppedareaimageheightpixels' => { 499 => 'CroppedAreaImageHeightPixels', 500 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 499 => 'CroppedAreaImageWidthPixels', 500 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 499 => 'CroppedAreaLeftPixels', 500 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 499 => 'CroppedAreaTopPixels', 500 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 415 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 415 => 0x1603 },
	'cropping' => { 486 => 0x9010 },
	'cropright' => { 126 => 0x8, 292 => 0x2e, 353 => 0x32, 394 => 0xdb, 511 => 'CropRight', 513 => 'CropRight' },
	'croprightmargin' => { 55 => 0x1 },
	'croprotatedoriginalheight' => { 104 => 0x2 },
	'croprotatedoriginalwidth' => { 104 => 0x1 },
	'croprotation' => { 104 => 0x8, 126 => 0xb },
	'cropscaledresolution' => { 292 => 0x9e },
	'cropsize' => { 130 => 0x1053 },
	'cropsourceresolution' => { 292 => 0xae },
	'croptop' => { 111 => 0x248, 126 => 0x7, 292 => 0x26, 328 => 0x613, 332 => 0x613, 353 => 0x2f, 394 => 0xda, 511 => 'CropTop', 513 => 'CropTop' },
	'croptopleft' => { 130 => 0x1052 },
	'croptopmargin' => { 55 => 0x2 },
	'cropunit' => { 511 => 'CropUnit', 513 => 'CropUnit' },
	'cropunits' => { 511 => 'CropUnits', 513 => 'CropUnits' },
	'cropw' => { 505 => 'CropW' },
	'cropwidth' => { 104 => 0x5, 111 => 0x24a, 328 => 0x614, 332 => 0x614, 511 => 'CropWidth', 513 => 'CropWidth' },
	'cropx' => { 104 => 0x3, 505 => 'CropX' },
	'cropy' => { 104 => 0x4, 505 => 'CropY' },
	'crossprocess' => { 383 => 0x7b },
	'crossprocessparams' => { 383 => 0x235 },
	'cuisine' => { 532 => 'cuisine' },
	'currenticcprofile' => { 122 => 0xc691 },
	'currentpreprofilematrix' => { 122 => 0xc692 },
	'currentversion' => { 486 => 0xd000 },
	'curve0x' => { 505 => 'Curve0x' },
	'curve0y' => { 505 => 'Curve0y' },
	'curve1x' => { 505 => 'Curve1x' },
	'curve1y' => { 505 => 'Curve1y' },
	'curve2x' => { 505 => 'Curve2x' },
	'curve2y' => { 505 => 'Curve2y' },
	'curve3x' => { 505 => 'Curve3x' },
	'curve3y' => { 505 => 'Curve3y' },
	'curve4x' => { 505 => 'Curve4x' },
	'curve4y' => { 505 => 'Curve4y' },
	'curves' => { 297 => 0x76a43201 },
	'custom1' => { 334 => 'Custom1' },
	'custom10' => { 334 => 'Custom10' },
	'custom2' => { 334 => 'Custom2' },
	'custom3' => { 334 => 'Custom3' },
	'custom4' => { 334 => 'Custom4' },
	'custom5' => { 334 => 'Custom5' },
	'custom6' => { 334 => 'Custom6' },
	'custom7' => { 334 => 'Custom7' },
	'custom8' => { 334 => 'Custom8' },
	'custom9' => { 334 => 'Custom9' },
	'customcolortone' => { 112 => 0x4c },
	'customcontrast' => { 112 => 0x4e },
	'customcontrols' => { 87 => 0x70c },
	'customdefaultunsharpfineness' => { 112 => 0xbe },
	'customdefaultunsharpstrength' => { 112 => 0xbc },
	'customdefaultunsharpthreshold' => { 112 => 0xc0 },
	'customilluminant' => { 141 => 0x405 },
	'customizedials' => { 87 => 0x715 },
	'customlinear' => { 112 => 0x4f },
	'customoutputhighlightpoint' => { 112 => 0x53 },
	'customoutputshadowpoint' => { 112 => 0x54 },
	'custompicturestyle' => { 106 => 0x10021 },
	'custompicturestyledata' => { 106 => 0xf0500 },
	'custompicturestylefilename' => { 66 => 0x4010 },
	'customrawhighlight' => { 112 => 0x7c },
	'customrawhighlightpoint' => { 112 => 0x51 },
	'customrawshadow' => { 112 => 0x85 },
	'customrawshadowpoint' => { 112 => 0x52 },
	'customrendered' => { 122 => 0xa401, 194 => 0x6420, 517 => 'CustomRendered' },
	'customsaturation' => { 112 => 0x4d, 324 => 0x503 },
	'customsettingsalldefault' => { 304 => '0.2', 313 => '0.2' },
	'customsettingsbank' => { 304 => '0.1', 305 => '0.1', 307 => '0.1', 308 => '0.1', 313 => '0.1', 317 => '0.2', 318 => '0.2', 320 => 0x1, 321 => 0x1, 322 => 0x1 },
	'customsharpness' => { 112 => 0x50 },
	'customunsharpmaskfineness' => { 112 => 0xb8 },
	'customunsharpmaskstrength' => { 112 => 0xb6 },
	'customunsharpmaskthreshold' => { 112 => 0xba },
	'customwb_rblevels' => { 454 => 0x1a },
	'customwb_rgblevels' => { 436 => 0x8, 437 => 0x19 },
	'customwbbluelevel' => { 187 => 0x36 },
	'customwberror' => { 187 => 0x37 },
	'customwbgreenlevel' => { 187 => 0x35 },
	'customwbredlevel' => { 187 => 0x34 },
	'customwbsetting' => { 187 => 0x26 },
	'cx' => { 408 => '_cx_' },
	'cy' => { 408 => '_cy_' },
	'd-lightinghq' => { 297 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 293 => 0x2 },
	'd-lightinghqhighlight' => { 293 => 0x1 },
	'd-lightinghqselected' => { 297 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 293 => 0x0 },
	'd-lightinghs' => { 297 => 0xce5554aa },
	'd-lightinghsadjustment' => { 294 => 0x0 },
	'd-lightinghscolorboost' => { 294 => 0x1 },
	'd-rangeoptimizerhighlight' => { 486 => 0x8024 },
	'd-rangeoptimizermode' => { 486 => 0x8022 },
	'd-rangeoptimizershadow' => { 486 => 0x802d },
	'd-rangeoptimizervalue' => { 486 => 0x8023 },
	'darkblacksegrows' => { 141 => 0x18d8 },
	'darkfocusenvironment' => { 348 => 0x8003 },
	'darkframecountfactor' => { 141 => 0xc85 },
	'darkframelongexposure' => { 141 => 0xc84 },
	'darkframeshortexposure' => { 141 => 0xc83 },
	'darkpedestal' => { 141 => 0xc7f },
	'datacompressionmethod' => { 136 => 0x6e },
	'dataimprint' => { 184 => 0x34 },
	'datamining' => { 334 => 'DataMining' },
	'dataonscreen' => { 525 => 'DataOnScreen' },
	'dataonscreenregion' => { 525 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 525 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 525 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 525 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 525 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 525 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 525 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 525 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 383 => 0x3d },
	'date' => { 383 => 0x6, 514 => 'date' },
	'dateacquired' => { 181 => 'DateAcquired', 182 => '{2CBAA8F5-D81F-47CA-B17A-F8D822300131} 100' },
	'datecreated' => { 134 => 0x37, 528 => 'DateCreated' },
	'datedisplayformat' => { 289 => 0x3 },
	'dateidentified' => { 121 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 309 => '4.2' },
	'daterecieved' => { 530 => 'dateRecieved' },
	'datesent' => { 135 => 0x46 },
	'datestampmode' => { 66 => 0x1c, 239 => 0x9d },
	'datetime' => { 506 => 'datetime', 536 => 'DateTime' },
	'datetimedigitized' => { 517 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 103 => 0x0, 122 => 0x9003, 157 => 0x14, 160 => 'OriginalDate', 403 => 'IDIT', 408 => 'date', 409 => 0xb, 410 => 0x3b, 411 => 0x3e, 517 => 'DateTimeOriginal' },
	'datetimestamp' => { 143 => 0x64 },
	'datetimeutc' => { 324 => 0x908 },
	'daylightsavings' => { 80 => 0x3, 289 => 0x2 },
	'dayofweek' => { 410 => 0x42, 411 => 0x4a },
	'dccontinent' => { 121 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 121 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 121 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 121 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 121 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 121 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 121 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 121 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 121 => 'Event' },
	'dcfootprintspatialfit' => { 121 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 121 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 121 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 121 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 121 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 121 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 121 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 121 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 121 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 121 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 121 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 121 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 121 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 121 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 121 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 121 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 121 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 121 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 121 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 121 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 121 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 121 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 121 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 121 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 121 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 121 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 121 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 121 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 121 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 121 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 121 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 121 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 121 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 121 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 121 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 121 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcverticaldatum' => { 121 => [\'dctermsLocation','dctermsLocationVerticalDatum'] },
	'dcwaterbody' => { 121 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 168 => 'Declination' },
	'decposition' => { 184 => 0x32 },
	'defaultautogray' => { 511 => 'DefaultAutoGray', 513 => 'DefaultAutoGray' },
	'defaultautotone' => { 511 => 'DefaultAutoTone', 513 => 'DefaultAutoTone' },
	'defaultblackrender' => { 122 => 0xc7a6 },
	'defaultcroporigin' => { 122 => 0xc61f },
	'defaultcropsize' => { 122 => 0xc620 },
	'defaulteraseoption' => { 87 => 0x813 },
	'defaultscale' => { 122 => 0xc61e },
	'defaultsspecifictoiso' => { 511 => 'DefaultsSpecificToISO', 513 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 511 => 'DefaultsSpecificToSerial', 513 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 122 => 0xc7b5 },
	'defectisocode' => { 141 => 0x90f },
	'defringe' => { 511 => 'Defringe', 513 => 'Defringe' },
	'defringegreenamount' => { 511 => 'DefringeGreenAmount', 513 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 511 => 'DefringeGreenHueHi', 513 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 511 => 'DefringeGreenHueLo', 513 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 511 => 'DefringePurpleAmount', 513 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 511 => 'DefringePurpleHueHi', 513 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 511 => 'DefringePurpleHueLo', 513 => 'DefringePurpleHueLo' },
	'dehaze' => { 511 => 'Dehaze', 513 => 'Dehaze' },
	'deletedimagecount' => { 239 => 0xa6, 268 => 0x6e },
	'deprecatedon' => { 509 => 'deprecatedOn' },
	'depthbasedcorrcorrectionactive' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionActive'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionActive'] },
	'depthbasedcorrcorrectionamount' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionAmount'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionAmount'] },
	'depthbasedcorrcorrectionsyncid' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionSyncID'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionSyncID'] },
	'depthbasedcorrections' => { 511 => 'DepthBasedCorrections', 513 => 'DepthBasedCorrections' },
	'depthbasedcorrlocalcorrecteddepth' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCorrectedDepth'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCorrectedDepth'] },
	'depthbasedcorrlocalcurverefinesaturation' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCurveRefineSaturation'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCurveRefineSaturation'] },
	'depthbasedcorrmask' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasks'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasks'] },
	'depthbasedcorrmaskalpha' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAlpha'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAlpha'] },
	'depthbasedcorrmaskangle' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAngle'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAngle'] },
	'depthbasedcorrmaskbottom' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksBottom'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksBottom'] },
	'depthbasedcorrmaskcentervalue' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterValue'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterValue'] },
	'depthbasedcorrmaskcenterweight' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterWeight'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterWeight'] },
	'depthbasedcorrmaskdabs' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksDabs'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksDabs'] },
	'depthbasedcorrmaskfeather' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFeather'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFeather'] },
	'depthbasedcorrmaskflipped' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlipped'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlipped'] },
	'depthbasedcorrmaskflow' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlow'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlow'] },
	'depthbasedcorrmaskfullx' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullX'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullX'] },
	'depthbasedcorrmaskfully' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullY'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullY'] },
	'depthbasedcorrmaskinputdigest' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksInputDigest'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksInputDigest'] },
	'depthbasedcorrmaskleft' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksLeft'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksLeft'] },
	'depthbasedcorrmaskmaskactive' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskActive'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskActive'] },
	'depthbasedcorrmaskmaskblendmode' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskBlendMode'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'depthbasedcorrmaskmaskdigest' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskDigest'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskDigest'] },
	'depthbasedcorrmaskmaskinverted' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskInverted'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskInverted'] },
	'depthbasedcorrmaskmaskname' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskName'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskName'] },
	'depthbasedcorrmaskmasks' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasks'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasks'] },
	'depthbasedcorrmaskmasksalpha' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAlpha'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'depthbasedcorrmaskmasksangle' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAngle'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAngle'] },
	'depthbasedcorrmaskmasksbottom' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksBottom'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksBottom'] },
	'depthbasedcorrmaskmaskscentervalue' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterValue'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'depthbasedcorrmaskmaskscenterweight' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterWeight'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'depthbasedcorrmaskmasksdabs' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksDabs'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksDabs'] },
	'depthbasedcorrmaskmasksfeather' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFeather'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFeather'] },
	'depthbasedcorrmaskmasksflipped' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlipped'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'depthbasedcorrmaskmasksflow' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlow'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlow'] },
	'depthbasedcorrmaskmasksfullx' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullX'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullX'] },
	'depthbasedcorrmaskmasksfully' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullY'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullY'] },
	'depthbasedcorrmaskmasksinputdigest' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksInputDigest'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'depthbasedcorrmaskmasksleft' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksLeft'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksLeft'] },
	'depthbasedcorrmaskmasksmaskactive' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskActive'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'depthbasedcorrmaskmasksmaskblendmode' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'depthbasedcorrmaskmasksmaskdigest' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskDigest'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'depthbasedcorrmaskmasksmaskinverted' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskInverted'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'depthbasedcorrmaskmasksmaskname' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskName'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'depthbasedcorrmaskmasksmasksubtype' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSubType'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'depthbasedcorrmaskmasksmasksyncid' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'depthbasedcorrmaskmasksmaskversion' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskVersion'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'depthbasedcorrmaskmasksmidpoint' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMidpoint'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'depthbasedcorrmaskmasksorigin' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksOrigin'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'depthbasedcorrmaskmasksperimetervalue' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'depthbasedcorrmaskmasksradius' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRadius'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRadius'] },
	'depthbasedcorrmaskmasksreferencepoint' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksReferencePoint'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'depthbasedcorrmaskmasksright' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRight'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRight'] },
	'depthbasedcorrmaskmasksroundness' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRoundness'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'depthbasedcorrmaskmaskssizex' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeX'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'depthbasedcorrmaskmaskssizey' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeY'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'depthbasedcorrmaskmaskstop' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksTop'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksTop'] },
	'depthbasedcorrmaskmasksubtype' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSubType'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSubType'] },
	'depthbasedcorrmaskmasksvalue' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskValue'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'depthbasedcorrmaskmasksversion' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksVersion'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksVersion'] },
	'depthbasedcorrmaskmaskswhat' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWhat'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWhat'] },
	'depthbasedcorrmaskmaskswholeimagearea' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'depthbasedcorrmaskmasksx' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksX'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksX'] },
	'depthbasedcorrmaskmasksy' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksY'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksY'] },
	'depthbasedcorrmaskmasksyncid' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSyncID'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'depthbasedcorrmaskmaskszerox' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroX'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'depthbasedcorrmaskmaskszeroy' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroY'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'depthbasedcorrmaskmaskversion' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskVersion'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskVersion'] },
	'depthbasedcorrmaskmidpoint' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMidpoint'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMidpoint'] },
	'depthbasedcorrmaskorigin' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksOrigin'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksOrigin'] },
	'depthbasedcorrmaskperimetervalue' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksPerimeterValue'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'depthbasedcorrmaskradius' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRadius'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRadius'] },
	'depthbasedcorrmaskrange' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'depthbasedcorrmaskrangeareamodels' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'depthbasedcorrmaskrangeareamodelscolorsampleinfo' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'depthbasedcorrmaskrangeareamodelscomponents' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'depthbasedcorrmaskrangecoloramount' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'depthbasedcorrmaskrangedepthfeather' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'depthbasedcorrmaskrangedepthmax' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'depthbasedcorrmaskrangedepthmin' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'depthbasedcorrmaskrangeinvert' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'depthbasedcorrmaskrangelumfeather' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'depthbasedcorrmaskrangeluminancedepthsampleinfo' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'depthbasedcorrmaskrangelummax' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'depthbasedcorrmaskrangelummin' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'depthbasedcorrmaskrangelumrange' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'depthbasedcorrmaskrangesampletype' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'depthbasedcorrmaskrangetype' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'depthbasedcorrmaskrangeversion' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'depthbasedcorrmaskreferencepoint' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksReferencePoint'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksReferencePoint'] },
	'depthbasedcorrmaskright' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRight'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRight'] },
	'depthbasedcorrmaskroundness' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRoundness'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRoundness'] },
	'depthbasedcorrmasksizex' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeX'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeX'] },
	'depthbasedcorrmasksizey' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeY'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeY'] },
	'depthbasedcorrmasktop' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksTop'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksTop'] },
	'depthbasedcorrmaskvalue' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskValue'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskValue'] },
	'depthbasedcorrmaskversion' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksVersion'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksVersion'] },
	'depthbasedcorrmaskwhat' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWhat'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWhat'] },
	'depthbasedcorrmaskwholeimagearea' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWholeImageArea'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'depthbasedcorrmaskx' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksX'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksX'] },
	'depthbasedcorrmasky' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksY'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksY'] },
	'depthbasedcorrmaskzerox' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroX'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroX'] },
	'depthbasedcorrmaskzeroy' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroY'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroY'] },
	'depthbasedcorrwhat' => { 511 => [\'DepthBasedCorrections','DepthBasedCorrectionsWhat'], 513 => [\'DepthBasedCorrections','DepthBasedCorrectionsWhat'] },
	'depthfar' => { 122 => 0xc7eb },
	'depthformat' => { 122 => 0xc7e9 },
	'depthimage' => { 496 => 'Data' },
	'depthmapinfo' => { 511 => 'DepthMapInfo', 513 => 'DepthMapInfo' },
	'depthmapinfobasehighlightguideinputdigest' => { 511 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideInputDigest'], 513 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideInputDigest'] },
	'depthmapinfobasehighlightguidetable' => { 511 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideTable'], 513 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideTable'] },
	'depthmapinfobasehighlightguideversion' => { 511 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideVersion'], 513 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideVersion'] },
	'depthmapinfobaselayereddepthinputdigest' => { 511 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthInputDigest'], 513 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthInputDigest'] },
	'depthmapinfobaselayereddepthtable' => { 511 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthTable'], 513 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthTable'] },
	'depthmapinfobaselayereddepthversion' => { 511 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthVersion'], 513 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthVersion'] },
	'depthmapinfobaserawdepthinputdigest' => { 511 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthInputDigest'], 513 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthInputDigest'] },
	'depthmapinfobaserawdepthtable' => { 511 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthTable'], 513 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthTable'] },
	'depthmapinfobaserawdepthversion' => { 511 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthVersion'], 513 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthVersion'] },
	'depthmapinfodepthsource' => { 511 => [\'DepthMapInfo','DepthMapInfoDepthSource'], 513 => [\'DepthMapInfo','DepthMapInfoDepthSource'] },
	'depthmeasuretype' => { 122 => 0xc7ed },
	'depthnear' => { 122 => 0xc7ea },
	'depthunits' => { 122 => 0xc7ec },
	'derivedfrom' => { 541 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 541 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 541 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 541 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 541 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 541 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 541 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 541 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 541 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 541 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 541 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 541 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 541 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 541 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 541 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 541 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 541 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 541 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 541 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 541 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 541 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 541 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 541 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 541 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 182 => 'Description', 337 => 'Description', 400 => ['desc','dscp',"\xa9des"], 402 => 'description', 408 => 'dscp', 511 => 'Description', 513 => 'Description', 514 => 'description', 538 => 'Description' },
	'destination' => { 135 => 0x5 },
	'destinationcity' => { 383 => 0x24, 389 => 0x3 },
	'destinationcitycode' => { 390 => 0x1001 },
	'destinationdst' => { 383 => 0x26, 389 => '0.3' },
	'developmentdynamicrange' => { 130 => 0x1403 },
	'deviantmatrixcustom' => { 141 => 0x7de },
	'deviantmatrixdaylight' => { 141 => 0x7da },
	'deviantmatrixflash' => { 141 => 0x7dd },
	'deviantmatrixfluorescent' => { 141 => 0x7dc },
	'deviantmatrixtungsten' => { 141 => 0x7db },
	'deviantwhitecustom' => { 141 => 0x842 },
	'deviantwhitedaylight' => { 141 => 0x83e },
	'deviantwhiteflash' => { 141 => 0x841 },
	'deviantwhitefluorescent' => { 141 => 0x840 },
	'deviantwhitetungsten' => { 141 => 0x83f },
	'device' => { 530 => 'device' },
	'devicesettingdescription' => { 517 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 517 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 517 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 517 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 422 => 0x2 },
	'dewarpdata' => { 119 => 'DewarpData' },
	'dewarpflag' => { 119 => 'DewarpFlag' },
	'dialdirectiontvav' => { 87 => 0x706 },
	'dietaryneeds' => { 532 => 'dietaryNeeds' },
	'diffractioncompensation' => { 228 => 0x20e, 243 => 0x142, 244 => 0x1b2, 245 => 0x1b2, 246 => 0x1a2, 247 => 0x1b6, 248 => 0x1b6 },
	'diffractioncorrection' => { 348 => 0xbc, 373 => 0x3 },
	'diffractioncorrectionon' => { 106 => 0x2070b },
	'digitalcreationdate' => { 134 => 0x3e },
	'digitalcreationtime' => { 134 => 0x3f },
	'digitaldeehighlightadj' => { 263 => 0x202 },
	'digitaldeeshadowadj' => { 263 => 0x200 },
	'digitaldeethreshold' => { 263 => 0x201 },
	'digitalfilter' => { 425 => 0x59 },
	'digitalfilter01' => { 370 => 0x5 },
	'digitalfilter02' => { 370 => 0x16 },
	'digitalfilter03' => { 370 => 0x27 },
	'digitalfilter04' => { 370 => 0x38 },
	'digitalfilter05' => { 370 => 0x49 },
	'digitalfilter06' => { 370 => 0x5a },
	'digitalfilter07' => { 370 => 0x6b },
	'digitalfilter08' => { 370 => 0x7c },
	'digitalfilter09' => { 370 => 0x8d },
	'digitalfilter10' => { 370 => 0x9e },
	'digitalfilter11' => { 370 => 0xaf },
	'digitalfilter12' => { 370 => 0xc0 },
	'digitalfilter13' => { 370 => 0xd1 },
	'digitalfilter14' => { 370 => 0xe2 },
	'digitalfilter15' => { 370 => 0xf3 },
	'digitalfilter16' => { 370 => 0x104 },
	'digitalfilter17' => { 370 => 0x115 },
	'digitalfilter18' => { 370 => 0x126 },
	'digitalfilter19' => { 370 => 0x137 },
	'digitalfilter20' => { 370 => 0x148 },
	'digitalgain' => { 76 => 0xb },
	'digitalgem' => { 223 => 0x0 },
	'digitalice' => { 263 => 0x100 },
	'digitalimageguid' => { 525 => 'DigImageGUID' },
	'digitallensoptimizer' => { 64 => 0xa },
	'digitallensoptimizersetting' => { 82 => 0x9 },
	'digitalroc' => { 260 => 0x0 },
	'digitalsourcefiletype' => { 525 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 525 => 'DigitalSourceType' },
	'digitalzoom' => { 36 => 0xc, 115 => 0xa, 130 => 0x1044, 143 => 0x68, 154 => 0x22, 155 => 0x1e, 159 => 'DigitalZoom', 184 => 0xc, 239 => 0x86, 286 => 0xa, 329 => 0x204, 383 => 0x1e, 390 => 0xa, 424 => 0x204, 472 => 0x12, 473 => 0x12 },
	'digitalzoomon' => { 424 => 0x21b },
	'digitalzoomratio' => { 122 => 0xa404, 460 => 0x200, 462 => 0x21c, 517 => 'DigitalZoomRatio' },
	'director' => { 182 => 'WM/Director', 400 => "\xa9dir", 402 => 'director', 408 => "\xa9dir", 540 => 'director' },
	'directorphotography' => { 540 => 'directorPhotography' },
	'directory' => { 123 => 'Directory' },
	'directoryindex' => { 7 => 0x137, 9 => 0x2dc, 11 => 0x17e, 13 => 0x238, 14 => 0x13f, 15 => 0x133, 16 => 0x1df, 17 => 0x1a7, 18 => 0x1f0, 19 => 0xcc, 20 => 0x1c7, 21 => 0x298, 22 => 0x1e7, 23 => 0x1e5, 24 => [0x27c,0x280], 25 => 0x2b6, 26 => 0x2bf, 28 => 0x1f7, 29 => 0x4ba, 30 => 0xb21 },
	'directoryindex2' => { 21 => 0x29c },
	'directorynumber' => { 216 => 0x3, 411 => 0x12 },
	'disableautocreation' => { 494 => 'DisableAutoCreation' },
	'disclaimer' => { 337 => 'Disclaimer' },
	'discnumber' => { 540 => 'discNumber' },
	'dishtype' => { 532 => 'dishType' },
	'disknumber' => { 400 => 'disk' },
	'dispbutton' => { 248 => 0x7d4, 320 => 0x2ab },
	'displayallafpoints' => { 87 => 0x514 },
	'displayaperture' => { 36 => 0x23 },
	'displayedunitsx' => { 398 => 0x2 },
	'displayedunitsy' => { 398 => 0x6 },
	'displayname' => { 402 => 'displayname', 529 => 'displayName' },
	'distance1' => { 143 => 0x28 },
	'distance2' => { 143 => 0x2c },
	'distance3' => { 143 => 0x30 },
	'distance4' => { 143 => 0x34 },
	'distortion' => { 422 => 0xa050 },
	'distortioncompensation' => { 486 => 0x8040 },
	'distortioncontrol' => { 268 => 0x10 },
	'distortioncorrection' => { 81 => 0x3, 106 => 0x20705, 112 => 0x67, 122 => 0x7036, 214 => 0x4, 324 => 0x50b, 352 => '7.1', 373 => 0x0, 480 => 0x601, 481 => 0x5b },
	'distortioncorrection2' => { 328 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 508 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 106 => '0x20705.0', 112 => 0x63 },
	'distortioncorrectionsetting' => { 82 => 0x7, 449 => 0x2013 },
	'distortioncorrectionvalue' => { 81 => 0x9 },
	'distortioncorrectionversion' => { 214 => 0x0 },
	'distortioncorrparams' => { 122 => 0x7037, 459 => 0x1a23, 462 => 0x1870, 464 => 0x189c, 465 => 0x18cc, 466 => 0x17d0, 480 => 0x6ca, 481 => 0x64 },
	'distortioncorrparamsnumber' => { 462 => 0x1899, 464 => 0x18c5, 465 => 0x18f5, 466 => 0x17f9 },
	'distortioncorrparamspresent' => { 462 => 0x1898, 464 => 0x18c4, 465 => 0x18f4, 466 => 0x17f8, 468 => 0x10b, 469 => 0x10b, 480 => 0x600, 481 => 0x5a },
	'distortioneffect' => { 106 => 0x20709 },
	'distortionn' => { 352 => 0xc },
	'distortionparam02' => { 352 => 0x2 },
	'distortionparam04' => { 352 => 0x4 },
	'distortionparam08' => { 352 => 0x8 },
	'distortionparam09' => { 352 => 0x9 },
	'distortionparam11' => { 352 => 0xb },
	'distortionscale' => { 352 => 0x5 },
	'distributor' => { 530 => 'distributor' },
	'distributorproductid' => { 529 => 'distributorProductID' },
	'dloon' => { 106 => '0x20706.0', 112 => 0xdc },
	'dlosetting' => { 106 => 0x20706, 112 => 0xdd },
	'dlosettingapplied' => { 105 => 0x4 },
	'dloshootingdistance' => { 112 => 0xde },
	'dloversion' => { 105 => 0x5 },
	'dmcomment' => { 540 => 'comment' },
	'dmdithermatrix' => { 141 => 0xc7a },
	'dmdithermatrixheight' => { 141 => 0xc7c },
	'dmdithermatrixwidth' => { 141 => 0xc7b },
	'dngadobedata' => { 122 => 0xc634 },
	'dngbackwardversion' => { 122 => 0xc613 },
	'dngignoresidecars' => { 511 => 'DNGIgnoreSidecars', 513 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 122 => 0xc630 },
	'dngprivatedata' => { 122 => 0xc634 },
	'dngversion' => { 122 => 0xc612 },
	'document' => { 337 => 'Document' },
	'documentancestors' => { 528 => 'DocumentAncestors' },
	'documenthistory' => { 134 => 0xe7 },
	'documentid' => { 541 => 'DocumentID' },
	'documentname' => { 122 => 0x10d },
	'documentnotes' => { 134 => 0xe6 },
	'doi' => { 530 => 'doi' },
	'dopesheet' => { 525 => 'Dopesheet' },
	'dopesheetlink' => { 525 => 'DopesheetLink' },
	'dopesheetlinklink' => { 525 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 525 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 141 => 0xc82 },
	'dpp' => { 506 => 'dpp' },
	'dprawbokehshift' => { 106 => 0x20b20 },
	'dprawbokehshiftarea' => { 106 => 0x20b21 },
	'dprawghostingreductionarea' => { 106 => 0x20b30 },
	'dprawmicroadjustbackfront' => { 106 => 0x20b10 },
	'dprawmicroadjuststrength' => { 106 => 0x20b12 },
	'dr4cameramodel' => { 107 => 0x3 },
	'drangepriority' => { 130 => 0x1443 },
	'drangepriorityauto' => { 130 => 0x1444 },
	'drangepriorityfixed' => { 130 => 0x1445 },
	'drivemode' => { 116 => 0x3103, 128 => '0.1', 184 => 0x6, 187 => 0x1e, 190 => 0xe, 194 => 0x64d0, 324 => 0x600, 383 => 0x34, 415 => 0x1002, 425 => 0x3, 435 => 0x4, 436 => 0x7e, 437 => 0x34 },
	'drivemode2' => { 187 => 0xa, 364 => 0x7, 446 => 0xe, 454 => 0x1 },
	'drivemodesetting' => { 437 => 0x4 },
	'drivespeed' => { 128 => '0.2' },
	'dspfirmwareversion' => { 383 => 0x27 },
	'dualpixelraw' => { 64 => 0xb },
	'duration' => { 69 => 0x6a, 158 => 'Duration', 172 => 'Duration', 532 => 'duration', 540 => 'duration' },
	'durationscale' => { 540 => [\'duration','durationScale'] },
	'durationvalue' => { 540 => [\'duration','durationValue'] },
	'dustremovaldata' => { 66 => 0x97 },
	'dxcropalert' => { 244 => 0x250, 245 => 0x250, 246 => 0x23c, 247 => 0x250, 248 => 0x250 },
	'dynamicafarea' => { 304 => '1.4', 313 => '1.4' },
	'dynamicafareasize' => { 244 => 0x254, 245 => 0x254, 246 => 0x240, 247 => 0x254, 248 => 0x254 },
	'dynamicareaafassist' => { 320 => 0x18, 321 => 0x18, 322 => 0x18 },
	'dynamicareaafdisplay' => { 305 => '46.1', 307 => '47.1', 308 => '47.1', 317 => '47.1', 318 => '47.1' },
	'dynamicrange' => { 130 => 0x1400 },
	'dynamicrangeboost' => { 348 => 0xee },
	'dynamicrangeexpansion' => { 383 => 0x69, 415 => 0x100e },
	'dynamicrangemax' => { 111 => 0x7c },
	'dynamicrangemin' => { 111 => 0x7a },
	'dynamicrangeoptimizer' => { 187 => 0x15, 449 => [0xb025,0xb04f], 458 => 0x1144, 459 => [0x1144,0x324], 460 => [0x1120,0x300], 461 => [0x119c,0x37c], 462 => [0x1178,0x328], 463 => [0x1030,0x50], 464 => [0x228,0x50], 465 => [0x228,0x50], 466 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 446 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 435 => 0x19, 436 => 0x17, 437 => 0xd, 446 => 0x79, 454 => 0x5 },
	'dynamicrangeoptimizermode' => { 190 => 0x15, 435 => 0x18, 436 => 0x16, 446 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 187 => 0x27, 437 => 0xc, 454 => 0x4 },
	'dynamicrangesetting' => { 130 => 0x1402 },
	'e-dialinprogram' => { 364 => '1.3' },
	'earliestageorloweststage' => { 121 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 121 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 121 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 121 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 121 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'earthpos' => { 490 => 'EarthPos' },
	'earthposaltitude' => { 490 => [\'EarthPos','EarthPosAltitude'] },
	'earthposlatitude' => { 490 => [\'EarthPos','EarthPosLatitude'] },
	'earthposlongitude' => { 490 => [\'EarthPos','EarthPosLongitude'] },
	'earthposrotationw' => { 490 => [\'EarthPos','EarthPosRotationW'] },
	'earthposrotationx' => { 490 => [\'EarthPos','EarthPosRotationX'] },
	'earthposrotationy' => { 490 => [\'EarthPos','EarthPosRotationY'] },
	'earthposrotationz' => { 490 => [\'EarthPos','EarthPosRotationZ'] },
	'earthpostimestamp' => { 490 => [\'EarthPos','EarthPosTimestamp'] },
	'easyexposurecomp' => { 319 => '6.1' },
	'easyexposurecompensation' => { 304 => '6.4', 305 => '6.5', 307 => '6.3', 308 => '6.3', 312 => '5.1', 313 => '4.4', 314 => '5.2', 317 => '6.3', 318 => '6.3', 320 => 0x1d, 321 => 0x1d, 322 => 0x1d },
	'easymode' => { 36 => 0xb },
	'edgemapslope' => { 141 => 0x930 },
	'edgemapx1' => { 141 => 0x931 },
	'edgemapx2' => { 141 => 0x932 },
	'edgemapx3' => { 141 => 0x934 },
	'edgemapx4' => { 141 => 0x935 },
	'edgenoisereduction' => { 298 => 0x4, 486 => 0x8028 },
	'edit1' => { 408 => "\xa9ed1" },
	'edit2' => { 408 => "\xa9ed2" },
	'edit3' => { 408 => "\xa9ed3" },
	'edit4' => { 408 => "\xa9ed4" },
	'edit5' => { 408 => "\xa9ed5" },
	'edit6' => { 408 => "\xa9ed6" },
	'edit7' => { 408 => "\xa9ed7" },
	'edit8' => { 408 => "\xa9ed8" },
	'edit9' => { 408 => "\xa9ed9" },
	'edition' => { 530 => 'edition' },
	'editorialupdate' => { 134 => 0x8 },
	'editstatus' => { 134 => 0x7, 395 => 'EditStatus', 506 => 'EditStatus' },
	'editversionname' => { 297 => 0x3d136244 },
	'effectivelv' => { 383 => 0x2d },
	'effectivemaxaperture' => { 232 => 0x12, 233 => 0x13, 237 => 0x14 },
	'eissn' => { 530 => 'eIssn' },
	'electricalblackcolumns' => { 141 => 0x1810 },
	'electronicfront-curtainshutter' => { 307 => '5.2', 308 => '5.2', 317 => '5.3', 318 => '5.2' },
	'electronicfrontcurtainshutter' => { 449 => 0x201a },
	'elevation' => { 168 => 'Elevation' },
	'email' => { 160 => 'EMail' },
	'embargodate' => { 533 => 'embargoDate' },
	'embdencrightsexpr' => { 525 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 525 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 525 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 525 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 528 => 'EmbeddedXMPDigest' },
	'emissivity' => { 124 => 0x3 },
	'emptyslotrelease' => { 244 => 0x723, 245 => 0x733, 246 => 0x625, 247 => 0x655, 248 => 0x6bd },
	'enablechromanoisereduction' => { 141 => 0xe6e },
	'enablesharpening' => { 141 => 0x92e },
	'encodedby' => { 182 => 'WM/EncodedBy', 400 => "\xa9enc" },
	'encodedwith' => { 402 => 'Encoded_With' },
	'encoder' => { 400 => "\xa9too", 402 => 'encoder', 408 => "\xa9too" },
	'encoderid' => { 408 => "\xa9enc" },
	'encodingtime' => { 182 => 'WM/EncodingTime' },
	'encryptionkey' => { 422 => 0xa020 },
	'endingpage' => { 530 => 'endingPage' },
	'enduser' => { 334 => 'EndUser' },
	'enduserid' => { 334 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 334 => [\'EndUser','EndUserEndUserName'] },
	'energysavingmode' => { 244 => 0x746, 245 => 0x756, 246 => 0x648, 247 => 0x678, 248 => 0x6e0 },
	'engineer' => { 540 => 'engineer' },
	'enhancedarktones' => { 290 => 0x8 },
	'enhancedenoisealreadyapplied' => { 508 => 'EnhanceDenoiseAlreadyApplied' },
	'enhancedenoiselumaamount' => { 508 => 'EnhanceDenoiseLumaAmount' },
	'enhancedenoiseversion' => { 508 => 'EnhanceDenoiseVersion' },
	'enhancedetailsalreadyapplied' => { 508 => 'EnhanceDetailsAlreadyApplied' },
	'enhancedetailsversion' => { 508 => 'EnhanceDetailsVersion' },
	'enhancement' => { 115 => 0x16, 116 => 0x3016 },
	'enhanceparams' => { 122 => 0xc7ee },
	'enhancer' => { 328 => 0x300 },
	'enhancervalues' => { 328 => 0x301 },
	'enhancesuperresolutionalreadyapplied' => { 508 => 'EnhanceSuperResolutionAlreadyApplied' },
	'enhancesuperresolutionscale' => { 508 => 'EnhanceSuperResolutionScale' },
	'enhancesuperresolutionversion' => { 508 => 'EnhanceSuperResolutionVersion' },
	'envelopenumber' => { 135 => 0x28 },
	'envelopepriority' => { 135 => 0x3c },
	'enveloperecordversion' => { 135 => 0x0 },
	'episode' => { 525 => 'Episode' },
	'episodeglobaluniqueid' => { 400 => 'egid' },
	'episodeidentifier' => { 525 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 525 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 525 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 329 => 0x20c },
	'epsonimagewidth' => { 329 => 0x20b },
	'epsonsoftware' => { 329 => 0x20d },
	'equipmentinstitution' => { 489 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 489 => 'EquipmentManufacturer' },
	'equipmentversion' => { 325 => 0x0 },
	'ettlii' => { 87 => 0x304, 88 => 0xd, 89 => 0xe, 90 => 0x7, 91 => 0x7, 92 => 0xe },
	'event' => { 492 => 'Event', 504 => 'Event', 525 => 'Event', 530 => 'event' },
	'eventalias' => { 529 => 'eventAlias' },
	'eventdate' => { 121 => [\'Event','EventEventDate'] },
	'eventday' => { 121 => [\'Event','EventDay'] },
	'eventearliestdate' => { 121 => [\'Event','EventEarliestDate'] },
	'eventend' => { 529 => 'eventEnd' },
	'eventenddayofyear' => { 121 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 121 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 121 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 121 => [\'Event','EventHabitat'] },
	'eventid' => { 121 => [\'Event','EventEventID'], 525 => 'EventId' },
	'eventlatestdate' => { 121 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 121 => [\'Event','EventMonth'] },
	'eventnumber' => { 409 => 0x9, 410 => 0x37, 411 => 0x3a },
	'eventparenteventid' => { 121 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 121 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 121 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 121 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 121 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 121 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 529 => 'eventStart' },
	'eventstartdayofyear' => { 121 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 529 => 'eventSubtype' },
	'eventtime' => { 121 => [\'Event','EventEventTime'] },
	'eventtype' => { 529 => 'eventType' },
	'eventverbatimeventdate' => { 121 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 121 => [\'Event','EventYear'] },
	'evfgrid' => { 320 => 0x165, 321 => 0x165, 322 => 0x17d },
	'evfimageframe' => { 320 => 0x164, 321 => 0x164, 322 => 0x17c },
	'evfreleaseindicator' => { 320 => 0x24f, 321 => 0x24f, 322 => 0x267 },
	'evfwarmdisplaybrightness' => { 320 => 0x24d, 321 => 0x24d, 322 => 0x265 },
	'evfwarmdisplaymode' => { 320 => 0x24b, 321 => 0x24b, 322 => 0x263 },
	'evsteps' => { 364 => '1.2', 366 => 0x0 },
	'evstepsize' => { 309 => '5.1', 310 => '6.1', 311 => '6.1', 315 => '0.7' },
	'exclusivecoverage' => { 501 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 533 => 'exclusivityEndDate' },
	'excursiontolerance' => { 136 => 0x82 },
	'executiveproducer' => { 400 => "\xa9xpd" },
	'exif' => { 123 => 'EXIF' },
	'exifbyteorder' => { 123 => 'ExifByteOrder' },
	'exifcamerainfo' => { 134 => 0xe8 },
	'exifimageheight' => { 122 => 0xa003, 517 => 'PixelYDimension' },
	'exifimagewidth' => { 122 => 0xa002, 517 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 123 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 122 => 0x9000, 517 => 'ExifVersion' },
	'exitpupilposition' => { 232 => 0x4, 233 => 0x4, 237 => 0x4 },
	'expirationdate' => { 134 => 0x25, 533 => 'expirationDate' },
	'expirationtime' => { 134 => 0x26 },
	'exposure' => { 122 => 0xfe51, 511 => 'Exposure', 513 => 'Exposure' },
	'exposure2012' => { 511 => 'Exposure2012', 513 => 'Exposure2012' },
	'exposureadj' => { 295 => 0x0 },
	'exposureadj2' => { 295 => 0x12 },
	'exposureadjust' => { 425 => 0xc },
	'exposurebracketingindicatorlast' => { 187 => 0x52 },
	'exposurebracketshotnumber' => { 190 => 0x2d, 446 => 0x2f },
	'exposurebracketstepsize' => { 364 => 0x8 },
	'exposurebracketvalue' => { 239 => 0x19 },
	'exposurecompautocancel' => { 87 => 0x113 },
	'exposurecompensation' => { 79 => 0x6, 96 => 0x0, 122 => 0x9204, 143 => 0x24, 159 => 'ExposureComp', 179 => 'ExposureCompensation', 184 => 0xd, 185 => 0x53, 186 => 0x1e, 190 => 0x49c0, 329 => 0x1006, 383 => 0x16, 392 => 0x402, 422 => 0xa013, 425 => [0xc,0x35,0x4d], 458 => 0x114c, 459 => 0x114c, 460 => 0x1128, 462 => 0x1180, 463 => 0x1038, 464 => 0x230, 465 => 0x230, 466 => 0x223, 517 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 454 => [0x24,0x26,0x2a] },
	'exposurecompensationbutton' => { 248 => 0x794 },
	'exposurecompensationmode' => { 187 => 0x47, 190 => 0x2a },
	'exposurecompensationset' => { 435 => 0x3, 436 => 0x3, 437 => 0x3, 454 => 0x1e },
	'exposurecompensationsetting' => { 187 => 0x1 },
	'exposurecompstepsize' => { 304 => '6.3', 305 => '7.3', 307 => '7.3', 308 => '7.3', 313 => '4.3', 317 => '7.3', 318 => '7.3' },
	'exposurecontrolstep' => { 312 => '6.1', 314 => '6.1' },
	'exposurecontrolstepsize' => { 304 => '6.2', 305 => '7.1', 307 => '7.1', 308 => '7.1', 313 => '4.2', 317 => '7.1', 318 => '7.1', 319 => '7.1', 320 => 0x1b, 321 => 0x1b, 322 => 0x1b },
	'exposurecount' => { 130 => 0x1032 },
	'exposuredelay' => { 248 => 0x800, 320 => 0x2f1 },
	'exposuredelaymode' => { 304 => '10.1', 305 => '11.1', 307 => '11.1', 308 => '11.1', 309 => '9.1', 310 => '10.1', 311 => '10.1', 313 => '10.4', 314 => '10.1', 315 => '6.4', 317 => '11.1', 318 => '11.1', 319 => '11.2' },
	'exposuredifference' => { 239 => 0xe },
	'exposuregaincustom' => { 141 => 0x89c },
	'exposuregaindaylight' => { 141 => 0x898 },
	'exposuregainflash' => { 141 => 0x89b },
	'exposuregainfluorescent' => { 141 => 0x89a },
	'exposuregaintungsten' => { 141 => 0x899 },
	'exposureindex' => { 122 => 0xa215, 517 => 'ExposureIndex' },
	'exposureindicator' => { 187 => 0x50 },
	'exposurelevelincrements' => { 85 => 0x6, 86 => 0x6, 87 => 0x101, 88 => 0x5, 89 => 0x6, 90 => 0x5, 91 => 0x5, 92 => 0x6, 93 => 0x4, 435 => 0x58, 436 => 0x58 },
	'exposurelockused' => { 499 => 'ExposureLockUsed' },
	'exposuremode' => { 122 => 0xa402, 159 => 'ExposureMode', 184 => 0x1, 185 => 0xa, 186 => 0x0, 187 => 0x0, 190 => 0x34, 324 => 0x200, 345 => 0x40d, 425 => 0x8, 449 => 0xb041, 517 => 'ExposureMode' },
	'exposuremodeinmanual' => { 87 => 0x10b },
	'exposureprogram' => { 122 => 0x8822, 415 => 0x1001, 428 => [0x17e,0x43], 435 => 0x3c, 436 => 0x3c, 437 => 0x5, 441 => 0x14, 446 => 0x3f, 454 => 0x2, 458 => 0x1175, 459 => 0x1179, 460 => 0x1155, 461 => 0x11d1, 462 => 0x11ad, 463 => 0x1065, 464 => 0x25d, 465 => 0x25d, 466 => 0x24c, 477 => 0xb, 478 => 0xc, 479 => 0xb, 481 => 0x48, 517 => 'ExposureProgram' },
	'exposureshift' => { 324 => 0x203 },
	'exposurestandardadjustment' => { 449 => 0x202d },
	'exposuretime' => { 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x4, 31 => 0x6, 32 => 0x7, 79 => 0x16, 122 => 0x829a, 140 => 0xfd05, 143 => 0x20, 145 => 0xfa24, 147 => 0xf104, 150 => 0x12, 152 => 0x38, 154 => 0x14, 155 => 0x10, 157 => 0x10, 159 => 'ExposureTime', 184 => 0x9, 185 => 0x35, 186 => 0x48, 187 => 0x8, 190 => 0x49b8, 383 => 0x12, 422 => 0xa018, 425 => [0x32,0x4a], 435 => 0x0, 436 => 0x0, 454 => [0x21,0x23,0x27], 481 => 0x10, 517 => 'ExposureTime' },
	'exposuretime2' => { 425 => [0x33,0x4b] },
	'exposuretuning' => { 239 => 0x1c },
	'exposurevalue' => { 141 => 0x3 },
	'exposurewarning' => { 130 => 0x1302 },
	'exrauto' => { 130 => 0x1033 },
	'exrmode' => { 130 => 0x1034 },
	'extdescraccessibility' => { 524 => 'ExtDescrAccessibility' },
	'extendedmenubanks' => { 244 => 0x120, 245 => 0x120, 246 => 0x114, 247 => 0x124, 248 => 0x124 },
	'extendedshutterspeeds' => { 320 => 0x102, 321 => 0x102, 322 => 0x118 },
	'extendedwbdetect' => { 324 => 0x902 },
	'extender' => { 325 => 0x301 },
	'extenderfirmwareversion' => { 325 => 0x304 },
	'extendermagnification' => { 161 => 'Magnification' },
	'extendermake' => { 161 => 'Make' },
	'extendermodel' => { 161 => 'Model', 325 => 0x303 },
	'extenderserialnumber' => { 161 => 'SerialNumber', 325 => 0x302 },
	'extenderstatus' => { 381 => 0x3 },
	'externalflash' => { 327 => 0x1201 },
	'externalflashae1' => { 329 => 0x101f },
	'externalflashae1_0' => { 329 => 0x101b },
	'externalflashae2' => { 329 => 0x1020 },
	'externalflashae2_0' => { 329 => 0x101c },
	'externalflashbounce' => { 327 => 0x1204, 329 => 0x1026, 371 => 0x1a },
	'externalflashcompensation' => { 219 => 0x1b },
	'externalflashexposurecomp' => { 239 => 0x17, 371 => 0x19 },
	'externalflashfirmware' => { 217 => 0x6, 218 => 0x6, 219 => 0x6, 220 => 0x6, 221 => 0x6, 222 => 0x6 },
	'externalflashflags' => { 217 => 0x8, 218 => 0x8, 219 => 0x8, 220 => 0x8, 222 => 0x8 },
	'externalflashguidenumber' => { 327 => 0x1203, 371 => '24.1' },
	'externalflashgvalue' => { 329 => 0x1025 },
	'externalflashmode' => { 329 => 0x1028, 371 => 0x2 },
	'externalflashreadystate' => { 221 => '9.1' },
	'externalflashstatus' => { 221 => '8.2' },
	'externalflashzoom' => { 327 => 0x1205, 329 => 0x1027 },
	'externalflashzoomoverride' => { 221 => '8.1' },
	'externalmetadatalink' => { 525 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 343 => 0x311, 346 => 0x311, 347 => 0x311, 350 => 0x3408 },
	'extrainfoversion' => { 439 => 0x1a },
	'eyestartaf' => { 187 => 0x40 },
	'fac100per' => { 141 => 0xe94 },
	'fac170per' => { 141 => 0xe93 },
	'fac18per' => { 141 => 0xe92 },
	'face10position' => { 113 => 0x3f4, 114 => 0x1ec, 215 => 0x28, 368 => 0x12 },
	'face10size' => { 369 => 0x12 },
	'face11position' => { 215 => 0x2c, 368 => 0x14 },
	'face11size' => { 369 => 0x14 },
	'face12position' => { 215 => 0x30, 368 => 0x16 },
	'face12size' => { 369 => 0x16 },
	'face13position' => { 368 => 0x18 },
	'face13size' => { 369 => 0x18 },
	'face14position' => { 368 => 0x1a },
	'face14size' => { 369 => 0x1a },
	'face15position' => { 368 => 0x1c },
	'face15size' => { 369 => 0x1c },
	'face16position' => { 368 => 0x1e },
	'face16size' => { 369 => 0x1e },
	'face17position' => { 368 => 0x20 },
	'face17size' => { 369 => 0x20 },
	'face18position' => { 368 => 0x22 },
	'face18size' => { 369 => 0x22 },
	'face19position' => { 368 => 0x24 },
	'face19size' => { 369 => 0x24 },
	'face1position' => { 56 => 0x8, 113 => 0xd, 114 => 0x18, 215 => 0x4, 340 => 0x1, 368 => 0x0, 412 => 0xbc, 442 => 0x1, 443 => 0x0, 444 => 0x0, 445 => 0x5b },
	'face1size' => { 369 => 0x0 },
	'face20position' => { 368 => 0x26 },
	'face20size' => { 369 => 0x26 },
	'face21position' => { 368 => 0x28 },
	'face21size' => { 369 => 0x28 },
	'face22position' => { 368 => 0x2a },
	'face22size' => { 369 => 0x2a },
	'face23position' => { 368 => 0x2c },
	'face23size' => { 369 => 0x2c },
	'face24position' => { 368 => 0x2e },
	'face24size' => { 369 => 0x2e },
	'face25position' => { 368 => 0x30 },
	'face25size' => { 369 => 0x30 },
	'face26position' => { 368 => 0x32 },
	'face26size' => { 369 => 0x32 },
	'face27position' => { 368 => 0x34 },
	'face27size' => { 369 => 0x34 },
	'face28position' => { 368 => 0x36 },
	'face28size' => { 369 => 0x36 },
	'face29position' => { 368 => 0x38 },
	'face29size' => { 369 => 0x38 },
	'face2position' => { 56 => 0xa, 113 => 0x7c, 114 => 0x4c, 215 => 0x8, 340 => 0x5, 368 => 0x2, 412 => 0xc8, 442 => 0x6, 443 => 0x20, 444 => 0x25, 445 => 0x65 },
	'face2size' => { 369 => 0x2 },
	'face30position' => { 368 => 0x3a },
	'face30size' => { 369 => 0x3a },
	'face31position' => { 368 => 0x3c },
	'face31size' => { 369 => 0x3c },
	'face32position' => { 368 => 0x3e },
	'face32size' => { 369 => 0x3e },
	'face3position' => { 56 => 0xc, 113 => 0xeb, 114 => 0x80, 215 => 0xc, 340 => 0x9, 368 => 0x4, 412 => 0xd4, 442 => 0xb, 443 => 0x40, 444 => 0x4a, 445 => 0x6f },
	'face3size' => { 369 => 0x4 },
	'face4position' => { 56 => 0xe, 113 => 0x15a, 114 => 0xb4, 215 => 0x10, 340 => 0xd, 368 => 0x6, 412 => 0xe0, 442 => 0x10, 443 => 0x60, 444 => 0x6f, 445 => 0x79 },
	'face4size' => { 369 => 0x6 },
	'face5position' => { 56 => 0x10, 113 => 0x1c9, 114 => 0xe8, 215 => 0x14, 340 => 0x11, 368 => 0x8, 412 => 0xec, 442 => 0x15, 443 => 0x80, 444 => 0x94 },
	'face5size' => { 369 => 0x8 },
	'face6position' => { 56 => 0x12, 113 => 0x238, 114 => 0x11c, 215 => 0x18, 368 => 0xa, 412 => 0xf8, 442 => 0x1a, 443 => 0xa0, 444 => 0xb9 },
	'face6size' => { 369 => 0xa },
	'face7position' => { 56 => 0x14, 113 => 0x2a7, 114 => 0x150, 215 => 0x1c, 368 => 0xc, 412 => 0x104, 442 => 0x1f, 443 => 0xc0, 444 => 0xde },
	'face7size' => { 369 => 0xc },
	'face8position' => { 56 => 0x16, 113 => 0x316, 114 => 0x184, 215 => 0x20, 368 => 0xe, 412 => 0x110, 442 => 0x24, 443 => 0xe0, 444 => 0x103 },
	'face8size' => { 369 => 0xe },
	'face9position' => { 56 => 0x18, 113 => 0x385, 114 => 0x1b8, 215 => 0x24, 368 => 0x10 },
	'face9size' => { 369 => 0x10 },
	'facebalanceorigi' => { 505 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 505 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 505 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 505 => 'FaceBalanceWarmth' },
	'facedetect' => { 383 => 0x76, 422 => 0x100 },
	'facedetectarea' => { 328 => 0x1201 },
	'facedetectframecrop' => { 328 => 0x1207 },
	'facedetectframesize' => { 56 => 0x3, 113 => 0x1, 114 => 0x4, 215 => 0x1, 328 => 0x1203, 383 => 0x77, 412 => 0xb6 },
	'facedetection' => { 437 => 0x30, 454 => 0x19 },
	'faceelementpositions' => { 130 => 0x4203 },
	'faceelementselected' => { 130 => 0x4005 },
	'faceelementtypes' => { 130 => 0x4201 },
	'faceid' => { 507 => 'FaceID' },
	'faceinfounknown' => { 116 => 0x2089 },
	'facename' => { 422 => 0x123 },
	'faceorientation' => { 114 => 0x8 },
	'faceposition' => { 367 => 0x2, 423 => 0x4 },
	'facepositions' => { 130 => 0x4103 },
	'facerecognition' => { 422 => 0x120 },
	'facesdetected' => { 56 => 0x2, 57 => 0x2, 58 => 0x3, 113 => 0x0, 114 => 0x2, 116 => 0x211c, 130 => 0x4100, 215 => 0x3, 328 => 0x1200, 348 => 0x3f, 367 => 0x0, 412 => 0xb5, 423 => 0x0, 442 => 0x0, 445 => 0x3, 457 => 0x30 },
	'facesrecognized' => { 341 => 0x0 },
	'facewidth' => { 57 => 0x1 },
	'fade' => { 449 => 0x2034 },
	'faithfuloutputhighlightpoint' => { 112 => 0x38 },
	'faithfuloutputshadowpoint' => { 112 => 0x39 },
	'faithfulrawcolortone' => { 112 => 0x31 },
	'faithfulrawcontrast' => { 112 => 0x33 },
	'faithfulrawhighlight' => { 112 => 0x79 },
	'faithfulrawhighlightpoint' => { 112 => 0x36 },
	'faithfulrawlinear' => { 112 => 0x34 },
	'faithfulrawsaturation' => { 112 => 0x32 },
	'faithfulrawshadow' => { 112 => 0x82 },
	'faithfulrawshadowpoint' => { 112 => 0x37 },
	'faithfulrawsharpness' => { 112 => 0x35 },
	'faithfulunsharpmaskfineness' => { 112 => 0xac },
	'faithfulunsharpmaskstrength' => { 112 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 112 => 0xae },
	'far' => { 496 => 'Far' },
	'fastresetlinetime' => { 141 => 0x1860 },
	'feedidentifier' => { 525 => 'FeedIdentifier' },
	'femicroadjustment' => { 87 => 0x111 },
	'ffid' => { 515 => 'ffid' },
	'field' => { 529 => 'field' },
	'fieldcount' => { 329 => 0x103f },
	'fieldofview' => { 408 => "FOV\x00" },
	'fifoenonepixeldelay' => { 141 => 0x1901 },
	'filecreatedate' => { 123 => 'FileCreateDate' },
	'filedatarate' => { 540 => 'fileDataRate' },
	'fileformat' => { 98 => 0x0, 135 => 0x14, 425 => [0x22,0x26], 449 => 0xb000 },
	'filegroupid' => { 123 => 'FileGroupID' },
	'fileindex' => { 7 => 0x143, 9 => 0x2d0, 11 => 0x172, 13 => 0x22c, 14 => 0x133, 15 => 0x13f, 16 => 0x1d3, 17 => 0x19b, 18 => 0x1e4, 19 => 0xd0, 20 => 0x1bb, 21 => 0x28c, 22 => 0x1db, 23 => 0x1d9, 24 => [0x270,0x274], 25 => 0x2aa, 26 => 0x2b3, 28 => 0x1eb, 29 => 0x4ae, 30 => 0xb2d, 349 => 0x0 },
	'fileindex2' => { 21 => 0x290 },
	'filemodifydate' => { 123 => 'FileModifyDate' },
	'filename' => { 123 => 'FileName' },
	'filenameasdelivered' => { 334 => 'FileNameAsDelivered' },
	'filenumber' => { 59 => 0x1, 66 => 0x8, 100 => 0x1817, 117 => 'Canon-FileNumber', 216 => 0x4, 411 => 0x10 },
	'filenumbermemory' => { 184 => 0x1a },
	'filenumbersequence' => { 304 => '12.2', 309 => '3.1', 310 => '4.1', 311 => '4.1', 313 => '11.1', 314 => '4.3', 319 => '5.2', 320 => 0x48, 321 => 0x48, 322 => 0x48 },
	'filepermissions' => { 123 => 'FilePermissions' },
	'filesource' => { 122 => 0xa300, 130 => 0x8000, 517 => 'FileSource' },
	'fileuserid' => { 123 => 'FileUserID' },
	'fileversion' => { 135 => 0x16 },
	'fillflashautoreduction' => { 85 => 0xe, 86 => 0xe, 93 => 0xa },
	'filllight' => { 511 => 'FillLight', 513 => 'FillLight' },
	'fillorder' => { 122 => 0x10a },
	'filmgraineffect' => { 324 => 0x538 },
	'filmmode' => { 130 => 0x1401, 345 => 0x412, 348 => 0x42 },
	'filmtype' => { 263 => 0x2 },
	'filtereffect' => { 59 => 0xe, 255 => 0x37, 256 => 0x3f, 257 => 0x47, 348 => 0xa1 },
	'filtereffectauto' => { 73 => 0xa0 },
	'filtereffectfaithful' => { 72 => 0x70, 73 => 0x70 },
	'filtereffectlandscape' => { 72 => 0x40, 73 => 0x40 },
	'filtereffectmonochrome' => { 19 => 0xff, 72 => 0x88, 73 => 0x88 },
	'filtereffectneutral' => { 72 => 0x58, 73 => 0x58 },
	'filtereffectportrait' => { 72 => 0x28, 73 => 0x28 },
	'filtereffectstandard' => { 72 => 0x10, 73 => 0x10 },
	'filtereffectuserdef1' => { 72 => 0xa0, 73 => 0xb8 },
	'filtereffectuserdef2' => { 72 => 0xb8, 73 => 0xd0 },
	'filtereffectuserdef3' => { 72 => 0xd0, 73 => 0xe8 },
	'finderdisplayduringexposure' => { 86 => 0x1 },
	'finesharpness' => { 383 => 0x70 },
	'finetuneoptcenterweighted' => { 304 => '7.2', 305 => '9.1', 307 => '9.1', 308 => '9.1', 312 => '8.1', 317 => '9.1', 318 => '9.1', 319 => '9.1', 320 => 0x23, 321 => 0x23, 322 => 0x23 },
	'finetuneopthighlightweighted' => { 307 => '46.1', 308 => '46.1', 317 => '46.1', 318 => '46.1', 320 => 0x27, 321 => 0x27, 322 => 0x27 },
	'finetuneoptmatrixmetering' => { 304 => '8.1', 305 => '8.2', 307 => '8.2', 308 => '8.2', 312 => '7.2', 313 => '6.1', 317 => '8.2', 318 => '8.2', 319 => '8.2', 320 => 0x21, 321 => 0x21, 322 => 0x21 },
	'finetuneoptspotmetering' => { 304 => '8.2', 305 => '9.2', 307 => '9.2', 308 => '9.2', 312 => '8.2', 313 => '6.2', 317 => '9.2', 318 => '9.2', 319 => '9.2', 320 => 0x25, 321 => 0x25, 322 => 0x25 },
	'finishexposure' => { 141 => 0xdbd },
	'finishfiletype' => { 141 => 0xdb8 },
	'finishlook' => { 141 => 0xdbc },
	'finishnoise' => { 141 => 0xdba },
	'finishresolution' => { 141 => 0xdb9 },
	'finishsharpening' => { 141 => 0xdbb },
	'firmware' => { 329 => 0x405, 425 => [0x8c,0x17,0x3b], 508 => 'Firmware' },
	'firmware2' => { 425 => 0x57 },
	'firmwaredate' => { 115 => 0x15, 116 => 0x2001, 409 => 0x4, 411 => 0x30 },
	'firmwareid' => { 191 => 0x0 },
	'firmwarename' => { 422 => 0xa001 },
	'firmwarerevision' => { 19 => 0xa4, 66 => 0x1e, 413 => 0x0 },
	'firmwarerevision2' => { 413 => 0xc },
	'firmwareversion' => { 7 => 0x10b, 11 => 0x136, 14 => 0xff, 15 => 0x107, 141 => [0x415,0xce5], 157 => 0x57, 159 => 'FirmwareVersion', 346 => 0x320, 348 => 0x2, 350 => 0x3109, 383 => 0x230, 408 => ['CNFV','FIRM','info'], 410 => 0x18, 411 => 0x2a, 415 => 0x2 },
	'firmwareversions' => { 392 => 0x301 },
	'firstphotodate' => { 499 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 334 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 134 => 0x16, 506 => 'FixtureIdentifier' },
	'flash' => { 117 => 'XMP-Flash', 122 => 0x9209, 155 => 0x22, 185 => 0x1f, 186 => 0x15, 411 => 0x5a, 517 => 'Flash' },
	'flashaction' => { 435 => 0x3e, 436 => 0x3e, 449 => 0x2017, 454 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 435 => 0x4c, 436 => 0x4c, 454 => 0x77 },
	'flashactionexternal' => { 454 => [0x78,0x7c] },
	'flashactivity' => { 36 => 0x1c },
	'flashbatterylevel' => { 46 => 0x249 },
	'flashbias' => { 348 => 0x24 },
	'flashbits' => { 36 => 0x1d },
	'flashburstpriority' => { 320 => 0x111, 321 => 0x111, 322 => 0x129 },
	'flashbuttonfunction' => { 87 => 0x70e },
	'flashchargelevel' => { 329 => 0x1010 },
	'flashcolorfilter' => { 219 => 0x10, 220 => 0x10, 222 => 0x10 },
	'flashcommandermode' => { 217 => '9.1', 218 => '9.1', 219 => '9.1', 220 => '9.1', 222 => '9.1' },
	'flashcompensation' => { 141 => 0x3f3, 217 => 0xa, 218 => 0xa, 219 => 0xa, 220 => 0x27, 221 => 0xa, 222 => 0xa, 508 => 'FlashCompensation' },
	'flashcontrol' => { 435 => 0x23, 436 => 0x1f, 437 => 0x21 },
	'flashcontrolbuilt-in' => { 313 => '16.1', 314 => '23.1', 316 => '23.1', 317 => '24.1' },
	'flashcontrolmode' => { 217 => '9.2', 218 => '9.2', 219 => '9.2', 220 => '9.2', 222 => '9.2', 228 => 0x214, 243 => 0x148, 244 => 0x1b8, 245 => 0x1b8, 246 => 0x1a8, 247 => 0x1bc, 248 => 0x1bc, 324 => 0x404 },
	'flashcurtain' => { 348 => 0x48 },
	'flashdefault' => { 187 => 0x42 },
	'flashdevice' => { 329 => 0x1005 },
	'flashdistance' => { 116 => 0x2034 },
	'flashenergy' => { 122 => 0xa20b, 517 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 239 => 0x18 },
	'flashexposurecomp' => { 79 => 0xf, 130 => 0x1011, 162 => 'ExposureComp', 184 => 0x23, 189 => 0x104, 190 => 0x49c1, 239 => 0x12, 324 => 0x401, 329 => 0x1023, 383 => 0x4d, 415 => 0x100b, 425 => [0x3a,0x56], 449 => 0x104 },
	'flashexposurecomp2' => { 284 => 0x4d2 },
	'flashexposurecomp3' => { 219 => 0x1d },
	'flashexposurecomp4' => { 219 => 0x27 },
	'flashexposurecomparea' => { 305 => '38.4', 307 => '38.4', 308 => '38.4', 317 => '38.4', 318 => '38.4', 320 => 0x59, 321 => 0x59, 322 => 0x59 },
	'flashexposurecompset' => { 187 => 0x10, 356 => 0xe, 435 => 0x14, 436 => 0x12, 437 => 0x23, 454 => 0x1f },
	'flashexposurecompset2' => { 454 => [0x26,0x2c] },
	'flashexposureindicator' => { 187 => 0x54 },
	'flashexposureindicatorlast' => { 187 => 0x56 },
	'flashexposureindicatornext' => { 187 => 0x55 },
	'flashexposurelock' => { 59 => 0x19 },
	'flashfired' => { 143 => 0x5d, 162 => 'Fired', 184 => 0x14, 283 => '590.3', 517 => [\'Flash','FlashFired'] },
	'flashfiring' => { 87 => 0x306, 88 => 0x6, 89 => 0x7, 92 => 0x7 },
	'flashfirmwareversion' => { 325 => 0x1002 },
	'flashfocallength' => { 217 => 0xb, 218 => 0xc, 219 => 0xc, 220 => 0xc, 221 => 0xc, 222 => 0x26 },
	'flashfunction' => { 190 => 0x31, 517 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 217 => 0xe, 218 => 0xf, 219 => 0xf, 220 => 0xf, 221 => 0xf, 222 => 0xf, 228 => 0x21a, 243 => 0x14e, 246 => 0x1ae, 247 => 0x1c2, 248 => 0x1c2 },
	'flashgroupacompensation' => { 217 => 0x11, 218 => 0x12, 219 => 0x13, 220 => 0x28, 221 => 0x28, 222 => 0x28 },
	'flashgroupacontrolmode' => { 217 => 0xf, 218 => '16.1', 219 => '17.1', 220 => '17.1', 221 => '17.1', 222 => '17.1' },
	'flashgroupaoutput' => { 217 => 0x11, 218 => 0x12, 219 => 0x13, 220 => 0x28, 221 => 0x28, 222 => 0x28 },
	'flashgroupbcompensation' => { 217 => 0x12, 218 => 0x13, 219 => 0x14, 220 => 0x29, 221 => 0x29, 222 => 0x29 },
	'flashgroupbcontrolmode' => { 217 => 0x10, 218 => '17.1', 219 => '18.1', 220 => '18.1', 221 => '18.1', 222 => '18.1' },
	'flashgroupboutput' => { 217 => 0x12, 218 => 0x13, 219 => 0x14, 220 => 0x29, 221 => 0x29, 222 => 0x29 },
	'flashgroupccompensation' => { 218 => 0x14, 219 => 0x15, 220 => 0x2a, 221 => 0x2a, 222 => 0x2a },
	'flashgroupccontrolmode' => { 218 => '17.2', 219 => '18.2', 220 => '18.2', 221 => '18.2', 222 => '18.2' },
	'flashgroupcoutput' => { 218 => 0x14, 219 => 0x15, 220 => 0x2a, 221 => 0x2a, 222 => 0x2a },
	'flashguidenumber' => { 79 => 0xd, 97 => 0x0, 162 => 'GuideNumber' },
	'flashilluminationpattern' => { 222 => 0x25 },
	'flashintensity' => { 115 => [0x19,0x5], 324 => 0x405 },
	'flashlevel' => { 306 => 0x9, 449 => 0xb048 },
	'flashmake' => { 162 => 'Make' },
	'flashmanufacturer' => { 181 => 'FlashManufacturer' },
	'flashmastercompensation' => { 228 => 0x22e, 243 => 0x162, 246 => 0x1aa, 247 => 0x1be, 248 => 0x1be },
	'flashmastercontrolmode' => { 228 => 0x22c, 243 => 0x160 },
	'flashmasteroutput' => { 228 => 0x232, 243 => 0x166 },
	'flashmetering' => { 184 => 0x3f, 187 => 0x1c },
	'flashmeteringmode' => { 7 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 18 => 0x15, 20 => 0x15, 22 => 0x15, 28 => 0x15 },
	'flashmeteringsegments' => { 383 => 0x20a },
	'flashmode' => { 115 => 0x4, 141 => 0x3f2, 143 => 0x5c, 154 => 0x27, 162 => 'Mode', 184 => 0x2, 185 => 0x20, 186 => 0x16, 187 => 0xf, 239 => 0x87, 324 => 0x400, 329 => 0x1004, 383 => 0xc, 390 => 0x4, 414 => 0x20, 415 => 0x100a, 424 => 0x225, 435 => 0x13, 436 => 0x7f, 437 => 0x20, 454 => 0x10, 458 => 0x1138, 459 => 0x1138, 460 => 0x1114, 461 => 0x1190, 462 => 0x116c, 463 => 0x1024, 464 => 0x21c, 465 => 0x21c, 466 => 0x211, 517 => [\'Flash','FlashMode'] },
	'flashmodebutton' => { 248 => 0x80e },
	'flashmodebuttonplaybackmode' => { 248 => 0x818 },
	'flashmodel' => { 162 => 'Model', 181 => 'FlashModel', 325 => 0x1001 },
	'flashoptions' => { 364 => 0x2 },
	'flashoptions2' => { 364 => 0x10 },
	'flashoutput' => { 46 => 0x248, 79 => 0x21, 217 => 0xa, 218 => 0xa, 219 => 0xa, 220 => 0x27, 222 => 0x21, 228 => 0x21e, 243 => 0x152, 246 => 0x1b2, 247 => 0x1c6, 248 => 0x1c6 },
	'flashpixversion' => { 122 => 0xa000, 517 => 'FlashpixVersion' },
	'flashredeyemode' => { 517 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 228 => 0x228, 243 => 0x15c, 246 => 0x1bc, 324 => 0x403 },
	'flashreturn' => { 517 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 162 => 'SerialNumber', 325 => 0x1003 },
	'flashsetting' => { 239 => 0x8 },
	'flashshutterspeed' => { 304 => '20.2', 305 => '23.2', 307 => '23.2', 308 => '23.2', 313 => '15.2', 314 => '22.2', 315 => '7.2', 316 => '22.2', 317 => '23.2', 318 => '23.2', 319 => '23.1', 320 => 0x57, 321 => 0x57, 322 => 0x57 },
	'flashsource' => { 217 => 0x4, 218 => 0x4, 219 => 0x4, 220 => 0x4, 221 => 0x4, 222 => 0x4 },
	'flashstatus' => { 371 => 0x0, 454 => [0x82,0x86], 468 => 0x31, 469 => 0x39, 470 => 0x39 },
	'flashstatusbuilt-in' => { 437 => [0x87,0x287] },
	'flashstatusexternal' => { 437 => [0x88,0x288] },
	'flashsyncspeed' => { 304 => '20.1', 305 => '23.1', 307 => '23.1', 308 => '23.1', 313 => '15.1', 314 => '22.1', 316 => '22.1', 317 => '23.1', 318 => '23.1', 320 => 0x53, 321 => 0x53, 322 => 0x53 },
	'flashsyncspeedav' => { 85 => 0x3, 87 => 0x10f, 88 => 0x2, 89 => 0x3, 90 => 0x2, 91 => 0x2, 92 => 0x3, 93 => 0x6 },
	'flashthreshold' => { 97 => 0x1 },
	'flashtype' => { 162 => 'Type', 187 => 0x59, 239 => 0x9, 325 => 0x1000 },
	'flashwarning' => { 314 => '30.1', 315 => '7.1', 319 => '31.1', 348 => 0x62 },
	'flashwirelessoption' => { 228 => 0x234, 243 => 0x15a, 246 => 0x1c8 },
	'flexiblespotposition' => { 449 => 0x201d },
	'flickadvancedirection' => { 320 => 0x25f, 321 => 0x25f, 322 => 0x277 },
	'flickerreduce' => { 424 => 0x218 },
	'flickerreduction' => { 130 => 0x1446, 267 => 0x7 },
	'flickerreductionindicator' => { 262 => 0x532 },
	'flickerreductionshooting' => { 244 => 0x1b4, 245 => 0x1b4, 246 => 0x1a4, 247 => 0x1b8, 248 => 0x1b8 },
	'flightpitchdegree' => { 119 => 'FlightPitchDegree' },
	'flightrolldegree' => { 119 => 'FlightRollDegree' },
	'flightxspeed' => { 119 => 'FlightXSpeed' },
	'flightyawdegree' => { 119 => 'FlightYawDegree' },
	'flightyspeed' => { 119 => 'FlightYSpeed' },
	'flightzspeed' => { 119 => 'FlightZSpeed' },
	'fliphorizontal' => { 297 => 0x76a43206 },
	'fnumber' => { 7 => 0x3, 9 => 0x3, 11 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x3, 31 => 0x5, 32 => 0x6, 79 => 0x15, 122 => 0x829d, 140 => 0xfd04, 143 => 0x1e, 145 => 0xfa23, 147 => 0xf103, 150 => 0x13, 152 => 0x3c, 154 => 0x1c, 155 => 0x18, 157 => 0xc, 166 => 'FNumber', 184 => 0xa, 185 => 0x36, 186 => 0x47, 187 => 0x9, 190 => 0x49c7, 237 => 0x38, 347 => 0x35a, 383 => 0x13, 422 => 0xa019, 425 => [0x31,0x49], 435 => 0x1, 436 => 0x1, 454 => [0x20,0x22,0x26], 517 => 'FNumber' },
	'focaldistance' => { 497 => 'FocalDistance' },
	'focallength' => { 7 => 0x1d, 8 => 0xa, 9 => 0x23, 10 => 0x9, 11 => 0x1d, 12 => 0x9, 13 => 0x1e, 14 => 0x1d, 15 => 0x1d, 16 => 0x1e, 17 => 0x1e, 18 => 0x1e, 19 => 0x28, 20 => 0x1e, 21 => 0x23, 22 => 0x1e, 23 => 0x1e, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x23, 28 => 0x1e, 29 => 0x23, 61 => 0x1, 116 => 0x1d, 122 => 0x920a, 150 => 0x1d, 166 => 'FocalLength', 184 => 0x12, 232 => 0xa, 233 => 0xb, 237 => [0xc,0x3c], 342 => 0x1, 383 => 0x1d, 392 => 0x403, 415 => 0x1500, 434 => 0xe, 462 => 0x1278, 463 => 0x1134, 464 => 0x32c, 465 => 0x32c, 466 => 0x30a, 517 => 'FocalLength' },
	'focallength2' => { 454 => [0x23,0x25,0x29] },
	'focallength35mm' => { 338 => 'FocalLength35mm' },
	'focallengthin35mmformat' => { 122 => 0xa405, 422 => 0xa01a, 517 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 434 => 0x10 },
	'focalplaneafpointarea' => { 467 => 0x2 },
	'focalplaneafpointlocation1' => { 467 => 0x6 },
	'focalplaneafpointlocation10' => { 467 => 0x2a },
	'focalplaneafpointlocation11' => { 467 => 0x2e },
	'focalplaneafpointlocation12' => { 467 => 0x32 },
	'focalplaneafpointlocation13' => { 467 => 0x36 },
	'focalplaneafpointlocation14' => { 467 => 0x3a },
	'focalplaneafpointlocation15' => { 467 => 0x3e },
	'focalplaneafpointlocation2' => { 467 => 0xa },
	'focalplaneafpointlocation3' => { 467 => 0xe },
	'focalplaneafpointlocation4' => { 467 => 0x12 },
	'focalplaneafpointlocation5' => { 467 => 0x16 },
	'focalplaneafpointlocation6' => { 467 => 0x1a },
	'focalplaneafpointlocation7' => { 467 => 0x1e },
	'focalplaneafpointlocation8' => { 467 => 0x22 },
	'focalplaneafpointlocation9' => { 467 => 0x26 },
	'focalplaneafpointsused' => { 467 => 0x1 },
	'focalplanediagonal' => { 325 => 0x103, 329 => 0x205 },
	'focalplaneresolutionunit' => { 122 => 0xa210, 517 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 122 => 0xa20e, 517 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 61 => 0x2 },
	'focalplanexunknown' => { 61 => 0x2 },
	'focalplaneyresolution' => { 122 => 0xa20f, 517 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 61 => 0x3 },
	'focalplaneyunknown' => { 61 => 0x3 },
	'focalpointx' => { 497 => 'FocalPointX' },
	'focalpointy' => { 497 => 'FocalPointY' },
	'focaltype' => { 10 => 0x2d, 61 => 0x0 },
	'focalunits' => { 36 => 0x19 },
	'focus' => { 286 => 0x8 },
	'focusarea' => { 184 => 0x31 },
	'focusareaselection' => { 315 => '15.2' },
	'focusbracket' => { 348 => 0xbd },
	'focusbracketstepsize' => { 324 => 0x308 },
	'focuscontinuous' => { 36 => 0x20 },
	'focusdisplayaiservoandmf' => { 87 => 0x515 },
	'focusdistance' => { 166 => 'FocusDistance', 184 => 0x13, 190 => 0x49bb, 232 => 0x9, 233 => 0xa, 237 => [0xb,0x4e], 327 => 0x305, 342 => 0x0, 346 => 0x304, 347 => 0x304 },
	'focusdistancelower' => { 7 => 0x45, 9 => 0x8e, 11 => 0x45, 13 => 0x56, 14 => 0x45, 15 => 0x45, 16 => 0x52, 17 => 0x52, 18 => 0x56, 20 => 0x52, 21 => 0x8e, 22 => 0x59, 23 => 0x57, 24 => 0x8e, 25 => 0x94, 26 => 0x95, 27 => 0xa7, 28 => 0x56, 29 => 0xa7, 59 => 0x15, 79 => 0x14 },
	'focusdistancerange' => { 1 => 0xc },
	'focusdistancerangewidth' => { 237 => 0x4c },
	'focusdistanceupper' => { 7 => 0x43, 9 => 0x8c, 11 => 0x43, 13 => 0x54, 14 => 0x43, 15 => 0x43, 16 => 0x50, 17 => 0x50, 18 => 0x54, 20 => 0x50, 21 => 0x8c, 22 => 0x57, 23 => 0x55, 24 => 0x8c, 25 => 0x92, 26 => 0x93, 27 => 0xa5, 28 => 0x54, 29 => 0xa5, 59 => 0x14, 79 => 0x13 },
	'focusholdbutton' => { 187 => 0x44 },
	'focusinfoversion' => { 327 => 0x0 },
	'focusingscreen' => { 86 => 0x0, 87 => 0x80b, 92 => 0x0 },
	'focuslocation' => { 449 => 0x2027 },
	'focuslocation2' => { 449 => 0x204a },
	'focuslocked' => { 183 => 0x14 },
	'focusmode' => { 36 => 0x7, 115 => 0x3, 116 => [0x3003,0xd], 130 => 0x1021, 141 => 0x3f5, 143 => 0x38, 159 => 'FocusMode', 184 => 0x30, 186 => 0xe, 187 => 0xc, 239 => 0x7, 324 => 0x301, 329 => 0x100b, 348 => 0x7, 383 => 0xd, 390 => 0x3, 415 => 0x1006, 428 => [0xb,0x5], 434 => [0x15,0x1d], 435 => 0x4d, 436 => 0x4d, 449 => [0xb042,0xb04e,0x201b], 454 => 0x13, 475 => 0x16 },
	'focusmode2' => { 129 => '0.1', 364 => '3.1', 454 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 306 => '10.1', 432 => 0x14, 433 => 0x15, 435 => 0x10, 436 => 0xf, 437 => 0x6 },
	'focusmodeswitch' => { 187 => 0x58, 435 => 0x2e },
	'focuspeakingdisplay' => { 320 => 0x235, 321 => 0x235, 322 => 0x24d },
	'focuspeakinghighlightcolor' => { 320 => 0x4b, 321 => 0x4b, 322 => 0x4b },
	'focuspeakinglevel' => { 320 => 0x49, 321 => 0x49, 322 => 0x49 },
	'focuspixel' => { 130 => 0x1023 },
	'focuspointlock' => { 320 => 0x1d3, 321 => 0x1d3, 322 => 0x1eb },
	'focuspointpersistence' => { 320 => 0x105, 321 => 0x105, 322 => 0x11b },
	'focuspointwrap' => { 304 => '2.2', 305 => '2.2', 307 => '2.1', 308 => '2.1', 312 => '1.1', 313 => '2.2', 314 => '1.1', 317 => '2.2', 318 => '2.1', 319 => '2.5', 320 => 0x16, 321 => 0x16, 322 => 0x16 },
	'focusposition' => { 1 => 0x2f, 232 => 0x8, 233 => 0x8, 383 => 0x10, 446 => 0x9bb },
	'focusposition2' => { 454 => [0x29,0x2b,0x2f], 475 => 0x2d, 478 => 0x20 },
	'focuspositionhorizontal' => { 196 => 0x2f, 197 => 0x43 },
	'focuspositionvertical' => { 196 => 0x31, 197 => 0x45 },
	'focusprocess' => { 324 => 0x302 },
	'focusrange' => { 36 => 0x12, 329 => 0x100a },
	'focusrangeindex' => { 374 => '3.1' },
	'focusresult' => { 197 => 0x4a },
	'focusringrotation' => { 87 => 0x713 },
	'focussetting' => { 425 => 0x6 },
	'focusshiftautoreset' => { 247 => 0x6da, 248 => 0x748 },
	'focusshiftexposurelock' => { 228 => 0x1b4, 243 => 0xe8, 244 => 0x100, 245 => 0x100, 246 => 0xf4, 247 => 0x104, 248 => 0x104 },
	'focusshiftinterval' => { 228 => 0x1b0, 243 => 0xe4, 244 => 0xfc, 245 => 0xfc, 246 => 0xf0, 247 => 0x100, 248 => 0x100 },
	'focusshiftnumbershots' => { 228 => 0x1a8, 243 => 0xdc, 244 => 0xf4, 245 => 0xf4, 246 => 0xe8, 247 => 0xf8, 248 => 0xf8 },
	'focusshiftshooting' => { 265 => 0x20 },
	'focusshiftstepwidth' => { 228 => 0x1ac, 243 => 0xe0, 244 => 0xf8, 245 => 0xf8, 246 => 0xec, 247 => 0xfc, 248 => 0xfc },
	'focusstatus' => { 434 => 0x19, 435 => 0x53, 436 => 0x53 },
	'focusstepcount' => { 327 => 0x301, 329 => 0x100e },
	'focusstepinfinity' => { 327 => 0x303, 329 => 0x103b },
	'focusstepnear' => { 327 => 0x304, 329 => 0x103c },
	'focusstepsfrominfinity' => { 237 => 0x58 },
	'focustrackinglockon' => { 304 => ['1.5','4.1'], 305 => '1.4', 312 => '0.4', 313 => '3.1', 314 => '0.4', 317 => '1.4' },
	'focuswarning' => { 130 => 0x1301 },
	'foldername' => { 184 => 0x27 },
	'foldernumber' => { 435 => 0x9a, 437 => [0x402,0x114,0x316] },
	'fontcomposite' => { 545 => [\'Fonts','FontsComposite'] },
	'fontface' => { 545 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 545 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 545 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 545 => [\'Fonts','FontsFontName'] },
	'fonts' => { 545 => 'Fonts' },
	'fonttype' => { 545 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 545 => [\'Fonts','FontsVersionString'] },
	'for' => { 399 => 'For' },
	'forcewrite' => { 123 => 'ForceWrite' },
	'format' => { 408 => "\xa9fmt", 496 => 'Format', 514 => 'format', 538 => 'Format' },
	'forwardlock' => { 535 => 'forwardlock' },
	'forwardmatrix1' => { 122 => 0xc714 },
	'forwardmatrix2' => { 122 => 0xc715 },
	'forwardmatrix3' => { 122 => 0xcd34 },
	'fossilspecimen' => { 121 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 121 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 69 => [0x2,0x4] },
	'frameheight' => { 130 => 0x3822 },
	'framenum' => { 394 => 0xd7 },
	'framenumber' => { 130 => 0x8003, 190 => 0x3c, 383 => 0x29 },
	'framerate' => { 69 => [0x1,0x6], 122 => 0xc764, 130 => 0x3820 },
	'framereadouttime' => { 402 => 'camera.framereadouttimeinmicroseconds' },
	'framewidth' => { 130 => 0x3821 },
	'framing' => { 529 => 'framing' },
	'freebytes' => { 100 => 0x1 },
	'freememorycardimages' => { 185 => [0x37,0x54], 186 => [0x2d,0x4a], 187 => 0x32 },
	'frontfacingcamera' => { 1 => 0x45 },
	'fujiflashmode' => { 130 => 0x1010 },
	'fujimodel' => { 130 => 0x1447 },
	'fujimodel2' => { 130 => 0x1448 },
	'fullhdhighspeedrec' => { 130 => 0x3824 },
	'fullimagesize' => { 449 => 0xb02b },
	'fullpanoheightpixels' => { 499 => 'FullPanoHeightPixels', 500 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 499 => 'FullPanoWidthPixels', 500 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 415 => 0x100d },
	'fullsizeimage' => { 165 => 'data' },
	'fullsizeimagename' => { 165 => '1Name' },
	'fullsizeimagetype' => { 165 => '0Type' },
	'func1button' => { 307 => '14.1', 308 => '14.1', 318 => '14.1', 320 => 0x63, 321 => 0x63, 322 => 0x63 },
	'func1buttonplaybackmode' => { 320 => 0x1a5, 321 => 0x1a5, 322 => 0x1bd },
	'func1buttonplusdials' => { 307 => '42.1', 308 => '42.1', 318 => '42.1' },
	'func2button' => { 307 => '80.1', 308 => '80.1', 318 => '80.1', 320 => 0x73, 321 => 0x73, 322 => 0x73 },
	'func2buttonplaybackmode' => { 320 => 0x1a7, 321 => 0x1a7, 322 => 0x1bf },
	'func2buttonplusdials' => { 307 => '81.1' },
	'func3button' => { 307 => '83.1', 321 => 0x119, 322 => 0x131 },
	'func3buttonplaybackmode' => { 321 => 0x1a9, 322 => 0x1c1 },
	'func4button' => { 321 => 0x175, 322 => 0x18d },
	'func4buttonplaybackmode' => { 321 => 0x1af, 322 => 0x1c7 },
	'funcbutton' => { 304 => ['14.1','15.1'], 305 => '14.1', 313 => '28.1', 314 => '13.1', 317 => '14.1', 319 => '14.1' },
	'funcbuttonplusdials' => { 304 => ['14.2','15.2'], 305 => '14.2', 313 => '31.1', 317 => '42.1' },
	'functionbutton' => { 311 => '13.1', 315 => '5.2' },
	'gainbase' => { 328 => 0x610 },
	'gaincontrol' => { 122 => 0xa407, 517 => 'GainControl' },
	'gainmapmax' => { 522 => 'GainMapMax' },
	'gainmapmin' => { 522 => 'GainMapMin' },
	'gamma' => { 122 => 0xa500, 141 => 0x8fe, 335 => 'gAMA', 353 => 0x11c, 518 => 'Gamma', 522 => 'Gamma' },
	'gammablackpoint' => { 108 => 0xc },
	'gammacolortone' => { 108 => 0x3 },
	'gammacompensatedvalue' => { 136 => 0x91 },
	'gammacontrast' => { 108 => 0x2 },
	'gammacurveoutputrange' => { 108 => 0xf },
	'gammahighlight' => { 108 => 0xa },
	'gammalinear' => { 106 => 0x20200 },
	'gammamidpoint' => { 108 => 0xe },
	'gammasaturation' => { 108 => 0x4 },
	'gammashadow' => { 108 => 0x9 },
	'gammasharpnessstrength' => { 108 => 0x8 },
	'gammaunsharpmaskfineness' => { 108 => 0x6 },
	'gammaunsharpmaskstrength' => { 108 => 0x5 },
	'gammaunsharpmaskthreshold' => { 108 => 0x7 },
	'gammawhitepoint' => { 108 => 0xd },
	'garminsettings' => { 408 => 'pmcc' },
	'garminsoftware' => { 408 => 'uuid' },
	'gdalmetadata' => { 122 => 0xa480 },
	'gdalnodata' => { 122 => 0xa481 },
	'geimagesize' => { 130 => 0x1304 },
	'gemake' => { 132 => 0x300 },
	'gemodel' => { 132 => 0x207 },
	'genre' => { 400 => ['gnre',"\xa9gen"], 402 => 'genre', 408 => ['gnre',"\xa9gen"], 525 => 'Genre', 530 => 'genre', 540 => 'genre' },
	'genrecvid' => { 525 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 525 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 525 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 525 => [\'Genre','GenreCvTermRefinedAbout'] },
	'genreid' => { 400 => 'geID' },
	'geography' => { 531 => 'geography' },
	'geolocate' => { 123 => 'Geolocate' },
	'geologicalcontext' => { 121 => 'GeologicalContext' },
	'geologicalcontextbed' => { 121 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 121 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 121 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 121 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 121 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 123 => 'Geosync' },
	'geotag' => { 123 => 'Geotag' },
	'geotiffasciiparams' => { 122 => 0x87b1 },
	'geotiffdirectory' => { 122 => 0x87af },
	'geotiffdoubleparams' => { 122 => 0x87b0 },
	'geotime' => { 123 => 'Geotime' },
	'giftftppriority' => { 501 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 119 => 'GimbalPitchDegree' },
	'gimbalreverse' => { 119 => 'GimbalReverse' },
	'gimbalrolldegree' => { 119 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 119 => 'GimbalYawDegree' },
	'globalaltitude' => { 397 => 0x419 },
	'globalangle' => { 397 => 0x40d },
	'good' => { 540 => 'good' },
	'googlehostheader' => { 400 => 'gshh' },
	'googlepingmessage' => { 400 => 'gspm' },
	'googlepingurl' => { 400 => 'gspu' },
	'googleplusuploadcode' => { 122 => 0x9009 },
	'googlesourcedata' => { 400 => 'gssd' },
	'googlestarttime' => { 400 => 'gsst' },
	'googletrackduration' => { 400 => 'gstd' },
	'goprotype' => { 408 => 'GoPr' },
	'gpsaltitude' => { 133 => 0x6, 163 => 'Altitude', 517 => 'GPSAltitude' },
	'gpsaltituderef' => { 133 => 0x5, 517 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 133 => 0x1c, 517 => 'GPSAreaInformation' },
	'gpscoordinates' => { 400 => "\xa9xyz", 402 => 'location.ISO6709', 408 => ['@xyz',"\xa9xyz"] },
	'gpsdatestamp' => { 133 => 0x1d },
	'gpsdatetime' => { 163 => 'DateTime', 517 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 133 => 0x18, 163 => 'Bearing', 517 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 133 => 0x17, 517 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 133 => 0x1a, 163 => 'Distance', 517 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 133 => 0x19, 517 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 133 => 0x14, 517 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 133 => 0x13 },
	'gpsdestlongitude' => { 133 => 0x16, 517 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 133 => 0x15 },
	'gpsdifferential' => { 133 => 0x1e, 163 => 'Differential', 517 => 'GPSDifferential' },
	'gpsdop' => { 133 => 0xb, 517 => 'GPSDOP' },
	'gpshpositioningerror' => { 133 => 0x1f, 517 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 133 => 0x11, 517 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 133 => 0x10, 517 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 117 => 'GPS-GPSLatitude', 119 => 'GpsLatitude', 133 => 0x2, 163 => 'Latitude', 517 => 'GPSLatitude' },
	'gpslatituderef' => { 133 => 0x1 },
	'gpslongitude' => { 117 => 'GPS-GPSLongitude', 119 => 'GpsLongitude', 133 => 0x4, 163 => 'Longitude', 517 => 'GPSLongitude' },
	'gpslongituderef' => { 133 => 0x3 },
	'gpslongtitude' => { 119 => 'GpsLongtitude' },
	'gpsmapdatum' => { 133 => 0x12, 163 => 'Datum', 517 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 133 => 0xa, 163 => 'MeasureMode', 517 => 'GPSMeasureMode' },
	'gpsposition' => { 117 => 'Exif-GPSPosition' },
	'gpsprocessingmethod' => { 133 => 0x1b, 517 => 'GPSProcessingMethod' },
	'gpssatellites' => { 133 => 0x8, 163 => 'Satellites', 517 => 'GPSSatellites' },
	'gpsspeed' => { 133 => 0xd, 163 => 'Speed', 517 => 'GPSSpeed' },
	'gpsspeedref' => { 133 => 0xc, 517 => 'GPSSpeedRef' },
	'gpsstatus' => { 133 => 0x9, 517 => 'GPSStatus' },
	'gpsstring' => { 141 => 0x402 },
	'gpstimestamp' => { 133 => 0x7 },
	'gpstrack' => { 133 => 0xf, 163 => 'Heading', 517 => 'GPSTrack' },
	'gpstrackref' => { 133 => 0xe, 517 => 'GPSTrackRef' },
	'gpsversionid' => { 133 => 0x0, 517 => 'GPSVersionID' },
	'gradation' => { 324 => 0x50f },
	'gradientbasedcorractive' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrblacks2012' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'] },
	'gradientbasedcorrbrightness' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrcorrectionname' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'] },
	'gradientbasedcorrcorrectionsyncid' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'] },
	'gradientbasedcorrdefringe' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrdehaze' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'] },
	'gradientbasedcorrections' => { 511 => 'GradientBasedCorrections', 513 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'] },
	'gradientbasedcorrluminancenoise' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskinputdigest' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'gradientbasedcorrmaskleft' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmaskactive' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'gradientbasedcorrmaskmaskblendmode' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmaskdigest' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'gradientbasedcorrmaskmaskinverted' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'gradientbasedcorrmaskmaskname' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'] },
	'gradientbasedcorrmaskmasks' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'] },
	'gradientbasedcorrmaskmasksalpha' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'gradientbasedcorrmaskmasksangle' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'gradientbasedcorrmaskmasksbottom' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'gradientbasedcorrmaskmaskscentervalue' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'gradientbasedcorrmaskmaskscenterweight' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'gradientbasedcorrmaskmasksdabs' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'gradientbasedcorrmaskmasksfeather' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'gradientbasedcorrmaskmasksflipped' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'gradientbasedcorrmaskmasksflow' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'gradientbasedcorrmaskmasksfullx' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'gradientbasedcorrmaskmasksfully' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'gradientbasedcorrmaskmasksinputdigest' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'gradientbasedcorrmaskmasksleft' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'gradientbasedcorrmaskmasksmaskactive' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'gradientbasedcorrmaskmasksmaskblendmode' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmasksmaskdigest' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'gradientbasedcorrmaskmasksmaskinverted' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'gradientbasedcorrmaskmasksmaskname' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'gradientbasedcorrmaskmasksmasksubtype' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksmasksyncid' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'gradientbasedcorrmaskmasksmaskversion' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'gradientbasedcorrmaskmasksmidpoint' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'gradientbasedcorrmaskmasksorigin' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'gradientbasedcorrmaskmasksperimetervalue' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'gradientbasedcorrmaskmasksradius' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'gradientbasedcorrmaskmasksreferencepoint' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'gradientbasedcorrmaskmasksright' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'gradientbasedcorrmaskmasksroundness' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'gradientbasedcorrmaskmaskssizex' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'gradientbasedcorrmaskmaskssizey' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'gradientbasedcorrmaskmaskstop' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'gradientbasedcorrmaskmasksubtype' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksvalue' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'gradientbasedcorrmaskmasksversion' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'gradientbasedcorrmaskmaskswhat' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'gradientbasedcorrmaskmaskswholeimagearea' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'gradientbasedcorrmaskmasksx' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'] },
	'gradientbasedcorrmaskmasksy' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'] },
	'gradientbasedcorrmaskmasksyncid' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'gradientbasedcorrmaskmaskszerox' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'gradientbasedcorrmaskmaskszeroy' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'gradientbasedcorrmaskmaskversion' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'gradientbasedcorrmaskmidpoint' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskorigin' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'] },
	'gradientbasedcorrmaskperimetervalue' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskrange' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'gradientbasedcorrmaskrangeareamodels' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrmaskrangeareamodelscolorsampleinfo' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrmaskrangeareamodelscomponents' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrmaskrangecoloramount' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrmaskrangedepthfeather' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrmaskrangedepthmax' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrmaskrangedepthmin' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrmaskrangeinvert' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'gradientbasedcorrmaskrangelumfeather' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrmaskrangeluminancedepthsampleinfo' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrmaskrangelummax' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrmaskrangelummin' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrmaskrangelumrange' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrmaskrangesampletype' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrmaskrangetype' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'gradientbasedcorrmaskrangeversion' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'gradientbasedcorrmaskreferencepoint' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'gradientbasedcorrmaskright' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskwholeimagearea' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'gradientbasedcorrmaskx' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrrangemask' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'] },
	'gradientbasedcorrrangemaskareamodels' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrrangemaskareamodelscolorsampleinfo' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrrangemaskareamodelscomponents' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrrangemaskcoloramount' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrrangemaskdepthfeather' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrrangemaskdepthmax' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrrangemaskdepthmin' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrrangemaskinvert' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'gradientbasedcorrrangemasklumfeather' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrrangemaskluminancedepthsampleinfo' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrrangemasklummax' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrrangemasklummin' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrrangemasklumrange' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrrangemasksampletype' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrrangemasktype' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'] },
	'gradientbasedcorrrangemaskversion' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'gradientbasedcorrsaturation' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'] },
	'gradientbasedcorrshadows2012' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtexture' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'] },
	'gradientbasedcorrtint' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrtoninghue' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrtoningsaturation' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrwhat' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'gradientbasedcorrwhites2012' => { 511 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'], 513 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'] },
	'grainamount' => { 511 => 'GrainAmount', 513 => 'GrainAmount' },
	'graineffectroughness' => { 130 => 0x1047 },
	'graineffectsize' => { 130 => 0x104c },
	'grainfrequency' => { 511 => 'GrainFrequency', 513 => 'GrainFrequency' },
	'grainseed' => { 511 => 'GrainSeed', 513 => 'GrainSeed' },
	'grainsize' => { 511 => 'GrainSize', 513 => 'GrainSize' },
	'graymixeraqua' => { 511 => 'GrayMixerAqua', 513 => 'GrayMixerAqua' },
	'graymixerblue' => { 511 => 'GrayMixerBlue', 513 => 'GrayMixerBlue' },
	'graymixergreen' => { 511 => 'GrayMixerGreen', 513 => 'GrayMixerGreen' },
	'graymixermagenta' => { 511 => 'GrayMixerMagenta', 513 => 'GrayMixerMagenta' },
	'graymixerorange' => { 511 => 'GrayMixerOrange', 513 => 'GrayMixerOrange' },
	'graymixerpurple' => { 511 => 'GrayMixerPurple', 513 => 'GrayMixerPurple' },
	'graymixerred' => { 511 => 'GrayMixerRed', 513 => 'GrayMixerRed' },
	'graymixeryellow' => { 511 => 'GrayMixerYellow', 513 => 'GrayMixerYellow' },
	'graypoint' => { 486 => 0x8021 },
	'grayresponseunit' => { 122 => 0x122 },
	'greencurvelimits' => { 111 => 0x1c4 },
	'greencurvepoints' => { 110 => 0x53, 111 => 0x19a },
	'greenghostmitigationstatus' => { 1 => 0x3f },
	'greenhsl' => { 106 => 0x20913 },
	'greenhue' => { 511 => 'GreenHue', 513 => 'GreenHue' },
	'greensaturation' => { 511 => 'GreenSaturation', 513 => 'GreenSaturation' },
	'griddisplay' => { 304 => '13.3', 305 => '4.3', 307 => '4.2', 308 => '4.2', 309 => '2.2', 313 => '10.5', 314 => '3.4', 315 => '6.1', 317 => '4.4', 318 => '4.2', 319 => '4.2' },
	'gripbatteryadload' => { 362 => 0x5 },
	'gripbatteryadnoload' => { 362 => 0x4 },
	'gripbatterystate' => { 362 => '1.2' },
	'group' => { 511 => 'Group', 513 => 'Group' },
	'groupareaafillumination' => { 305 => '46.4', 308 => '47.4', 317 => '47.4' },
	'grouping' => { 400 => ['grup',"\xa9grp"], 408 => "\xa9grp" },
	'guid' => { 400 => 'GUID' },
	'h2resetblackpixels' => { 141 => 0x18a6 },
	'h3resetblackcolumns' => { 141 => 0x18ce },
	'h3resetblackpixels' => { 141 => 0x18b0 },
	'halftonehints' => { 122 => 0x141 },
	'hardlink' => { 123 => 'HardLink' },
	'hasalternative' => { 530 => 'hasAlternative' },
	'hascorrection' => { 530 => 'hasCorrection' },
	'hascorrectiona-lang' => { 530 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 530 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 530 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 511 => 'HasCrop', 513 => 'HasCrop' },
	'hasextendedxmp' => { 542 => 'HasExtendedXMP' },
	'hassettings' => { 511 => 'HasSettings', 513 => 'HasSettings' },
	'hastranslation' => { 530 => 'hasTranslation' },
	'hasvisibleoverprint' => { 545 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 545 => 'HasVisibleTransparency' },
	'hdmioutputn-log' => { 243 => 0x35a },
	'hdmioutputresolution' => { 244 => 0x710, 245 => 0x720, 246 => 0x610, 247 => 0x640, 248 => 0x6a8 },
	'hdmiviewassist' => { 321 => 0x20f, 322 => 0x227 },
	'hdr' => { 62 => 0x1, 224 => 0x4, 225 => 0x4, 244 => 0x23a, 245 => 0x23a, 248 => 0x23a, 348 => 0x9e, 383 => 0x85, 449 => 0x200a },
	'hdrcapacitymax' => { 522 => 'HDRCapacityMax' },
	'hdrcapacitymin' => { 522 => 'HDRCapacityMin' },
	'hdreditmode' => { 511 => 'HDREditMode', 513 => 'HDREditMode' },
	'hdreffect' => { 62 => 0x2 },
	'hdrgain' => { 1 => 0x30 },
	'hdrheadroom' => { 1 => 0x21 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrlevel' => { 224 => 0x5, 225 => 0x5, 244 => 0x246, 245 => 0x246, 248 => 0x246, 437 => 0x2e, 454 => 0x17 },
	'hdrlevel2' => { 224 => 0x7 },
	'hdrplusmakernote' => { 494 => 'HdrPlusMakernote' },
	'hdrpmakernote' => { 494 => 'hdrp_makernote' },
	'hdrsetting' => { 437 => 0x2d, 454 => 0x16, 458 => 0x1148, 459 => 0x1148, 460 => 0x1124, 461 => 0x11a0, 462 => 0x117c, 463 => 0x1034, 464 => 0x22c, 465 => 0x22c, 466 => 0x21f },
	'hdrsmoothing' => { 224 => 0x6 },
	'hdvideo' => { 400 => 'hdvd' },
	'headline' => { 134 => 0x69, 525 => 'Headline', 528 => 'Headline' },
	'hiddendatalength' => { 447 => 0x1 },
	'hiddendataoffset' => { 447 => 0x0 },
	'hierarchicalkeywords' => { 174 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 174 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 174 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 174 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 174 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 174 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 503 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 121 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highframerate' => { 244 => 0x48, 245 => 0x48, 247 => 0x48, 248 => 0x48 },
	'highfrequencyflickerreduction' => { 244 => 0x27c, 245 => 0x27c, 247 => 0x27c, 248 => 0x27c },
	'highisomultiplierblue' => { 353 => 0x1a },
	'highisomultipliergreen' => { 353 => 0x19 },
	'highisomultiplierred' => { 353 => 0x18 },
	'highisonoisereduction' => { 16 => 0xbc, 17 => 0xbd, 20 => 0xbd, 28 => 0xc9, 64 => 0x5, 87 => 0x202, 239 => 0xb1, 383 => 0x71, 435 => 0x2c, 436 => 0x26, 437 => 0x26, 449 => 0x2009, 454 => 0x12, 481 => 0x42 },
	'highisonoisereduction2' => { 449 => 0xb050 },
	'highlight' => { 425 => 0xf },
	'highlight2012' => { 511 => 'Highlight2012', 513 => 'Highlight2012' },
	'highlightadj' => { 106 => 0x2030c },
	'highlightcolordistortreduct' => { 486 => 0x8026 },
	'highlightlinearitylimit' => { 422 => 0xa025 },
	'highlightprotection' => { 296 => 0x6 },
	'highlightrecovery' => { 511 => 'HighlightRecovery', 513 => 'HighlightRecovery' },
	'highlights' => { 449 => 0x2033, 505 => 'Highlights' },
	'highlights2012' => { 511 => 'Highlights2012', 513 => 'Highlights2012' },
	'highlightsadj' => { 486 => 0x9019 },
	'highlightshadow' => { 348 => 0xad },
	'highlighttone' => { 130 => 0x1041 },
	'highlighttonepriority' => { 13 => 0x7, 16 => 0x7, 17 => 0x7, 18 => 0x7, 20 => 0x7, 22 => 0x7, 28 => 0x7, 64 => 0x3, 87 => 0x203 },
	'highlightwarning' => { 348 => 0x8002 },
	'highlowkeyadj' => { 383 => 0x6c },
	'highspeedsync' => { 187 => 0x5, 320 => 0x55, 321 => 0x55, 322 => 0x55, 435 => 0x2, 436 => 0x2 },
	'hintversion' => { 408 => 'hinv' },
	'histogramxml' => { 297 => 0x83a1a25 },
	'history' => { 528 => 'History', 541 => 'History' },
	'historyaction' => { 541 => [\'History','HistoryAction'] },
	'historychanged' => { 541 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 541 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 541 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 541 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 541 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 141 => 0xc88 },
	'holefilldeltathreshold' => { 141 => 0xc7e },
	'hometowncity' => { 116 => 0x3006, 383 => 0x23, 389 => 0x2 },
	'hometowncitycode' => { 390 => 0x1000 },
	'hometowndst' => { 383 => 0x25, 389 => '0.2' },
	'hostcomputer' => { 122 => 0x13c },
	'hostsoftwarerendering' => { 141 => 0xce7 },
	'hue' => { 192 => 0x3b, 256 => 0x3d, 257 => 0x45, 383 => 0x67 },
	'hueadj' => { 300 => 0x2f, 486 => 0x8019 },
	'hueadjust' => { 415 => 0x1016 },
	'hueadjustment' => { 185 => 0x4a, 186 => 0x40, 239 => 0x92, 255 => 0x36 },
	'hueadjustmentaqua' => { 511 => 'HueAdjustmentAqua', 513 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 511 => 'HueAdjustmentBlue', 513 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 511 => 'HueAdjustmentGreen', 513 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 511 => 'HueAdjustmentMagenta', 513 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 511 => 'HueAdjustmentOrange', 513 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 511 => 'HueAdjustmentPurple', 513 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 511 => 'HueAdjustmentRed', 513 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 511 => 'HueAdjustmentYellow', 513 => 'HueAdjustmentYellow' },
	'huesetting' => { 332 => 0x1011 },
	'humanobservation' => { 121 => 'HumanObservation' },
	'humanobservationday' => { 121 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 121 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 121 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 121 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 121 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 121 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 121 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationfieldnotes' => { 121 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 121 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 121 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 121 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 121 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 121 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 121 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 121 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 121 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 121 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 121 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 121 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 121 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 122 => 0x9401, 518 => 'Humidity' },
	'icc_profile' => { 123 => 'ICC_Profile' },
	'iccprofilename' => { 528 => 'ICCProfile' },
	'iconuri' => { 408 => 'icnu' },
	'idccreativestyle' => { 486 => 0x8000 },
	'idcpreviewlength' => { 486 => 0x202 },
	'idcpreviewstart' => { 486 => 0x201 },
	'identification' => { 121 => 'Identification' },
	'identificationid' => { 121 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 121 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 121 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 121 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 121 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 121 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifiedbyid' => { 121 => [\'Identification','IdentificationIdentifiedByID'] },
	'identifier' => { 514 => 'identifier', 538 => 'Identifier' },
	'ifcameramodel' => { 141 => 0x9c8 },
	'illuminantdata1' => { 122 => 0xcd35 },
	'illuminantdata2' => { 122 => 0xcd36 },
	'illuminantdata3' => { 122 => 0xcd37 },
	'illumination' => { 315 => '0.5', 410 => 0x48 },
	'imageabsolutex' => { 141 => 0x3fe },
	'imageabsolutey' => { 141 => 0x3ff },
	'imageadjustment' => { 239 => 0x80, 286 => 0x5 },
	'imagealterationconstraints' => { 334 => 'ImageAlterationConstraints' },
	'imagearea' => { 229 => 0x2b, 264 => 0x2b, 272 => 0x10, 275 => 0x10 },
	'imageareaoffset' => { 383 => 0x38 },
	'imageauthentication' => { 239 => 0x20 },
	'imageboundary' => { 239 => 0x16 },
	'imagecapturerequestid' => { 1 => 0x20 },
	'imagecapturetype' => { 1 => 0x14 },
	'imagecount' => { 130 => 0x1438, 239 => 0xa5, 452 => 0x11b },
	'imagecreator' => { 334 => 'ImageCreator' },
	'imagecreatorid' => { 334 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 334 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 334 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 141 => 0x41f },
	'imagecropy' => { 141 => 0x420 },
	'imagedata' => { 498 => 'Data' },
	'imagedatasize' => { 239 => 0xa2 },
	'imagedescription' => { 122 => 0x10e, 536 => 'ImageDescription' },
	'imageduplicationconstraints' => { 334 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 297 => 0xfe443a45 },
	'imageeditcount' => { 383 => 0x41 },
	'imageediting' => { 383 => 0x32 },
	'imageeditingsoftware' => { 122 => 0xa43b },
	'imageeditor' => { 122 => 0xa438 },
	'imageeffects' => { 415 => 0x1010 },
	'imagefileconstraints' => { 334 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 334 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 334 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 130 => 0x1436 },
	'imageheight' => { 122 => 0x101, 191 => 0xc, 392 => 0x10d, 496 => 'ImageHeight', 536 => 'ImageLength' },
	'imagehistory' => { 122 => 0x9213, 516 => 'ImageHistory' },
	'imageidnumber' => { 343 => 0x340 },
	'imagemimetype' => { 498 => 'Mime' },
	'imagenumber' => { 122 => 0x9211, 159 => 'ImageNumber', 185 => 0xae, 186 => 0x5e, 392 => 0x113, 435 => 0x9b, 437 => [0x400,'276.1',0x314], 508 => 'ImageNumber' },
	'imagenumber2' => { 186 => 0x62 },
	'imageoptimization' => { 239 => 0xa9 },
	'imageorientation' => { 134 => 0x83 },
	'imageprocessing' => { 239 => 0x1a },
	'imageprocessingfiledatecreated' => { 141 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 141 => 0xc80 },
	'imageprocessingflags' => { 1 => 0x19 },
	'imageprocessingversion' => { 328 => 0x0 },
	'imagequality' => { 159 => 'ImageQuality', 274 => '723.2', 275 => '732.2', 283 => '708.1', 348 => 0x1 },
	'imagequality2' => { 324 => 0x603 },
	'imagerank' => { 501 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 141 => 0x600 },
	'imagerboardversion' => { 141 => 0x439 },
	'imagercols' => { 141 => 0x17d4 },
	'imageref' => { 523 => 'ImageRef' },
	'imageregion' => { 525 => 'ImageRegion' },
	'imageregionboundary' => { 525 => [\'ImageRegion','ImageRegionRegionBoundary'] },
	'imageregionboundaryh' => { 525 => [\'ImageRegion','ImageRegionRegionBoundaryRbH'] },
	'imageregionboundaryrx' => { 525 => [\'ImageRegion','ImageRegionRegionBoundaryRbRx'] },
	'imageregionboundaryshape' => { 525 => [\'ImageRegion','ImageRegionRegionBoundaryRbShape'] },
	'imageregionboundaryunit' => { 525 => [\'ImageRegion','ImageRegionRegionBoundaryRbUnit'] },
	'imageregionboundaryvertices' => { 525 => [\'ImageRegion','ImageRegionRegionBoundaryRbVertices'] },
	'imageregionboundaryverticesx' => { 525 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbX'] },
	'imageregionboundaryverticesy' => { 525 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbY'] },
	'imageregionboundaryw' => { 525 => [\'ImageRegion','ImageRegionRegionBoundaryRbW'] },
	'imageregionboundaryx' => { 525 => [\'ImageRegion','ImageRegionRegionBoundaryRbX'] },
	'imageregionboundaryy' => { 525 => [\'ImageRegion','ImageRegionRegionBoundaryRbY'] },
	'imageregionctype' => { 525 => [\'ImageRegion','ImageRegionRCtype'] },
	'imageregionctypeidentifier' => { 525 => [\'ImageRegion','ImageRegionRCtypeIdentifier'] },
	'imageregionctypename' => { 525 => [\'ImageRegion','ImageRegionRCtypeName'] },
	'imageregionid' => { 525 => [\'ImageRegion','ImageRegionRId'] },
	'imageregionname' => { 525 => [\'ImageRegion','ImageRegionName'] },
	'imageregionrole' => { 525 => [\'ImageRegion','ImageRegionRRole'] },
	'imageregionroleidentifier' => { 525 => [\'ImageRegion','ImageRegionRRoleIdentifier'] },
	'imageregionrolename' => { 525 => [\'ImageRegion','ImageRegionRRoleName'] },
	'imageresolution' => { 141 => 0x944 },
	'imageresolutionjpg' => { 141 => 0x945 },
	'imagereview' => { 306 => '0.4', 315 => '0.4' },
	'imagereviewmonitorofftime' => { 305 => '21.1', 307 => '21.1', 308 => '21.1', 312 => '20.1', 317 => '21.1', 318 => '21.1', 320 => 0x39, 321 => 0x39, 322 => 0x39 },
	'imagereviewtime' => { 304 => '25.1', 306 => '2.1', 309 => '19.1', 310 => '20.1', 311 => '20.1', 313 => '9.2', 314 => '20.1', 319 => '21.2' },
	'imagerfiledatecreated' => { 141 => 0x9c5 },
	'imagerfileproductionlevel' => { 141 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 141 => 0x9c7 },
	'imagerotated' => { 154 => 0x2a },
	'imagerpowerondelaymsec' => { 141 => 0x5fd },
	'imagerrows' => { 141 => 0x17de },
	'imagesegmentlines' => { 141 => 0x184d },
	'imagesegmentstartline' => { 141 => 0x184c },
	'imagesequenceinfo' => { 122 => 0xcd44 },
	'imagesize' => { 165 => 'ImageSize' },
	'imagesizeraw' => { 239 => 0x3e },
	'imagesizerestriction' => { 533 => 'imageSizeRestriction' },
	'imagesourcedata' => { 122 => 0x935c },
	'imagespace' => { 141 => 0x909 },
	'imagestabilization' => { 36 => 0x22, 116 => 0x3020, 130 => 0x1422, 159 => 'ImageStabilization', 185 => 0xbd, 186 => 0x71, 187 => 0x57, 188 => 0x0, 189 => [0x18,0x107,0x113], 190 => 0x49c2, 239 => 0xac, 324 => 0x604, 327 => 0x1600, 348 => 0x1a, 440 => 0x12, 441 => 0x11, 449 => 0xb026 },
	'imagestabilization2' => { 439 => 0xa },
	'imagestabilizationsetting' => { 190 => 0x14, 435 => 0x3d, 436 => 0x3d, 446 => 0x14 },
	'imagestats' => { 122 => 0xcd46 },
	'imagestyle' => { 435 => 0x2d, 436 => 0x27 },
	'imagesupplier' => { 334 => 'ImageSupplier' },
	'imagesupplierid' => { 334 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 334 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 334 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 124 => 0x1 },
	'imagetemperaturemin' => { 124 => 0x2 },
	'imagetone' => { 383 => 0x4f },
	'imagetype' => { 134 => 0x82, 334 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 66 => 0x28, 122 => 0xa420, 516 => 'ImageUniqueID', 517 => 'ImageUniqueID' },
	'imagewidth' => { 122 => 0x100, 191 => 0xe, 392 => 0x10c, 496 => 'ImageWidth', 536 => 'ImageWidth' },
	'inclinationangle' => { 486 => 0x900f },
	'inclinationcorrection' => { 486 => 0x900e },
	'incrementaltemperature' => { 511 => 'IncrementalTemperature', 513 => 'IncrementalTemperature' },
	'incrementaltint' => { 511 => 'IncrementalTint', 513 => 'IncrementalTint' },
	'industry' => { 530 => 'industry', 531 => 'industry' },
	'infobuttonwhenshooting' => { 87 => 0x409 },
	'information' => { 402 => 'information', 408 => "\xa9inf" },
	'infourl' => { 408 => 'infu' },
	'infraredilluminator' => { 409 => 0x28 },
	'ingredientexclusion' => { 532 => 'ingredientExclusion' },
	'ingredients' => { 541 => 'Ingredients' },
	'ingredientsalternatepaths' => { 541 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 541 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 541 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 541 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 541 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 541 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 541 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 541 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 541 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 541 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 541 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 541 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 541 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 541 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 541 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 541 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 541 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 541 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 541 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 541 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 541 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 541 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 541 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 87 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 499 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 499 => 'InitialHorizontalFOVDegrees' },
	'initialkey' => { 182 => 'WM/InitialKey' },
	'initialverticalfovdegrees' => { 499 => 'InitialVerticalFOVDegrees' },
	'initialviewheadingdegrees' => { 499 => 'InitialViewHeadingDegrees', 500 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 499 => 'InitialViewPitchDegrees', 500 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 499 => 'InitialViewRollDegrees', 500 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 304 => '4.4' },
	'initialzoomsetting' => { 304 => '9.3', 313 => '27.3' },
	'inkset' => { 122 => 0x14c },
	'inputprofile' => { 141 => 0x1389 },
	'instanceid' => { 541 => 'InstanceID' },
	'instantplaybacksetup' => { 187 => 0x3e },
	'instantplaybacktime' => { 187 => 0x3d },
	'instructions' => { 528 => 'Instructions' },
	'instrument' => { 540 => 'instrument' },
	'integrationtime' => { 141 => 0x423 },
	'intellectualgenre' => { 524 => 'IntellectualGenre' },
	'intelligentauto' => { 449 => 0xb052, 477 => 0xd, 478 => 0xe, 479 => 0xd },
	'intelligentcontrast' => { 54 => 0x4 },
	'intelligentd-range' => { 348 => 0x79 },
	'intelligentexposure' => { 348 => 0x5d },
	'intelligentresolution' => { 348 => 0x70 },
	'interchangecolorspace' => { 136 => 0x40 },
	'intergraphmatrix' => { 122 => 0x8480 },
	'internalflash' => { 184 => 0x2b, 304 => '23.1', 306 => '8.1', 309 => '22.1', 311 => '23.1', 315 => '8.1', 319 => '24.1', 327 => 0x1208 },
	'internalflashae1' => { 329 => 0x1021 },
	'internalflashae1_0' => { 329 => 0x101d },
	'internalflashae2' => { 329 => 0x1022 },
	'internalflashae2_0' => { 329 => 0x101e },
	'internalflashmode' => { 371 => 0x1 },
	'internalflashstrength' => { 371 => 0x3 },
	'internalflashtable' => { 329 => 0x1024 },
	'internallensserialnumber' => { 422 => 0xa005 },
	'internalndfilter' => { 348 => 0x9d },
	'internalserialnumber' => { 66 => 0x96, 78 => 0x9, 130 => 0x10, 190 => 0x49dc, 323 => 0x18, 325 => 0x102, 345 => 0x500, 348 => 0x25, 363 => 0x4, 415 => 0x5, 468 => [0x7c,0xf0], 469 => 0x88, 470 => [0x88,0x8a], 471 => 0x38 },
	'interopindex' => { 122 => 0x1, 518 => 'InteroperabilityIndex' },
	'interopversion' => { 122 => 0x2 },
	'interval' => { 262 => 0x20 },
	'intervaldurationhours' => { 243 => 0xa0, 244 => 0xb8, 245 => 0xb8 },
	'intervaldurationminutes' => { 243 => 0xa4, 244 => 0xbc, 245 => 0xbc },
	'intervaldurationseconds' => { 243 => 0xa8, 244 => 0xc0, 245 => 0xc0 },
	'intervalexposuresmoothing' => { 228 => 0x184, 243 => 0xb8, 244 => 0xd0, 245 => 0xd0 },
	'intervalframe' => { 262 => 0x24 },
	'intervallength' => { 184 => 0x10 },
	'intervalmode' => { 184 => 0x26 },
	'intervalnumber' => { 184 => 0x11 },
	'intervalpriority' => { 228 => 0x186, 243 => 0xba, 244 => 0xd2, 245 => 0xd2 },
	'intervals' => { 228 => 0x17c, 243 => 0xb0, 244 => 0xc8, 245 => 0xc8, 246 => 0xbc, 247 => 0xcc, 248 => 0xcc },
	'intervalshooting' => { 229 => 0x24, 264 => 0x24, 265 => 0x28, 383 => 0x92 },
	'introtime' => { 540 => 'introTime' },
	'introtimescale' => { 540 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 540 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 141 => 0xdae },
	'ipfcameramodel' => { 141 => 0xe4d },
	'iptc' => { 123 => 'IPTC' },
	'iptc-naa' => { 122 => 0x83bb, 353 => 0x83bb },
	'iptcbitspersample' => { 136 => 0x56 },
	'iptcdigest' => { 397 => 0x425 },
	'iptcimageheight' => { 136 => 0x1e },
	'iptcimagerotation' => { 136 => 0x66 },
	'iptcimagewidth' => { 136 => 0x14 },
	'iptclastedited' => { 525 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 136 => 0xa },
	'iptcpixelheight' => { 136 => 0x32 },
	'iptcpixelwidth' => { 136 => 0x28 },
	'isalternativeof' => { 530 => 'isAlternativeOf' },
	'isbn' => { 530 => 'isbn' },
	'iscorrectionof' => { 530 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 112 => 0x3 },
	'ismergedhdr' => { 508 => 'IsMergedHDR' },
	'ismergedpanorama' => { 508 => 'IsMergedPanorama' },
	'iso' => { 7 => 0x6, 9 => 0x6, 10 => 0x75, 11 => 0x6, 12 => 0x79, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x6, 31 => 0x0, 32 => 0x1, 115 => 0x14, 116 => [0x3014,0x14], 122 => 0x8827, 140 => 0xfd06, 141 => 0x1784, 143 => 0x60, 145 => [0xfa2e,0xfa46], 146 => [0x27,0x28], 147 => 0xf105, 150 => 0x14, 152 => 0x4e, 154 => 0x1e, 155 => 0x1a, 157 => 0x34, 159 => 'ISO', 184 => 0x8, 190 => 0x49ba, 227 => 0x0, 239 => 0x2, 348 => 0xd1, 353 => 0x17, 383 => [0x8b,0x14], 390 => 0x14, 392 => 0x105, 422 => 0xa014, 425 => 0x86, 446 => 0x6f, 454 => [0x1f,0x21,0x25], 517 => 'ISOSpeedRatings' },
	'iso2' => { 227 => 0x6, 269 => 0x265, 270 => 0x25c, 271 => 0x265, 272 => 0x221, 273 => 0x25d, 274 => 0x256, 275 => 0x25d, 278 => 0x2b5, 281 => 0x265, 285 => 0x2b5 },
	'isoauto' => { 364 => '14.4' },
	'isoautoflashlimit' => { 244 => 0x156, 245 => 0x156, 246 => 0x146, 247 => 0x15a, 248 => 0x15a },
	'isoautohilimit' => { 226 => 0x5, 244 => 0x154, 245 => 0x154, 246 => 0x144, 247 => 0x158, 248 => 0x158, 267 => 0x5, 277 => 0x18eb },
	'isoautomax' => { 448 => 0x4 },
	'isoautomin' => { 448 => 0x2 },
	'isoautominspeed' => { 383 => 0x7a },
	'isoautoshuttertime' => { 226 => 0x4, 244 => 0x15e, 245 => 0x15e, 246 => 0x14e, 247 => 0x162, 248 => 0x162, 267 => 0x4, 277 => 0x18ea },
	'isobutton' => { 248 => 0x796 },
	'isocalibrationgain' => { 141 => 0x89f },
	'isodisplay' => { 307 => '4.1', 308 => '4.1', 309 => '2.3', 310 => '3.3', 311 => '3.3', 314 => '3.3', 317 => '4.3', 318 => '4.1', 319 => '4.3' },
	'isoexpansion' => { 87 => 0x103, 88 => 0x7, 89 => 0x8, 92 => 0x8, 227 => 0x4 },
	'isoexpansion2' => { 227 => 0xa },
	'isofloor' => { 364 => 0x6 },
	'isoselected' => { 347 => 0x359 },
	'isoselection' => { 239 => 0xf },
	'isosensitivitystep' => { 312 => '6.2', 314 => '6.2' },
	'isosetting' => { 143 => 0x5e, 155 => 0x14, 159 => 'ISOSetting', 184 => 0x24, 185 => 0x26, 186 => 0x1c, 187 => 0x13, 192 => 0x6, 239 => 0x13, 364 => '17.3', 414 => 0x27, 435 => 0x16, 436 => 0x14, 437 => 0x2, 446 => 0x6d, 448 => 0x0 },
	'isospeed' => { 122 => 0x8833, 518 => 'ISOSpeed' },
	'isospeedexpansion' => { 86 => 0x3 },
	'isospeedincrements' => { 87 => 0x102 },
	'isospeedlatitudeyyy' => { 122 => 0x8834, 518 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 122 => 0x8835, 518 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 87 => 0x103 },
	'isostepsize' => { 304 => '6.1', 305 => '7.2', 307 => '7.2', 308 => '7.2', 313 => '4.1', 317 => '7.2', 318 => '7.2', 320 => 0x15d, 321 => 0x15d, 322 => 0x175 },
	'isovalue' => { 329 => 0x1001 },
	'isrc' => { 400 => 'xid ' },
	'isrccode' => { 408 => "\xa9isr" },
	'issn' => { 530 => 'issn' },
	'issueidentifier' => { 530 => 'issueIdentifier' },
	'issuename' => { 530 => 'issueName' },
	'issueteaser' => { 530 => 'issueTeaser' },
	'issuetype' => { 530 => 'issueType' },
	'istranslationof' => { 530 => 'isTranslationOf' },
	'itemsubtype' => { 181 => 'ItemSubType' },
	'itunesu' => { 400 => 'itnu' },
	'jobid' => { 134 => 0xb8 },
	'jobname' => { 519 => 'JobName' },
	'jobref' => { 539 => 'JobRef' },
	'jobrefid' => { 539 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 539 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 539 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 519 => 'JobStatus' },
	'jpeg-heifswitch' => { 449 => 0x2039 },
	'jpeghandling' => { 511 => 'JPEGHandling', 513 => 'JPEGHandling' },
	'jpegquality' => { 10 => 0x66, 348 => 0x43, 350 => 0x3034, 449 => 0xb047 },
	'jpegsize' => { 350 => 0x303a },
	'jpgcompression' => { 230 => 0x24, 239 => 0x44, 272 => '671.1' },
	'jpgfromraw' => { 100 => 0x2007, 117 => 'Exif-JpgFromRaw', 353 => 0x2e },
	'jpgfromrawlength' => { 122 => [0x117,0x202] },
	'jpgfromrawstart' => { 122 => [0x111,0x201] },
	'jpgrecordedpixels' => { 364 => '14.1' },
	'jurisdiction' => { 509 => 'jurisdiction' },
	'keepexposure' => { 320 => 0x237, 321 => 0x237, 322 => 0x24f },
	'kelvinwb_01' => { 372 => 0x5 },
	'kelvinwb_02' => { 372 => 0x9 },
	'kelvinwb_03' => { 372 => 0xd },
	'kelvinwb_04' => { 372 => 0x11 },
	'kelvinwb_05' => { 372 => 0x15 },
	'kelvinwb_06' => { 372 => 0x19 },
	'kelvinwb_07' => { 372 => 0x1d },
	'kelvinwb_08' => { 372 => 0x21 },
	'kelvinwb_09' => { 372 => 0x25 },
	'kelvinwb_10' => { 372 => 0x29 },
	'kelvinwb_11' => { 372 => 0x2d },
	'kelvinwb_12' => { 372 => 0x31 },
	'kelvinwb_13' => { 372 => 0x35 },
	'kelvinwb_14' => { 372 => 0x39 },
	'kelvinwb_15' => { 372 => 0x3d },
	'kelvinwb_16' => { 372 => 0x41 },
	'kelvinwb_daylight' => { 372 => 0x1 },
	'kerneldenominators' => { 141 => 0x933 },
	'key' => { 540 => 'key' },
	'keystonecompensation' => { 328 => 0x1900 },
	'keystonedirection' => { 328 => 0x1901 },
	'keystonevalue' => { 328 => 0x1906 },
	'keyword' => { 400 => 'keyw', 530 => 'keyword' },
	'keywordinfo' => { 174 => 'Keywords' },
	'keywords' => { 134 => 0x19, 160 => 'Keywords', 333 => 'Keywords', 399 => 'Keywords', 402 => 'keywords', 506 => 'keywords', 527 => 'Keywords', 538 => 'Keywords' },
	'killdate' => { 530 => 'killDate' },
	'killdatea-platform' => { 530 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 530 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 140 => 0xf908, 143 => 0xe, 145 => [0xfa1e,0xfa52], 151 => 0x70 },
	'kodakimagewidth' => { 140 => 0xf907, 143 => 0xc, 145 => [0xfa1d,0xfa51], 151 => 0x6c },
	'kodakinfotype' => { 140 => 0xfa00 },
	'kodaklook' => { 141 => 0xe4c },
	'kodaklookprofile' => { 141 => 0x138a },
	'kodakmaker' => { 151 => 0x8 },
	'kodakmodel' => { 143 => 0x0, 151 => 0x28 },
	'kodaktag' => { 141 => 0x3ea },
	'kodakversion' => { 141 => 0x0 },
	'label' => { 337 => 'Label', 538 => 'Label' },
	'labelname1' => { 523 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 523 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 523 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 523 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 523 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 523 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 348 => 0x6f },
	'landscapeoutputhighlightpoint' => { 112 => 0x26 },
	'landscapeoutputshadowpoint' => { 112 => 0x27 },
	'landscaperawcolortone' => { 112 => 0x1f },
	'landscaperawcontrast' => { 112 => 0x21 },
	'landscaperawhighlight' => { 112 => 0x77 },
	'landscaperawhighlightpoint' => { 112 => 0x24 },
	'landscaperawlinear' => { 112 => 0x22 },
	'landscaperawsaturation' => { 112 => 0x20 },
	'landscaperawshadow' => { 112 => 0x80 },
	'landscaperawshadowpoint' => { 112 => 0x25 },
	'landscaperawsharpness' => { 112 => 0x23 },
	'landscapeunsharpmaskfineness' => { 112 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 112 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 112 => 0xa2 },
	'language' => { 244 => 0x6a2, 245 => 0x6a2, 246 => 0x592, 247 => 0x5c2, 248 => 0x5da, 514 => 'language' },
	'languageidentifier' => { 134 => 0x87 },
	'largestvalidinteriorrectheight' => { 499 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 499 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 499 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 499 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 184 => 0x1b },
	'lastkeywordiptc' => { 181 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 181 => 'LastKeywordXMP' },
	'lastphotodate' => { 499 => 'LastPhotoDate' },
	'lasturl' => { 541 => 'LastURL' },
	'lateralchromaticaberration' => { 449 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 508 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 121 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 121 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 121 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 121 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 121 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'latitude' => { 119 => 'Latitude' },
	'lc1' => { 374 => 0x2 },
	'lc10' => { 374 => 0xb },
	'lc11' => { 374 => 0xc },
	'lc12' => { 374 => 0xd },
	'lc14' => { 374 => 0xf },
	'lc15' => { 374 => 0x10 },
	'lc3' => { 374 => 0x4 },
	'lc4' => { 374 => 0x5 },
	'lc5' => { 374 => 0x6 },
	'lc6' => { 374 => 0x7 },
	'lc7' => { 374 => 0x8 },
	'lc8' => { 374 => 0x9 },
	'lcddisplayatpoweron' => { 87 => 0x811, 91 => 0xa },
	'lcddisplayreturntoshoot' => { 92 => 0x12 },
	'lcdillumination' => { 304 => '17.5', 305 => '5.2', 307 => '5.1', 308 => '5.1', 313 => '10.3', 314 => '4.2', 317 => '5.2', 318 => '5.1', 319 => '5.4', 320 => 0x101, 321 => 0x101, 322 => 0x117 },
	'lcdilluminationduringbulb' => { 87 => 0x408 },
	'lcdmatrix' => { 141 => 0xe74 },
	'lcdmatrixchickfix' => { 141 => 0xe75 },
	'lcdmatrixmarvin' => { 141 => 0xe76 },
	'lcdpanels' => { 86 => 0x8 },
	'lcheditor' => { 297 => 0x8ae85e },
	'legacyiptcdigest' => { 528 => 'LegacyIPTCDigest' },
	'legalcode' => { 509 => 'legalcode' },
	'lens' => { 122 => 0xfdea, 239 => 0x84, 508 => 'Lens' },
	'lensafstopbutton' => { 85 => 0x11, 86 => 0x13, 87 => 0x506, 88 => 0x10, 89 => 0x12, 92 => 0x13, 93 => 0x9 },
	'lensaperturerange' => { 425 => [0x30,0x48] },
	'lensblur' => { 511 => 'LensBlur', 513 => 'LensBlur' },
	'lensbluractive' => { 511 => [\'LensBlur','LensBlurActive'], 513 => [\'LensBlur','LensBlurActive'] },
	'lensbluramount' => { 511 => [\'LensBlur','LensBlurBlurAmount'], 513 => [\'LensBlur','LensBlurBlurAmount'] },
	'lensblurbokehaspect' => { 511 => [\'LensBlur','LensBlurBokehAspect'], 513 => [\'LensBlur','LensBlurBokehAspect'] },
	'lensblurbokehrotation' => { 511 => [\'LensBlur','LensBlurBokehRotation'], 513 => [\'LensBlur','LensBlurBokehRotation'] },
	'lensblurbokehshape' => { 511 => [\'LensBlur','LensBlurBokehShape'], 513 => [\'LensBlur','LensBlurBokehShape'] },
	'lensblurbokehshapedetail' => { 511 => [\'LensBlur','LensBlurBokehShapeDetail'], 513 => [\'LensBlur','LensBlurBokehShapeDetail'] },
	'lensblurcateyeamount' => { 511 => [\'LensBlur','LensBlurCatEyeAmount'], 513 => [\'LensBlur','LensBlurCatEyeAmount'] },
	'lensblurcateyescale' => { 511 => [\'LensBlur','LensBlurCatEyeScale'], 513 => [\'LensBlur','LensBlurCatEyeScale'] },
	'lensblurfocalrange' => { 511 => [\'LensBlur','LensBlurFocalRange'], 513 => [\'LensBlur','LensBlurFocalRange'] },
	'lensblurfocalrangesource' => { 511 => [\'LensBlur','LensBlurFocalRangeSource'], 513 => [\'LensBlur','LensBlurFocalRangeSource'] },
	'lensblurhighlightsboost' => { 511 => [\'LensBlur','LensBlurHighlightsBoost'], 513 => [\'LensBlur','LensBlurHighlightsBoost'] },
	'lensblurhighlightsthreshold' => { 511 => [\'LensBlur','LensBlurHighlightsThreshold'], 513 => [\'LensBlur','LensBlurHighlightsThreshold'] },
	'lensblursampledarea' => { 511 => [\'LensBlur','LensBlurSampledArea'], 513 => [\'LensBlur','LensBlurSampledArea'] },
	'lensblursampledrange' => { 511 => [\'LensBlur','LensBlurSampledRange'], 513 => [\'LensBlur','LensBlurSampledRange'] },
	'lensblursphericalaberration' => { 511 => [\'LensBlur','LensBlurSphericalAberration'], 513 => [\'LensBlur','LensBlurSphericalAberration'] },
	'lensblursubjectrange' => { 511 => [\'LensBlur','LensBlurSubjectRange'], 513 => [\'LensBlur','LensBlurSubjectRange'] },
	'lensblurversion' => { 511 => [\'LensBlur','LensBlurVersion'], 513 => [\'LensBlur','LensBlurVersion'] },
	'lenscontrolring' => { 320 => 0xad, 321 => 0xad, 322 => 0xad },
	'lenscorrectionsettings' => { 516 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 508 => 'LensDistortInfo' },
	'lensdistortionparams' => { 329 => 0x206 },
	'lensdriveend' => { 237 => 0x56 },
	'lensdrivenoaf' => { 87 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 437 => 0x3f0, 485 => 0xd },
	'lensfirmware' => { 416 => 0x20, 422 => 0xa004 },
	'lensfirmwareversion' => { 325 => 0x204, 348 => 0x60, 437 => 0x3f3, 485 => 0x14 },
	'lensfocallength' => { 106 => 0xf0512, 374 => 0x9 },
	'lensfocalrange' => { 425 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 305 => '55.1', 307 => '52.1', 308 => '52.1', 317 => '52.1', 318 => '52.1' },
	'lensformat' => { 462 => 0x1891, 464 => 0x18bd, 465 => 0x18ed, 466 => 0x17f1, 468 => 0x106, 469 => 0x106, 480 => 0x603, 481 => 0x5d },
	'lensfstops' => { 231 => 0x7, 232 => 0xc, 233 => 0xd, 237 => 0xe, 239 => 0x8b, 374 => '0.3' },
	'lensfunc1button' => { 320 => 0x9f, 321 => 0x9f, 322 => 0x9f },
	'lensfunc1buttonplaybackmode' => { 245 => 0x80a, 248 => 0x810 },
	'lensfunc2button' => { 320 => 0xa7, 321 => 0xa7, 322 => 0xa7 },
	'lensfunc2buttonplaybackmode' => { 245 => 0x80c, 248 => 0x812 },
	'lensid' => { 237 => 0x30, 508 => 'LensID' },
	'lensidnumber' => { 231 => 0x6, 232 => 0xb, 233 => 0xc, 237 => 0xd },
	'lensinfo' => { 122 => 0xa432, 380 => 0x2a, 508 => 'LensInfo', 518 => 'LensSpecification' },
	'lenskind' => { 374 => 0x1 },
	'lensmake' => { 122 => 0xa433, 166 => 'Make', 518 => 'LensMake' },
	'lensmanualdistortionamount' => { 511 => 'LensManualDistortionAmount', 513 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 181 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 425 => 0x2b },
	'lensmodel' => { 7 => 0x937, 14 => 0x92b, 15 => 0x933, 66 => 0x95, 122 => 0xa434, 166 => 'Model', 181 => 'LensModel', 234 => 0x18a, 235 => 0x18b, 236 => 0x2ac, 325 => 0x203, 380 => 0xc, 392 => 0x412, 518 => 'LensModel' },
	'lensmodulationoptimizer' => { 130 => 0x1045 },
	'lensmount' => { 437 => 0x99, 462 => 0x1892, 464 => 0x18be, 465 => 0x18ee, 466 => 0x17f2, 468 => 0x105, 469 => 0x105, 480 => 0x604, 481 => 0x5e },
	'lensmount2' => { 485 => 0x8 },
	'lensmounttype' => { 237 => 0x35 },
	'lenspositionabsolute' => { 237 => 0x5a },
	'lensprofilechromaticaberrationscale' => { 511 => 'LensProfileChromaticAberrationScale', 513 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 511 => 'LensProfileDigest', 513 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 511 => 'LensProfileDistortionScale', 513 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 511 => 'LensProfileEnable', 513 => 'LensProfileEnable' },
	'lensprofilefilename' => { 511 => 'LensProfileFilename', 513 => 'LensProfileFilename' },
	'lensprofileisembedded' => { 511 => 'LensProfileIsEmbedded', 513 => 'LensProfileIsEmbedded' },
	'lensprofilematchkeycameramodelname' => { 511 => 'LensProfileMatchKeyCameraModelName', 513 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 511 => 'LensProfileMatchKeyExifMake', 513 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 511 => 'LensProfileMatchKeyExifModel', 513 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 511 => 'LensProfileMatchKeyIsRaw', 513 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 511 => 'LensProfileMatchKeyLensID', 513 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 511 => 'LensProfileMatchKeyLensInfo', 513 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 511 => 'LensProfileMatchKeyLensName', 513 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 511 => 'LensProfileMatchKeySensorFormatFactor', 513 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 347 => 0x370, 511 => 'LensProfileName', 513 => 'LensProfileName' },
	'lensprofilesetup' => { 511 => 'LensProfileSetup', 513 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 511 => 'LensProfileVignettingScale', 513 => 'LensProfileVignettingScale' },
	'lensproperties' => { 325 => 0x20b },
	'lensserialnumber' => { 21 => 0x164, 34 => 0x16b, 63 => 0x0, 122 => 0xa435, 166 => 'SerialNumber', 325 => 0x202, 346 => 0x321, 348 => 0x52, 408 => 'LENS', 416 => 0x30, 508 => 'LensSerialNumber', 518 => 'LensSerialNumber' },
	'lensshutterlock' => { 187 => 0x4a },
	'lensspec' => { 432 => 0x0, 433 => 0x0, 434 => 0x0, 449 => 0xb02a },
	'lensspecfeatures' => { 468 => [0x115,0x116], 469 => [0x116,0x1ed,0x1f0,0x21c,0x21e] },
	'lenstemperature' => { 329 => 0x1008 },
	'lenstype' => { 7 => 0xe2, 8 => 0xd, 9 => 0x1a7, 10 => 0xc, 11 => 0x111, 12 => 0xc, 13 => 0x14f, 14 => 0xd6, 15 => 0xde, 16 => 0xf6, 17 => 0xea, 18 => 0xff, 19 => [0xc,0x97], 20 => 0xe6, 21 => 0x153, 22 => 0xea, 23 => 0xe8, 24 => 0x127, 25 => 0x161, 26 => 0x166, 27 => 0x184, 28 => 0x112, 29 => 0x189, 36 => 0x16, 189 => 0x10c, 190 => 0x49bd, 239 => 0x83, 325 => 0x201, 339 => 0x16, 343 => 0x310, 345 => 0x303, 346 => 0x303, 348 => 0x51, 350 => 0x3405, 375 => 0x0, 376 => 0x0, 377 => 0x1, 378 => 0x1, 379 => 0x1, 381 => 0x0, 422 => 0xa003, 425 => 0x27, 449 => 0xb027, 462 => 0x1896, 464 => 0x18c2, 465 => 0x18f2, 466 => 0x17f6, 468 => 0x109, 469 => 0x109, 480 => 0x608, 481 => 0x62 },
	'lenstype2' => { 437 => 0x3f7, 462 => 0x1893, 464 => 0x18bf, 465 => 0x18ef, 466 => 0x17f3, 468 => 0x107, 469 => 0x107, 480 => 0x605, 481 => 0x60 },
	'lenstype3' => { 485 => 0x9 },
	'lenstypemake' => { 348 => 0xc4 },
	'lenstypemodel' => { 348 => [0xc5,0xe4] },
	'lenszoomposition' => { 477 => 0x19, 478 => 0x1e, 481 => [0x342,0x34e,0x35a] },
	'levelindicator' => { 356 => 0x15 },
	'levelmeter' => { 408 => ['Lvlm','lvlm'] },
	'levelorientation' => { 382 => 0x0 },
	'license' => { 509 => 'license' },
	'licensee' => { 334 => 'Licensee' },
	'licenseeid' => { 334 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 334 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 334 => 'LicenseeImageNotes' },
	'licenseename' => { 334 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 334 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 334 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 334 => 'LicenseeTransactionID' },
	'licenseid' => { 334 => 'LicenseID' },
	'licensestartdate' => { 334 => 'LicenseStartDate' },
	'licensetransactiondate' => { 334 => 'LicenseTransactionDate' },
	'licensetype' => { 515 => 'licensetype' },
	'licensor' => { 334 => 'Licensor' },
	'licensorcity' => { 334 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 334 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 334 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 334 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 334 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 334 => 'LicensorImageID' },
	'licensorname' => { 334 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 334 => 'LicensorNotes' },
	'licensorpostalcode' => { 334 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 334 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 334 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 334 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 334 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 334 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 334 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 334 => 'LicensorTransactionID' },
	'licensorurl' => { 334 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 329 => 0x1009 },
	'lightingmode' => { 116 => 0x302a },
	'lightreading' => { 383 => 0x15 },
	'lightsource' => { 122 => 0x9208, 239 => 0x90, 332 => 0x1000, 517 => 'LightSource' },
	'lightsourcespecial' => { 424 => 0x21d },
	'lightswitch' => { 317 => '0.1', 319 => '0.1' },
	'lightvaluecenter' => { 329 => 0x103d },
	'lightvalueperiphery' => { 329 => 0x103e },
	'limitaf-areamodesel3dtracking' => { 320 => 0x153, 321 => 0x153, 322 => 0x16b },
	'limitaf-areamodeseldynamic_l' => { 320 => 0x151, 321 => 0x151, 322 => 0x169 },
	'limitaf-areamodeseldynamic_m' => { 320 => 0x150, 321 => 0x150, 322 => 0x168 },
	'limitaf-areamodeseldynamic_s' => { 320 => 0x14f, 321 => 0x14f, 322 => 0x167 },
	'limitaf-areamodeselpinpoint' => { 320 => 0x11, 321 => 0x11, 322 => 0x11 },
	'limitaf-areamodeselwideaf_l' => { 320 => 0x14, 321 => 0x14, 322 => 0x14 },
	'limitaf-areamodeselwideaf_s' => { 320 => 0x13, 321 => 0x13, 322 => 0x13 },
	'limitafareamodeselauto' => { 320 => 0x15, 321 => 0x15, 322 => 0x15 },
	'limitafareamodeselection' => { 305 => '51.1', 307 => '49.1', 308 => '49.1', 317 => '49.1', 318 => '49.1' },
	'limitreleasemodeselc120' => { 321 => '269.4', 322 => '293.4' },
	'limitreleasemodeselc30' => { 321 => '269.3', 322 => '293.3' },
	'limitreleasemodeselch' => { 321 => '269.2', 322 => '293.2' },
	'limitreleasemodeselcl' => { 321 => '269.1', 322 => '293.1' },
	'limitreleasemodeselself' => { 321 => '269.5', 322 => '293.5' },
	'limitselectableimagearea16to9' => { 320 => 0x47, 321 => 0x47, 322 => 0x47 },
	'limitselectableimagearea1to1' => { 320 => 0x46, 321 => 0x46, 322 => 0x46 },
	'limitselectableimageareadx' => { 320 => 0x45, 321 => 0x45, 322 => 0x45 },
	'linearitylimitblue' => { 353 => 0x10 },
	'linearitylimitgreen' => { 353 => 0xf },
	'linearitylimitred' => { 353 => 0xe },
	'linearityuppermargin' => { 43 => 0x32c, 44 => 0x282, 47 => [0x2ba,0x2d1,0x2d5], 49 => 0x1e5, 50 => [0x1fe,0x2de], 51 => [0x232,0x310], 52 => 0x31e },
	'linearizationtable' => { 122 => 0xc618 },
	'linearresponselimit' => { 122 => 0xc62e },
	'link' => { 530 => 'link' },
	'linkaetoafpoint' => { 364 => '14.2' },
	'linkedencodedrightsexpr' => { 525 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 525 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 525 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 525 => 'LinkedEncRightsExpr' },
	'linlogcoring' => { 141 => 0x904 },
	'lithostratigraphicterms' => { 121 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'livephotoauto' => { 402 => 'live-photo.auto' },
	'livephotovideoindex' => { 1 => 0x17 },
	'livephotovitalityscore' => { 402 => 'live-photo.vitality-score' },
	'livephotovitalityscoringversion' => { 402 => 'live-photo.vitality-scoring-version' },
	'liveviewaf' => { 309 => '32.1', 319 => '34.1' },
	'liveviewafareamode' => { 314 => '34.1' },
	'liveviewafmethod' => { 454 => 0x20 },
	'liveviewafmode' => { 314 => '34.2' },
	'liveviewafsetting' => { 437 => 0x36 },
	'liveviewbuttonoptions' => { 305 => '50.2', 307 => '48.2', 308 => '48.2', 317 => '48.2', 318 => '48.2' },
	'liveviewexposuresimulation' => { 87 => 0x810 },
	'liveviewfocusmode' => { 437 => [0x8b,0x28b] },
	'liveviewmetering' => { 437 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 305 => '21.2', 307 => '21.2', 308 => '21.2', 310 => '20.2', 311 => '20.2', 312 => '20.2', 314 => '20.2', 317 => '21.2', 318 => '21.2' },
	'liveviewshooting' => { 59 => 0x13 },
	'livingspecimen' => { 121 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 121 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 134 => 0x79 },
	'localizedcameramodel' => { 122 => 0xc615 },
	'locallocationname' => { 422 => 0x30 },
	'location' => { 238 => 0x9, 348 => 0x67, 504 => 'Location', 524 => 'Location', 529 => 'location', 530 => 'location' },
	'locationaccuracyhorizontal' => { 402 => 'location.accuracy.horizontal' },
	'locationareacode' => { 510 => 'lac' },
	'locationbody' => { 402 => 'location.body' },
	'locationcreated' => { 525 => 'LocationCreated' },
	'locationcreatedcity' => { 525 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 525 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 525 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 525 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpsaltituderef' => { 525 => [\'LocationCreated','LocationCreatedGPSAltitudeRef'] },
	'locationcreatedgpslatitude' => { 525 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 525 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 525 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 525 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 525 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 525 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 525 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 525 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationdate' => { 402 => 'location.date' },
	'locationinformation' => { 408 => 'loci' },
	'locationinfoversion' => { 238 => 0x0 },
	'locationname' => { 402 => 'location.name', 422 => 0x31 },
	'locationnote' => { 402 => 'location.note' },
	'locationrole' => { 402 => 'location.role' },
	'locationshown' => { 525 => 'LocationShown' },
	'locationshowncity' => { 525 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 525 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 525 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 525 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpsaltituderef' => { 525 => [\'LocationShown','LocationShownGPSAltitudeRef'] },
	'locationshowngpslatitude' => { 525 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 525 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 525 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 525 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 525 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 525 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 525 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 525 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 87 => 0x709 },
	'logcomment' => { 540 => 'logComment' },
	'logscale' => { 141 => 0x902 },
	'longdescription' => { 400 => 'ldes' },
	'longexposurenoisereduction' => { 64 => 0x4, 87 => 0x201, 88 => 0x1, 89 => 0x2, 90 => 0x1, 91 => 0x1, 92 => 0x2, 93 => 0x1, 348 => 0x49, 435 => 0x2b, 436 => 0x25, 437 => 0x25, 449 => 0x2008, 454 => 0x11, 481 => 0x44 },
	'longexposurenoisereduction2' => { 59 => 0x8 },
	'longexposurenrused' => { 348 => 0xbe },
	'longitude' => { 119 => 'Longitude' },
	'look' => { 511 => 'Look', 513 => 'Look' },
	'lookamount' => { 511 => [\'Look','LookAmount'], 513 => [\'Look','LookAmount'] },
	'lookcluster' => { 511 => [\'Look','LookCluster'], 513 => [\'Look','LookCluster'] },
	'lookcopyright' => { 511 => [\'Look','LookCopyright'], 513 => [\'Look','LookCopyright'] },
	'lookgroup' => { 511 => [\'Look','LookGroup'], 513 => [\'Look','LookGroup'] },
	'lookname' => { 511 => 'LookName', 513 => 'LookName' },
	'lookparameters' => { 511 => [\'Look','LookParameters'], 513 => [\'Look','LookParameters'] },
	'lookparameterscameraprofile' => { 511 => [\'Look','LookParametersCameraProfile'], 513 => [\'Look','LookParametersCameraProfile'] },
	'lookparametersclarity2012' => { 511 => [\'Look','LookParametersClarity2012'], 513 => [\'Look','LookParametersClarity2012'] },
	'lookparametersconverttograyscale' => { 511 => [\'Look','LookParametersConvertToGrayscale'], 513 => [\'Look','LookParametersConvertToGrayscale'] },
	'lookparametershighlights2012' => { 511 => [\'Look','LookParametersHighlights2012'], 513 => [\'Look','LookParametersHighlights2012'] },
	'lookparameterslooktable' => { 511 => [\'Look','LookParametersLookTable'], 513 => [\'Look','LookParametersLookTable'] },
	'lookparametersprocessversion' => { 511 => [\'Look','LookParametersProcessVersion'], 513 => [\'Look','LookParametersProcessVersion'] },
	'lookparametersshadows2012' => { 511 => [\'Look','LookParametersShadows2012'], 513 => [\'Look','LookParametersShadows2012'] },
	'lookparameterstonecurvepv2012' => { 511 => [\'Look','LookParametersToneCurvePV2012'], 513 => [\'Look','LookParametersToneCurvePV2012'] },
	'lookparameterstonecurvepv2012blue' => { 511 => [\'Look','LookParametersToneCurvePV2012Blue'], 513 => [\'Look','LookParametersToneCurvePV2012Blue'] },
	'lookparameterstonecurvepv2012green' => { 511 => [\'Look','LookParametersToneCurvePV2012Green'], 513 => [\'Look','LookParametersToneCurvePV2012Green'] },
	'lookparameterstonecurvepv2012red' => { 511 => [\'Look','LookParametersToneCurvePV2012Red'], 513 => [\'Look','LookParametersToneCurvePV2012Red'] },
	'lookparametersversion' => { 511 => [\'Look','LookParametersVersion'], 513 => [\'Look','LookParametersVersion'] },
	'looksupportsamount' => { 511 => [\'Look','LookSupportsAmount'], 513 => [\'Look','LookSupportsAmount'] },
	'looksupportsmonochrome' => { 511 => [\'Look','LookSupportsMonochrome'], 513 => [\'Look','LookSupportsMonochrome'] },
	'looksupportsoutputreferred' => { 511 => [\'Look','LookSupportsOutputReferred'], 513 => [\'Look','LookSupportsOutputReferred'] },
	'lookuuid' => { 511 => [\'Look','LookUUID'], 513 => [\'Look','LookUUID'] },
	'loop' => { 540 => 'loop' },
	'loopstyle' => { 408 => 'LOOP' },
	'lowestbiostratigraphiczone' => { 121 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 511 => 'LuminanceAdjustmentAqua', 513 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 511 => 'LuminanceAdjustmentBlue', 513 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 511 => 'LuminanceAdjustmentGreen', 513 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 511 => 'LuminanceAdjustmentMagenta', 513 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 511 => 'LuminanceAdjustmentOrange', 513 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 511 => 'LuminanceAdjustmentPurple', 513 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 511 => 'LuminanceAdjustmentRed', 513 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 511 => 'LuminanceAdjustmentYellow', 513 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 111 => 0x150 },
	'luminancecurvepoints' => { 111 => 0x126 },
	'luminancenoiseamplitude' => { 1 => 0x1d },
	'luminancenoisereduction' => { 106 => 0x20600, 112 => 0x5f, 425 => 0x1b },
	'luminancenoisereductioncontrast' => { 511 => 'LuminanceNoiseReductionContrast', 513 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 511 => 'LuminanceNoiseReductionDetail', 513 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 112 => 0x6d },
	'luminancesmoothing' => { 511 => 'LuminanceSmoothing', 513 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 87 => [0x40b,0x40c] },
	'lyrics' => { 400 => "\xa9lyr", 408 => "\xa9lyr", 540 => 'lyrics' },
	'lyricsuri' => { 408 => 'lrcu' },
	'm16cversion' => { 343 => 0x333 },
	'macatom' => { 512 => 'macAtom' },
	'macatomapplicationcode' => { 512 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 512 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 512 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 121 => 'MachineObservation' },
	'machineobservationday' => { 121 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 121 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 121 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 121 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 121 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 121 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 121 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationfieldnotes' => { 121 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 121 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 121 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 121 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 121 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 121 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 121 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 121 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 121 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 121 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 121 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 121 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 121 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 130 => 0x1020, 132 => 0x202, 154 => 0x2b, 329 => 0x202, 414 => 0x21, 424 => 0x202, 449 => 0xb040 },
	'macroled' => { 327 => 0x120a },
	'macromagnification' => { 7 => 0x1b, 11 => 0x1b, 14 => 0x1b, 15 => 0x1b, 19 => 0x1b, 20 => 0x1b, 59 => 0x10 },
	'macromode' => { 36 => 0x1, 184 => 0xb, 324 => 0x300, 348 => 0x1c, 415 => 0x1009 },
	'magentahsl' => { 106 => 0x20917 },
	'magicfilter' => { 324 => 0x52c },
	'magnifiedview' => { 89 => 0x11, 91 => 0x9 },
	'mainboardversion' => { 141 => 0x438 },
	'maindialexposurecomp' => { 315 => '0.6' },
	'mainingredient' => { 532 => 'mainIngredient' },
	'majorbrand' => { 402 => 'major_brand' },
	'majorversion' => { 502 => 'MajorVersion' },
	'make' => { 101 => 0x0, 118 => 0x1, 122 => 0x10f, 159 => 'Make', 337 => 'Make', 353 => 0x10f, 402 => 'make', 408 => ['@mak',"\xa9mak"], 529 => 'make', 536 => 'Make' },
	'makernote' => { 517 => 'MakerNote' },
	'makernoteapple' => { 120 => 'MakN', 122 => 0x927c },
	'makernotecanon' => { 84 => 'CMT3', 120 => 'MakN', 122 => 0x927c },
	'makernotecasio' => { 120 => 'MakN', 122 => 0x927c },
	'makernotecasio2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotedji' => { 120 => 'MakN', 122 => 0x927c },
	'makernotedjiinfo' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteflir' => { 120 => 'MakN', 122 => 0x927c },
	'makernotefujifilm' => { 120 => 'MakN', 122 => 0x927c },
	'makernotege' => { 120 => 'MakN', 122 => 0x927c },
	'makernotege2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotehasselblad' => { 120 => 'MakN', 122 => 0x927c },
	'makernotehp' => { 120 => 'MakN', 122 => 0x927c },
	'makernotehp2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotehp4' => { 120 => 'MakN', 122 => 0x927c },
	'makernotehp6' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteisl' => { 120 => 'MakN', 122 => 0x927c },
	'makernotejvc' => { 120 => 'MakN', 122 => 0x927c },
	'makernotejvctext' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak10' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak11' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak12' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak1a' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak1b' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak3' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak4' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak5' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak6a' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak6b' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak7' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak8a' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak8b' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak8c' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak9' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodakunknown' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekyocera' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica10' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica2' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica3' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica4' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica5' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica6' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica7' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica8' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica9' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteminolta' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteminolta2' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteminolta3' => { 120 => 'MakN', 122 => 0x927c },
	'makernotemotorola' => { 120 => 'MakN', 122 => 0x927c },
	'makernotenikon' => { 120 => 'MakN', 122 => 0x927c },
	'makernotenikon2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotenikon3' => { 120 => 'MakN', 122 => 0x927c },
	'makernotenintendo' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteoffset' => { 424 => 0xff },
	'makernoteolympus' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteolympus2' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteolympus3' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepanasonic' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepanasonic2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepanasonic3' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepentax' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepentax2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepentax3' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepentax4' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepentax5' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepentax6' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepentaxunknown' => { 408 => 'PXMN' },
	'makernotephaseone' => { 120 => 'MakN', 122 => 0x927c },
	'makernotereconyx' => { 120 => 'MakN', 122 => 0x927c },
	'makernotereconyx2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotereconyx3' => { 120 => 'MakN', 122 => 0x927c },
	'makernotericoh' => { 120 => 'MakN', 122 => 0x927c },
	'makernotericoh2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotericohpentax' => { 120 => 'MakN', 122 => 0x927c },
	'makernotericohtext' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesafety' => { 122 => 0xc635 },
	'makernotesamsung1a' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesamsung1b' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesamsung2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesanyo' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesanyoc4' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesanyopatch' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesigma' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesony' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesony2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesony3' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesony4' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesony5' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesonyericsson' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesonysrf' => { 120 => 'MakN', 122 => 0x927c },
	'makernotetype' => { 415 => 0x1 },
	'makernoteunknown' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteunknownbinary' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteunknowntext' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteversion' => { 1 => 0x1, 189 => 0x0, 239 => 0x1, 329 => 0x0, 348 => 0x8000, 419 => 0x0, 422 => 0x1, 425 => [0x1d,0x1f], 438 => 0x2000 },
	'makerurl' => { 408 => "\xa9mal" },
	'managedfrom' => { 541 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 541 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 541 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 541 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 541 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 541 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 541 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 541 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 541 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 541 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 541 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 541 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 541 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 541 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 541 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 541 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 541 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 541 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 541 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 541 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 541 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 541 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 541 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 541 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 541 => 'Manager' },
	'managervariant' => { 541 => 'ManagerVariant' },
	'manageto' => { 541 => 'ManageTo' },
	'manageui' => { 541 => 'ManageUI' },
	'manifest' => { 541 => 'Manifest' },
	'manifestlinkform' => { 541 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 541 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 541 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 541 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 541 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 541 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 541 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 541 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 541 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 541 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 541 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 541 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 541 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 541 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 541 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 541 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 541 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 541 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 541 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 541 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 541 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 541 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 541 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 541 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 541 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 541 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 541 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 541 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 324 => 0x900, 348 => 0x86 },
	'manometerreading' => { 324 => 0x901 },
	'manualafpointselectpattern' => { 87 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 327 => 0x1209 },
	'manualflashoutput' => { 36 => 0x29, 306 => '8.2', 309 => '22.2', 310 => '23.1', 311 => '23.2', 313 => '16.2', 314 => '23.2', 315 => '8.2', 316 => '23.2', 319 => '24.2', 415 => 0x100c },
	'manualflashstrength' => { 324 => 0x406 },
	'manualfocusdistance' => { 239 => 0x85, 329 => 0x100c, 424 => 0x223 },
	'manualfocuspointillumination' => { 320 => 0x17, 321 => 0x17, 322 => 0x17 },
	'manualfocusringinafmode' => { 320 => 0x1a, 321 => 0x1a, 322 => 0x1a },
	'manualtv' => { 86 => 0x5, 87 => 0x705 },
	'manufacturedate' => { 194 => 0x6705, 363 => 0x1 },
	'manufacturedate1' => { 417 => 0x4 },
	'manufacturedate2' => { 417 => 0x5 },
	'manufacturer' => { 496 => 'Manufacturer', 529 => 'manufacturer' },
	'mariahchromablursize' => { 141 => 0xf0d },
	'mariahmaphithreshold' => { 141 => 0xf0c },
	'mariahmaplothreshold' => { 141 => 0xf0b },
	'mariahsigmathreshold' => { 141 => 0xf0e },
	'mariahtexturethreshold' => { 141 => 0xf0a },
	'marked' => { 527 => 'Marked', 544 => 'Marked' },
	'markers' => { 540 => 'markers' },
	'markerscomment' => { 540 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 540 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 540 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 540 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 540 => [\'markers','markersCuePointType'] },
	'markersduration' => { 540 => [\'markers','markersDuration'] },
	'markerslocation' => { 540 => [\'markers','markersLocation'] },
	'markersname' => { 540 => [\'markers','markersName'] },
	'markersprobability' => { 540 => [\'markers','markersProbability'] },
	'markersspeaker' => { 540 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 540 => [\'markers','markersStartTime'] },
	'markerstarget' => { 540 => [\'markers','markersTarget'] },
	'markerstype' => { 540 => [\'markers','markersType'] },
	'maskedareas' => { 122 => 0xc68e },
	'maskgroupbasedcorractive' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'] },
	'maskgroupbasedcorramount' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'] },
	'maskgroupbasedcorrblacks2012' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'] },
	'maskgroupbasedcorrbrightness' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'] },
	'maskgroupbasedcorrclarity' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'] },
	'maskgroupbasedcorrclarity2012' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'] },
	'maskgroupbasedcorrcontrast' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'] },
	'maskgroupbasedcorrcontrast2012' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'] },
	'maskgroupbasedcorrcorrectionname' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'] },
	'maskgroupbasedcorrcorrectionsyncid' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'] },
	'maskgroupbasedcorrdefringe' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'] },
	'maskgroupbasedcorrdehaze' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'] },
	'maskgroupbasedcorrections' => { 511 => 'MaskGroupBasedCorrections', 513 => 'MaskGroupBasedCorrections' },
	'maskgroupbasedcorrexposure' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'] },
	'maskgroupbasedcorrexposure2012' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'] },
	'maskgroupbasedcorrhighlights2012' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'] },
	'maskgroupbasedcorrhue' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'] },
	'maskgroupbasedcorrluminancenoise' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'] },
	'maskgroupbasedcorrmask' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'] },
	'maskgroupbasedcorrmaskalpha' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'] },
	'maskgroupbasedcorrmaskangle' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'] },
	'maskgroupbasedcorrmaskbottom' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'] },
	'maskgroupbasedcorrmaskcentervalue' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'] },
	'maskgroupbasedcorrmaskcenterweight' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'] },
	'maskgroupbasedcorrmaskdabs' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'] },
	'maskgroupbasedcorrmaskfeather' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'] },
	'maskgroupbasedcorrmaskflipped' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'] },
	'maskgroupbasedcorrmaskflow' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'] },
	'maskgroupbasedcorrmaskfullx' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'] },
	'maskgroupbasedcorrmaskfully' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'] },
	'maskgroupbasedcorrmaskinputdigest' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'] },
	'maskgroupbasedcorrmaskleft' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'] },
	'maskgroupbasedcorrmaskmaskactive' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'] },
	'maskgroupbasedcorrmaskmaskblendmode' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmaskdigest' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmaskinverted' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmaskname' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'] },
	'maskgroupbasedcorrmaskmasks' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'] },
	'maskgroupbasedcorrmaskmasksalpha' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'maskgroupbasedcorrmaskmasksangle' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'] },
	'maskgroupbasedcorrmaskmasksbottom' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'] },
	'maskgroupbasedcorrmaskmaskscentervalue' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'maskgroupbasedcorrmaskmaskscenterweight' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'maskgroupbasedcorrmaskmasksdabs' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'] },
	'maskgroupbasedcorrmaskmasksfeather' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'] },
	'maskgroupbasedcorrmaskmasksflipped' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'maskgroupbasedcorrmaskmasksflow' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'] },
	'maskgroupbasedcorrmaskmasksfullx' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'] },
	'maskgroupbasedcorrmaskmasksfully' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'] },
	'maskgroupbasedcorrmaskmasksinputdigest' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'maskgroupbasedcorrmaskmasksleft' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'] },
	'maskgroupbasedcorrmaskmasksmaskactive' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'maskgroupbasedcorrmaskmasksmaskblendmode' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmasksmaskdigest' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmasksmaskinverted' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmasksmaskname' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'maskgroupbasedcorrmaskmasksmasksubtype' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksmasksyncid' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmasksmaskversion' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmasksmidpoint' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'maskgroupbasedcorrmaskmasksorigin' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'maskgroupbasedcorrmaskmasksperimetervalue' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskmasksradius' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'] },
	'maskgroupbasedcorrmaskmasksreferencepoint' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'maskgroupbasedcorrmaskmasksright' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'] },
	'maskgroupbasedcorrmaskmasksroundness' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'maskgroupbasedcorrmaskmaskssizex' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'maskgroupbasedcorrmaskmaskssizey' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'maskgroupbasedcorrmaskmaskstop' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'] },
	'maskgroupbasedcorrmaskmasksubtype' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksvalue' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'maskgroupbasedcorrmaskmasksversion' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'] },
	'maskgroupbasedcorrmaskmaskswhat' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'] },
	'maskgroupbasedcorrmaskmaskswholeimagearea' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskmasksx' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'] },
	'maskgroupbasedcorrmaskmasksy' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'] },
	'maskgroupbasedcorrmaskmasksyncid' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmaskszerox' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'maskgroupbasedcorrmaskmaskszeroy' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'maskgroupbasedcorrmaskmaskversion' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmidpoint' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'] },
	'maskgroupbasedcorrmaskorigin' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'] },
	'maskgroupbasedcorrmaskperimetervalue' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskradius' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'] },
	'maskgroupbasedcorrmaskrange' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'maskgroupbasedcorrmaskrangeareamodels' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrmaskrangeareamodelscolorsampleinfo' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrmaskrangeareamodelscomponents' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrmaskrangecoloramount' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrmaskrangedepthfeather' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrmaskrangedepthmax' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrmaskrangedepthmin' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrmaskrangeinvert' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrmaskrangelumfeather' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrmaskrangeluminancedepthsampleinfo' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrmaskrangelummax' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrmaskrangelummin' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrmaskrangelumrange' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrmaskrangesampletype' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrmaskrangetype' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'maskgroupbasedcorrmaskrangeversion' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrmaskreferencepoint' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'] },
	'maskgroupbasedcorrmaskright' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'] },
	'maskgroupbasedcorrmaskroundness' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'] },
	'maskgroupbasedcorrmasksizex' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'] },
	'maskgroupbasedcorrmasksizey' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'] },
	'maskgroupbasedcorrmasktop' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'] },
	'maskgroupbasedcorrmaskvalue' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'] },
	'maskgroupbasedcorrmaskversion' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'] },
	'maskgroupbasedcorrmaskwhat' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'] },
	'maskgroupbasedcorrmaskwholeimagearea' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskx' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'] },
	'maskgroupbasedcorrmasky' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'] },
	'maskgroupbasedcorrmaskzerox' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'] },
	'maskgroupbasedcorrmaskzeroy' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'] },
	'maskgroupbasedcorrmoire' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'] },
	'maskgroupbasedcorrrangemask' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'] },
	'maskgroupbasedcorrrangemaskareamodels' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrrangemaskareamodelscolorsampleinfo' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrrangemaskareamodelscomponents' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrrangemaskcoloramount' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrrangemaskdepthfeather' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrrangemaskdepthmax' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrrangemaskdepthmin' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrrangemaskinvert' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrrangemasklumfeather' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrrangemaskluminancedepthsampleinfo' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrrangemasklummax' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrrangemasklummin' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrrangemasklumrange' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrrangemasksampletype' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrrangemasktype' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'] },
	'maskgroupbasedcorrrangemaskversion' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrsaturation' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'] },
	'maskgroupbasedcorrshadows2012' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'] },
	'maskgroupbasedcorrsharpness' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'] },
	'maskgroupbasedcorrtemperature' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'] },
	'maskgroupbasedcorrtexture' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'] },
	'maskgroupbasedcorrtint' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'] },
	'maskgroupbasedcorrtoninghue' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'] },
	'maskgroupbasedcorrtoningsaturation' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'] },
	'maskgroupbasedcorrwhat' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'] },
	'maskgroupbasedcorrwhites2012' => { 511 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'], 513 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'] },
	'masterdocumentid' => { 134 => 0xb9 },
	'mastergain' => { 263 => 0x50 },
	'materialsample' => { 121 => 'MaterialSample' },
	'materialsampleid' => { 121 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 305 => '50.1', 307 => '48.1', 308 => '48.1', 317 => '48.1', 318 => '48.1', 320 => 0x233, 321 => 0x233, 322 => 0x24b },
	'matrixselectk' => { 141 => 0x91b },
	'matrixselectthreshold' => { 141 => 0x91a },
	'matrixselectthreshold1' => { 141 => 0x91e },
	'matrixselectthreshold2' => { 141 => 0x91f },
	'matrixstructure' => { 407 => 0xa },
	'maxaperture' => { 36 => 0x1a, 141 => 0x3f9, 147 => 0x6103, 166 => 'MaxAperture', 184 => 0x17, 190 => 0x49c5, 237 => 0x36, 325 => 0x20a, 374 => '14.1' },
	'maxapertureatmaxfocal' => { 130 => 0x1407, 166 => 'MaxApertureAtMaxFocal', 231 => 0xb, 232 => 0x10, 233 => 0x11, 237 => 0x12, 325 => 0x206 },
	'maxapertureatminfocal' => { 130 => 0x1406, 231 => 0xa, 232 => 0xf, 233 => 0x10, 237 => 0x11, 325 => 0x205 },
	'maxaperturevalue' => { 122 => 0x9205, 392 => 0x414, 517 => 'MaxApertureValue' },
	'maxavailheight' => { 525 => 'MaxAvailHeight' },
	'maxavailwidth' => { 525 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 304 => 0xb, 305 => 0xc, 307 => '12.1', 308 => '12.1', 313 => 0xc, 314 => 0xb, 317 => '12.1', 318 => '12.1', 320 => 0x3d, 321 => 0x3d, 322 => 0x3d },
	'maxfaces' => { 328 => 0x1202 },
	'maxfocallength' => { 7 => 0xe6, 8 => 0x10, 9 => 0x1ab, 10 => 0x13, 11 => 0x115, 12 => 0x13, 13 => 0x153, 14 => 0xda, 16 => 0xfa, 17 => 0xee, 18 => 0x103, 19 => 0x95, 20 => 0xea, 21 => 0x157, 22 => 0xee, 23 => 0xec, 24 => 0x12b, 25 => 0x165, 26 => 0x16a, 27 => 0x188, 28 => 0x116, 29 => 0x18d, 36 => 0x17, 130 => 0x1405, 166 => 'MaxFocalLength', 231 => 0x9, 232 => 0xe, 233 => 0xf, 237 => 0x10, 325 => 0x208, 462 => 0x127c, 463 => 0x1138, 464 => 0x330, 465 => 0x330, 466 => 0x30e },
	'maximumdensityrange' => { 136 => 0x8c },
	'maxpagesize' => { 545 => 'MaxPageSize' },
	'maxpagesizeh' => { 545 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 545 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 545 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 141 => 0xc7d },
	'maxsamplevalue' => { 122 => 0x119 },
	'maxstorage' => { 535 => 'maxstorage' },
	'mb-d10batteries' => { 304 => '12.6' },
	'mb-d10batterytype' => { 313 => '13.3' },
	'mb-d11batterytype' => { 314 => '2.3' },
	'mb-d12batterytype' => { 317 => '3.2' },
	'mb-d80batteries' => { 315 => '6.5' },
	'mb-d80batterytype' => { 319 => '3.2' },
	'mcuversion' => { 231 => 0xc, 232 => 0x11, 233 => 0x12, 237 => 0x13 },
	'md5digest' => { 167 => 'zmd5' },
	'mditemfindercomment' => { 176 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 176 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 176 => 'MDItemFSLabel' },
	'mditemusertags' => { 176 => 'MDItemUserTags' },
	'meal' => { 532 => 'meal' },
	'measuredev' => { 28 => 0x9, 79 => 0x3, 100 => 0x1814, 159 => 'MeasuredEV' },
	'measuredev2' => { 13 => 0x8, 28 => 0x8, 79 => 0x17 },
	'measuredev3' => { 13 => 0x9 },
	'measuredlv' => { 190 => 0x690, 343 => 0x312, 346 => 0x312, 347 => 0x312, 350 => 0x3407 },
	'measuredrggb' => { 67 => 0x1 },
	'measuredrggbdata' => { 46 => 0x287 },
	'measurementaccuracy' => { 121 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 121 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 121 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 121 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 121 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 121 => 'MeasurementOrFact' },
	'measurementremarks' => { 121 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 121 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 121 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 121 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 496 => 'MeasureType' },
	'mechanicalshuttercount' => { 239 => 0x37 },
	'mediaclassprimaryid' => { 182 => 'WM/MediaClassPrimaryID' },
	'mediaclasssecondaryid' => { 182 => 'WM/MediaClassSecondaryID' },
	'mediaconstraints' => { 334 => 'MediaConstraints' },
	'mediacreatedate' => { 404 => 0x1 },
	'mediaeventiddate' => { 501 => 'MediaEventIdDate' },
	'mediamodifydate' => { 404 => 0x2 },
	'mediasummarycode' => { 334 => 'MediaSummaryCode' },
	'mediatype' => { 400 => 'stik' },
	'memoaudioquality' => { 87 => 0x812 },
	'memorycardconfiguration' => { 441 => 0x16 },
	'memorycardnumber' => { 216 => 0x2 },
	'menubuttondisplayposition' => { 85 => 0xb, 88 => 0xa, 89 => 0xb, 92 => 0xb },
	'menubuttonreturn' => { 93 => 0xb },
	'menumonitorofftime' => { 304 => '26.1', 305 => '22.1', 307 => '22.1', 308 => '22.1', 312 => '21.1', 313 => '8.2', 314 => '21.1', 317 => '22.1', 318 => '22.1', 319 => '22.1', 320 => 0x35, 321 => 0x35, 322 => 0x35 },
	'mergedimages' => { 348 => 0x76 },
	'metadataauthority' => { 525 => 'metadataAuthority' },
	'metadataauthorityidentifier' => { 525 => [\'metadataAuthority','metadataAuthorityIdentifier'] },
	'metadataauthorityname' => { 525 => [\'metadataAuthority','metadataAuthorityName'] },
	'metadatadate' => { 538 => 'MetadataDate' },
	'metadataeditingsoftware' => { 122 => 0xa43c },
	'metadatalastedited' => { 525 => 'metadataLastEdited' },
	'metadatalasteditor' => { 525 => 'metadataLastEditor' },
	'metadatalasteditoridentifier' => { 525 => [\'metadataLastEditor','metadataLastEditorIdentifier'] },
	'metadatalasteditorname' => { 525 => [\'metadataLastEditor','metadataLastEditorName'] },
	'metadatamoddate' => { 540 => 'metadataModDate' },
	'metaversion' => { 457 => 0x34 },
	'meterinfo1row1' => { 450 => 0x0, 451 => 0x0 },
	'meterinfo1row2' => { 450 => 0x6c, 451 => 0x5a },
	'meterinfo1row3' => { 450 => 0xd8, 451 => 0xb4 },
	'meterinfo1row4' => { 450 => 0x144, 451 => 0x10e },
	'meterinfo1row5' => { 450 => 0x1b0, 451 => 0x168 },
	'meterinfo1row6' => { 450 => 0x21c, 451 => 0x1c2 },
	'meterinfo1row7' => { 450 => 0x288, 451 => 0x21c },
	'meterinfo2row1' => { 450 => 0x2f4, 451 => 0x276 },
	'meterinfo2row2' => { 450 => 0x378, 451 => 0x2e4 },
	'meterinfo2row3' => { 450 => 0x3fc, 451 => 0x352 },
	'meterinfo2row4' => { 450 => 0x480, 451 => 0x3c0 },
	'meterinfo2row5' => { 450 => 0x504, 451 => 0x42e },
	'meterinfo2row6' => { 450 => 0x588, 451 => 0x49c },
	'meterinfo2row7' => { 450 => 0x60c, 451 => 0x50a },
	'meterinfo2row8' => { 450 => 0x690, 451 => 0x578 },
	'meterinfo2row9' => { 450 => 0x714, 451 => 0x5e6 },
	'metering' => { 306 => '6.1' },
	'meteringmode' => { 36 => 0x11, 122 => 0x9207, 143 => 0x1c, 184 => 0x7, 185 => 0x25, 187 => 0x12, 324 => 0x202, 383 => 0x17, 425 => 0x9, 435 => 0x15, 436 => 0x13, 437 => 0x7, 454 => 0x3, 458 => 0x1174, 459 => 0x1178, 460 => 0x1154, 461 => 0x11d0, 462 => 0x11ac, 463 => 0x1064, 464 => 0x25c, 465 => 0x25c, 466 => 0x24b, 517 => 'MeteringMode' },
	'meteringmode2' => { 364 => '2.1', 449 => 0x202c },
	'meteringmode3' => { 364 => '16.1' },
	'meteringoffscaleindicator' => { 187 => 0x53 },
	'meteringtime' => { 304 => '22.2', 306 => '3.2', 309 => '17.1', 310 => '18.1', 313 => '7.3', 314 => '18.1', 315 => '3.2', 319 => '19.1' },
	'micro1version' => { 410 => 0x1f },
	'micro2version' => { 410 => 0x2d },
	'microphoneattenuator' => { 244 => 0x34e, 245 => 0x34e, 246 => 0x2d2, 247 => 0x2fa, 248 => 0x2fa },
	'microphonefrequencyresponse' => { 244 => 0x350, 245 => 0x350, 246 => 0x2d4, 247 => 0x2fc, 248 => 0x2fc },
	'microphonejackpower' => { 244 => 0x376, 245 => 0x376, 246 => 0x2fa, 247 => 0x322, 248 => 0x322 },
	'microphonesensitivity' => { 244 => 0x34c, 245 => 0x34c, 246 => 0x2d0, 247 => 0x2f8, 248 => 0x2f8 },
	'microvideo' => { 494 => 'MicroVideo' },
	'microvideooffset' => { 494 => 'MicroVideoOffset' },
	'microvideopresentationtimestampus' => { 494 => 'MicroVideoPresentationTimestampUs' },
	'microvideoversion' => { 494 => 'MicroVideoVersion' },
	'midrangesharpness' => { 257 => 0x3b },
	'mieversion' => { 167 => '0Vers' },
	'mime' => { 496 => 'Mime' },
	'minaperture' => { 36 => 0x1b, 141 => 0x3f8, 166 => 'MinAperture', 374 => '0.2' },
	'minaperturevalue' => { 392 => 0x415 },
	'minfocallength' => { 7 => 0xe4, 8 => 0xe, 9 => 0x1a9, 10 => 0x11, 11 => 0x113, 12 => 0x11, 13 => 0x151, 14 => 0xd8, 16 => 0xf8, 17 => 0xec, 18 => 0x101, 19 => 0x93, 20 => 0xe8, 21 => 0x155, 22 => 0xec, 23 => 0xea, 24 => 0x129, 25 => 0x163, 26 => 0x168, 27 => 0x186, 28 => 0x114, 29 => 0x18b, 36 => 0x18, 130 => 0x1404, 166 => 'MinFocalLength', 231 => 0x8, 232 => 0xd, 233 => 0xe, 237 => 0xf, 325 => 0x207, 462 => 0x127a, 463 => 0x1136, 464 => 0x32e, 465 => 0x32e, 466 => 0x30c },
	'minfocusdistance' => { 374 => 0x3 },
	'minimumiso' => { 348 => 0xe8 },
	'minintegrationrows' => { 141 => 0x1874 },
	'minoltadate' => { 184 => 0x15 },
	'minoltaimagesize' => { 184 => 0x4, 185 => 0xc, 186 => 0x2, 189 => 0x103 },
	'minoltamodelid' => { 184 => 0x25 },
	'minoltaquality' => { 184 => 0x5, 185 => 0xd, 186 => 0x3, 189 => [0x102,0x103] },
	'minoltatime' => { 184 => 0x16 },
	'minormodelagedisclosure' => { 334 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 402 => 'minor_version', 502 => 'MinorVersion' },
	'minsamplevalue' => { 122 => 0x118 },
	'mirrorlockup' => { 85 => 0xc, 86 => 0xc, 87 => 0x60f, 88 => 0xb, 89 => 0xc, 90 => 0x6, 91 => 0x6, 92 => 0xc, 93 => 0x3 },
	'mobilecountrycode' => { 510 => 'mcc' },
	'mobilenetworkcode' => { 510 => 'mnc' },
	'moddate' => { 337 => 'modify-date', 527 => 'ModDate' },
	'modedialposition' => { 441 => 0x14 },
	'model' => { 101 => 0x6, 122 => 0x110, 159 => 'Model', 337 => 'Model', 353 => 0x110, 383 => 0x23f, 402 => 'model', 408 => ['@mod','CNMN','cmnm',"\xa9mdl","\xa9mod"], 425 => 0x84, 496 => 'Model', 529 => 'model', 536 => 'Model' },
	'modelage' => { 525 => 'ModelAge' },
	'modelid' => { 323 => 0x0 },
	'modelingflash' => { 304 => '21.4', 305 => '31.1', 307 => '31.1', 308 => '31.1', 313 => '26.4', 314 => '30.2', 315 => '7.4', 316 => '30.1', 317 => '31.1', 318 => '31.1', 319 => '31.3', 320 => 0x5d, 321 => 0x5d, 322 => 0x5d },
	'modelreleaseid' => { 334 => 'ModelReleaseID' },
	'modelreleasestatus' => { 334 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 472 => 0x52, 473 => 0x46, 474 => 0x53 },
	'modeltiepoint' => { 122 => 0x8482 },
	'modeltransform' => { 122 => 0x85d8 },
	'modelyear' => { 529 => 'modelYear' },
	'modificationdate' => { 530 => 'modificationDate' },
	'modifiedcolortemp' => { 68 => 0x9 },
	'modifieddigitalgain' => { 68 => 0xb },
	'modifiedparamflag' => { 60 => 0x1 },
	'modifiedpicturestyle' => { 68 => 0xa },
	'modifiedsaturation' => { 324 => 0x504 },
	'modifiedsensorbluelevel' => { 68 => 0x5 },
	'modifiedsensorredlevel' => { 68 => 0x4 },
	'modifiedsharpness' => { 68 => 0x2 },
	'modifiedsharpnessfreq' => { 68 => 0x3 },
	'modifiedtonecurve' => { 68 => 0x1 },
	'modifiedwhitebalance' => { 68 => 0x8 },
	'modifiedwhitebalanceblue' => { 68 => 0x7 },
	'modifiedwhitebalancered' => { 68 => 0x6 },
	'modifydate' => { 122 => 0x132, 160 => 'ModifyDate', 333 => 'ModDate', 335 => 'tIME', 399 => 'ModDate', 405 => 0x2, 538 => 'ModifyDate' },
	'moirefilter' => { 122 => 0xfe58, 511 => 'MoireFilter', 513 => 'MoireFilter' },
	'monitorbrightness' => { 244 => 0x69a, 245 => 0x6aa, 246 => 0x59a, 247 => 0x5ca, 248 => 0x5e2 },
	'monitordisplayoff' => { 187 => 0x4c },
	'monitormatrix' => { 141 => 0x8fc },
	'monitorofftime' => { 304 => '18.2', 306 => '3.1', 315 => '3.1' },
	'monochromecolor' => { 324 => 0x53b },
	'monochromecontrast' => { 112 => 0x3c },
	'monochromefiltereffect' => { 106 => 0x20307, 112 => 0x3a, 348 => 0xac, 383 => 0x73 },
	'monochromegraineffect' => { 348 => 0xd2 },
	'monochromelinear' => { 112 => 0x3d },
	'monochromeoutputhighlightpoint' => { 112 => 0x41 },
	'monochromeoutputshadowpoint' => { 112 => 0x42 },
	'monochromeprofilesettings' => { 324 => 0x537 },
	'monochromerawhighlight' => { 112 => 0x7a },
	'monochromerawhighlightpoint' => { 112 => 0x3f },
	'monochromerawshadow' => { 112 => 0x83 },
	'monochromerawshadowpoint' => { 112 => 0x40 },
	'monochromesharpness' => { 112 => 0x3e },
	'monochrometoning' => { 383 => 0x74 },
	'monochrometoningeffect' => { 106 => 0x20306, 112 => 0x3b },
	'monochromeunsharpmaskfineness' => { 112 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 112 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 112 => 0xb4 },
	'monochromevignetting' => { 324 => 0x53a },
	'monthdaycreated' => { 143 => 0x12, 152 => 0xe },
	'mood' => { 182 => 'WM/Mood' },
	'moonphase' => { 409 => 0x12, 410 => 0x43, 411 => 0x4c },
	'morepermissions' => { 509 => 'morePermissions' },
	'motionphotovideo' => { 403 => 'mpvd' },
	'motionsensitivity' => { 409 => 0x29, 411 => 0x60 },
	'movementcount' => { 400 => "\xa9mvc" },
	'movementname' => { 400 => "\xa9mvn" },
	'movementnumber' => { 400 => "\xa9mvi" },
	'movieactived-lighting' => { 243 => 0x238, 244 => 0x334, 245 => 0x334, 246 => 0x2b8, 247 => 0x2e0, 248 => 0x2e0 },
	'movieaelockbuttonassignment' => { 317 => '40.1' },
	'movieaf-onbutton' => { 320 => 0xcb, 321 => 0xcb, 322 => 0xcb },
	'movieafareamode' => { 244 => 0x342, 245 => 0x342, 246 => 0x2c6, 247 => 0x2ee, 248 => 0x2ee, 320 => 0x203, 321 => 0x203, 322 => 0x21b },
	'movieafspeed' => { 320 => 0xdd, 321 => 0xdd, 322 => 0xdd },
	'movieafspeedapply' => { 320 => 0xdf, 321 => 0xdf, 322 => 0xdf },
	'movieaftrackingsensitivity' => { 320 => 0xe1, 321 => 0xe1, 322 => 0xe1 },
	'movieaperturelock' => { 320 => 0x259, 321 => 0x259, 322 => 0x271 },
	'movieautodistortioncontrol' => { 243 => 0x242 },
	'moviediffractioncompensation' => { 243 => 0x241 },
	'moviedxcropalert' => { 244 => 0x377, 245 => 0x377, 246 => 0x2fb, 247 => 0x323, 248 => 0x323 },
	'movieelectronicvr' => { 244 => 0x348, 245 => 0x348, 246 => 0x2cc, 247 => 0x2f4, 248 => 0x2f4 },
	'movieevfgrid' => { 320 => 0x21d, 321 => 0x21d, 322 => 0x235 },
	'movieflickerreduction' => { 244 => 0x33c, 245 => 0x33c, 246 => 0x2c0, 247 => 0x2e8, 248 => 0x2e8 },
	'moviefocusmode' => { 243 => 0x248, 244 => 0x340, 245 => 0x340, 246 => 0x2c4, 247 => 0x2ec, 248 => 0x2ec },
	'moviefocuspointlock' => { 320 => 0x226, 321 => 0x226, 322 => 0x23e },
	'movieframerate' => { 243 => 0x1f8, 244 => 0x374, 245 => 0x370, 246 => 0x2f4, 247 => 0x31c, 248 => 0x31c },
	'movieframesize' => { 243 => 0x1f6, 244 => 0x372, 245 => 0x36e, 246 => 0x2f2, 247 => 0x31a, 248 => 0x31a },
	'moviefunc1button' => { 307 => '41.1', 308 => '41.1', 318 => '41.1', 320 => 0xc3, 321 => 0xc3, 322 => 0xc3 },
	'moviefunc2button' => { 320 => 0xc7, 321 => 0xc7, 322 => 0xc7 },
	'moviefunc3button' => { 321 => 0x127, 322 => 0x13f },
	'moviefunctionbutton' => { 305 => '41.1', 317 => '41.1' },
	'moviefunctionbuttonplusdials' => { 305 => '52.1' },
	'moviehighisonoisereduction' => { 243 => 0x23c, 244 => 0x336, 245 => 0x336, 246 => 0x2ba, 247 => 0x2e2, 248 => 0x2e2 },
	'moviehighlightdisplaythreshold' => { 320 => 0x215, 321 => 0x215, 322 => 0x22d },
	'moviehighreszoom' => { 244 => 0x380, 245 => 0x380, 247 => 0x32c, 248 => 0x32c },
	'movieimagearea' => { 244 => 0x2da, 245 => 0x2da, 246 => 0x25c, 247 => 0x286, 248 => 0x286 },
	'movieisoautocontrolmanualmode' => { 244 => 0x2e8, 245 => 0x2e8, 246 => 0x26a, 247 => 0x294, 248 => 0x294 },
	'movieisoautohilimit' => { 244 => 0x2e6, 245 => 0x2e6, 246 => 0x268, 247 => 0x292, 248 => 0x292 },
	'movieisoautomanualmode' => { 243 => 0x204, 244 => 0x2ea, 245 => 0x2ea, 246 => 0x26c, 247 => 0x296, 248 => 0x296 },
	'movielenscontrolring' => { 320 => 0xd7, 321 => 0xd7, 322 => 0xd7 },
	'moviemeteringmode' => { 244 => 0x33e, 245 => 0x33e, 246 => 0x2c2, 247 => 0x2ea, 248 => 0x2ea },
	'moviemidtonedisplayrange' => { 320 => 0x219, 321 => 0x219, 322 => 0x231 },
	'moviemidtonedisplayvalue' => { 320 => 0x217, 321 => 0x217, 322 => 0x22f },
	'moviemultiselector' => { 320 => 0xd9, 321 => 0xcf, 322 => 0xcf },
	'moviepreviewbutton' => { 305 => '41.2', 307 => '41.2', 308 => '41.2', 317 => '41.2', 318 => '41.2' },
	'moviepreviewbuttonplusdials' => { 305 => '52.2' },
	'movierecordbuttonplaybackmode' => { 320 => 0x1b5, 321 => 0x1b5, 322 => 0x1cd },
	'movieshutterbutton' => { 305 => '38.3', 307 => '38.3', 308 => '38.3', 317 => '38.3', 318 => '38.3' },
	'movieshutterspeedlock' => { 320 => 0x225, 321 => 0x225, 322 => 0x23d },
	'movieslowmotion' => { 243 => 0x1fa },
	'moviesoundrecording' => { 244 => 0x34a, 245 => 0x34a, 246 => 0x2ce, 247 => 0x2f6, 248 => 0x2f6 },
	'moviesubjectdetection' => { 244 => 0x378, 245 => 0x378, 246 => 0x2fc, 247 => 0x324, 248 => 0x324 },
	'moviesubselectorassignment' => { 305 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 305 => '53.1' },
	'movietonemap' => { 246 => 0x2ec, 247 => 0x314, 248 => 0x314 },
	'movietype' => { 228 => 0x2ca, 243 => 0x1fe, 244 => 0x2e4, 245 => 0x2e4, 246 => 0x266, 247 => 0x290, 248 => 0x290 },
	'movievibrationreduction' => { 243 => 0x24e },
	'movievibrationreductionsameasphoto' => { 243 => 0x24f },
	'movievignettecontrol' => { 243 => 0x23e, 244 => 0x1b0, 245 => 0x1b0, 246 => 0x1a0, 247 => 0x1b4, 248 => 0x1b4 },
	'movievignettecontrolsameasphoto' => { 243 => 0x240 },
	'movievrmode' => { 244 => 0x344, 245 => 0x344, 246 => 0x2c8, 247 => 0x2f0, 248 => 0x2f0 },
	'moviezebrapattern' => { 320 => 0x213, 321 => 0x213, 322 => 0x22b },
	'multiburstimageheight' => { 449 => 0x1002 },
	'multiburstimagewidth' => { 449 => 0x1001 },
	'multiburstmode' => { 449 => 0x1000 },
	'multicontrollerwhilemetering' => { 87 => 0x517 },
	'multiexposure' => { 70 => 0x1, 348 => 0xb4 },
	'multiexposureautogain' => { 250 => 0x3 },
	'multiexposurecontrol' => { 70 => 0x2 },
	'multiexposuremode' => { 250 => 0x1, 251 => 0x1 },
	'multiexposureoverlaymode' => { 251 => 0x3 },
	'multiexposureshots' => { 70 => 0x3, 244 => 0x9a, 245 => 0x9a, 246 => 0x8e, 247 => 0x9c, 248 => 0x9c, 250 => 0x2, 251 => 0x2 },
	'multiframenoisereduction' => { 437 => 0x35, 449 => 0x200b, 454 => 0x15 },
	'multiframenreffect' => { 449 => 0x2023 },
	'multifunctionlock' => { 87 => 0x70f },
	'multipleexposuremode' => { 244 => 0x98, 245 => 0x98, 246 => 0x8c, 247 => 0x9a, 248 => 0x9a, 328 => 0x101c },
	'multipleexposureset' => { 364 => '10.1' },
	'multisample' => { 263 => 0x40 },
	'multiselector' => { 304 => '9.4', 305 => '10.3', 307 => '10.3', 308 => '10.3', 313 => '27.4', 317 => '10.3', 318 => '10.3' },
	'multiselectorliveview' => { 304 => '4.3', 307 => '37.1', 308 => '37.1', 317 => '37.1', 318 => '37.1' },
	'multiselectorliveviewmode' => { 277 => 0x18c2 },
	'multiselectorplaybackmode' => { 304 => ['13.5','9.2'], 305 => '10.2', 308 => '10.2', 313 => '27.2', 317 => '10.2', 318 => '10.2', 320 => 0xb3, 321 => 0xb3, 322 => 0xb3 },
	'multiselectorshootmode' => { 304 => '9.1', 305 => '10.1', 307 => '10.1', 308 => '10.1', 313 => '27.1', 317 => '10.1', 318 => '10.1', 320 => 0xaf, 321 => 0xaf, 322 => 0xaf },
	'multishot' => { 353 => 0x121 },
	'mute' => { 402 => 'player.movie.audio.mute' },
	'mycolormode' => { 71 => 0x2 },
	'name' => { 408 => 'name', 511 => 'Name', 513 => 'Name' },
	'narrator' => { 400 => "\xa9nrt" },
	'nationalcatalognumber' => { 530 => 'nationalCatalogNumber' },
	'nativedigest' => { 517 => 'NativeDigest', 536 => 'NativeDigest' },
	'ndfilter' => { 79 => 0x1c, 324 => 0x204, 415 => 0x1019 },
	'near' => { 496 => 'Near' },
	'nefbitdepth' => { 239 => 0xe22 },
	'nefcompression' => { 239 => 0x93, 240 => 0xa },
	'neflinearizationtable' => { 239 => 0x96 },
	'negativecachelargepreviewsize' => { 511 => 'NegativeCacheLargePreviewSize', 513 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 511 => 'NegativeCacheMaximumSize', 513 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 511 => 'NegativeCachePath', 513 => 'NegativeCachePath' },
	'neutraldensityfactor' => { 508 => 'NeutralDensityFactor' },
	'neutraldensityfilter' => { 383 => 0x88 },
	'neutraloutputhighlightpoint' => { 112 => 0x2f },
	'neutraloutputshadowpoint' => { 112 => 0x30 },
	'neutralrawcolortone' => { 112 => 0x28 },
	'neutralrawcontrast' => { 112 => 0x2a },
	'neutralrawhighlight' => { 112 => 0x78 },
	'neutralrawhighlightpoint' => { 112 => 0x2d },
	'neutralrawlinear' => { 112 => 0x2b },
	'neutralrawsaturation' => { 112 => 0x29 },
	'neutralrawshadow' => { 112 => 0x81 },
	'neutralrawshadowpoint' => { 112 => 0x2e },
	'neutralrawsharpness' => { 112 => 0x2c },
	'neutralunsharpmaskfineness' => { 112 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 112 => 0xa8 },
	'neutraunsharpmaskstrength' => { 112 => 0xa4 },
	'newlensdata' => { 237 => 0x2f },
	'newrawimagedigest' => { 122 => 0xc7a7 },
	'newsphotoversion' => { 136 => 0x0 },
	'nickname' => { 538 => 'Nickname' },
	'nikoncapturedata' => { 239 => 0xe01 },
	'nikoncaptureeditversions' => { 239 => 0xe13 },
	'nikoncaptureoffsets' => { 239 => 0xe0e },
	'nikoncaptureoutput' => { 239 => 0xe1e },
	'nikoncaptureversion' => { 239 => 0xe09 },
	'nikoniccprofile' => { 239 => 0xe1d },
	'nikonimagesize' => { 274 => '723.1', 275 => '732.1', 283 => 0x2c4 },
	'nikonmeteringmode' => { 202 => 0x17, 243 => 0x146, 254 => 0x214 },
	'nikonsettings' => { 239 => 0x4e },
	'noisefilter' => { 324 => 0x527 },
	'noiseprofile' => { 122 => 0xc761 },
	'noisereduction' => { 130 => [0x100b,0x100e], 185 => 0xb0, 186 => 0x60, 187 => 0x3f, 239 => 0x95, 297 => 0x753dcbc0, 298 => 0x17, 324 => 0x50a, 329 => 0x103a, 348 => 0x2d, 383 => 0x49, 415 => 0x100f, 417 => 0x2a },
	'noisereduction2' => { 328 => 0x1010 },
	'noisereductionapplied' => { 122 => 0xc6f7 },
	'noisereductionintensity' => { 298 => 0x9 },
	'noisereductionmethod' => { 298 => 0x11 },
	'noisereductionmode' => { 486 => 0x801e },
	'noisereductionparametersatcapture' => { 141 => 0xe73 },
	'noisereductionparameterscamera' => { 141 => 0xe72 },
	'noisereductionparametershost3mp' => { 141 => 0xe71 },
	'noisereductionparametershost6mp' => { 141 => 0xe70 },
	'noisereductionparametershostrgb' => { 141 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 141 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 141 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 141 => 0xe63 },
	'noisereductionparams' => { 353 => 0x1b },
	'noisereductionsharpness' => { 298 => 0xd },
	'noisereductionstrength' => { 348 => 0xd6 },
	'noisereductionvalue' => { 486 => 0x8027 },
	'nomemorycard' => { 304 => '22.1', 305 => '4.2', 306 => '0.3', 309 => '2.4', 310 => '3.2', 311 => '3.2', 313 => '33.7', 314 => '3.2', 315 => '0.3', 317 => '4.2', 319 => '4.5' },
	'nominalmaxaperture' => { 374 => 0xa },
	'nominalminaperture' => { 374 => '10.1' },
	'noncpulens10focallength' => { 244 => 0x6c6, 245 => 0x6d6, 248 => 0x620 },
	'noncpulens10maxaperture' => { 244 => 0x6ee, 245 => 0x738, 248 => 0x670 },
	'noncpulens11focallength' => { 244 => 0x6c8, 245 => 0x6d8, 248 => 0x624 },
	'noncpulens11maxaperture' => { 244 => 0x6f0, 245 => 0x73c, 248 => 0x674 },
	'noncpulens12focallength' => { 244 => 0x6ca, 245 => 0x6da, 248 => 0x628 },
	'noncpulens12maxaperture' => { 244 => 0x6f2, 245 => 0x740, 248 => 0x678 },
	'noncpulens13focallength' => { 244 => 0x6cc, 245 => 0x6dc, 248 => 0x62c },
	'noncpulens13maxaperture' => { 244 => 0x6f4, 245 => 0x744, 248 => 0x67c },
	'noncpulens14focallength' => { 244 => 0x6ce, 245 => 0x6de, 248 => 0x630 },
	'noncpulens14maxaperture' => { 244 => 0x6f6, 245 => 0x748, 248 => 0x680 },
	'noncpulens15focallength' => { 244 => 0x6d0, 245 => 0x6e0, 248 => 0x634 },
	'noncpulens15maxaperture' => { 244 => 0x6f8, 245 => 0x74c, 248 => 0x684 },
	'noncpulens16focallength' => { 244 => 0x6d2, 245 => 0x6e2, 248 => 0x638 },
	'noncpulens16maxaperture' => { 244 => 0x6fa, 245 => 0x750, 248 => 0x688 },
	'noncpulens17focallength' => { 244 => 0x6d4, 245 => 0x6e4, 248 => 0x63c },
	'noncpulens17maxaperture' => { 244 => 0x6fc, 245 => 0x754, 248 => 0x68c },
	'noncpulens18focallength' => { 244 => 0x6d6, 245 => 0x6e6, 248 => 0x640 },
	'noncpulens18maxaperture' => { 244 => 0x6fe, 245 => 0x758, 248 => 0x690 },
	'noncpulens19focallength' => { 244 => 0x6d8, 245 => 0x6e8, 248 => 0x644 },
	'noncpulens19maxaperture' => { 244 => 0x700, 245 => 0x75c, 248 => 0x694 },
	'noncpulens1focallength' => { 244 => 0x6b4, 245 => 0x6c4, 248 => 0x5fc },
	'noncpulens1maxaperture' => { 244 => 0x6dc, 245 => 0x714, 248 => 0x64c },
	'noncpulens20focallength' => { 244 => 0x6da, 245 => 0x6ea, 248 => 0x648 },
	'noncpulens20maxaperture' => { 244 => 0x702, 245 => 0x760, 248 => 0x698 },
	'noncpulens2focallength' => { 244 => 0x6b6, 245 => 0x6c6, 248 => 0x600 },
	'noncpulens2maxaperture' => { 244 => 0x6de, 245 => 0x718, 248 => 0x650 },
	'noncpulens3focallength' => { 244 => 0x6b8, 245 => 0x6c8, 248 => 0x604 },
	'noncpulens3maxaperture' => { 244 => 0x6e0, 245 => 0x71c, 248 => 0x654 },
	'noncpulens4focallength' => { 244 => 0x6ba, 245 => 0x6ca, 248 => 0x608 },
	'noncpulens4maxaperture' => { 244 => 0x6e2, 248 => 0x658 },
	'noncpulens5focallength' => { 244 => 0x6bc, 245 => 0x6cc, 248 => 0x60c },
	'noncpulens5maxaperture' => { 244 => 0x6e4, 245 => 0x724, 248 => 0x65c },
	'noncpulens6focallength' => { 244 => 0x6be, 245 => 0x6ce, 248 => 0x610 },
	'noncpulens6maxaperture' => { 244 => 0x6e6, 245 => 0x728, 248 => 0x660 },
	'noncpulens7focallength' => { 244 => 0x6c0, 245 => 0x6d0, 248 => 0x614 },
	'noncpulens7maxaperture' => { 244 => 0x6e8, 245 => 0x72c, 248 => 0x664 },
	'noncpulens8focallength' => { 244 => 0x6c2, 245 => 0x6d2, 248 => 0x618 },
	'noncpulens8maxaperture' => { 244 => 0x6ea, 245 => 0x730, 248 => 0x668 },
	'noncpulens9focallength' => { 244 => 0x6c4, 245 => 0x6d4, 248 => 0x61c },
	'noncpulens9maxaperture' => { 244 => 0x6ec, 245 => 0x734, 248 => 0x66c },
	'normalizedcropcorners' => { 338 => 'NormalizedCropCorners' },
	'normallinetime' => { 141 => 0x186a },
	'normalwhitelevel' => { 43 => 0x32a, 44 => 0x280, 47 => [0x2b8,0x2cf,0x2d3], 48 => 0x569, 49 => 0x1e3, 50 => [0x1fc,0x2dc], 51 => [0x230,0x30e], 52 => 0x31c },
	'notes' => { 488 => 'Notes', 506 => 'notes' },
	'npages' => { 545 => 'NPages' },
	'nullrecord' => { 100 => 0x0 },
	'numafpoints' => { 360 => 0x2 },
	'number' => { 530 => 'number' },
	'numberofbeats' => { 540 => 'numberOfBeats' },
	'numberoffocuspoints' => { 307 => '1.3', 308 => '1.3', 311 => '0.2', 312 => '0.3', 314 => '0.3' },
	'numfaceelements' => { 130 => 0x4200 },
	'numfacepositions' => { 340 => 0x0 },
	'numindexentries' => { 136 => 0x54 },
	'numwbentries' => { 354 => 0x0, 355 => 0x0 },
	'object' => { 530 => 'object' },
	'objectattributereference' => { 134 => 0x4 },
	'objectcycle' => { 134 => 0x4b, 506 => 'ObjectCycle' },
	'objectdescription' => { 529 => 'objectDescription' },
	'objectdistance' => { 115 => 0x6, 116 => 0x2022 },
	'objectname' => { 134 => 0x5 },
	'objectpreviewdata' => { 134 => 0xca },
	'objectpreviewfileformat' => { 134 => 0xc8 },
	'objectpreviewfileversion' => { 134 => 0xc9 },
	'objectsubtype' => { 529 => 'objectSubtype' },
	'objecttype' => { 529 => 'objectType' },
	'objecttypereference' => { 134 => 0x3 },
	'occurrence' => { 121 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 121 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 121 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 121 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 121 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 121 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 121 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 121 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedegreeofestablishment' => { 121 => [\'Occurrence','OccurrenceDegreeOfEstablishment'] },
	'occurrencedetails' => { 121 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 121 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 121 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrencegeoreferenceverificationstatus' => { 121 => [\'Occurrence','OccurrenceGeoreferenceVerificationStatus'] },
	'occurrenceid' => { 121 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 121 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 121 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 121 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 121 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 121 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 121 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepathway' => { 121 => [\'Occurrence','OccurrencePathway'] },
	'occurrencepreparations' => { 121 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 121 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 121 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordedbyid' => { 121 => [\'Occurrence','OccurrenceRecordedByID'] },
	'occurrencerecordnumber' => { 121 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 121 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 121 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 121 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 121 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 517 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 517 => [\'OECF','OECFNames'] },
	'oecfrows' => { 517 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 517 => [\'OECF','OECFValues'] },
	'offsaledate' => { 530 => 'offSaleDate' },
	'offsaledatea-platform' => { 530 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 530 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 141 => 0x190a },
	'offsethdr' => { 522 => 'OffsetHDR' },
	'offsetschema' => { 122 => 0xea1d },
	'offsetsdr' => { 522 => 'OffsetSDR' },
	'offsettime' => { 122 => 0x9010 },
	'offsettimedigitized' => { 122 => 0x9012 },
	'offsettimeoriginal' => { 122 => 0x9011 },
	'oismode' => { 1 => 0xf },
	'okbutton' => { 314 => '15.1', 319 => '16.1' },
	'oldsubfiletype' => { 122 => 0xff },
	'olympusimageheight' => { 329 => 0x102f },
	'olympusimagewidth' => { 329 => 0x102e },
	'omenatcapturestrength' => { 141 => 0xa60 },
	'omenautostrength' => { 141 => 0xa5f },
	'omenearlystrength' => { 141 => 0xa5e },
	'omenfocallengthlimit' => { 141 => 0xa62 },
	'omeninitialipfstrength' => { 141 => 0xa5d },
	'omensurfaceindex' => { 141 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 329 => 0x302 },
	'onsaledate' => { 530 => 'onSaleDate' },
	'onsaledatea-platform' => { 530 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 530 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 530 => 'onSaleDay' },
	'onsaledaya-platform' => { 530 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 530 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 122 => 0xc740 },
	'opcodelist2' => { 122 => 0xc741 },
	'opcodelist3' => { 122 => 0xc74e },
	'opticalzoom' => { 145 => 0xfa3d, 147 => [0x6006,0xf006], 148 => 0x1000, 149 => 0xf, 152 => 0x1e, 154 => 0x20, 155 => 0x1c, 166 => 'OpticalZoom' },
	'opticalzoomcode' => { 79 => 0xa },
	'opticalzoommode' => { 348 => 0x34 },
	'opticalzoomon' => { 424 => 0x219 },
	'optionenddate' => { 533 => 'optionEndDate' },
	'opto-electricconvfactor' => { 517 => 'OECF' },
	'orangehsl' => { 106 => 0x20911 },
	'ordernumber' => { 130 => 0x8002 },
	'organisationinimagecode' => { 525 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 525 => 'OrganisationInImageName' },
	'organism' => { 121 => 'Organism' },
	'organismassociatedoccurrences' => { 121 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 121 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 121 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 121 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 121 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 121 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 121 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 530 => 'organization' },
	'orientation' => { 122 => 0x112, 353 => 0x112, 529 => 'orientation', 536 => 'Orientation' },
	'orientation2' => { 454 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 87 => 0x516 },
	'originalalbumtitle' => { 182 => 'WM/OriginalAlbumTitle' },
	'originalartist' => { 182 => 'WM/OriginalArtist', 400 => "\xa9ope" },
	'originalbestqualitysize' => { 122 => 0xc792 },
	'originalcreatedatetime' => { 501 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 117 => 'Canon-OriginalDecisionData' },
	'originaldecisiondataoffset' => { 66 => 0x83 },
	'originaldefaultcropsize' => { 122 => 0xc793 },
	'originaldefaultfinalsize' => { 122 => 0xc791 },
	'originaldirectory' => { 345 => 0x408 },
	'originaldocumentid' => { 541 => 'OriginalDocumentID' },
	'originalfilename' => { 100 => 0x816, 141 => 0x3e9, 153 => 0x20, 345 => 0x407, 501 => 'OriginalFilename' },
	'originalimagehash' => { 491 => 'OriginalImageHash' },
	'originalimagehashtype' => { 491 => 'OriginalImageHashType' },
	'originalimageheight' => { 81 => 0xc, 126 => 0x1 },
	'originalimagemd5' => { 491 => 'OriginalImageMD5' },
	'originalimagesize' => { 165 => 'OriginalImageSize' },
	'originalimagewidth' => { 81 => 0xb, 126 => 0x0 },
	'originallyricist' => { 182 => 'WM/OriginalLyricist' },
	'originalrawfiledata' => { 122 => 0xc68c },
	'originalrawfiledigest' => { 122 => 0xc71d },
	'originalrawfilename' => { 122 => 0xc68b },
	'originaltransmissionreference' => { 134 => 0x67 },
	'originatingprogram' => { 134 => 0x41, 506 => 'OriginatingProgram' },
	'originplatform' => { 530 => 'originPlatform' },
	'os' => { 515 => 'os' },
	'otherconditions' => { 334 => 'OtherConditions' },
	'otherconstraints' => { 334 => 'OtherConstraints' },
	'otherimage' => { 117 => 'Exif-OtherImage' },
	'otherimageinfo' => { 334 => 'OtherImageInfo' },
	'otherimagelength' => { 122 => 0x202 },
	'otherimagestart' => { 122 => 0x201 },
	'otherlicensedocuments' => { 334 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 334 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 334 => 'OtherLicenseRequirements' },
	'outcue' => { 540 => 'outCue' },
	'outcuescale' => { 540 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 540 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 203 => 0x3 },
	'outputimagewidth' => { 203 => 0x2 },
	'outputlut' => { 348 => 0xa7 },
	'outputprofile' => { 141 => 0x138b },
	'outputresolution' => { 203 => 0x4 },
	'overclockcols' => { 141 => 0x189c },
	'overclockrows' => { 141 => 0x18c4 },
	'overridelookvignette' => { 511 => 'OverrideLookVignette', 513 => 'OverrideLookVignette' },
	'owner' => { 400 => 'ownr', 544 => 'Owner' },
	'ownerid' => { 134 => 0xbc },
	'ownername' => { 15 => 0x10f, 66 => 0x9, 100 => 0x810, 122 => [0xa430,0xfde8], 159 => 'OwnerName', 508 => 'OwnerName', 518 => 'CameraOwnerName' },
	'padding' => { 122 => 0xea1c },
	'pagecount' => { 530 => 'pageCount' },
	'pageimage' => { 538 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 538 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 538 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 538 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 538 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 538 => 'PageInfo' },
	'pagename' => { 122 => 0x11d },
	'pagenumber' => { 122 => 0x129 },
	'pageprogressiondirection' => { 530 => 'pageProgressionDirection' },
	'pagerange' => { 530 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 511 => 'PaintBasedCorrections', 513 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionblacks2012' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'] },
	'paintcorrectionbrightness' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectioncorrectionname' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'] },
	'paintcorrectioncorrectionsyncid' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'] },
	'paintcorrectiondefringe' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectiondehaze' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'] },
	'paintcorrectionexposure' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'] },
	'paintcorrectionluminancenoise' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskinputdigest' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'] },
	'paintcorrectionmaskleft' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmaskactive' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'] },
	'paintcorrectionmaskmaskblendmode' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'paintcorrectionmaskmaskdigest' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'] },
	'paintcorrectionmaskmaskinverted' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'] },
	'paintcorrectionmaskmaskname' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'] },
	'paintcorrectionmaskmasks' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'] },
	'paintcorrectionmaskmasksalpha' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'paintcorrectionmaskmasksangle' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'] },
	'paintcorrectionmaskmasksbottom' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'] },
	'paintcorrectionmaskmaskscentervalue' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'paintcorrectionmaskmaskscenterweight' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'paintcorrectionmaskmasksdabs' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'] },
	'paintcorrectionmaskmasksfeather' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'] },
	'paintcorrectionmaskmasksflipped' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'paintcorrectionmaskmasksflow' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'] },
	'paintcorrectionmaskmasksfullx' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'] },
	'paintcorrectionmaskmasksfully' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'] },
	'paintcorrectionmaskmasksinputdigest' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'paintcorrectionmaskmasksleft' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'] },
	'paintcorrectionmaskmasksmaskactive' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'paintcorrectionmaskmasksmaskblendmode' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'paintcorrectionmaskmasksmaskdigest' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'paintcorrectionmaskmasksmaskinverted' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'paintcorrectionmaskmasksmaskname' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'paintcorrectionmaskmasksmasksubtype' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'paintcorrectionmaskmasksmasksyncid' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'paintcorrectionmaskmasksmaskversion' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'paintcorrectionmaskmasksmidpoint' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'paintcorrectionmaskmasksorigin' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'paintcorrectionmaskmasksperimetervalue' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'paintcorrectionmaskmasksradius' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'] },
	'paintcorrectionmaskmasksreferencepoint' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'paintcorrectionmaskmasksright' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'] },
	'paintcorrectionmaskmasksroundness' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'paintcorrectionmaskmaskssizex' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'paintcorrectionmaskmaskssizey' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'paintcorrectionmaskmaskstop' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'] },
	'paintcorrectionmaskmasksubtype' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'] },
	'paintcorrectionmaskmasksvalue' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'paintcorrectionmaskmasksversion' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'] },
	'paintcorrectionmaskmaskswhat' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'] },
	'paintcorrectionmaskmaskswholeimagearea' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'paintcorrectionmaskmasksx' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'] },
	'paintcorrectionmaskmasksy' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'] },
	'paintcorrectionmaskmasksyncid' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'paintcorrectionmaskmaskszerox' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'paintcorrectionmaskmaskszeroy' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'paintcorrectionmaskmaskversion' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'] },
	'paintcorrectionmaskmidpoint' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskorigin' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'] },
	'paintcorrectionmaskperimetervalue' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskrange' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'paintcorrectionmaskrangeareamodels' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'paintcorrectionmaskrangeareamodelscolorsampleinfo' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionmaskrangeareamodelscomponents' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionmaskrangecoloramount' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'paintcorrectionmaskrangedepthfeather' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionmaskrangedepthmax' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'paintcorrectionmaskrangedepthmin' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'paintcorrectionmaskrangeinvert' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'paintcorrectionmaskrangelumfeather' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'paintcorrectionmaskrangeluminancedepthsampleinfo' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionmaskrangelummax' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'paintcorrectionmaskrangelummin' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'paintcorrectionmaskrangelumrange' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'paintcorrectionmaskrangesampletype' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'paintcorrectionmaskrangetype' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'paintcorrectionmaskrangeversion' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'paintcorrectionmaskreferencepoint' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'] },
	'paintcorrectionmaskright' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskwholeimagearea' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'paintcorrectionmaskx' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionrangemask' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'] },
	'paintcorrectionrangemaskareamodels' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'paintcorrectionrangemaskareamodelscolorsampleinfo' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionrangemaskareamodelscomponents' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionrangemaskcoloramount' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'paintcorrectionrangemaskdepthfeather' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionrangemaskdepthmax' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'paintcorrectionrangemaskdepthmin' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'paintcorrectionrangemaskinvert' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'] },
	'paintcorrectionrangemasklumfeather' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'paintcorrectionrangemaskluminancedepthsampleinfo' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionrangemasklummax' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'paintcorrectionrangemasklummin' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'paintcorrectionrangemasklumrange' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'paintcorrectionrangemasksampletype' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'paintcorrectionrangemasktype' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'] },
	'paintcorrectionrangemaskversion' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'] },
	'paintcorrectionsaturation' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'] },
	'paintcorrectionshadows2012' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontexture' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'] },
	'paintcorrectiontint' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectiontoninghue' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectiontoningsaturation' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionwhat' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'paintcorrectionwhites2012' => { 511 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'], 513 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'] },
	'panasonicdatetime' => { 351 => 0x0 },
	'panasonicexifversion' => { 348 => 0x26 },
	'panasonicimageheight' => { 348 => 0x4c },
	'panasonicimagewidth' => { 348 => 0x4b },
	'panasonicrawversion' => { 353 => 0x1 },
	'panasonictitle' => { 122 => 0xc6d2 },
	'panasonictitle2' => { 122 => 0xc6d3 },
	'panoramaangle' => { 130 => 0x1153 },
	'panoramacropbottom' => { 455 => 0x7 },
	'panoramacropleft' => { 455 => 0x4 },
	'panoramacropright' => { 455 => 0x6 },
	'panoramacroptop' => { 455 => 0x5 },
	'panoramadirection' => { 74 => 0x5, 130 => 0x1154, 455 => 0x3 },
	'panoramaframeheight' => { 455 => 0x9 },
	'panoramaframenumber' => { 74 => 0x2 },
	'panoramaframewidth' => { 455 => 0x8 },
	'panoramafullheight' => { 455 => 0x2 },
	'panoramafullwidth' => { 455 => 0x1 },
	'panoramamode' => { 143 => 0x3c, 324 => 0x601 },
	'panoramasize3d' => { 437 => 0x38 },
	'panoramasourceheight' => { 455 => 0xb },
	'panoramasourcewidth' => { 455 => 0xa },
	'panoramicstitchcameramotion' => { 179 => 'PanoramicStitchCameraMotion', 180 => 0x1 },
	'panoramicstitchmaptype' => { 179 => 'PanoramicStitchMapType', 180 => 0x2 },
	'panoramicstitchphi0' => { 179 => 'PanoramicStitchPhi0', 180 => 0x5 },
	'panoramicstitchphi1' => { 179 => 'PanoramicStitchPhi1', 180 => 0x6 },
	'panoramicstitchtheta0' => { 179 => 'PanoramicStitchTheta0', 180 => 0x3 },
	'panoramicstitchtheta1' => { 179 => 'PanoramicStitchTheta1', 180 => 0x4 },
	'panoramicstitchversion' => { 180 => 0x0 },
	'pantry' => { 541 => 'Pantry' },
	'pantryinstanceid' => { 541 => [\'Pantry','PantryInstanceID'] },
	'parallax' => { 130 => 0xb211, 323 => 0x28 },
	'parameters' => { 337 => 'parameters' },
	'parametricdarks' => { 511 => 'ParametricDarks', 513 => 'ParametricDarks' },
	'parametrichighlights' => { 511 => 'ParametricHighlights', 513 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 511 => 'ParametricHighlightSplit', 513 => 'ParametricHighlightSplit' },
	'parametriclights' => { 511 => 'ParametricLights', 513 => 'ParametricLights' },
	'parametricmidtonesplit' => { 511 => 'ParametricMidtoneSplit', 513 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 511 => 'ParametricShadows', 513 => 'ParametricShadows' },
	'parametricshadowsplit' => { 511 => 'ParametricShadowSplit', 513 => 'ParametricShadowSplit' },
	'parentalrating' => { 182 => 'WM/ParentalRating' },
	'parentid' => { 525 => 'parentId' },
	'parentmediaeventid' => { 501 => 'ParentMediaEventID' },
	'parentmeid' => { 501 => 'ParentMEID' },
	'parentproductid' => { 400 => '@ppi' },
	'parentreference1' => { 523 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 523 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 523 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 523 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 523 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 523 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentshorttitle' => { 400 => '@PST' },
	'parenttitle' => { 400 => '@pti' },
	'partialactivecols1' => { 141 => 0x17e8 },
	'partialactivecols2' => { 141 => 0x17f2 },
	'partialactiverows1' => { 141 => 0x17fc },
	'partialactiverows2' => { 141 => 0x1806 },
	'partofcompilation' => { 540 => 'partOfCompilation' },
	'patientbirthdate' => { 489 => 'PatientDOB' },
	'patientid' => { 489 => 'PatientID' },
	'patientname' => { 489 => 'PatientName' },
	'patientsex' => { 489 => 'PatientSex' },
	'patternareaheight' => { 141 => 0x963 },
	'patternareawidth' => { 141 => 0x962 },
	'patterncorrectionfactorscale' => { 141 => 0x969 },
	'patterncropcols1' => { 141 => 0x96c },
	'patterncropcols2' => { 141 => 0x96d },
	'patterncroprows1' => { 141 => 0x96a },
	'patterncroprows2' => { 141 => 0x96b },
	'patternimagerheight' => { 141 => 0x961 },
	'patternimagerwidth' => { 141 => 0x960 },
	'patternx' => { 141 => 0x966 },
	'patterny' => { 141 => 0x967 },
	'pdfversion' => { 527 => 'PDFVersion' },
	'pentaximagesize' => { 383 => 0x9 },
	'pentaxmodelid' => { 363 => 0x0, 383 => 0x5 },
	'pentaxmodeltype' => { 383 => 0x1 },
	'pentaxversion' => { 383 => 0x0 },
	'people' => { 492 => 'People', 504 => 'People' },
	'perchannelblacklevel' => { 43 => 0x157, 44 => 0x16b, 46 => 0xc4, 47 => [0x2b4,0x2cb,0x2cf], 48 => [0x108,0x14d], 49 => 0x1df, 50 => [0x1f8,0x2d8], 51 => [0x22c,0x30a], 52 => 0x149 },
	'performer' => { 400 => 'perf', 408 => 'perf' },
	'performerkeywords' => { 408 => "\xa9prk" },
	'performers' => { 408 => "\xa9prf" },
	'performerurl' => { 408 => "\xa9prl" },
	'period' => { 182 => 'WM/Period' },
	'peripheralillumcentralradius' => { 486 => 0x8030 },
	'peripheralillumcentralvalue' => { 486 => 0x8031 },
	'peripheralillumination' => { 106 => 0x20702, 112 => 0x68 },
	'peripheralilluminationcorr' => { 64 => 0x1, 373 => 0x2 },
	'peripheralilluminationon' => { 106 => '0x20702.0', 112 => 0x64 },
	'peripheralillumperiphvalue' => { 486 => 0x8032 },
	'peripherallighting' => { 81 => 0x2, 130 => 0x3804 },
	'peripherallightingsetting' => { 82 => 0x5 },
	'peripherallightingvalue' => { 81 => 0x6 },
	'permissions' => { 533 => 'permissions' },
	'permits' => { 509 => 'permits' },
	'person' => { 530 => 'person' },
	'personality' => { 501 => 'Personality' },
	'personheard' => { 525 => 'PersonHeard' },
	'personheardidentifier' => { 525 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 525 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 525 => 'PersonInImage' },
	'personinimagecharacteristic' => { 525 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 525 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 525 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 525 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 525 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 525 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 525 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 525 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 525 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 511 => 'PerspectiveAspect', 513 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 511 => 'PerspectiveHorizontal', 513 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 511 => 'PerspectiveRotate', 513 => 'PerspectiveRotate' },
	'perspectivescale' => { 511 => 'PerspectiveScale', 513 => 'PerspectiveScale' },
	'perspectiveupright' => { 511 => 'PerspectiveUpright', 513 => 'PerspectiveUpright' },
	'perspectivevertical' => { 511 => 'PerspectiveVertical', 513 => 'PerspectiveVertical' },
	'perspectivex' => { 511 => 'PerspectiveX', 513 => 'PerspectiveX' },
	'perspectivey' => { 511 => 'PerspectiveY', 513 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 95 => 0x1 },
	'pf10retainprogramshift' => { 95 => 0xb },
	'pf13drivepriority' => { 95 => 0xe },
	'pf14disablefocussearch' => { 95 => 0xf },
	'pf15disableafassistbeam' => { 95 => 0x10 },
	'pf16autofocuspointshoot' => { 95 => 0x11 },
	'pf17disableafpointsel' => { 95 => 0x12 },
	'pf18enableautoafpointsel' => { 95 => 0x13 },
	'pf19continuousshootspeed' => { 95 => 0x14 },
	'pf19shootingspeedhigh' => { 94 => 0xa },
	'pf19shootingspeedlow' => { 94 => 0x9 },
	'pf1disableshootingmodes' => { 95 => 0x2 },
	'pf1value' => { 94 => 0x1 },
	'pf20limitcontinousshots' => { 95 => 0x15 },
	'pf20maxcontinousshots' => { 94 => 0xb },
	'pf21enablequietoperation' => { 95 => 0x16 },
	'pf23felocktime' => { 94 => 0xd },
	'pf23postreleasetime' => { 94 => 0xe },
	'pf23settimerlengths' => { 95 => 0x18 },
	'pf23shutterbuttontime' => { 94 => 0xc },
	'pf24lightlcdduringbulb' => { 95 => 0x19 },
	'pf25aemode' => { 94 => 0xf },
	'pf25afmode' => { 94 => 0x12 },
	'pf25afpointsel' => { 94 => 0x13 },
	'pf25colormatrix' => { 94 => 0x17 },
	'pf25defaultclearsettings' => { 95 => 0x1a },
	'pf25drivemode' => { 94 => 0x11 },
	'pf25imagesize' => { 94 => 0x14 },
	'pf25meteringmode' => { 94 => 0x10 },
	'pf25parameters' => { 94 => 0x16 },
	'pf25wbmode' => { 94 => 0x15 },
	'pf26shortenreleaselag' => { 95 => 0x1b },
	'pf27reversedialrotation' => { 95 => 0x1c },
	'pf27value' => { 94 => 0x18 },
	'pf28noquickdialexpcomp' => { 95 => 0x1d },
	'pf29quickdialswitchoff' => { 95 => 0x1e },
	'pf2disablemeteringmodes' => { 95 => 0x3 },
	'pf2value' => { 94 => 0x2 },
	'pf30enlargementmode' => { 95 => 0x1f },
	'pf31originaldecisiondata' => { 95 => 0x20 },
	'pf3manualexposuremetering' => { 95 => 0x4 },
	'pf3value' => { 94 => 0x3 },
	'pf4exposuretimelimits' => { 95 => 0x5 },
	'pf4exposuretimemax' => { 94 => 0x5 },
	'pf4exposuretimemin' => { 94 => 0x4 },
	'pf5aperturelimits' => { 95 => 0x6 },
	'pf5aperturemax' => { 94 => 0x7 },
	'pf5aperturemin' => { 94 => 0x6 },
	'pf6presetshootingmodes' => { 95 => 0x7 },
	'pf7bracketcontinuousshoot' => { 95 => 0x8 },
	'pf8bracketshots' => { 94 => 0x8 },
	'pf8setbracketshots' => { 95 => 0x9 },
	'pf9changebracketsequence' => { 95 => 0xa },
	'phasedetectaf' => { 196 => 0x6 },
	'phonenumber' => { 160 => 'Phone' },
	'photoeffect' => { 36 => 0x28 },
	'photoeffecthistoryxml' => { 297 => 0xe9651831 },
	'photoeffects' => { 297 => 0xab5eca5e },
	'photoeffectsblue' => { 299 => 0x8 },
	'photoeffectsgreen' => { 299 => 0x6 },
	'photoeffectsred' => { 299 => 0x4 },
	'photoeffectstype' => { 299 => 0x0 },
	'photographer' => { 122 => 0xa437 },
	'photographicsensitivity' => { 518 => 'PhotographicSensitivity' },
	'photoidentifier' => { 1 => 0x2b },
	'photoinfoplayback' => { 304 => '17.6', 313 => '33.6' },
	'photometricinterpretation' => { 122 => 0x106, 536 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 244 => 0x11e, 245 => 0x11e, 246 => 0x112, 247 => 0x122, 248 => 0x122, 249 => 0x24, 267 => 0x0 },
	'photoshootingmenubankimagearea' => { 242 => 0x6dd, 244 => 0x144, 245 => 0x144, 246 => 0x134, 247 => 0x148, 248 => 0x148, 267 => '7.1' },
	'photoshopbgrthumbnail' => { 397 => 0x409 },
	'photoshopquality' => { 396 => 0x0 },
	'photoshopthumbnail' => { 397 => 0x40c },
	'photostyle' => { 348 => 0x89 },
	'picasawebgphotoid' => { 516 => 'picasawebGPhotoId' },
	'pick' => { 540 => 'pick' },
	'picklabel' => { 516 => 'PickLabel' },
	'pictinfo' => { 424 => 0x208 },
	'picturecontrol' => { 297 => 0xe2173c47 },
	'picturecontrolactive' => { 300 => 0x0 },
	'picturecontroladjust' => { 255 => 0x30, 256 => 0x30, 257 => 0x36 },
	'picturecontrolbase' => { 255 => 0x18, 256 => 0x18, 257 => 0x1c },
	'picturecontroldata' => { 239 => [0xbd,0x23] },
	'picturecontrolmode' => { 300 => 0x13 },
	'picturecontrolname' => { 255 => 0x4, 256 => 0x4, 257 => 0x8 },
	'picturecontrolquickadjust' => { 255 => 0x31, 256 => 0x31, 257 => 0x37 },
	'pictureeffect' => { 449 => 0x200e },
	'pictureeffect2' => { 458 => 0x1163, 459 => 0x1167, 460 => 0x1143, 461 => 0x11bf, 462 => 0x119b, 463 => 0x1053, 464 => 0x24b, 465 => 0x24b, 466 => 0x23c, 481 => 0x46 },
	'picturefinish' => { 185 => 0x71 },
	'picturemode' => { 130 => 0x1031, 324 => 0x520, 383 => [0xb,0x33], 425 => 0x3d },
	'picturemode2' => { 364 => 0x0 },
	'picturemodebwfilter' => { 324 => 0x525 },
	'picturemodecontrast' => { 324 => 0x523 },
	'picturemodeeffect' => { 324 => 0x52d },
	'picturemodehue' => { 324 => 0x522 },
	'picturemodesaturation' => { 324 => 0x521 },
	'picturemodesharpness' => { 324 => 0x524 },
	'picturemodetone' => { 324 => 0x526 },
	'pictureprofile' => { 458 => [0x115e,0x115f], 459 => [0x1162,0x1163], 460 => [0x113e,0x113f], 461 => [0x11ba,0x11bb], 462 => [0x1196,0x1197], 463 => [0x104e,0x104f], 464 => [0x246,0x247], 465 => [0x246,0x247], 466 => [0x237,0x238] },
	'picturestyle' => { 8 => [0x4b,0x51], 9 => 0xf4, 10 => 0x6c, 11 => 0x86, 12 => 0x73, 16 => 0xab, 17 => 0xa7, 18 => 0xb0, 19 => 0x6c, 20 => 0xa7, 21 => 0xf4, 22 => 0xb3, 24 => 0xf4, 25 => 0xfa, 27 => 0x169, 76 => 0xa, 106 => 0x20301, 112 => 0x2 },
	'picturestylepc' => { 66 => 0x4009 },
	'picturestyleuserdef' => { 66 => 0x4008 },
	'picturewizard' => { 422 => 0x21 },
	'picturewizardcolor' => { 421 => 0x1 },
	'picturewizardcontrast' => { 421 => 0x4 },
	'picturewizardmode' => { 421 => 0x0 },
	'picturewizardsaturation' => { 421 => 0x2 },
	'picturewizardsharpness' => { 421 => 0x3 },
	'pipelineversion' => { 179 => 'PipelineVersion' },
	'pitch' => { 118 => 0x6, 305 => '4.1', 317 => '4.1', 408 => ['ptch',"\xa9fpt"] },
	'pitchangle' => { 253 => 0x4, 324 => 0x904, 338 => 'PitchAngle', 348 => 0x91, 382 => 0x2, 420 => 0x1 },
	'pitchshift' => { 402 => 'player.movie.audio.pitchshift' },
	'pixelaspectratio' => { 401 => 'pasp' },
	'pixelclockfrequency' => { 141 => 0x40b },
	'pixelcorrectionoffset' => { 141 => 0x972 },
	'pixelcorrectionscale' => { 141 => 0x971 },
	'pixelscale' => { 122 => 0x830e },
	'pixelshiftdelay' => { 245 => 0x802 },
	'pixelshiftinfo' => { 449 => 0x202f },
	'pixelshiftnumbershots' => { 245 => 0x800 },
	'pixelshiftoffset' => { 130 => 0x1106 },
	'pixelshiftresolution' => { 384 => 0x0 },
	'pixelshiftshooting' => { 245 => 0x7fe },
	'pixelshiftshots' => { 130 => 0x1105 },
	'pixelsperunitx' => { 336 => 0x0 },
	'pixelsperunity' => { 336 => 0x4 },
	'pixelunits' => { 336 => 0x8 },
	'planarconfiguration' => { 122 => 0x11c, 536 => 'PlanarConfiguration' },
	'plane' => { 490 => [\'Planes','PlanesPlane'] },
	'planeboundary' => { 490 => [\'Planes','PlanesPlaneBoundary'] },
	'planeboundaryvertexcount' => { 490 => [\'Planes','PlanesPlaneBoundaryVertexCount'] },
	'planeextentx' => { 490 => [\'Planes','PlanesPlaneExtentX'] },
	'planeextentz' => { 490 => [\'Planes','PlanesPlaneExtentZ'] },
	'planepose' => { 490 => [\'Planes','PlanesPlanePose'] },
	'planeposepositionx' => { 490 => [\'Planes','PlanesPlanePosePositionX'] },
	'planeposepositiony' => { 490 => [\'Planes','PlanesPlanePosePositionY'] },
	'planeposepositionz' => { 490 => [\'Planes','PlanesPlanePosePositionZ'] },
	'planeposerotationw' => { 490 => [\'Planes','PlanesPlanePoseRotationW'] },
	'planeposerotationx' => { 490 => [\'Planes','PlanesPlanePoseRotationX'] },
	'planeposerotationy' => { 490 => [\'Planes','PlanesPlanePoseRotationY'] },
	'planeposerotationz' => { 490 => [\'Planes','PlanesPlanePoseRotationZ'] },
	'planeposetimestamp' => { 490 => [\'Planes','PlanesPlanePoseTimestamp'] },
	'planes' => { 490 => 'Planes' },
	'planningref' => { 525 => 'PlanningRef' },
	'planningrefidentifier' => { 525 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 525 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 525 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 545 => 'PlateNames' },
	'platform' => { 530 => 'platform' },
	'playallframes' => { 408 => 'AllF' },
	'playbackbutton' => { 245 => 0x804, 248 => 0x808 },
	'playbackbuttonplaybackmode' => { 245 => 0x80e, 248 => 0x814 },
	'playbackflickdown' => { 320 => 0x159, 321 => 0x159, 322 => 0x171 },
	'playbackflickup' => { 320 => 0x155, 321 => 0x155, 322 => 0x16d },
	'playbackmenustime' => { 309 => '20.1', 310 => '21.1', 311 => '21.1' },
	'playbackmonitorofftime' => { 304 => '25.2', 305 => '36.1', 307 => '36.1', 308 => '36.1', 312 => '35.1', 313 => '8.1', 314 => '35.1', 317 => '36.1', 318 => '36.1', 319 => '21.1', 320 => 0x33, 321 => 0x33, 322 => 0x33 },
	'playbackzoom' => { 305 => '37.1' },
	'playdisplay' => { 187 => 0x4e },
	'playerversion' => { 402 => 'player.version' },
	'playgap' => { 400 => 'pgap' },
	'playmode' => { 408 => 'SDLN' },
	'playselection' => { 408 => 'SelO' },
	'plusversion' => { 334 => 'Version' },
	'pmversion' => { 395 => 'PMVersion' },
	'pngwarning' => { 337 => 'Warning' },
	'podcast' => { 400 => 'pcst' },
	'podcasturl' => { 400 => 'purl' },
	'poilevel' => { 238 => 0x8 },
	'portraitimpressionbalance' => { 244 => 0x26e, 245 => 0x26e, 258 => 0xa0 },
	'portraitnote' => { 494 => 'PortraitNote' },
	'portraitoutputhighlightpoint' => { 112 => 0x1d },
	'portraitoutputshadowpoint' => { 112 => 0x1e },
	'portraitrawcolortone' => { 112 => 0x16 },
	'portraitrawcontrast' => { 112 => 0x18 },
	'portraitrawhighlight' => { 112 => 0x76 },
	'portraitrawhighlightpoint' => { 112 => 0x1b },
	'portraitrawlinear' => { 112 => 0x19 },
	'portraitrawsaturation' => { 112 => 0x17 },
	'portraitrawshadow' => { 112 => 0x7f },
	'portraitrawshadowpoint' => { 112 => 0x1c },
	'portraitrawsharpness' => { 112 => 0x1a },
	'portraitrefiner' => { 116 => 0x302b },
	'portraitrequest' => { 494 => 'PortraitRequest' },
	'portraitunsharpmaskfineness' => { 112 => 0x9a },
	'portraitunsharpmaskstrength' => { 112 => 0x98 },
	'portraitunsharpmaskthreshold' => { 112 => 0x9c },
	'portraitversion' => { 494 => 'PortraitVersion' },
	'pose' => { 490 => 'Pose' },
	'poseheadingdegrees' => { 499 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 499 => 'PosePitchDegrees' },
	'posepositionx' => { 490 => [\'Pose','PosePositionX'] },
	'posepositiony' => { 490 => [\'Pose','PosePositionY'] },
	'posepositionz' => { 490 => [\'Pose','PosePositionZ'] },
	'poserolldegrees' => { 499 => 'PoseRollDegrees' },
	'poserotationw' => { 490 => [\'Pose','PoseRotationW'] },
	'poserotationx' => { 490 => [\'Pose','PoseRotationX'] },
	'poserotationy' => { 490 => [\'Pose','PoseRotationY'] },
	'poserotationz' => { 490 => [\'Pose','PoseRotationZ'] },
	'posetimestamp' => { 490 => [\'Pose','PoseTimestamp'] },
	'positiondescriptor' => { 529 => 'positionDescriptor' },
	'postalcode' => { 164 => 'PostalCode' },
	'postcropvignetteamount' => { 511 => 'PostCropVignetteAmount', 513 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 511 => 'PostCropVignetteFeather', 513 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 511 => 'PostCropVignetteHighlightContrast', 513 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 511 => 'PostCropVignetteMidpoint', 513 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 511 => 'PostCropVignetteRoundness', 513 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 511 => 'PostCropVignetteStyle', 513 => 'PostCropVignetteStyle' },
	'postfocusmerging' => { 348 => 0xbf },
	'postreleaseburstlength' => { 247 => 0x714, 248 => 0x784, 320 => 0x289 },
	'potentialface1position' => { 445 => 0xb },
	'potentialface2position' => { 445 => 0x15 },
	'potentialface3position' => { 445 => 0x1f },
	'potentialface4position' => { 445 => 0x29 },
	'potentialface5position' => { 445 => 0x33 },
	'potentialface6position' => { 445 => 0x3d },
	'potentialface7position' => { 445 => 0x47 },
	'potentialface8position' => { 445 => 0x51 },
	'powersource' => { 362 => '0.1' },
	'poweruptime' => { 239 => 0xb6 },
	'preaf' => { 129 => '0.2' },
	'precaptureframes' => { 329 => 0x300 },
	'predictor' => { 122 => 0x13d },
	'preflashreturnstrength' => { 275 => 0x28a },
	'prefs' => { 134 => 0xdd, 395 => 'Prefs' },
	'prereadfastresetcount' => { 141 => 0x187e },
	'prereleaseburstlength' => { 247 => 0x712, 248 => 0x782, 320 => 0x287 },
	'preservedfilename' => { 541 => 'PreservedFileName' },
	'preservedspecimen' => { 121 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 121 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presettype' => { 511 => 'PresetType', 513 => 'PresetType' },
	'presetwhitebalance' => { 187 => 0x24, 486 => 0x8002 },
	'presetwhitebalanceadj' => { 486 => 0x8014 },
	'pressure' => { 122 => 0x9402, 518 => 'Pressure' },
	'previewapplicationname' => { 122 => 0xc716 },
	'previewapplicationversion' => { 122 => 0xc717 },
	'previewbutton' => { 304 => ['14.1','15.1'], 305 => '15.1', 307 => '15.1', 308 => '15.1', 313 => '29.1', 314 => '14.1', 317 => '15.1', 318 => '15.1' },
	'previewbuttonplusdials' => { 304 => ['14.2','15.2'], 305 => '15.2', 307 => '43.1', 308 => '43.1', 313 => '31.2', 317 => '43.1', 318 => '43.1' },
	'previewcolorspace' => { 122 => 0xc71a },
	'previewcropbottom' => { 394 => 0xef },
	'previewcropleft' => { 394 => 0xec },
	'previewcropright' => { 394 => 0xee },
	'previewcroptop' => { 394 => 0xed },
	'previewdate' => { 406 => 0x0 },
	'previewdatetime' => { 122 => 0xc71b },
	'previewimage' => { 116 => 0x2000, 117 => 'Exif-PreviewImage', 123 => 'PreviewImage', 125 => 0x4, 169 => 'data', 189 => 0x81, 329 => 0x280, 346 => 0x300, 408 => 'mcvr', 449 => 0x2001 },
	'previewimageborders' => { 383 => 0x3e },
	'previewimageheight' => { 75 => 0x4, 145 => 0xfa58 },
	'previewimagelength' => { 75 => 0x2, 116 => 0x3, 122 => [0x117,0x202], 189 => 0x89, 259 => 0x202, 324 => 0x102, 329 => 0x1037, 383 => 0x3, 414 => 0x1e, 419 => 0x3, 425 => [0x1b,0x1d], 438 => 0x202 },
	'previewimagename' => { 169 => '1Name' },
	'previewimagesize' => { 116 => 0x2, 150 => 0x2, 169 => 'ImageSize', 383 => 0x2, 425 => [0x1c,0x1e], 449 => 0xb02c, 486 => 0x9012 },
	'previewimagestart' => { 75 => 0x5, 116 => 0x4, 122 => [0x111,0x201], 189 => 0x88, 259 => 0x201, 324 => 0x101, 329 => 0x1036, 383 => 0x4, 414 => 0x1c, 419 => 0x2, 425 => [0x1a,0x1c], 438 => 0x201 },
	'previewimagetype' => { 169 => '0Type' },
	'previewimagevalid' => { 324 => 0x100, 329 => 0x1035 },
	'previewimagewidth' => { 75 => 0x3, 145 => 0xfa57 },
	'previewquality' => { 75 => 0x1 },
	'previewsettingsdigest' => { 122 => 0xc719 },
	'previewsettingsname' => { 122 => 0xc718 },
	'primaryafpoint' => { 196 => [0x38,0x44,0x7,0x8] },
	'primarychromaticities' => { 122 => 0x13f, 536 => 'PrimaryChromaticities' },
	'primaryftp' => { 501 => 'PrimaryFTP' },
	'primaryslot' => { 249 => 0x25, 267 => 0x2 },
	'printim' => { 122 => 0xc4a5 },
	'prioritysetinawb' => { 449 => 0x202b },
	'prioritysetupshutterrelease' => { 187 => 0x1d, 435 => 0x28 },
	'privatertkinfo' => { 503 => 'privateRTKInfo' },
	'processbordercolsleft' => { 141 => 0xc61 },
	'processbordercolsright' => { 141 => 0xc62 },
	'processborderrowsbottom' => { 141 => 0xc64 },
	'processborderrowstop' => { 141 => 0xc63 },
	'processingsoftware' => { 122 => 0xb },
	'processversion' => { 511 => 'ProcessVersion', 513 => 'ProcessVersion' },
	'producer' => { 182 => 'WM/Producer', 333 => 'Producer', 400 => "\xa9prd", 402 => 'producer', 408 => "\xa9prd", 527 => 'Producer' },
	'producerkeywords' => { 408 => "\xa9pdk" },
	'productcode' => { 530 => 'productCode' },
	'productid' => { 135 => 0x32, 400 => 'prID', 529 => 'productID' },
	'productidtype' => { 529 => 'productIDType' },
	'productinimage' => { 525 => 'ProductInImage' },
	'productinimagedescription' => { 525 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 525 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 525 => [\'ProductInImage','ProductInImageProductName'] },
	'productinimageproductid' => { 525 => [\'ProductInImage','ProductInImageProductId'] },
	'productioncode' => { 363 => 0x2 },
	'productorserviceconstraints' => { 334 => 'ProductOrServiceConstraints' },
	'productversion' => { 400 => 'VERS' },
	'profession' => { 530 => 'profession' },
	'profile' => { 490 => [\'Profiles','ProfilesProfile'] },
	'profilecalibrationsig' => { 122 => 0xc6f4 },
	'profilecameraindices' => { 490 => [\'Profiles','ProfilesProfileCameraIndices'] },
	'profilecopyright' => { 122 => 0xc6fe },
	'profiledynamicrange' => { 122 => 0xcd47 },
	'profileembedpolicy' => { 122 => 0xc6fd },
	'profilegaintablemap' => { 122 => 0xcd2d },
	'profilegaintablemap2' => { 122 => 0xcd40 },
	'profilegroupname' => { 122 => 0xcd48 },
	'profilehuesatmapdata1' => { 122 => 0xc6fa },
	'profilehuesatmapdata2' => { 122 => 0xc6fb },
	'profilehuesatmapdata3' => { 122 => 0xcd39 },
	'profilehuesatmapdims' => { 122 => 0xc6f9 },
	'profilehuesatmapencoding' => { 122 => 0xc7a3 },
	'profilelooktabledata' => { 122 => 0xc726 },
	'profilelooktabledims' => { 122 => 0xc725 },
	'profilelooktableencoding' => { 122 => 0xc7a4 },
	'profilename' => { 122 => 0xc6f8, 335 => 'iCCP-name' },
	'profiles' => { 490 => 'Profiles' },
	'profiletonecurve' => { 122 => 0xc6fc },
	'profiletype' => { 490 => [\'Profiles','ProfilesProfileType'] },
	'programiso' => { 348 => 0x3c },
	'programline' => { 364 => '1.1' },
	'programmode' => { 192 => 0x5 },
	'programshift' => { 239 => 0xd },
	'programversion' => { 134 => 0x46 },
	'prohibits' => { 509 => 'prohibits' },
	'projectiontype' => { 499 => 'ProjectionType', 500 => 'ProjectionType' },
	'projectname' => { 540 => 'projectName' },
	'projectref' => { 540 => 'projectRef' },
	'projectrefpath' => { 540 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 540 => [\'projectRef','projectRefType'] },
	'promotionurl' => { 182 => 'WM/PromotionURL' },
	'propertyreleaseid' => { 334 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 334 => 'PropertyReleaseStatus' },
	'provider' => { 182 => 'WM/Provider' },
	'province-state' => { 134 => 0x5f },
	'publicationdate' => { 530 => 'publicationDate' },
	'publicationdatea-platform' => { 530 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 530 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 530 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 530 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 530 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 525 => 'PublicationEvent' },
	'publicationeventdate' => { 525 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 525 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 525 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 530 => 'publicationName' },
	'publisher' => { 182 => 'WM/Publisher', 400 => "\xa9pub", 402 => 'publisher', 514 => 'publisher' },
	'publishingfrequency' => { 530 => 'publishingFrequency' },
	'pulldown' => { 540 => 'pullDown' },
	'purchasedate' => { 400 => 'purd' },
	'purplehsl' => { 106 => 0x20916 },
	'pxshiftperiphedgenr' => { 486 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 486 => 0x9014 },
	'quality' => { 0 => 0x1, 36 => 0x3, 115 => 0x2, 116 => 0x3002, 130 => 0x1000, 143 => 0x9, 239 => 0x4, 286 => 0x3, 329 => 0x201, 343 => 0x300, 383 => 0x8, 390 => 0x2, 425 => 0x16, 435 => 0x56, 436 => 0x56, 437 => 0xb, 449 => [0x102,0x202e] },
	'quality2' => { 458 => 0x1170, 459 => 0x1174, 460 => 0x1150, 462 => 0x11a8, 463 => 0x1060, 464 => 0x258, 465 => 0x258, 466 => 0x247, 472 => 0x29, 473 => 0x25, 474 => 0x2a },
	'qualitybutton' => { 321 => 0x17d, 322 => 0x195 },
	'qualitybuttonplaybackmode' => { 321 => 0x1bf, 322 => 0x1d7 },
	'qualityhint' => { 1 => 0x1a },
	'qualitymode' => { 116 => 0x8 },
	'quantizationmethod' => { 136 => 0x78 },
	'quickadjust' => { 300 => 0x2a },
	'quickcontroldialinmeter' => { 87 => 0x703 },
	'quickfix' => { 297 => 0x416391c6 },
	'quickshot' => { 424 => 0x213 },
	'quiettime' => { 141 => 0x188a },
	'radialdistortioncoefficient1' => { 214 => 0x14 },
	'radialdistortioncoefficient2' => { 214 => 0x1c },
	'radialdistortioncoefficient3' => { 214 => 0x24 },
	'rads' => { 408 => 'rads' },
	'rangefinder' => { 309 => '4.1', 310 => '5.1', 311 => '5.1' },
	'rangemask' => { 511 => 'RangeMaskMapInfo', 513 => 'RangeMaskMapInfo' },
	'rangemaskmapinfo' => { 511 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'], 513 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'] },
	'rangemaskmapinfolabmax' => { 511 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'], 513 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'] },
	'rangemaskmapinfolabmin' => { 511 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'], 513 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'] },
	'rangemaskmapinfolumeq' => { 511 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'], 513 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'] },
	'rangemaskmapinforgbmax' => { 511 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'], 513 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'] },
	'rangemaskmapinforgbmin' => { 511 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'], 513 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'] },
	'rasterizedcaption' => { 134 => 0x7d },
	'rating' => { 122 => 0x4746, 130 => 0x1431, 394 => 0xdf, 400 => 'rtng', 408 => 'rtng', 449 => 0x2002, 506 => 'rating', 515 => 'rating', 525 => 'Rating', 530 => 'rating', 538 => 'Rating' },
	'ratingpercent' => { 122 => 0x4749, 181 => 'Rating', 400 => 'rate', 538 => 'RatingPercent' },
	'ratingregion' => { 525 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 525 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 525 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 525 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 525 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpsaltituderef' => { 525 => [\'Rating','RatingRatingRegionGPSAltitudeRef'] },
	'ratingregiongpslatitude' => { 525 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 525 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 525 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 525 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 525 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 525 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 525 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 525 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 525 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 525 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 525 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 525 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 525 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 85 => 0x8, 189 => 0x109, 364 => 0xd },
	'rawbrightnessadj' => { 106 => 0x20001, 111 => 0x38 },
	'rawburstimagecount' => { 77 => 0x2 },
	'rawburstimagenum' => { 77 => 0x1 },
	'rawcoloradj' => { 111 => 0x2e },
	'rawcropbottom' => { 394 => 0xd4 },
	'rawcropleft' => { 394 => 0xd1 },
	'rawcropright' => { 394 => 0xd3 },
	'rawcroptop' => { 394 => 0xd2 },
	'rawcustomsaturation' => { 111 => 0x30 },
	'rawcustomtone' => { 111 => 0x34 },
	'rawdata' => { 422 => 0xa048 },
	'rawdatabyteorder' => { 422 => 0x40 },
	'rawdatacfapattern' => { 422 => 0x50 },
	'rawdatauniqueid' => { 122 => 0xc65d },
	'rawdepth' => { 191 => 0x10 },
	'rawdevartfilter' => { 331 => 0x121 },
	'rawdevautogradation' => { 331 => 0x119 },
	'rawdevcolorspace' => { 330 => 0x108, 331 => 0x109 },
	'rawdevcontrastvalue' => { 330 => 0x106, 331 => 0x105 },
	'rawdeveditstatus' => { 330 => 0x10b },
	'rawdevelopingsoftware' => { 122 => 0xa43a },
	'rawdevelopmentprocess' => { 383 => 0x62 },
	'rawdevengine' => { 330 => 0x109, 331 => 0x10b },
	'rawdevexposurebiasvalue' => { 330 => 0x100, 331 => 0x100 },
	'rawdevgradation' => { 331 => 0x112 },
	'rawdevgraypoint' => { 330 => 0x103, 331 => 0x104 },
	'rawdevmemorycoloremphasis' => { 330 => 0x105, 331 => 0x108 },
	'rawdevnoisereduction' => { 330 => 0x10a, 331 => 0x10a },
	'rawdevpicturemode' => { 331 => 0x10c },
	'rawdevpm_bwfilter' => { 331 => 0x110 },
	'rawdevpmcontrast' => { 331 => 0x10e },
	'rawdevpmnoisefilter' => { 331 => 0x120 },
	'rawdevpmpicturetone' => { 331 => 0x111 },
	'rawdevpmsaturation' => { 331 => 0x10d },
	'rawdevpmsharpness' => { 331 => 0x10f },
	'rawdevsaturation3' => { 331 => 0x113 },
	'rawdevsaturationemphasis' => { 330 => 0x104, 331 => 0x107 },
	'rawdevsettings' => { 330 => 0x10c },
	'rawdevsharpnessvalue' => { 330 => 0x107, 331 => 0x106 },
	'rawdevversion' => { 330 => 0x0, 331 => 0x0 },
	'rawdevwbfineadjustment' => { 330 => 0x102, 331 => 0x103 },
	'rawdevwhitebalance' => { 331 => 0x101 },
	'rawdevwhitebalancevalue' => { 330 => 0x101, 331 => 0x102 },
	'rawfile' => { 122 => 0xfe4c },
	'rawfilename' => { 511 => 'RawFileName', 513 => 'RawFileName' },
	'rawfiletype' => { 449 => 0x2029 },
	'rawformat' => { 353 => 0x2d, 392 => 0x10e },
	'rawimagecenter' => { 239 => 0x99 },
	'rawimagedigest' => { 122 => 0xc71c },
	'rawimagesize' => { 383 => 0x39 },
	'rawinfoversion' => { 332 => 0x0 },
	'rawjpgheight' => { 102 => 0x4 },
	'rawjpgquality' => { 59 => 0x6, 102 => 0x1 },
	'rawjpgsize' => { 59 => 0x7, 102 => 0x2 },
	'rawjpgwidth' => { 102 => 0x3 },
	'rawmeasuredrggb' => { 45 => 0x26a, 47 => 0x280, 49 => 0x194, 50 => [0x1ad,0x26b] },
	'rawrppused' => { 506 => 'rawrppused' },
	'rawtopreviewgain' => { 122 => 0xc7a8 },
	'readouttypeactual' => { 141 => 0x1903 },
	'readouttyperequested' => { 141 => 0x1902 },
	'reardisplay' => { 304 => '12.3', 305 => '6.2' },
	'recdevice' => { 525 => 'RecDevice' },
	'recdeviceattlensdescription' => { 525 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 525 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 525 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 525 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 525 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 532 => 'recipeEndingPage' },
	'recipepagerange' => { 532 => 'recipePageRange' },
	'recipesource' => { 532 => 'recipeSource' },
	'recipestartingpage' => { 532 => 'recipeStartingPage' },
	'recipetitle' => { 532 => 'recipeTitle' },
	'recognizedface1age' => { 341 => 0x20 },
	'recognizedface1name' => { 341 => 0x4 },
	'recognizedface1position' => { 341 => 0x18 },
	'recognizedface2age' => { 341 => 0x50 },
	'recognizedface2name' => { 341 => 0x34 },
	'recognizedface2position' => { 341 => 0x48 },
	'recognizedface3age' => { 341 => 0x80 },
	'recognizedface3name' => { 341 => 0x64 },
	'recognizedface3position' => { 341 => 0x78 },
	'recognizedfaceflags' => { 348 => 0x63 },
	'recommendedexposureindex' => { 122 => 0x8832, 518 => 'RecommendedExposureIndex' },
	'record' => { 121 => 'Record' },
	'recordbasisofrecord' => { 121 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 121 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 121 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 121 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 121 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 121 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 187 => 0x4d },
	'recorddynamicproperties' => { 121 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 100 => 0x1804 },
	'recordinformationwithheld' => { 121 => [\'Record','RecordInformationWithheld'] },
	'recordingcopyright' => { 408 => "\xa9phg" },
	'recordingformat' => { 415 => 0x1000 },
	'recordingmode' => { 115 => 0x1, 390 => 0x1 },
	'recordinstitutioncode' => { 121 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 121 => [\'Record','RecordInstitutionID'] },
	'recordlabelname' => { 408 => "\xa9lab" },
	'recordlabelurl' => { 408 => "\xa9lal" },
	'recordlocationdata' => { 246 => 0x660, 247 => 0x690, 248 => 0x6f8 },
	'recordmode' => { 36 => 0x9, 116 => 0x3000 },
	'recordownerinstitutioncode' => { 121 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 424 => 0x217 },
	'redbalance' => { 329 => 0x1017, 353 => 0x11, 383 => 0x1c },
	'redcurvelimits' => { 111 => 0x18a },
	'redcurvepoints' => { 110 => 0x2d, 111 => 0x160 },
	'redeyecorrection' => { 301 => 0x0 },
	'redeyeinfo' => { 511 => 'RedEyeInfo', 513 => 'RedEyeInfo' },
	'redeyereduction' => { 187 => 0x41, 435 => 0x6a, 437 => 0x28 },
	'redeyeremoval' => { 348 => 0xb9 },
	'redhsl' => { 106 => 0x20910 },
	'redhue' => { 511 => 'RedHue', 513 => 'RedHue' },
	'redsaturation' => { 511 => 'RedSaturation', 513 => 'RedSaturation' },
	'reductionmatrix1' => { 122 => 0xc625 },
	'reductionmatrix2' => { 122 => 0xc626 },
	'reductionmatrix3' => { 122 => 0xcd3a },
	'reelname' => { 122 => 0xc789, 408 => 'reel' },
	'reference1' => { 523 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 523 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 523 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 523 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 523 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 523 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 122 => 0x214, 536 => 'ReferenceBlackWhite' },
	'referencedate' => { 134 => 0x2f },
	'referencenumber' => { 134 => 0x32 },
	'references' => { 160 => 'References' },
	'referenceservice' => { 134 => 0x2d },
	'regionappliedtodimensions' => { 175 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 175 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 175 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 175 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 175 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 175 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 175 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 175 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 175 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 175 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 175 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 175 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 334 => 'RegionConstraints' },
	'regiondescription' => { 175 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 175 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 175 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 175 => 'Regions' },
	'regioninfoacdsee' => { 487 => 'Regions' },
	'regioninfodateregionsvalid' => { 178 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 178 => 'RegionInfo' },
	'regioninforegions' => { 178 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 175 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 175 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 178 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 178 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 178 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 178 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 178 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 175 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 175 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 175 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 525 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 525 => 'RegistryId' },
	'registryitemid' => { 525 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 525 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 158 => 'data' },
	'relatedaudiofilename' => { 158 => '1Name' },
	'relatedaudiofiletype' => { 158 => '0Type' },
	'relatedimagefileformat' => { 122 => 0x1000 },
	'relatedimageheight' => { 122 => 0x1002 },
	'relatedimagewidth' => { 122 => 0x1001 },
	'relatedresourceid' => { 121 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 122 => 0xa004, 517 => 'RelatedSoundFile' },
	'relatedvideofile' => { 172 => 'data' },
	'relatedvideofilename' => { 172 => '1Name' },
	'relatedvideofiletype' => { 172 => '0Type' },
	'relation' => { 514 => 'relation' },
	'relationshipaccordingto' => { 121 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 121 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 121 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipofresourceid' => { 121 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResourceID'] },
	'relationshipremarks' => { 121 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 119 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 540 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 540 => 'relativeTimestamp' },
	'relativetimestampscale' => { 540 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 540 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 304 => '17.8', 305 => '18.5', 307 => '18.4', 308 => '18.4', 313 => '33.8', 314 => '17.6', 317 => '18.5', 318 => '18.4' },
	'releasedate' => { 134 => 0x1e, 400 => 'rldt', 506 => 'ReleaseDate', 540 => 'releaseDate' },
	'releasemode' => { 116 => 0x3001, 243 => 0x5c, 277 => 0x184d, 449 => 0xb049 },
	'releasemode2' => { 458 => 0x112c, 459 => [0x112c,0x8], 460 => [0x1108,0x8], 461 => [0x1184,0x8], 462 => [0x1160,0x8], 463 => [0x4,0x1018], 464 => [0x4,0x210], 465 => [0x4,0x210], 466 => [0x4,0x208], 468 => [0x67,0x3f], 469 => [0x6b,0x6d,0x73,0x4b], 470 => [0x6b,0x4b], 471 => 0x1f, 472 => 0x10, 473 => 0x10, 474 => 0x9, 481 => 0x34 },
	'releasemode3' => { 458 => 0x1128, 459 => 0x1128, 460 => 0x1104, 461 => 0x1180, 462 => 0x115c, 463 => 0x1014, 464 => 0x20c, 465 => 0x20c, 466 => 0x204 },
	'releaseready' => { 525 => 'ReleaseReady' },
	'releasesetting' => { 100 => 0x1016 },
	'releasetime' => { 134 => 0x23, 506 => 'ReleaseTime' },
	'remoteonduration' => { 306 => '3.4', 309 => '17.2', 310 => '18.2', 311 => '18.2', 312 => '18.2', 314 => '18.2', 315 => '4.3', 319 => '19.2' },
	'renditionclass' => { 541 => 'RenditionClass' },
	'renditionof' => { 541 => 'RenditionOf' },
	'renditionofalternatepaths' => { 541 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 541 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 541 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 541 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 541 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 541 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 541 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 541 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 541 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 541 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 541 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 541 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 541 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 541 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 541 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 541 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 541 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 541 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 541 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 541 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 541 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 541 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 541 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 541 => 'RenditionParams' },
	'repeatingflashcount' => { 217 => 0xd, 218 => 0xe, 219 => 0xe, 220 => 0xe, 221 => 0xe, 222 => 0xe, 313 => '17.2', 314 => '24.2', 315 => '9.2', 316 => '24.2', 319 => '25.2' },
	'repeatingflashcountbuilt-in' => { 284 => 0x4db },
	'repeatingflashcountexternal' => { 284 => 0x4c3 },
	'repeatingflashoutput' => { 313 => '17.1', 314 => '24.1', 315 => '9.1', 316 => '24.1', 319 => '25.1' },
	'repeatingflashoutputexternal' => { 284 => 0x4c0 },
	'repeatingflashrate' => { 217 => 0xc, 218 => 0xd, 219 => 0xd, 220 => 0xd, 221 => 0xd, 222 => 0xd, 313 => '18.1', 314 => '25.1', 315 => '10.1', 316 => '25.1', 319 => '26.1' },
	'repeatingflashratebuilt-in' => { 284 => 0x4da },
	'repeatingflashrateexternal' => { 284 => 0x4c2 },
	'requirements' => { 408 => "\xa9req" },
	'requires' => { 509 => 'requires' },
	'resampleparams' => { 540 => 'resampleParams' },
	'resampleparamsquality' => { 540 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 141 => 0xe50 },
	'resamplingkerneldenominators067' => { 141 => 0xe4f },
	'resamplingkerneldenominators100' => { 141 => 0xe51 },
	'resaved' => { 424 => 0x21e },
	'resetblacksegrows' => { 141 => 0x181a },
	'resolution' => { 165 => 'Resolution' },
	'resolutionmode' => { 425 => [0x87,0x4] },
	'resolutionunit' => { 122 => 0x128, 137 => 0x2, 536 => 'ResolutionUnit' },
	'resourceid' => { 121 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 121 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 121 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 87 => 0x612 },
	'restrictions' => { 533 => 'restrictions' },
	'retouchareafeather' => { 511 => [\'RetouchAreas','RetouchAreasFeather'], 513 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 511 => [\'RetouchAreas','RetouchAreasMasksAlpha'], 513 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 511 => [\'RetouchAreas','RetouchAreasMasksAngle'], 513 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 511 => [\'RetouchAreas','RetouchAreasMasksBottom'], 513 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 511 => [\'RetouchAreas','RetouchAreasMasksCenterValue'], 513 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 511 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'], 513 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 511 => [\'RetouchAreas','RetouchAreasMasksDabs'], 513 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 511 => [\'RetouchAreas','RetouchAreasMasksFeather'], 513 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 511 => [\'RetouchAreas','RetouchAreasMasksFlipped'], 513 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 511 => [\'RetouchAreas','RetouchAreasMasksFlow'], 513 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 511 => [\'RetouchAreas','RetouchAreasMasksFullX'], 513 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 511 => [\'RetouchAreas','RetouchAreasMasksFullY'], 513 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskinputdigest' => { 511 => [\'RetouchAreas','RetouchAreasMasksInputDigest'], 513 => [\'RetouchAreas','RetouchAreasMasksInputDigest'] },
	'retouchareamaskleft' => { 511 => [\'RetouchAreas','RetouchAreasMasksLeft'], 513 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmaskactive' => { 511 => [\'RetouchAreas','RetouchAreasMasksMaskActive'], 513 => [\'RetouchAreas','RetouchAreasMasksMaskActive'] },
	'retouchareamaskmaskblendmode' => { 511 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'], 513 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'] },
	'retouchareamaskmaskdigest' => { 511 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'], 513 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'] },
	'retouchareamaskmaskinverted' => { 511 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'], 513 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'] },
	'retouchareamaskmaskname' => { 511 => [\'RetouchAreas','RetouchAreasMasksMaskName'], 513 => [\'RetouchAreas','RetouchAreasMasksMaskName'] },
	'retouchareamaskmasks' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasks'], 513 => [\'RetouchAreas','RetouchAreasMasksMasks'] },
	'retouchareamaskmasksalpha' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'] },
	'retouchareamaskmasksangle' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'] },
	'retouchareamaskmasksbottom' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'] },
	'retouchareamaskmaskscentervalue' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'] },
	'retouchareamaskmaskscenterweight' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'] },
	'retouchareamaskmasksdabs' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'] },
	'retouchareamaskmasksfeather' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'] },
	'retouchareamaskmasksflipped' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'] },
	'retouchareamaskmasksflow' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'] },
	'retouchareamaskmasksfullx' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'] },
	'retouchareamaskmasksfully' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'] },
	'retouchareamaskmasksinputdigest' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'] },
	'retouchareamaskmasksleft' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'] },
	'retouchareamaskmasksmaskactive' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'] },
	'retouchareamaskmasksmaskblendmode' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'] },
	'retouchareamaskmasksmaskdigest' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'] },
	'retouchareamaskmasksmaskinverted' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'] },
	'retouchareamaskmasksmaskname' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'] },
	'retouchareamaskmasksmasksubtype' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'] },
	'retouchareamaskmasksmasksyncid' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'] },
	'retouchareamaskmasksmaskversion' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'] },
	'retouchareamaskmasksmidpoint' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'] },
	'retouchareamaskmasksorigin' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'] },
	'retouchareamaskmasksperimetervalue' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'] },
	'retouchareamaskmasksradius' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'] },
	'retouchareamaskmasksreferencepoint' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'] },
	'retouchareamaskmasksright' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksRight'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksRight'] },
	'retouchareamaskmasksroundness' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'] },
	'retouchareamaskmaskssizex' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'] },
	'retouchareamaskmaskssizey' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'] },
	'retouchareamaskmaskstop' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksTop'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksTop'] },
	'retouchareamaskmasksubtype' => { 511 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'], 513 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'] },
	'retouchareamaskmasksvalue' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'] },
	'retouchareamaskmasksversion' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'] },
	'retouchareamaskmaskswhat' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'] },
	'retouchareamaskmaskswholeimagearea' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'] },
	'retouchareamaskmasksx' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksX'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksX'] },
	'retouchareamaskmasksy' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksY'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksY'] },
	'retouchareamaskmasksyncid' => { 511 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'], 513 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'] },
	'retouchareamaskmaskszerox' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'] },
	'retouchareamaskmaskszeroy' => { 511 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'], 513 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'] },
	'retouchareamaskmaskversion' => { 511 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'], 513 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'] },
	'retouchareamaskmidpoint' => { 511 => [\'RetouchAreas','RetouchAreasMasksMidpoint'], 513 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskorigin' => { 511 => [\'RetouchAreas','RetouchAreasMasksOrigin'], 513 => [\'RetouchAreas','RetouchAreasMasksOrigin'] },
	'retouchareamaskperimetervalue' => { 511 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'], 513 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 511 => [\'RetouchAreas','RetouchAreasMasksRadius'], 513 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskrange' => { 511 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'], 513 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'] },
	'retouchareamaskrangeareamodels' => { 511 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'], 513 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'] },
	'retouchareamaskrangeareamodelscolorsampleinfo' => { 511 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 513 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'retouchareamaskrangeareamodelscomponents' => { 511 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'], 513 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'retouchareamaskrangecoloramount' => { 511 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'], 513 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'] },
	'retouchareamaskrangedepthfeather' => { 511 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'], 513 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'] },
	'retouchareamaskrangedepthmax' => { 511 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'], 513 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'] },
	'retouchareamaskrangedepthmin' => { 511 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'], 513 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'] },
	'retouchareamaskrangeinvert' => { 511 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'], 513 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'] },
	'retouchareamaskrangelumfeather' => { 511 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'], 513 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'] },
	'retouchareamaskrangeluminancedepthsampleinfo' => { 511 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 513 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'retouchareamaskrangelummax' => { 511 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'], 513 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'] },
	'retouchareamaskrangelummin' => { 511 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'], 513 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'] },
	'retouchareamaskrangelumrange' => { 511 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'], 513 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'] },
	'retouchareamaskrangesampletype' => { 511 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'], 513 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'] },
	'retouchareamaskrangetype' => { 511 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'], 513 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'] },
	'retouchareamaskrangeversion' => { 511 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'], 513 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'] },
	'retouchareamaskreferencepoint' => { 511 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'], 513 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'] },
	'retouchareamaskright' => { 511 => [\'RetouchAreas','RetouchAreasMasksRight'], 513 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 511 => [\'RetouchAreas','RetouchAreasMasksRoundness'], 513 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 511 => [\'RetouchAreas','RetouchAreasMasks'], 513 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 511 => [\'RetouchAreas','RetouchAreasMasksSizeX'], 513 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 511 => [\'RetouchAreas','RetouchAreasMasksSizeY'], 513 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 511 => [\'RetouchAreas','RetouchAreasMasksTop'], 513 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 511 => [\'RetouchAreas','RetouchAreasMasksMaskValue'], 513 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 511 => [\'RetouchAreas','RetouchAreasMasksVersion'], 513 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 511 => [\'RetouchAreas','RetouchAreasMasksWhat'], 513 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskwholeimagearea' => { 511 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'], 513 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'] },
	'retouchareamaskx' => { 511 => [\'RetouchAreas','RetouchAreasMasksX'], 513 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 511 => [\'RetouchAreas','RetouchAreasMasksY'], 513 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 511 => [\'RetouchAreas','RetouchAreasMasksZeroX'], 513 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 511 => [\'RetouchAreas','RetouchAreasMasksZeroY'], 513 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 511 => [\'RetouchAreas','RetouchAreasMethod'], 513 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 511 => [\'RetouchAreas','RetouchAreasOffsetY'], 513 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 511 => [\'RetouchAreas','RetouchAreasOpacity'], 513 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 511 => 'RetouchAreas', 513 => 'RetouchAreas' },
	'retouchareaseed' => { 511 => [\'RetouchAreas','RetouchAreasSeed'], 513 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 511 => [\'RetouchAreas','RetouchAreasSourceState'], 513 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 511 => [\'RetouchAreas','RetouchAreasSourceX'], 513 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 511 => [\'RetouchAreas','RetouchAreasSpotType'], 513 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 239 => 0x9e },
	'retouchinfo' => { 511 => 'RetouchInfo', 513 => 'RetouchInfo' },
	'retouchnefprocessing' => { 261 => 0x5 },
	'retractlensonpoweroff' => { 87 => 0x814 },
	'reuse' => { 334 => 'Reuse' },
	'reuseallowed' => { 543 => 'ReuseAllowed' },
	'reuseprohibited' => { 533 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 311 => '5.2' },
	'reversefocusring' => { 320 => 0x163, 321 => 0x163, 322 => 0x17b },
	'reverseindicators' => { 304 => '12.1', 305 => '6.1', 307 => '6.1', 308 => '6.1', 309 => '4.3', 310 => '5.2', 311 => '5.4', 313 => '33.5', 314 => '5.1', 317 => '6.1', 318 => '6.1', 319 => '6.2', 320 => 0xc1, 321 => 0xc1, 322 => 0xc1 },
	'reverseshutterspeedaperture' => { 311 => '5.3' },
	'revision' => { 515 => 'revision' },
	'rflensmffocusringsensitivity' => { 87 => 0x714 },
	'rflenstype' => { 59 => 0x3d },
	'rgbcurvelimits' => { 111 => 0x238 },
	'rgbcurvepoints' => { 110 => 0x7, 111 => 0x20e },
	'rgbtables' => { 122 => 0xcd3b },
	'richtextcomment' => { 520 => 'RichTextComment' },
	'ricohdate' => { 414 => 0x6 },
	'ricohimageheight' => { 414 => 0x2 },
	'ricohimagewidth' => { 414 => 0x0 },
	'rightalbedo' => { 502 => 'RightAlbedo' },
	'rightascension' => { 168 => 'RightAscension' },
	'rights' => { 514 => 'rights' },
	'rightsagent' => { 533 => 'rightsAgent' },
	'rightsowner' => { 533 => 'rightsOwner' },
	'roll' => { 118 => 0x8, 408 => ['roll',"\xa9frl"] },
	'rollangle' => { 130 => 0x144d, 253 => 0x0, 324 => 0x903, 338 => 'RollAngle', 348 => 0x90, 382 => 0x1, 420 => 0x2 },
	'romoperationmode' => { 100 => 0x80d },
	'rotation' => { 31 => 0x17, 32 => 0x18, 99 => 0x3, 106 => 0x10002, 111 => 0x26e, 117 => 'QuickTime-Rotation', 126 => 0x4, 168 => 'Rotation', 185 => [0x65,0x50], 186 => 0x46, 187 => 0x5a, 190 => 0x10, 262 => 0x1a, 277 => 0x3693, 283 => '590.1', 297 => 0x76a43207, 348 => 0x30, 364 => '17.2', 394 => 0xd8, 401 => 'irot', 435 => 0x3f, 436 => 0x3f, 446 => 0x10 },
	'routedto' => { 519 => 'RoutedTo' },
	'routing' => { 399 => 'Routing' },
	'routingdestinations' => { 501 => 'RoutingDestinations' },
	'routingexclusions' => { 501 => 'RoutingExclusions' },
	'routingnotes' => { 519 => 'RoutingNotes' },
	'rowsperstrip' => { 122 => 0x116 },
	'rpp' => { 506 => 'rpp' },
	'rtkflag' => { 119 => 'RtkFlag' },
	'rtkstdhgt' => { 119 => 'RtkStdHgt' },
	'rtkstdlat' => { 119 => 'RtkStdLat' },
	'rtkstdlon' => { 119 => 'RtkStdLon' },
	'safetyshift' => { 87 => 0x108 },
	'safetyshiftinavortv' => { 85 => 0x10, 86 => 0x10, 88 => 0xf, 89 => 0x10, 92 => 0x10 },
	'sameexposurefornewaperture' => { 87 => 0x112 },
	'samplebits' => { 158 => 'SampleBits' },
	'samplepagerange' => { 530 => 'samplePageRange' },
	'samplerate' => { 158 => 'SampleRate' },
	'samplesperpixel' => { 122 => 0x115, 353 => 0x8, 536 => 'SamplesPerPixel' },
	'samplestructure' => { 136 => 0x5a },
	'samsungmodelid' => { 422 => 0x3 },
	'sanyoquality' => { 424 => 0x201 },
	'sanyothumbnail' => { 424 => 0x100 },
	'saturation' => { 10 => 0x6e, 12 => 0x76, 36 => 0xe, 53 => 0x1, 65 => 0x7, 115 => 0xd, 116 => [0x3013,0x1f], 122 => [0xa409,0xfe55], 130 => 0x1003, 159 => 'Saturation', 184 => 0x1f, 185 => 0x32, 186 => 0x28, 187 => 0x1a, 192 => 0x1, 239 => 0xaa, 255 => 0x35, 256 => 0x3b, 257 => 0x43, 348 => 0x40, 350 => 0x300d, 383 => 0x1f, 390 => 0xd, 409 => 0x27, 411 => 0x58, 414 => 0x28, 415 => 0x1013, 425 => 0x10, 435 => 0x1e, 436 => 0x1b, 449 => 0x2005, 511 => 'Saturation', 513 => 'Saturation', 517 => 'Saturation' },
	'saturationadj' => { 106 => 0x20901, 111 => 0x116, 239 => 0x94, 296 => 0x1, 300 => 0x2e, 486 => 0x8016 },
	'saturationadjustmentaqua' => { 511 => 'SaturationAdjustmentAqua', 513 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 511 => 'SaturationAdjustmentBlue', 513 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 511 => 'SaturationAdjustmentGreen', 513 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 511 => 'SaturationAdjustmentMagenta', 513 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 511 => 'SaturationAdjustmentOrange', 513 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 511 => 'SaturationAdjustmentPurple', 513 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 511 => 'SaturationAdjustmentRed', 513 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 511 => 'SaturationAdjustmentYellow', 513 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 73 => 0x98 },
	'saturationfaithful' => { 19 => 0xfe, 72 => 0x68, 73 => 0x68 },
	'saturationlandscape' => { 19 => 0xfc, 72 => 0x38, 73 => 0x38 },
	'saturationmonochrome' => { 72 => 0x80, 73 => 0x80 },
	'saturationneutral' => { 19 => 0xfd, 72 => 0x50, 73 => 0x50 },
	'saturationportrait' => { 19 => 0xfb, 72 => 0x20, 73 => 0x20 },
	'saturationsetting' => { 332 => 0x1010, 437 => 0x11, 454 => 0x9 },
	'saturationstandard' => { 19 => 0xfa, 72 => 0x8, 73 => 0x8 },
	'saturationuserdef1' => { 19 => 0x100, 72 => 0x98, 73 => 0xb0 },
	'saturationuserdef2' => { 19 => 0x101, 72 => 0xb0, 73 => 0xc8 },
	'saturationuserdef3' => { 19 => 0x102, 72 => 0xc8, 73 => 0xe0 },
	'saveid' => { 541 => 'SaveID' },
	'sbaanalysiscomplete' => { 141 => 0xc35 },
	'sbablack' => { 141 => 0xc25 },
	'sbagmoffset' => { 141 => 0xc4a },
	'sbagray' => { 141 => 0xc26 },
	'sbagreenmagentabal' => { 141 => 0xc33 },
	'sbahighgray' => { 141 => 0xc46 },
	'sbailloffset' => { 141 => 0xc49 },
	'sbailluminantbal' => { 141 => 0xc34 },
	'sbalowgray' => { 141 => 0xc47 },
	'sbaneutralbal' => { 141 => 0xc32 },
	'sbawhite' => { 141 => 0xc27 },
	'scaletype' => { 540 => 'scaleType' },
	'scalingfactorheight' => { 338 => 'ScalingFactorHeight' },
	'scanimageenhancer' => { 263 => 0x60 },
	'scanningdirection' => { 136 => 0x64 },
	'scene' => { 408 => 'scen', 524 => 'Scene', 540 => 'scene' },
	'scenearea' => { 327 => 0x211, 329 => 0x1031 },
	'sceneassist' => { 239 => 0x9c },
	'scenecapturetype' => { 122 => 0xa406, 517 => 'SceneCaptureType' },
	'scenedetect' => { 327 => 0x210, 329 => 0x1030 },
	'scenedetectdata' => { 327 => 0x212, 329 => 0x1033 },
	'sceneflags' => { 1 => 0x25 },
	'scenemode' => { 145 => 0xfa02, 189 => 0x100, 239 => 0x8f, 324 => 0x509, 329 => 0x403, 348 => 0x8001, 357 => 0xf, 449 => 0xb023 },
	'scenemodeused' => { 147 => [0x6002,0xf002] },
	'scenerecognition' => { 130 => 0x1425 },
	'scenereferred' => { 521 => 'scene_referred' },
	'sceneselect' => { 424 => 0x21f },
	'scenetype' => { 122 => 0xa301, 517 => 'SceneType' },
	'screentips' => { 304 => '12.7', 305 => '5.3', 313 => '13.1', 314 => '4.4', 317 => '5.4', 319 => '5.1' },
	'scriptversion' => { 141 => 0x1770 },
	'sdrblend' => { 511 => 'SDRBlend', 513 => 'SDRBlend' },
	'sdrbrightness' => { 511 => 'SDRBrightness', 513 => 'SDRBrightness' },
	'sdrcontrast' => { 511 => 'SDRContrast', 513 => 'SDRContrast' },
	'sdrhighlights' => { 511 => 'SDRHighlights', 513 => 'SDRHighlights' },
	'sdrshadows' => { 511 => 'SDRShadows', 513 => 'SDRShadows' },
	'sdrwhites' => { 511 => 'SDRWhites', 513 => 'SDRWhites' },
	'season' => { 525 => 'Season', 529 => 'season' },
	'seasonidentifier' => { 525 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 525 => [\'Season','SeasonName'] },
	'seasonnumber' => { 525 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 501 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 244 => 0x240, 245 => 0x240, 246 => 0x22c, 247 => 0x240, 248 => 0x240, 266 => 0x13c, 277 => 0x1d0 },
	'section' => { 530 => 'section' },
	'securityclassification' => { 122 => 0x9212 },
	'selectableafpoint' => { 87 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 87 => 0x512 },
	'selfdata' => { 119 => 'SelfData' },
	'selftimer' => { 36 => 0x2, 348 => 0x2e, 424 => 0x214, 458 => 0x1134, 459 => 0x1134, 460 => 0x1110, 461 => 0x118c, 462 => 0x1168, 463 => 0x1020, 464 => 0x218, 465 => 0x218, 466 => 0x210 },
	'selftimer2' => { 79 => 0x1d },
	'selftimerinterval' => { 314 => '19.2' },
	'selftimermode' => { 122 => 0x882b },
	'selftimershotcount' => { 305 => '20.2', 307 => '20.3', 308 => '20.3', 309 => '18.2', 310 => '19.2', 311 => '19.2', 312 => '19.3', 314 => '19.3', 317 => '20.3', 318 => '20.3', 319 => '20.2', 320 => 0x2d, 321 => 0x2d, 322 => 0x2d },
	'selftimershotinterval' => { 305 => '20.3', 307 => '20.2', 308 => '20.2', 312 => '19.2', 317 => '20.2', 318 => '20.2', 320 => 0x31, 321 => 0x31, 322 => 0x31 },
	'selftimertime' => { 100 => 0x1806, 187 => 0x1f, 304 => '18.1', 305 => '20.1', 306 => '3.3', 307 => '20.1', 308 => '20.1', 309 => '18.1', 310 => '19.1', 311 => '19.1', 312 => '19.1', 313 => '7.2', 314 => '19.1', 315 => '3.3', 317 => '20.1', 318 => '20.1', 319 => '20.1', 320 => 0x2b, 321 => 0x2b, 322 => 0x2b },
	'sellingagency' => { 530 => 'sellingAgency' },
	'semanticstyle' => { 1 => 0x40 },
	'semanticstylepreset' => { 1 => 0x42 },
	'semanticstylerenderingver' => { 1 => 0x41 },
	'seminfo' => { 122 => 0x8546 },
	'sensingmethod' => { 122 => 0xa217, 517 => 'SensingMethod' },
	'sensitivityadjust' => { 383 => 0x40 },
	'sensitivitysteps' => { 364 => ['14.3','17.4'], 366 => 0x1 },
	'sensitivitytype' => { 122 => 0x8830, 518 => 'SensitivityType' },
	'sensor' => { 194 => 0x665e },
	'sensorarea' => { 329 => 0x400 },
	'sensorareas' => { 422 => 0xa010 },
	'sensorbitdepth' => { 350 => 0x312d },
	'sensorbluelevel' => { 76 => 0x5 },
	'sensorcalibration' => { 328 => 0x805 },
	'sensorcleaning' => { 93 => 0xd },
	'sensorfullheight' => { 140 => 0xf904 },
	'sensorfullwidth' => { 140 => 0xf903 },
	'sensorheight' => { 140 => 0xf901, 145 => 0xfa21, 191 => 0x8, 350 => 0x312c, 392 => 0x109, 415 => 0x1602 },
	'sensorimageheight' => { 141 => 0x3ee },
	'sensorimagewidth' => { 141 => 0x3ed },
	'sensorleftborder' => { 141 => 0x3eb },
	'sensorleftmargin' => { 392 => 0x10a },
	'sensorpixelsize' => { 239 => 0x9a },
	'sensorredlevel' => { 76 => 0x4 },
	'sensorserialnumber' => { 141 => 0x9ce },
	'sensorshield' => { 244 => 0x76b, 245 => 0x77b, 246 => 0x66d, 247 => 0x69d, 248 => 0x705 },
	'sensorsize' => { 159 => 'SensorSize', 383 => 0x35 },
	'sensortemperature' => { 327 => 0x1500, 329 => 0x1007, 388 => 0xc, 392 => 0x210, 425 => [0x39,0x55] },
	'sensortemperature2' => { 388 => 0xe, 392 => 0x211 },
	'sensortopborder' => { 141 => 0x3ec },
	'sensortopmargin' => { 392 => 0x10b },
	'sensortype' => { 348 => 0xca },
	'sensorwidth' => { 140 => 0xf900, 145 => 0xfa20, 191 => 0xa, 350 => 0x312b, 392 => 0x108, 415 => 0x1601 },
	'sequence' => { 409 => 0x7, 410 => 0x35, 411 => 0x36 },
	'sequencefilenumber' => { 459 => 0x4, 460 => 0x4, 461 => 0x4, 462 => 0x4, 472 => 0xc, 473 => 0xc, 474 => 0x1a },
	'sequenceimagenumber' => { 459 => 0x0, 460 => 0x0, 461 => 0x0, 462 => 0x0, 472 => 0x8, 473 => 0x8, 474 => 0x12, 481 => 0x24 },
	'sequencelength' => { 472 => 0x22, 473 => 0x1e, 474 => [0x16,0x1e] },
	'sequencename' => { 529 => 'sequenceName' },
	'sequencenumber' => { 79 => 0x9, 116 => 0x301c, 130 => 0x1101, 143 => 0x1d, 284 => 0x51c, 348 => 0x2b, 437 => [0x10c,0x30c], 449 => 0xb04a, 529 => 'sequenceNumber' },
	'sequenceshotinterval' => { 424 => 0x224 },
	'sequencetotalnumber' => { 529 => 'sequenceTotalNumber' },
	'sequentialshot' => { 424 => 0x20e },
	'serialnumber' => { 66 => 0xc, 100 => 0x180b, 122 => [0xa431,0xfde9], 140 => 0xfa04, 142 => 0xfa00, 144 => 0xc354, 145 => 0xfa19, 156 => 0x0, 159 => 'SerialNumber', 194 => 0x5501, 239 => [0xa0,0x1d], 325 => 0x101, 329 => [0x404,0x101a], 343 => 0x303, 345 => 0x305, 350 => 0x3103, 383 => 0x229, 392 => 0x102, 393 => 0x407, 408 => ['SNum','slno'], 409 => 0x15, 410 => 0x4b, 411 => 0x7e, 415 => 0x5, 422 => 0xa002, 425 => 0x2, 449 => 0x2031, 508 => 'SerialNumber', 518 => 'BodySerialNumber' },
	'serialnumberformat' => { 66 => 0x15, 100 => 0x183b },
	'serialnumberhash' => { 408 => 'CAME' },
	'series' => { 525 => 'Series' },
	'seriesdatetime' => { 489 => 'SeriesDateTime' },
	'seriesdescription' => { 489 => 'SeriesDescription' },
	'seriesidentifier' => { 525 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 489 => 'SeriesModality' },
	'seriesname' => { 525 => [\'Series','SeriesName'] },
	'seriesnumber' => { 489 => 'SeriesNumber', 530 => 'seriesNumber' },
	'seriestitle' => { 530 => 'seriesTitle' },
	'serviceidentifier' => { 135 => 0x1e },
	'servingsize' => { 532 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 90 => 0x0, 91 => 0x0 },
	'setbuttonwhenshooting' => { 85 => 0x1, 87 => 0x704, 93 => 0xc },
	'setclockfromlocationdata' => { 246 => 0x61d, 247 => 0x64d, 248 => 0x6b5 },
	'setfunctionwhenshooting' => { 88 => 0x0, 89 => 0x1, 92 => 0x1 },
	'setting' => { 529 => 'setting' },
	'shadingcompensation' => { 324 => 0x50c, 348 => 0x8a },
	'shadingcompensation2' => { 328 => 0x1012 },
	'shadow' => { 425 => 0xe },
	'shadowadj' => { 106 => 0x2030b },
	'shadowcorrection' => { 383 => 0x79 },
	'shadowprotection' => { 296 => 0x0 },
	'shadows' => { 122 => 0xfe52, 449 => 0x2032, 505 => 'Shadows', 511 => 'Shadows', 513 => 'Shadows' },
	'shadows2012' => { 511 => 'Shadows2012', 513 => 'Shadows2012' },
	'shadowsadj' => { 486 => 0x901a },
	'shadowscale' => { 122 => 0xc633 },
	'shadowtint' => { 511 => 'ShadowTint', 513 => 'ShadowTint' },
	'shadowtone' => { 130 => 0x1040 },
	'shakereduction' => { 385 => 0x1, 386 => 0x1 },
	'shareduserrating' => { 182 => 'WM/SharedUserRating' },
	'sharpendetail' => { 511 => 'SharpenDetail', 513 => 'SharpenDetail' },
	'sharpenedgemasking' => { 511 => 'SharpenEdgeMasking', 513 => 'SharpenEdgeMasking' },
	'sharpening' => { 350 => 0x300b },
	'sharpeningadj' => { 300 => 0x2b },
	'sharpeningkernel' => { 141 => 0x92f },
	'sharpenradius' => { 511 => 'SharpenRadius', 513 => 'SharpenRadius' },
	'sharpness' => { 8 => [0x42,0x48], 10 => 0x72, 12 => 0x74, 36 => 0xf, 65 => 0x6, 76 => 0x2, 115 => 0xb, 116 => [0x3011,0x21], 122 => [0xa40a,0xfe56], 130 => 0x1001, 143 => 0x6b, 152 => 0x37, 159 => 'Sharpness', 184 => 0x21, 185 => 0x30, 186 => 0x26, 187 => 0x18, 192 => 0x3, 239 => 0x6, 255 => 0x32, 256 => 0x33, 257 => 0x39, 329 => 0x100f, 348 => 0x41, 383 => 0x21, 390 => 0xb, 409 => 0x26, 411 => 0x56, 414 => 0x22, 415 => [0x1003,0x1014], 425 => 0x11, 435 => 0x1c, 436 => 0x19, 449 => 0x2006, 481 => 0x52, 511 => 'Sharpness', 513 => 'Sharpness', 517 => 'Sharpness' },
	'sharpnessadj' => { 106 => 0x20310, 111 => 0x25a, 486 => 0x801a },
	'sharpnessadjon' => { 106 => '0x20310.0' },
	'sharpnessauto' => { 73 => 0x94 },
	'sharpnessfactor' => { 329 => 0x102a },
	'sharpnessfaithful' => { 19 => 0xf5, 72 => 0x64, 73 => 0x64 },
	'sharpnessfrequency' => { 8 => [0x41,0x47], 76 => 0x3 },
	'sharpnesslandscape' => { 19 => 0xf3, 72 => 0x34, 73 => 0x34 },
	'sharpnessmonochrome' => { 19 => 0xf6, 72 => 0x7c, 73 => 0x7c },
	'sharpnessneutral' => { 19 => 0xf4, 72 => 0x4c, 73 => 0x4c },
	'sharpnessovershoot' => { 486 => 0x801b },
	'sharpnessportrait' => { 19 => 0xf2, 72 => 0x1c, 73 => 0x1c },
	'sharpnessrange' => { 449 => 0x2035 },
	'sharpnesssetting' => { 324 => 0x506, 332 => 0x1013, 437 => 0x12, 454 => 0xa },
	'sharpnessstandard' => { 19 => 0xf1, 72 => 0x4, 73 => 0x4 },
	'sharpnessstrength' => { 106 => 0x20311 },
	'sharpnessthreshold' => { 486 => 0x801d },
	'sharpnessundershoot' => { 486 => 0x801c },
	'sharpnessuserdef1' => { 19 => 0xf7, 72 => 0x94, 73 => 0xac },
	'sharpnessuserdef2' => { 19 => 0xf8, 72 => 0xac, 73 => 0xc4 },
	'sharpnessuserdef3' => { 19 => 0xf9, 72 => 0xc4, 73 => 0xdc },
	'shiftcols' => { 141 => 0xc70 },
	'shootid' => { 529 => 'shootID' },
	'shootingdistance' => { 106 => 0x20701 },
	'shootinginfodisplay' => { 304 => '13.2', 305 => '5.1', 313 => '10.2', 314 => '4.1', 317 => '5.1', 319 => '5.3' },
	'shootinginfomonitorofftime' => { 304 => '26.2', 305 => '22.2', 307 => '22.2', 308 => '22.2', 312 => '21.2', 313 => '9.1', 314 => '21.2', 317 => '22.2', 318 => '22.2', 319 => '22.2', 320 => 0x37, 321 => 0x37, 322 => 0x37 },
	'shootingmode' => { 159 => 'ShootingMode', 239 => 0x89, 348 => 0x1f },
	'shootingmodesetting' => { 306 => '5.1' },
	'shortdescription' => { 515 => 'shortdescription' },
	'shortdocumentid' => { 134 => 0xba },
	'shortname' => { 511 => 'ShortName', 513 => 'ShortName' },
	'shortownername' => { 19 => 0xac },
	'shortreleasetimelag' => { 87 => 0x80d },
	'shorttitle' => { 400 => '@sti' },
	'shotdate' => { 540 => 'shotDate' },
	'shotday' => { 540 => 'shotDay' },
	'shotlocation' => { 540 => 'shotLocation' },
	'shotlogdata' => { 494 => 'shot_log_data' },
	'shotname' => { 408 => 'shot', 540 => 'shotName' },
	'shotnumber' => { 540 => 'shotNumber' },
	'shotnumbersincepowerup' => { 453 => 0x44e, 472 => 0x1a, 473 => 0x16, 474 => 0xa },
	'shotnumbersincepowerup2' => { 437 => 0x200 },
	'shotsize' => { 540 => 'shotSize' },
	'shotsperinterval' => { 228 => 0x180, 243 => 0xb4, 244 => 0xcc, 245 => 0xcc, 246 => 0xc0, 247 => 0xd0, 248 => 0xd0 },
	'showmovement' => { 400 => 'shwm' },
	'shownevent' => { 525 => 'EventExt' },
	'showneventidentifier' => { 525 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 525 => [\'EventExt','EventExtName'] },
	'shutter' => { 468 => 0x20, 469 => 0x26, 470 => 0x26 },
	'shutter-aelock' => { 85 => 0x4, 87 => 0x701, 88 => 0x3, 89 => 0x4, 90 => 0x3, 91 => 0x3, 92 => 0x4, 93 => 0x2 },
	'shutteraelbutton' => { 86 => 0x4 },
	'shutterbuttonafonbutton' => { 87 => 0x701 },
	'shuttercount' => { 11 => 0x176, 30 => [0xa95,0x293], 33 => 0xaf1, 59 => 0x1, 239 => 0xa7, 268 => [0x6a,0x157,0x24d], 269 => 0x286, 270 => 0x279, 271 => 0x284, 272 => 0x242, 273 => 0x280, 274 => 0x276, 275 => [0x27d,0x27f], 276 => 0x246, 278 => 0x2d6, 279 => 0x321, 280 => 0xbd8, 281 => 0x287, 282 => 0x320, 283 => 0x24a, 284 => 0x5fb, 285 => 0x2d5, 383 => 0x5d, 446 => 0x846, 452 => [0x125,0x14a], 468 => 0x32, 469 => 0x3a, 470 => 0x3a, 471 => 0xa },
	'shuttercount2' => { 468 => 0x4c, 469 => [0x50,0x52,0x58], 470 => 0x50 },
	'shuttercount3' => { 468 => [0x1a0,0x1aa,0x1bd], 469 => [0x19f,0x1cb,0x1cd] },
	'shuttercurtainsync' => { 85 => 0xf, 86 => 0xf, 87 => 0x305, 88 => 0xe, 89 => 0xf, 90 => 0x8, 91 => 0x8, 92 => 0xf, 93 => 0x8 },
	'shuttermode' => { 59 => 0x17, 143 => 0x1b, 239 => 0x34 },
	'shutterreleasebuttonae-l' => { 304 => '17.7', 305 => '18.4', 307 => '78.4', 308 => '78.4', 309 => '16.1', 310 => '17.1', 311 => '17.1', 312 => '17.1', 313 => '7.1', 314 => '17.5', 317 => '18.4', 318 => '78.4', 319 => '18.2', 320 => 0x29, 321 => 0x29, 322 => 0x29 },
	'shutterreleasemethod' => { 100 => 0x1010 },
	'shutterreleasenocfcard' => { 85 => 0x2, 86 => 0x2, 93 => 0xf },
	'shutterreleasetiming' => { 100 => 0x1011 },
	'shutterreleasewithoutlens' => { 87 => 0x711 },
	'shutterspeedlock' => { 305 => '38.1', 307 => '38.1', 308 => '38.1', 317 => '38.1', 318 => '38.1', 320 => 0xb7, 321 => 0xb7, 322 => 0xb7 },
	'shutterspeedrange' => { 87 => 0x10c },
	'shutterspeedsetting' => { 187 => 0x6, 435 => 0x2f, 436 => 0x28, 437 => 0x0 },
	'shutterspeedvalue' => { 96 => 0x1, 122 => 0x9201, 329 => 0x1000, 392 => 0x400, 517 => 'ShutterSpeedValue' },
	'shuttertype' => { 130 => 0x1050, 348 => 0x9f, 383 => 0x87, 474 => [0x133,0x139,0x13f] },
	'sidecarforextension' => { 528 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 141 => 0xe0d },
	'sigmascalingfactorcamera' => { 141 => 0xe0c },
	'sigmascalingfactorlowres' => { 141 => 0xe0b },
	'sigmasizetable' => { 141 => 0xe0f },
	'signaltonoiseratio' => { 1 => 0x27 },
	'signaltonoiseratiotype' => { 1 => 0x26 },
	'silentphotography' => { 239 => 0xbf },
	'similarityindex' => { 134 => 0xe4 },
	'singleframebracketing' => { 187 => 0x21 },
	'skilllevel' => { 532 => 'skillLevel' },
	'skintonecorrection' => { 383 => 0x95 },
	'skiplinetime' => { 141 => 0x184e },
	'slaveflashmeteringsegments' => { 383 => 0x20b },
	'slideshowname' => { 529 => 'slideshowName' },
	'slideshownumber' => { 529 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 529 => 'slideshowTotalNumber' },
	'slot2jpgsize' => { 244 => 0x24a, 245 => 0x24a, 248 => 0x24a },
	'slowshutter' => { 79 => 0x8 },
	'slowsync' => { 130 => 0x1030 },
	'smartalbumcolor' => { 422 => 0x20 },
	'smartrange' => { 422 => 0xa012 },
	'smileshutter' => { 437 => 0x31 },
	'smileshuttermode' => { 437 => 0x27 },
	'smoothness' => { 122 => 0xfe57, 511 => 'Smoothness', 513 => 'Smoothness' },
	'snapshot' => { 525 => 'SnapshotLink' },
	'snapshotformat' => { 525 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 525 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 525 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 525 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 525 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 506 => 'Snapshots' },
	'snapshotusedvideoframe' => { 525 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 525 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 525 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 525 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 525 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 449 => 0x200f },
	'software' => { 122 => 0x131, 160 => 'Software', 337 => 'Software', 392 => 0x203, 402 => 'software', 425 => 0x18, 496 => 'Software', 536 => 'Software' },
	'softwareversion' => { 408 => ['@swr',"\xa9swr"], 424 => 0x207 },
	'soloist' => { 400 => "\xa9sol" },
	'songwriter' => { 408 => "\xa9swf" },
	'songwriterkeywords' => { 408 => "\xa9swk" },
	'sonycropsize' => { 122 => 0x74c8 },
	'sonycroptopleft' => { 122 => 0x74c7 },
	'sonydatetime' => { 457 => 0x6, 459 => 0x1b6, 460 => 0x210, 461 => 0x1fe, 462 => 0x22c },
	'sonydatetime2' => { 468 => 0x51 },
	'sonyexposuretime' => { 468 => 0x3a, 469 => 0x46, 470 => [0x66,0x46], 471 => 0x1a },
	'sonyexposuretime2' => { 481 => 0xe },
	'sonyfnumber' => { 468 => 0x3c, 469 => 0x48, 470 => [0x68,0x48], 471 => 0x1c, 481 => 0x14 },
	'sonyimageheight' => { 457 => 0x1a, 472 => 0x44, 473 => 0x3f },
	'sonyimageheightmax' => { 481 => 0x40 },
	'sonyimagesize' => { 187 => 0x3b, 435 => 0x54, 436 => 0x54, 437 => 0x9 },
	'sonyimagewidth' => { 457 => 0x1c },
	'sonyimagewidthmax' => { 481 => 0x3e },
	'sonyiso' => { 459 => 0x1218, 460 => 0x11f4, 461 => 0x1270, 462 => [0x1254,0x1258,0x1280], 463 => 0x113c, 464 => 0x344, 465 => 0x346, 466 => 0x320, 481 => 0x4 },
	'sonymaxaperture' => { 468 => 0x0, 469 => 0x0 },
	'sonymaxaperturevalue' => { 481 => 0x16 },
	'sonyminaperture' => { 468 => 0x1, 469 => 0x1 },
	'sonymodelid' => { 449 => 0xb001 },
	'sonyquality' => { 187 => 0x3c },
	'sonyrawimagesize' => { 122 => 0x7038 },
	'sonytimeminsec' => { 469 => 0x61 },
	'sortalbum' => { 400 => 'soal' },
	'sortalbumartist' => { 400 => 'soaa' },
	'sortartist' => { 400 => 'soar' },
	'sortcomposer' => { 400 => 'soco' },
	'sortname' => { 400 => 'sonm', 511 => 'SortName', 513 => 'SortName' },
	'sortshow' => { 400 => 'sosn' },
	'soundengineer' => { 400 => "\xa9sne" },
	'source' => { 134 => 0x73, 337 => 'Source', 514 => 'source', 515 => 'source', 528 => 'Source' },
	'sourcecount' => { 500 => 'SourceCount' },
	'sourcecredits' => { 408 => "\xa9src" },
	'sourcedirectoryindex' => { 370 => 0x0 },
	'sourcefileindex' => { 370 => 0x2 },
	'sourcephotoscount' => { 499 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 141 => 0x1390 },
	'spatialfrequencyresponse' => { 517 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 517 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 517 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 517 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 517 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 540 => 'speakerPlacement' },
	'specialeffectlevel' => { 116 => 0x3030 },
	'specialeffectmode' => { 116 => 0x2076 },
	'specialeffectsetting' => { 116 => 0x3031 },
	'specialinstructions' => { 134 => 0x28 },
	'specialmode' => { 329 => 0x200, 424 => 0x200 },
	'specialoccasion' => { 532 => 'specialOccasion' },
	'specialtypeid' => { 494 => 'SpecialTypeID' },
	'spectralsensitivity' => { 122 => 0x8824, 517 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 43 => 0x32b, 44 => 0x281, 47 => [0x2b9,0x2d0,0x2d4], 48 => [0x56a,0x296], 49 => 0x1e4, 50 => [0x1fd,0x2dd], 51 => [0x231,0x30f], 52 => 0x31d },
	'speedx' => { 118 => 0x3, 408 => "\xa9xsp" },
	'speedy' => { 118 => 0x4, 408 => "\xa9ysp" },
	'speedz' => { 118 => 0x5, 408 => "\xa9zsp" },
	'spherical' => { 500 => 'Spherical' },
	'sphericalvideoxml' => { 123 => 'SphericalVideoXML' },
	'splitcolumn' => { 392 => 0x222 },
	'splittoningbalance' => { 511 => 'SplitToningBalance', 513 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 511 => 'SplitToningHighlightHue', 513 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 511 => 'SplitToningHighlightSaturation', 513 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 511 => 'SplitToningShadowHue', 513 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 511 => 'SplitToningShadowSaturation', 513 => 'SplitToningShadowSaturation' },
	'sport' => { 530 => 'sport' },
	'spotfocuspointx' => { 184 => 0x2d },
	'spotfocuspointy' => { 184 => 0x2e },
	'spotmeteringmode' => { 36 => 0x27 },
	'spotmeterlinktoafpoint' => { 87 => 0x107 },
	'sractive' => { 364 => '17.1' },
	'srawquality' => { 36 => 0x2e },
	'srfocallength' => { 385 => 0x3 },
	'srgbrendering' => { 335 => 'sRGB' },
	'srhalfpresstime' => { 385 => 0x2 },
	'srresult' => { 385 => 0x0, 386 => 0x0 },
	'stackedimage' => { 324 => 0x804 },
	'standardmatrixcustom' => { 141 => 0x7d4 },
	'standardmatrixdaylight' => { 141 => 0x7d0 },
	'standardmatrixflash' => { 141 => 0x7d3 },
	'standardmatrixfluorescent' => { 141 => 0x7d2 },
	'standardmatrixtungsten' => { 141 => 0x7d1 },
	'standardoutputhighlightpoint' => { 112 => 0x14 },
	'standardoutputsensitivity' => { 122 => 0x8831, 518 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 112 => 0x15 },
	'standardrawcolortone' => { 112 => 0xd },
	'standardrawcontrast' => { 112 => 0xf },
	'standardrawhighlight' => { 112 => 0x75 },
	'standardrawhighlightpoint' => { 112 => 0x12 },
	'standardrawlinear' => { 112 => 0x10 },
	'standardrawsaturation' => { 112 => 0xe },
	'standardrawshadow' => { 112 => 0x7e },
	'standardrawshadowpoint' => { 112 => 0x13 },
	'standardrawsharpness' => { 112 => 0x11 },
	'standardunsharpmaskfineness' => { 112 => 0x94 },
	'standardunsharpmaskstrength' => { 112 => 0x92 },
	'standardunsharpmaskthreshold' => { 112 => 0x96 },
	'standardwhitecustom' => { 141 => 0x838 },
	'standardwhitedaylight' => { 141 => 0x834 },
	'standardwhiteflash' => { 141 => 0x837 },
	'standardwhitefluorescent' => { 141 => 0x836 },
	'standardwhitetungsten' => { 141 => 0x835 },
	'standbytimer' => { 305 => '19.1', 307 => '19.1', 308 => '19.1', 311 => '18.1', 312 => '18.1', 317 => '19.1', 318 => '19.1' },
	'starlightview' => { 320 => 0x249, 321 => 0x249, 322 => 0x261 },
	'startingpage' => { 530 => 'startingPage' },
	'startmovieshooting' => { 87 => 0x70d },
	'starttimecode' => { 408 => "\xa9TIM", 540 => 'startTimecode' },
	'starttimecodetimeformat' => { 540 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 540 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 540 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 408 => "\xa9TSZ", 540 => 'startTimeSampleSize' },
	'starttimescale' => { 408 => "\xa9TSC", 540 => 'startTimeScale' },
	'state' => { 164 => 'State', 348 => 0x6b, 528 => 'State' },
	'status' => { 492 => 'Status', 504 => 'Status' },
	'stereomode' => { 500 => 'StereoMode' },
	'stitched' => { 500 => 'Stitched' },
	'stitchingsoftware' => { 499 => 'StitchingSoftware', 500 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 458 => 0x113e, 459 => 0x113e, 460 => 0x111a, 461 => 0x1196, 462 => 0x1172, 463 => 0x102a, 464 => 0x222, 465 => 0x222, 466 => 0x217, 481 => 0xa },
	'storagemethod' => { 191 => 0x12 },
	'storebyorientation' => { 305 => '46.3', 307 => '47.3', 308 => '47.3', 317 => '47.3', 318 => '47.3', 320 => 0xd, 321 => 0xd, 322 => 0xd },
	'storedescription' => { 400 => 'sdes' },
	'storylineidentifier' => { 525 => 'StorylineIdentifier' },
	'straightenangle' => { 297 => 0x2fc08431 },
	'streamready' => { 525 => 'StreamReady' },
	'streamtype' => { 179 => 'StreamType' },
	'stretchmode' => { 540 => 'stretchMode' },
	'studydatetime' => { 489 => 'StudyDateTime' },
	'studydescription' => { 489 => 'StudyDescription' },
	'studyid' => { 489 => 'StudyID' },
	'studyphysician' => { 489 => 'StudyPhysician' },
	'styleperiod' => { 525 => 'StylePeriod' },
	'sub-location' => { 134 => 0x5c },
	'subcommanddialframeadvancezoom' => { 248 => 0x806 },
	'subcommanddialplaybackmode' => { 320 => 0x1cf, 321 => 0x1cf, 322 => 0x1e7 },
	'subcommanddialvideoplaybackmode' => { 320 => 0x1d1, 322 => 0x1e9 },
	'subfiledata' => { 167 => 'data' },
	'subfiledirectory' => { 167 => '1Directory' },
	'subfilemimetype' => { 167 => '2MIME' },
	'subfilename' => { 167 => '1Name' },
	'subfileresource' => { 167 => 'rsrc' },
	'subfiletype' => { 122 => 0xfe, 167 => '0Type' },
	'subject' => { 333 => 'Subject', 399 => 'Subject', 514 => 'subject', 527 => 'Subject', 541 => 'subject' },
	'subjectarea' => { 122 => 0x9214, 517 => 'SubjectArea' },
	'subjectcode' => { 524 => 'SubjectCode' },
	'subjectdetection' => { 244 => 0x252, 245 => 0x252, 246 => 0x23e, 247 => 0x252, 248 => 0x252 },
	'subjectdistance' => { 122 => 0x9206, 143 => 0x3e, 517 => 'SubjectDistance' },
	'subjectdistancerange' => { 122 => 0xa40c, 517 => 'SubjectDistanceRange' },
	'subjectlocation' => { 122 => 0xa214, 517 => 'SubjectLocation' },
	'subjectmotion' => { 307 => '78.2', 308 => '78.2', 318 => '78.2', 320 => 0x103, 321 => 0x103, 322 => 0x119 },
	'subjectprogram' => { 184 => 0x22 },
	'subjectreference' => { 134 => 0xc },
	'sublabels1' => { 523 => [\'TagStructure','TagStructureSubLabels'] },
	'sublabels2' => { 523 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublabels3' => { 523 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'sublabels4' => { 523 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 523 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 117 => 'Exif-SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 117 => 'Exif-SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 117 => 'Exif-SubSecModifyDate' },
	'subsectime' => { 122 => 0x9290 },
	'subsectimedigitized' => { 122 => 0x9292 },
	'subsectimeoriginal' => { 122 => 0x9291 },
	'subsection1' => { 530 => 'subsection1' },
	'subsection2' => { 530 => 'subsection2' },
	'subsection3' => { 530 => 'subsection3' },
	'subsection4' => { 530 => 'subsection4' },
	'subselector' => { 305 => '49.1', 307 => '71.1', 308 => '71.1', 318 => '71.1', 320 => 0x8f, 321 => 0x8f, 322 => 0x8f },
	'subselectorassignment' => { 305 => '48.1' },
	'subselectorcenter' => { 307 => '72.1', 308 => '72.1', 318 => '72.1' },
	'subselectorplusdials' => { 305 => '49.2', 307 => '73.1', 308 => '73.1', 318 => '73.1' },
	'subtitle' => { 182 => 'WM/SubTitle', 400 => "\xa9st3", 408 => "\xa9snm", 530 => 'subtitle' },
	'subtitlekeywords' => { 408 => "\xa9snk" },
	'subversionfilename' => { 523 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 523 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 523 => 'SubVersions' },
	'superimposeddisplay' => { 85 => 0xa, 87 => 0x510, 88 => 0x9, 89 => 0xa, 92 => 0xa, 93 => 0xe },
	'supermacro' => { 66 => 0x1a },
	'supplementalcategories' => { 134 => 0x14, 528 => 'SupplementalCategories' },
	'supplementaltype' => { 136 => 0x37 },
	'supplementdisplayid' => { 530 => 'supplementDisplayID' },
	'supplementstartingpage' => { 530 => 'supplementStartingPage' },
	'supplementtitle' => { 530 => 'supplementTitle' },
	'supplychainsource' => { 525 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 525 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 525 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'supportsamount' => { 511 => 'SupportsAmount', 513 => 'SupportsAmount' },
	'supportscolor' => { 511 => 'SupportsColor', 513 => 'SupportsColor' },
	'supportshighdynamicrange' => { 511 => 'SupportsHighDynamicRange', 513 => 'SupportsHighDynamicRange' },
	'supportsmonochrome' => { 511 => 'SupportsMonochrome', 513 => 'SupportsMonochrome' },
	'supportsnormaldynamicrange' => { 511 => 'SupportsNormalDynamicRange', 513 => 'SupportsNormalDynamicRange' },
	'supportsoutputreferred' => { 511 => 'SupportsOutputReferred', 513 => 'SupportsOutputReferred' },
	'supportsscenereferred' => { 511 => 'SupportsSceneReferred', 513 => 'SupportsSceneReferred' },
	'svisosetting' => { 364 => 0x14 },
	'swatchcoloranta' => { 545 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 545 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 545 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 545 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 545 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 545 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 545 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 545 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 545 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 545 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 545 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 545 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 545 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 545 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 545 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 545 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 545 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 545 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 545 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 348 => 0x93, 437 => 0x33 },
	'sweeppanoramafieldofview' => { 348 => 0x94 },
	'sweeppanoramasize' => { 437 => 0x32 },
	'switchtoregisteredafpoint' => { 86 => 0x12, 87 => 0x50a },
	'symlink' => { 123 => 'SymLink' },
	'syncreleasemode' => { 307 => '77.1', 308 => '77.1', 318 => '77.1', 320 => 0x41, 321 => 0x41, 322 => 0x41 },
	'system' => { 392 => 0x204 },
	'tagged' => { 394 => 0xdd, 395 => 'Tagged', 506 => 'tagged' },
	'tagslist' => { 516 => 'TagsList' },
	'tagstructure' => { 523 => 'TagStructure' },
	'takenumber' => { 540 => 'takeNumber' },
	'tapename' => { 540 => 'tapeName' },
	'targetaperture' => { 79 => 0x4 },
	'targetaspectratio' => { 338 => 'TargetAspectRatio' },
	'targetcompressionratio' => { 98 => 0x1 },
	'targetdistancesetting' => { 100 => 0x1807 },
	'targetexposuretime' => { 79 => 0x5 },
	'targetimagetype' => { 100 => 0x100a },
	'targetprinter' => { 122 => 0x151 },
	'taxon' => { 121 => 'Taxon' },
	'taxonacceptednameusage' => { 121 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 121 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 121 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 121 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxoncultivarepithet' => { 121 => [\'Taxon','TaxonCultivarEpithet'] },
	'taxonfamily' => { 121 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 121 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 121 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 121 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 121 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 121 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 121 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 121 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 121 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 121 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 121 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 121 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 121 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 121 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 121 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 121 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 121 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 121 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 121 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 121 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 121 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 121 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 121 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 121 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 121 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 121 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 121 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 121 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 121 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 141 => 0x196f },
	'tda1edgepolarity' => { 141 => 0x1971 },
	'tda1gain' => { 141 => 0x1970 },
	'tda1offset' => { 141 => 0x196e },
	'tda2bandwidth' => { 141 => 0x1979 },
	'tda2edgepolarity' => { 141 => 0x197b },
	'tda2gain' => { 141 => 0x197a },
	'tda2offset' => { 141 => 0x1978 },
	'tda3bandwidth' => { 141 => 0x1983 },
	'tda3edgepolarity' => { 141 => 0x1985 },
	'tda3gain' => { 141 => 0x1984 },
	'tda3offset' => { 141 => 0x1982 },
	'tda4bandwidth' => { 141 => 0x198d },
	'tda4edgepolarity' => { 141 => 0x198f },
	'tda4gain' => { 141 => 0x198e },
	'tda4offset' => { 141 => 0x198c },
	'teaser' => { 530 => 'teaser' },
	'teleconverter' => { 189 => 0x105, 449 => 0x105 },
	'tempampgainx100' => { 141 => 0x1914 },
	'tempo' => { 540 => 'tempo' },
	'temporalcoverage' => { 525 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 525 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 525 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 334 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 334 => 'TermsAndConditionsURL' },
	'testname' => { 123 => 'TestName' },
	'textencoding' => { 238 => 0x4 },
	'textlayername' => { 528 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 528 => 'TextLayers' },
	'textlayertext' => { 528 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 348 => [0x8008,0x8009,0x3b,0x3e] },
	'texture' => { 511 => 'Texture', 513 => 'Texture' },
	'three-dtrackingfacedetection' => { 307 => '1.4', 308 => '1.4', 318 => '1.4' },
	'three-dtrackingwatcharea' => { 307 => '78.1', 308 => '78.1', 318 => '78.1' },
	'thresholding' => { 122 => 0x107 },
	'thumbnailfilename' => { 100 => 0x817 },
	'thumbnailformat' => { 538 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 145 => 0xfa55, 538 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 6 => 'CNDA', 100 => 0x2008, 117 => 'Exif-ThumbnailImage', 125 => 0x3, 170 => 'data', 329 => 0x100, 408 => 'thmb', 538 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 170 => '1Name' },
	'thumbnailimagesize' => { 170 => 'ImageSize' },
	'thumbnailimagetype' => { 170 => '0Type' },
	'thumbnailimagevalidarea' => { 66 => 0x13 },
	'thumbnaillength' => { 122 => 0x202 },
	'thumbnailoffset' => { 122 => 0x201 },
	'thumbnailpng' => { 408 => 'thmb' },
	'thumbnails' => { 538 => 'Thumbnails' },
	'thumbnailwidth' => { 145 => 0xfa54, 538 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 530 => 'ticker' },
	'tiffhandling' => { 511 => 'TIFFHandling', 513 => 'TIFFHandling' },
	'tiffmeteringimage' => { 190 => 0x104c, 446 => 0x1110 },
	'tilelength' => { 122 => 0x143 },
	'tilewidth' => { 122 => 0x142 },
	'time' => { 141 => 0x401, 383 => 0x7 },
	'timecodes' => { 122 => 0xc763 },
	'timecreated' => { 134 => 0x3c, 143 => 0x14, 152 => 0x10, 395 => 'TimeCreated' },
	'timelapseshotnumber' => { 351 => 0x10 },
	'timeperiod' => { 530 => 'timePeriod' },
	'timerfunctionbutton' => { 306 => '5.2', 309 => '12.1', 310 => '13.1' },
	'timerlength' => { 87 => 0x80c },
	'timerrecording' => { 348 => 0x96 },
	'timescaleparams' => { 540 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 540 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 540 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 540 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 135 => 0x50 },
	'timeshot' => { 501 => 'TimeShot' },
	'timesignature' => { 540 => 'timeSignature' },
	'timesincepoweron' => { 348 => 0x29 },
	'timestamp' => { 11 => 0x45e, 19 => 0x11c, 323 => 0x8, 337 => 'TimeStamp', 348 => 0xaf, 500 => 'Timestamp', 507 => 'Timestamp', 523 => 'TimeStamp' },
	'timestamp1' => { 11 => 0x45a },
	'timezone' => { 80 => 0x1, 244 => 0x694, 245 => 0x6a4, 246 => 0x594, 247 => 0x5c4, 248 => 0x5dc, 289 => 0x0, 418 => 0xa },
	'timezonecity' => { 80 => 0x2 },
	'timezonecode' => { 103 => 0x1 },
	'timezoneinfo' => { 103 => 0x2 },
	'timezoneoffset' => { 122 => 0x882a },
	'tint' => { 402 => 'player.movie.visual.tint', 511 => 'Tint', 513 => 'Tint' },
	'title' => { 122 => 0xa436, 160 => 'Title', 333 => 'Title', 337 => 'Title', 348 => 0x65, 399 => 'Title', 400 => ['titl',"\xa9nam"], 402 => 'title', 408 => ['titl',"\xa9nam"], 514 => 'title', 527 => 'Title', 538 => 'Title' },
	'togglestyleamount' => { 511 => 'ToggleStyleAmount', 513 => 'ToggleStyleAmount' },
	'togglestyledigest' => { 511 => 'ToggleStyleDigest', 513 => 'ToggleStyleDigest' },
	'tonecomp' => { 239 => 0x81 },
	'tonecurve' => { 76 => 0x1, 383 => 0x402, 511 => 'ToneCurve', 513 => 'ToneCurve' },
	'tonecurveactive' => { 111 => 0x110 },
	'tonecurveadobergb' => { 422 => 0xa043 },
	'tonecurveadobergbdefault' => { 422 => 0xa041 },
	'tonecurveblue' => { 511 => 'ToneCurveBlue', 513 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 486 => 0x9003 },
	'tonecurvebluey' => { 486 => 0x9007 },
	'tonecurvebrightness' => { 106 => 0x20410 },
	'tonecurvebrightnessx' => { 486 => 0x9000 },
	'tonecurvebrightnessy' => { 486 => 0x9004 },
	'tonecurvecolorspace' => { 110 => 0x0 },
	'tonecurvecontrast' => { 106 => 0x20411 },
	'tonecurvegreen' => { 511 => 'ToneCurveGreen', 513 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 486 => 0x9002 },
	'tonecurvegreeny' => { 486 => 0x9006 },
	'tonecurveinputrange' => { 110 => 0x3 },
	'tonecurveinterpolation' => { 111 => 0x159 },
	'tonecurvemode' => { 111 => 0x113 },
	'tonecurvename' => { 511 => 'ToneCurveName', 513 => 'ToneCurveName' },
	'tonecurvename2012' => { 511 => 'ToneCurveName2012', 513 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 106 => '0x20400.1' },
	'tonecurveoutputrange' => { 110 => 0x5 },
	'tonecurveprofilename' => { 141 => 0x1391 },
	'tonecurveproperty' => { 111 => 0x3c },
	'tonecurvepv2012' => { 511 => 'ToneCurvePV2012', 513 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 511 => 'ToneCurvePV2012Blue', 513 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 511 => 'ToneCurvePV2012Green', 513 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 511 => 'ToneCurvePV2012Red', 513 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 511 => 'ToneCurveRed', 513 => 'ToneCurveRed' },
	'tonecurveredx' => { 486 => 0x9001 },
	'tonecurveredy' => { 486 => 0x9005 },
	'tonecurves' => { 383 => 0x403 },
	'tonecurveshape' => { 110 => 0x1 },
	'tonecurvesrgb' => { 422 => 0xa042 },
	'tonecurvesrgbdefault' => { 422 => 0xa040 },
	'tonecurvex' => { 110 => 0xa },
	'tonecurvey' => { 110 => 0xb },
	'tonelevel' => { 324 => 0x52e },
	'tonemap' => { 244 => 0x26a, 245 => 0x26a },
	'tonemapstrength' => { 511 => 'ToneMapStrength', 513 => 'ToneMapStrength' },
	'toningeffect' => { 59 => 0xf, 239 => 0xb3, 255 => 0x38, 256 => 0x40, 257 => 0x48, 415 => 0x1015 },
	'toningeffectauto' => { 73 => 0xa4 },
	'toningeffectfaithful' => { 72 => 0x74, 73 => 0x74 },
	'toningeffectlandscape' => { 72 => 0x44, 73 => 0x44 },
	'toningeffectmonochrome' => { 19 => 0x108, 72 => 0x8c, 73 => 0x8c },
	'toningeffectneutral' => { 72 => 0x5c, 73 => 0x5c },
	'toningeffectportrait' => { 72 => 0x2c, 73 => 0x2c },
	'toningeffectstandard' => { 72 => 0x14, 73 => 0x14 },
	'toningeffectuserdef1' => { 72 => 0xa4, 73 => 0xbc },
	'toningeffectuserdef2' => { 72 => 0xbc, 73 => 0xd4 },
	'toningeffectuserdef3' => { 72 => 0xd4, 73 => 0xec },
	'toningsaturation' => { 255 => 0x39, 256 => 0x41, 257 => 0x49 },
	'totalzoom' => { 143 => 0x62 },
	'touchae' => { 348 => 0xab },
	'track' => { 400 => "\xa9trk", 408 => "\xa9trk" },
	'trackcreatedate' => { 407 => 0x1 },
	'trackmodifydate' => { 407 => 0x2 },
	'tracknumber' => { 400 => 'trkn', 540 => 'trackNumber' },
	'tracks' => { 540 => 'Tracks' },
	'tracksframerate' => { 540 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 540 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 540 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 540 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 540 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 540 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 540 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 540 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 540 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 540 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 540 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 540 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 540 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 540 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 540 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 540 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 540 => [\'Tracks','TracksTrackType'] },
	'tracktype' => { 408 => 'kgtt' },
	'trailer' => { 123 => 'Trailer' },
	'trailersignature' => { 167 => 'zmie' },
	'transcript' => { 525 => 'Transcript' },
	'transcriptlink' => { 525 => 'TranscriptLink' },
	'transcriptlinklink' => { 525 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 525 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 122 => 0x12d, 536 => 'TransferFunction' },
	'transfertimenormal' => { 141 => 0x1888 },
	'transfertimetest' => { 141 => 0x1889 },
	'transform' => { 348 => [0x8012,0x59] },
	'transformation' => { 526 => 'Transformation' },
	'transmissionreference' => { 528 => 'TransmissionReference' },
	'trapped' => { 333 => 'Trapped', 527 => 'Trapped' },
	'trashbuttonfunction' => { 87 => 0x710 },
	'travelday' => { 348 => 0x36 },
	'treble' => { 402 => 'player.movie.audio.treble' },
	'triggermode' => { 409 => 0x6, 410 => 0x34, 411 => 0x34 },
	'tstop' => { 122 => 0xc772 },
	'ttl_da_adown' => { 371 => 0x5 },
	'ttl_da_aup' => { 371 => 0x4 },
	'ttl_da_bdown' => { 371 => 0x7 },
	'ttl_da_bup' => { 371 => 0x6 },
	'tungstenawb' => { 361 => 0x1 },
	'tvepisode' => { 400 => 'tves' },
	'tvepisodeid' => { 400 => 'tven' },
	'tvexposuretimesetting' => { 364 => 0x12 },
	'tvnetworkname' => { 400 => 'tvnn' },
	'tvseason' => { 400 => 'tvsn' },
	'tvshow' => { 400 => 'tvsh' },
	'type' => { 495 => 'Type', 514 => 'type', 535 => 'type' },
	'typestatus' => { 121 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 122 => 0xc614 },
	'uniquedocumentid' => { 134 => 0xbb },
	'uniquematrixauto' => { 141 => 0x7e9 },
	'uniquematrixcustom' => { 141 => 0x7e8 },
	'uniquematrixdaylight' => { 141 => 0x7e4 },
	'uniquematrixflash' => { 141 => 0x7e7 },
	'uniquematrixfluorescent' => { 141 => 0x7e6 },
	'uniquematrixtungsten' => { 141 => 0x7e5 },
	'uniqueobjectname' => { 135 => 0x64 },
	'units' => { 496 => 'Units' },
	'unknown_aacr' => { 400 => 'AACR' },
	'unknown_cdek' => { 400 => 'CDEK' },
	'unknown_cdet' => { 400 => 'CDET' },
	'unknownblock' => { 383 => 0x405 },
	'unknownblock1' => { 328 => 0x635 },
	'unknownblock2' => { 328 => 0x636 },
	'unknownblock3' => { 328 => 0x1103 },
	'unknownblock4' => { 328 => 0x1104 },
	'unknowncontrast' => { 112 => 0x45 },
	'unknowndate' => { 392 => 0x212 },
	'unknownev' => { 141 => 0x1 },
	'unknownlinear' => { 112 => 0x46 },
	'unknownnumber' => { 100 => 0x180b },
	'unknownoutputhighlightpoint' => { 112 => 0x4a },
	'unknownoutputshadowpoint' => { 112 => 0x4b },
	'unknownrawhighlight' => { 112 => 0x7b },
	'unknownrawhighlightpoint' => { 112 => 0x48 },
	'unknownrawshadow' => { 112 => 0x84 },
	'unknownrawshadowpoint' => { 112 => 0x49 },
	'unknownsharpness' => { 112 => 0x47 },
	'unknowntags' => { 408 => 'TAGS' },
	'unknowntemperature' => { 124 => 0x4 },
	'unknownthumbnail' => { 408 => 'thmb' },
	'unsharp1color' => { 302 => 0x13 },
	'unsharp1halowidth' => { 302 => 0x19 },
	'unsharp1intensity' => { 302 => 0x17 },
	'unsharp1threshold' => { 302 => 0x1b },
	'unsharp2color' => { 302 => 0x2e },
	'unsharp2halowidth' => { 302 => 0x34 },
	'unsharp2intensity' => { 302 => 0x32 },
	'unsharp2threshold' => { 302 => 0x36 },
	'unsharp3color' => { 302 => 0x49 },
	'unsharp3halowidth' => { 302 => 0x4f },
	'unsharp3intensity' => { 302 => 0x4d },
	'unsharp3threshold' => { 302 => 0x51 },
	'unsharp4color' => { 302 => 0x64 },
	'unsharp4halowidth' => { 302 => 0x6a },
	'unsharp4intensity' => { 302 => 0x68 },
	'unsharp4threshold' => { 302 => 0x6c },
	'unsharpcount' => { 302 => 0x0 },
	'unsharpmask' => { 112 => 0x90, 297 => 0x76a43200 },
	'unsharpmaskfineness' => { 106 => 0x20309 },
	'unsharpmaskstrength' => { 106 => 0x20308 },
	'unsharpmaskthreshold' => { 106 => 0x2030a },
	'uprightcentermode' => { 511 => 'UprightCenterMode', 513 => 'UprightCenterMode' },
	'uprightcenternormx' => { 511 => 'UprightCenterNormX', 513 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 511 => 'UprightCenterNormY', 513 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 511 => 'UprightDependentDigest', 513 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 511 => 'UprightFocalLength35mm', 513 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 511 => 'UprightFocalMode', 513 => 'UprightFocalMode' },
	'uprightfoursegments_0' => { 511 => 'UprightFourSegments_0', 513 => 'UprightFourSegments_0' },
	'uprightfoursegments_1' => { 511 => 'UprightFourSegments_1', 513 => 'UprightFourSegments_1' },
	'uprightfoursegments_2' => { 511 => 'UprightFourSegments_2', 513 => 'UprightFourSegments_2' },
	'uprightfoursegments_3' => { 511 => 'UprightFourSegments_3', 513 => 'UprightFourSegments_3' },
	'uprightfoursegmentscount' => { 511 => 'UprightFourSegmentsCount', 513 => 'UprightFourSegmentsCount' },
	'uprightguideddependentdigest' => { 511 => 'UprightGuidedDependentDigest', 513 => 'UprightGuidedDependentDigest' },
	'uprightpreview' => { 511 => 'UprightPreview', 513 => 'UprightPreview' },
	'uprighttransform_0' => { 511 => 'UprightTransform_0', 513 => 'UprightTransform_0' },
	'uprighttransform_1' => { 511 => 'UprightTransform_1', 513 => 'UprightTransform_1' },
	'uprighttransform_2' => { 511 => 'UprightTransform_2', 513 => 'UprightTransform_2' },
	'uprighttransform_3' => { 511 => 'UprightTransform_3', 513 => 'UprightTransform_3' },
	'uprighttransform_4' => { 511 => 'UprightTransform_4', 513 => 'UprightTransform_4' },
	'uprighttransform_5' => { 511 => 'UprightTransform_5', 513 => 'UprightTransform_5' },
	'uprighttransformcount' => { 511 => 'UprightTransformCount', 513 => 'UprightTransformCount' },
	'uprightversion' => { 511 => 'UprightVersion', 513 => 'UprightVersion' },
	'urgency' => { 134 => 0xa, 528 => 'Urgency' },
	'url' => { 160 => 'URL', 337 => 'URL', 397 => 0x40b, 530 => 'url' },
	'url_list' => { 397 => 0x41e },
	'urla-platform' => { 530 => [\'url','urlA-platform'] },
	'urlurl' => { 530 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 87 => 0x10a },
	'usableshootingmodes' => { 87 => 0x109 },
	'usage' => { 531 => 'usage' },
	'usageterms' => { 544 => 'UsageTerms' },
	'usbpowerdelivery' => { 244 => 0x762, 245 => 0x772, 246 => 0x664, 247 => 0x694, 248 => 0x6fc },
	'usedialwithouthold' => { 320 => 0xbf, 321 => 0xbf, 322 => 0xbf },
	'useguidelines' => { 509 => 'useGuidelines' },
	'usepanoramaviewer' => { 499 => 'UsePanoramaViewer' },
	'usercollection' => { 402 => 'collection.user' },
	'usercomment' => { 100 => 0x805, 122 => 0x9286, 517 => 'UserComment' },
	'userdef1picturestyle' => { 19 => 0x10c, 72 => 0xd8, 73 => 0xf0 },
	'userdef2picturestyle' => { 19 => 0x10e, 72 => 0xda, 73 => 0xf2 },
	'userdef3picturestyle' => { 19 => 0x110, 72 => 0xdc, 73 => 0xf4 },
	'userfields' => { 504 => 'UserFields' },
	'userlabel' => { 409 => 0x2b, 410 => 0x5a, 411 => 0x68 },
	'userprofile' => { 343 => 0x302, 347 => 0x34c, 350 => 0x3038 },
	'userrating' => { 402 => 'rating.user', 408 => 'urat' },
	'usmlenselectronicmf' => { 2 => 0x7, 86 => 0x7, 87 => 0x501 },
	'uspsnumber' => { 530 => 'uspsNumber' },
	'utmeasting' => { 171 => 'Easting' },
	'utmmapdatum' => { 171 => 'Datum' },
	'utmnorthing' => { 171 => 'Northing' },
	'utmzone' => { 171 => 'Zone' },
	'uuid' => { 511 => 'UUID', 513 => 'UUID' },
	'uv-irfiltercorrection' => { 343 => 0x325 },
	'validbits' => { 328 => 0x611, 329 => 0x102c },
	'validcropcorners' => { 338 => 'ValidCropCorners' },
	'validpixeldepth' => { 332 => 0x611 },
	'variablelowpassfilter' => { 449 => 0x2028 },
	'variousmodes' => { 143 => 0x26 },
	'variousmodes2' => { 143 => 0x3a },
	'variprogram' => { 239 => 0xab },
	'varraydacnominalvalues' => { 141 => 0x191e },
	'vendor' => { 408 => 'vndr' },
	'vendorinfo' => { 490 => 'VendorInfo' },
	'vendorinfomanufacturer' => { 490 => [\'VendorInfo','VendorInfoManufacturer'] },
	'vendorinfomodel' => { 490 => [\'VendorInfo','VendorInfoModel'] },
	'vendorinfonotes' => { 490 => [\'VendorInfo','VendorInfoNotes'] },
	'verbatimidentification' => { 121 => [\'Identification','IdentificationVerbatimIdentification'] },
	'version' => { 130 => 0x0, 338 => 'Version', 399 => 'Version', 402 => 'version', 511 => 'Version', 513 => 'Version', 522 => 'Version' },
	'versioncreatedate' => { 486 => 0xd100 },
	'versionid' => { 541 => 'VersionID' },
	'versionidentifier' => { 530 => 'versionIdentifier' },
	'versionmodifydate' => { 486 => 0xd101 },
	'versions' => { 541 => 'Versions' },
	'versionscomments' => { 541 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 541 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 541 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 541 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 541 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 541 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 541 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 541 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 541 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 541 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 541 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 304 => '3.2', 305 => '47.2', 307 => '79.1', 321 => 0x11d, 322 => 0x135 },
	'verticalclockoverlaps' => { 141 => 0x412 },
	'verticalfuncbutton' => { 305 => '42.2', 307 => '67.1', 321 => 0x115, 322 => 0x12d },
	'verticalfuncbuttonplaybackmode' => { 321 => 0x1b7, 322 => 0x1cf },
	'verticalfuncbuttonplusdials' => { 305 => '43.1' },
	'verticalfuncplusdials' => { 307 => '68.1' },
	'verticalisobutton' => { 248 => 0x792 },
	'verticalmovieafonbutton' => { 321 => 0x1f9, 322 => 0x211 },
	'verticalmoviefuncbutton' => { 321 => 0x1e1, 322 => 0x1f9 },
	'verticalmultiselector' => { 305 => '42.1', 307 => '66.1', 308 => '66.1', 318 => '66.1', 321 => 0x18f, 322 => 0x1a7 },
	'verticalmultiselectorplaybackmode' => { 321 => 0x125, 322 => 0x13d },
	'vfdisplayillumination' => { 2 => 0x11, 87 => [0x510,0x51d] },
	'vibrance' => { 505 => 'Vibrance', 511 => 'Vibrance', 513 => 'Vibrance' },
	'vibrationreduction' => { 268 => [0x75,0x82,0x1ae], 276 => '586.1', 283 => '590.2', 287 => 0x4 },
	'videoalphamode' => { 540 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 540 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 540 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 540 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 540 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 540 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 540 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 540 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 540 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 540 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 540 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 540 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 540 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 540 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 540 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 540 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 540 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 540 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 525 => 'videoBitRate' },
	'videobitratemode' => { 525 => 'videoBitRateMode' },
	'videoburstmode' => { 348 => 0xbb },
	'videoburstresolution' => { 348 => 0xb3 },
	'videocodec' => { 69 => 0x74 },
	'videocolorspace' => { 540 => 'videoColorSpace' },
	'videocompression' => { 130 => 0x3806 },
	'videocompressor' => { 540 => 'videoCompressor' },
	'videodisplayaspectratio' => { 525 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 525 => 'videoEncodingProfile' },
	'videofieldorder' => { 540 => 'videoFieldOrder' },
	'videoframerate' => { 348 => 0x27, 540 => 'videoFrameRate' },
	'videoframesize' => { 540 => 'videoFrameSize' },
	'videoframesizeh' => { 540 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 540 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 540 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 540 => 'videoModDate' },
	'videopixelaspectratio' => { 540 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 540 => 'videoPixelDepth' },
	'videopreburst' => { 348 => 0xc1 },
	'videoquality' => { 116 => 0x4003 },
	'videorecordingmode' => { 130 => 0x3803 },
	'videoshottype' => { 525 => 'VideoShotType' },
	'videoshottypeidentifier' => { 525 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 525 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 525 => 'videoStreamsCount' },
	'viewfinder' => { 392 => 0x455 },
	'viewfinderdisplay' => { 304 => '12.4', 305 => '6.3' },
	'viewfinderwarning' => { 304 => '13.4', 314 => '3.5', 315 => '6.2', 319 => '4.4' },
	'viewfinderwarnings' => { 87 => 0x40a },
	'viewinfoduringexposure' => { 87 => 0x407 },
	'viewingmode' => { 437 => 0x2f, 454 => 0x18 },
	'viewingmode2' => { 437 => [0x85,0x285] },
	'viewmodeshoweffectsofsettings' => { 248 => 0x7d2, 320 => 0x2a9 },
	'viewpoint' => { 529 => 'viewpoint' },
	'vignetteamount' => { 511 => 'VignetteAmount', 513 => 'VignetteAmount' },
	'vignettecoefficient1' => { 288 => 0x24 },
	'vignettecoefficient2' => { 288 => 0x34 },
	'vignettecoefficient3' => { 288 => 0x44 },
	'vignettecontrol' => { 239 => 0x2a, 297 => 0x76a43205 },
	'vignettecontrolintensity' => { 297 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 508 => 'VignetteCorrectionAlreadyApplied' },
	'vignettecorrectionversion' => { 288 => 0x0 },
	'vignettemidpoint' => { 511 => 'VignetteMidpoint', 513 => 'VignetteMidpoint' },
	'vignetting' => { 415 => 0x1011, 422 => 0xa052 },
	'vignettingcorrection' => { 122 => 0x7031, 422 => 0xa053, 449 => 0x2011 },
	'vignettingcorrparams' => { 122 => 0x7032, 480 => 0x64a, 481 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 422 => 0xa054 },
	'virtualfocallength' => { 526 => 'VirtualFocalLength' },
	'virtualhorizonstyle' => { 320 => 0x167, 321 => 0x167, 322 => 0x17f },
	'virtualimagexcenter' => { 526 => 'VirtualImageXCenter' },
	'virtualimageycenter' => { 526 => 'VirtualImageYCenter' },
	'visualcolor' => { 525 => 'VisualColour' },
	'visualtechnique' => { 529 => 'visualTechnique' },
	'voicememo' => { 424 => 0x216 },
	'volume' => { 530 => 'volume' },
	'vr_0x66' => { 268 => 0x66 },
	'vrdoffset' => { 66 => 0xd0 },
	'vrmode' => { 244 => 0x226, 245 => 0x226, 246 => 0x212, 247 => 0x226, 248 => 0x226, 287 => 0x6 },
	'vrtype' => { 287 => 0x8 },
	'waterdepth' => { 122 => 0x9403, 518 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 190 => 0x19a },
	'wb_bluelevel6500k' => { 190 => 0x18a },
	'wb_bluelevelcustom' => { 190 => 0x18e },
	'wb_bluelevelscloudy' => { 190 => 0x106 },
	'wb_bluelevelsdaylight' => { 190 => 0xea },
	'wb_bluelevelsflash' => { 190 => 0x122 },
	'wb_bluelevelsfluorescent' => { 190 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 190 => 0x254 },
	'wb_bluelevelsshade' => { 190 => 0x176 },
	'wb_bluelevelstungsten' => { 190 => 0xce },
	'wb_gbrglevels' => { 190 => 0xae, 193 => 0x4 },
	'wb_glevel' => { 328 => 0x11f },
	'wb_glevel3000k' => { 328 => 0x113 },
	'wb_glevel3300k' => { 328 => 0x114 },
	'wb_glevel3600k' => { 328 => 0x115 },
	'wb_glevel3900k' => { 328 => 0x116 },
	'wb_glevel4000k' => { 328 => 0x117 },
	'wb_glevel4300k' => { 328 => 0x118 },
	'wb_glevel4500k' => { 328 => 0x119 },
	'wb_glevel4800k' => { 328 => 0x11a },
	'wb_glevel5300k' => { 328 => 0x11b },
	'wb_glevel6000k' => { 328 => 0x11c },
	'wb_glevel6600k' => { 328 => 0x11d },
	'wb_glevel7500k' => { 328 => 0x11e },
	'wb_grbglevels' => { 207 => 0x0, 456 => 0x7303 },
	'wb_grbglevelsauto' => { 83 => 0x2, 456 => 0x7302 },
	'wb_grbglevelscloudy' => { 83 => 0x12 },
	'wb_grbglevelscustom1' => { 83 => 0x42 },
	'wb_grbglevelscustom2' => { 83 => 0x4a },
	'wb_grbglevelsdaylight' => { 83 => 0xa },
	'wb_grbglevelsflash' => { 83 => 0x32 },
	'wb_grbglevelsfluorescent' => { 83 => 0x22 },
	'wb_grbglevelsfluorhigh' => { 83 => 0x2a },
	'wb_grbglevelstungsten' => { 83 => 0x1a },
	'wb_grbglevelsunderwater' => { 83 => 0x3a },
	'wb_rbgglevels' => { 204 => 0x0 },
	'wb_rblevels' => { 208 => 0x270, 239 => 0xc, 328 => 0x100 },
	'wb_rblevels1' => { 354 => 0x2 },
	'wb_rblevels2' => { 354 => 0x5 },
	'wb_rblevels3' => { 354 => 0x8 },
	'wb_rblevels3000k' => { 328 => 0x102 },
	'wb_rblevels3300k' => { 328 => 0x103 },
	'wb_rblevels3500k' => { 190 => 0x430 },
	'wb_rblevels3600k' => { 328 => 0x104 },
	'wb_rblevels3900k' => { 328 => 0x105 },
	'wb_rblevels4' => { 354 => 0xb },
	'wb_rblevels4000k' => { 328 => 0x106 },
	'wb_rblevels4300k' => { 328 => 0x107 },
	'wb_rblevels4500k' => { 328 => 0x108 },
	'wb_rblevels4800k' => { 328 => 0x109 },
	'wb_rblevels5' => { 354 => 0xe },
	'wb_rblevels5300k' => { 328 => 0x10a },
	'wb_rblevels6' => { 354 => 0x11 },
	'wb_rblevels6000k' => { 328 => 0x10b },
	'wb_rblevels6500k' => { 190 => 0x420 },
	'wb_rblevels6600k' => { 328 => 0x10c },
	'wb_rblevels7' => { 354 => 0x14 },
	'wb_rblevels7500k' => { 328 => 0x10d },
	'wb_rblevelsauto' => { 208 => 0x272, 332 => 0x110 },
	'wb_rblevelscloudy' => { 190 => 0x3f0, 192 => 0x10, 208 => 0x296, 332 => 0x121 },
	'wb_rblevelscoolwhitef' => { 190 => 0x308, 192 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 332 => 0x132 },
	'wb_rblevelscustom' => { 190 => 0x424, 192 => 0x1c },
	'wb_rblevelscwb1' => { 328 => 0x10e },
	'wb_rblevelscwb2' => { 328 => 0x10f },
	'wb_rblevelscwb3' => { 328 => 0x110 },
	'wb_rblevelscwb4' => { 328 => 0x111 },
	'wb_rblevelsdaylight' => { 190 => [0x3ec,0x528], 192 => 0xc, 208 => 0x274 },
	'wb_rblevelsdaylightf' => { 192 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 332 => 0x130 },
	'wb_rblevelsdaywhitef' => { 192 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 332 => 0x131 },
	'wb_rblevelseveningsunlight' => { 332 => 0x124 },
	'wb_rblevelsfineweather' => { 332 => 0x122 },
	'wb_rblevelsflash' => { 190 => [0x3f4,0x304], 192 => 0x18, 208 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 208 => 0x290 },
	'wb_rblevelsincandescent' => { 208 => 0x282 },
	'wb_rblevelsshade' => { 190 => 0x418, 192 => 0x20, 208 => 0x2b2, 332 => 0x120 },
	'wb_rblevelstungsten' => { 190 => 0x3e8, 192 => 0x8, 332 => 0x123 },
	'wb_rblevelsused' => { 332 => 0x100 },
	'wb_rblevelswhitef' => { 192 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 332 => 0x133 },
	'wb_redlevel3500k' => { 190 => 0x198 },
	'wb_redlevel6500k' => { 190 => 0x188 },
	'wb_redlevelcustom' => { 190 => 0x18c },
	'wb_redlevelscloudy' => { 190 => 0xf8 },
	'wb_redlevelsdaylight' => { 190 => 0xdc },
	'wb_redlevelsflash' => { 190 => 0x114 },
	'wb_redlevelsfluorescent' => { 190 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 190 => 0x1be },
	'wb_redlevelsshade' => { 190 => 0x168 },
	'wb_redlevelstungsten' => { 190 => 0xc0 },
	'wb_rgbglevels' => { 206 => 0x0 },
	'wb_rgblevels' => { 190 => [0x546,0x96], 344 => 0xd, 345 => 0x413, 350 => 0x3036, 392 => 0x107, 458 => 0x117c, 459 => 0x1180, 460 => 0x115c, 461 => 0x11d8, 462 => 0x11b4, 463 => 0x106c, 464 => 0x264, 465 => 0x264, 466 => 0x252 },
	'wb_rgblevels1' => { 355 => 0x2 },
	'wb_rgblevels2' => { 355 => 0x6 },
	'wb_rgblevels2500k' => { 456 => 0x782d },
	'wb_rgblevels3' => { 355 => 0xa },
	'wb_rgblevels3200k' => { 456 => 0x782c },
	'wb_rgblevels4' => { 355 => 0xe },
	'wb_rgblevels4500k' => { 456 => [0x7484,0x7824] },
	'wb_rgblevels5' => { 355 => 0x12 },
	'wb_rgblevels6' => { 355 => 0x16 },
	'wb_rgblevels6000k' => { 456 => 0x782b },
	'wb_rgblevels7' => { 355 => 0x1a },
	'wb_rgblevels8500k' => { 456 => 0x782a },
	'wb_rgblevelsauto' => { 426 => 0x0 },
	'wb_rgblevelscloudy' => { 456 => [0x7481,0x7821] },
	'wb_rgblevelscustom1' => { 426 => 0x15 },
	'wb_rgblevelscustom2' => { 426 => 0x18 },
	'wb_rgblevelscustom3' => { 426 => 0x1b },
	'wb_rgblevelsdaylight' => { 426 => 0x3, 456 => [0x7480,0x7820] },
	'wb_rgblevelsflash' => { 426 => 0x12, 456 => [0x7483,0x7823] },
	'wb_rgblevelsfluorescent' => { 426 => 0xf, 456 => [0x7486,0x7826] },
	'wb_rgblevelsfluorescentm1' => { 456 => 0x7829 },
	'wb_rgblevelsfluorescentp1' => { 456 => 0x7827 },
	'wb_rgblevelsfluorescentp2' => { 456 => 0x7828 },
	'wb_rgblevelsincandescent' => { 426 => 0xc },
	'wb_rgblevelsovercast' => { 426 => 0x9 },
	'wb_rgblevelsshade' => { 426 => 0x6, 456 => 0x7825 },
	'wb_rgblevelstungsten' => { 456 => [0x7482,0x7822] },
	'wb_rgblevelsunknown0' => { 427 => 0x0 },
	'wb_rgblevelsunknown1' => { 427 => 0x3 },
	'wb_rgblevelsunknown2' => { 427 => 0x6 },
	'wb_rgblevelsunknown3' => { 427 => 0x9 },
	'wb_rgblevelsunknown4' => { 427 => 0xc },
	'wb_rgblevelsunknown5' => { 427 => 0xf },
	'wb_rgblevelsunknown6' => { 427 => 0x12 },
	'wb_rgblevelsunknown7' => { 427 => 0x15 },
	'wb_rgblevelsunknown8' => { 427 => 0x18 },
	'wb_rgblevelsunknown9' => { 427 => 0x1b },
	'wb_rgbmuldaylight' => { 141 => 0x852 },
	'wb_rgbmulflash' => { 141 => 0x855 },
	'wb_rgbmulfluorescent' => { 141 => 0x854 },
	'wb_rgbmultungsten' => { 141 => 0x853 },
	'wb_rggbblacklevels' => { 37 => 0x25 },
	'wb_rggblevels' => { 122 => 0x7313, 193 => 0x4, 205 => 0x0, 209 => 0x13e8, 210 => 0x38, 456 => 0x7313 },
	'wb_rggblevelsasshot' => { 40 => 0x0, 41 => 0x0, 42 => 0x19, 43 => 0x55, 44 => 0x69, 45 => 0x22, 46 => 0x3f, 49 => 0x3f, 50 => 0x3f, 51 => 0x3f, 52 => 0x47 },
	'wb_rggblevelsauto' => { 37 => 0x1, 40 => 0x5, 41 => 0x8, 42 => 0x1e, 43 => 0x5a, 44 => 0x6e, 45 => 0x18, 46 => 0x44, 49 => 0x44, 50 => 0x44, 51 => 0x44, 52 => 0x4c, 209 => 0x1478, 210 => 0x114, 422 => 0xa022, 456 => 0x7312 },
	'wb_rggblevelsblack' => { 422 => 0xa028 },
	'wb_rggblevelscloudy' => { 37 => 0xd, 40 => 0x1e, 41 => 0x30, 42 => 0x2d, 43 => 0xa0, 44 => 0xd7, 45 => 0x31, 46 => 0x58, 49 => 0x71, 50 => 0x8a, 51 => 0x8f, 52 => 0x92, 209 => 0x1408, 210 => 0x60, 383 => 0x20f, 391 => 0x14 },
	'wb_rggblevelscustom' => { 37 => 0x1d, 46 => 0x80, 209 => 0x1468, 210 => 0x100 },
	'wb_rggblevelscustom1' => { 42 => 0x41 },
	'wb_rggblevelscustom2' => { 42 => 0x46 },
	'wb_rggblevelsdaylight' => { 37 => 0x5, 40 => 0x14, 41 => 0x20, 42 => 0x23, 43 => 0x96, 44 => 0xcd, 45 => 0x27, 46 => 0x4e, 49 => 0x67, 50 => 0x80, 51 => 0x85, 52 => 0x88, 209 => 0x13f8, 210 => 0x4c, 383 => 0x20d, 391 => 0x2 },
	'wb_rggblevelsflash' => { 37 => 0x19, 40 => 0x32, 41 => 0x50, 42 => 0x3c, 43 => 0xb4, 44 => 0xeb, 45 => 0x45, 46 => 0x6c, 49 => 0x85, 50 => 0x9e, 51 => 0xa3, 52 => 0xa6, 209 => 0x1448, 383 => 0x214, 391 => 0x41 },
	'wb_rggblevelsfluorescent' => { 37 => 0x15, 40 => 0x28, 41 => 0x40, 42 => 0x37, 43 => 0xaa, 44 => 0xe1, 45 => 0x3b, 46 => 0x62, 49 => 0x7b, 50 => 0x94, 51 => 0x99, 52 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 210 => 0xc4, 383 => 0x211, 391 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 391 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 210 => 0xb0, 383 => 0x212, 391 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 209 => 0x1438, 210 => 0x9c, 383 => 0x213, 391 => 0x38 },
	'wb_rggblevelshtmercury' => { 210 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 422 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 422 => 0xa024 },
	'wb_rggblevelskelvin' => { 37 => 0x21, 40 => 0x2d, 41 => 0x48, 43 => 0xaf, 44 => 0xe6, 45 => 0x40, 46 => 0x67, 49 => 0x80, 50 => 0x99, 51 => 0x9e, 52 => 0xa1 },
	'wb_rggblevelsmeasured' => { 40 => 0xa, 41 => 0x10, 43 => 0x5f, 44 => 0x73, 46 => 0x49, 49 => 0x49, 50 => 0x49, 51 => 0x49, 52 => 0x51 },
	'wb_rggblevelspc1' => { 45 => 0x90, 46 => 0x71 },
	'wb_rggblevelspc2' => { 45 => 0x95, 46 => 0x76 },
	'wb_rggblevelspc3' => { 45 => 0x9a, 46 => 0x7b },
	'wb_rggblevelsshade' => { 37 => 0x9, 40 => 0x19, 41 => 0x28, 42 => 0x28, 43 => 0x9b, 44 => 0xd2, 45 => 0x2c, 46 => 0x53, 49 => 0x6c, 50 => 0x85, 51 => 0x8a, 52 => 0x8d, 210 => 0x74, 383 => 0x20e, 391 => 0xb },
	'wb_rggblevelstungsten' => { 37 => 0x11, 40 => 0x23, 41 => 0x38, 42 => 0x32, 43 => 0xa5, 44 => 0xdc, 45 => 0x36, 46 => 0x5d, 49 => 0x76, 50 => 0x8f, 51 => 0x94, 52 => 0x97, 209 => 0x1428, 210 => 0x88, 383 => 0x210, 391 => 0x1d },
	'wb_rggblevelsuncorrected' => { 422 => 0xa021 },
	'wb_rggblevelsunknown' => { 40 => 0xf, 41 => 0x18, 43 => 0x64, 44 => 0x78, 45 => 0x1d, 49 => 0x4e, 50 => 0x4e, 51 => 0x4e, 52 => 0x56, 391 => 0x53 },
	'wb_rggblevelsunknown10' => { 40 => 0x5f, 41 => 0x98, 43 => 0x91, 44 => 0xa5, 45 => 0x72, 49 => 0x9e, 50 => 0x7b, 51 => 0x7b, 52 => 0x83 },
	'wb_rggblevelsunknown11' => { 40 => 0x64, 41 => 0xa0, 43 => 0xb9, 44 => [0xaa,0xaf], 45 => 0x77, 49 => 0xa3, 50 => 0xa3, 51 => 0x80, 52 => 0xab },
	'wb_rggblevelsunknown12' => { 40 => 0x69, 41 => 0xa8, 43 => 0xbe, 44 => 0xb4, 45 => 0x7c, 49 => 0xa8, 50 => 0xa8, 51 => 0xa8, 52 => 0xb0 },
	'wb_rggblevelsunknown13' => { 40 => 0x6e, 41 => 0xb0, 43 => 0xc3, 44 => 0xb9, 45 => 0x81, 49 => 0xad, 50 => 0xad, 51 => 0xad, 52 => 0xb5 },
	'wb_rggblevelsunknown14' => { 43 => 0xc8, 44 => 0xbe, 45 => 0x86, 49 => 0xb2, 50 => 0xb2, 51 => 0xb2, 52 => 0xba },
	'wb_rggblevelsunknown15' => { 43 => 0xcd, 44 => 0xc3, 45 => 0x8b, 49 => 0xb7, 50 => 0xb7, 51 => 0xb7, 52 => 0xbf },
	'wb_rggblevelsunknown16' => { 43 => 0xd2, 44 => 0xc8, 45 => 0x9f, 50 => 0xbc, 51 => 0xbc, 52 => 0xc4 },
	'wb_rggblevelsunknown17' => { 43 => 0xd7, 44 => 0xf0, 50 => 0xc1, 51 => 0xc1, 52 => 0xc9 },
	'wb_rggblevelsunknown18' => { 43 => 0xdc, 44 => 0xf5, 50 => 0xc6, 51 => 0xc6, 52 => 0xce },
	'wb_rggblevelsunknown19' => { 43 => 0xe1, 44 => 0xfa, 50 => 0xcb, 51 => 0xcb, 52 => 0xd3 },
	'wb_rggblevelsunknown2' => { 40 => 0x37, 41 => 0x58, 43 => 0x69, 44 => 0x7d, 45 => 0x4a, 49 => 0x53, 50 => 0x53, 51 => 0x53, 52 => 0x5b },
	'wb_rggblevelsunknown20' => { 43 => 0xe6, 44 => 0xff, 50 => 0xd0, 51 => 0xd0, 52 => 0xd8 },
	'wb_rggblevelsunknown21' => { 43 => 0xeb, 44 => 0x104, 51 => 0xd5, 52 => 0xdd },
	'wb_rggblevelsunknown22' => { 43 => 0xf0, 44 => 0x109, 51 => 0xda, 52 => 0xe2 },
	'wb_rggblevelsunknown23' => { 43 => 0xf5, 44 => 0x10e, 51 => 0xdf, 52 => 0xe7 },
	'wb_rggblevelsunknown24' => { 43 => 0xfa, 44 => 0x113, 51 => 0xe4, 52 => 0xec },
	'wb_rggblevelsunknown25' => { 43 => 0xff, 44 => 0x118, 51 => 0xe9, 52 => 0xf1 },
	'wb_rggblevelsunknown26' => { 43 => 0x104, 44 => 0x11d, 51 => 0xee, 52 => 0xf6 },
	'wb_rggblevelsunknown27' => { 43 => 0x109, 44 => 0x122, 51 => 0xf3, 52 => 0xfb },
	'wb_rggblevelsunknown28' => { 43 => 0x10e, 51 => 0xf8, 52 => 0x100 },
	'wb_rggblevelsunknown29' => { 43 => 0x113, 51 => 0xfd, 52 => 0x105 },
	'wb_rggblevelsunknown3' => { 40 => 0x3c, 41 => 0x60, 43 => 0x6e, 44 => 0x82, 45 => 0x4f, 49 => 0x58, 50 => 0x58, 51 => 0x58, 52 => 0x60 },
	'wb_rggblevelsunknown30' => { 51 => 0x102 },
	'wb_rggblevelsunknown4' => { 40 => 0x41, 41 => 0x68, 43 => 0x73, 44 => 0x87, 45 => 0x54, 49 => 0x5d, 50 => 0x5d, 51 => 0x5d, 52 => 0x65 },
	'wb_rggblevelsunknown5' => { 40 => 0x46, 41 => 0x70, 43 => 0x78, 44 => 0x8c, 45 => 0x59, 49 => 0x62, 50 => 0x62, 51 => 0x62, 52 => 0x6a },
	'wb_rggblevelsunknown6' => { 40 => 0x4b, 41 => 0x78, 43 => 0x7d, 44 => 0x91, 45 => 0x5e, 49 => 0x8a, 50 => 0x67, 51 => 0x67, 52 => 0x6f },
	'wb_rggblevelsunknown7' => { 40 => 0x50, 41 => 0x80, 43 => 0x82, 44 => 0x96, 45 => 0x63, 49 => 0x8f, 50 => 0x6c, 51 => 0x6c, 52 => 0x74 },
	'wb_rggblevelsunknown8' => { 40 => 0x55, 41 => 0x88, 43 => 0x87, 44 => 0x9b, 45 => 0x68, 49 => 0x94, 50 => 0x71, 51 => 0x71, 52 => 0x79 },
	'wb_rggblevelsunknown9' => { 40 => 0x5a, 41 => 0x90, 43 => 0x8c, 44 => 0xa0, 45 => 0x6d, 49 => 0x99, 50 => 0x76, 51 => 0x76, 52 => 0x7e },
	'wb_rggblevelsuserselected' => { 391 => 0x5c },
	'wbadjblueamber' => { 106 => 0x20106 },
	'wbadjbluebalance' => { 303 => 0x8 },
	'wbadjcolortemp' => { 106 => 0x20102, 111 => 0x1a },
	'wbadjlighting' => { 303 => 0x14 },
	'wbadjmagentagreen' => { 106 => 0x20105 },
	'wbadjmode' => { 303 => 0x10 },
	'wbadjredbalance' => { 303 => 0x0 },
	'wbadjrggblevels' => { 106 => 0x20125, 111 => 0x6 },
	'wbadjtemperature' => { 303 => 0x18 },
	'wbadjtint' => { 303 => 0x25 },
	'wbbluelevel' => { 343 => 0x324, 348 => 0x8006, 353 => 0x26 },
	'wbbracketingsteps' => { 201 => 0x10, 202 => 0x10, 277 => 0x174d },
	'wbbracketmode' => { 59 => 0x9 },
	'wbbracketshotnumber' => { 190 => 0x2b, 415 => 0x101a },
	'wbbracketvalueab' => { 59 => 0xc },
	'wbbracketvaluegm' => { 59 => 0xd },
	'wbbutton' => { 245 => 0x806, 248 => 0x80a },
	'wbbuttonplaybackmode' => { 320 => 0x1c5 },
	'wbfinetuneactive' => { 111 => 0x24 },
	'wbfinetunesaturation' => { 111 => 0x28 },
	'wbfinetunetone' => { 111 => 0x2c },
	'wbgreenlevel' => { 343 => 0x323, 348 => 0x8005, 353 => 0x25 },
	'wbmediaimagesizesetting' => { 87 => 0x708 },
	'wbmode' => { 192 => 0x4, 329 => 0x1015 },
	'wbredlevel' => { 343 => 0x322, 348 => 0x8004, 353 => 0x24 },
	'wbscale' => { 193 => 0x0 },
	'wbshiftab' => { 76 => 0xc, 348 => 0x46, 365 => 0x10 },
	'wbshiftab_gm' => { 449 => 0x2014 },
	'wbshiftab_gm_precise' => { 449 => 0x2026 },
	'wbshiftcreativecontrol' => { 348 => 0x92 },
	'wbshiftgm' => { 76 => 0xd, 348 => 0x47, 365 => 0x11 },
	'wbshiftintelligentauto' => { 348 => 0x8b },
	'wbtype1' => { 354 => 0x1, 355 => 0x1 },
	'wbtype2' => { 354 => 0x4, 355 => 0x5 },
	'wbtype3' => { 354 => 0x7, 355 => 0x9 },
	'wbtype4' => { 354 => 0xa, 355 => 0xd },
	'wbtype5' => { 354 => 0xd, 355 => 0x11 },
	'wbtype6' => { 354 => 0x10, 355 => 0x15 },
	'wbtype7' => { 354 => 0x13, 355 => 0x19 },
	'webstatement' => { 544 => 'WebStatement' },
	'weightedflatsubject' => { 503 => 'weightedFlatSubject' },
	'what' => { 511 => 'What', 513 => 'What' },
	'whitebalance' => { 7 => 0x6f, 8 => [0x44,0x4a], 9 => 0xbc, 10 => 0x36, 11 => 0x5e, 12 => 0x36, 13 => 0x78, 14 => 0x6f, 15 => 0x6f, 16 => 0x73, 17 => 0x6f, 18 => 0x78, 19 => 0x54, 20 => 0x6f, 21 => 0xbc, 22 => 0x7b, 24 => 0xbc, 25 => 0xc2, 27 => 0x131, 28 => 0x77, 76 => 0x8, 79 => 0x7, 115 => 0x7, 116 => [0x19,0x2012], 122 => [0xa403,0xfe4e], 130 => 0x1002, 141 => 0x3fc, 142 => 0xfa0d, 143 => 0x40, 154 => 0x1a, 184 => 0x3, 185 => 0xe, 186 => 0x4, 187 => 0xb, 189 => 0x115, 239 => 0x5, 286 => 0x7, 343 => 0x304, 348 => 0x3, 350 => 0x3033, 383 => 0x19, 390 => 0x7, 414 => 0x26, 415 => 0x1003, 425 => [0x88,0x3c,0x7,0x58], 435 => 0xf, 436 => 0xe, 449 => [0x115,0xb054], 511 => 'WhiteBalance', 513 => 'WhiteBalance', 517 => 'WhiteBalance' },
	'whitebalance0' => { 179 => 'WhiteBalance0' },
	'whitebalance1' => { 179 => 'WhiteBalance1' },
	'whitebalance2' => { 179 => 'WhiteBalance2', 324 => 0x500 },
	'whitebalanceadj' => { 106 => 0x20101, 111 => 0x18, 297 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 361 => 0x0 },
	'whitebalancebias' => { 116 => 0x2011, 329 => 0x304, 348 => 0x23 },
	'whitebalanceblue' => { 76 => 0x7 },
	'whitebalancebracket' => { 324 => 0x502, 329 => 0x303 },
	'whitebalancebracketing' => { 187 => 0x22, 190 => 0x2c, 446 => 0x2c },
	'whitebalancebuttonplaybackmode' => { 321 => 0x1c5, 322 => 0x1dd },
	'whitebalancecomp' => { 332 => 0x1001 },
	'whitebalancedetected' => { 141 => 0x3fb },
	'whitebalancefinetune' => { 130 => 0x100a, 187 => 0x38, 189 => 0x112, 239 => [0xb,0x3f], 415 => 0x1004, 435 => 0x6, 436 => 0x5, 449 => 0x112 },
	'whitebalancemode' => { 141 => 0x3fa, 383 => 0x1a },
	'whitebalancered' => { 76 => 0x6 },
	'whitebalanceset' => { 364 => 0xa },
	'whitebalancesetting' => { 187 => 0x23, 435 => 0x5, 436 => 0x4, 437 => 0x16, 454 => 0xd },
	'whitebalancesetup' => { 422 => 0x41 },
	'whitebalancetemperature' => { 324 => 0x501 },
	'whiteboard' => { 329 => 0x301 },
	'whitelevel' => { 122 => 0xc61d, 383 => 0x7e, 456 => 0x787f },
	'whitepoint' => { 122 => 0x13e, 347 => 0x35d, 383 => 0x201, 536 => 'WhitePoint' },
	'whites2012' => { 511 => 'Whites2012', 513 => 'Whites2012' },
	'whitesadj' => { 486 => 0x9017 },
	'wideadapter' => { 415 => 0x1017 },
	'widefocuszone' => { 184 => 0x2f },
	'widerange' => { 424 => 0x20f },
	'windmode' => { 141 => 0x3f4 },
	'windnoisereduction' => { 244 => 0x352, 245 => 0x352, 246 => 0x2d6, 247 => 0x2fe, 248 => 0x2fe },
	'windowlocation' => { 408 => 'WLOC' },
	'windowsatom' => { 512 => 'windowsAtom' },
	'windowsatomextension' => { 512 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 512 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 512 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 530 => 'wordCount' },
	'work' => { 400 => "\xa9wrk" },
	'workcolorspace' => { 106 => 0x10200, 111 => 0x270 },
	'workflowtag' => { 525 => 'WorkflowTag' },
	'workflowtagcvid' => { 525 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 525 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 525 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 525 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 519 => 'WorkToDo' },
	'worldtimelocation' => { 348 => 0x3a, 383 => 0x22, 389 => '0.1' },
	'writer' => { 182 => 'WM/Writer' },
	'writer-editor' => { 134 => 0x7a },
	'x3filllight' => { 425 => 0x12 },
	'xattrmditemwherefroms' => { 177 => 'com.apple.metadata:kMDItemWhereFroms' },
	'xattrquarantine' => { 177 => 'com.apple.quarantine' },
	'xiaomimodel' => { 122 => 0x9a00 },
	'xiaomisettings' => { 122 => 0x9999 },
	'xilinxversion' => { 141 => 0x414 },
	'xml' => { 139 => 'xml ' },
	'xmp' => { 109 => 0xffff00f6, 123 => 'XMP' },
	'xmptoolkit' => { 537 => 'xmptk' },
	'xpauthor' => { 122 => 0x9c9d },
	'xpcomment' => { 122 => 0x9c9c },
	'xpkeywords' => { 122 => 0x9c9e },
	'xposition' => { 122 => 0x11e },
	'xpsubject' => { 122 => 0x9c9f },
	'xptitle' => { 122 => 0x9c9b },
	'xresolution' => { 122 => 0x11a, 137 => 0x3, 398 => 0x0, 536 => 'XResolution' },
	'xyresolution' => { 126 => 0x3 },
	'yaw' => { 118 => 0x7, 408 => ['_yaw',"\xa9fyw"] },
	'yawangle' => { 253 => 0x8, 420 => 0x0 },
	'ycbcrcoefficients' => { 122 => 0x211, 536 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 122 => 0x213, 536 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 122 => 0x212, 536 => 'YCbCrSubSampling' },
	'year' => { 400 => 'yrrc', 402 => 'year', 408 => 'yrrc' },
	'yearcreated' => { 143 => 0x10, 152 => 0xc },
	'yellowhsl' => { 106 => 0x20912 },
	'yield' => { 532 => 'yield' },
	'yposition' => { 122 => 0x11f },
	'yresolution' => { 122 => 0x11b, 137 => 0x5, 398 => 0x4, 536 => 'YResolution' },
	'zebrapatterntonerange' => { 320 => 0x211, 321 => 0x211, 322 => 0x229 },
	'zoneidentifier' => { 123 => 'ZoneIdentifier' },
	'zonematching' => { 189 => 0x10a, 192 => [0x3a,0x4a], 449 => 0xb024 },
	'zonematchingmode' => { 187 => 0x14 },
	'zonematchingon' => { 186 => 0x75 },
	'zonematchingvalue' => { 435 => 0x1f },
	'zoomedpreviewlength' => { 329 => 0xf05 },
	'zoomedpreviewsize' => { 329 => 0xf06 },
	'zoomedpreviewstart' => { 329 => 0xf04 },
	'zoomsourcewidth' => { 36 => 0x24 },
	'zoomstepcount' => { 327 => 0x300, 329 => 0x100d },
	'zoomtargetwidth' => { 36 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_misb' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accel360fly' => 1,
	'acceldata' => 1,
	'accelerometermatrix' => 1,
	'accelerometertime' => 1,
	'accelerometerunknown' => 1,
	'accelmode' => 1,
	'accelypr' => 1,
	'accessdate' => 1,
	'accessrights' => 1,
	'accompaniment' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acdsee-rs' => 1,
	'acidizer' => 1,
	'acidizerflags' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actors' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'additionalinfo' => 1,
	'adjdebuginfo' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aedebuginfo' => 1,
	'aeflags' => 1,
	'aehistograminfo' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'aeliveviewhistograminfo' => 1,
	'aeliveviewlocalhistogram' => 1,
	'aelocalhistogram' => 1,
	'af' => 1,
	'af-cprioritysel' => 1,
	'af-sprioritysel' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'afdebuginfo' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airfieldbarometricpressure' => 1,
	'airfieldelevation' => 1,
	'airspeed' => 1,
	'airtemperature' => 1,
	'airulerunits' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartistsortorder' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitlesortorder' => 1,
	'alerts' => 1,
	'alexa' => 1,
	'alexa-paireddevicename' => 1,
	'alexa-pairing' => 1,
	'alexa-privacymode' => 1,
	'alexa-wakewordlanguage' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternatealtitude' => 1,
	'alternateduotonecolors' => 1,
	'alternateellipsoidheight' => 1,
	'alternateellipsoidheightextended' => 1,
	'alternateheading' => 1,
	'alternatelatitude' => 1,
	'alternatelongitude' => 1,
	'alternatename' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'altitudefromtakeoff' => 1,
	'ambienceinfo' => 1,
	'ambisonicchannelmap' => 1,
	'ambisonicchannelordering' => 1,
	'ambisonicchannels' => 1,
	'ambisonicnormalization' => 1,
	'ambisonicorder' => 1,
	'ambisonictype' => 1,
	'amendlocalset' => 1,
	'angleaxis' => 1,
	'angleofattack' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'appledataoffsets' => 1,
	'applemaildatereceived' => 1,
	'applemaildatesent' => 1,
	'applemailflagged' => 1,
	'applemailisremoteattachment' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'application' => 1,
	'application_riff' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationunknown' => 1,
	'applicationversion' => 1,
	'applysettingstoliveview' => 1,
	'appname' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'arcoreaccel' => 1,
	'arcorecustom' => 1,
	'arcoregyro' => 1,
	'arcorevideo' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artists' => 1,
	'artisturl' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantdirector' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'associateddatalist' => 1,
	'associatedimagefile' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'ast' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atob3' => 1,
	'atom0' => 1,
	'atsccontent' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attr' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiolevel' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoridentifier' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorname' => 1,
	'authors' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'autoareaafstartingpoint' => 1,
	'autocaptureoffset' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'automationanimation' => 1,
	'automationflags' => 1,
	'autopoweroff' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimageref' => 1,
	'auxiliaryimagetype' => 1,
	'av1configuration' => 1,
	'av1configurationversion' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averageframerate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbdebuginfo' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'axml' => 1,
	'b1' => 1,
	'b2' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barcodes' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'basename' => 1,
	'baseviewpointnum' => 1,
	'basicfileinfo' => 1,
	'basisobject' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats' => 1,
	'beats-per-minute' => 1,
	'beautycolorlevel' => 1,
	'beautyretouchlevel' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bibliographicreferences' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binarydata' => 1,
	'binarydatatype' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'binning' => 1,
	'birthday' => 1,
	'bitdepthchroma' => 1,
	'bitdepthluma' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetoothmacaddress' => 1,
	'bluetoothname' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'blurstrength' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'body' => 1,
	'bokehshape' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bpm' => 1,
	'bps' => 1,
	'bracketingburstoptions' => 1,
	'bracketingcounter' => 1,
	'bracketingmode' => 1,
	'bracketingoffset' => 1,
	'bracketingstep' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'brdfatob0' => 1,
	'brdfatob1' => 1,
	'brdfatob2' => 1,
	'brdfatob3' => 1,
	'brdfbtoa0' => 1,
	'brdfbtoa1' => 1,
	'brdfbtoa2' => 1,
	'brdfbtoa3' => 1,
	'brdfbtod0' => 1,
	'brdfbtod1' => 1,
	'brdfbtod2' => 1,
	'brdfbtod3' => 1,
	'brdfcolorimetricparam0' => 1,
	'brdfcolorimetricparam1' => 1,
	'brdfcolorimetricparam2' => 1,
	'brdfcolorimetricparam3' => 1,
	'brdfdtob0' => 1,
	'brdfdtob1' => 1,
	'brdfdtob2' => 1,
	'brdfdtob3' => 1,
	'brdfmtob0' => 1,
	'brdfmtob1' => 1,
	'brdfmtob2' => 1,
	'brdfmtob3' => 1,
	'brdfmtos0' => 1,
	'brdfmtos1' => 1,
	'brdfmtos2' => 1,
	'brdfmtos3' => 1,
	'brdfspectralparam0' => 1,
	'brdfspectralparam1' => 1,
	'brdfspectralparam2' => 1,
	'brdfspectralparam3' => 1,
	'breakchar' => 1,
	'briefdescription' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'brotliexif' => 1,
	'brotlijumb' => 1,
	'brotlixmp' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btoa3' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwf_umid' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'byteordermark' => 1,
	'bytes' => 1,
	'bytesperline' => 1,
	'bytesperminute' => 1,
	'c2pasalthash' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'callsign' => 1,
	'camcore' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapan' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'cameratilt' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfog5xii' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfor6' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'car' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'catalognumber' => 1,
	'caveats' => 1,
	'cbor' => 1,
	'cbordata' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'character' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'checksum' => 1,
	'children' => 1,
	'chmversion' => 1,
	'choregrapher' => 1,
	'chromaformat' => 1,
	'chromasampleposition' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chrominancetable' => 1,
	'chunkcount' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'churchillnav' => 1,
	'cicodepoints' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classificationandmarkingsystem' => 1,
	'classificationcomments' => 1,
	'classificationreason' => 1,
	'classifiedby' => 1,
	'classifyingcountry' => 1,
	'classifyingcountrycodemethod' => 1,
	'classifyingcountrycodingmethoddate' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmddialsaperturesetting' => 1,
	'cmddialschangemainsub' => 1,
	'cmddialschangemainsubexposure' => 1,
	'cmddialsmenuandplayback' => 1,
	'cmddialsreverserotexposurecomp' => 1,
	'cmmflags' => 1,
	'cmp1' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantinfoout' => 1,
	'colorantorder' => 1,
	'colorantorderout' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalance0219' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown1' => 1,
	'colorbalanceunknown2' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata10' => 1,
	'colordata11' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorencodingparams' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetricspecification' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorpopstrength' => 1,
	'colorprimaries' => 1,
	'colorprofiles' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspacename' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransferfunction' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columncount' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblefontname' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composernationality' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositeimaginglocalset' => 1,
	'compositinglayerheader' => 1,
	'compositionlocation' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressioncodecs' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'constantframerate' => 1,
	'constraintindicatorflags' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentlightlevel' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstatus' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'coproducer' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'cornerlatitude1' => 1,
	'cornerlatitude2' => 1,
	'cornerlatitude3' => 1,
	'cornerlatitude4' => 1,
	'cornerlongitude1' => 1,
	'cornerlongitude2' => 1,
	'cornerlongitude3' => 1,
	'cornerlongitude4' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crc' => 1,
	'crcdevelparams' => 1,
	'crd' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapp' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatormodule' => 1,
	'creatoros' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs0' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepointlabel' => 1,
	'cuepointnote' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'customsettingsz8' => 1,
	'customsettingsz9' => 1,
	'customsettingsz9v4' => 1,
	'customtostandardpcc' => 1,
	'cxf' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'd2' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateencoded' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datepurchased' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetagged' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'datewritten' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'db' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'declassificationdate' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultcmyk' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultsettings' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delimiter' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'densityaltitude' => 1,
	'densityaltitudeextended' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthhwheight' => 1,
	'depthhwwidth' => 1,
	'depthmapdata' => 1,
	'depthmapdata2' => 1,
	'depthmapheight' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'depthswheight' => 1,
	'depthswwidth' => 1,
	'derivedimageref' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'deviceorientation' => 1,
	'devicesettings' => 1,
	'devicesounds' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'differentialpressure' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directionalatob0' => 1,
	'directionalatob1' => 1,
	'directionalatob2' => 1,
	'directionalatob3' => 1,
	'directionalbtoa0' => 1,
	'directionalbtoa1' => 1,
	'directionalbtoa2' => 1,
	'directionalbtoa3' => 1,
	'directionalbtod0' => 1,
	'directionalbtod1' => 1,
	'directionalbtod2' => 1,
	'directionalbtod3' => 1,
	'directionaldtob0' => 1,
	'directionaldtob1' => 1,
	'directionaldtob2' => 1,
	'directionaldtob3' => 1,
	'directorofphotography' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distance' => 1,
	'distancefromhome' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'dji-dbg' => 1,
	'dji_dtat' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'docversion' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dronepitch' => 1,
	'dronequaternion' => 1,
	'droneroll' => 1,
	'droneyaw' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualfiles' => 1,
	'dualshotextra' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'dynamicranger128' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit4data' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'ef' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectstrength' => 1,
	'effectsvisible' => 1,
	'effecttype' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electricalextendermagnification' => 1,
	'electronicimagestabilization' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimage2' => 1,
	'embeddedimageclass' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagerectangle' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideo' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emergencysos' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endianness' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'et' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'eventstarttime' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimes' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedalbumname' => 1,
	'extendedartistname' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedtracktitle' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'extremeweathermode' => 1,
	'f-stop' => 1,
	'f_' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'fax' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fcc-id' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileguid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterparametersbinary' => 1,
	'filterparameterscustomcustomdata' => 1,
	'filterparametersexportexportdata' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finetune' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firmwareversion51' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfo0300' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flightdegree' => 1,
	'flightspeed' => 1,
	'flipstatus' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'flirdata' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'flyingstate' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusframesize' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspointbrightness' => 1,
	'focuspointselectionspeed' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'follow-meanimation' => 1,
	'follow-memode' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formatsdcard' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fps' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framebaseview' => 1,
	'framecenterelevation' => 1,
	'framecenterheightaboveellipsoid' => 1,
	'framecenterlatitude' => 1,
	'framecenterlongitude' => 1,
	'framedelay' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'frameview' => 1,
	'framinggriddisplay' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fuelremaining' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullangleofattack' => 1,
	'fullname' => 1,
	'fullpitchangle' => 1,
	'fullrollangle' => 1,
	'fullscreen' => 1,
	'fullsideslipangle' => 1,
	'fusion360fly' => 1,
	'fusionmode' => 1,
	'fusionypr' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gainmapimage' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gamutboundarydescription0' => 1,
	'gamutboundarydescription1' => 1,
	'gamutboundarydescription2' => 1,
	'gamutboundarydescription3' => 1,
	'gapless' => 1,
	'garmingps' => 1,
	'garminmodel' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gcamera' => 1,
	'gcreations' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generalencapsulatedobject' => 1,
	'generallevelidc' => 1,
	'generalprofileidc' => 1,
	'generalprofilespace' => 1,
	'generaltierflag' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genericflagdata01' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genprofilecompatibilityflags' => 1,
	'genr' => 1,
	'geo' => 1,
	'geob-data' => 1,
	'geob-desc' => 1,
	'geob-file' => 1,
	'geob-mime' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geolocationbearing' => 1,
	'geolocationcity' => 1,
	'geolocationcountry' => 1,
	'geolocationcountrycode' => 1,
	'geolocationdistance' => 1,
	'geolocationfeaturecode' => 1,
	'geolocationpopulation' => 1,
	'geolocationposition' => 1,
	'geolocationregion' => 1,
	'geolocationsubregion' => 1,
	'geolocationtimezone' => 1,
	'geolocationwarning' => 1,
	'geometricdistortionparams' => 1,
	'georegistrationlocalset' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbaldegree' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalpalette' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'gpano' => 1,
	'gpmd_fmas' => 1,
	'gpmd_gopro' => 1,
	'gpmd_kingslim' => 1,
	'gpmd_rove' => 1,
	'gps' => 1,
	'gps360fly' => 1,
	'gpsaltituderaw' => 1,
	'gpsaltitudesystem' => 1,
	'gpsdata' => 1,
	'gpsdatalist' => 1,
	'gpsdatalist2' => 1,
	'gpsdatetimeraw' => 1,
	'gpsdestaltitude' => 1,
	'gpsframingaltitude' => 1,
	'gpsframinglatitude' => 1,
	'gpsframinglongitude' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpslatitude2' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongitude2' => 1,
	'gpslongituderaw' => 1,
	'gpsmode' => 1,
	'gpspos' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpsstamp' => 1,
	'gpstargetaltitude' => 1,
	'gpstargetlatitude' => 1,
	'gpstargetlongitude' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocitydown' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'gravityvector' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'gridsize' => 1,
	'groundrange' => 1,
	'groupareac1' => 1,
	'groupcaption' => 1,
	'groupmutualexclusion' => 1,
	'groups' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guano' => 1,
	'gyro360fly' => 1,
	'gyromode' => 1,
	'gyroscope' => 1,
	'gyroscopeunknown' => 1,
	'gyroypr' => 1,
	'halftonedegree' => 1,
	'halftonelpi' => 1,
	'halftonelpiunit' => 1,
	'halftonemisc' => 1,
	'halftonescreen' => 1,
	'halftoneshape' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasselbladexif' => 1,
	'hasselbladrawimage' => 1,
	'hasselbladxml' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdmibitdepth' => 1,
	'hdmiexternalrecorder' => 1,
	'hdmioutputhdr' => 1,
	'hdmioutputrange' => 1,
	'hdrgm' => 1,
	'hdrinfo' => 1,
	'hdrinfo2' => 1,
	'hdrinfoversion' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hevcconfigurationversion' => 1,
	'hiddendata' => 1,
	'hiddeninfo' => 1,
	'hiddenslides' => 1,
	'highbitdepth' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'highnote' => 1,
	'highvelocity' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintmaxoutputvalue' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalfieldofview' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'hotspotx' => 1,
	'hotspoty' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huawei' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlapsdebuginfo' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'iad1' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iccprofilelocation' => 1,
	'icingdetected' => 1,
	'icondir' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idsbasevalue' => 1,
	'idstring' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagecoordinatesystem' => 1,
	'imagedatadiscard' => 1,
	'imagedatahash' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imagegeometry' => 1,
	'imageheader' => 1,
	'imageheightinches' => 1,
	'imagehorizonpixelpack' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagelocation' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imagepixeloffset' => 1,
	'imagepixelstorage' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesampleformat' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestabilisation' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imagewidthinches' => 1,
	'imageworkstationmake' => 1,
	'imagingdata' => 1,
	'imdb' => 1,
	'imdb_id' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexbackground' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'indextransparent' => 1,
	'indicatedairspeed' => 1,
	'indications' => 1,
	'infirayfactory' => 1,
	'infirayisothermal' => 1,
	'infiraymixmode' => 1,
	'infirayopmode' => 1,
	'infiraypicture' => 1,
	'infiraysensor' => 1,
	'infirayversion' => 1,
	'info' => 1,
	'ingrreserved' => 1,
	'initialdelaysamples' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'inputheight' => 1,
	'inputorientation' => 1,
	'inputuniformity' => 1,
	'inputwidth' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'insta360' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'instruments' => 1,
	'insv' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'intervaloffset' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isartbokeh' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoautooffset' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemdesignatorid' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'ixml' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpegimagelength' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jpgfromraw2' => 1,
	'jpginfooffset' => 1,
	'jplcartoifd' => 1,
	'jps' => 1,
	'jpscomment' => 1,
	'jpsflags' => 1,
	'jpslayout' => 1,
	'jpsseparation' => 1,
	'jpstype' => 1,
	'jsondata' => 1,
	'jsonmetadata' => 1,
	'jumbf' => 1,
	'jumbfbox' => 1,
	'jumbfdescr' => 1,
	'jumdid' => 1,
	'jumdlabel' => 1,
	'jumdsignature' => 1,
	'jumdtoggles' => 1,
	'jumdtype' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'jxlcodestream' => 1,
	'k1' => 1,
	'k2' => 1,
	'k3' => 1,
	'k4' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepexposurewithteleconverter' => 1,
	'keepuntil' => 1,
	'keepusersettings' => 1,
	'kelvinwb' => 1,
	'kenwooddata' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf' => 1,
	'kf8coveruri' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kilocalories' => 1,
	'kinds' => 1,
	'kj' => 1,
	'kk' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelcode' => 1,
	'labeledtext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'languages' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'laserprfcode' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'lawrating' => 1,
	'layerblendmodes' => 1,
	'layercolors' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layersections' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layervisible' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lccn' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'leftmargin' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdata0402' => 1,
	'lensdata0403' => 1,
	'lensdata0800' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfacing' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'ligo_json' => 1,
	'limage' => 1,
	'limitaf-areamodeselautoanimals' => 1,
	'limitaf-areamodeselautopeople' => 1,
	'limitaf-areamodeseldynamic' => 1,
	'limitaf-areamodeselwidelanimals' => 1,
	'limitaf-areamodeselwidelpeople' => 1,
	'limitafareamodesel3d' => 1,
	'limitafareamodeseld105' => 1,
	'limitafareamodeseld25' => 1,
	'limitafareamodeseld49' => 1,
	'limitafareamodeseld9' => 1,
	'limitafareamodeselgroup' => 1,
	'limitafareamodeselgroupc1' => 1,
	'limitafareamodeselgroupc2' => 1,
	'limitreleasemodeselmirror-up' => 1,
	'limitreleasemodeselq' => 1,
	'limitreleasemodeseltimer' => 1,
	'limitselectableimagearea5to4' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'linecount' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedfilename' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkgoodput' => 1,
	'linkinfo' => 1,
	'linkquality' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'linux' => 1,
	'listtype' => 1,
	'lit' => 1,
	'livephotoinfo' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationinfo' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loginfo' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopcount' => 1,
	'lotus' => 1,
	'lowlightaf' => 1,
	'lownote' => 1,
	'lowvelocity' => 1,
	'lr' => 1,
	'lslv' => 1,
	'lucasjunk' => 1,
	'lumaaverage' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'luminancetable' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'mag360fly' => 1,
	'magmode' => 1,
	'magneticfield' => 1,
	'magneticheading' => 1,
	'magnetometer' => 1,
	'magnetometerxyz' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'marl' => 1,
	'masksubarea' => 1,
	'masteredby' => 1,
	'mastergainadjustment' => 1,
	'matrixcoefficients' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxcontentlightlevel' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumshutterangle' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxpicaveragelightlevel' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mccdata' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemaudiobitrate' => 1,
	'mditemaudiochannelcount' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcodecs' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentcreationdateranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditemdurationseconds' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditeminterestingdateranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlastuseddate_ranking' => 1,
	'mditemlatitude' => 1,
	'mditemlensmodel' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemmediatypes' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemstreamable' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemtotalbitrate' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemuserdownloadeddate' => 1,
	'mditemuserdownloadeduserhandle' => 1,
	'mditemusersharedreceiveddate' => 1,
	'mditemusersharedreceivedrecipient' => 1,
	'mditemusersharedreceivedrecipienthandle' => 1,
	'mditemusersharedreceivedsender' => 1,
	'mditemusersharedreceivedsenderhandle' => 1,
	'mditemusersharedreceivedtransport' => 1,
	'mditemversion' => 1,
	'mditemvideobitrate' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measure' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementinputinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediadataoffset' => 1,
	'mediadatasize' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediauniqueid' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'menuoffset' => 1,
	'menusettingsoffset' => 1,
	'menusettingsoffsetz7ii' => 1,
	'menusettingsoffsetz8' => 1,
	'menusettingsoffsetz8v2' => 1,
	'menusettingsoffsetz9' => 1,
	'menusettingsoffsetz9v3' => 1,
	'menusettingsoffsetz9v4' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metadataversion' => 1,
	'metaformat' => 1,
	'metaimagesize' => 1,
	'metarelation' => 1,
	'metasampledesc' => 1,
	'metatype' => 1,
	'metdata' => 1,
	'meter' => 1,
	'meterinfo' => 1,
	'meteringbutton' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'mett' => 1,
	'microphonewet' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midipitchfraction' => 1,
	'midisong' => 1,
	'midiunitynote' => 1,
	'mie' => 1,
	'miiscoreidentifier' => 1,
	'mileage' => 1,
	'mimeencoding' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'minspatialsegmentationidc' => 1,
	'mintransmissiontime' => 1,
	'missionid' => 1,
	'mixedby' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modelstamp' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monostrength' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'moresettingsoffset' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviefragment' => 1,
	'moviefragmentheader' => 1,
	'moviefragmentsequence' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'moviehighlightdisplaypattern' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'moviewhitebalancesameasphoto' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'mtoa0' => 1,
	'mtob0' => 1,
	'mtob1' => 1,
	'mtob2' => 1,
	'mtob3' => 1,
	'mtos0' => 1,
	'mtos1' => 1,
	'mtos2' => 1,
	'mtos3' => 1,
	'multiexp' => 1,
	'multiexposure2' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiplexdefaultvalues' => 1,
	'multiplextypearray' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'mynextbase-paireddevicename' => 1,
	'mynextbase-pairing' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'nbcd' => 1,
	'ncc' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'newlines' => 1,
	'nextbasemeta' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikonapp' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonnefinfo' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'nine' => 1,
	'nineedits' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'normallinetransfertiming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlicenseplate' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numplanes' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numsampleloops' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'numtemporallayers' => 1,
	'objectcountrycodes' => 1,
	'objectcountrycodingmethod' => 1,
	'objectcountrycodingmethoddate' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectorientation' => 1,
	'objectsizeannounced' => 1,
	'observationdate' => 1,
	'observationdateend' => 1,
	'observationtime' => 1,
	'observationtimeend' => 1,
	'observer' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offset13' => 1,
	'offsetcornerlatitude1' => 1,
	'offsetcornerlatitude2' => 1,
	'offsetcornerlatitude3' => 1,
	'offsetcornerlatitude4' => 1,
	'offsetcornerlongitude1' => 1,
	'offsetcornerlongitude2' => 1,
	'offsetcornerlongitude3' => 1,
	'offsetcornerlongitude4' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'oleinfo' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'on1_settingsdata' => 1,
	'on1_settingsmetadatacreated' => 1,
	'on1_settingsmetadatamodified' => 1,
	'on1_settingsmetadataname' => 1,
	'on1_settingsmetadatapluginid' => 1,
	'on1_settingsmetadatatimestamp' => 1,
	'on1_settingsmetadatausage' => 1,
	'on1_settingsmetadatavisibletouser' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationalmode' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'opticalvr' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'orientationoffset' => 1,
	'orientoffset' => 1,
	'original' => 1,
	'originalalbum' => 1,
	'originaldate' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originalmedia' => 1,
	'originalmediatype' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originalyear' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'othermeta' => 1,
	'othername' => 1,
	'otheroffset' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputheight' => 1,
	'outputorientation' => 1,
	'outputresponse' => 1,
	'outputwidth' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parallelismtype' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalratingreason' => 1,
	'parkingmode' => 1,
	'parrotautomation' => 1,
	'parrotfollowme' => 1,
	'parrottimestamp' => 1,
	'parrotv1' => 1,
	'parrotv2' => 1,
	'parrotv3' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialjxlcodestream' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partoffset' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'pdrversion' => 1,
	'peakbitrate' => 1,
	'peaklevelr128' => 1,
	'peaklevelsample' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'perfmode' => 1,
	'performersortorder' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'phone' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pilotingmode' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchrollyaw' => 1,
	'pittasoft' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'playbackflickdownrating' => 1,
	'playbackflickuprating' => 1,
	'playbackframerate' => 1,
	'playcounter' => 1,
	'playlist' => 1,
	'playlistdelay' => 1,
	'playlistindex' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraitmatrix' => 1,
	'portraitoffset' => 1,
	'portraittonescaletable' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'prediminanthue' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'prefersubselectorcenter' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewjxl' => 1,
	'previewjxllength' => 1,
	'previewjxlstart' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryfileguid' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsbleedwidth' => 1,
	'printflagsbleedwidthscale' => 1,
	'printflagscrop' => 1,
	'printflagsinfo' => 1,
	'printflagsversion' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productioncopyright' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversionnumber' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesequenceinfo' => 1,
	'profilesize' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projectidcode' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protune' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'ptrh' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasecurrency' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purchaseitem' => 1,
	'purchaseowner' => 1,
	'purchaseprice' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'quietshuttershootingspeed' => 1,
	'quoting' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rangeimagelocalset' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawburstmoderoll' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimageaspectratio' => 1,
	'rawimagecroppedsize' => 1,
	'rawimagecroptopleft' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagenumber' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawvaluerangemax' => 1,
	'rawvaluerangemin' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'rearcontropaneldisplay' => 1,
	'recallshootfuncaf-on' => 1,
	'recallshootfuncafareamode' => 1,
	'recallshootfuncaperture' => 1,
	'recallshootfuncexposurecomp' => 1,
	'recallshootfuncexposuremode' => 1,
	'recallshootfuncfocustracking' => 1,
	'recallshootfunciso' => 1,
	'recallshootfuncmeteringmode' => 1,
	'recallshootfuncshutterspeed' => 1,
	'recallshootfuncwhitebalance' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingdates' => 1,
	'recordinghistory' => 1,
	'recordinglocation' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'records' => 1,
	'recordsv2' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencename' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectedtemperature' => 1,
	'reflection' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relatedresources' => 1,
	'relationship' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'releasinginstructions' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'remixedby' => 1,
	'remotefuncbutton' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaingain' => 1,
	'replaygainpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replaytrackgain' => 1,
	'replaytrackpeak' => 1,
	'replayvolumelevel' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resolutioninfo' => 1,
	'resolutionxlengthunit' => 1,
	'resolutionxunit' => 1,
	'resolutionylengthunit' => 1,
	'resolutionyunit' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'reversingcamera' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrdta' => 1,
	'ricohrdtb' => 1,
	'ricohrdtc' => 1,
	'ricohrdtg' => 1,
	'ricohrdtl' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rootnote' => 1,
	'rot360fly' => 1,
	'rotationangle' => 1,
	'rotationinfooffset' => 1,
	'rotationxyz' => 1,
	'rotmode' => 1,
	'roundtripversion' => 1,
	'rowcount' => 1,
	'rowinterleavefactor' => 1,
	'rsrc' => 1,
	'rtmd' => 1,
	'rtos' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	'rvtlocalset' => 1,
	's2n' => 1,
	'sample' => 1,
	'sampleblacksequence' => 1,
	'sampledatetime' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'sampleperiod' => 1,
	'sampler' => 1,
	'samplerate2' => 1,
	'samplerdata' => 1,
	'samplerdatalen' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungmodel' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'samsungtrailer' => 1,
	'samsunguniqueid' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'sarmotionimagerydata' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'savefocus' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'sceneclassification' => 1,
	'scenecolorimetryestimates' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screendimming' => 1,
	'screenheight' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenplayby' => 1,
	'screensaver' => 1,
	'screenwidth' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'script' => 1,
	'scriptcommand' => 1,
	'sdc' => 1,
	'sdcardclass' => 1,
	'sdcardformat' => 1,
	'sdcardmanfdate' => 1,
	'sdcardmanfid' => 1,
	'sdcardmodelno' => 1,
	'sdcardoemid' => 1,
	'sdcardserialno' => 1,
	'sdcardsize' => 1,
	'sdcardtype' => 1,
	'sdcardusedspace' => 1,
	'sdcc-flp' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondcam' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'securitylocalmetadataset' => 1,
	'securitysci-shiinformation' => 1,
	'securityversion' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'segheight' => 1,
	'segmentlocalset' => 1,
	'segwidth' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'semanticinstanceid' => 1,
	'semanticname' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensitivityvalue' => 1,
	'sensorbottomborder' => 1,
	'sensordata' => 1,
	'sensordefects' => 1,
	'sensorellipsoidheight' => 1,
	'sensorellipsoidheightextended' => 1,
	'sensorfieldofviewname' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorname' => 1,
	'sensorreadouttime' => 1,
	'sensorrelativeazimuthangle' => 1,
	'sensorrelativeelevationangle' => 1,
	'sensorrelativerollangle' => 1,
	'sensorrightborder' => 1,
	'sensorvelocityeast' => 1,
	'sensorvelocitynorth' => 1,
	'seqcount' => 1,
	'seqfinal' => 1,
	'seqframeinfo' => 1,
	'seqid' => 1,
	'seqindex' => 1,
	'seqlevelidx0' => 1,
	'seqprofile' => 1,
	'seqtier0' => 1,
	'seqtype' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'sequenceoffset' => 1,
	'serialinfo' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'settingsoffset' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod6' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod7500' => 1,
	'shotinfod780' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'shotinfoz7ii' => 1,
	'shotinfoz8' => 1,
	'shotinfoz9' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutterangle' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sidelightstrength' => 1,
	'sideslipangle' => 1,
	'sigma' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'singleshotdepthmap' => 1,
	'singleshotdepthmaptiff' => 1,
	'singleshotmeta' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'skipinfo' => 1,
	'slantrange' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'smpteformat' => 1,
	'smpteoffset' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sony_0x9416' => 1,
	'sonyfnumber2' => 1,
	'sonyhiddendata' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'sortwith' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialaudio' => 1,
	'spatialaudioversion' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'spectralviewingconditions' => 1,
	'spectralwhitepoint' => 1,
	'speed' => 1,
	'speedstamp' => 1,
	'speedunits' => 1,
	'sphericalvideo' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spinstrength' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'standardtocustompcc' => 1,
	'standbymonitorofftime' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'staticpressure' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stillimagetime' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streamid' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdialframeadvance' => 1,
	'subdialframeadvancerating0' => 1,
	'subdialframeadvancerating1' => 1,
	'subdialframeadvancerating2' => 1,
	'subdialframeadvancerating3' => 1,
	'subdialframeadvancerating4' => 1,
	'subdialframeadvancerating5' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surfacemap' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'synopsis' => 1,
	'systeminfo' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9050c' => 1,
	'tag9050d' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9401' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag9406b' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'tag9416_0000' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tailnumber' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targeterrorestimatece90' => 1,
	'targeterrorestimatele90' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetlocationcovariancematrix' => 1,
	'targetlocationelevation' => 1,
	'targetlocationlatitude' => 1,
	'targetlocationlongitude' => 1,
	'targettrackgateheight' => 1,
	'targettrackgatewidth' => 1,
	'targetwidth' => 1,
	'targetwidthextended' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telescope' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporalidnested' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'thanksto' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thermalcalibration' => 1,
	'thermaldata' => 1,
	'thermalparams' => 1,
	'thermalparams2' => 1,
	'thermalparams3' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailartist' => 1,
	'thumbnailbitspersample' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcolordepth' => 1,
	'thumbnailcompressedsize' => 1,
	'thumbnailcompression' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailcopyright' => 1,
	'thumbnaildata' => 1,
	'thumbnaildatetime' => 1,
	'thumbnaildescription' => 1,
	'thumbnailequipmake' => 1,
	'thumbnailequipmodel' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailhash' => 1,
	'thumbnailimageheight' => 1,
	'thumbnailimagewidth' => 1,
	'thumbnailorientation' => 1,
	'thumbnailphotometricinterp' => 1,
	'thumbnailplanarconfig' => 1,
	'thumbnailplanes' => 1,
	'thumbnailprimarychromaticities' => 1,
	'thumbnailrawbytes' => 1,
	'thumbnailref' => 1,
	'thumbnailrefblackwhite' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailresolutionunit' => 1,
	'thumbnailresolutionx' => 1,
	'thumbnailresolutiony' => 1,
	'thumbnailrowsperstrip' => 1,
	'thumbnailsamplesperpixel' => 1,
	'thumbnailsoftware' => 1,
	'thumbnailstripbytecounts' => 1,
	'thumbnailstripoffsets' => 1,
	'thumbnailtiff' => 1,
	'thumbnailtransferfunction' => 1,
	'thumbnailurl' => 1,
	'thumbnailwhitepoint' => 1,
	'thumbnailycbcrcoefficients' => 1,
	'thumbnailycbcrpositioning' => 1,
	'thumbnailycbcrsubsampling' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timeanddate' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelapse' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamplist' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'timezonedst' => 1,
	'tipl' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'tmdb' => 1,
	'tmdb_id' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tomtomad' => 1,
	'tomtomhl' => 1,
	'tomtomid' => 1,
	'tomtommetadata' => 1,
	'tomtomvd' => 1,
	'tomtomvi' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'topmargin' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalparts' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transfercharacteristic' => 1,
	'transfercharacteristics' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentcolor' => 1,
	'transparentindex' => 1,
	'transportstreamid' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'trim' => 1,
	'trueairspeed' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'tuning' => 1,
	'tvdb' => 1,
	'twelvebit' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'uas_lsversionnumber' => 1,
	'uasdatalink' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'umid' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'uniqueid' => 1,
	'unknown' => 1,
	'unknown00' => 1,
	'unknown01' => 1,
	'unknown02' => 1,
	'unknown03' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknownexif' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unsharpdata' => 1,
	'unshiftednote' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'usertext' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-c2paclaimsignature' => 1,
	'uuid-canon' => 1,
	'uuid-canon2' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-signature' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalaf-onbutton' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalfieldofview' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalspeed' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videofullrangeflag' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videolength' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotimestamp' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignetteinfo' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'vintagestrength' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmtidataset' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumelevelr128' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelscustom' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wbsettings' => 1,
	'wbsettings2' => 1,
	'wcsprofiles' => 1,
	'weaponfired' => 1,
	'weaponload' => 1,
	'webp_flags' => 1,
	'webpage' => 1,
	'weight' => 1,
	'what3words' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wi-fimacaddress' => 1,
	'wi-fipassword' => 1,
	'wi-fissid' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'wifirssi' => 1,
	'winddirection' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'windprocessing' => 1,
	'windspeed' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wpgversion' => 1,
	'wrapmodes' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrapplemaildatereceived' => 1,
	'xattrapplemaildatesent' => 1,
	'xattrapplemailisremoteattachment' => 1,
	'xattrfinderinfo' => 1,
	'xattrlastuseddate' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xidiri' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmlpackets' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpdsa' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilecomment' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zisrawversion' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zoomstrength' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'gpslatitude' => 'Image::ExifTool::GPS',
	'gpslongitude' => 'Image::ExifTool::GPS',
	'gpsposition' => 'Image::ExifTool::Exif',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names to lookup corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level structure
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                my $lcFlat = $$newInfo{FlatName} ? lc($$newInfo{FlatName}) : $lcTag;
                AddFields($tagTablePtr, $tagID, $lcFlat, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (sort { $a <=> $b } keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        no strict 'refs';
                        $reload = 1 if &$writeProc();
                    }
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2024, Phil Harvey (philharvey66 at gmail.com)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
