#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.20';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CNTH',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoG5XII',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoR6',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData10',
	'Image::ExifTool::Canon::ColorData11',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LevelInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::LogInfo',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::RawBurstInfo',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::Canon::WBInfo',
	'Image::ExifTool::Canon::uuid',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::ColorSpec',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type5',
	'Image::ExifTool::Kodak::Type6',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Microsoft::Xtra',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFInfo2V0400',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::AutoCaptureInfo',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::BracketingInfoD500',
	'Image::ExifTool::Nikon::BracketingInfoD810',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::ColorBalanceUnknown2',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::DistortionInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::FlashInfo0300',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::HDRInfo2',
	'Image::ExifTool::Nikon::ISOAutoInfoD810',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::IntervalInfoD6',
	'Image::ExifTool::Nikon::IntervalInfoZ7II',
	'Image::ExifTool::Nikon::JPGInfoD500',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LensData0402',
	'Image::ExifTool::Nikon::LensData0403',
	'Image::ExifTool::Nikon::LensData0800',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MakerNotes0x51',
	'Image::ExifTool::Nikon::MakerNotes0x56',
	'Image::ExifTool::Nikon::MenuSettingsD850',
	'Image::ExifTool::Nikon::MenuSettingsZ7II',
	'Image::ExifTool::Nikon::MenuSettingsZ8',
	'Image::ExifTool::Nikon::MenuSettingsZ8v2',
	'Image::ExifTool::Nikon::MenuSettingsZ9',
	'Image::ExifTool::Nikon::MenuSettingsZ9v3',
	'Image::ExifTool::Nikon::MenuSettingsZ9v4',
	'Image::ExifTool::Nikon::MoreSettingsD850',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::MultiExposure2',
	'Image::ExifTool::Nikon::Offset13InfoZ9',
	'Image::ExifTool::Nikon::OrientationInfo',
	'Image::ExifTool::Nikon::OtherInfoD500',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PictureControl3',
	'Image::ExifTool::Nikon::PortraitInfoZ7II',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::RotationInfoD500',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::SeqInfoD6',
	'Image::ExifTool::Nikon::SeqInfoZ9',
	'Image::ExifTool::Nikon::SettingsInfoD810',
	'Image::ExifTool::Nikon::ShootingMenuD500',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::VignetteInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::NikonCustom::SettingsZ8',
	'Image::ExifTool::NikonCustom::SettingsZ9',
	'Image::ExifTool::NikonCustom::SettingsZ9v4',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::DSA',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::LevelInfoK3III',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::ItemList',
	'Image::ExifTool::QuickTime::ItemPropCont',
	'Image::ExifTool::QuickTime::Keys',
	'Image::ExifTool::QuickTime::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::QuickTime::UserData',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Reconyx::Type3',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sigma::WBSettings',
	'Image::ExifTool::Sigma::WBSettings2',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::HiddenInfo',
	'Image::ExifTool::Sony::ISOInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::SR2SubIFD',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9050c',
	'Image::ExifTool::Sony::Tag9050d',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag9406b',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::ACDSeeRegions',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Device',
	'Image::ExifTool::XMP::ExifTool',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GCamera',
	'Image::ExifTool::XMP::GContainer',
	'Image::ExifTool::XMP::GCreations',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crd',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::hdr',
	'Image::ExifTool::XMP::hdrgm',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::panorama',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 113 => 0x69 },
	'about' => { 537 => 'about' },
	'aboutcvterm' => { 528 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 528 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 528 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 528 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 528 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 120 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 543 => 'absPeakAudioFilePath' },
	'academicfield' => { 533 => 'academicField' },
	'acceleration' => { 123 => 0x9404, 521 => 'Acceleration' },
	'accelerationtracking' => { 88 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 420 => 0x3 },
	'accelerometerdata' => { 410 => 'vrot' },
	'accelerometerx' => { 349 => 0x8d },
	'accelerometery' => { 349 => 0x8e },
	'accelerometerz' => { 349 => 0x8c },
	'accessoryserialnumber' => { 349 => 0x54 },
	'accessorytype' => { 349 => 0x53 },
	'acdseeregion' => { 489 => [\'Regions','RegionsRegionList'] },
	'acdseeregionalgarea' => { 489 => [\'Regions','RegionsRegionListALGArea'] },
	'acdseeregionalgareah' => { 489 => [\'Regions','RegionsRegionListALGAreaH'] },
	'acdseeregionalgareaw' => { 489 => [\'Regions','RegionsRegionListALGAreaW'] },
	'acdseeregionalgareax' => { 489 => [\'Regions','RegionsRegionListALGAreaX'] },
	'acdseeregionalgareay' => { 489 => [\'Regions','RegionsRegionListALGAreaY'] },
	'acdseeregionappliedtodimensions' => { 489 => [\'Regions','RegionsAppliedToDimensions'] },
	'acdseeregionappliedtodimensionsh' => { 489 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'acdseeregionappliedtodimensionsunit' => { 489 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'acdseeregionappliedtodimensionsw' => { 489 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'acdseeregiondlyarea' => { 489 => [\'Regions','RegionsRegionListDLYArea'] },
	'acdseeregiondlyareah' => { 489 => [\'Regions','RegionsRegionListDLYAreaH'] },
	'acdseeregiondlyareaw' => { 489 => [\'Regions','RegionsRegionListDLYAreaW'] },
	'acdseeregiondlyareax' => { 489 => [\'Regions','RegionsRegionListDLYAreaX'] },
	'acdseeregiondlyareay' => { 489 => [\'Regions','RegionsRegionListDLYAreaY'] },
	'acdseeregionname' => { 489 => [\'Regions','RegionsRegionListName'] },
	'acdseeregionnameassigntype' => { 489 => [\'Regions','RegionsRegionListNameAssignType'] },
	'acdseeregiontype' => { 489 => [\'Regions','RegionsRegionListType'] },
	'actionadvised' => { 135 => 0x2a },
	'activearea' => { 123 => 0xc68d },
	'actived-lighting' => { 240 => 0x22, 296 => 0x24 },
	'actived-lightingmode' => { 296 => 0x25 },
	'adaptervoltage' => { 142 => 0x407 },
	'addaspectratioinfo' => { 88 => 0x80e },
	'addiptcinformation' => { 88 => 0x815 },
	'additionalmodelinformation' => { 528 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 88 => 0x80f, 89 => 0x11, 90 => 0x13, 93 => 0x14 },
	'address' => { 165 => 'Address' },
	'adjustmentmode' => { 427 => 0x15 },
	'adlbracketingstep' => { 202 => 0x17 },
	'adlbracketingtype' => { 202 => 0x18 },
	'adobe' => { 124 => 'Adobe' },
	'adultcontentwarning' => { 335 => 'AdultContentWarning', 536 => 'adultContentWarning' },
	'advancedfilter' => { 131 => 0x1201 },
	'advancedraw' => { 298 => 0x76a43203 },
	'advancedscenetype' => { 349 => 0x3d },
	'advisory' => { 541 => 'Advisory' },
	'ae_iso' => { 357 => 0x2, 358 => 0x4, 359 => 0x12 },
	'aeaperture' => { 357 => 0x1, 358 => 0x3, 359 => 0x11 },
	'aeaperturesteps' => { 357 => 0x8, 358 => 0xb },
	'aeaverage' => { 1 => 0x6 },
	'aebautocancel' => { 88 => 0x104 },
	'aebbracketvalue' => { 80 => 0x11 },
	'aebracketingsteps' => { 202 => 0xf, 203 => 0xf, 278 => 0x174c },
	'aebsequence' => { 88 => 0x105 },
	'aebsequenceautocancel' => { 86 => 0x9, 87 => 0x9, 89 => 0x8, 90 => 0x9, 93 => 0x9, 94 => 0x7 },
	'aebshotcount' => { 88 => 0x106 },
	'aebxv' => { 357 => 0x4, 358 => 0x6 },
	'aeerror' => { 358 => 0x8 },
	'aeexposuretime' => { 357 => 0x0, 358 => 0x2, 359 => 0x10 },
	'aelbutton' => { 188 => 0x45 },
	'aelexposureindicator' => { 188 => 0x51 },
	'aelock' => { 188 => 0x5b, 307 => '4.2', 316 => '4.2', 325 => 0x201, 385 => 0x48, 437 => 0x40, 438 => 0x40, 439 => [0x86,0x286] },
	'aelockbutton' => { 305 => '16.1', 307 => '4.1', 310 => '15.1', 311 => '16.1', 312 => '16.1', 314 => '30.1', 315 => '16.1', 316 => '4.1', 318 => '17.1', 320 => '17.1' },
	'aelockbuttonplusdials' => { 305 => '16.2', 314 => '32.1', 318 => '44.1' },
	'aelockformb-d80' => { 320 => '3.1' },
	'aelockmetermodeafterfocus' => { 88 => 0x114 },
	'aematrix' => { 1 => 0x2 },
	'aemaxaperture' => { 357 => 0x9, 358 => 0x10, 359 => 0x1c },
	'aemaxaperture2' => { 357 => 0xa, 358 => 0x11, 359 => 0x1d },
	'aemeteringmode' => { 357 => 0xc },
	'aemeteringmode2' => { 357 => '13.1' },
	'aemeteringsegments' => { 191 => 0x628, 385 => 0x209 },
	'aemicroadjustment' => { 88 => 0x110 },
	'aeminaperture' => { 357 => 0xb, 358 => 0x12, 359 => 0x1e },
	'aeminexposuretime' => { 357 => 0x5, 358 => 0x13, 359 => 0x1f },
	'aeprogrammode' => { 357 => 0x6 },
	'aeprojectlink' => { 515 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 515 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 515 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 515 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 515 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 515 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 36 => 0x21 },
	'aestable' => { 1 => 0x4 },
	'aestheticscore' => { 338 => 'aesthetic_score' },
	'aetarget' => { 1 => 0x5 },
	'aewhitebalance' => { 357 => 0xd },
	'aexv' => { 357 => 0x3, 358 => 0x5 },
	'af-assistilluminator' => { 321 => 0x19, 322 => 0x19, 323 => 0x19 },
	'af-cfocusdisplay' => { 321 => 0x234, 322 => 0x234, 323 => 0x24c },
	'af-cpriority' => { 132 => '0.2' },
	'af-cpriorityselection' => { 305 => '1.1', 306 => '1.1', 308 => '1.1', 309 => '1.1', 311 => '0.1', 312 => '0.1', 313 => '0.1', 314 => '1.1', 315 => '0.1', 318 => '1.1', 319 => '1.1', 321 => 0x3, 322 => 0x3, 323 => 0x3 },
	'af-csetting' => { 128 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 128 => '0.2' },
	'af-ctrackingsensitivity' => { 128 => '0.1' },
	'af-czoneareaswitching' => { 128 => '0.3' },
	'af-onbutton' => { 308 => '70.1', 309 => '70.1', 319 => '70.1' },
	'af-onformb-d10' => { 305 => '3.3', 314 => '3.2' },
	'af-onformb-d11' => { 315 => '2.2' },
	'af-onformb-d12' => { 318 => '50.1' },
	'af-onoutoffocusrelease' => { 321 => 0x10, 322 => 0x10, 323 => 0x10 },
	'af-spriority' => { 132 => '0.1' },
	'af-spriorityselection' => { 305 => '1.2', 306 => '1.2', 308 => '1.2', 309 => '1.2', 313 => '0.2', 314 => '1.2', 315 => '0.2', 318 => '1.2', 319 => '1.2', 321 => 0x5, 322 => 0x5, 323 => 0x5 },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 305 => '2.1', 306 => '2.1', 308 => '78.3', 309 => '78.3', 314 => '2.1', 318 => '2.1', 319 => '78.3', 321 => 0xf, 322 => 0xf, 323 => 0xf },
	'afadjustment' => { 385 => 0x72, 394 => 0x267 },
	'afandmeteringbuttons' => { 88 => 0x701 },
	'afaperture' => { 233 => 0x5, 234 => 0x5, 238 => 0x5 },
	'afareaheight' => { 197 => [0x1a,0x34,0x50], 198 => 0x48 },
	'afareaillumination' => { 188 => 0x4b, 316 => '15.3' },
	'afareainitialheight' => { 253 => 0xbeb },
	'afareainitialwidth' => { 253 => 0xbea },
	'afareainitialxposition' => { 253 => 0xbe8 },
	'afareainitialyposition' => { 253 => 0xbe9 },
	'afareamode' => { 130 => '0.3', 184 => 0x33, 188 => 0xe, 196 => 0x0, 197 => 0x5, 198 => 0x5, 245 => 0x224, 246 => 0x224, 247 => 0x210, 248 => 0x224, 249 => 0x224, 349 => 0xf, 417 => 0x1205, 430 => [0xa,0x3a], 437 => 0x11, 438 => 0x10, 439 => 0x24, 451 => 0xb043, 477 => 0x17 },
	'afareamodesetting' => { 307 => '11.1', 310 => '0.1', 316 => '16.1', 320 => '2.1', 451 => 0x201c },
	'afareapointsize' => { 130 => '0.4' },
	'afareas' => { 325 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 88 => 0x51b },
	'afareawidth' => { 197 => [0x18,0x32,0x4e], 198 => 0x46 },
	'afareaxposition' => { 197 => [0x14,0x2e,0x4a], 198 => 0x42, 417 => 0x1203 },
	'afareaxposition1' => { 417 => 0x1201 },
	'afareayposition' => { 197 => [0x16,0x30,0x4c], 198 => 0x44, 417 => 0x1204 },
	'afareayposition1' => { 417 => 0x1202 },
	'afareazonesize' => { 130 => '0.5' },
	'afassist' => { 86 => 0x5, 94 => 0x5, 188 => 0x48, 305 => '2.5', 307 => '0.2', 310 => '0.2', 311 => '1.1', 312 => '1.1', 313 => '1.3', 314 => '2.4', 315 => '1.3', 316 => '0.2', 318 => '2.4', 320 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 88 => 0x50e, 89 => 0x4, 90 => 0x5, 91 => 0x4, 92 => 0x4, 93 => 0x5 },
	'afassistlamp' => { 349 => 0x31 },
	'afbuttonpressed' => { 439 => [0x83,0x283] },
	'afconfidence' => { 1 => 0x3d },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 360 => 0x6 },
	'afduringliveview' => { 88 => 0x511 },
	'affinea' => { 508 => 'AffineA' },
	'affineb' => { 508 => 'AffineB' },
	'affinec' => { 508 => 'AffineC' },
	'affined' => { 508 => 'AffineD' },
	'affinetune' => { 199 => 0x0, 245 => 0x6b0, 246 => 0x6c0, 247 => 0x5b0, 248 => 0x5e0, 249 => 0x5f8, 325 => 0x306 },
	'affinetuneadj' => { 199 => 0x2, 271 => 0x2d1, 272 => 0x2dc, 325 => 0x307 },
	'affinetuneadjtele' => { 199 => 0x3 },
	'affinetuneindex' => { 199 => 0x1 },
	'affinex' => { 508 => 'AffineX' },
	'affiney' => { 508 => 'AffineY' },
	'afhold' => { 360 => 0x1fd },
	'afilluminator' => { 437 => 0x29, 451 => 0xb044 },
	'afimageheight' => { 197 => [0x12,0x2c,0x48], 198 => 0x40 },
	'afimagewidth' => { 197 => [0x10,0x2a,0x46], 198 => 0x3e },
	'afintegrationtime' => { 360 => 0x7 },
	'afmeasureddepth' => { 1 => 0x38 },
	'afmicroadj' => { 430 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 434 => 0x131 },
	'afmicroadjregisteredlenses' => { 434 => '305.1' },
	'afmicroadjustment' => { 88 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 434 => 0x130 },
	'afmode' => { 117 => 0x3009, 131 => 0x1022, 184 => 0x16, 427 => 0x5 },
	'afmoderestrictions' => { 306 => '50.3', 308 => '48.3', 309 => '48.3', 318 => '48.3', 319 => '48.3' },
	'afonaelockbuttonswitch' => { 88 => 0x702 },
	'afonbutton' => { 305 => '3.1', 306 => '47.1', 321 => 0x83, 322 => 0x83, 323 => 0x83 },
	'afperformance' => { 1 => 0x23 },
	'afpoint' => { 36 => 0x13, 116 => 0x18, 184 => 0x15, 196 => 0x1, 328 => 0x308, 427 => 0x1f, 430 => [0x37,0x7], 434 => 0x19, 435 => 0x18, 436 => [0x18,0x20] },
	'afpointactivationarea' => { 87 => 0x11, 93 => 0x11 },
	'afpointareaexpansion' => { 88 => 0x508 },
	'afpointatshutterrelease' => { 430 => [0x39,0x9] },
	'afpointautoselection' => { 88 => 0x50b },
	'afpointbrightness' => { 88 => 0x50d, 305 => '2.4', 306 => '46.5', 308 => '2.2', 309 => '2.2', 318 => '2.3', 319 => '2.2' },
	'afpointdetails' => { 328 => 0x31b },
	'afpointdisplayduringfocus' => { 2 => 0x10, 88 => 0x50c },
	'afpointillumination' => { 87 => 0xa, 305 => '2.3', 306 => '46.2', 308 => '47.2', 309 => '47.2', 313 => '1.2', 314 => '2.3', 315 => '1.2', 318 => '47.2', 319 => '47.2', 320 => '2.4' },
	'afpointinfocus' => { 430 => [0x38,0x8] },
	'afpointmode' => { 365 => 0x3 },
	'afpointposition' => { 117 => 0x2021, 349 => 0x4d },
	'afpointregistration' => { 86 => 0x7 },
	'afpoints' => { 187 => 0x10 },
	'afpointsel' => { 321 => 0xb, 322 => 0xb, 323 => 0xb },
	'afpointselected' => { 188 => 0xd, 325 => 0x305, 385 => 0xe, 434 => 0x15, 435 => 0x14, 436 => [0x14,0x1c], 451 => 0x201e },
	'afpointselected2' => { 365 => 0x4 },
	'afpointselection' => { 87 => 0xb, 305 => '1.3', 306 => '1.3', 314 => '1.3', 318 => '1.3', 319 => '1.3' },
	'afpointselectionmethod' => { 88 => 0x50f, 89 => 0xc, 90 => 0xd, 93 => 0xd },
	'afpointsetting' => { 437 => 0x12, 438 => 0x11 },
	'afpointsinfocus' => { 80 => 0xe, 196 => 0x2, 197 => 0x30, 360 => 0xb, 361 => 0x4, 385 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 19 => 0x38 },
	'afpointspotmetering' => { 87 => 0xd },
	'afpointsselected' => { 197 => 0x1c, 361 => '4.1', 486 => 0x4 },
	'afpointsspecial' => { 361 => '4.2' },
	'afpointsunknown1' => { 360 => 0x0 },
	'afpointsunknown2' => { 360 => 0x2 },
	'afpointsused' => { 197 => [0xa,0x8], 198 => 0xa, 430 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 360 => 0x4 },
	'afresponse' => { 240 => 0xad },
	'afresult' => { 330 => 0x1038 },
	'afsearch' => { 325 => 0x303 },
	'afsensoractive' => { 184 => 0x1 },
	'afstable' => { 1 => 0x7 },
	'afstatus' => { 417 => 0x1200 },
	'afstatus_00_b4' => { 433 => 0x0 },
	'afstatus_01_c4' => { 433 => 0x2 },
	'afstatus_02_d4' => { 433 => 0x4 },
	'afstatus_03_e4' => { 433 => 0x6 },
	'afstatus_04_f4' => { 433 => 0x8 },
	'afstatus_05_g4' => { 433 => 0xa },
	'afstatus_06_h4' => { 433 => 0xc },
	'afstatus_07_b3' => { 433 => 0xe },
	'afstatus_08_c3' => { 433 => 0x10 },
	'afstatus_09_d3' => { 433 => 0x12 },
	'afstatus_10_e3' => { 433 => 0x14 },
	'afstatus_11_f3' => { 433 => 0x16 },
	'afstatus_12_g3' => { 433 => 0x18 },
	'afstatus_13_h3' => { 433 => 0x1a },
	'afstatus_14_b2' => { 433 => 0x1c },
	'afstatus_15_c2' => { 433 => 0x1e },
	'afstatus_16_d2' => { 433 => 0x20 },
	'afstatus_17_e2' => { 433 => 0x22 },
	'afstatus_18_f2' => { 433 => 0x24 },
	'afstatus_19_g2' => { 433 => 0x26 },
	'afstatus_20_h2' => { 433 => 0x28 },
	'afstatus_21_c1' => { 433 => 0x2a },
	'afstatus_22_d1' => { 433 => 0x2c },
	'afstatus_23_e1' => { 433 => 0x2e },
	'afstatus_24_f1' => { 433 => 0x30 },
	'afstatus_25_g1' => { 433 => 0x32 },
	'afstatus_26_a7_vertical' => { 433 => 0x34 },
	'afstatus_27_a6_vertical' => { 433 => 0x36 },
	'afstatus_28_a5_vertical' => { 433 => 0x38 },
	'afstatus_29_c7_vertical' => { 433 => 0x3a },
	'afstatus_30_c6_vertical' => { 433 => 0x3c },
	'afstatus_31_c5_vertical' => { 433 => 0x3e },
	'afstatus_32_e7_vertical' => { 433 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 433 => 0x42 },
	'afstatus_34_e5_vertical' => { 433 => 0x44 },
	'afstatus_35_g7_vertical' => { 433 => 0x46 },
	'afstatus_36_g6_vertical' => { 433 => 0x48 },
	'afstatus_37_g5_vertical' => { 433 => 0x4a },
	'afstatus_38_i7_vertical' => { 433 => 0x4c },
	'afstatus_39_i6_vertical' => { 433 => 0x4e },
	'afstatus_40_i5_vertical' => { 433 => 0x50 },
	'afstatus_41_a7' => { 433 => 0x52 },
	'afstatus_42_b7' => { 433 => 0x54 },
	'afstatus_43_c7' => { 433 => 0x56 },
	'afstatus_44_d7' => { 433 => 0x58 },
	'afstatus_45_e7' => { 433 => 0x5a },
	'afstatus_46_f7' => { 433 => 0x5c },
	'afstatus_47_g7' => { 433 => 0x5e },
	'afstatus_48_h7' => { 433 => 0x60 },
	'afstatus_49_i7' => { 433 => 0x62 },
	'afstatus_50_a6' => { 433 => 0x64 },
	'afstatus_51_b6' => { 433 => 0x66 },
	'afstatus_52_c6' => { 433 => 0x68 },
	'afstatus_53_d6' => { 433 => 0x6a },
	'afstatus_54_e6_center' => { 433 => 0x6c },
	'afstatus_55_f6' => { 433 => 0x6e },
	'afstatus_56_g6' => { 433 => 0x70 },
	'afstatus_57_h6' => { 433 => 0x72 },
	'afstatus_58_i6' => { 433 => 0x74 },
	'afstatus_59_a5' => { 433 => 0x76 },
	'afstatus_60_b5' => { 433 => 0x78 },
	'afstatus_61_c5' => { 433 => 0x7a },
	'afstatus_62_d5' => { 433 => 0x7c },
	'afstatus_63_e5' => { 433 => 0x7e },
	'afstatus_64_f5' => { 433 => 0x80 },
	'afstatus_65_g5' => { 433 => 0x82 },
	'afstatus_66_h5' => { 433 => 0x84 },
	'afstatus_67_i5' => { 433 => 0x86 },
	'afstatus_68_c11' => { 433 => 0x88 },
	'afstatus_69_d11' => { 433 => 0x8a },
	'afstatus_70_e11' => { 433 => 0x8c },
	'afstatus_71_f11' => { 433 => 0x8e },
	'afstatus_72_g11' => { 433 => 0x90 },
	'afstatus_73_b10' => { 433 => 0x92 },
	'afstatus_74_c10' => { 433 => 0x94 },
	'afstatus_75_d10' => { 433 => 0x96 },
	'afstatus_76_e10' => { 433 => 0x98 },
	'afstatus_77_f10' => { 433 => 0x9a },
	'afstatus_78_g10' => { 433 => 0x9c },
	'afstatus_79_h10' => { 433 => 0x9e },
	'afstatus_80_b9' => { 433 => 0xa0 },
	'afstatus_81_c9' => { 433 => 0xa2 },
	'afstatus_82_d9' => { 433 => 0xa4 },
	'afstatus_83_e9' => { 433 => 0xa6 },
	'afstatus_84_f9' => { 433 => 0xa8 },
	'afstatus_85_g9' => { 433 => 0xaa },
	'afstatus_86_h9' => { 433 => 0xac },
	'afstatus_87_b8' => { 433 => 0xae },
	'afstatus_88_c8' => { 433 => 0xb0 },
	'afstatus_89_d8' => { 433 => 0xb2 },
	'afstatus_90_e8' => { 433 => 0xb4 },
	'afstatus_91_f8' => { 433 => 0xb6 },
	'afstatus_92_g8' => { 433 => 0xb8 },
	'afstatus_93_h8' => { 433 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 433 => 0xbc },
	'afstatusactivesensor' => { 184 => 0x2, 430 => [0x4,0x3b], 434 => 0x1e, 435 => 0x1b, 436 => [0x1b,0x21] },
	'afstatusbottom' => { 184 => 0x8, 434 => 0x2a, 435 => 0x21, 436 => 0x21 },
	'afstatusbottom-left' => { 184 => 0x12, 435 => 0x2b, 436 => 0x2b },
	'afstatusbottom-right' => { 184 => 0x6, 435 => 0x1f, 436 => 0x1f },
	'afstatusbottomassist-left' => { 434 => 0x28 },
	'afstatusbottomassist-right' => { 434 => 0x2c },
	'afstatusbottomhorizontal' => { 431 => 0x10, 432 => 0x1c },
	'afstatusbottomvertical' => { 431 => 0x16, 432 => 0x26 },
	'afstatuscenter-10' => { 434 => 0x34 },
	'afstatuscenter-11' => { 434 => 0x36 },
	'afstatuscenter-12' => { 434 => 0x38 },
	'afstatuscenter-14' => { 434 => 0x3c },
	'afstatuscenter-7' => { 434 => 0x2e },
	'afstatuscenter-9' => { 434 => 0x32 },
	'afstatuscenter-horizontal' => { 434 => 0x30 },
	'afstatuscenter-vertical' => { 434 => 0x3a },
	'afstatuscenterf2-8' => { 434 => 0x4c },
	'afstatuscenterhorizontal' => { 184 => 0x2f, 431 => 0xc, 432 => 0x18, 435 => 0x2f, 436 => 0x2f },
	'afstatuscentervertical' => { 184 => 0xc, 431 => 0x14, 432 => 0x22, 435 => 0x25, 436 => 0x25 },
	'afstatusfarleft' => { 431 => 0x6, 434 => 0x26 },
	'afstatusfarlefthorizontal' => { 432 => 0x4 },
	'afstatusfarleftvertical' => { 432 => 0x12 },
	'afstatusfarright' => { 431 => 0x18, 434 => 0x44 },
	'afstatusfarrighthorizontal' => { 432 => 0x2c },
	'afstatusfarrightvertical' => { 432 => 0x34 },
	'afstatusleft' => { 184 => 0x2d, 431 => 0x2, 434 => 0x22, 435 => 0x2d, 436 => 0x2d },
	'afstatuslefthorizontal' => { 432 => 0x6 },
	'afstatusleftvertical' => { 432 => 0xe },
	'afstatuslower-left' => { 431 => 0x4, 434 => 0x24 },
	'afstatuslower-lefthorizontal' => { 432 => 0xa },
	'afstatuslower-leftvertical' => { 432 => 0x10 },
	'afstatuslower-middle' => { 431 => 0x22, 432 => 0x24 },
	'afstatuslower-right' => { 431 => 0x1e, 434 => 0x4a },
	'afstatuslower-righthorizontal' => { 432 => 0x32 },
	'afstatuslower-rightvertical' => { 432 => 0x3a },
	'afstatuslowerfarleft' => { 432 => 0x8 },
	'afstatuslowerfarright' => { 432 => 0x30 },
	'afstatusmiddlehorizontal' => { 184 => 0xa, 435 => 0x23, 436 => 0x23 },
	'afstatusnearleft' => { 431 => 0xe, 432 => 0x1a },
	'afstatusnearright' => { 431 => 0xa, 432 => 0x16 },
	'afstatusright' => { 184 => 0x31, 431 => 0x1c, 434 => 0x48, 435 => 0x31, 436 => 0x31 },
	'afstatusrighthorizontal' => { 432 => 0x2e },
	'afstatusrightvertical' => { 432 => 0x38 },
	'afstatustop' => { 184 => 0xe, 434 => 0x40, 435 => 0x27, 436 => 0x27 },
	'afstatustop-left' => { 184 => 0x10, 435 => 0x29, 436 => 0x29 },
	'afstatustop-right' => { 184 => 0x4, 435 => 0x1d, 436 => 0x1d },
	'afstatustopassist-left' => { 434 => 0x3e },
	'afstatustopassist-right' => { 434 => 0x42 },
	'afstatustophorizontal' => { 431 => 0x8, 432 => 0x14 },
	'afstatustopvertical' => { 431 => 0x12, 432 => 0x1e },
	'afstatusupper-left' => { 431 => 0x0, 434 => 0x20 },
	'afstatusupper-lefthorizontal' => { 432 => 0x2 },
	'afstatusupper-leftvertical' => { 432 => 0xc },
	'afstatusupper-middle' => { 431 => 0x20, 432 => 0x20 },
	'afstatusupper-right' => { 431 => 0x1a, 434 => 0x46 },
	'afstatusupper-righthorizontal' => { 432 => 0x2a },
	'afstatusupper-rightvertical' => { 432 => 0x36 },
	'afstatusupperfarleft' => { 432 => 0x0 },
	'afstatusupperfarright' => { 432 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftracking' => { 451 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 430 => 0x2 },
	'afwithshutter' => { 437 => 0x2a },
	'aggregateissuenumber' => { 533 => 'aggregateIssueNumber' },
	'aggregationtype' => { 533 => 'aggregationType' },
	'agreement' => { 536 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 142 => 0xe4e },
	'airplanemode' => { 245 => 0x722, 246 => 0x732, 247 => 0x624, 248 => 0x654, 249 => 0x6bc },
	'aiservocontinuousshooting' => { 87 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 88 => 0x519 },
	'aiservoimagepriority' => { 88 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 88 => 0x51a },
	'aiservotrackingmethod' => { 88 => 0x504 },
	'aiservotrackingsensitivity' => { 87 => 0x14, 88 => 0x502 },
	'aisubjecttrackingmode' => { 325 => 0x309 },
	'album' => { 402 => ['albm',"\xa9alb"], 404 => 'album', 410 => ['albm',"\xa9alb"], 543 => 'album' },
	'albumartist' => { 183 => 'WM/AlbumArtist', 402 => 'aART', 410 => 'albr' },
	'albumcoverurl' => { 183 => 'WM/AlbumCoverURL' },
	'albumid' => { 402 => 'plID' },
	'albumtitle' => { 183 => 'WM/AlbumTitle' },
	'alreadyapplied' => { 514 => 'AlreadyApplied', 516 => 'AlreadyApplied' },
	'alternatetitle' => { 533 => 'alternateTitle' },
	'alternatetitlea-lang' => { 533 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 533 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 533 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 201 => 0x6 },
	'alttapename' => { 543 => 'altTapeName' },
	'alttextaccessibility' => { 527 => 'AltTextAccessibility' },
	'alttimecode' => { 543 => 'altTimecode' },
	'alttimecodetimeformat' => { 543 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 543 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 543 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambientinfrared' => { 413 => 0x5c },
	'ambientlight' => { 413 => 0x5e },
	'ambienttemperature' => { 123 => 0x9400, 411 => 0x14, 412 => 0x46, 413 => 0x50, 477 => 0x4, 521 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 411 => 0x13, 412 => 0x44, 413 => 0x4e },
	'analogbalance' => { 123 => 0xc627 },
	'analogcaptureiso' => { 142 => 0x89e },
	'analogisotable' => { 142 => 0x89d },
	'androidcapturefps' => { 404 => 'com.android.capture.fps' },
	'androidversion' => { 404 => 'com.android.version' },
	'angleadj' => { 107 => 0x10003, 113 => 0x8b },
	'angleinforoll' => { 510 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 510 => 'AngleInfoYaw' },
	'anti-blur' => { 451 => 0xb04b },
	'antialiasstrength' => { 123 => 0xc632 },
	'antiflicker' => { 59 => 0x20 },
	'aperturelock' => { 306 => '38.2', 308 => '38.2', 309 => '38.2', 318 => '38.2', 319 => '38.2', 321 => 0xb8, 322 => 0xb8, 323 => 0xb8 },
	'aperturemode' => { 410 => 'apmd' },
	'aperturerange' => { 88 => 0x10d },
	'apertureringuse' => { 365 => '1.4' },
	'aperturesetting' => { 188 => 0x7, 437 => 0x30, 438 => 0x29, 439 => 0x1 },
	'aperturevalue' => { 97 => 0x2, 123 => 0x9202, 330 => 0x1002, 394 => 0x401, 520 => 'ApertureValue' },
	'appinfo' => { 492 => 'AppInfo' },
	'appinfoapplication' => { 492 => [\'AppInfo','AppInfoApplication'] },
	'appinfoitemuri' => { 492 => [\'AppInfo','AppInfoItemURI'] },
	'appinfoversion' => { 492 => [\'AppInfo','AppInfoVersion'] },
	'apple_0x004e' => { 1 => 0x4e },
	'apple_0x004f' => { 1 => 0x4f },
	'applekeywords' => { 334 => 'AAPL:Keywords' },
	'applephotosvariationidentifier' => { 404 => 'apple.photos.variation-identifier' },
	'applestoreaccount' => { 402 => 'apID' },
	'applestoreaccounttype' => { 402 => 'akID' },
	'applestorecatalogid' => { 402 => 'cnID' },
	'applestorecountry' => { 402 => 'sfID' },
	'applicationkeystring' => { 142 => 0x400 },
	'applicationnotes' => { 123 => 0x2bc, 354 => 0x2bc },
	'applicationrecordversion' => { 135 => 0x0 },
	'applyautomatically' => { 339 => 'ApplyAutomatically' },
	'applyshootingmeteringmode' => { 88 => 0x10e },
	'approved' => { 522 => 'Approved' },
	'approvedby' => { 522 => 'ApprovedBy' },
	'approximatefnumber' => { 344 => 0x313, 351 => 0x3406 },
	'approximatefocusdistance' => { 511 => 'ApproximateFocusDistance' },
	'appversion' => { 526 => 'AppVersion' },
	'aps-csizecapture' => { 470 => 0x114, 471 => [0x114,0x1eb,0x1ee,0x21a,0x21c] },
	'aquahsl' => { 107 => 0x20914 },
	'armidentifier' => { 136 => 0x78 },
	'armversion' => { 136 => 0x7a },
	'arranger' => { 402 => "\xa9arg", 410 => "\xa9arg" },
	'arrangerkeywords' => { 410 => "\xa9ark" },
	'artdirector' => { 402 => "\xa9ard" },
	'artfilter' => { 325 => 0x529 },
	'artfiltereffect' => { 325 => 0x52f },
	'artist' => { 123 => 0x13b, 338 => 'Artist', 354 => 0x13b, 385 => 0x22e, 402 => "\xa9ART", 404 => 'artist', 410 => "\xa9ART", 539 => 'Artist', 543 => 'artist' },
	'artistid' => { 402 => 'atID' },
	'artmode' => { 117 => 0x301b },
	'artmodeparameters' => { 117 => 0x310b },
	'artwork' => { 404 => 'artwork' },
	'artworkcircadatecreated' => { 528 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 528 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 528 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 528 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 528 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 528 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 528 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 528 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 528 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 528 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 528 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 528 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 528 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 528 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 528 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 528 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 528 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 528 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 329 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 329 => 0x1112, 385 => 0x80, 437 => 0x55, 438 => 0x55, 439 => 0xa, 464 => [0x192c,0x1a88], 465 => 0x192c, 466 => 0x1958, 467 => 0x192c, 468 => 0x188c },
	'assetid' => { 504 => 'AssetID' },
	'asshoticcprofile' => { 123 => 0xc68f },
	'asshotneutral' => { 123 => 0xc628 },
	'asshotpreprofilematrix' => { 123 => 0xc690 },
	'asshotprofilename' => { 123 => 0xc6f6 },
	'asshotwhitexy' => { 123 => 0xc629 },
	'assignbktbutton' => { 305 => '4.2', 306 => '16.1', 308 => '16.1', 309 => '16.1', 318 => '16.1', 319 => '16.1' },
	'assignfuncbutton' => { 88 => 0x70b },
	'assignmb-d17af-onbutton' => { 309 => '79.1' },
	'assignmb-d17funcbutton' => { 309 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 309 => '68.1' },
	'assignmb-d18af-onbutton' => { 319 => '79.1' },
	'assignmb-d18funcbutton' => { 319 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 319 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 308 => '75.1', 309 => '75.1', 319 => '75.1' },
	'assignmoviefunc2button' => { 308 => '82.1', 309 => '82.1', 319 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 308 => '75.2', 309 => '75.2', 319 => '75.2' },
	'assignmovierecordbutton' => { 306 => '43.2', 318 => '45.1', 321 => 0x9b, 322 => 0x9b, 323 => 0x9b },
	'assignmovierecordbuttonplusdials' => { 308 => '45.1', 309 => '45.1', 319 => '45.1' },
	'assignmoviesubselector' => { 308 => '74.1', 309 => '74.1', 319 => '74.1' },
	'assignmoviesubselectorplusdials' => { 308 => '76.1', 309 => '76.1', 319 => '76.1' },
	'assignremotefnbutton' => { 306 => '54.1', 318 => '51.1' },
	'assistbuttonfunction' => { 86 => 0xd },
	'atcaptureusercrop' => { 142 => 0x943 },
	'attributionname' => { 512 => 'attributionName' },
	'attributionurl' => { 512 => 'attributionURL' },
	'audio' => { 349 => 0x20 },
	'audiobitrate' => { 70 => 0x6c, 528 => 'audioBitRate' },
	'audiobitratemode' => { 528 => 'audioBitRateMode' },
	'audiobitspersample' => { 528 => 'audioBitsPerSample' },
	'audiobutton' => { 322 => 0x17b, 323 => 0x193 },
	'audiobuttonplaybackmode' => { 322 => 0x1b9, 323 => 0x1d1 },
	'audiochannelcount' => { 528 => 'audioChannelCount' },
	'audiochannels' => { 70 => 0x70 },
	'audiochanneltype' => { 543 => 'audioChannelType' },
	'audiocompression' => { 88 => 0x816, 159 => 'Compression' },
	'audiocompressor' => { 543 => 'audioCompressor' },
	'audiodata' => { 495 => 'Data' },
	'audioduration' => { 135 => 0x99 },
	'audiogain' => { 404 => 'player.movie.audio.gain' },
	'audiomimetype' => { 495 => 'Mime' },
	'audiomoddate' => { 543 => 'audioModDate' },
	'audiooutcue' => { 135 => 0x9a },
	'audiosamplerate' => { 70 => 0x6e, 543 => 'audioSampleRate' },
	'audiosampletype' => { 543 => 'audioSampleType' },
	'audiosamplingrate' => { 135 => 0x97 },
	'audiosamplingresolution' => { 135 => 0x98 },
	'audiotype' => { 135 => 0x96 },
	'author' => { 161 => 'Author', 334 => 'Author', 338 => 'Author', 401 => 'Author', 402 => ['auth',"\xa9aut"], 404 => 'author', 410 => 'auth', 509 => 'author', 530 => 'Author', 541 => 'Author' },
	'authorsposition' => { 531 => 'AuthorsPosition' },
	'authorurl' => { 183 => 'WM/AuthorURL' },
	'autoafpointcolortracking' => { 88 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 375 => '0.1' },
	'autobracket' => { 427 => 0x19 },
	'autobracketing' => { 131 => 0x1100, 385 => 0x18, 417 => 0x1007 },
	'autobracketingmode' => { 317 => '12.3' },
	'autobracketingset' => { 317 => '12.1' },
	'autobracketmodem' => { 305 => '21.2', 306 => '13.3', 308 => '13.2', 309 => '13.2', 314 => '26.2', 318 => '13.3', 319 => '13.2', 321 => 0x5f, 322 => 0x5f, 323 => 0x5f },
	'autobracketorder' => { 188 => 0x43, 305 => '21.3', 306 => '13.2', 308 => '13.1', 309 => '13.1', 314 => '26.3', 315 => '12.2', 316 => '2.2', 317 => '12.2', 318 => '13.2', 319 => '13.1', 320 => '13.2', 321 => 0x61, 322 => 0x61, 323 => 0x61 },
	'autobracketset' => { 305 => '21.1', 306 => '13.1', 310 => '11.1', 311 => '12.1', 312 => '12.1', 314 => '26.1', 315 => '12.1', 316 => '2.1', 318 => '13.1', 320 => '13.1' },
	'autobrightness' => { 514 => 'AutoBrightness', 516 => 'AutoBrightness' },
	'autocapturecriteria' => { 200 => 0x1 },
	'autocapturecriteriamotiondirection' => { 200 => 0x5f },
	'autocapturecriteriamotionsize' => { 200 => 0x64 },
	'autocapturecriteriamotionspeed' => { 200 => 0x63 },
	'autocapturecriteriasubjectsize' => { 200 => 0x69 },
	'autocapturecriteriasubjecttype' => { 200 => 0x6a },
	'autocapturedframe' => { 200 => 0x0 },
	'autocapturedistancefar' => { 200 => 0x4a },
	'autocapturedistancenear' => { 200 => 0x4e },
	'autocapturepreset' => { 249 => 0x746 },
	'autocapturerecordingtime' => { 200 => 0x37 },
	'autocapturewaittime' => { 200 => 0x38 },
	'autocontrast' => { 514 => 'AutoContrast', 516 => 'AutoContrast' },
	'autodistortioncontrol' => { 214 => 0x4, 244 => 0x143 },
	'autodynamicrange' => { 131 => 0x140b },
	'autoexposure' => { 514 => 'AutoExposure', 516 => 'AutoExposure' },
	'autoexposurebracketing' => { 80 => 0x10 },
	'autoflashisosensitivity' => { 308 => '38.5', 309 => '38.5', 319 => '38.5', 321 => 0x5b, 322 => 0x5b, 323 => 0x5b },
	'autofocus' => { 328 => 0x209 },
	'autofocusmoderestrictions' => { 321 => 0x107, 322 => 0x107, 323 => 0x11d },
	'autofp' => { 316 => '7.3', 320 => '31.4' },
	'autoiso' => { 80 => 0x1, 117 => 0x3008, 245 => 0x152, 246 => 0x152, 247 => 0x142, 248 => 0x156, 249 => 0x156, 307 => '1.1', 316 => '1.1' },
	'autoisomax' => { 307 => '1.2', 316 => '1.2' },
	'autoisominshutterspeed' => { 307 => '1.3', 316 => '1.3' },
	'autolateralca' => { 514 => 'AutoLateralCA', 516 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 16 => 0xbe, 17 => 0xbf, 20 => 0xbf, 65 => 0x2, 88 => 0x204, 107 => 0x20500, 113 => 0x6f },
	'autolightingoptimizeron' => { 107 => '0x20500.0', 113 => 0x6e },
	'autoportraitframed' => { 451 => 0x2016 },
	'autoredeye' => { 298 => 0xfe28a44f },
	'autorotate' => { 80 => 0x1b },
	'autoshadows' => { 514 => 'AutoShadows', 516 => 'AutoShadows' },
	'autotone' => { 514 => 'AutoTone', 516 => 'AutoTone' },
	'autotonedigest' => { 514 => 'AutoToneDigest', 516 => 'AutoToneDigest' },
	'autotonedigestnosat' => { 514 => 'AutoToneDigestNoSat', 516 => 'AutoToneDigestNoSat' },
	'autowhiteversion' => { 514 => 'AutoWhiteVersion', 516 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 240 => 0x82 },
	'avaperturesetting' => { 365 => 0x13 },
	'averageblacklevel' => { 47 => 0xe7, 49 => 0xfb, 50 => 0x114, 51 => 0x146 },
	'averagelv' => { 191 => 0x38 },
	'avsettingwithoutlens' => { 88 => 0x707 },
	'azimuth' => { 169 => 'Azimuth' },
	'babyage' => { 349 => [0x8010,0x33] },
	'babyname' => { 349 => 0x66 },
	'backgroundalpha' => { 538 => 'bgalpha' },
	'balance' => { 404 => 'player.movie.audio.balance' },
	'baseexposurecompensation' => { 365 => 0x15 },
	'baseiso' => { 80 => 0x2, 101 => 0x101c, 142 => 0x903, 351 => 0x312a, 483 => 0x6 },
	'baseisodaylight' => { 142 => 0x910 },
	'baseisoflash' => { 142 => 0x913 },
	'baseisofluorescent' => { 142 => 0x912 },
	'baseisotungsten' => { 142 => 0x911 },
	'baselineexposure' => { 123 => 0xc62a },
	'baselineexposureoffset' => { 123 => 0xc7a5 },
	'baselinenoise' => { 123 => 0xc62b },
	'baselinesharpness' => { 123 => 0xc62c },
	'baserenditionishdr' => { 525 => 'BaseRenditionIsHDR' },
	'baseurl' => { 541 => 'BaseURL' },
	'bass' => { 404 => 'player.movie.audio.bass' },
	'batterylevel' => { 349 => 0x38, 437 => 0x51, 441 => 0xc, 442 => 0x4, 443 => 0x4, 484 => 0x7, 485 => 0x5 },
	'batterylevel2' => { 485 => 0x7 },
	'batterylevelgrip1' => { 484 => 0x6 },
	'batterylevelgrip2' => { 484 => 0x8 },
	'batteryorder' => { 305 => '12.5', 314 => '13.2', 315 => '2.1', 318 => '3.1' },
	'batterystate' => { 188 => 0x60, 437 => 0x50, 443 => 0x14 },
	'batterytemperature' => { 441 => 0x1, 443 => 0x2, 484 => 0x5 },
	'batterytype' => { 67 => 0x38, 413 => 0x66 },
	'batteryunknown' => { 441 => 0x2, 443 => 0x0 },
	'batteryvoltage' => { 142 => 0x408, 411 => 0x2a, 412 => 0x49, 413 => 0x62, 441 => 0x8 },
	'batteryvoltage1' => { 443 => 0x6 },
	'batteryvoltage2' => { 443 => 0x8 },
	'batteryvoltageavg' => { 413 => 0x64 },
	'bayergreensplit' => { 123 => 0xc62d },
	'bayerpattern' => { 141 => 0xf902, 192 => 0x17 },
	'beatsperminute' => { 402 => 'tmpo' },
	'beatspliceparams' => { 543 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 543 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 543 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 543 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 543 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 543 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 305 => '13.1', 306 => '5.4', 307 => '0.1', 310 => '2.1', 311 => '3.1', 312 => '3.1', 314 => '10.1', 316 => '0.1', 318 => '5.5', 320 => '4.1' },
	'beeppitch' => { 315 => '3.1' },
	'beepvolume' => { 315 => '4.5' },
	'bestqualityscale' => { 123 => 0xc65c },
	'bestshotmode' => { 117 => 0x3007 },
	'bitdepth' => { 166 => 'BitDepth', 192 => 0x11, 264 => 0x41 },
	'bitspercomponent' => { 137 => 0x87 },
	'bitspersample' => { 123 => 0x102, 354 => 0xa, 539 => 'BitsPerSample' },
	'blackacquirerows' => { 142 => 0x18ba },
	'blacklevel' => { 123 => [0x7310,0xc61a], 211 => 0x20, 240 => 0x3d, 330 => [0x401,0x1012], 394 => 0x21d, 458 => [0x7300,0x7310] },
	'blacklevel2' => { 329 => 0x600, 333 => 0x600 },
	'blacklevelblue' => { 354 => 0x1e },
	'blacklevelbottom' => { 142 => 0x3f0 },
	'blackleveldata' => { 394 => 0x223 },
	'blackleveldeltah' => { 123 => 0xc61b },
	'blackleveldeltav' => { 123 => 0xc61c },
	'blacklevelgreen' => { 354 => 0x1d },
	'blacklevelred' => { 354 => 0x1c },
	'blacklevelrepeatdim' => { 123 => 0xc619 },
	'blacklevelrough' => { 142 => 0x40e },
	'blacklevelroughafter' => { 142 => 0x416 },
	'blacklevels' => { 37 => 0x1d },
	'blackleveltop' => { 142 => 0x3ef },
	'blackpoint' => { 385 => 0x200 },
	'blacks2012' => { 514 => 'Blacks2012', 516 => 'Blacks2012' },
	'blacksadj' => { 488 => 0x9018 },
	'bleachbypasstoning' => { 385 => 0x7f },
	'blockshotafresponse' => { 308 => '1.5', 309 => '1.5', 319 => '1.5', 321 => 0x7, 322 => 0x7, 323 => 0x7 },
	'blogtitle' => { 533 => 'blogTitle' },
	'blogurl' => { 533 => 'blogURL' },
	'bluebalance' => { 330 => 0x1018, 354 => 0x12, 385 => 0x1b },
	'bluecurvelimits' => { 112 => 0x1fe },
	'bluecurvepoints' => { 111 => 0x79, 112 => 0x1d4 },
	'bluehsl' => { 107 => 0x20915 },
	'bluehue' => { 514 => 'BlueHue', 516 => 'BlueHue' },
	'bluesaturation' => { 514 => 'BlueSaturation', 516 => 'BlueSaturation' },
	'bluratinfinity' => { 500 => 'BlurAtInfinity' },
	'blurcontrol' => { 385 => 0x82 },
	'blurwarning' => { 131 => 0x1300 },
	'bodybatteryadload' => { 363 => 0x3 },
	'bodybatteryadnoload' => { 363 => 0x2 },
	'bodybatterypercent' => { 363 => 0x3 },
	'bodybatterystate' => { 363 => ['1.1',0x2] },
	'bodybatteryvoltage' => { 363 => 0x4 },
	'bodybatteryvoltage1' => { 363 => 0x2 },
	'bodybatteryvoltage2' => { 363 => 0x4 },
	'bodybatteryvoltage3' => { 363 => 0x6 },
	'bodybatteryvoltage4' => { 363 => 0x8 },
	'bodyfirmware' => { 418 => 0x0 },
	'bodyfirmwareversion' => { 326 => 0x104, 327 => 0x100, 330 => 0x104 },
	'bodyserialnumber' => { 418 => 0x10 },
	'bookedition' => { 533 => 'bookEdition' },
	'bootloaderversion' => { 412 => 0x26 },
	'bracketbutton' => { 246 => 0x808, 249 => 0x80c },
	'bracketbuttonplaybackmode' => { 246 => 0x810, 249 => 0x816 },
	'bracketincrement' => { 245 => 0x22e, 246 => 0x22e, 247 => 0x21a, 248 => 0x22e, 249 => 0x22e },
	'bracketmode' => { 59 => 0x3 },
	'bracketprogram' => { 245 => 0x22c, 246 => 0x22c, 247 => 0x218, 248 => 0x22c, 249 => 0x22c },
	'bracketsequence' => { 117 => 0x301d },
	'bracketset' => { 245 => 0x22a, 246 => 0x22a, 247 => 0x216, 248 => 0x22a, 249 => 0x22a },
	'bracketsettings' => { 349 => 0x45 },
	'bracketshotnumber' => { 59 => 0x5, 365 => 0x9, 448 => 0x2b },
	'bracketshotnumber2' => { 448 => 0x2d },
	'bracketstep' => { 185 => 0xe },
	'bracketvalue' => { 59 => 0x4 },
	'brightness' => { 123 => 0xfe53, 160 => 'Brightness', 180 => 'Brightness', 185 => 0x2c, 256 => 0x34, 257 => 0x39, 258 => 0x41, 404 => 'player.movie.visual.brightness', 411 => 0x25, 413 => 0x54, 437 => 0x22, 451 => 0x2007, 514 => 'Brightness', 516 => 'Brightness' },
	'brightnessadj' => { 112 => 0x114, 291 => 0x0, 301 => 0x2d, 488 => 0x8018 },
	'brightnessvalue' => { 123 => 0x9203, 191 => [0x691,0x49c3], 330 => 0x1003, 456 => 0x1e, 460 => 0x1140, 461 => 0x1140, 462 => 0x111c, 463 => 0x1198, 464 => 0x1174, 465 => 0x102c, 466 => 0x224, 467 => 0x224, 468 => 0x219, 520 => 'BrightnessValue' },
	'buildnumber' => { 195 => 0x5500 },
	'bulbduration' => { 80 => 0x18 },
	'burstcount' => { 142 => 0x40d },
	'burstgroupid' => { 242 => 0x4 },
	'burstid' => { 496 => 'BurstID' },
	'burstmode' => { 144 => 0xa, 349 => 0x2a },
	'burstmode2' => { 144 => 0x18 },
	'burstprimary' => { 496 => 'BurstPrimary' },
	'burstshot' => { 427 => 0x34 },
	'burstspeed' => { 349 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 88 => 0x70a },
	'bwadjustment' => { 131 => 0x1049 },
	'bwfilter' => { 185 => 0x2a, 193 => 0x39 },
	'bwmagentagreen' => { 131 => 0x104b },
	'bwmode' => { 330 => 0x203 },
	'by-line' => { 135 => 0x50 },
	'by-linetitle' => { 135 => 0x55 },
	'bytecount' => { 533 => 'byteCount' },
	'c14configuration' => { 142 => 0x1964 },
	'cacheversion' => { 123 => 0xc7aa },
	'calibratedfocallength' => { 120 => 'CalibratedFocalLength' },
	'calibratedopticalcenterx' => { 120 => 'CalibratedOpticalCenterX' },
	'calibratedopticalcentery' => { 120 => 'CalibratedOpticalCenterY' },
	'calibration' => { 427 => [0x24,0x30] },
	'calibrationhistory' => { 142 => 0x9c9 },
	'calibrationilluminant1' => { 123 => 0xc65a },
	'calibrationilluminant2' => { 123 => 0xc65b },
	'calibrationilluminant3' => { 123 => 0xcd31 },
	'calibrationversion' => { 142 => 0x9c6 },
	'callforimage' => { 504 => 'CallForImage' },
	'camera' => { 492 => [\'Cameras','CamerasCamera'] },
	'cameraangle' => { 410 => 'angl', 543 => 'cameraAngle' },
	'cameraappinfo' => { 492 => [\'Cameras','CamerasCameraAppInfo'] },
	'cameraappinfoapplication' => { 492 => [\'Cameras','CamerasCameraAppInfoApplication'] },
	'cameraappinfoitemuri' => { 492 => [\'Cameras','CamerasCameraAppInfoItemURI'] },
	'cameraappinfoversion' => { 492 => [\'Cameras','CamerasCameraAppInfoVersion'] },
	'cameraburstid' => { 498 => 'CameraBurstID' },
	'cameracalibration' => { 427 => 0x11f },
	'cameracalibration1' => { 123 => 0xc623 },
	'cameracalibration2' => { 123 => 0xc624 },
	'cameracalibration3' => { 123 => 0xcd32 },
	'cameracalibrationsig' => { 123 => 0xc6f3 },
	'cameracolorcalibration01' => { 38 => 0x0, 39 => 0x0 },
	'cameracolorcalibration02' => { 38 => 0x4, 39 => 0x5 },
	'cameracolorcalibration03' => { 38 => 0x8, 39 => 0xa },
	'cameracolorcalibration04' => { 38 => 0xc, 39 => 0xf },
	'cameracolorcalibration05' => { 38 => 0x10, 39 => 0x14 },
	'cameracolorcalibration06' => { 38 => 0x14, 39 => 0x19 },
	'cameracolorcalibration07' => { 38 => 0x18, 39 => 0x1e },
	'cameracolorcalibration08' => { 38 => 0x1c, 39 => 0x23 },
	'cameracolorcalibration09' => { 38 => 0x20, 39 => 0x28 },
	'cameracolorcalibration10' => { 38 => 0x24, 39 => 0x2d },
	'cameracolorcalibration11' => { 38 => 0x28, 39 => 0x32 },
	'cameracolorcalibration12' => { 38 => 0x2c, 39 => 0x37 },
	'cameracolorcalibration13' => { 38 => 0x30, 39 => 0x3c },
	'cameracolorcalibration14' => { 38 => 0x34, 39 => 0x41 },
	'cameracolorcalibration15' => { 38 => 0x38, 39 => 0x46 },
	'cameradepthmap' => { 492 => [\'Cameras','CamerasCameraDepthMap'] },
	'cameradepthmapconfidenceuri' => { 492 => [\'Cameras','CamerasCameraDepthMapConfidenceURI'] },
	'cameradepthmapdepthuri' => { 492 => [\'Cameras','CamerasCameraDepthMapDepthURI'] },
	'cameradepthmapfar' => { 492 => [\'Cameras','CamerasCameraDepthMapFar'] },
	'cameradepthmapfocaltable' => { 492 => [\'Cameras','CamerasCameraDepthMapFocalTable'] },
	'cameradepthmapfocaltableentrycount' => { 492 => [\'Cameras','CamerasCameraDepthMapFocalTableEntryCount'] },
	'cameradepthmapformat' => { 492 => [\'Cameras','CamerasCameraDepthMapFormat'] },
	'cameradepthmapitemsemantic' => { 492 => [\'Cameras','CamerasCameraDepthMapItemSemantic'] },
	'cameradepthmapmeasuretype' => { 492 => [\'Cameras','CamerasCameraDepthMapMeasureType'] },
	'cameradepthmapnear' => { 492 => [\'Cameras','CamerasCameraDepthMapNear'] },
	'cameradepthmapsoftware' => { 492 => [\'Cameras','CamerasCameraDepthMapSoftware'] },
	'cameradepthmapunits' => { 492 => [\'Cameras','CamerasCameraDepthMapUnits'] },
	'cameradirection' => { 404 => 'direction.facing' },
	'camerae-mountversion' => { 487 => 0xb },
	'cameraelevationangle' => { 123 => 0x9405, 521 => 'CameraElevationAngle' },
	'camerafilename' => { 504 => 'CameraFilename' },
	'camerafirmware' => { 123 => 0xa439 },
	'cameraid' => { 330 => 0x209, 410 => 'cmid', 426 => 0x209 },
	'cameraidentifier' => { 404 => 'camera.identifier' },
	'cameraimage' => { 492 => [\'Cameras','CamerasCameraImage'] },
	'cameraimageitemsemantic' => { 492 => [\'Cameras','CamerasCameraImageItemSemantic'] },
	'cameraimageitemuri' => { 492 => [\'Cameras','CamerasCameraImageItemURI'] },
	'cameraimagingmodel' => { 492 => [\'Cameras','CamerasCameraImagingModel'] },
	'cameraimagingmodeldistortion' => { 492 => [\'Cameras','CamerasCameraImagingModelDistortion'] },
	'cameraimagingmodeldistortioncount' => { 492 => [\'Cameras','CamerasCameraImagingModelDistortionCount'] },
	'cameraimagingmodelfocallengthx' => { 492 => [\'Cameras','CamerasCameraImagingModelFocalLengthX'] },
	'cameraimagingmodelfocallengthy' => { 492 => [\'Cameras','CamerasCameraImagingModelFocalLengthY'] },
	'cameraimagingmodelimageheight' => { 492 => [\'Cameras','CamerasCameraImagingModelImageHeight'] },
	'cameraimagingmodelimagewidth' => { 492 => [\'Cameras','CamerasCameraImagingModelImageWidth'] },
	'cameraimagingmodelpixelaspectratio' => { 492 => [\'Cameras','CamerasCameraImagingModelPixelAspectRatio'] },
	'cameraimagingmodelprincipalpointx' => { 492 => [\'Cameras','CamerasCameraImagingModelPrincipalPointX'] },
	'cameraimagingmodelprincipalpointy' => { 492 => [\'Cameras','CamerasCameraImagingModelPrincipalPointY'] },
	'cameraimagingmodelskew' => { 492 => [\'Cameras','CamerasCameraImagingModelSkew'] },
	'cameraiso' => { 36 => 0x10 },
	'cameralabel' => { 123 => 0xc7a1, 543 => 'cameraLabel' },
	'cameralightestimate' => { 492 => [\'Cameras','CamerasCameraLightEstimate'] },
	'cameralightestimatecolorcorrectionb' => { 492 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionB'] },
	'cameralightestimatecolorcorrectiong' => { 492 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionG'] },
	'cameralightestimatecolorcorrectionr' => { 492 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionR'] },
	'cameralightestimatepixelintensity' => { 492 => [\'Cameras','CamerasCameraLightEstimatePixelIntensity'] },
	'cameramakemodel' => { 504 => 'CameraMakeModel' },
	'cameramodel' => { 394 => 0x410, 543 => 'cameraModel' },
	'cameramodelid' => { 180 => 'CameraModelID' },
	'cameramodelrestriction' => { 514 => 'CameraModelRestriction', 516 => 'CameraModelRestriction' },
	'cameramotion' => { 404 => 'direction.motion' },
	'cameramove' => { 543 => 'cameraMove' },
	'cameraorientation' => { 7 => 0x30, 9 => 0x7d, 11 => 0x30, 13 => 0x35, 14 => 0x30, 15 => 0x30, 16 => 0x31, 17 => 0x31, 18 => 0x35, 19 => 0x27, 20 => 0x31, 21 => 0x7d, 22 => 0x38, 23 => [0x36,0x3a], 24 => 0x7d, 25 => 0x83, 26 => 0x84, 27 => 0x96, 28 => 0x35, 29 => 0x96, 349 => 0x8f, 384 => 0x1, 389 => 0x1, 394 => 0x100, 443 => [0x16,0x18], 474 => 0x28, 475 => 0x24, 476 => 0x29 },
	'cameraowner' => { 145 => 0xc353 },
	'cameraparameters' => { 330 => 0x2050 },
	'camerapicturestyle' => { 28 => 0xaf },
	'camerapitch' => { 119 => 0x9, 410 => "\xa9gpt" },
	'camerapointcloud' => { 492 => [\'Cameras','CamerasCameraPointCloud'] },
	'camerapointcloudmetric' => { 492 => [\'Cameras','CamerasCameraPointCloudMetric'] },
	'camerapointcloudpointcloud' => { 492 => [\'Cameras','CamerasCameraPointCloudPointCloud'] },
	'camerapointcloudpoints' => { 492 => [\'Cameras','CamerasCameraPointCloudPoints'] },
	'camerapose' => { 492 => [\'Cameras','CamerasCameraPose'] },
	'cameraposepositionx' => { 492 => [\'Cameras','CamerasCameraPosePositionX'] },
	'cameraposepositiony' => { 492 => [\'Cameras','CamerasCameraPosePositionY'] },
	'cameraposepositionz' => { 492 => [\'Cameras','CamerasCameraPosePositionZ'] },
	'cameraposerotationw' => { 492 => [\'Cameras','CamerasCameraPoseRotationW'] },
	'cameraposerotationx' => { 492 => [\'Cameras','CamerasCameraPoseRotationX'] },
	'cameraposerotationy' => { 492 => [\'Cameras','CamerasCameraPoseRotationY'] },
	'cameraposerotationz' => { 492 => [\'Cameras','CamerasCameraPoseRotationZ'] },
	'cameraposetimestamp' => { 492 => [\'Cameras','CamerasCameraPoseTimestamp'] },
	'cameraprofile' => { 514 => 'CameraProfile', 516 => 'CameraProfile' },
	'cameraprofiledigest' => { 514 => 'CameraProfileDigest', 516 => 'CameraProfileDigest' },
	'cameraprofiles' => { 531 => 'CameraProfiles' },
	'cameraprofilesaperturevalue' => { 531 => [\'CameraProfiles','CameraProfilesApertureValue'] },
	'cameraprofilesauthor' => { 531 => [\'CameraProfiles','CameraProfilesAuthor'] },
	'cameraprofilesautoscale' => { 531 => [\'CameraProfiles','CameraProfilesAutoScale'] },
	'cameraprofilescameraprettyname' => { 531 => [\'CameraProfiles','CameraProfilesCameraPrettyName'] },
	'cameraprofilescamerarawprofile' => { 531 => [\'CameraProfiles','CameraProfilesCameraRawProfile'] },
	'cameraprofilesfocallength' => { 531 => [\'CameraProfiles','CameraProfilesFocalLength'] },
	'cameraprofilesfocusdistance' => { 531 => [\'CameraProfiles','CameraProfilesFocusDistance'] },
	'cameraprofileslens' => { 531 => [\'CameraProfiles','CameraProfilesLens'] },
	'cameraprofileslensprettyname' => { 531 => [\'CameraProfiles','CameraProfilesLensPrettyName'] },
	'cameraprofilesmake' => { 531 => [\'CameraProfiles','CameraProfilesMake'] },
	'cameraprofilesmodel' => { 531 => [\'CameraProfiles','CameraProfilesModel'] },
	'cameraprofilesperspectivemodel' => { 531 => [\'CameraProfiles','CameraProfilesPerspectiveModel'] },
	'cameraprofilesperspectivemodelimagexcenter' => { 531 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageXCenter'] },
	'cameraprofilesperspectivemodelimageycenter' => { 531 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageYCenter'] },
	'cameraprofilesperspectivemodelradialdistortparam1' => { 531 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam1'] },
	'cameraprofilesperspectivemodelradialdistortparam2' => { 531 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam2'] },
	'cameraprofilesperspectivemodelradialdistortparam3' => { 531 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam3'] },
	'cameraprofilesperspectivemodelscalefactor' => { 531 => [\'CameraProfiles','CameraProfilesPerspectiveModelScaleFactor'] },
	'cameraprofilesperspectivemodelversion' => { 531 => [\'CameraProfiles','CameraProfilesPerspectiveModelVersion'] },
	'cameraprofilesprofilename' => { 531 => [\'CameraProfiles','CameraProfilesProfileName'] },
	'cameraprofilessensorformatfactor' => { 531 => [\'CameraProfiles','CameraProfilesSensorFormatFactor'] },
	'cameraprofilesuniquecameramodel' => { 531 => [\'CameraProfiles','CameraProfilesUniqueCameraModel'] },
	'camerarawcolortone' => { 113 => 0xe1 },
	'camerarawcontrast' => { 113 => 0xe3 },
	'camerarawhighlightpoint' => { 113 => 0xe6 },
	'camerarawlinear' => { 113 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 113 => 0xe8 },
	'camerarawoutputshadowpoint' => { 113 => 0xe9 },
	'camerarawsaturation' => { 113 => 0xe2 },
	'camerarawshadowpoint' => { 113 => 0xe7 },
	'camerarawsharpness' => { 113 => 0xe5 },
	'cameraroll' => { 119 => 0xb, 410 => "\xa9grl" },
	'cameras' => { 492 => 'Cameras' },
	'cameraserialnumber' => { 123 => 0xc62f, 182 => 'CameraSerialNumber', 504 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 325 => 0x0 },
	'cameratemperature' => { 7 => 0x18, 9 => 0x1b, 11 => 0x18, 13 => 0x19, 14 => 0x18, 15 => 0x18, 16 => 0x19, 17 => 0x19, 18 => 0x19, 19 => 0x17, 20 => 0x19, 21 => 0x1b, 22 => 0x19, 23 => 0x19, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x1b, 28 => 0x19, 29 => 0x1b, 31 => [0x87,0x91], 32 => [0x99,0x9f,0xa4,0xa8,0x105], 35 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 80 => 0xc, 142 => 0x406, 329 => 0x1306, 344 => 0x320, 351 => 0x3402, 385 => 0x47, 424 => 0x43, 478 => 0x5 },
	'cameratemperature4' => { 390 => 0x14 },
	'cameratemperature5' => { 390 => 0x16 },
	'cameratemperaturerangemax' => { 125 => 0x5 },
	'cameratemperaturerangemin' => { 125 => 0x6 },
	'cameratrait' => { 492 => [\'Cameras','CamerasCameraTrait'] },
	'cameratype' => { 1 => 0x2e, 80 => 0x1a, 330 => 0x207 },
	'cameratype2' => { 326 => 0x100 },
	'cameravendorinfo' => { 492 => [\'Cameras','CamerasCameraVendorInfo'] },
	'cameravendorinfomanufacturer' => { 492 => [\'Cameras','CamerasCameraVendorInfoManufacturer'] },
	'cameravendorinfomodel' => { 492 => [\'Cameras','CamerasCameraVendorInfoModel'] },
	'cameravendorinfonotes' => { 492 => [\'Cameras','CamerasCameraVendorInfoNotes'] },
	'camerayaw' => { 119 => 0xa, 410 => "\xa9gyw" },
	'camreverse' => { 120 => 'CamReverse' },
	'canondr4' => { 124 => 'CanonDR4' },
	'canonexposuremode' => { 36 => 0x14 },
	'canonfiledescription' => { 101 => 0x805 },
	'canonfilelength' => { 67 => 0xe },
	'canonfirmwareversion' => { 67 => 0x7, 101 => 0x80b },
	'canonflashinfo' => { 101 => 0x1028 },
	'canonflashmode' => { 36 => 0x4 },
	'canonimagesize' => { 10 => 0x39, 36 => 0xa },
	'canonimagetype' => { 67 => 0x6, 101 => 0x815 },
	'canonlogversion' => { 66 => 0xb },
	'canonmodelid' => { 67 => 0x10, 101 => 0x1834 },
	'canonvrd' => { 124 => 'CanonVRD' },
	'caption' => { 509 => 'caption' },
	'caption-abstract' => { 135 => 0x78 },
	'captionsauthornames' => { 519 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 519 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 531 => 'CaptionWriter' },
	'captureframerate' => { 117 => 0x4001 },
	'captureheightnormal' => { 142 => 0x1839 },
	'capturelook' => { 142 => 0xc48 },
	'capturemode' => { 404 => 'com.apple.photos.captureMode' },
	'capturesoftware' => { 502 => 'CaptureSoftware' },
	'capturewidthnormal' => { 142 => 0x1838 },
	'capturewidthtest' => { 142 => 0x1842 },
	'cardshutterlock' => { 188 => 0x49 },
	'casioimagesize' => { 117 => 0x9 },
	'catalogsets' => { 135 => 0xff, 494 => 'CatalogSets', 507 => 'CatalogSets' },
	'categories' => { 67 => 0x23, 509 => 'categories' },
	'category' => { 135 => 0xf, 183 => 'WM/Category', 324 => 0x30, 402 => 'catg', 531 => 'Category' },
	'cbcrgain' => { 424 => 0xa036 },
	'cbcrgaindefault' => { 424 => 0xa035 },
	'cbcrmatrix' => { 424 => 0xa034 },
	'cbcrmatrixdefault' => { 424 => 0xa033 },
	'ccdboardversion' => { 344 => 0x331 },
	'ccdscanmode' => { 330 => 0x1039 },
	'ccdsensitivity' => { 287 => 0x6 },
	'ccdversion' => { 344 => 0x330 },
	'ccvavgluminancenits' => { 524 => 'ccv_avg_luminance_nits' },
	'ccvmaxluminancenits' => { 524 => 'ccv_max_luminance_nits' },
	'ccvminluminancenits' => { 524 => 'ccv_min_luminance_nits' },
	'ccvprimariesxy' => { 524 => 'ccv_primaries_xy' },
	'ccvwhitexy' => { 524 => 'ccv_white_xy' },
	'cellglobalid' => { 513 => 'cgi' },
	'celllength' => { 123 => 0x109 },
	'cellr' => { 513 => 'r' },
	'celltowerid' => { 513 => 'cellid' },
	'cellwidth' => { 123 => 0x108 },
	'centerafarea' => { 316 => '15.1' },
	'centerfocuspoint' => { 320 => '2.2' },
	'centerpixel' => { 142 => 0x40c },
	'centerweightedareasize' => { 305 => '7.1', 306 => '8.1', 308 => '8.1', 309 => '8.1', 313 => '7.1', 314 => '5.1', 315 => '7.1', 316 => '6.3', 318 => '8.1', 319 => '8.1', 320 => '8.1', 321 => 0x1f, 322 => 0x1f, 323 => 0x1f },
	'certificate' => { 547 => 'Certificate' },
	'cfainterpolationalgorithm' => { 142 => 0xe60 },
	'cfainterpolationmetric' => { 142 => 0xe61 },
	'cfaoffsetcols' => { 142 => 0xc71 },
	'cfaoffsetrows' => { 142 => 0xc6f },
	'cfapattern' => { 123 => 0xa302, 354 => 0x9, 520 => 'CFAPattern' },
	'cfapattern2' => { 123 => 0x828e },
	'cfapatterncolumns' => { 520 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 520 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 520 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 123 => 0x828d },
	'cfazipperfixthreshold' => { 142 => 0xe62 },
	'channel' => { 533 => 'channel' },
	'channela-lang' => { 533 => [\'channel','channelA-lang'] },
	'channelchannel' => { 533 => [\'channel','channelChannel'] },
	'channels' => { 159 => 'Channels' },
	'channelsubchannel1' => { 533 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 533 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 533 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 533 => [\'channel','channelSubchannel4'] },
	'chapterlist' => { 410 => 'chpl' },
	'checkmark' => { 107 => 0x10101, 112 => 0x26a },
	'checkmark2' => { 113 => 0x8e },
	'childfontfiles' => { 548 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 305 => '10.3', 306 => '11.2', 321 => 0x10b, 322 => 0x10b, 323 => 0x121 },
	'chromablurradius' => { 123 => 0xc631 },
	'chromanoisecolorspace' => { 142 => 0xe6d },
	'chromanoiseedgemapthresh' => { 142 => 0xe6c },
	'chromanoisehighfthresh' => { 142 => 0xe6a },
	'chromanoiselowfthresh' => { 142 => 0xe6b },
	'chromaticaberration' => { 107 => 0x20703, 113 => 0x66, 424 => 0xa051 },
	'chromaticaberrationb' => { 514 => 'ChromaticAberrationB', 516 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 107 => 0x20708, 113 => 0x6b },
	'chromaticaberrationcorr' => { 82 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 123 => 0x7034, 374 => 0x1, 488 => 0x900d },
	'chromaticaberrationcorrparams' => { 123 => 0x7035, 482 => 0x66a, 483 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 107 => '0x20703.0', 113 => 0x62 },
	'chromaticaberrationr' => { 514 => 'ChromaticAberrationR', 516 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 107 => 0x20707, 113 => 0x6a },
	'chromaticaberrationsetting' => { 83 => 0x6 },
	'chrominancenoisereduction' => { 107 => 0x20601, 113 => 0x5e, 427 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 113 => 0x60 },
	'circadatecreated' => { 528 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrblacks2012' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'] },
	'circgradbasedcorrbrightness' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrcorrectionname' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'] },
	'circgradbasedcorrcorrectionsyncid' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'] },
	'circgradbasedcorrdefringe' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrdehaze' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'] },
	'circgradbasedcorrexposure' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'] },
	'circgradbasedcorrluminancenoise' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskinputdigest' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'circgradbasedcorrmaskleft' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmaskactive' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'circgradbasedcorrmaskmaskblendmode' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmaskdigest' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'circgradbasedcorrmaskmaskinverted' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'circgradbasedcorrmaskmaskname' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'] },
	'circgradbasedcorrmaskmasks' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'] },
	'circgradbasedcorrmaskmasksalpha' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'circgradbasedcorrmaskmasksangle' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'circgradbasedcorrmaskmasksbottom' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'circgradbasedcorrmaskmaskscentervalue' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'circgradbasedcorrmaskmaskscenterweight' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'circgradbasedcorrmaskmasksdabs' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'circgradbasedcorrmaskmasksfeather' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'circgradbasedcorrmaskmasksflipped' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'circgradbasedcorrmaskmasksflow' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'circgradbasedcorrmaskmasksfullx' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'circgradbasedcorrmaskmasksfully' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'circgradbasedcorrmaskmasksinputdigest' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'circgradbasedcorrmaskmasksleft' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'circgradbasedcorrmaskmasksmaskactive' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'circgradbasedcorrmaskmasksmaskblendmode' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmasksmaskdigest' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'circgradbasedcorrmaskmasksmaskinverted' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'circgradbasedcorrmaskmasksmaskname' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'circgradbasedcorrmaskmasksmasksubtype' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksmasksyncid' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'circgradbasedcorrmaskmasksmaskversion' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'circgradbasedcorrmaskmasksmidpoint' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'circgradbasedcorrmaskmasksorigin' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'circgradbasedcorrmaskmasksperimetervalue' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'circgradbasedcorrmaskmasksradius' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'circgradbasedcorrmaskmasksreferencepoint' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'circgradbasedcorrmaskmasksright' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'circgradbasedcorrmaskmasksroundness' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'circgradbasedcorrmaskmaskssizex' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'circgradbasedcorrmaskmaskssizey' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'circgradbasedcorrmaskmaskstop' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'circgradbasedcorrmaskmasksubtype' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksvalue' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'circgradbasedcorrmaskmasksversion' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'circgradbasedcorrmaskmaskswhat' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'circgradbasedcorrmaskmaskswholeimagearea' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'circgradbasedcorrmaskmasksx' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'] },
	'circgradbasedcorrmaskmasksy' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'] },
	'circgradbasedcorrmaskmasksyncid' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'circgradbasedcorrmaskmaskszerox' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'circgradbasedcorrmaskmaskszeroy' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'circgradbasedcorrmaskmaskversion' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'circgradbasedcorrmaskmidpoint' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskorigin' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'] },
	'circgradbasedcorrmaskperimetervalue' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskrange' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'circgradbasedcorrmaskrangeareamodels' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrmaskrangeareamodelscolorsampleinfo' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrmaskrangeareamodelscomponents' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrmaskrangecoloramount' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrmaskrangedepthfeather' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrmaskrangedepthmax' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrmaskrangedepthmin' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrmaskrangeinvert' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'circgradbasedcorrmaskrangelumfeather' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrmaskrangeluminancedepthsampleinfo' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrmaskrangelummax' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrmaskrangelummin' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrmaskrangelumrange' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrmaskrangesampletype' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrmaskrangetype' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'circgradbasedcorrmaskrangeversion' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'circgradbasedcorrmaskreferencepoint' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'circgradbasedcorrmaskright' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskwholeimagearea' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'circgradbasedcorrmaskx' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrrangemask' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'] },
	'circgradbasedcorrrangemaskareamodels' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrrangemaskareamodelscolorsampleinfo' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrrangemaskareamodelscomponents' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrrangemaskcoloramount' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrrangemaskdepthfeather' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrrangemaskdepthmax' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrrangemaskdepthmin' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrrangemaskinvert' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'circgradbasedcorrrangemasklumfeather' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrrangemaskluminancedepthsampleinfo' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrrangemasklummax' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrrangemasklummin' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrrangemasklumrange' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrrangemasksampletype' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrrangemasktype' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'] },
	'circgradbasedcorrrangemaskversion' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'circgradbasedcorrsaturation' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'] },
	'circgradbasedcorrshadows2012' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtexture' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'] },
	'circgradbasedcorrtint' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrtoninghue' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrtoningsaturation' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrwhat' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circgradbasedcorrwhites2012' => { 514 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'], 516 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'] },
	'circulargradientbasedcorrections' => { 514 => 'CircularGradientBasedCorrections', 516 => 'CircularGradientBasedCorrections' },
	'city' => { 135 => 0x5a, 165 => 'City', 349 => 0x6d, 531 => 'City' },
	'city2' => { 349 => 0x80 },
	'clarity' => { 36 => 0x33, 131 => 0x100f, 257 => 0x35, 258 => 0x3d, 451 => 0x2036, 514 => 'Clarity', 516 => 'Clarity' },
	'clarity2012' => { 514 => 'Clarity2012', 516 => 'Clarity2012' },
	'claritycontrol' => { 385 => 0x96 },
	'classification' => { 410 => 'clsf' },
	'classifystate' => { 135 => 0xe1 },
	'clearretouch' => { 349 => 0x7c },
	'clearretouchvalue' => { 349 => 0xa3 },
	'client' => { 543 => 'client' },
	'clientname' => { 522 => 'ClientName' },
	'clipboardaspectratio' => { 514 => 'ClipboardAspectRatio', 516 => 'ClipboardAspectRatio' },
	'clipboardorientation' => { 514 => 'ClipboardOrientation', 516 => 'ClipboardOrientation' },
	'clipfilename' => { 410 => 'clfn' },
	'clipid' => { 410 => 'clid' },
	'clmodeshootingspeed' => { 305 => '10.2', 306 => '11.3', 308 => '11.2', 309 => '11.2', 314 => '11.2', 315 => '10.2', 318 => '11.2', 319 => '11.2', 320 => '11.1', 321 => 0x3b, 322 => 0x3b, 323 => 0x3b },
	'cluster' => { 514 => 'Cluster', 516 => 'Cluster' },
	'cmcontrast' => { 333 => 0x2022 },
	'cmddialsreverserotation' => { 321 => 0xba, 322 => 0xba, 323 => 0xba },
	'cmexposurecompensation' => { 333 => 0x2000 },
	'cmhue' => { 333 => 0x2021 },
	'cmsaturation' => { 333 => 0x2020 },
	'cmsharpness' => { 333 => 0x2023 },
	'cmwhitebalance' => { 333 => 0x2001 },
	'cmwhitebalancecomp' => { 333 => 0x2002 },
	'cmwhitebalancegraypoint' => { 333 => 0x2010 },
	'codec' => { 173 => 'Codec' },
	'codedcharacterset' => { 136 => 0x5a },
	'codeversion' => { 410 => 'cver' },
	'collection' => { 338 => 'Collection' },
	'collectionname' => { 174 => [\'Collections','CollectionsCollectionName'], 410 => 'coll' },
	'collections' => { 174 => 'Collections', 509 => 'collections' },
	'collectionuri' => { 174 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 404 => 'player.movie.visual.color', 532 => 'color' },
	'coloraberrationcontrol' => { 298 => 0xc89224b },
	'coloradjustment' => { 427 => 0x14 },
	'coloradjustmentmode' => { 426 => 0x210 },
	'coloranta' => { 548 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 548 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 548 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 548 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 548 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 548 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 548 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 548 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 548 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 548 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 548 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 548 => 'Colorants' },
	'colorantswatchname' => { 548 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 548 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 548 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 548 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 160 => 'ColorBalance' },
	'colorbalanceadj' => { 298 => 0x76a43202 },
	'colorbalanceblue' => { 185 => 0x1e },
	'colorbalancegreen' => { 185 => 0x1d },
	'colorbalancered' => { 185 => 0x1c },
	'colorbalanceversion' => { 210 => 0x4, 211 => 0x4, 212 => 0x0, 213 => 0x0 },
	'colorblur' => { 113 => 0x65 },
	'colorbluron' => { 107 => 0x20704 },
	'colorbooster' => { 298 => 0x5f0e7d23 },
	'colorboostlevel' => { 292 => 0x1 },
	'colorboosttype' => { 292 => 0x0 },
	'colorchromeeffect' => { 131 => 0x1048 },
	'colorchromefxblue' => { 131 => 0x104e },
	'colorclass' => { 396 => 0xde, 397 => 'ColorClass' },
	'colorcompensationfilter' => { 188 => [0x3a,0x5f], 190 => 0x111, 451 => 0xb022 },
	'colorcompensationfiltercustom' => { 437 => 0xd, 438 => 0xc },
	'colorcompensationfilterset' => { 437 => 0x8, 438 => 0x7, 439 => 0x18, 456 => 0xf },
	'colorcontrol' => { 330 => 0x102b },
	'colorcorrection' => { 488 => 0x8015 },
	'colorcorrectionmatrix' => { 1 => 0x3e },
	'colorcreatoreffect' => { 325 => 0x532 },
	'colordataversion' => { 43 => 0x0, 44 => 0x0, 46 => 0x0, 47 => 0x0, 48 => 0x0, 49 => 0x0, 50 => 0x0, 51 => 0x0, 52 => 0x0 },
	'coloreffect' => { 349 => 0x28 },
	'colorfilter' => { 116 => 0x17, 117 => 0x3017, 185 => 0x29, 193 => [0x38,0x4d,0x4f], 392 => 0x17 },
	'colorgain' => { 264 => 0x51 },
	'colorgradeblending' => { 514 => 'ColorGradeBlending', 516 => 'ColorGradeBlending' },
	'colorgradeglobalhue' => { 514 => 'ColorGradeGlobalHue', 516 => 'ColorGradeGlobalHue' },
	'colorgradegloballum' => { 514 => 'ColorGradeGlobalLum', 516 => 'ColorGradeGlobalLum' },
	'colorgradeglobalsat' => { 514 => 'ColorGradeGlobalSat', 516 => 'ColorGradeGlobalSat' },
	'colorgradehighlightlum' => { 514 => 'ColorGradeHighlightLum', 516 => 'ColorGradeHighlightLum' },
	'colorgrademidtonehue' => { 514 => 'ColorGradeMidtoneHue', 516 => 'ColorGradeMidtoneHue' },
	'colorgrademidtonelum' => { 514 => 'ColorGradeMidtoneLum', 516 => 'ColorGradeMidtoneLum' },
	'colorgrademidtonesat' => { 514 => 'ColorGradeMidtoneSat', 516 => 'ColorGradeMidtoneSat' },
	'colorgradeshadowlum' => { 514 => 'ColorGradeShadowLum', 516 => 'ColorGradeShadowLum' },
	'colorhue' => { 107 => 0x20900, 240 => 0x8d },
	'colorimetricreference' => { 123 => 0xc6bf },
	'colorlabel' => { 519 => 'ColorLabel' },
	'colormatrix' => { 66 => 0xa, 329 => 0x200, 330 => 0x1011, 424 => 0xa030 },
	'colormatrix1' => { 123 => 0xc621, 394 => 0x106 },
	'colormatrix2' => { 123 => 0xc622, 333 => 0x200, 394 => 0x226 },
	'colormatrix3' => { 123 => 0xcd33 },
	'colormatrixa' => { 385 => 0x203 },
	'colormatrixa2' => { 385 => 0x21c },
	'colormatrixadobergb' => { 424 => 0xa032 },
	'colormatrixb' => { 385 => 0x204 },
	'colormatrixb2' => { 385 => 0x21d },
	'colormatrixnumber' => { 330 => 0x1019 },
	'colormatrixsrgb' => { 424 => 0xa031 },
	'colormode' => { 117 => 0x3015, 131 => 0x1210, 144 => 0x66, 185 => 0x28, 188 => 0x16, 190 => 0x101, 191 => 0x36, 193 => 0x7, 240 => 0x3, 287 => 0x4, 349 => 0x32, 427 => 0x2c, 451 => 0xb029, 531 => 'ColorMode' },
	'colormoirereduction' => { 107 => 0x20670, 299 => 0x15 },
	'colormoirereductionmode' => { 299 => 0x5 },
	'colormoirereductionon' => { 107 => '0x20670.0' },
	'colornoisereduction' => { 488 => 0x8029, 514 => 'ColorNoiseReduction', 516 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 514 => 'ColorNoiseReductionDetail', 516 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 299 => 0x18 },
	'colornoisereductionsharpness' => { 299 => 0x1c },
	'colornoisereductionsmoothness' => { 514 => 'ColorNoiseReductionSmoothness', 516 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 127 => 0x2 },
	'colorprofile' => { 185 => 0x33 },
	'colorprofilesettings' => { 325 => 0x539 },
	'colorrepresentation' => { 137 => 0x3c },
	'colorsaturationadj' => { 107 => 0x20305 },
	'colorsequence' => { 137 => 0x41 },
	'colorspace' => { 53 => 0x3, 67 => 0xb4, 101 => 0x10b4, 123 => 0xa001, 139 => 0x3, 166 => 'ColorSpace', 186 => 0x2f, 187 => 0x25, 188 => 0x17, 240 => 0x1e, 325 => 0x507, 385 => 0x37, 424 => 0xa011, 427 => 0xb, 437 => 0x1b, 438 => 0x83, 439 => 0xe, 456 => 0x6, 520 => 'ColorSpace' },
	'colorspace2' => { 66 => 0x9 },
	'colorspecapproximation' => { 139 => 0x2 },
	'colorspecdata' => { 139 => 0x3 },
	'colorspecmethod' => { 139 => 0x0 },
	'colorspecprecedence' => { 139 => 0x1 },
	'colortempasshot' => { 40 => 0x4, 41 => 0x7, 42 => 0x1d, 43 => 0x59, 44 => 0x6d, 45 => 0x26, 46 => 0x43, 49 => 0x43, 50 => 0x43, 51 => 0x43, 52 => 0x4b },
	'colortempauto' => { 40 => 0x9, 41 => 0xf, 42 => 0x22, 43 => 0x5e, 44 => 0x72, 45 => 0x1c, 46 => 0x48, 49 => 0x48, 50 => 0x48, 51 => 0x48, 52 => 0x50 },
	'colortempcloudy' => { 40 => 0x22, 41 => 0x37, 42 => 0x31, 43 => 0xa4, 44 => 0xdb, 45 => 0x35, 46 => 0x5c, 49 => 0x75, 50 => 0x8e, 51 => 0x93, 52 => 0x96, 385 => 0x55 },
	'colortempcustom' => { 46 => 0x84 },
	'colortempcustom1' => { 42 => 0x45 },
	'colortempcustom2' => { 42 => 0x4a },
	'colortempdaylight' => { 40 => 0x18, 41 => 0x27, 42 => 0x27, 43 => 0x9a, 44 => 0xd1, 45 => 0x2b, 46 => 0x52, 49 => 0x6b, 50 => 0x84, 51 => 0x89, 52 => 0x8c, 385 => 0x53 },
	'colortemperature' => { 1 => 0x2d, 7 => 0x73, 8 => [0x48,0x4e], 9 => 0xc0, 10 => 0x37, 11 => 0x62, 12 => 0x37, 13 => 0x7c, 14 => 0x73, 15 => 0x73, 16 => 0x77, 17 => 0x73, 18 => 0x7c, 19 => 0x58, 20 => 0x73, 21 => 0xc0, 22 => 0x7f, 23 => 0x7d, 24 => 0xc0, 25 => 0xc6, 26 => 0xc7, 27 => 0x135, 28 => 0x7b, 29 => 0x13a, 67 => 0xae, 77 => 0x9, 101 => 0x10ae, 131 => 0x1005, 142 => 0x846, 160 => 'ColorTemperature', 186 => [0x6e,0x49], 187 => 0x3f, 188 => [0x39,0x5e], 190 => 0x10b, 193 => [0x3c,0x4c,0x4e], 344 => 0x321, 385 => 0x50, 417 => 0x1308, 451 => 0xb021, 514 => 'Temperature', 516 => 'Temperature' },
	'colortemperatureadj' => { 488 => 0x8013 },
	'colortemperatureauto' => { 240 => 0x4f },
	'colortemperaturebg' => { 330 => 0x1013 },
	'colortemperaturecustom' => { 437 => 0xc, 438 => 0xb },
	'colortemperaturerg' => { 330 => 0x1014 },
	'colortemperatureset' => { 437 => 0x7, 438 => 0x6 },
	'colortemperaturesetting' => { 188 => 0x25, 439 => 0x17, 456 => 0xe },
	'colortempflash' => { 40 => 0x36, 41 => 0x57, 42 => 0x40, 43 => 0xb8, 44 => 0xef, 45 => 0x49, 46 => 0x70, 49 => 0x89, 50 => 0xa2, 51 => 0xa7, 52 => 0xaa, 385 => 0x5a },
	'colortempflashdata' => { 46 => 0x24a },
	'colortempfluorescent' => { 40 => 0x2c, 41 => 0x47, 42 => 0x3b, 43 => 0xae, 44 => 0xe5, 45 => 0x3f, 46 => 0x66, 49 => 0x7f, 50 => 0x98, 51 => 0x9d, 52 => 0xa0 },
	'colortempfluorescentd' => { 385 => 0x57 },
	'colortempfluorescentn' => { 385 => 0x58 },
	'colortempfluorescentw' => { 385 => 0x59 },
	'colortempkelvin' => { 40 => 0x31, 41 => 0x4f, 43 => 0xb3, 44 => 0xea, 45 => 0x44, 46 => 0x6b, 49 => 0x84, 50 => 0x9d, 51 => 0xa2, 52 => 0xa5, 349 => 0x44, 417 => 0x1307 },
	'colortempmeasured' => { 40 => 0xe, 41 => 0x17, 43 => 0x63, 44 => 0x77, 46 => 0x4d, 49 => 0x4d, 50 => 0x4d, 51 => 0x4d, 52 => 0x55 },
	'colortemppc1' => { 45 => 0x94, 46 => 0x75 },
	'colortemppc2' => { 45 => 0x99, 46 => 0x7a },
	'colortemppc3' => { 45 => 0x9e, 46 => 0x7f },
	'colortempshade' => { 40 => 0x1d, 41 => 0x2f, 42 => 0x2c, 43 => 0x9f, 44 => 0xd6, 45 => 0x30, 46 => 0x57, 49 => 0x70, 50 => 0x89, 51 => 0x8e, 52 => 0x91, 385 => 0x54 },
	'colortemptungsten' => { 40 => 0x27, 41 => 0x3f, 42 => 0x36, 43 => 0xa9, 44 => 0xe0, 45 => 0x3a, 46 => 0x61, 49 => 0x7a, 50 => 0x93, 51 => 0x98, 52 => 0x9b, 385 => 0x56 },
	'colortempunknown' => { 40 => 0x13, 41 => 0x1f, 43 => 0x68, 44 => 0x7c, 45 => 0x21, 49 => 0x52, 50 => 0x52, 51 => 0x52, 52 => 0x5a },
	'colortempunknown10' => { 40 => 0x63, 41 => 0x9f, 43 => 0x95, 44 => 0xa9, 45 => 0x76, 49 => 0xa2, 50 => 0x7f, 51 => 0x7f, 52 => 0x87 },
	'colortempunknown11' => { 40 => 0x68, 41 => 0xa7, 43 => 0xbd, 44 => [0xae,0xb3], 45 => 0x7b, 49 => 0xa7, 50 => 0xa7, 51 => 0x84, 52 => 0xaf },
	'colortempunknown12' => { 40 => 0x6d, 41 => 0xaf, 43 => 0xc2, 44 => 0xb8, 45 => 0x80, 49 => 0xac, 50 => 0xac, 51 => 0xac, 52 => 0xb4 },
	'colortempunknown13' => { 40 => 0x72, 41 => 0xb7, 43 => 0xc7, 44 => 0xbd, 45 => 0x85, 49 => 0xb1, 50 => 0xb1, 51 => 0xb1, 52 => 0xb9 },
	'colortempunknown14' => { 43 => 0xcc, 44 => 0xc2, 45 => 0x8a, 49 => 0xb6, 50 => 0xb6, 51 => 0xb6, 52 => 0xbe },
	'colortempunknown15' => { 43 => 0xd1, 44 => 0xc7, 45 => 0x8f, 49 => 0xbb, 50 => 0xbb, 51 => 0xbb, 52 => 0xc3 },
	'colortempunknown16' => { 43 => 0xd6, 44 => 0xcc, 45 => 0xa3, 50 => 0xc0, 51 => 0xc0, 52 => 0xc8 },
	'colortempunknown17' => { 43 => 0xdb, 44 => 0xf4, 50 => 0xc5, 51 => 0xc5, 52 => 0xcd },
	'colortempunknown18' => { 43 => 0xe0, 44 => 0xf9, 50 => 0xca, 51 => 0xca, 52 => 0xd2 },
	'colortempunknown19' => { 43 => 0xe5, 44 => 0xfe, 50 => 0xcf, 51 => 0xcf, 52 => 0xd7 },
	'colortempunknown2' => { 40 => 0x3b, 41 => 0x5f, 43 => 0x6d, 44 => 0x81, 45 => 0x4e, 49 => 0x57, 50 => 0x57, 51 => 0x57, 52 => 0x5f },
	'colortempunknown20' => { 43 => 0xea, 44 => 0x103, 50 => 0xd4, 51 => 0xd4, 52 => 0xdc },
	'colortempunknown21' => { 43 => 0xef, 44 => 0x108, 51 => 0xd9, 52 => 0xe1 },
	'colortempunknown22' => { 43 => 0xf4, 44 => 0x10d, 51 => 0xde, 52 => 0xe6 },
	'colortempunknown23' => { 43 => 0xf9, 44 => 0x112, 51 => 0xe3, 52 => 0xeb },
	'colortempunknown24' => { 43 => 0xfe, 44 => 0x117, 51 => 0xe8, 52 => 0xf0 },
	'colortempunknown25' => { 43 => 0x103, 44 => 0x11c, 51 => 0xed, 52 => 0xf5 },
	'colortempunknown26' => { 43 => 0x108, 44 => 0x121, 51 => 0xf2, 52 => 0xfa },
	'colortempunknown27' => { 43 => 0x10d, 44 => 0x126, 51 => 0xf7, 52 => 0xff },
	'colortempunknown28' => { 43 => 0x112, 51 => 0xfc, 52 => 0x104 },
	'colortempunknown29' => { 43 => 0x117, 51 => 0x101, 52 => 0x109 },
	'colortempunknown3' => { 40 => 0x40, 41 => 0x67, 43 => 0x72, 44 => 0x86, 45 => 0x53, 49 => 0x5c, 50 => 0x5c, 51 => 0x5c, 52 => 0x64 },
	'colortempunknown30' => { 51 => 0x106 },
	'colortempunknown4' => { 40 => 0x45, 41 => 0x6f, 43 => 0x77, 44 => 0x8b, 45 => 0x58, 49 => 0x61, 50 => 0x61, 51 => 0x61, 52 => 0x69 },
	'colortempunknown5' => { 40 => 0x4a, 41 => 0x77, 43 => 0x7c, 44 => 0x90, 45 => 0x5d, 49 => 0x66, 50 => 0x66, 51 => 0x66, 52 => 0x6e },
	'colortempunknown6' => { 40 => 0x4f, 41 => 0x7f, 43 => 0x81, 44 => 0x95, 45 => 0x62, 49 => 0x8e, 50 => 0x6b, 51 => 0x6b, 52 => 0x73 },
	'colortempunknown7' => { 40 => 0x54, 41 => 0x87, 43 => 0x86, 44 => 0x9a, 45 => 0x67, 49 => 0x93, 50 => 0x70, 51 => 0x70, 52 => 0x78 },
	'colortempunknown8' => { 40 => 0x59, 41 => 0x8f, 43 => 0x8b, 44 => 0x9f, 45 => 0x6c, 49 => 0x98, 50 => 0x75, 51 => 0x75, 52 => 0x7d },
	'colortempunknown9' => { 40 => 0x5e, 41 => 0x97, 43 => 0x90, 44 => 0xa4, 45 => 0x71, 49 => 0x9d, 50 => 0x7a, 51 => 0x7a, 52 => 0x82 },
	'colortint' => { 348 => 0x35c },
	'colortone' => { 10 => 0x6f, 12 => 0x77, 36 => 0x2a, 53 => 0x2, 66 => 0x8 },
	'colortoneadj' => { 107 => 0x20304, 112 => 0x11e },
	'colortoneauto' => { 74 => 0x9c },
	'colortonefaithful' => { 19 => 0x107, 73 => 0x6c, 74 => 0x6c },
	'colortonelandscape' => { 19 => 0x105, 73 => 0x3c, 74 => 0x3c },
	'colortonemonochrome' => { 73 => 0x84, 74 => 0x84 },
	'colortoneneutral' => { 19 => 0x106, 73 => 0x54, 74 => 0x54 },
	'colortoneportrait' => { 19 => 0x104, 73 => 0x24, 74 => 0x24 },
	'colortonestandard' => { 19 => 0x103, 73 => 0xc, 74 => 0xc },
	'colortoneuserdef1' => { 19 => 0x109, 73 => 0x9c, 74 => 0xb4 },
	'colortoneuserdef2' => { 19 => 0x10a, 73 => 0xb4, 74 => 0xcc },
	'colortoneuserdef3' => { 19 => 0x10b, 73 => 0xcc, 74 => 0xe4 },
	'columninterleavefactor' => { 123 => 0xcd43 },
	'comlenblksize' => { 142 => 0xfde8 },
	'commanddialframeadvancezoom' => { 249 => 0x804 },
	'commanddialplaybackmode' => { 321 => 0x1cb, 322 => 0x1cb, 323 => 0x1e3 },
	'commanddials' => { 316 => '5.1' },
	'commanddialsaperturesetting' => { 305 => '17.3', 306 => '18.3', 308 => '18.3', 309 => '18.3', 314 => '33.3', 315 => '17.3', 318 => '18.3', 319 => '18.3' },
	'commanddialschangemainsub' => { 305 => '17.2', 306 => '18.1', 308 => '18.1', 309 => '18.1', 314 => '33.2', 315 => '17.2', 318 => '18.1', 319 => '18.1' },
	'commanddialsmenuandplayback' => { 305 => '17.4', 306 => '18.2', 308 => '18.2', 309 => '18.2', 314 => '33.4', 315 => '17.4', 318 => '18.2', 319 => '18.2' },
	'commanddialsreverserotation' => { 305 => '17.1', 306 => '6.4', 308 => '6.2', 309 => '6.2', 310 => '16.2', 311 => '17.2', 314 => '33.1', 315 => '17.1', 318 => '6.2', 319 => '6.2', 320 => '18.1' },
	'commanddialvideoplaybackmode' => { 321 => 0x1cd, 323 => 0x1e5 },
	'commanderchannel' => { 316 => '10.2', 317 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 316 => '13.1', 317 => '31.1' },
	'commandergroupa_ttlcomp' => { 320 => '32.1' },
	'commandergroupamanualoutput' => { 316 => '13.2', 317 => '28.2' },
	'commandergroupamode' => { 316 => '11.2', 317 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 316 => '14.1', 317 => '32.1' },
	'commandergroupb_ttlcomp' => { 320 => '33.1' },
	'commandergroupbmanualoutput' => { 316 => '14.2', 317 => '29.2' },
	'commandergroupbmode' => { 316 => '11.3', 317 => '29.1' },
	'commanderinternalflash' => { 316 => '11.1', 317 => '27.1' },
	'commanderinternalmanualoutput' => { 316 => '12.2', 317 => '27.2' },
	'commanderinternalttlchannel' => { 314 => '18.2' },
	'commanderinternalttlcomp' => { 316 => '12.1', 317 => '30.2', 320 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 314 => '20.1', 315 => '26.1' },
	'commanderinternalttlcompgroupa' => { 314 => '21.1', 315 => '27.1' },
	'commanderinternalttlcompgroupb' => { 314 => '22.1', 315 => '28.1' },
	'comment' => { 0 => 0x2, 124 => 'Comment', 161 => 'Comment', 338 => 'Comment', 402 => "\xa9cmt", 404 => 'comment', 410 => "\xa9cmt" },
	'compass' => { 420 => 0x4 },
	'compatiblebrands' => { 404 => 'compatible_brands' },
	'compatibleversion' => { 514 => 'CompatibleVersion', 516 => 'CompatibleVersion' },
	'compilation' => { 402 => 'cpil' },
	'compimageimagespersequence' => { 521 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfImagesInSequences'] },
	'compimagemaxexposureall' => { 521 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfAll'] },
	'compimagemaxexposureused' => { 521 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfUsed'] },
	'compimageminexposureall' => { 521 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfAll'] },
	'compimageminexposureused' => { 521 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfUsed'] },
	'compimagenumsequences' => { 521 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfSequences'] },
	'compimagesumexposureall' => { 521 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfAll'] },
	'compimagesumexposureused' => { 521 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfUsed'] },
	'compimagetotalexposureperiod' => { 521 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesTotalExposurePeriod'] },
	'compimagevalues' => { 521 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesValues'] },
	'complianceprofile' => { 533 => 'complianceProfile' },
	'componentsconfiguration' => { 123 => 0x9101, 166 => 'Components', 520 => 'ComponentsConfiguration' },
	'componentversion' => { 101 => 0x80c },
	'composer' => { 183 => 'WM/Composer', 402 => ["\xa9com","\xa9wrt"], 410 => ["\xa9com","\xa9wrt"], 543 => 'composer' },
	'composerid' => { 402 => 'cmID' },
	'composerkeywords' => { 410 => "\xa9cok" },
	'compositeimage' => { 123 => 0xa460, 521 => 'CompositeImage' },
	'compositeimagecount' => { 123 => 0xa461, 521 => 'CompositeImageCount' },
	'compositeimageexposuretimes' => { 123 => 0xa462, 521 => 'CompositeImageExposureTimes' },
	'composition' => { 504 => 'Composition' },
	'compositionadjust' => { 383 => '0.1' },
	'compositionadjustrotation' => { 383 => 0x7 },
	'compositionadjustx' => { 383 => 0x5 },
	'compositionadjusty' => { 383 => 0x6 },
	'compressedbitsperpixel' => { 123 => 0x9102, 520 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 190 => 0x40, 330 => 0x40 },
	'compression' => { 123 => 0x103, 354 => 0xb, 539 => 'Compression' },
	'compressionfactor' => { 325 => 0x50d },
	'compressionformat' => { 66 => 0x4 },
	'compressionratio' => { 166 => 'Compression', 330 => 0x1034 },
	'compressorversion' => { 410 => 'CNCV' },
	'condadobvfactor' => { 142 => 0xf3e },
	'condadodaybvthresh' => { 142 => 0xf3c },
	'condadodayoffsets' => { 142 => 0xf42 },
	'condadofluoffsets' => { 142 => 0xf44 },
	'condadofluthresh' => { 142 => 0xf41 },
	'condadoillfactor' => { 142 => 0xf3f },
	'condadoneurange' => { 142 => 0xf3d },
	'condadotunoffsets' => { 142 => 0xf43 },
	'condadotunthresh' => { 142 => 0xf40 },
	'conductor' => { 183 => 'WM/Conductor', 402 => "\xa9con" },
	'confidence' => { 499 => 'Confidence' },
	'confidencelevel' => { 510 => 'ConfidenceLevel' },
	'confidencemime' => { 499 => 'ConfidenceMime' },
	'constrainedcropheight' => { 112 => 0x266, 396 => 0xd6 },
	'constrainedcropwidth' => { 112 => 0x262, 396 => 0xd5 },
	'contact' => { 135 => 0x76 },
	'contactinfo' => { 514 => 'ContactInfo', 516 => 'ContactInfo', 532 => 'contactInfo' },
	'container' => { 492 => 'Container' },
	'containerdirectory' => { 492 => [\'Container','ContainerDirectory'], 497 => 'Directory' },
	'containerdirectoryitem' => { 492 => [\'Container','ContainerDirectoryItem'] },
	'containerdirectoryitemdatauri' => { 492 => [\'Container','ContainerDirectoryItemDataURI'] },
	'containerdirectoryitemlength' => { 492 => [\'Container','ContainerDirectoryItemLength'] },
	'containerdirectoryitemmime' => { 492 => [\'Container','ContainerDirectoryItemMime'] },
	'containerdirectoryitempadding' => { 492 => [\'Container','ContainerDirectoryItemPadding'] },
	'containerformat' => { 528 => 'ContainerFormat' },
	'containerformatidentifier' => { 528 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 528 => [\'ContainerFormat','ContainerFormatName'] },
	'contentcreatedate' => { 402 => "\xa9day", 410 => ['@day',"\xa9day"] },
	'contentdistributor' => { 183 => 'WM/ContentDistributor' },
	'contentdistributorid' => { 410 => 'cdis' },
	'contentid' => { 410 => 'ccid' },
	'contentidentifier' => { 1 => 0x11, 404 => 'content.identifier' },
	'contentlocationcode' => { 135 => 0x1a },
	'contentlocationname' => { 135 => 0x1b },
	'contenttype' => { 533 => 'contentType' },
	'continuousbracketing' => { 188 => 0x20 },
	'continuousdrive' => { 36 => 0x5 },
	'continuousmodedisplay' => { 321 => 0x51, 322 => 0x51, 323 => 0x51 },
	'continuousmodeliveview' => { 319 => '77.2' },
	'continuousshootingspeed' => { 88 => 0x610 },
	'continuousshotlimit' => { 88 => 0x611 },
	'contrast' => { 10 => 0x73, 12 => 0x75, 36 => 0xd, 116 => 0xc, 117 => [0x3012,0x20], 123 => [0xa408,0xfe54], 131 => [0x1004,0x1006], 160 => 'Contrast', 180 => 'Contrast', 185 => 0x20, 186 => 0x31, 187 => 0x27, 188 => 0x19, 193 => 0x2, 256 => 0x33, 257 => 0x37, 258 => 0x3f, 330 => 0x1029, 349 => 0x39, 351 => 0x300a, 385 => 0x20, 392 => 0xc, 404 => 'player.movie.visual.contrast', 411 => 0x24, 413 => 0x52, 417 => 0x1012, 427 => 0xd, 437 => 0x1d, 438 => 0x1a, 451 => 0x2004, 514 => 'Contrast', 516 => 'Contrast', 520 => 'Contrast' },
	'contrast2012' => { 514 => 'Contrast2012', 516 => 'Contrast2012' },
	'contrastadj' => { 107 => 0x20303, 112 => 0x115, 301 => 0x2c, 488 => 0x8017 },
	'contrastauto' => { 74 => 0x90 },
	'contrastcurve' => { 240 => 0x8c },
	'contrastdetectaf' => { 197 => 0x4 },
	'contrastdetectafarea' => { 385 => 0x231 },
	'contrastdetectafinfocus' => { 197 => [0x1c,0x52] },
	'contrastfaithful' => { 19 => 0xec, 73 => 0x60, 74 => 0x60 },
	'contrasthighlight' => { 385 => 0x6d },
	'contrasthighlightshadowadj' => { 385 => 0x6f },
	'contrastlandscape' => { 19 => 0xea, 73 => 0x30, 74 => 0x30 },
	'contrastmode' => { 349 => 0x2c },
	'contrastmonochrome' => { 19 => 0xed, 73 => 0x78, 74 => 0x78 },
	'contrastneutral' => { 19 => 0xeb, 73 => 0x48, 74 => 0x48 },
	'contrastportrait' => { 19 => 0xe9, 73 => 0x18, 74 => 0x18 },
	'contrastsetting' => { 325 => 0x505, 333 => 0x1012, 439 => 0x10, 456 => 0x8 },
	'contrastshadow' => { 385 => 0x6e },
	'contraststandard' => { 19 => 0xe8, 73 => 0x0, 74 => 0x0 },
	'contrastuserdef1' => { 19 => 0xee, 73 => 0x90, 74 => 0xa8 },
	'contrastuserdef2' => { 19 => 0xef, 73 => 0xa8, 74 => 0xc0 },
	'contrastuserdef3' => { 19 => 0xf0, 73 => 0xc0, 74 => 0xd8 },
	'contributedmedia' => { 543 => 'contributedMedia' },
	'contributedmediaduration' => { 543 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 543 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 543 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 543 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 543 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 543 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 543 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 543 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 543 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 543 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 517 => 'contributor', 528 => 'Contributor' },
	'contributoridentifier' => { 528 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 528 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 528 => [\'Contributor','ContributorRole'] },
	'contributors' => { 161 => 'Contributors' },
	'controldialset' => { 188 => 0x46 },
	'controlledvocabularyterm' => { 528 => 'CVterm' },
	'controllerboardversion' => { 344 => 0x332 },
	'controlmode' => { 80 => 0x12 },
	'controlringresponse' => { 321 => 0x1d5, 322 => 0x1d5, 323 => 0x1ed },
	'controlringrotation' => { 88 => 0x712 },
	'conversionlens' => { 326 => 0x403, 349 => 0x35 },
	'converter' => { 123 => 0xfe4d, 287 => 0xb, 514 => 'Converter', 516 => 'Converter' },
	'converttograyscale' => { 514 => 'ConvertToGrayscale', 516 => 'ConvertToGrayscale' },
	'cookingequipment' => { 535 => 'cookingEquipment' },
	'cookingmethod' => { 535 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 123 => 0x8298, 161 => 'Copyright', 338 => 'Copyright', 354 => 0x8298, 385 => 0x22f, 401 => 'Copyright', 402 => ['cprt',"\xa9cpy"], 404 => 'copyright', 410 => ['cprt',"\xa9cpy"], 514 => 'Copyright', 516 => 'Copyright', 530 => 'Copyright', 536 => 'copyright', 539 => 'Copyright', 543 => 'copyright' },
	'copyrightflag' => { 399 => 0x40a },
	'copyrightnotice' => { 135 => 0x74 },
	'copyrightowner' => { 335 => 'CopyrightOwner' },
	'copyrightownerid' => { 335 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 335 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 335 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 335 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 335 => 'CopyrightStatus' },
	'copyrightyear' => { 528 => 'CopyrightYear', 533 => 'copyrightYear' },
	'coringfilter' => { 329 => 0x310, 330 => 0x102d, 333 => 0x310 },
	'coringvalues' => { 329 => 0x311, 333 => 0x311 },
	'corporateentity' => { 533 => 'corporateEntity' },
	'correctionalreadyapplied' => { 339 => 'CorrectionAlreadyApplied' },
	'correlatedcolortemp' => { 348 => 0x35b },
	'country' => { 165 => 'Country', 349 => 0x69, 531 => 'Country' },
	'country-primarylocationcode' => { 135 => 0x64 },
	'country-primarylocationname' => { 135 => 0x65 },
	'countrycode' => { 239 => 0x5, 397 => 'CountryCode', 527 => 'CountryCode' },
	'course' => { 535 => 'course' },
	'coverage' => { 517 => 'coverage' },
	'coverart' => { 402 => 'covr' },
	'coverdate' => { 533 => 'coverDate' },
	'coverdisplaydate' => { 533 => 'coverDisplayDate' },
	'coveruri' => { 410 => 'cvru' },
	'cpufirmwareversion' => { 385 => 0x28 },
	'crc32' => { 518 => 'crc32' },
	'createdate' => { 123 => 0x9004, 161 => 'CreateDate', 334 => 'CreationDate', 338 => 'create-date', 401 => 'CreationDate', 407 => 0x1, 541 => 'CreateDate' },
	'creationdate' => { 404 => 'creationdate', 530 => 'CreationDate', 533 => 'creationDate' },
	'creationtime' => { 338 => 'Creation Time', 404 => 'creation_time' },
	'creativestyle' => { 437 => 0x1a, 438 => 0x18, 448 => 0x41, 451 => 0xb020, 483 => 0x4a },
	'creativestylesetting' => { 439 => 0xf, 456 => 0x7 },
	'creativestylewaschanged' => { 488 => 0x8001 },
	'creator' => { 334 => 'Creator', 401 => 'Creator', 517 => 'creator', 528 => 'Creator', 530 => 'Creator' },
	'creatoraddress' => { 527 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 182 => 'CreatorAppId' },
	'creatorcity' => { 527 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 527 => 'CreatorContactInfo' },
	'creatorcountry' => { 527 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 528 => [\'Creator','CreatorIdentifier'] },
	'creatoridentity' => { 397 => 'CreatorIdentity' },
	'creatorname' => { 528 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 182 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 527 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 527 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 528 => [\'Creator','CreatorRole'] },
	'creatortool' => { 541 => 'CreatorTool' },
	'creatorworkemail' => { 527 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 527 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 527 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 135 => 0x6e, 531 => 'Credit' },
	'creditline' => { 536 => 'creditLine' },
	'creditlinereq' => { 546 => 'CreditLineReq' },
	'creditlinerequired' => { 335 => 'CreditLineRequired' },
	'cropactive' => { 105 => 0x0, 112 => 0x244 },
	'cropangle' => { 105 => 0x8, 514 => 'CropAngle', 516 => 'CropAngle' },
	'croparea' => { 240 => 0x45, 488 => 0x9011 },
	'cropaspectratio' => { 107 => 0x30101, 112 => 0x260 },
	'cropaspectratiocustom' => { 107 => 0x30102 },
	'cropbottom' => { 127 => 0x9, 293 => 0x36, 354 => 0x31, 396 => 0xdc, 514 => 'CropBottom', 516 => 'CropBottom' },
	'cropbottommargin' => { 55 => 0x3 },
	'cropcircleactive' => { 113 => 0xd6 },
	'cropcircleradius' => { 113 => 0xd9 },
	'cropcirclex' => { 113 => 0xd7 },
	'cropcircley' => { 113 => 0xd8 },
	'cropconstraintowarp' => { 514 => 'CropConstrainToWarp', 516 => 'CropConstrainToWarp' },
	'cropflag' => { 131 => 0x1051 },
	'croph' => { 508 => 'CropH' },
	'cropheight' => { 105 => 0x6, 112 => 0x24c, 329 => 0x615, 333 => 0x615, 514 => 'CropHeight', 516 => 'CropHeight' },
	'crophispeed' => { 240 => 0x1b },
	'cropleft' => { 112 => 0x246, 127 => 0x6, 293 => 0x1e, 329 => 0x612, 333 => 0x612, 354 => 0x30, 396 => 0xd9, 514 => 'CropLeft', 516 => 'CropLeft' },
	'cropleftmargin' => { 55 => 0x0 },
	'cropmode' => { 131 => 0x104d, 417 => 0x1018 },
	'croporiginalheight' => { 105 => 0xb },
	'croporiginalwidth' => { 105 => 0xa },
	'cropoutputheight' => { 293 => 0xce },
	'cropoutputheightinches' => { 293 => 0x96 },
	'cropoutputpixels' => { 293 => 0xd6 },
	'cropoutputresolution' => { 293 => 0xb6 },
	'cropoutputscale' => { 293 => 0xbe },
	'cropoutputwidth' => { 293 => 0xc6 },
	'cropoutputwidthinches' => { 293 => 0x8e },
	'croppedareaimageheightpixels' => { 502 => 'CroppedAreaImageHeightPixels', 503 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 502 => 'CroppedAreaImageWidthPixels', 503 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 502 => 'CroppedAreaLeftPixels', 503 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 502 => 'CroppedAreaTopPixels', 503 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 417 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 417 => 0x1603 },
	'cropping' => { 488 => 0x9010 },
	'cropright' => { 127 => 0x8, 293 => 0x2e, 354 => 0x32, 396 => 0xdb, 514 => 'CropRight', 516 => 'CropRight' },
	'croprightmargin' => { 55 => 0x1 },
	'croprotatedoriginalheight' => { 105 => 0x2 },
	'croprotatedoriginalwidth' => { 105 => 0x1 },
	'croprotation' => { 105 => 0x7, 127 => 0xb },
	'cropscaledresolution' => { 293 => 0x9e },
	'cropsize' => { 131 => 0x1053 },
	'cropsourceresolution' => { 293 => 0xae },
	'croptop' => { 112 => 0x248, 127 => 0x7, 293 => 0x26, 329 => 0x613, 333 => 0x613, 354 => 0x2f, 396 => 0xda, 514 => 'CropTop', 516 => 'CropTop' },
	'croptopleft' => { 131 => 0x1052 },
	'croptopmargin' => { 55 => 0x2 },
	'cropunit' => { 514 => 'CropUnit', 516 => 'CropUnit' },
	'cropunits' => { 514 => 'CropUnits', 516 => 'CropUnits' },
	'cropw' => { 508 => 'CropW' },
	'cropwidth' => { 105 => 0x5, 112 => 0x24a, 329 => 0x614, 333 => 0x614, 514 => 'CropWidth', 516 => 'CropWidth' },
	'cropx' => { 105 => 0x3, 508 => 'CropX' },
	'cropy' => { 105 => 0x4, 508 => 'CropY' },
	'crossprocess' => { 385 => 0x7b },
	'crossprocessparams' => { 385 => 0x235 },
	'cuisine' => { 535 => 'cuisine' },
	'currenticcprofile' => { 123 => 0xc691 },
	'currentpreprofilematrix' => { 123 => 0xc692 },
	'currentversion' => { 488 => 0xd000 },
	'curve0x' => { 508 => 'Curve0x' },
	'curve0y' => { 508 => 'Curve0y' },
	'curve1x' => { 508 => 'Curve1x' },
	'curve1y' => { 508 => 'Curve1y' },
	'curve2x' => { 508 => 'Curve2x' },
	'curve2y' => { 508 => 'Curve2y' },
	'curve3x' => { 508 => 'Curve3x' },
	'curve3y' => { 508 => 'Curve3y' },
	'curve4x' => { 508 => 'Curve4x' },
	'curve4y' => { 508 => 'Curve4y' },
	'curves' => { 298 => 0x76a43201 },
	'custom1' => { 335 => 'Custom1' },
	'custom10' => { 335 => 'Custom10' },
	'custom2' => { 335 => 'Custom2' },
	'custom3' => { 335 => 'Custom3' },
	'custom4' => { 335 => 'Custom4' },
	'custom5' => { 335 => 'Custom5' },
	'custom6' => { 335 => 'Custom6' },
	'custom7' => { 335 => 'Custom7' },
	'custom8' => { 335 => 'Custom8' },
	'custom9' => { 335 => 'Custom9' },
	'customcolortone' => { 113 => 0x4c },
	'customcontrast' => { 113 => 0x4e },
	'customcontrols' => { 88 => 0x70c },
	'customdefaultunsharpfineness' => { 113 => 0xbe },
	'customdefaultunsharpstrength' => { 113 => 0xbc },
	'customdefaultunsharpthreshold' => { 113 => 0xc0 },
	'customilluminant' => { 142 => 0x405 },
	'customizedials' => { 88 => 0x715 },
	'customlinear' => { 113 => 0x4f },
	'customoutputhighlightpoint' => { 113 => 0x53 },
	'customoutputshadowpoint' => { 113 => 0x54 },
	'custompicturestyle' => { 107 => 0x10021 },
	'custompicturestyledata' => { 107 => 0xf0500 },
	'custompicturestylefilename' => { 67 => 0x4010 },
	'customrawhighlight' => { 113 => 0x7c },
	'customrawhighlightpoint' => { 113 => 0x51 },
	'customrawshadow' => { 113 => 0x85 },
	'customrawshadowpoint' => { 113 => 0x52 },
	'customrendered' => { 123 => 0xa401, 195 => 0x6420, 520 => 'CustomRendered' },
	'customsaturation' => { 113 => 0x4d, 325 => 0x503 },
	'customsettingsalldefault' => { 305 => '0.2', 314 => '0.2' },
	'customsettingsbank' => { 305 => '0.1', 306 => '0.1', 308 => '0.1', 309 => '0.1', 314 => '0.1', 318 => '0.2', 319 => '0.2', 321 => 0x1, 322 => 0x1, 323 => 0x1 },
	'customsharpness' => { 113 => 0x50 },
	'customunsharpmaskfineness' => { 113 => 0xb8 },
	'customunsharpmaskstrength' => { 113 => 0xb6 },
	'customunsharpmaskthreshold' => { 113 => 0xba },
	'customwb_rblevels' => { 456 => 0x1a },
	'customwb_rgblevels' => { 438 => 0x8, 439 => 0x19 },
	'customwbbluelevel' => { 188 => 0x36 },
	'customwberror' => { 188 => 0x37 },
	'customwbgreenlevel' => { 188 => 0x35 },
	'customwbredlevel' => { 188 => 0x34 },
	'customwbsetting' => { 188 => 0x26 },
	'cx' => { 410 => '_cx_' },
	'cy' => { 410 => '_cy_' },
	'd-lightinghq' => { 298 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 294 => 0x2 },
	'd-lightinghqhighlight' => { 294 => 0x1 },
	'd-lightinghqselected' => { 298 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 294 => 0x0 },
	'd-lightinghs' => { 298 => 0xce5554aa },
	'd-lightinghsadjustment' => { 295 => 0x0 },
	'd-lightinghscolorboost' => { 295 => 0x1 },
	'd-rangeoptimizerhighlight' => { 488 => 0x8024 },
	'd-rangeoptimizermode' => { 488 => 0x8022 },
	'd-rangeoptimizershadow' => { 488 => 0x802d },
	'd-rangeoptimizervalue' => { 488 => 0x8023 },
	'darkblacksegrows' => { 142 => 0x18d8 },
	'darkfocusenvironment' => { 349 => 0x8003 },
	'darkframecountfactor' => { 142 => 0xc85 },
	'darkframelongexposure' => { 142 => 0xc84 },
	'darkframeshortexposure' => { 142 => 0xc83 },
	'darkpedestal' => { 142 => 0xc7f },
	'datacompressionmethod' => { 137 => 0x6e },
	'dataimprint' => { 185 => 0x34 },
	'datamining' => { 335 => 'DataMining' },
	'dataonscreen' => { 528 => 'DataOnScreen' },
	'dataonscreenregion' => { 528 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 528 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 528 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 528 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 528 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 528 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 528 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 528 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 385 => 0x3d },
	'date' => { 385 => 0x6, 517 => 'date' },
	'dateacquired' => { 182 => 'DateAcquired', 183 => '{2CBAA8F5-D81F-47CA-B17A-F8D822300131} 100' },
	'datecreated' => { 135 => 0x37, 531 => 'DateCreated' },
	'datedisplayformat' => { 290 => 0x3 },
	'dateidentified' => { 122 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 310 => '4.2' },
	'daterecieved' => { 533 => 'dateRecieved' },
	'datesent' => { 136 => 0x46 },
	'datestampmode' => { 67 => 0x1c, 240 => 0x9d },
	'datetime' => { 509 => 'datetime', 539 => 'DateTime' },
	'datetimedigitized' => { 520 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 104 => 0x0, 123 => 0x9003, 158 => 0x14, 161 => 'OriginalDate', 405 => 'IDIT', 410 => 'date', 411 => 0xb, 412 => 0x3b, 413 => 0x3e, 520 => 'DateTimeOriginal' },
	'datetimestamp' => { 144 => 0x64 },
	'datetimeutc' => { 325 => 0x908 },
	'daylightsavings' => { 81 => 0x3, 290 => 0x2 },
	'dayofweek' => { 412 => 0x42, 413 => 0x4a },
	'dccontinent' => { 122 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 122 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 122 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 122 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 122 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 122 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 122 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 122 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 122 => 'Event' },
	'dcfootprintspatialfit' => { 122 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 122 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 122 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 122 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 122 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 122 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 122 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 122 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 122 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 122 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 122 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 122 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 122 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 122 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 122 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 122 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 122 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 122 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 122 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 122 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 122 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 122 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 122 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 122 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 122 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 122 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 122 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 122 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 122 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 122 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 122 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 122 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 122 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 122 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 122 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 122 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcverticaldatum' => { 122 => [\'dctermsLocation','dctermsLocationVerticalDatum'] },
	'dcwaterbody' => { 122 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 169 => 'Declination' },
	'decposition' => { 185 => 0x32 },
	'defaultautogray' => { 514 => 'DefaultAutoGray', 516 => 'DefaultAutoGray' },
	'defaultautotone' => { 514 => 'DefaultAutoTone', 516 => 'DefaultAutoTone' },
	'defaultblackrender' => { 123 => 0xc7a6 },
	'defaultcroporigin' => { 123 => 0xc61f },
	'defaultcropsize' => { 123 => 0xc620 },
	'defaulteraseoption' => { 88 => 0x813 },
	'defaultscale' => { 123 => 0xc61e },
	'defaultsspecifictoiso' => { 514 => 'DefaultsSpecificToISO', 516 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 514 => 'DefaultsSpecificToSerial', 516 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 123 => 0xc7b5 },
	'defectisocode' => { 142 => 0x90f },
	'defringe' => { 514 => 'Defringe', 516 => 'Defringe' },
	'defringegreenamount' => { 514 => 'DefringeGreenAmount', 516 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 514 => 'DefringeGreenHueHi', 516 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 514 => 'DefringeGreenHueLo', 516 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 514 => 'DefringePurpleAmount', 516 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 514 => 'DefringePurpleHueHi', 516 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 514 => 'DefringePurpleHueLo', 516 => 'DefringePurpleHueLo' },
	'dehaze' => { 514 => 'Dehaze', 516 => 'Dehaze' },
	'deletedimagecount' => { 240 => 0xa6, 269 => 0x6e },
	'deprecatedon' => { 512 => 'deprecatedOn' },
	'depthbasedcorrcorrectionactive' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionActive'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionActive'] },
	'depthbasedcorrcorrectionamount' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionAmount'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionAmount'] },
	'depthbasedcorrcorrectionsyncid' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionSyncID'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionSyncID'] },
	'depthbasedcorrections' => { 514 => 'DepthBasedCorrections', 516 => 'DepthBasedCorrections' },
	'depthbasedcorrlocalcorrecteddepth' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCorrectedDepth'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCorrectedDepth'] },
	'depthbasedcorrlocalcurverefinesaturation' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCurveRefineSaturation'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCurveRefineSaturation'] },
	'depthbasedcorrmask' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasks'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasks'] },
	'depthbasedcorrmaskalpha' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAlpha'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAlpha'] },
	'depthbasedcorrmaskangle' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAngle'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAngle'] },
	'depthbasedcorrmaskbottom' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksBottom'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksBottom'] },
	'depthbasedcorrmaskcentervalue' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterValue'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterValue'] },
	'depthbasedcorrmaskcenterweight' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterWeight'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterWeight'] },
	'depthbasedcorrmaskdabs' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksDabs'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksDabs'] },
	'depthbasedcorrmaskfeather' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFeather'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFeather'] },
	'depthbasedcorrmaskflipped' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlipped'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlipped'] },
	'depthbasedcorrmaskflow' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlow'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlow'] },
	'depthbasedcorrmaskfullx' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullX'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullX'] },
	'depthbasedcorrmaskfully' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullY'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullY'] },
	'depthbasedcorrmaskinputdigest' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksInputDigest'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksInputDigest'] },
	'depthbasedcorrmaskleft' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksLeft'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksLeft'] },
	'depthbasedcorrmaskmaskactive' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskActive'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskActive'] },
	'depthbasedcorrmaskmaskblendmode' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskBlendMode'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'depthbasedcorrmaskmaskdigest' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskDigest'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskDigest'] },
	'depthbasedcorrmaskmaskinverted' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskInverted'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskInverted'] },
	'depthbasedcorrmaskmaskname' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskName'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskName'] },
	'depthbasedcorrmaskmasks' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasks'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasks'] },
	'depthbasedcorrmaskmasksalpha' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAlpha'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'depthbasedcorrmaskmasksangle' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAngle'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAngle'] },
	'depthbasedcorrmaskmasksbottom' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksBottom'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksBottom'] },
	'depthbasedcorrmaskmaskscentervalue' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterValue'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'depthbasedcorrmaskmaskscenterweight' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterWeight'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'depthbasedcorrmaskmasksdabs' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksDabs'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksDabs'] },
	'depthbasedcorrmaskmasksfeather' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFeather'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFeather'] },
	'depthbasedcorrmaskmasksflipped' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlipped'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'depthbasedcorrmaskmasksflow' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlow'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlow'] },
	'depthbasedcorrmaskmasksfullx' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullX'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullX'] },
	'depthbasedcorrmaskmasksfully' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullY'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullY'] },
	'depthbasedcorrmaskmasksinputdigest' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksInputDigest'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'depthbasedcorrmaskmasksleft' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksLeft'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksLeft'] },
	'depthbasedcorrmaskmasksmaskactive' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskActive'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'depthbasedcorrmaskmasksmaskblendmode' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'depthbasedcorrmaskmasksmaskdigest' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskDigest'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'depthbasedcorrmaskmasksmaskinverted' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskInverted'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'depthbasedcorrmaskmasksmaskname' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskName'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'depthbasedcorrmaskmasksmasksubtype' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSubType'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'depthbasedcorrmaskmasksmasksyncid' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'depthbasedcorrmaskmasksmaskversion' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskVersion'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'depthbasedcorrmaskmasksmidpoint' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMidpoint'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'depthbasedcorrmaskmasksorigin' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksOrigin'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'depthbasedcorrmaskmasksperimetervalue' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'depthbasedcorrmaskmasksradius' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRadius'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRadius'] },
	'depthbasedcorrmaskmasksreferencepoint' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksReferencePoint'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'depthbasedcorrmaskmasksright' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRight'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRight'] },
	'depthbasedcorrmaskmasksroundness' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRoundness'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'depthbasedcorrmaskmaskssizex' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeX'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'depthbasedcorrmaskmaskssizey' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeY'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'depthbasedcorrmaskmaskstop' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksTop'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksTop'] },
	'depthbasedcorrmaskmasksubtype' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSubType'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSubType'] },
	'depthbasedcorrmaskmasksvalue' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskValue'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'depthbasedcorrmaskmasksversion' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksVersion'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksVersion'] },
	'depthbasedcorrmaskmaskswhat' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWhat'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWhat'] },
	'depthbasedcorrmaskmaskswholeimagearea' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'depthbasedcorrmaskmasksx' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksX'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksX'] },
	'depthbasedcorrmaskmasksy' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksY'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksY'] },
	'depthbasedcorrmaskmasksyncid' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSyncID'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'depthbasedcorrmaskmaskszerox' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroX'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'depthbasedcorrmaskmaskszeroy' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroY'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'depthbasedcorrmaskmaskversion' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskVersion'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskVersion'] },
	'depthbasedcorrmaskmidpoint' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMidpoint'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMidpoint'] },
	'depthbasedcorrmaskorigin' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksOrigin'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksOrigin'] },
	'depthbasedcorrmaskperimetervalue' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksPerimeterValue'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'depthbasedcorrmaskradius' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRadius'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRadius'] },
	'depthbasedcorrmaskrange' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'depthbasedcorrmaskrangeareamodels' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'depthbasedcorrmaskrangeareamodelscolorsampleinfo' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'depthbasedcorrmaskrangeareamodelscomponents' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'depthbasedcorrmaskrangecoloramount' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'depthbasedcorrmaskrangedepthfeather' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'depthbasedcorrmaskrangedepthmax' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'depthbasedcorrmaskrangedepthmin' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'depthbasedcorrmaskrangeinvert' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'depthbasedcorrmaskrangelumfeather' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'depthbasedcorrmaskrangeluminancedepthsampleinfo' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'depthbasedcorrmaskrangelummax' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'depthbasedcorrmaskrangelummin' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'depthbasedcorrmaskrangelumrange' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'depthbasedcorrmaskrangesampletype' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'depthbasedcorrmaskrangetype' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'depthbasedcorrmaskrangeversion' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'depthbasedcorrmaskreferencepoint' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksReferencePoint'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksReferencePoint'] },
	'depthbasedcorrmaskright' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRight'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRight'] },
	'depthbasedcorrmaskroundness' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRoundness'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRoundness'] },
	'depthbasedcorrmasksizex' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeX'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeX'] },
	'depthbasedcorrmasksizey' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeY'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeY'] },
	'depthbasedcorrmasktop' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksTop'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksTop'] },
	'depthbasedcorrmaskvalue' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskValue'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskValue'] },
	'depthbasedcorrmaskversion' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksVersion'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksVersion'] },
	'depthbasedcorrmaskwhat' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWhat'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWhat'] },
	'depthbasedcorrmaskwholeimagearea' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWholeImageArea'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'depthbasedcorrmaskx' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksX'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksX'] },
	'depthbasedcorrmasky' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksY'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksY'] },
	'depthbasedcorrmaskzerox' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroX'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroX'] },
	'depthbasedcorrmaskzeroy' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroY'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroY'] },
	'depthbasedcorrwhat' => { 514 => [\'DepthBasedCorrections','DepthBasedCorrectionsWhat'], 516 => [\'DepthBasedCorrections','DepthBasedCorrectionsWhat'] },
	'depthfar' => { 123 => 0xc7eb },
	'depthformat' => { 123 => 0xc7e9 },
	'depthimage' => { 499 => 'Data' },
	'depthmapinfo' => { 514 => 'DepthMapInfo', 516 => 'DepthMapInfo' },
	'depthmapinfobasehighlightguideinputdigest' => { 514 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideInputDigest'], 516 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideInputDigest'] },
	'depthmapinfobasehighlightguidetable' => { 514 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideTable'], 516 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideTable'] },
	'depthmapinfobasehighlightguideversion' => { 514 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideVersion'], 516 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideVersion'] },
	'depthmapinfobaselayereddepthinputdigest' => { 514 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthInputDigest'], 516 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthInputDigest'] },
	'depthmapinfobaselayereddepthtable' => { 514 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthTable'], 516 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthTable'] },
	'depthmapinfobaselayereddepthversion' => { 514 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthVersion'], 516 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthVersion'] },
	'depthmapinfobaserawdepthinputdigest' => { 514 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthInputDigest'], 516 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthInputDigest'] },
	'depthmapinfobaserawdepthtable' => { 514 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthTable'], 516 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthTable'] },
	'depthmapinfobaserawdepthversion' => { 514 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthVersion'], 516 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthVersion'] },
	'depthmapinfodepthsource' => { 514 => [\'DepthMapInfo','DepthMapInfoDepthSource'], 516 => [\'DepthMapInfo','DepthMapInfoDepthSource'] },
	'depthmeasuretype' => { 123 => 0xc7ed },
	'depthnear' => { 123 => 0xc7ea },
	'depthunits' => { 123 => 0xc7ec },
	'derivedfrom' => { 544 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 544 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 544 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 544 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 544 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 544 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 544 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 544 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 544 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 544 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 544 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 544 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 544 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 544 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 544 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 544 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 544 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 544 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 544 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 544 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 544 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 544 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 544 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 544 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 183 => 'Description', 338 => 'Description', 402 => ['desc','dscp',"\xa9des"], 404 => 'description', 410 => 'dscp', 514 => 'Description', 516 => 'Description', 517 => 'description', 541 => 'Description' },
	'destination' => { 136 => 0x5 },
	'destinationcity' => { 385 => 0x24, 391 => 0x3 },
	'destinationcitycode' => { 392 => 0x1001 },
	'destinationdst' => { 385 => 0x26, 391 => '0.3' },
	'developmentdynamicrange' => { 131 => 0x1403 },
	'deviantmatrixcustom' => { 142 => 0x7de },
	'deviantmatrixdaylight' => { 142 => 0x7da },
	'deviantmatrixflash' => { 142 => 0x7dd },
	'deviantmatrixfluorescent' => { 142 => 0x7dc },
	'deviantmatrixtungsten' => { 142 => 0x7db },
	'deviantwhitecustom' => { 142 => 0x842 },
	'deviantwhitedaylight' => { 142 => 0x83e },
	'deviantwhiteflash' => { 142 => 0x841 },
	'deviantwhitefluorescent' => { 142 => 0x840 },
	'deviantwhitetungsten' => { 142 => 0x83f },
	'device' => { 533 => 'device' },
	'devicesettingdescription' => { 520 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 520 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 520 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 520 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 424 => 0x2 },
	'dewarpdata' => { 120 => 'DewarpData' },
	'dewarpflag' => { 120 => 'DewarpFlag' },
	'dialdirectiontvav' => { 88 => 0x706 },
	'dietaryneeds' => { 535 => 'dietaryNeeds' },
	'diffractioncompensation' => { 229 => 0x20e, 244 => 0x142, 245 => 0x1b2, 246 => 0x1b2, 247 => 0x1a2, 248 => 0x1b6, 249 => 0x1b6 },
	'diffractioncorrection' => { 349 => 0xbc, 374 => 0x3 },
	'diffractioncorrectionon' => { 107 => 0x2070b },
	'digitalcreationdate' => { 135 => 0x3e },
	'digitalcreationtime' => { 135 => 0x3f },
	'digitaldeehighlightadj' => { 264 => 0x202 },
	'digitaldeeshadowadj' => { 264 => 0x200 },
	'digitaldeethreshold' => { 264 => 0x201 },
	'digitalfilter' => { 427 => 0x59 },
	'digitalfilter01' => { 371 => 0x5 },
	'digitalfilter02' => { 371 => 0x16 },
	'digitalfilter03' => { 371 => 0x27 },
	'digitalfilter04' => { 371 => 0x38 },
	'digitalfilter05' => { 371 => 0x49 },
	'digitalfilter06' => { 371 => 0x5a },
	'digitalfilter07' => { 371 => 0x6b },
	'digitalfilter08' => { 371 => 0x7c },
	'digitalfilter09' => { 371 => 0x8d },
	'digitalfilter10' => { 371 => 0x9e },
	'digitalfilter11' => { 371 => 0xaf },
	'digitalfilter12' => { 371 => 0xc0 },
	'digitalfilter13' => { 371 => 0xd1 },
	'digitalfilter14' => { 371 => 0xe2 },
	'digitalfilter15' => { 371 => 0xf3 },
	'digitalfilter16' => { 371 => 0x104 },
	'digitalfilter17' => { 371 => 0x115 },
	'digitalfilter18' => { 371 => 0x126 },
	'digitalfilter19' => { 371 => 0x137 },
	'digitalfilter20' => { 371 => 0x148 },
	'digitalgain' => { 77 => 0xb },
	'digitalgem' => { 224 => 0x0 },
	'digitalice' => { 264 => 0x100 },
	'digitalimageguid' => { 528 => 'DigImageGUID' },
	'digitallensoptimizer' => { 65 => 0xa },
	'digitallensoptimizersetting' => { 83 => 0x9 },
	'digitalroc' => { 261 => 0x0 },
	'digitalsourcefiletype' => { 528 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 528 => 'DigitalSourceType' },
	'digitalzoom' => { 36 => 0xc, 116 => 0xa, 131 => 0x1044, 144 => 0x68, 155 => 0x22, 156 => 0x1e, 160 => 'DigitalZoom', 185 => 0xc, 240 => 0x86, 287 => 0xa, 330 => 0x204, 385 => 0x1e, 392 => 0xa, 426 => 0x204, 474 => 0x12, 475 => 0x12 },
	'digitalzoomon' => { 426 => 0x21b },
	'digitalzoomratio' => { 123 => 0xa404, 462 => 0x200, 464 => 0x21c, 520 => 'DigitalZoomRatio' },
	'director' => { 183 => 'WM/Director', 402 => "\xa9dir", 404 => 'director', 410 => "\xa9dir", 543 => 'director' },
	'directorphotography' => { 543 => 'directorPhotography' },
	'directory' => { 124 => 'Directory' },
	'directoryindex' => { 7 => 0x137, 9 => 0x2dc, 11 => 0x17e, 13 => 0x238, 14 => 0x13f, 15 => 0x133, 16 => 0x1df, 17 => 0x1a7, 18 => 0x1f0, 19 => 0xcc, 20 => 0x1c7, 21 => 0x298, 22 => 0x1e7, 23 => 0x1e5, 24 => [0x27c,0x280], 25 => 0x2b6, 26 => 0x2bf, 28 => 0x1f7, 29 => 0x4ba, 30 => 0xb21 },
	'directoryindex2' => { 21 => 0x29c },
	'directoryitem' => { 497 => [\'Directory','DirectoryItem'] },
	'directoryitemlabel' => { 497 => [\'Directory','DirectoryItemLabel'] },
	'directoryitemlength' => { 497 => [\'Directory','DirectoryItemLength'] },
	'directoryitemmime' => { 497 => [\'Directory','DirectoryItemMime'] },
	'directoryitempadding' => { 497 => [\'Directory','DirectoryItemPadding'] },
	'directoryitemsemantic' => { 497 => [\'Directory','DirectoryItemSemantic'] },
	'directoryitemuri' => { 497 => [\'Directory','DirectoryItemURI'] },
	'directorynumber' => { 217 => 0x3, 413 => 0x12 },
	'disableautocreation' => { 496 => 'DisableAutoCreation' },
	'disablesuggestedaction' => { 496 => 'DisableSuggestedAction' },
	'disclaimer' => { 338 => 'Disclaimer' },
	'discnumber' => { 543 => 'discNumber' },
	'dishtype' => { 535 => 'dishType' },
	'disknumber' => { 402 => 'disk' },
	'dispbutton' => { 249 => 0x7d4, 321 => 0x2ab },
	'displayallafpoints' => { 88 => 0x514 },
	'displayaperture' => { 36 => 0x23 },
	'displayedunitsx' => { 400 => 0x2 },
	'displayedunitsy' => { 400 => 0x6 },
	'displayname' => { 404 => 'displayname', 532 => 'displayName' },
	'distance1' => { 144 => 0x28 },
	'distance2' => { 144 => 0x2c },
	'distance3' => { 144 => 0x30 },
	'distance4' => { 144 => 0x34 },
	'distortion' => { 424 => 0xa050 },
	'distortioncompensation' => { 488 => 0x8040 },
	'distortioncontrol' => { 269 => 0x10 },
	'distortioncorrection' => { 82 => 0x3, 107 => 0x20705, 113 => 0x67, 123 => 0x7036, 215 => 0x4, 325 => 0x50b, 353 => '7.1', 374 => 0x0, 482 => 0x601, 483 => 0x5b },
	'distortioncorrection2' => { 329 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 511 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 107 => '0x20705.0', 113 => 0x63 },
	'distortioncorrectionsetting' => { 83 => 0x7, 451 => 0x2013 },
	'distortioncorrectionvalue' => { 82 => 0x9 },
	'distortioncorrectionversion' => { 215 => 0x0 },
	'distortioncorrparams' => { 123 => 0x7037, 461 => 0x1a23, 464 => 0x1870, 466 => 0x189c, 467 => 0x18cc, 468 => 0x17d0, 482 => 0x6ca, 483 => 0x64 },
	'distortioncorrparamsnumber' => { 464 => 0x1899, 466 => 0x18c5, 467 => 0x18f5, 468 => 0x17f9 },
	'distortioncorrparamspresent' => { 464 => 0x1898, 466 => 0x18c4, 467 => 0x18f4, 468 => 0x17f8, 470 => 0x10b, 471 => 0x10b, 482 => 0x600, 483 => 0x5a },
	'distortioneffect' => { 107 => 0x20709 },
	'distortionn' => { 353 => 0xc },
	'distortionparam02' => { 353 => 0x2 },
	'distortionparam04' => { 353 => 0x4 },
	'distortionparam08' => { 353 => 0x8 },
	'distortionparam09' => { 353 => 0x9 },
	'distortionparam11' => { 353 => 0xb },
	'distortionscale' => { 353 => 0x5 },
	'distributor' => { 533 => 'distributor' },
	'distributorproductid' => { 532 => 'distributorProductID' },
	'dloon' => { 107 => '0x20706.0', 113 => 0xdc },
	'dlosetting' => { 107 => 0x20706, 113 => 0xdd },
	'dlosettingapplied' => { 106 => 0x4 },
	'dloshootingdistance' => { 113 => 0xde },
	'dloversion' => { 106 => 0x5 },
	'dmcomment' => { 543 => 'comment' },
	'dmdithermatrix' => { 142 => 0xc7a },
	'dmdithermatrixheight' => { 142 => 0xc7c },
	'dmdithermatrixwidth' => { 142 => 0xc7b },
	'dngadobedata' => { 123 => 0xc634 },
	'dngbackwardversion' => { 123 => 0xc613 },
	'dngignoresidecars' => { 514 => 'DNGIgnoreSidecars', 516 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 123 => 0xc630 },
	'dngprivatedata' => { 123 => 0xc634 },
	'dngversion' => { 123 => 0xc612 },
	'document' => { 338 => 'Document' },
	'documentancestors' => { 531 => 'DocumentAncestors' },
	'documenthistory' => { 135 => 0xe7 },
	'documentid' => { 544 => 'DocumentID' },
	'documentname' => { 123 => 0x10d },
	'documentnotes' => { 135 => 0xe6 },
	'doi' => { 533 => 'doi' },
	'dopesheet' => { 528 => 'Dopesheet' },
	'dopesheetlink' => { 528 => 'DopesheetLink' },
	'dopesheetlinklink' => { 528 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 528 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 142 => 0xc82 },
	'dpp' => { 509 => 'dpp' },
	'dprawbokehshift' => { 107 => 0x20b20 },
	'dprawbokehshiftarea' => { 107 => 0x20b21 },
	'dprawghostingreductionarea' => { 107 => 0x20b30 },
	'dprawmicroadjustbackfront' => { 107 => 0x20b10 },
	'dprawmicroadjuststrength' => { 107 => 0x20b12 },
	'dr4cameramodel' => { 108 => 0x3 },
	'drangepriority' => { 131 => 0x1443 },
	'drangepriorityauto' => { 131 => 0x1444 },
	'drangepriorityfixed' => { 131 => 0x1445 },
	'drivemode' => { 117 => 0x3103, 129 => '0.1', 185 => 0x6, 188 => 0x1e, 191 => 0xe, 195 => 0x64d0, 325 => 0x600, 385 => 0x34, 417 => 0x1002, 427 => 0x3, 437 => 0x4, 438 => 0x7e, 439 => 0x34 },
	'drivemode2' => { 188 => 0xa, 365 => 0x7, 448 => 0xe, 456 => 0x1 },
	'drivemodesetting' => { 439 => 0x4 },
	'drivespeed' => { 129 => '0.2' },
	'dspfirmwareversion' => { 385 => 0x27 },
	'dualpixelraw' => { 65 => 0xb },
	'duration' => { 70 => 0x6a, 159 => 'Duration', 173 => 'Duration', 535 => 'duration', 543 => 'duration' },
	'durationscale' => { 543 => [\'duration','durationScale'] },
	'durationvalue' => { 543 => [\'duration','durationValue'] },
	'dustremovaldata' => { 67 => 0x97 },
	'dxcropalert' => { 245 => 0x250, 246 => 0x250, 247 => 0x23c, 248 => 0x250, 249 => 0x250 },
	'dynamicafarea' => { 305 => '1.4', 314 => '1.4' },
	'dynamicafareasize' => { 245 => 0x254, 246 => 0x254, 247 => 0x240, 248 => 0x254, 249 => 0x254 },
	'dynamicareaafassist' => { 321 => 0x18, 322 => 0x18, 323 => 0x18 },
	'dynamicareaafdisplay' => { 306 => '46.1', 308 => '47.1', 309 => '47.1', 318 => '47.1', 319 => '47.1' },
	'dynamicrange' => { 131 => 0x1400 },
	'dynamicrangeboost' => { 349 => 0xee },
	'dynamicrangeexpansion' => { 385 => 0x69, 417 => 0x100e },
	'dynamicrangemax' => { 112 => 0x7c },
	'dynamicrangemin' => { 112 => 0x7a },
	'dynamicrangeoptimizer' => { 188 => 0x15, 451 => [0xb025,0xb04f], 460 => 0x1144, 461 => [0x1144,0x324], 462 => [0x1120,0x300], 463 => [0x119c,0x37c], 464 => [0x1178,0x328], 465 => [0x1030,0x50], 466 => [0x228,0x50], 467 => [0x228,0x50], 468 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 448 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 437 => 0x19, 438 => 0x17, 439 => 0xd, 448 => 0x79, 456 => 0x5 },
	'dynamicrangeoptimizermode' => { 191 => 0x15, 437 => 0x18, 438 => 0x16, 448 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 188 => 0x27, 439 => 0xc, 456 => 0x4 },
	'dynamicrangesetting' => { 131 => 0x1402 },
	'e-dialinprogram' => { 365 => '1.3' },
	'earliestageorloweststage' => { 122 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 122 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 122 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 122 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 122 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'earthpos' => { 492 => 'EarthPos' },
	'earthposaltitude' => { 492 => [\'EarthPos','EarthPosAltitude'] },
	'earthposlatitude' => { 492 => [\'EarthPos','EarthPosLatitude'] },
	'earthposlongitude' => { 492 => [\'EarthPos','EarthPosLongitude'] },
	'earthposrotationw' => { 492 => [\'EarthPos','EarthPosRotationW'] },
	'earthposrotationx' => { 492 => [\'EarthPos','EarthPosRotationX'] },
	'earthposrotationy' => { 492 => [\'EarthPos','EarthPosRotationY'] },
	'earthposrotationz' => { 492 => [\'EarthPos','EarthPosRotationZ'] },
	'earthpostimestamp' => { 492 => [\'EarthPos','EarthPosTimestamp'] },
	'easyexposurecomp' => { 320 => '6.1' },
	'easyexposurecompensation' => { 305 => '6.4', 306 => '6.5', 308 => '6.3', 309 => '6.3', 313 => '5.1', 314 => '4.4', 315 => '5.2', 318 => '6.3', 319 => '6.3', 321 => 0x1d, 322 => 0x1d, 323 => 0x1d },
	'easymode' => { 36 => 0xb },
	'edgemapslope' => { 142 => 0x930 },
	'edgemapx1' => { 142 => 0x931 },
	'edgemapx2' => { 142 => 0x932 },
	'edgemapx3' => { 142 => 0x934 },
	'edgemapx4' => { 142 => 0x935 },
	'edgenoisereduction' => { 299 => 0x4, 488 => 0x8028 },
	'edit1' => { 410 => "\xa9ed1" },
	'edit2' => { 410 => "\xa9ed2" },
	'edit3' => { 410 => "\xa9ed3" },
	'edit4' => { 410 => "\xa9ed4" },
	'edit5' => { 410 => "\xa9ed5" },
	'edit6' => { 410 => "\xa9ed6" },
	'edit7' => { 410 => "\xa9ed7" },
	'edit8' => { 410 => "\xa9ed8" },
	'edit9' => { 410 => "\xa9ed9" },
	'edition' => { 533 => 'edition' },
	'editorialupdate' => { 135 => 0x8 },
	'editstatus' => { 135 => 0x7, 397 => 'EditStatus', 509 => 'EditStatus' },
	'editversionname' => { 298 => 0x3d136244 },
	'effectivelv' => { 385 => 0x2d },
	'effectivemaxaperture' => { 233 => 0x12, 234 => 0x13, 238 => 0x14 },
	'eissn' => { 533 => 'eIssn' },
	'electricalblackcolumns' => { 142 => 0x1810 },
	'electronicfront-curtainshutter' => { 308 => '5.2', 309 => '5.2', 318 => '5.3', 319 => '5.2' },
	'electronicfrontcurtainshutter' => { 451 => 0x201a },
	'elevation' => { 169 => 'Elevation' },
	'email' => { 161 => 'EMail' },
	'embargodate' => { 536 => 'embargoDate' },
	'embdencrightsexpr' => { 528 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 528 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 528 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 528 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 531 => 'EmbeddedXMPDigest' },
	'emissivity' => { 125 => 0x3 },
	'emptyslotrelease' => { 245 => 0x723, 246 => 0x733, 247 => 0x625, 248 => 0x655, 249 => 0x6bd },
	'enablechromanoisereduction' => { 142 => 0xe6e },
	'enablesharpening' => { 142 => 0x92e },
	'encodedby' => { 183 => 'WM/EncodedBy', 402 => "\xa9enc" },
	'encodedwith' => { 404 => 'Encoded_With' },
	'encoder' => { 402 => "\xa9too", 404 => 'encoder', 410 => "\xa9too" },
	'encoderid' => { 410 => "\xa9enc" },
	'encodingtime' => { 183 => 'WM/EncodingTime' },
	'encryptionkey' => { 424 => 0xa020 },
	'endingpage' => { 533 => 'endingPage' },
	'enduser' => { 335 => 'EndUser' },
	'enduserid' => { 335 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 335 => [\'EndUser','EndUserEndUserName'] },
	'energysavingmode' => { 245 => 0x746, 246 => 0x756, 247 => 0x648, 248 => 0x678, 249 => 0x6e0 },
	'engineer' => { 543 => 'engineer' },
	'enhancedarktones' => { 291 => 0x8 },
	'enhancedenoisealreadyapplied' => { 511 => 'EnhanceDenoiseAlreadyApplied' },
	'enhancedenoiselumaamount' => { 511 => 'EnhanceDenoiseLumaAmount' },
	'enhancedenoiseversion' => { 511 => 'EnhanceDenoiseVersion' },
	'enhancedetailsalreadyapplied' => { 511 => 'EnhanceDetailsAlreadyApplied' },
	'enhancedetailsversion' => { 511 => 'EnhanceDetailsVersion' },
	'enhancement' => { 116 => 0x16, 117 => 0x3016 },
	'enhanceparams' => { 123 => 0xc7ee },
	'enhancer' => { 329 => 0x300 },
	'enhancervalues' => { 329 => 0x301 },
	'enhancesuperresolutionalreadyapplied' => { 511 => 'EnhanceSuperResolutionAlreadyApplied' },
	'enhancesuperresolutionscale' => { 511 => 'EnhanceSuperResolutionScale' },
	'enhancesuperresolutionversion' => { 511 => 'EnhanceSuperResolutionVersion' },
	'envelopenumber' => { 136 => 0x28 },
	'envelopepriority' => { 136 => 0x3c },
	'enveloperecordversion' => { 136 => 0x0 },
	'episode' => { 528 => 'Episode' },
	'episodeglobaluniqueid' => { 402 => 'egid' },
	'episodeidentifier' => { 528 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 528 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 528 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 330 => 0x20c },
	'epsonimagewidth' => { 330 => 0x20b },
	'epsonsoftware' => { 330 => 0x20d },
	'equipmentinstitution' => { 491 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 491 => 'EquipmentManufacturer' },
	'equipmentversion' => { 326 => 0x0 },
	'ettlii' => { 88 => 0x304, 89 => 0xd, 90 => 0xe, 91 => 0x7, 92 => 0x7, 93 => 0xe },
	'event' => { 494 => 'Event', 507 => 'Event', 528 => 'Event', 533 => 'event' },
	'eventalias' => { 532 => 'eventAlias' },
	'eventdate' => { 122 => [\'Event','EventEventDate'] },
	'eventday' => { 122 => [\'Event','EventDay'] },
	'eventearliestdate' => { 122 => [\'Event','EventEarliestDate'] },
	'eventend' => { 532 => 'eventEnd' },
	'eventenddayofyear' => { 122 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 122 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 122 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 122 => [\'Event','EventHabitat'] },
	'eventid' => { 122 => [\'Event','EventEventID'], 528 => 'EventId' },
	'eventlatestdate' => { 122 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 122 => [\'Event','EventMonth'] },
	'eventnumber' => { 411 => 0x9, 412 => 0x37, 413 => 0x3a },
	'eventparenteventid' => { 122 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 122 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 122 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 122 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 122 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 122 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 532 => 'eventStart' },
	'eventstartdayofyear' => { 122 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 532 => 'eventSubtype' },
	'eventtime' => { 122 => [\'Event','EventEventTime'] },
	'eventtype' => { 532 => 'eventType' },
	'eventverbatimeventdate' => { 122 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 122 => [\'Event','EventYear'] },
	'evfgrid' => { 321 => 0x165, 322 => 0x165, 323 => 0x17d },
	'evfimageframe' => { 321 => 0x164, 322 => 0x164, 323 => 0x17c },
	'evfreleaseindicator' => { 321 => 0x24f, 322 => 0x24f, 323 => 0x267 },
	'evfwarmdisplaybrightness' => { 321 => 0x24d, 322 => 0x24d, 323 => 0x265 },
	'evfwarmdisplaymode' => { 321 => 0x24b, 322 => 0x24b, 323 => 0x263 },
	'evsteps' => { 365 => '1.2', 367 => 0x0 },
	'evstepsize' => { 310 => '5.1', 311 => '6.1', 312 => '6.1', 316 => '0.7' },
	'exclusivecoverage' => { 504 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 536 => 'exclusivityEndDate' },
	'excursiontolerance' => { 137 => 0x82 },
	'executiveproducer' => { 402 => "\xa9xpd" },
	'exif' => { 124 => 'EXIF' },
	'exifbyteorder' => { 124 => 'ExifByteOrder' },
	'exifcamerainfo' => { 135 => 0xe8 },
	'exifimageheight' => { 123 => 0xa003, 520 => 'PixelYDimension' },
	'exifimagewidth' => { 123 => 0xa002, 520 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 124 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 123 => 0x9000, 520 => 'ExifVersion' },
	'exitpupilposition' => { 233 => 0x4, 234 => 0x4, 238 => 0x4 },
	'expirationdate' => { 135 => 0x25, 536 => 'expirationDate' },
	'expirationtime' => { 135 => 0x26 },
	'exposure' => { 123 => 0xfe51, 514 => 'Exposure', 516 => 'Exposure' },
	'exposure2012' => { 514 => 'Exposure2012', 516 => 'Exposure2012' },
	'exposureadj' => { 296 => 0x0 },
	'exposureadj2' => { 296 => 0x12 },
	'exposureadjust' => { 427 => 0xc },
	'exposurebracketingindicatorlast' => { 188 => 0x52 },
	'exposurebracketshotnumber' => { 191 => 0x2d, 448 => 0x2f },
	'exposurebracketstepsize' => { 365 => 0x8 },
	'exposurebracketvalue' => { 240 => 0x19 },
	'exposurecompautocancel' => { 88 => 0x113 },
	'exposurecompensation' => { 80 => 0x6, 97 => 0x0, 123 => 0x9204, 144 => 0x24, 160 => 'ExposureComp', 180 => 'ExposureCompensation', 185 => 0xd, 186 => 0x53, 187 => 0x1e, 191 => 0x49c0, 330 => 0x1006, 385 => 0x16, 394 => 0x402, 424 => 0xa013, 427 => [0xc,0x35,0x4d], 460 => 0x114c, 461 => 0x114c, 462 => 0x1128, 464 => 0x1180, 465 => 0x1038, 466 => 0x230, 467 => 0x230, 468 => 0x223, 520 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 456 => [0x24,0x26,0x2a] },
	'exposurecompensationbutton' => { 249 => 0x794 },
	'exposurecompensationmode' => { 188 => 0x47, 191 => 0x2a },
	'exposurecompensationset' => { 437 => 0x3, 438 => 0x3, 439 => 0x3, 456 => 0x1e },
	'exposurecompensationsetting' => { 188 => 0x1 },
	'exposurecompstepsize' => { 305 => '6.3', 306 => '7.3', 308 => '7.3', 309 => '7.3', 314 => '4.3', 318 => '7.3', 319 => '7.3' },
	'exposurecontrolstep' => { 313 => '6.1', 315 => '6.1' },
	'exposurecontrolstepsize' => { 305 => '6.2', 306 => '7.1', 308 => '7.1', 309 => '7.1', 314 => '4.2', 318 => '7.1', 319 => '7.1', 320 => '7.1', 321 => 0x1b, 322 => 0x1b, 323 => 0x1b },
	'exposurecount' => { 131 => 0x1032 },
	'exposuredelay' => { 249 => 0x800, 321 => 0x2f1 },
	'exposuredelaymode' => { 305 => '10.1', 306 => '11.1', 308 => '11.1', 309 => '11.1', 310 => '9.1', 311 => '10.1', 312 => '10.1', 314 => '10.4', 315 => '10.1', 316 => '6.4', 318 => '11.1', 319 => '11.1', 320 => '11.2' },
	'exposuredifference' => { 240 => 0xe },
	'exposuregaincustom' => { 142 => 0x89c },
	'exposuregaindaylight' => { 142 => 0x898 },
	'exposuregainflash' => { 142 => 0x89b },
	'exposuregainfluorescent' => { 142 => 0x89a },
	'exposuregaintungsten' => { 142 => 0x899 },
	'exposureindex' => { 123 => 0xa215, 520 => 'ExposureIndex' },
	'exposureindicator' => { 188 => 0x50 },
	'exposurelevelincrements' => { 86 => 0x6, 87 => 0x6, 88 => 0x101, 89 => 0x5, 90 => 0x6, 91 => 0x5, 92 => 0x5, 93 => 0x6, 94 => 0x4, 437 => 0x58, 438 => 0x58 },
	'exposurelockused' => { 502 => 'ExposureLockUsed' },
	'exposuremode' => { 123 => 0xa402, 160 => 'ExposureMode', 185 => 0x1, 186 => 0xa, 187 => 0x0, 188 => 0x0, 191 => 0x34, 325 => 0x200, 346 => 0x40d, 427 => 0x8, 451 => 0xb041, 520 => 'ExposureMode' },
	'exposuremodeinmanual' => { 88 => 0x10b },
	'exposureprogram' => { 123 => 0x8822, 417 => 0x1001, 430 => [0x17e,0x43], 437 => 0x3c, 438 => 0x3c, 439 => 0x5, 443 => 0x14, 448 => 0x3f, 456 => 0x2, 460 => 0x1175, 461 => 0x1179, 462 => 0x1155, 463 => 0x11d1, 464 => 0x11ad, 465 => 0x1065, 466 => 0x25d, 467 => 0x25d, 468 => 0x24c, 479 => 0xb, 480 => 0xc, 481 => 0xb, 483 => 0x48, 520 => 'ExposureProgram' },
	'exposureshift' => { 325 => 0x203 },
	'exposurestandardadjustment' => { 451 => 0x202d },
	'exposuretime' => { 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x4, 31 => 0x6, 32 => 0x7, 80 => 0x16, 123 => 0x829a, 141 => 0xfd05, 144 => 0x20, 146 => 0xfa24, 148 => 0xf104, 151 => 0x12, 153 => 0x38, 155 => 0x14, 156 => 0x10, 158 => 0x10, 160 => 'ExposureTime', 185 => 0x9, 186 => 0x35, 187 => 0x48, 188 => 0x8, 191 => 0x49b8, 385 => 0x12, 424 => 0xa018, 427 => [0x32,0x4a], 437 => 0x0, 438 => 0x0, 456 => [0x21,0x23,0x27], 483 => 0x10, 520 => 'ExposureTime' },
	'exposuretime2' => { 427 => [0x33,0x4b] },
	'exposuretuning' => { 240 => 0x1c },
	'exposurevalue' => { 142 => 0x3 },
	'exposurewarning' => { 131 => 0x1302 },
	'exrauto' => { 131 => 0x1033 },
	'exrmode' => { 131 => 0x1034 },
	'extdescraccessibility' => { 527 => 'ExtDescrAccessibility' },
	'extendedmenubanks' => { 245 => 0x120, 246 => 0x120, 247 => 0x114, 248 => 0x124, 249 => 0x124 },
	'extendedshutterspeeds' => { 321 => 0x102, 322 => 0x102, 323 => 0x118 },
	'extendedwbdetect' => { 325 => 0x902 },
	'extender' => { 326 => 0x301 },
	'extenderfirmwareversion' => { 326 => 0x304 },
	'extendermagnification' => { 162 => 'Magnification' },
	'extendermake' => { 162 => 'Make' },
	'extendermodel' => { 162 => 'Model', 326 => 0x303 },
	'extenderserialnumber' => { 162 => 'SerialNumber', 326 => 0x302 },
	'extenderstatus' => { 382 => 0x3 },
	'externalflash' => { 328 => 0x1201 },
	'externalflashae1' => { 330 => 0x101f },
	'externalflashae1_0' => { 330 => 0x101b },
	'externalflashae2' => { 330 => 0x1020 },
	'externalflashae2_0' => { 330 => 0x101c },
	'externalflashbounce' => { 328 => 0x1204, 330 => 0x1026, 372 => 0x1a },
	'externalflashcompensation' => { 220 => 0x1b },
	'externalflashexposurecomp' => { 240 => 0x17, 372 => 0x19 },
	'externalflashfirmware' => { 218 => 0x6, 219 => 0x6, 220 => 0x6, 221 => 0x6, 222 => 0x6, 223 => 0x6 },
	'externalflashflags' => { 218 => 0x8, 219 => 0x8, 220 => 0x8, 221 => 0x8, 223 => 0x8 },
	'externalflashguidenumber' => { 328 => 0x1203, 372 => '24.1' },
	'externalflashgvalue' => { 330 => 0x1025 },
	'externalflashmode' => { 330 => 0x1028, 372 => 0x2 },
	'externalflashreadystate' => { 222 => '9.1' },
	'externalflashstatus' => { 222 => '8.2' },
	'externalflashzoom' => { 328 => 0x1205, 330 => 0x1027 },
	'externalflashzoomoverride' => { 222 => '8.1' },
	'externalmetadatalink' => { 528 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 344 => 0x311, 347 => 0x311, 348 => 0x311, 351 => 0x3408 },
	'extrainfoversion' => { 441 => 0x1a },
	'eyedetection' => { 2 => 0x18 },
	'eyestartaf' => { 188 => 0x40 },
	'fac100per' => { 142 => 0xe94 },
	'fac170per' => { 142 => 0xe93 },
	'fac18per' => { 142 => 0xe92 },
	'face10position' => { 114 => 0x3f4, 115 => 0x1ec, 216 => 0x28, 369 => 0x12 },
	'face10size' => { 370 => 0x12 },
	'face11position' => { 216 => 0x2c, 369 => 0x14 },
	'face11size' => { 370 => 0x14 },
	'face12position' => { 216 => 0x30, 369 => 0x16 },
	'face12size' => { 370 => 0x16 },
	'face13position' => { 369 => 0x18 },
	'face13size' => { 370 => 0x18 },
	'face14position' => { 369 => 0x1a },
	'face14size' => { 370 => 0x1a },
	'face15position' => { 369 => 0x1c },
	'face15size' => { 370 => 0x1c },
	'face16position' => { 369 => 0x1e },
	'face16size' => { 370 => 0x1e },
	'face17position' => { 369 => 0x20 },
	'face17size' => { 370 => 0x20 },
	'face18position' => { 369 => 0x22 },
	'face18size' => { 370 => 0x22 },
	'face19position' => { 369 => 0x24 },
	'face19size' => { 370 => 0x24 },
	'face1position' => { 56 => 0x8, 114 => 0xd, 115 => 0x18, 216 => 0x4, 341 => 0x1, 369 => 0x0, 414 => 0xbc, 444 => 0x1, 445 => 0x0, 446 => 0x0, 447 => 0x5b },
	'face1size' => { 370 => 0x0 },
	'face20position' => { 369 => 0x26 },
	'face20size' => { 370 => 0x26 },
	'face21position' => { 369 => 0x28 },
	'face21size' => { 370 => 0x28 },
	'face22position' => { 369 => 0x2a },
	'face22size' => { 370 => 0x2a },
	'face23position' => { 369 => 0x2c },
	'face23size' => { 370 => 0x2c },
	'face24position' => { 369 => 0x2e },
	'face24size' => { 370 => 0x2e },
	'face25position' => { 369 => 0x30 },
	'face25size' => { 370 => 0x30 },
	'face26position' => { 369 => 0x32 },
	'face26size' => { 370 => 0x32 },
	'face27position' => { 369 => 0x34 },
	'face27size' => { 370 => 0x34 },
	'face28position' => { 369 => 0x36 },
	'face28size' => { 370 => 0x36 },
	'face29position' => { 369 => 0x38 },
	'face29size' => { 370 => 0x38 },
	'face2position' => { 56 => 0xa, 114 => 0x7c, 115 => 0x4c, 216 => 0x8, 341 => 0x5, 369 => 0x2, 414 => 0xc8, 444 => 0x6, 445 => 0x20, 446 => 0x25, 447 => 0x65 },
	'face2size' => { 370 => 0x2 },
	'face30position' => { 369 => 0x3a },
	'face30size' => { 370 => 0x3a },
	'face31position' => { 369 => 0x3c },
	'face31size' => { 370 => 0x3c },
	'face32position' => { 369 => 0x3e },
	'face32size' => { 370 => 0x3e },
	'face3position' => { 56 => 0xc, 114 => 0xeb, 115 => 0x80, 216 => 0xc, 341 => 0x9, 369 => 0x4, 414 => 0xd4, 444 => 0xb, 445 => 0x40, 446 => 0x4a, 447 => 0x6f },
	'face3size' => { 370 => 0x4 },
	'face4position' => { 56 => 0xe, 114 => 0x15a, 115 => 0xb4, 216 => 0x10, 341 => 0xd, 369 => 0x6, 414 => 0xe0, 444 => 0x10, 445 => 0x60, 446 => 0x6f, 447 => 0x79 },
	'face4size' => { 370 => 0x6 },
	'face5position' => { 56 => 0x10, 114 => 0x1c9, 115 => 0xe8, 216 => 0x14, 341 => 0x11, 369 => 0x8, 414 => 0xec, 444 => 0x15, 445 => 0x80, 446 => 0x94 },
	'face5size' => { 370 => 0x8 },
	'face6position' => { 56 => 0x12, 114 => 0x238, 115 => 0x11c, 216 => 0x18, 369 => 0xa, 414 => 0xf8, 444 => 0x1a, 445 => 0xa0, 446 => 0xb9 },
	'face6size' => { 370 => 0xa },
	'face7position' => { 56 => 0x14, 114 => 0x2a7, 115 => 0x150, 216 => 0x1c, 369 => 0xc, 414 => 0x104, 444 => 0x1f, 445 => 0xc0, 446 => 0xde },
	'face7size' => { 370 => 0xc },
	'face8position' => { 56 => 0x16, 114 => 0x316, 115 => 0x184, 216 => 0x20, 369 => 0xe, 414 => 0x110, 444 => 0x24, 445 => 0xe0, 446 => 0x103 },
	'face8size' => { 370 => 0xe },
	'face9position' => { 56 => 0x18, 114 => 0x385, 115 => 0x1b8, 216 => 0x24, 369 => 0x10 },
	'face9size' => { 370 => 0x10 },
	'facebalanceorigi' => { 508 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 508 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 508 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 508 => 'FaceBalanceWarmth' },
	'facedetect' => { 385 => 0x76, 424 => 0x100 },
	'facedetectarea' => { 329 => 0x1201 },
	'facedetectframecrop' => { 329 => 0x1207 },
	'facedetectframesize' => { 56 => 0x3, 114 => 0x1, 115 => 0x4, 216 => 0x1, 329 => 0x1203, 385 => 0x77, 414 => 0xb6 },
	'facedetection' => { 439 => 0x30, 456 => 0x19 },
	'faceelementpositions' => { 131 => 0x4203 },
	'faceelementselected' => { 131 => 0x4005 },
	'faceelementtypes' => { 131 => 0x4201 },
	'faceid' => { 510 => 'FaceID' },
	'faceinfounknown' => { 117 => 0x2089 },
	'facename' => { 424 => 0x123 },
	'faceorientation' => { 115 => 0x8 },
	'faceposition' => { 368 => 0x2, 425 => 0x4 },
	'facepositions' => { 131 => 0x4103 },
	'facerecognition' => { 424 => 0x120 },
	'facesdetected' => { 56 => 0x2, 57 => 0x2, 58 => 0x3, 114 => 0x0, 115 => 0x2, 117 => 0x211c, 131 => 0x4100, 216 => 0x3, 329 => 0x1200, 349 => 0x3f, 368 => 0x0, 414 => 0xb5, 425 => 0x0, 444 => 0x0, 447 => 0x3, 459 => 0x30 },
	'facesrecognized' => { 342 => 0x0 },
	'facewidth' => { 57 => 0x1 },
	'fade' => { 451 => 0x2034 },
	'faithfuloutputhighlightpoint' => { 113 => 0x38 },
	'faithfuloutputshadowpoint' => { 113 => 0x39 },
	'faithfulrawcolortone' => { 113 => 0x31 },
	'faithfulrawcontrast' => { 113 => 0x33 },
	'faithfulrawhighlight' => { 113 => 0x79 },
	'faithfulrawhighlightpoint' => { 113 => 0x36 },
	'faithfulrawlinear' => { 113 => 0x34 },
	'faithfulrawsaturation' => { 113 => 0x32 },
	'faithfulrawshadow' => { 113 => 0x82 },
	'faithfulrawshadowpoint' => { 113 => 0x37 },
	'faithfulrawsharpness' => { 113 => 0x35 },
	'faithfulunsharpmaskfineness' => { 113 => 0xac },
	'faithfulunsharpmaskstrength' => { 113 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 113 => 0xae },
	'far' => { 499 => 'Far' },
	'fastresetlinetime' => { 142 => 0x1860 },
	'feedidentifier' => { 528 => 'FeedIdentifier' },
	'femicroadjustment' => { 88 => 0x111 },
	'ffid' => { 518 => 'ffid' },
	'field' => { 532 => 'field' },
	'fieldcount' => { 330 => 0x103f },
	'fieldofview' => { 410 => "FOV\x00" },
	'fifoenonepixeldelay' => { 142 => 0x1901 },
	'filecreatedate' => { 124 => 'FileCreateDate' },
	'filedatarate' => { 543 => 'fileDataRate' },
	'fileformat' => { 99 => 0x0, 136 => 0x14, 427 => [0x22,0x26], 451 => 0xb000 },
	'filegroupid' => { 124 => 'FileGroupID' },
	'fileindex' => { 7 => 0x143, 9 => 0x2d0, 11 => 0x172, 13 => 0x22c, 14 => 0x133, 15 => 0x13f, 16 => 0x1d3, 17 => 0x19b, 18 => 0x1e4, 19 => 0xd0, 20 => 0x1bb, 21 => 0x28c, 22 => 0x1db, 23 => 0x1d9, 24 => [0x270,0x274], 25 => 0x2aa, 26 => 0x2b3, 28 => 0x1eb, 29 => 0x4ae, 30 => 0xb2d, 350 => 0x0 },
	'fileindex2' => { 21 => 0x290 },
	'filemodifydate' => { 124 => 'FileModifyDate' },
	'filename' => { 124 => 'FileName' },
	'filenameasdelivered' => { 335 => 'FileNameAsDelivered' },
	'filenumber' => { 59 => 0x1, 67 => 0x8, 101 => 0x1817, 118 => 'Canon-FileNumber', 217 => 0x4, 413 => 0x10 },
	'filenumbermemory' => { 185 => 0x1a },
	'filenumbersequence' => { 305 => '12.2', 310 => '3.1', 311 => '4.1', 312 => '4.1', 314 => '11.1', 315 => '4.3', 320 => '5.2', 321 => 0x48, 322 => 0x48, 323 => 0x48 },
	'filepermissions' => { 124 => 'FilePermissions' },
	'filesource' => { 123 => 0xa300, 131 => 0x8000, 520 => 'FileSource' },
	'fileuserid' => { 124 => 'FileUserID' },
	'fileversion' => { 136 => 0x16 },
	'fillflashautoreduction' => { 86 => 0xe, 87 => 0xe, 94 => 0xa },
	'filllight' => { 514 => 'FillLight', 516 => 'FillLight' },
	'fillorder' => { 123 => 0x10a },
	'filmgraineffect' => { 325 => 0x538 },
	'filmmode' => { 131 => 0x1401, 346 => 0x412, 349 => 0x42 },
	'filmtype' => { 264 => 0x2 },
	'filtereffect' => { 59 => 0xe, 256 => 0x37, 257 => 0x3f, 258 => 0x47, 349 => 0xa1 },
	'filtereffectauto' => { 74 => 0xa0 },
	'filtereffectfaithful' => { 73 => 0x70, 74 => 0x70 },
	'filtereffectlandscape' => { 73 => 0x40, 74 => 0x40 },
	'filtereffectmonochrome' => { 19 => 0xff, 73 => 0x88, 74 => 0x88 },
	'filtereffectneutral' => { 73 => 0x58, 74 => 0x58 },
	'filtereffectportrait' => { 73 => 0x28, 74 => 0x28 },
	'filtereffectstandard' => { 73 => 0x10, 74 => 0x10 },
	'filtereffectuserdef1' => { 73 => 0xa0, 74 => 0xb8 },
	'filtereffectuserdef2' => { 73 => 0xb8, 74 => 0xd0 },
	'filtereffectuserdef3' => { 73 => 0xd0, 74 => 0xe8 },
	'finderdisplayduringexposure' => { 87 => 0x1 },
	'finesharpness' => { 385 => 0x70 },
	'finetuneoptcenterweighted' => { 305 => '7.2', 306 => '9.1', 308 => '9.1', 309 => '9.1', 313 => '8.1', 318 => '9.1', 319 => '9.1', 320 => '9.1', 321 => 0x23, 322 => 0x23, 323 => 0x23 },
	'finetuneopthighlightweighted' => { 308 => '46.1', 309 => '46.1', 318 => '46.1', 319 => '46.1', 321 => 0x27, 322 => 0x27, 323 => 0x27 },
	'finetuneoptmatrixmetering' => { 305 => '8.1', 306 => '8.2', 308 => '8.2', 309 => '8.2', 313 => '7.2', 314 => '6.1', 318 => '8.2', 319 => '8.2', 320 => '8.2', 321 => 0x21, 322 => 0x21, 323 => 0x21 },
	'finetuneoptspotmetering' => { 305 => '8.2', 306 => '9.2', 308 => '9.2', 309 => '9.2', 313 => '8.2', 314 => '6.2', 318 => '9.2', 319 => '9.2', 320 => '9.2', 321 => 0x25, 322 => 0x25, 323 => 0x25 },
	'finishexposure' => { 142 => 0xdbd },
	'finishfiletype' => { 142 => 0xdb8 },
	'finishlook' => { 142 => 0xdbc },
	'finishnoise' => { 142 => 0xdba },
	'finishresolution' => { 142 => 0xdb9 },
	'finishsharpening' => { 142 => 0xdbb },
	'firmware' => { 330 => 0x405, 427 => [0x8c,0x17,0x3b], 511 => 'Firmware' },
	'firmware2' => { 427 => 0x57 },
	'firmwaredate' => { 116 => 0x15, 117 => 0x2001, 411 => 0x4, 413 => 0x30 },
	'firmwareid' => { 192 => 0x0 },
	'firmwarename' => { 424 => 0xa001 },
	'firmwarerevision' => { 19 => 0xa4, 67 => 0x1e, 415 => 0x0 },
	'firmwarerevision2' => { 415 => 0xc },
	'firmwareversion' => { 7 => 0x10b, 11 => 0x136, 14 => 0xff, 15 => 0x107, 142 => [0x415,0xce5], 158 => 0x57, 160 => 'FirmwareVersion', 347 => 0x320, 349 => 0x2, 351 => 0x3109, 385 => 0x230, 410 => ['CNFV','FIRM','info'], 412 => 0x18, 413 => 0x2a, 417 => 0x2 },
	'firmwareversions' => { 394 => 0x301 },
	'firstphotodate' => { 502 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 335 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 135 => 0x16, 509 => 'FixtureIdentifier' },
	'flash' => { 118 => 'XMP-Flash', 123 => 0x9209, 156 => 0x22, 186 => 0x1f, 187 => 0x15, 413 => 0x5a, 520 => 'Flash' },
	'flashaction' => { 437 => 0x3e, 438 => 0x3e, 451 => 0x2017, 456 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 437 => 0x4c, 438 => 0x4c, 456 => 0x77 },
	'flashactionexternal' => { 456 => [0x78,0x7c] },
	'flashactivity' => { 36 => 0x1c },
	'flashbatterylevel' => { 46 => 0x249 },
	'flashbias' => { 349 => 0x24 },
	'flashbits' => { 36 => 0x1d },
	'flashburstpriority' => { 321 => 0x111, 322 => 0x111, 323 => 0x129 },
	'flashbuttonfunction' => { 88 => 0x70e },
	'flashchargelevel' => { 330 => 0x1010 },
	'flashcolorfilter' => { 220 => 0x10, 221 => 0x10, 223 => 0x10 },
	'flashcommandermode' => { 218 => '9.1', 219 => '9.1', 220 => '9.1', 221 => '9.1', 223 => '9.1' },
	'flashcompensation' => { 142 => 0x3f3, 218 => 0xa, 219 => 0xa, 220 => 0xa, 221 => 0x27, 222 => 0xa, 223 => 0xa, 511 => 'FlashCompensation' },
	'flashcontrol' => { 437 => 0x23, 438 => 0x1f, 439 => 0x21 },
	'flashcontrolbuilt-in' => { 314 => '16.1', 315 => '23.1', 317 => '23.1', 318 => '24.1' },
	'flashcontrolmode' => { 218 => '9.2', 219 => '9.2', 220 => '9.2', 221 => '9.2', 223 => '9.2', 229 => 0x214, 244 => 0x148, 245 => 0x1b8, 246 => 0x1b8, 247 => 0x1a8, 248 => 0x1bc, 249 => 0x1bc, 325 => 0x404 },
	'flashcurtain' => { 349 => 0x48 },
	'flashdefault' => { 188 => 0x42 },
	'flashdevice' => { 330 => 0x1005 },
	'flashdistance' => { 117 => 0x2034 },
	'flashenergy' => { 123 => 0xa20b, 520 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 240 => 0x18 },
	'flashexposurecomp' => { 80 => 0xf, 131 => 0x1011, 163 => 'ExposureComp', 185 => 0x23, 190 => 0x104, 191 => 0x49c1, 240 => 0x12, 325 => 0x401, 330 => 0x1023, 385 => 0x4d, 417 => 0x100b, 427 => [0x3a,0x56], 451 => 0x104 },
	'flashexposurecomp2' => { 285 => 0x4d2 },
	'flashexposurecomp3' => { 220 => 0x1d },
	'flashexposurecomp4' => { 220 => 0x27 },
	'flashexposurecomparea' => { 306 => '38.4', 308 => '38.4', 309 => '38.4', 318 => '38.4', 319 => '38.4', 321 => 0x59, 322 => 0x59, 323 => 0x59 },
	'flashexposurecompset' => { 188 => 0x10, 357 => 0xe, 437 => 0x14, 438 => 0x12, 439 => 0x23, 456 => 0x1f },
	'flashexposurecompset2' => { 456 => [0x26,0x2c] },
	'flashexposureindicator' => { 188 => 0x54 },
	'flashexposureindicatorlast' => { 188 => 0x56 },
	'flashexposureindicatornext' => { 188 => 0x55 },
	'flashexposurelock' => { 59 => 0x19 },
	'flashfired' => { 144 => 0x5d, 163 => 'Fired', 185 => 0x14, 284 => '590.3', 520 => [\'Flash','FlashFired'] },
	'flashfiring' => { 88 => 0x306, 89 => 0x6, 90 => 0x7, 93 => 0x7 },
	'flashfirmwareversion' => { 326 => 0x1002 },
	'flashfocallength' => { 218 => 0xb, 219 => 0xc, 220 => 0xc, 221 => 0xc, 222 => 0xc, 223 => 0x26 },
	'flashfunction' => { 191 => 0x31, 520 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 218 => 0xe, 219 => 0xf, 220 => 0xf, 221 => 0xf, 222 => 0xf, 223 => 0xf, 229 => 0x21a, 244 => 0x14e, 247 => 0x1ae, 248 => 0x1c2, 249 => 0x1c2 },
	'flashgroupacompensation' => { 218 => 0x11, 219 => 0x12, 220 => 0x13, 221 => 0x28, 222 => 0x28, 223 => 0x28 },
	'flashgroupacontrolmode' => { 218 => 0xf, 219 => '16.1', 220 => '17.1', 221 => '17.1', 222 => '17.1', 223 => '17.1' },
	'flashgroupaoutput' => { 218 => 0x11, 219 => 0x12, 220 => 0x13, 221 => 0x28, 222 => 0x28, 223 => 0x28 },
	'flashgroupbcompensation' => { 218 => 0x12, 219 => 0x13, 220 => 0x14, 221 => 0x29, 222 => 0x29, 223 => 0x29 },
	'flashgroupbcontrolmode' => { 218 => 0x10, 219 => '17.1', 220 => '18.1', 221 => '18.1', 222 => '18.1', 223 => '18.1' },
	'flashgroupboutput' => { 218 => 0x12, 219 => 0x13, 220 => 0x14, 221 => 0x29, 222 => 0x29, 223 => 0x29 },
	'flashgroupccompensation' => { 219 => 0x14, 220 => 0x15, 221 => 0x2a, 222 => 0x2a, 223 => 0x2a },
	'flashgroupccontrolmode' => { 219 => '17.2', 220 => '18.2', 221 => '18.2', 222 => '18.2', 223 => '18.2' },
	'flashgroupcoutput' => { 219 => 0x14, 220 => 0x15, 221 => 0x2a, 222 => 0x2a, 223 => 0x2a },
	'flashguidenumber' => { 80 => 0xd, 98 => 0x0, 163 => 'GuideNumber' },
	'flashilluminationpattern' => { 223 => 0x25 },
	'flashintensity' => { 116 => [0x19,0x5], 325 => 0x405 },
	'flashlevel' => { 307 => 0x9, 451 => 0xb048 },
	'flashmake' => { 163 => 'Make' },
	'flashmanufacturer' => { 182 => 'FlashManufacturer' },
	'flashmastercompensation' => { 229 => 0x22e, 244 => 0x162, 247 => 0x1aa, 248 => 0x1be, 249 => 0x1be },
	'flashmastercontrolmode' => { 229 => 0x22c, 244 => 0x160 },
	'flashmasteroutput' => { 229 => 0x232, 244 => 0x166 },
	'flashmetering' => { 185 => 0x3f, 188 => 0x1c },
	'flashmeteringmode' => { 7 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 18 => 0x15, 20 => 0x15, 22 => 0x15, 28 => 0x15 },
	'flashmeteringsegments' => { 385 => 0x20a },
	'flashmode' => { 116 => 0x4, 142 => 0x3f2, 144 => 0x5c, 155 => 0x27, 163 => 'Mode', 185 => 0x2, 186 => 0x20, 187 => 0x16, 188 => 0xf, 240 => 0x87, 325 => 0x400, 330 => 0x1004, 385 => 0xc, 392 => 0x4, 416 => 0x20, 417 => 0x100a, 426 => 0x225, 437 => 0x13, 438 => 0x7f, 439 => 0x20, 456 => 0x10, 460 => 0x1138, 461 => 0x1138, 462 => 0x1114, 463 => 0x1190, 464 => 0x116c, 465 => 0x1024, 466 => 0x21c, 467 => 0x21c, 468 => 0x211, 520 => [\'Flash','FlashMode'] },
	'flashmodebutton' => { 249 => 0x80e },
	'flashmodebuttonplaybackmode' => { 249 => 0x818 },
	'flashmodel' => { 163 => 'Model', 182 => 'FlashModel', 326 => 0x1001 },
	'flashoptions' => { 365 => 0x2 },
	'flashoptions2' => { 365 => 0x10 },
	'flashoutput' => { 46 => 0x248, 80 => 0x21, 218 => 0xa, 219 => 0xa, 220 => 0xa, 221 => 0x27, 223 => 0x21, 229 => 0x21e, 244 => 0x152, 247 => 0x1b2, 248 => 0x1c6, 249 => 0x1c6 },
	'flashpixversion' => { 123 => 0xa000, 520 => 'FlashpixVersion' },
	'flashredeyemode' => { 520 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 229 => 0x228, 244 => 0x15c, 247 => 0x1bc, 325 => 0x403 },
	'flashreturn' => { 520 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 163 => 'SerialNumber', 326 => 0x1003 },
	'flashsetting' => { 240 => 0x8 },
	'flashshutterspeed' => { 305 => '20.2', 306 => '23.2', 308 => '23.2', 309 => '23.2', 314 => '15.2', 315 => '22.2', 316 => '7.2', 317 => '22.2', 318 => '23.2', 319 => '23.2', 320 => '23.1', 321 => 0x57, 322 => 0x57, 323 => 0x57 },
	'flashsource' => { 218 => 0x4, 219 => 0x4, 220 => 0x4, 221 => 0x4, 222 => 0x4, 223 => 0x4 },
	'flashstatus' => { 372 => 0x0, 456 => [0x82,0x86], 470 => 0x31, 471 => 0x39, 472 => 0x39 },
	'flashstatusbuilt-in' => { 439 => [0x87,0x287] },
	'flashstatusexternal' => { 439 => [0x88,0x288] },
	'flashsyncspeed' => { 305 => '20.1', 306 => '23.1', 308 => '23.1', 309 => '23.1', 314 => '15.1', 315 => '22.1', 317 => '22.1', 318 => '23.1', 319 => '23.1', 321 => 0x53, 322 => 0x53, 323 => 0x53 },
	'flashsyncspeedav' => { 86 => 0x3, 88 => 0x10f, 89 => 0x2, 90 => 0x3, 91 => 0x2, 92 => 0x2, 93 => 0x3, 94 => 0x6 },
	'flashthreshold' => { 98 => 0x1 },
	'flashtype' => { 163 => 'Type', 188 => 0x59, 240 => 0x9, 326 => 0x1000 },
	'flashwarning' => { 315 => '30.1', 316 => '7.1', 320 => '31.1', 349 => 0x62 },
	'flashwirelessoption' => { 229 => 0x234, 244 => 0x15a, 247 => 0x1c8 },
	'flexiblespotposition' => { 451 => 0x201d },
	'flickadvancedirection' => { 321 => 0x25f, 322 => 0x25f, 323 => 0x277 },
	'flickerreduce' => { 426 => 0x218 },
	'flickerreduction' => { 131 => 0x1446, 268 => 0x7 },
	'flickerreductionindicator' => { 263 => 0x532 },
	'flickerreductionshooting' => { 245 => 0x1b4, 246 => 0x1b4, 247 => 0x1a4, 248 => 0x1b8, 249 => 0x1b8 },
	'flightpitchdegree' => { 120 => 'FlightPitchDegree' },
	'flightrolldegree' => { 120 => 'FlightRollDegree' },
	'flightxspeed' => { 120 => 'FlightXSpeed' },
	'flightyawdegree' => { 120 => 'FlightYawDegree' },
	'flightyspeed' => { 120 => 'FlightYSpeed' },
	'flightzspeed' => { 120 => 'FlightZSpeed' },
	'fliphorizontal' => { 298 => 0x76a43206 },
	'fnumber' => { 7 => 0x3, 9 => 0x3, 11 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x3, 31 => 0x5, 32 => 0x6, 80 => 0x15, 123 => 0x829d, 141 => 0xfd04, 144 => 0x1e, 146 => 0xfa23, 148 => 0xf103, 151 => 0x13, 153 => 0x3c, 155 => 0x1c, 156 => 0x18, 158 => 0xc, 167 => 'FNumber', 185 => 0xa, 186 => 0x36, 187 => 0x47, 188 => 0x9, 191 => 0x49c7, 238 => 0x38, 348 => 0x35a, 385 => 0x13, 424 => 0xa019, 427 => [0x31,0x49], 437 => 0x1, 438 => 0x1, 456 => [0x20,0x22,0x26], 520 => 'FNumber' },
	'focaldistance' => { 500 => 'FocalDistance' },
	'focallength' => { 7 => 0x1d, 8 => 0xa, 9 => 0x23, 10 => 0x9, 11 => 0x1d, 12 => 0x9, 13 => 0x1e, 14 => 0x1d, 15 => 0x1d, 16 => 0x1e, 17 => 0x1e, 18 => 0x1e, 19 => 0x28, 20 => 0x1e, 21 => 0x23, 22 => 0x1e, 23 => 0x1e, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x23, 28 => 0x1e, 29 => 0x23, 61 => 0x1, 64 => 0x7, 117 => 0x1d, 123 => 0x920a, 151 => 0x1d, 167 => 'FocalLength', 185 => 0x12, 233 => 0xa, 234 => 0xb, 238 => [0xc,0x3c], 343 => 0x1, 385 => 0x1d, 394 => 0x403, 417 => 0x1500, 436 => 0xe, 464 => 0x1278, 465 => 0x1134, 466 => 0x32c, 467 => 0x32c, 468 => 0x30a, 520 => 'FocalLength' },
	'focallength2' => { 456 => [0x23,0x25,0x29] },
	'focallength35mm' => { 339 => 'FocalLength35mm' },
	'focallengthin35mmformat' => { 123 => 0xa405, 404 => 'camera.focal_length.35mm_equivalent', 424 => 0xa01a, 520 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 436 => 0x10 },
	'focalplaneafpointarea' => { 469 => 0x2 },
	'focalplaneafpointlocation1' => { 469 => 0x6 },
	'focalplaneafpointlocation10' => { 469 => 0x2a },
	'focalplaneafpointlocation11' => { 469 => 0x2e },
	'focalplaneafpointlocation12' => { 469 => 0x32 },
	'focalplaneafpointlocation13' => { 469 => 0x36 },
	'focalplaneafpointlocation14' => { 469 => 0x3a },
	'focalplaneafpointlocation15' => { 469 => 0x3e },
	'focalplaneafpointlocation2' => { 469 => 0xa },
	'focalplaneafpointlocation3' => { 469 => 0xe },
	'focalplaneafpointlocation4' => { 469 => 0x12 },
	'focalplaneafpointlocation5' => { 469 => 0x16 },
	'focalplaneafpointlocation6' => { 469 => 0x1a },
	'focalplaneafpointlocation7' => { 469 => 0x1e },
	'focalplaneafpointlocation8' => { 469 => 0x22 },
	'focalplaneafpointlocation9' => { 469 => 0x26 },
	'focalplaneafpointsused' => { 469 => 0x1 },
	'focalplanediagonal' => { 326 => 0x103, 330 => 0x205 },
	'focalplaneresolutionunit' => { 123 => 0xa210, 520 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 123 => 0xa20e, 520 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 61 => 0x2 },
	'focalplanexunknown' => { 61 => 0x2 },
	'focalplaneyresolution' => { 123 => 0xa20f, 520 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 61 => 0x3 },
	'focalplaneyunknown' => { 61 => 0x3 },
	'focalpointx' => { 500 => 'FocalPointX' },
	'focalpointy' => { 500 => 'FocalPointY' },
	'focaltype' => { 10 => 0x2d, 61 => 0x0 },
	'focalunits' => { 36 => 0x19 },
	'focus' => { 287 => 0x8 },
	'focusarea' => { 185 => 0x31 },
	'focusareaselection' => { 316 => '15.2' },
	'focusbracket' => { 349 => 0xbd },
	'focusbracketstepsize' => { 325 => 0x308 },
	'focuscontinuous' => { 36 => 0x20 },
	'focusdisplayaiservoandmf' => { 88 => 0x515 },
	'focusdistance' => { 167 => 'FocusDistance', 185 => 0x13, 191 => 0x49bb, 233 => 0x9, 234 => 0xa, 238 => [0xb,0x4e], 328 => 0x305, 343 => 0x0, 347 => 0x304, 348 => 0x304 },
	'focusdistancelower' => { 7 => 0x45, 9 => 0x8e, 11 => 0x45, 13 => 0x56, 14 => 0x45, 15 => 0x45, 16 => 0x52, 17 => 0x52, 18 => 0x56, 20 => 0x52, 21 => 0x8e, 22 => 0x59, 23 => 0x57, 24 => 0x8e, 25 => 0x94, 26 => 0x95, 27 => 0xa7, 28 => 0x56, 29 => 0xa7, 59 => 0x15, 80 => 0x14 },
	'focusdistancerange' => { 1 => 0xc },
	'focusdistancerangewidth' => { 238 => 0x4c },
	'focusdistanceupper' => { 7 => 0x43, 9 => 0x8c, 11 => 0x43, 13 => 0x54, 14 => 0x43, 15 => 0x43, 16 => 0x50, 17 => 0x50, 18 => 0x54, 20 => 0x50, 21 => 0x8c, 22 => 0x57, 23 => 0x55, 24 => 0x8c, 25 => 0x92, 26 => 0x93, 27 => 0xa5, 28 => 0x54, 29 => 0xa5, 59 => 0x14, 80 => 0x13 },
	'focusholdbutton' => { 188 => 0x44 },
	'focusinfoversion' => { 328 => 0x0 },
	'focusingscreen' => { 87 => 0x0, 88 => 0x80b, 93 => 0x0 },
	'focuslocation' => { 451 => 0x2027 },
	'focuslocation2' => { 451 => 0x204a },
	'focuslocked' => { 184 => 0x14 },
	'focusmode' => { 36 => 0x7, 116 => 0x3, 117 => [0x3003,0xd], 131 => 0x1021, 142 => 0x3f5, 144 => 0x38, 160 => 'FocusMode', 185 => 0x30, 187 => 0xe, 188 => 0xc, 240 => 0x7, 325 => 0x301, 330 => 0x100b, 349 => 0x7, 385 => 0xd, 392 => 0x3, 417 => 0x1006, 430 => [0xb,0x5], 436 => [0x15,0x1d], 437 => 0x4d, 438 => 0x4d, 451 => [0xb042,0xb04e,0x201b], 456 => 0x13, 477 => 0x16 },
	'focusmode2' => { 130 => '0.1', 365 => '3.1', 456 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 307 => '10.1', 434 => 0x14, 435 => 0x15, 437 => 0x10, 438 => 0xf, 439 => 0x6 },
	'focusmodeswitch' => { 188 => 0x58, 437 => 0x2e },
	'focuspeakingdisplay' => { 321 => 0x235, 322 => 0x235, 323 => 0x24d },
	'focuspeakinghighlightcolor' => { 321 => 0x4b, 322 => 0x4b, 323 => 0x4b },
	'focuspeakinglevel' => { 321 => 0x49, 322 => 0x49, 323 => 0x49 },
	'focuspixel' => { 131 => 0x1023 },
	'focuspointlock' => { 321 => 0x1d3, 322 => 0x1d3, 323 => 0x1eb },
	'focuspointpersistence' => { 321 => 0x105, 322 => 0x105, 323 => 0x11b },
	'focuspointwrap' => { 305 => '2.2', 306 => '2.2', 308 => '2.1', 309 => '2.1', 313 => '1.1', 314 => '2.2', 315 => '1.1', 318 => '2.2', 319 => '2.1', 320 => '2.5', 321 => 0x16, 322 => 0x16, 323 => 0x16 },
	'focusposition' => { 1 => 0x2f, 233 => 0x8, 234 => 0x8, 385 => 0x10, 448 => 0x9bb },
	'focusposition2' => { 456 => [0x29,0x2b,0x2f], 477 => 0x2d, 480 => 0x20 },
	'focuspositionhorizontal' => { 197 => 0x2f, 198 => 0x43 },
	'focuspositionvertical' => { 197 => 0x31, 198 => 0x45 },
	'focusprocess' => { 325 => 0x302 },
	'focusrange' => { 36 => 0x12, 330 => 0x100a },
	'focusrangeindex' => { 375 => '3.1' },
	'focusresult' => { 198 => 0x4a },
	'focusringrotation' => { 88 => 0x713 },
	'focussetting' => { 427 => 0x6 },
	'focusshiftautoreset' => { 248 => 0x6da, 249 => 0x748 },
	'focusshiftexposurelock' => { 229 => 0x1b4, 244 => 0xe8, 245 => 0x100, 246 => 0x100, 247 => 0xf4, 248 => 0x104, 249 => 0x104 },
	'focusshiftinterval' => { 229 => 0x1b0, 244 => 0xe4, 245 => 0xfc, 246 => 0xfc, 247 => 0xf0, 248 => 0x100, 249 => 0x100 },
	'focusshiftnumbershots' => { 229 => 0x1a8, 244 => 0xdc, 245 => 0xf4, 246 => 0xf4, 247 => 0xe8, 248 => 0xf8, 249 => 0xf8 },
	'focusshiftshooting' => { 266 => 0x20 },
	'focusshiftstepwidth' => { 229 => 0x1ac, 244 => 0xe0, 245 => 0xf8, 246 => 0xf8, 247 => 0xec, 248 => 0xfc, 249 => 0xfc },
	'focusstatus' => { 436 => 0x19, 437 => 0x53, 438 => 0x53 },
	'focusstepcount' => { 328 => 0x301, 330 => 0x100e },
	'focusstepinfinity' => { 328 => 0x303, 330 => 0x103b },
	'focusstepnear' => { 328 => 0x304, 330 => 0x103c },
	'focusstepsfrominfinity' => { 238 => 0x58 },
	'focustrackinglockon' => { 305 => ['1.5','4.1'], 306 => '1.4', 313 => '0.4', 314 => '3.1', 315 => '0.4', 318 => '1.4' },
	'focuswarning' => { 131 => 0x1301 },
	'foldername' => { 185 => 0x27 },
	'foldernumber' => { 437 => 0x9a, 439 => [0x402,0x114,0x316] },
	'fontcomposite' => { 548 => [\'Fonts','FontsComposite'] },
	'fontface' => { 548 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 548 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 548 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 548 => [\'Fonts','FontsFontName'] },
	'fonts' => { 548 => 'Fonts' },
	'fonttype' => { 548 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 548 => [\'Fonts','FontsVersionString'] },
	'for' => { 401 => 'For' },
	'forcewrite' => { 124 => 'ForceWrite' },
	'format' => { 410 => "\xa9fmt", 499 => 'Format', 517 => 'format', 541 => 'Format' },
	'forwardlock' => { 538 => 'forwardlock' },
	'forwardmatrix1' => { 123 => 0xc714 },
	'forwardmatrix2' => { 123 => 0xc715 },
	'forwardmatrix3' => { 123 => 0xcd34 },
	'fossilspecimen' => { 122 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 122 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 70 => [0x2,0x4] },
	'frameheight' => { 131 => 0x3822 },
	'framenum' => { 396 => 0xd7 },
	'framenumber' => { 131 => 0x8003, 191 => 0x3c, 385 => 0x29 },
	'framerate' => { 70 => [0x1,0x6], 123 => 0xc764, 131 => 0x3820 },
	'framereadouttime' => { 404 => 'camera.framereadouttimeinmicroseconds' },
	'framewidth' => { 131 => 0x3821 },
	'framing' => { 532 => 'framing' },
	'freebytes' => { 101 => 0x1 },
	'freememorycardimages' => { 186 => [0x37,0x54], 187 => [0x2d,0x4a], 188 => 0x32 },
	'fujiflashmode' => { 131 => 0x1010 },
	'fujimodel' => { 131 => 0x1447 },
	'fujimodel2' => { 131 => 0x1448 },
	'fullhdhighspeedrec' => { 131 => 0x3824 },
	'fullimagesize' => { 451 => 0xb02b },
	'fullpanoheightpixels' => { 502 => 'FullPanoHeightPixels', 503 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 502 => 'FullPanoWidthPixels', 503 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 417 => 0x100d },
	'fullsizeimage' => { 166 => 'data' },
	'fullsizeimagename' => { 166 => '1Name' },
	'fullsizeimagetype' => { 166 => '0Type' },
	'func1button' => { 308 => '14.1', 309 => '14.1', 319 => '14.1', 321 => 0x63, 322 => 0x63, 323 => 0x63 },
	'func1buttonplaybackmode' => { 321 => 0x1a5, 322 => 0x1a5, 323 => 0x1bd },
	'func1buttonplusdials' => { 308 => '42.1', 309 => '42.1', 319 => '42.1' },
	'func2button' => { 308 => '80.1', 309 => '80.1', 319 => '80.1', 321 => 0x73, 322 => 0x73, 323 => 0x73 },
	'func2buttonplaybackmode' => { 321 => 0x1a7, 322 => 0x1a7, 323 => 0x1bf },
	'func2buttonplusdials' => { 308 => '81.1' },
	'func3button' => { 308 => '83.1', 322 => 0x119, 323 => 0x131 },
	'func3buttonplaybackmode' => { 322 => 0x1a9, 323 => 0x1c1 },
	'func4button' => { 322 => 0x175, 323 => 0x18d },
	'func4buttonplaybackmode' => { 322 => 0x1af, 323 => 0x1c7 },
	'funcbutton' => { 305 => ['14.1','15.1'], 306 => '14.1', 314 => '28.1', 315 => '13.1', 318 => '14.1', 320 => '14.1' },
	'funcbuttonplusdials' => { 305 => ['14.2','15.2'], 306 => '14.2', 314 => '31.1', 318 => '42.1' },
	'functionbutton' => { 312 => '13.1', 316 => '5.2' },
	'gainbase' => { 329 => 0x610 },
	'gaincontrol' => { 123 => 0xa407, 520 => 'GainControl' },
	'gainmapmax' => { 525 => 'GainMapMax' },
	'gainmapmin' => { 525 => 'GainMapMin' },
	'gamma' => { 123 => 0xa500, 142 => 0x8fe, 336 => 'gAMA', 354 => 0x11c, 521 => 'Gamma', 525 => 'Gamma' },
	'gammablackpoint' => { 109 => 0xc },
	'gammacolortone' => { 109 => 0x3 },
	'gammacompensatedvalue' => { 137 => 0x91 },
	'gammacontrast' => { 109 => 0x2 },
	'gammacurveoutputrange' => { 109 => 0xf },
	'gammahighlight' => { 109 => 0xa },
	'gammalinear' => { 107 => 0x20200 },
	'gammamidpoint' => { 109 => 0xe },
	'gammasaturation' => { 109 => 0x4 },
	'gammashadow' => { 109 => 0x9 },
	'gammasharpnessstrength' => { 109 => 0x8 },
	'gammaunsharpmaskfineness' => { 109 => 0x6 },
	'gammaunsharpmaskstrength' => { 109 => 0x5 },
	'gammaunsharpmaskthreshold' => { 109 => 0x7 },
	'gammawhitepoint' => { 109 => 0xd },
	'garminsettings' => { 410 => 'pmcc' },
	'garminsoftware' => { 410 => 'uuid' },
	'gdalmetadata' => { 123 => 0xa480 },
	'gdalnodata' => { 123 => 0xa481 },
	'geimagesize' => { 131 => 0x1304 },
	'gemake' => { 133 => 0x300 },
	'gemodel' => { 133 => 0x207 },
	'genre' => { 402 => ['gnre',"\xa9gen"], 404 => 'genre', 410 => ['gnre',"\xa9gen"], 528 => 'Genre', 533 => 'genre', 543 => 'genre' },
	'genrecvid' => { 528 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 528 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 528 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 528 => [\'Genre','GenreCvTermRefinedAbout'] },
	'genreid' => { 402 => 'geID' },
	'geography' => { 534 => 'geography' },
	'geolocate' => { 124 => 'Geolocate' },
	'geologicalcontext' => { 122 => 'GeologicalContext' },
	'geologicalcontextbed' => { 122 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 122 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 122 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 122 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 122 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 124 => 'Geosync' },
	'geotag' => { 124 => 'Geotag' },
	'geotiffasciiparams' => { 123 => 0x87b1 },
	'geotiffdirectory' => { 123 => 0x87af },
	'geotiffdoubleparams' => { 123 => 0x87b0 },
	'geotime' => { 124 => 'Geotime' },
	'giftftppriority' => { 504 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 120 => 'GimbalPitchDegree' },
	'gimbalreverse' => { 120 => 'GimbalReverse' },
	'gimbalrolldegree' => { 120 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 120 => 'GimbalYawDegree' },
	'globalaltitude' => { 399 => 0x419 },
	'globalangle' => { 399 => 0x40d },
	'good' => { 543 => 'good' },
	'googlehostheader' => { 402 => 'gshh' },
	'googlepingmessage' => { 402 => 'gspm' },
	'googlepingurl' => { 402 => 'gspu' },
	'googleplusuploadcode' => { 123 => 0x9009 },
	'googlesourcedata' => { 402 => 'gssd' },
	'googlestarttime' => { 402 => 'gsst' },
	'googletrackduration' => { 402 => 'gstd' },
	'goprotype' => { 410 => 'GoPr' },
	'gpsaltitude' => { 134 => 0x6, 164 => 'Altitude', 520 => 'GPSAltitude' },
	'gpsaltituderef' => { 134 => 0x5, 520 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 134 => 0x1c, 520 => 'GPSAreaInformation' },
	'gpscoordinates' => { 402 => "\xa9xyz", 404 => 'location.ISO6709', 410 => ['@xyz',"\xa9xyz"] },
	'gpsdatestamp' => { 134 => 0x1d },
	'gpsdatetime' => { 164 => 'DateTime', 520 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 134 => 0x18, 164 => 'Bearing', 520 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 134 => 0x17, 520 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 134 => 0x1a, 164 => 'Distance', 520 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 134 => 0x19, 520 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 134 => 0x14, 520 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 134 => 0x13 },
	'gpsdestlongitude' => { 134 => 0x16, 520 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 134 => 0x15 },
	'gpsdifferential' => { 134 => 0x1e, 164 => 'Differential', 520 => 'GPSDifferential' },
	'gpsdop' => { 134 => 0xb, 520 => 'GPSDOP' },
	'gpshpositioningerror' => { 134 => 0x1f, 520 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 134 => 0x11, 520 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 134 => 0x10, 520 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 118 => 'GPS-GPSLatitude', 120 => 'GpsLatitude', 134 => 0x2, 164 => 'Latitude', 520 => 'GPSLatitude' },
	'gpslatituderef' => { 134 => 0x1 },
	'gpslongitude' => { 118 => 'GPS-GPSLongitude', 120 => 'GpsLongitude', 134 => 0x4, 164 => 'Longitude', 520 => 'GPSLongitude' },
	'gpslongituderef' => { 134 => 0x3 },
	'gpslongtitude' => { 120 => 'GpsLongtitude' },
	'gpsmapdatum' => { 134 => 0x12, 164 => 'Datum', 520 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 134 => 0xa, 164 => 'MeasureMode', 520 => 'GPSMeasureMode' },
	'gpsposition' => { 118 => 'Exif-GPSPosition' },
	'gpsprocessingmethod' => { 134 => 0x1b, 520 => 'GPSProcessingMethod' },
	'gpssatellites' => { 134 => 0x8, 164 => 'Satellites', 520 => 'GPSSatellites' },
	'gpsspeed' => { 134 => 0xd, 164 => 'Speed', 520 => 'GPSSpeed' },
	'gpsspeedref' => { 134 => 0xc, 520 => 'GPSSpeedRef' },
	'gpsstatus' => { 134 => 0x9, 520 => 'GPSStatus' },
	'gpsstring' => { 142 => 0x402 },
	'gpstimestamp' => { 134 => 0x7 },
	'gpstrack' => { 134 => 0xf, 164 => 'Heading', 520 => 'GPSTrack' },
	'gpstrackref' => { 134 => 0xe, 520 => 'GPSTrackRef' },
	'gpsversionid' => { 134 => 0x0, 520 => 'GPSVersionID' },
	'gradation' => { 325 => 0x50f },
	'gradientbasedcorractive' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrblacks2012' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'] },
	'gradientbasedcorrbrightness' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrcorrectionname' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'] },
	'gradientbasedcorrcorrectionsyncid' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'] },
	'gradientbasedcorrdefringe' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrdehaze' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'] },
	'gradientbasedcorrections' => { 514 => 'GradientBasedCorrections', 516 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'] },
	'gradientbasedcorrluminancenoise' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskinputdigest' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'gradientbasedcorrmaskleft' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmaskactive' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'gradientbasedcorrmaskmaskblendmode' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmaskdigest' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'gradientbasedcorrmaskmaskinverted' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'gradientbasedcorrmaskmaskname' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'] },
	'gradientbasedcorrmaskmasks' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'] },
	'gradientbasedcorrmaskmasksalpha' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'gradientbasedcorrmaskmasksangle' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'gradientbasedcorrmaskmasksbottom' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'gradientbasedcorrmaskmaskscentervalue' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'gradientbasedcorrmaskmaskscenterweight' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'gradientbasedcorrmaskmasksdabs' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'gradientbasedcorrmaskmasksfeather' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'gradientbasedcorrmaskmasksflipped' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'gradientbasedcorrmaskmasksflow' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'gradientbasedcorrmaskmasksfullx' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'gradientbasedcorrmaskmasksfully' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'gradientbasedcorrmaskmasksinputdigest' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'gradientbasedcorrmaskmasksleft' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'gradientbasedcorrmaskmasksmaskactive' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'gradientbasedcorrmaskmasksmaskblendmode' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmasksmaskdigest' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'gradientbasedcorrmaskmasksmaskinverted' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'gradientbasedcorrmaskmasksmaskname' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'gradientbasedcorrmaskmasksmasksubtype' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksmasksyncid' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'gradientbasedcorrmaskmasksmaskversion' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'gradientbasedcorrmaskmasksmidpoint' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'gradientbasedcorrmaskmasksorigin' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'gradientbasedcorrmaskmasksperimetervalue' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'gradientbasedcorrmaskmasksradius' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'gradientbasedcorrmaskmasksreferencepoint' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'gradientbasedcorrmaskmasksright' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'gradientbasedcorrmaskmasksroundness' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'gradientbasedcorrmaskmaskssizex' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'gradientbasedcorrmaskmaskssizey' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'gradientbasedcorrmaskmaskstop' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'gradientbasedcorrmaskmasksubtype' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksvalue' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'gradientbasedcorrmaskmasksversion' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'gradientbasedcorrmaskmaskswhat' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'gradientbasedcorrmaskmaskswholeimagearea' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'gradientbasedcorrmaskmasksx' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'] },
	'gradientbasedcorrmaskmasksy' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'] },
	'gradientbasedcorrmaskmasksyncid' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'gradientbasedcorrmaskmaskszerox' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'gradientbasedcorrmaskmaskszeroy' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'gradientbasedcorrmaskmaskversion' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'gradientbasedcorrmaskmidpoint' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskorigin' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'] },
	'gradientbasedcorrmaskperimetervalue' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskrange' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'gradientbasedcorrmaskrangeareamodels' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrmaskrangeareamodelscolorsampleinfo' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrmaskrangeareamodelscomponents' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrmaskrangecoloramount' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrmaskrangedepthfeather' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrmaskrangedepthmax' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrmaskrangedepthmin' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrmaskrangeinvert' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'gradientbasedcorrmaskrangelumfeather' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrmaskrangeluminancedepthsampleinfo' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrmaskrangelummax' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrmaskrangelummin' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrmaskrangelumrange' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrmaskrangesampletype' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrmaskrangetype' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'gradientbasedcorrmaskrangeversion' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'gradientbasedcorrmaskreferencepoint' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'gradientbasedcorrmaskright' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskwholeimagearea' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'gradientbasedcorrmaskx' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrrangemask' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'] },
	'gradientbasedcorrrangemaskareamodels' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrrangemaskareamodelscolorsampleinfo' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrrangemaskareamodelscomponents' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrrangemaskcoloramount' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrrangemaskdepthfeather' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrrangemaskdepthmax' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrrangemaskdepthmin' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrrangemaskinvert' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'gradientbasedcorrrangemasklumfeather' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrrangemaskluminancedepthsampleinfo' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrrangemasklummax' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrrangemasklummin' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrrangemasklumrange' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrrangemasksampletype' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrrangemasktype' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'] },
	'gradientbasedcorrrangemaskversion' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'gradientbasedcorrsaturation' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'] },
	'gradientbasedcorrshadows2012' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtexture' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'] },
	'gradientbasedcorrtint' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrtoninghue' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrtoningsaturation' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrwhat' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'gradientbasedcorrwhites2012' => { 514 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'], 516 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'] },
	'grainamount' => { 514 => 'GrainAmount', 516 => 'GrainAmount' },
	'graineffectroughness' => { 131 => 0x1047 },
	'graineffectsize' => { 131 => 0x104c },
	'grainfrequency' => { 514 => 'GrainFrequency', 516 => 'GrainFrequency' },
	'grainseed' => { 514 => 'GrainSeed', 516 => 'GrainSeed' },
	'grainsize' => { 514 => 'GrainSize', 516 => 'GrainSize' },
	'graymixeraqua' => { 514 => 'GrayMixerAqua', 516 => 'GrayMixerAqua' },
	'graymixerblue' => { 514 => 'GrayMixerBlue', 516 => 'GrayMixerBlue' },
	'graymixergreen' => { 514 => 'GrayMixerGreen', 516 => 'GrayMixerGreen' },
	'graymixermagenta' => { 514 => 'GrayMixerMagenta', 516 => 'GrayMixerMagenta' },
	'graymixerorange' => { 514 => 'GrayMixerOrange', 516 => 'GrayMixerOrange' },
	'graymixerpurple' => { 514 => 'GrayMixerPurple', 516 => 'GrayMixerPurple' },
	'graymixerred' => { 514 => 'GrayMixerRed', 516 => 'GrayMixerRed' },
	'graymixeryellow' => { 514 => 'GrayMixerYellow', 516 => 'GrayMixerYellow' },
	'graypoint' => { 488 => 0x8021 },
	'grayresponseunit' => { 123 => 0x122 },
	'greencurvelimits' => { 112 => 0x1c4 },
	'greencurvepoints' => { 111 => 0x53, 112 => 0x19a },
	'greenghostmitigationstatus' => { 1 => 0x3f },
	'greenhsl' => { 107 => 0x20913 },
	'greenhue' => { 514 => 'GreenHue', 516 => 'GreenHue' },
	'greensaturation' => { 514 => 'GreenSaturation', 516 => 'GreenSaturation' },
	'griddisplay' => { 305 => '13.3', 306 => '4.3', 308 => '4.2', 309 => '4.2', 310 => '2.2', 314 => '10.5', 315 => '3.4', 316 => '6.1', 318 => '4.4', 319 => '4.2', 320 => '4.2' },
	'gripbatteryadload' => { 363 => 0x5 },
	'gripbatteryadnoload' => { 363 => 0x4 },
	'gripbatterypercent' => { 363 => 0x11 },
	'gripbatterystate' => { 363 => ['1.2',0x10] },
	'gripbatteryvoltage' => { 363 => 0x12 },
	'group' => { 514 => 'Group', 516 => 'Group' },
	'groupareaafillumination' => { 306 => '46.4', 309 => '47.4', 318 => '47.4' },
	'grouping' => { 402 => ['grup',"\xa9grp"], 410 => "\xa9grp" },
	'guid' => { 402 => 'GUID' },
	'h2resetblackpixels' => { 142 => 0x18a6 },
	'h3resetblackcolumns' => { 142 => 0x18ce },
	'h3resetblackpixels' => { 142 => 0x18b0 },
	'halftonehints' => { 123 => 0x141 },
	'hardlink' => { 124 => 'HardLink' },
	'hasalternative' => { 533 => 'hasAlternative' },
	'hascorrection' => { 533 => 'hasCorrection' },
	'hascorrectiona-lang' => { 533 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 533 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 533 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 514 => 'HasCrop', 516 => 'HasCrop' },
	'hasextendedxmp' => { 545 => 'HasExtendedXMP' },
	'hassettings' => { 514 => 'HasSettings', 516 => 'HasSettings' },
	'hastranslation' => { 533 => 'hasTranslation' },
	'hasvisibleoverprint' => { 548 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 548 => 'HasVisibleTransparency' },
	'hdmioutputn-log' => { 244 => 0x35a },
	'hdmioutputresolution' => { 245 => 0x710, 246 => 0x720, 247 => 0x610, 248 => 0x640, 249 => 0x6a8 },
	'hdmiviewassist' => { 322 => 0x20f, 323 => 0x227 },
	'hdr' => { 62 => 0x1, 225 => 0x4, 226 => 0x4, 245 => 0x23a, 246 => 0x23a, 249 => 0x23a, 349 => 0x9e, 385 => 0x85, 451 => 0x200a },
	'hdrcapacitymax' => { 525 => 'HDRCapacityMax' },
	'hdrcapacitymin' => { 525 => 'HDRCapacityMin' },
	'hdreditmode' => { 514 => 'HDREditMode', 516 => 'HDREditMode' },
	'hdreffect' => { 62 => 0x2 },
	'hdrgain' => { 1 => 0x30 },
	'hdrheadroom' => { 1 => 0x21 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrlevel' => { 225 => 0x5, 226 => 0x5, 245 => 0x246, 246 => 0x246, 249 => 0x246, 439 => 0x2e, 456 => 0x17 },
	'hdrlevel2' => { 225 => 0x7 },
	'hdrplusmakernote' => { 496 => 'HdrPlusMakernote' },
	'hdrpmakernote' => { 496 => 'hdrp_makernote' },
	'hdrsetting' => { 439 => 0x2d, 456 => 0x16, 460 => 0x1148, 461 => 0x1148, 462 => 0x1124, 463 => 0x11a0, 464 => 0x117c, 465 => 0x1034, 466 => 0x22c, 467 => 0x22c, 468 => 0x21f },
	'hdrsmoothing' => { 225 => 0x6 },
	'hdvideo' => { 402 => 'hdvd' },
	'headline' => { 135 => 0x69, 528 => 'Headline', 531 => 'Headline' },
	'hiddendatalength' => { 449 => 0x1 },
	'hiddendataoffset' => { 449 => 0x0 },
	'hierarchicalkeywords' => { 175 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 175 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 175 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 175 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 175 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 175 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 175 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 175 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 175 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 175 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 175 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 175 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 175 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 175 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 175 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 175 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 175 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 175 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 506 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 122 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highframerate' => { 245 => 0x48, 246 => 0x48, 248 => 0x48, 249 => 0x48 },
	'highfrequencyflickerreduction' => { 245 => 0x27c, 246 => 0x27c, 248 => 0x27c, 249 => 0x27c },
	'highisomultiplierblue' => { 354 => 0x1a },
	'highisomultipliergreen' => { 354 => 0x19 },
	'highisomultiplierred' => { 354 => 0x18 },
	'highisonoisereduction' => { 16 => 0xbc, 17 => 0xbd, 20 => 0xbd, 28 => 0xc9, 65 => 0x5, 88 => 0x202, 240 => 0xb1, 385 => 0x71, 437 => 0x2c, 438 => 0x26, 439 => 0x26, 451 => 0x2009, 456 => 0x12, 483 => 0x42 },
	'highisonoisereduction2' => { 451 => 0xb050 },
	'highlight' => { 427 => 0xf },
	'highlight2012' => { 514 => 'Highlight2012', 516 => 'Highlight2012' },
	'highlightadj' => { 107 => 0x2030c },
	'highlightcolordistortreduct' => { 488 => 0x8026 },
	'highlightlinearitylimit' => { 424 => 0xa025 },
	'highlightprotection' => { 297 => 0x6 },
	'highlightrecovery' => { 514 => 'HighlightRecovery', 516 => 'HighlightRecovery' },
	'highlights' => { 451 => 0x2033, 508 => 'Highlights' },
	'highlights2012' => { 514 => 'Highlights2012', 516 => 'Highlights2012' },
	'highlightsadj' => { 488 => 0x9019 },
	'highlightshadow' => { 349 => 0xad },
	'highlighttone' => { 131 => 0x1041 },
	'highlighttonepriority' => { 13 => 0x7, 16 => 0x7, 17 => 0x7, 18 => 0x7, 20 => 0x7, 22 => 0x7, 28 => 0x7, 65 => 0x3, 88 => 0x203 },
	'highlightwarning' => { 349 => 0x8002 },
	'highlowkeyadj' => { 385 => 0x6c },
	'highspeedsync' => { 188 => 0x5, 321 => 0x55, 322 => 0x55, 323 => 0x55, 437 => 0x2, 438 => 0x2 },
	'hintversion' => { 410 => 'hinv' },
	'histogramxml' => { 298 => 0x83a1a25 },
	'history' => { 531 => 'History', 544 => 'History' },
	'historyaction' => { 544 => [\'History','HistoryAction'] },
	'historychanged' => { 544 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 544 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 544 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 544 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 544 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 142 => 0xc88 },
	'holefilldeltathreshold' => { 142 => 0xc7e },
	'hometowncity' => { 117 => 0x3006, 385 => 0x23, 391 => 0x2 },
	'hometowncitycode' => { 392 => 0x1000 },
	'hometowndst' => { 385 => 0x25, 391 => '0.2' },
	'hostcomputer' => { 123 => 0x13c },
	'hostsoftwarerendering' => { 142 => 0xce7 },
	'hue' => { 193 => 0x3b, 257 => 0x3d, 258 => 0x45, 385 => 0x67 },
	'hueadj' => { 301 => 0x2f, 488 => 0x8019 },
	'hueadjust' => { 417 => 0x1016 },
	'hueadjustment' => { 186 => 0x4a, 187 => 0x40, 240 => 0x92, 256 => 0x36 },
	'hueadjustmentaqua' => { 514 => 'HueAdjustmentAqua', 516 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 514 => 'HueAdjustmentBlue', 516 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 514 => 'HueAdjustmentGreen', 516 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 514 => 'HueAdjustmentMagenta', 516 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 514 => 'HueAdjustmentOrange', 516 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 514 => 'HueAdjustmentPurple', 516 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 514 => 'HueAdjustmentRed', 516 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 514 => 'HueAdjustmentYellow', 516 => 'HueAdjustmentYellow' },
	'huesetting' => { 333 => 0x1011 },
	'humanobservation' => { 122 => 'HumanObservation' },
	'humanobservationday' => { 122 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 122 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 122 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 122 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 122 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 122 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 122 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationfieldnotes' => { 122 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 122 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 122 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 122 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 122 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 122 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 122 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 122 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 122 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 122 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 122 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 122 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 122 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 123 => 0x9401, 521 => 'Humidity' },
	'icc_profile' => { 124 => 'ICC_Profile' },
	'iccprofilename' => { 531 => 'ICCProfile' },
	'iconuri' => { 410 => 'icnu' },
	'idccreativestyle' => { 488 => 0x8000 },
	'idcpreviewlength' => { 488 => 0x202 },
	'idcpreviewstart' => { 488 => 0x201 },
	'identification' => { 122 => 'Identification' },
	'identificationid' => { 122 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 122 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 122 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 122 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 122 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 122 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifiedbyid' => { 122 => [\'Identification','IdentificationIdentifiedByID'] },
	'identifier' => { 517 => 'identifier', 541 => 'Identifier' },
	'ifcameramodel' => { 142 => 0x9c8 },
	'illuminantdata1' => { 123 => 0xcd35 },
	'illuminantdata2' => { 123 => 0xcd36 },
	'illuminantdata3' => { 123 => 0xcd37 },
	'illumination' => { 316 => '0.5', 412 => 0x48 },
	'imageabsolutex' => { 142 => 0x3fe },
	'imageabsolutey' => { 142 => 0x3ff },
	'imageadjustment' => { 240 => 0x80, 287 => 0x5 },
	'imagealterationconstraints' => { 335 => 'ImageAlterationConstraints' },
	'imagearea' => { 230 => 0x2b, 265 => 0x2b, 273 => 0x10, 276 => 0x10 },
	'imageareaoffset' => { 385 => 0x38 },
	'imageauthentication' => { 240 => 0x20 },
	'imageboundary' => { 240 => 0x16 },
	'imagecapturerequestid' => { 1 => 0x20 },
	'imagecapturetype' => { 1 => 0x14 },
	'imagecount' => { 131 => 0x1438, 240 => 0xa5, 454 => 0x11b },
	'imagecreator' => { 335 => 'ImageCreator' },
	'imagecreatorid' => { 335 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 335 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 335 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 142 => 0x41f },
	'imagecropy' => { 142 => 0x420 },
	'imagedata' => { 501 => 'Data' },
	'imagedatasize' => { 240 => 0xa2 },
	'imagedescription' => { 123 => 0x10e, 539 => 'ImageDescription' },
	'imageduplicationconstraints' => { 335 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 298 => 0xfe443a45 },
	'imageeditcount' => { 385 => 0x41 },
	'imageediting' => { 385 => 0x32 },
	'imageeditingsoftware' => { 123 => 0xa43b },
	'imageeditor' => { 123 => 0xa438 },
	'imageeffects' => { 417 => 0x1010 },
	'imagefileconstraints' => { 335 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 335 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 335 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 131 => 0x1436 },
	'imageheight' => { 123 => 0x101, 192 => 0xc, 394 => 0x10d, 499 => 'ImageHeight', 539 => 'ImageLength' },
	'imagehistory' => { 123 => 0x9213, 519 => 'ImageHistory' },
	'imageidnumber' => { 344 => 0x340 },
	'imagemimetype' => { 501 => 'Mime' },
	'imagenumber' => { 123 => 0x9211, 160 => 'ImageNumber', 186 => 0xae, 187 => 0x5e, 394 => 0x113, 437 => 0x9b, 439 => [0x400,'276.1',0x314], 511 => 'ImageNumber' },
	'imagenumber2' => { 187 => 0x62 },
	'imageoptimization' => { 240 => 0xa9 },
	'imageorientation' => { 135 => 0x83 },
	'imageprocessing' => { 240 => 0x1a },
	'imageprocessingfiledatecreated' => { 142 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 142 => 0xc80 },
	'imageprocessingflags' => { 1 => 0x19 },
	'imageprocessingversion' => { 329 => 0x0 },
	'imagequality' => { 160 => 'ImageQuality', 275 => '723.2', 276 => '732.2', 284 => '708.1', 349 => 0x1 },
	'imagequality2' => { 325 => 0x603 },
	'imagerank' => { 504 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 142 => 0x600 },
	'imagerboardversion' => { 142 => 0x439 },
	'imagercols' => { 142 => 0x17d4 },
	'imageref' => { 526 => 'ImageRef' },
	'imageregion' => { 528 => 'ImageRegion' },
	'imageregionboundary' => { 528 => [\'ImageRegion','ImageRegionRegionBoundary'] },
	'imageregionboundaryh' => { 528 => [\'ImageRegion','ImageRegionRegionBoundaryRbH'] },
	'imageregionboundaryrx' => { 528 => [\'ImageRegion','ImageRegionRegionBoundaryRbRx'] },
	'imageregionboundaryshape' => { 528 => [\'ImageRegion','ImageRegionRegionBoundaryRbShape'] },
	'imageregionboundaryunit' => { 528 => [\'ImageRegion','ImageRegionRegionBoundaryRbUnit'] },
	'imageregionboundaryvertices' => { 528 => [\'ImageRegion','ImageRegionRegionBoundaryRbVertices'] },
	'imageregionboundaryverticesx' => { 528 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbX'] },
	'imageregionboundaryverticesy' => { 528 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbY'] },
	'imageregionboundaryw' => { 528 => [\'ImageRegion','ImageRegionRegionBoundaryRbW'] },
	'imageregionboundaryx' => { 528 => [\'ImageRegion','ImageRegionRegionBoundaryRbX'] },
	'imageregionboundaryy' => { 528 => [\'ImageRegion','ImageRegionRegionBoundaryRbY'] },
	'imageregionctype' => { 528 => [\'ImageRegion','ImageRegionRCtype'] },
	'imageregionctypeidentifier' => { 528 => [\'ImageRegion','ImageRegionRCtypeIdentifier'] },
	'imageregionctypename' => { 528 => [\'ImageRegion','ImageRegionRCtypeName'] },
	'imageregionid' => { 528 => [\'ImageRegion','ImageRegionRId'] },
	'imageregionname' => { 528 => [\'ImageRegion','ImageRegionName'] },
	'imageregionrole' => { 528 => [\'ImageRegion','ImageRegionRRole'] },
	'imageregionroleidentifier' => { 528 => [\'ImageRegion','ImageRegionRRoleIdentifier'] },
	'imageregionrolename' => { 528 => [\'ImageRegion','ImageRegionRRoleName'] },
	'imageresolution' => { 142 => 0x944 },
	'imageresolutionjpg' => { 142 => 0x945 },
	'imagereview' => { 307 => '0.4', 316 => '0.4' },
	'imagereviewmonitorofftime' => { 306 => '21.1', 308 => '21.1', 309 => '21.1', 313 => '20.1', 318 => '21.1', 319 => '21.1', 321 => 0x39, 322 => 0x39, 323 => 0x39 },
	'imagereviewtime' => { 305 => '25.1', 307 => '2.1', 310 => '19.1', 311 => '20.1', 312 => '20.1', 314 => '9.2', 315 => '20.1', 320 => '21.2' },
	'imagerfiledatecreated' => { 142 => 0x9c5 },
	'imagerfileproductionlevel' => { 142 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 142 => 0x9c7 },
	'imagerotated' => { 155 => 0x2a },
	'imagerpowerondelaymsec' => { 142 => 0x5fd },
	'imagerrows' => { 142 => 0x17de },
	'imagesegmentlines' => { 142 => 0x184d },
	'imagesegmentstartline' => { 142 => 0x184c },
	'imagesequenceinfo' => { 123 => 0xcd44 },
	'imagesize' => { 166 => 'ImageSize' },
	'imagesizeraw' => { 240 => 0x3e },
	'imagesizerestriction' => { 536 => 'imageSizeRestriction' },
	'imagesourcedata' => { 123 => 0x935c },
	'imagespace' => { 142 => 0x909 },
	'imagestabilization' => { 36 => 0x22, 117 => 0x3020, 131 => 0x1422, 160 => 'ImageStabilization', 186 => 0xbd, 187 => 0x71, 188 => 0x57, 189 => 0x0, 190 => [0x18,0x107,0x113], 191 => 0x49c2, 240 => 0xac, 325 => 0x604, 328 => 0x1600, 349 => 0x1a, 442 => 0x12, 443 => 0x11, 451 => 0xb026 },
	'imagestabilization2' => { 441 => 0xa },
	'imagestabilizationsetting' => { 191 => 0x14, 437 => 0x3d, 438 => 0x3d, 448 => 0x14 },
	'imagestats' => { 123 => 0xcd46 },
	'imagestyle' => { 437 => 0x2d, 438 => 0x27 },
	'imagesupplier' => { 335 => 'ImageSupplier' },
	'imagesupplierid' => { 335 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 335 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 335 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 125 => 0x1 },
	'imagetemperaturemin' => { 125 => 0x2 },
	'imagetone' => { 385 => 0x4f },
	'imagetype' => { 135 => 0x82, 335 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 67 => 0x28, 123 => 0xa420, 519 => 'ImageUniqueID', 520 => 'ImageUniqueID' },
	'imagewidth' => { 123 => 0x100, 192 => 0xe, 394 => 0x10c, 499 => 'ImageWidth', 539 => 'ImageWidth' },
	'inclinationangle' => { 488 => 0x900f },
	'inclinationcorrection' => { 488 => 0x900e },
	'incrementaltemperature' => { 514 => 'IncrementalTemperature', 516 => 'IncrementalTemperature' },
	'incrementaltint' => { 514 => 'IncrementalTint', 516 => 'IncrementalTint' },
	'industry' => { 533 => 'industry', 534 => 'industry' },
	'infobuttonwhenshooting' => { 88 => 0x409 },
	'information' => { 404 => 'information', 410 => "\xa9inf" },
	'infourl' => { 410 => 'infu' },
	'infraredilluminator' => { 411 => 0x28 },
	'ingredientexclusion' => { 535 => 'ingredientExclusion' },
	'ingredients' => { 544 => 'Ingredients' },
	'ingredientsalternatepaths' => { 544 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 544 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 544 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 544 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 544 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 544 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 544 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 544 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 544 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 544 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 544 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 544 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 544 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 544 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 544 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 544 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 544 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 544 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 544 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 544 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 544 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 544 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 544 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 88 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 502 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 502 => 'InitialHorizontalFOVDegrees' },
	'initialkey' => { 183 => 'WM/InitialKey' },
	'initialverticalfovdegrees' => { 502 => 'InitialVerticalFOVDegrees' },
	'initialviewheadingdegrees' => { 502 => 'InitialViewHeadingDegrees', 503 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 502 => 'InitialViewPitchDegrees', 503 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 502 => 'InitialViewRollDegrees', 503 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 305 => '4.4' },
	'initialzoomsetting' => { 305 => '9.3', 314 => '27.3' },
	'inkset' => { 123 => 0x14c },
	'inputprofile' => { 142 => 0x1389 },
	'instanceid' => { 544 => 'InstanceID' },
	'instantplaybacksetup' => { 188 => 0x3e },
	'instantplaybacktime' => { 188 => 0x3d },
	'instructions' => { 531 => 'Instructions' },
	'instrument' => { 543 => 'instrument' },
	'integrationtime' => { 142 => 0x423 },
	'intellectualgenre' => { 527 => 'IntellectualGenre' },
	'intelligentauto' => { 451 => 0xb052, 479 => 0xd, 480 => 0xe, 481 => 0xd },
	'intelligentcontrast' => { 54 => 0x4 },
	'intelligentd-range' => { 349 => 0x79 },
	'intelligentexposure' => { 349 => 0x5d },
	'intelligentresolution' => { 349 => 0x70 },
	'interchangecolorspace' => { 137 => 0x40 },
	'intergraphmatrix' => { 123 => 0x8480 },
	'internalflash' => { 185 => 0x2b, 305 => '23.1', 307 => '8.1', 310 => '22.1', 312 => '23.1', 316 => '8.1', 320 => '24.1', 328 => 0x1208 },
	'internalflashae1' => { 330 => 0x1021 },
	'internalflashae1_0' => { 330 => 0x101d },
	'internalflashae2' => { 330 => 0x1022 },
	'internalflashae2_0' => { 330 => 0x101e },
	'internalflashmode' => { 372 => 0x1 },
	'internalflashstrength' => { 372 => 0x3 },
	'internalflashtable' => { 330 => 0x1024 },
	'internallensserialnumber' => { 424 => 0xa005 },
	'internalndfilter' => { 349 => 0x9d },
	'internalserialnumber' => { 67 => 0x96, 79 => 0x9, 131 => 0x10, 191 => 0x49dc, 324 => 0x18, 326 => 0x102, 346 => 0x500, 349 => 0x25, 364 => 0x4, 417 => 0x5, 470 => [0x7c,0xf0], 471 => 0x88, 472 => [0x88,0x8a], 473 => 0x38 },
	'interopindex' => { 123 => 0x1, 521 => 'InteroperabilityIndex' },
	'interopversion' => { 123 => 0x2 },
	'interval' => { 263 => 0x20 },
	'intervaldurationhours' => { 244 => 0xa0, 245 => 0xb8, 246 => 0xb8 },
	'intervaldurationminutes' => { 244 => 0xa4, 245 => 0xbc, 246 => 0xbc },
	'intervaldurationseconds' => { 244 => 0xa8, 245 => 0xc0, 246 => 0xc0 },
	'intervalexposuresmoothing' => { 229 => 0x184, 244 => 0xb8, 245 => 0xd0, 246 => 0xd0 },
	'intervalframe' => { 263 => 0x24 },
	'intervallength' => { 185 => 0x10 },
	'intervalmode' => { 185 => 0x26 },
	'intervalnumber' => { 185 => 0x11 },
	'intervalpriority' => { 229 => 0x186, 244 => 0xba, 245 => 0xd2, 246 => 0xd2 },
	'intervals' => { 229 => 0x17c, 244 => 0xb0, 245 => 0xc8, 246 => 0xc8, 247 => 0xbc, 248 => 0xcc, 249 => 0xcc },
	'intervalshooting' => { 230 => 0x24, 265 => 0x24, 266 => 0x28, 385 => 0x92 },
	'introtime' => { 543 => 'introTime' },
	'introtimescale' => { 543 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 543 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 142 => 0xdae },
	'ipfcameramodel' => { 142 => 0xe4d },
	'iptc' => { 124 => 'IPTC' },
	'iptc-naa' => { 123 => 0x83bb, 354 => 0x83bb },
	'iptcbitspersample' => { 137 => 0x56 },
	'iptcdigest' => { 399 => 0x425 },
	'iptcimageheight' => { 137 => 0x1e },
	'iptcimagerotation' => { 137 => 0x66 },
	'iptcimagewidth' => { 137 => 0x14 },
	'iptclastedited' => { 528 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 137 => 0xa },
	'iptcpixelheight' => { 137 => 0x32 },
	'iptcpixelwidth' => { 137 => 0x28 },
	'isalternativeof' => { 533 => 'isAlternativeOf' },
	'isbn' => { 533 => 'isbn' },
	'iscorrectionof' => { 533 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 113 => 0x3 },
	'ismergedhdr' => { 511 => 'IsMergedHDR' },
	'ismergedpanorama' => { 511 => 'IsMergedPanorama' },
	'iso' => { 7 => 0x6, 9 => 0x6, 10 => 0x75, 11 => 0x6, 12 => 0x79, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x6, 31 => 0x0, 32 => 0x1, 116 => 0x14, 117 => [0x3014,0x14], 123 => 0x8827, 141 => 0xfd06, 142 => 0x1784, 144 => 0x60, 146 => [0xfa2e,0xfa46], 147 => [0x27,0x28], 148 => 0xf105, 151 => 0x14, 153 => 0x4e, 155 => 0x1e, 156 => 0x1a, 158 => 0x34, 160 => 'ISO', 185 => 0x8, 191 => 0x49ba, 228 => 0x0, 240 => 0x2, 349 => 0xd1, 354 => [0x17,0x37], 385 => [0x8b,0x14], 392 => 0x14, 394 => 0x105, 424 => 0xa014, 427 => 0x86, 448 => 0x6f, 456 => [0x1f,0x21,0x25], 520 => 'ISOSpeedRatings' },
	'iso2' => { 228 => 0x6, 270 => 0x265, 271 => 0x25c, 272 => 0x265, 273 => 0x221, 274 => 0x25d, 275 => 0x256, 276 => 0x25d, 279 => 0x2b5, 282 => 0x265, 286 => 0x2b5 },
	'isoauto' => { 365 => '14.4' },
	'isoautoflashlimit' => { 245 => 0x156, 246 => 0x156, 247 => 0x146, 248 => 0x15a, 249 => 0x15a },
	'isoautohilimit' => { 227 => 0x5, 245 => 0x154, 246 => 0x154, 247 => 0x144, 248 => 0x158, 249 => 0x158, 268 => 0x5, 278 => 0x18eb },
	'isoautomax' => { 450 => 0x4 },
	'isoautomin' => { 450 => 0x2 },
	'isoautominspeed' => { 385 => 0x7a },
	'isoautoshuttertime' => { 227 => 0x4, 245 => 0x15e, 246 => 0x15e, 247 => 0x14e, 248 => 0x162, 249 => 0x162, 268 => 0x4, 278 => 0x18ea },
	'isobutton' => { 249 => 0x796 },
	'isocalibrationgain' => { 142 => 0x89f },
	'isodisplay' => { 308 => '4.1', 309 => '4.1', 310 => '2.3', 311 => '3.3', 312 => '3.3', 315 => '3.3', 318 => '4.3', 319 => '4.1', 320 => '4.3' },
	'isoexpansion' => { 88 => 0x103, 89 => 0x7, 90 => 0x8, 93 => 0x8, 228 => 0x4 },
	'isoexpansion2' => { 228 => 0xa },
	'isofloor' => { 365 => 0x6 },
	'isoselected' => { 348 => 0x359 },
	'isoselection' => { 240 => 0xf },
	'isosensitivitystep' => { 313 => '6.2', 315 => '6.2' },
	'isosetting' => { 144 => 0x5e, 156 => 0x14, 160 => 'ISOSetting', 185 => 0x24, 186 => 0x26, 187 => 0x1c, 188 => 0x13, 193 => 0x6, 240 => 0x13, 365 => '17.3', 416 => 0x27, 437 => 0x16, 438 => 0x14, 439 => 0x2, 448 => 0x6d, 450 => 0x0 },
	'isospeed' => { 123 => 0x8833, 521 => 'ISOSpeed' },
	'isospeedexpansion' => { 87 => 0x3 },
	'isospeedincrements' => { 88 => 0x102 },
	'isospeedlatitudeyyy' => { 123 => 0x8834, 521 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 123 => 0x8835, 521 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 88 => 0x103 },
	'isostepsize' => { 305 => '6.1', 306 => '7.2', 308 => '7.2', 309 => '7.2', 314 => '4.1', 318 => '7.2', 319 => '7.2', 321 => 0x15d, 322 => 0x15d, 323 => 0x175 },
	'isovalue' => { 330 => 0x1001 },
	'isrc' => { 402 => 'xid ' },
	'isrccode' => { 410 => "\xa9isr" },
	'issn' => { 533 => 'issn' },
	'issueidentifier' => { 533 => 'issueIdentifier' },
	'issuename' => { 533 => 'issueName' },
	'issueteaser' => { 533 => 'issueTeaser' },
	'issuetype' => { 533 => 'issueType' },
	'istranslationof' => { 533 => 'isTranslationOf' },
	'itemsubtype' => { 182 => 'ItemSubType' },
	'itunesu' => { 402 => 'itnu' },
	'jobid' => { 135 => 0xb8 },
	'jobname' => { 522 => 'JobName' },
	'jobref' => { 542 => 'JobRef' },
	'jobrefid' => { 542 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 542 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 542 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 522 => 'JobStatus' },
	'jpeg-heifswitch' => { 451 => 0x2039 },
	'jpeghandling' => { 514 => 'JPEGHandling', 516 => 'JPEGHandling' },
	'jpegquality' => { 10 => 0x66, 349 => 0x43, 351 => 0x3034, 451 => 0xb047 },
	'jpegsize' => { 351 => 0x303a },
	'jpgcompression' => { 231 => 0x24, 240 => 0x44, 273 => '671.1' },
	'jpgfromraw' => { 101 => 0x2007, 118 => 'Exif-JpgFromRaw', 354 => 0x2e },
	'jpgfromrawlength' => { 123 => [0x117,0x202] },
	'jpgfromrawstart' => { 123 => [0x111,0x201] },
	'jpgrecordedpixels' => { 365 => '14.1' },
	'jurisdiction' => { 512 => 'jurisdiction' },
	'jxldecodespeed' => { 123 => 0xcd4b },
	'jxldistance' => { 123 => 0xcd49 },
	'jxleffort' => { 123 => 0xcd4a },
	'keepexposure' => { 321 => 0x237, 322 => 0x237, 323 => 0x24f },
	'kelvinwb_01' => { 373 => 0x5 },
	'kelvinwb_02' => { 373 => 0x9 },
	'kelvinwb_03' => { 373 => 0xd },
	'kelvinwb_04' => { 373 => 0x11 },
	'kelvinwb_05' => { 373 => 0x15 },
	'kelvinwb_06' => { 373 => 0x19 },
	'kelvinwb_07' => { 373 => 0x1d },
	'kelvinwb_08' => { 373 => 0x21 },
	'kelvinwb_09' => { 373 => 0x25 },
	'kelvinwb_10' => { 373 => 0x29 },
	'kelvinwb_11' => { 373 => 0x2d },
	'kelvinwb_12' => { 373 => 0x31 },
	'kelvinwb_13' => { 373 => 0x35 },
	'kelvinwb_14' => { 373 => 0x39 },
	'kelvinwb_15' => { 373 => 0x3d },
	'kelvinwb_16' => { 373 => 0x41 },
	'kelvinwb_daylight' => { 373 => 0x1 },
	'kerneldenominators' => { 142 => 0x933 },
	'key' => { 543 => 'key' },
	'keystonecompensation' => { 329 => 0x1900 },
	'keystonedirection' => { 329 => 0x1901 },
	'keystonevalue' => { 329 => 0x1906 },
	'keyword' => { 402 => 'keyw', 533 => 'keyword' },
	'keywordinfo' => { 175 => 'Keywords' },
	'keywords' => { 135 => 0x19, 161 => 'Keywords', 334 => 'Keywords', 401 => 'Keywords', 404 => 'keywords', 509 => 'keywords', 530 => 'Keywords', 541 => 'Keywords' },
	'killdate' => { 533 => 'killDate' },
	'killdatea-platform' => { 533 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 533 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 141 => 0xf908, 144 => 0xe, 146 => [0xfa1e,0xfa52], 152 => 0x70 },
	'kodakimagewidth' => { 141 => 0xf907, 144 => 0xc, 146 => [0xfa1d,0xfa51], 152 => 0x6c },
	'kodakinfotype' => { 141 => 0xfa00 },
	'kodaklook' => { 142 => 0xe4c },
	'kodaklookprofile' => { 142 => 0x138a },
	'kodakmaker' => { 152 => 0x8 },
	'kodakmodel' => { 144 => 0x0, 152 => 0x28 },
	'kodaktag' => { 142 => 0x3ea },
	'kodakversion' => { 142 => 0x0 },
	'label' => { 338 => 'Label', 541 => 'Label' },
	'labelname1' => { 526 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 526 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 526 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 526 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 526 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 526 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 349 => 0x6f },
	'landscapeoutputhighlightpoint' => { 113 => 0x26 },
	'landscapeoutputshadowpoint' => { 113 => 0x27 },
	'landscaperawcolortone' => { 113 => 0x1f },
	'landscaperawcontrast' => { 113 => 0x21 },
	'landscaperawhighlight' => { 113 => 0x77 },
	'landscaperawhighlightpoint' => { 113 => 0x24 },
	'landscaperawlinear' => { 113 => 0x22 },
	'landscaperawsaturation' => { 113 => 0x20 },
	'landscaperawshadow' => { 113 => 0x80 },
	'landscaperawshadowpoint' => { 113 => 0x25 },
	'landscaperawsharpness' => { 113 => 0x23 },
	'landscapeunsharpmaskfineness' => { 113 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 113 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 113 => 0xa2 },
	'language' => { 245 => 0x6a2, 246 => 0x6a2, 247 => 0x592, 248 => 0x5c2, 249 => 0x5da, 517 => 'language' },
	'languageidentifier' => { 135 => 0x87 },
	'largestvalidinteriorrectheight' => { 502 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 502 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 502 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 502 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 185 => 0x1b },
	'lastkeywordiptc' => { 182 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 182 => 'LastKeywordXMP' },
	'lastphotodate' => { 502 => 'LastPhotoDate' },
	'lasturl' => { 544 => 'LastURL' },
	'lateralchromaticaberration' => { 451 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 511 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 122 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 122 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 122 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 122 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 122 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'latitude' => { 120 => 'Latitude' },
	'lc1' => { 375 => 0x2 },
	'lc10' => { 375 => 0xb },
	'lc11' => { 375 => 0xc },
	'lc12' => { 375 => 0xd },
	'lc14' => { 375 => 0xf },
	'lc15' => { 375 => 0x10 },
	'lc3' => { 375 => 0x4 },
	'lc4' => { 375 => 0x5 },
	'lc5' => { 375 => 0x6 },
	'lc6' => { 375 => 0x7 },
	'lc7' => { 375 => 0x8 },
	'lc8' => { 375 => 0x9 },
	'lcddisplayatpoweron' => { 88 => 0x811, 92 => 0xa },
	'lcddisplayreturntoshoot' => { 93 => 0x12 },
	'lcdillumination' => { 305 => '17.5', 306 => '5.2', 308 => '5.1', 309 => '5.1', 314 => '10.3', 315 => '4.2', 318 => '5.2', 319 => '5.1', 320 => '5.4', 321 => 0x101, 322 => 0x101, 323 => 0x117 },
	'lcdilluminationduringbulb' => { 88 => 0x408 },
	'lcdmatrix' => { 142 => 0xe74 },
	'lcdmatrixchickfix' => { 142 => 0xe75 },
	'lcdmatrixmarvin' => { 142 => 0xe76 },
	'lcdpanels' => { 87 => 0x8 },
	'lcheditor' => { 298 => 0x8ae85e },
	'legacyiptcdigest' => { 531 => 'LegacyIPTCDigest' },
	'legalcode' => { 512 => 'legalcode' },
	'lens' => { 123 => 0xfdea, 240 => 0x84, 511 => 'Lens' },
	'lensafstopbutton' => { 86 => 0x11, 87 => 0x13, 88 => 0x506, 89 => 0x10, 90 => 0x12, 93 => 0x13, 94 => 0x9 },
	'lensaperturerange' => { 427 => [0x30,0x48] },
	'lensblur' => { 514 => 'LensBlur', 516 => 'LensBlur' },
	'lensbluractive' => { 514 => [\'LensBlur','LensBlurActive'], 516 => [\'LensBlur','LensBlurActive'] },
	'lensbluramount' => { 514 => [\'LensBlur','LensBlurBlurAmount'], 516 => [\'LensBlur','LensBlurBlurAmount'] },
	'lensblurbokehaspect' => { 514 => [\'LensBlur','LensBlurBokehAspect'], 516 => [\'LensBlur','LensBlurBokehAspect'] },
	'lensblurbokehrotation' => { 514 => [\'LensBlur','LensBlurBokehRotation'], 516 => [\'LensBlur','LensBlurBokehRotation'] },
	'lensblurbokehshape' => { 514 => [\'LensBlur','LensBlurBokehShape'], 516 => [\'LensBlur','LensBlurBokehShape'] },
	'lensblurbokehshapedetail' => { 514 => [\'LensBlur','LensBlurBokehShapeDetail'], 516 => [\'LensBlur','LensBlurBokehShapeDetail'] },
	'lensblurcateyeamount' => { 514 => [\'LensBlur','LensBlurCatEyeAmount'], 516 => [\'LensBlur','LensBlurCatEyeAmount'] },
	'lensblurcateyescale' => { 514 => [\'LensBlur','LensBlurCatEyeScale'], 516 => [\'LensBlur','LensBlurCatEyeScale'] },
	'lensblurfocalrange' => { 514 => [\'LensBlur','LensBlurFocalRange'], 516 => [\'LensBlur','LensBlurFocalRange'] },
	'lensblurfocalrangesource' => { 514 => [\'LensBlur','LensBlurFocalRangeSource'], 516 => [\'LensBlur','LensBlurFocalRangeSource'] },
	'lensblurhighlightsboost' => { 514 => [\'LensBlur','LensBlurHighlightsBoost'], 516 => [\'LensBlur','LensBlurHighlightsBoost'] },
	'lensblurhighlightsthreshold' => { 514 => [\'LensBlur','LensBlurHighlightsThreshold'], 516 => [\'LensBlur','LensBlurHighlightsThreshold'] },
	'lensblursampledarea' => { 514 => [\'LensBlur','LensBlurSampledArea'], 516 => [\'LensBlur','LensBlurSampledArea'] },
	'lensblursampledrange' => { 514 => [\'LensBlur','LensBlurSampledRange'], 516 => [\'LensBlur','LensBlurSampledRange'] },
	'lensblursphericalaberration' => { 514 => [\'LensBlur','LensBlurSphericalAberration'], 516 => [\'LensBlur','LensBlurSphericalAberration'] },
	'lensblursubjectrange' => { 514 => [\'LensBlur','LensBlurSubjectRange'], 516 => [\'LensBlur','LensBlurSubjectRange'] },
	'lensblurversion' => { 514 => [\'LensBlur','LensBlurVersion'], 516 => [\'LensBlur','LensBlurVersion'] },
	'lenscontrolring' => { 321 => 0xad, 322 => 0xad, 323 => 0xad },
	'lenscorrectionsettings' => { 519 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 511 => 'LensDistortInfo' },
	'lensdistortionparams' => { 330 => 0x206 },
	'lensdriveend' => { 238 => 0x56 },
	'lensdrivenoaf' => { 88 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 439 => 0x3f0, 487 => 0xd },
	'lensfirmware' => { 418 => 0x20, 424 => 0xa004 },
	'lensfirmwareversion' => { 326 => 0x204, 349 => 0x60, 439 => 0x3f3, 487 => 0x14 },
	'lensfocallength' => { 107 => 0xf0512, 375 => 0x9 },
	'lensfocalrange' => { 427 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 306 => '55.1', 308 => '52.1', 309 => '52.1', 318 => '52.1', 319 => '52.1' },
	'lensformat' => { 464 => 0x1891, 466 => 0x18bd, 467 => 0x18ed, 468 => 0x17f1, 470 => 0x106, 471 => 0x106, 482 => 0x603, 483 => 0x5d },
	'lensfstops' => { 232 => 0x7, 233 => 0xc, 234 => 0xd, 238 => 0xe, 240 => 0x8b, 375 => '0.3' },
	'lensfunc1button' => { 321 => 0x9f, 322 => 0x9f, 323 => 0x9f },
	'lensfunc1buttonplaybackmode' => { 246 => 0x80a, 249 => 0x810 },
	'lensfunc2button' => { 321 => 0xa7, 322 => 0xa7, 323 => 0xa7 },
	'lensfunc2buttonplaybackmode' => { 246 => 0x80c, 249 => 0x812 },
	'lensid' => { 238 => 0x30, 511 => 'LensID' },
	'lensidnumber' => { 232 => 0x6, 233 => 0xb, 234 => 0xc, 238 => 0xd },
	'lensinfo' => { 123 => 0xa432, 381 => 0x2a, 511 => 'LensInfo', 521 => 'LensSpecification' },
	'lenskind' => { 375 => 0x1 },
	'lensmake' => { 123 => 0xa433, 167 => 'Make', 521 => 'LensMake' },
	'lensmanualdistortionamount' => { 514 => 'LensManualDistortionAmount', 516 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 182 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 427 => 0x2b },
	'lensmodel' => { 7 => 0x937, 14 => 0x92b, 15 => 0x933, 67 => 0x95, 123 => 0xa434, 167 => 'Model', 182 => 'LensModel', 235 => 0x18a, 236 => 0x18b, 237 => 0x2ac, 326 => 0x203, 381 => 0xc, 394 => 0x412, 404 => 'camera.lens_model', 521 => 'LensModel' },
	'lensmodulationoptimizer' => { 131 => 0x1045 },
	'lensmount' => { 439 => 0x99, 464 => 0x1892, 466 => 0x18be, 467 => 0x18ee, 468 => 0x17f2, 470 => 0x105, 471 => 0x105, 482 => 0x604, 483 => 0x5e },
	'lensmount2' => { 487 => 0x8 },
	'lensmounttype' => { 238 => 0x35 },
	'lenspositionabsolute' => { 238 => 0x5a },
	'lensprofilechromaticaberrationscale' => { 514 => 'LensProfileChromaticAberrationScale', 516 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 514 => 'LensProfileDigest', 516 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 514 => 'LensProfileDistortionScale', 516 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 514 => 'LensProfileEnable', 516 => 'LensProfileEnable' },
	'lensprofilefilename' => { 514 => 'LensProfileFilename', 516 => 'LensProfileFilename' },
	'lensprofileisembedded' => { 514 => 'LensProfileIsEmbedded', 516 => 'LensProfileIsEmbedded' },
	'lensprofilematchkeycameramodelname' => { 514 => 'LensProfileMatchKeyCameraModelName', 516 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 514 => 'LensProfileMatchKeyExifMake', 516 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 514 => 'LensProfileMatchKeyExifModel', 516 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 514 => 'LensProfileMatchKeyIsRaw', 516 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 514 => 'LensProfileMatchKeyLensID', 516 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 514 => 'LensProfileMatchKeyLensInfo', 516 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 514 => 'LensProfileMatchKeyLensName', 516 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 514 => 'LensProfileMatchKeySensorFormatFactor', 516 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 348 => 0x370, 514 => 'LensProfileName', 516 => 'LensProfileName' },
	'lensprofilesetup' => { 514 => 'LensProfileSetup', 516 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 514 => 'LensProfileVignettingScale', 516 => 'LensProfileVignettingScale' },
	'lensproperties' => { 326 => 0x20b },
	'lensserialnumber' => { 21 => 0x164, 34 => 0x16b, 63 => 0x0, 123 => 0xa435, 167 => 'SerialNumber', 326 => 0x202, 347 => 0x321, 349 => 0x52, 410 => 'LENS', 418 => 0x30, 511 => 'LensSerialNumber', 521 => 'LensSerialNumber' },
	'lensshutterlock' => { 188 => 0x4a },
	'lensspec' => { 434 => 0x0, 435 => 0x0, 436 => 0x0, 451 => 0xb02a },
	'lensspecfeatures' => { 470 => [0x115,0x116], 471 => [0x116,0x1ed,0x1f0,0x21c,0x21e] },
	'lenstemperature' => { 330 => 0x1008 },
	'lenstype' => { 7 => 0xe2, 8 => 0xd, 9 => 0x1a7, 10 => 0xc, 11 => 0x111, 12 => 0xc, 13 => 0x14f, 14 => 0xd6, 15 => 0xde, 16 => 0xf6, 17 => 0xea, 18 => 0xff, 19 => [0xc,0x97], 20 => 0xe6, 21 => 0x153, 22 => 0xea, 23 => 0xe8, 24 => 0x127, 25 => 0x161, 26 => 0x166, 27 => 0x184, 28 => 0x112, 29 => 0x189, 36 => 0x16, 190 => 0x10c, 191 => 0x49bd, 240 => 0x83, 326 => 0x201, 340 => 0x16, 344 => 0x310, 346 => 0x303, 347 => 0x303, 349 => 0x51, 351 => 0x3405, 376 => 0x0, 377 => 0x0, 378 => 0x1, 379 => 0x1, 380 => 0x1, 382 => 0x0, 424 => 0xa003, 427 => 0x27, 451 => 0xb027, 464 => 0x1896, 466 => 0x18c2, 467 => 0x18f2, 468 => 0x17f6, 470 => 0x109, 471 => 0x109, 482 => 0x608, 483 => 0x62 },
	'lenstype2' => { 439 => 0x3f7, 464 => 0x1893, 466 => 0x18bf, 467 => 0x18ef, 468 => 0x17f3, 470 => 0x107, 471 => 0x107, 482 => 0x605, 483 => 0x60 },
	'lenstype3' => { 487 => 0x9 },
	'lenstypemake' => { 349 => 0xc4 },
	'lenstypemodel' => { 349 => [0xc5,0xe4] },
	'lenszoomposition' => { 479 => 0x19, 480 => 0x1e, 483 => [0x342,0x34e,0x35a] },
	'levelindicator' => { 357 => 0x15 },
	'levelmeter' => { 410 => ['Lvlm','lvlm'] },
	'levelorientation' => { 383 => 0x0 },
	'license' => { 512 => 'license' },
	'licensee' => { 335 => 'Licensee' },
	'licenseeid' => { 335 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 335 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 335 => 'LicenseeImageNotes' },
	'licenseename' => { 335 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 335 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 335 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 335 => 'LicenseeTransactionID' },
	'licenseid' => { 335 => 'LicenseID' },
	'licensestartdate' => { 335 => 'LicenseStartDate' },
	'licensetransactiondate' => { 335 => 'LicenseTransactionDate' },
	'licensetype' => { 518 => 'licensetype' },
	'licensor' => { 335 => 'Licensor' },
	'licensorcity' => { 335 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 335 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 335 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 335 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 335 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 335 => 'LicensorImageID' },
	'licensorname' => { 335 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 335 => 'LicensorNotes' },
	'licensorpostalcode' => { 335 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 335 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 335 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 335 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 335 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 335 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 335 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 335 => 'LicensorTransactionID' },
	'licensorurl' => { 335 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 330 => 0x1009 },
	'lightingmode' => { 117 => 0x302a },
	'lightreading' => { 385 => 0x15 },
	'lightsource' => { 123 => 0x9208, 240 => 0x90, 333 => 0x1000, 520 => 'LightSource' },
	'lightsourcespecial' => { 426 => 0x21d },
	'lightswitch' => { 318 => '0.1', 320 => '0.1' },
	'lightvaluecenter' => { 330 => 0x103d },
	'lightvalueperiphery' => { 330 => 0x103e },
	'limitaf-areamodesel3dtracking' => { 321 => 0x153, 322 => 0x153, 323 => 0x16b },
	'limitaf-areamodeseldynamic_l' => { 321 => 0x151, 322 => 0x151, 323 => 0x169 },
	'limitaf-areamodeseldynamic_m' => { 321 => 0x150, 322 => 0x150, 323 => 0x168 },
	'limitaf-areamodeseldynamic_s' => { 321 => 0x14f, 322 => 0x14f, 323 => 0x167 },
	'limitaf-areamodeselpinpoint' => { 321 => 0x11, 322 => 0x11, 323 => 0x11 },
	'limitaf-areamodeselwideaf_l' => { 321 => 0x14, 322 => 0x14, 323 => 0x14 },
	'limitaf-areamodeselwideaf_s' => { 321 => 0x13, 322 => 0x13, 323 => 0x13 },
	'limitafareamodeselauto' => { 321 => 0x15, 322 => 0x15, 323 => 0x15 },
	'limitafareamodeselection' => { 306 => '51.1', 308 => '49.1', 309 => '49.1', 318 => '49.1', 319 => '49.1' },
	'limitreleasemodeselc120' => { 322 => '269.4', 323 => '293.4' },
	'limitreleasemodeselc30' => { 322 => '269.3', 323 => '293.3' },
	'limitreleasemodeselch' => { 322 => '269.2', 323 => '293.2' },
	'limitreleasemodeselcl' => { 322 => '269.1', 323 => '293.1' },
	'limitreleasemodeselself' => { 322 => '269.5', 323 => '293.5' },
	'limitselectableimagearea16to9' => { 321 => 0x47, 322 => 0x47, 323 => 0x47 },
	'limitselectableimagearea1to1' => { 321 => 0x46, 322 => 0x46, 323 => 0x46 },
	'limitselectableimageareadx' => { 321 => 0x45, 322 => 0x45, 323 => 0x45 },
	'linearitylimitblue' => { 354 => 0x10 },
	'linearitylimitgreen' => { 354 => 0xf },
	'linearitylimitred' => { 354 => 0xe },
	'linearityuppermargin' => { 43 => 0x32c, 44 => 0x282, 47 => [0x2ba,0x2d1,0x2d5], 49 => 0x1e5, 50 => [0x1fe,0x2de], 51 => [0x232,0x310], 52 => 0x31e },
	'linearizationtable' => { 123 => 0xc618 },
	'linearresponselimit' => { 123 => 0xc62e },
	'link' => { 533 => 'link' },
	'linkaetoafpoint' => { 365 => '14.2' },
	'linkedencodedrightsexpr' => { 528 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 528 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 528 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 528 => 'LinkedEncRightsExpr' },
	'linlogcoring' => { 142 => 0x904 },
	'lithostratigraphicterms' => { 122 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'livephotoauto' => { 404 => 'live-photo.auto' },
	'livephotovideoindex' => { 1 => 0x17 },
	'livephotovitalityscore' => { 404 => 'live-photo.vitality-score' },
	'livephotovitalityscoringversion' => { 404 => 'live-photo.vitality-scoring-version' },
	'liveview' => { 360 => 0x1fa, 367 => 0x3 },
	'liveviewaf' => { 310 => '32.1', 320 => '34.1' },
	'liveviewafareamode' => { 315 => '34.1' },
	'liveviewafmethod' => { 456 => 0x20 },
	'liveviewafmode' => { 315 => '34.2' },
	'liveviewafsetting' => { 439 => 0x36 },
	'liveviewbuttonoptions' => { 306 => '50.2', 308 => '48.2', 309 => '48.2', 318 => '48.2', 319 => '48.2' },
	'liveviewexposuresimulation' => { 88 => 0x810 },
	'liveviewfocusmode' => { 439 => [0x8b,0x28b] },
	'liveviewmetering' => { 439 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 306 => '21.2', 308 => '21.2', 309 => '21.2', 311 => '20.2', 312 => '20.2', 313 => '20.2', 315 => '20.2', 318 => '21.2', 319 => '21.2' },
	'liveviewshooting' => { 59 => 0x13 },
	'livingspecimen' => { 122 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 122 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 135 => 0x79 },
	'localizedcameramodel' => { 123 => 0xc615 },
	'locallocationname' => { 424 => 0x30 },
	'location' => { 239 => 0x9, 349 => 0x67, 507 => 'Location', 527 => 'Location', 532 => 'location', 533 => 'location' },
	'locationaccuracyhorizontal' => { 404 => 'location.accuracy.horizontal' },
	'locationareacode' => { 513 => 'lac' },
	'locationbody' => { 404 => 'location.body' },
	'locationcreated' => { 528 => 'LocationCreated' },
	'locationcreatedcity' => { 528 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 528 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 528 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 528 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpsaltituderef' => { 528 => [\'LocationCreated','LocationCreatedGPSAltitudeRef'] },
	'locationcreatedgpslatitude' => { 528 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 528 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 528 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 528 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 528 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 528 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 528 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 528 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationdate' => { 404 => 'location.date' },
	'locationinformation' => { 410 => 'loci' },
	'locationinfoversion' => { 239 => 0x0 },
	'locationname' => { 404 => 'location.name', 424 => 0x31 },
	'locationnote' => { 404 => 'location.note' },
	'locationrole' => { 404 => 'location.role' },
	'locationshown' => { 528 => 'LocationShown' },
	'locationshowncity' => { 528 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 528 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 528 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 528 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpsaltituderef' => { 528 => [\'LocationShown','LocationShownGPSAltitudeRef'] },
	'locationshowngpslatitude' => { 528 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 528 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 528 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 528 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 528 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 528 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 528 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 528 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 88 => 0x709 },
	'logcomment' => { 543 => 'logComment' },
	'logscale' => { 142 => 0x902 },
	'longdescription' => { 402 => 'ldes' },
	'longexposurenoisereduction' => { 65 => 0x4, 88 => 0x201, 89 => 0x1, 90 => 0x2, 91 => 0x1, 92 => 0x1, 93 => 0x2, 94 => 0x1, 349 => 0x49, 437 => 0x2b, 438 => 0x25, 439 => 0x25, 451 => 0x2008, 456 => 0x11, 483 => 0x44 },
	'longexposurenoisereduction2' => { 59 => 0x8 },
	'longexposurenrused' => { 349 => 0xbe },
	'longitude' => { 120 => 'Longitude' },
	'look' => { 514 => 'Look', 516 => 'Look' },
	'lookamount' => { 514 => [\'Look','LookAmount'], 516 => [\'Look','LookAmount'] },
	'lookcluster' => { 514 => [\'Look','LookCluster'], 516 => [\'Look','LookCluster'] },
	'lookcopyright' => { 514 => [\'Look','LookCopyright'], 516 => [\'Look','LookCopyright'] },
	'lookgroup' => { 514 => [\'Look','LookGroup'], 516 => [\'Look','LookGroup'] },
	'lookname' => { 514 => 'LookName', 516 => 'LookName' },
	'lookparameters' => { 514 => [\'Look','LookParameters'], 516 => [\'Look','LookParameters'] },
	'lookparameterscameraprofile' => { 514 => [\'Look','LookParametersCameraProfile'], 516 => [\'Look','LookParametersCameraProfile'] },
	'lookparametersclarity2012' => { 514 => [\'Look','LookParametersClarity2012'], 516 => [\'Look','LookParametersClarity2012'] },
	'lookparametersconverttograyscale' => { 514 => [\'Look','LookParametersConvertToGrayscale'], 516 => [\'Look','LookParametersConvertToGrayscale'] },
	'lookparametershighlights2012' => { 514 => [\'Look','LookParametersHighlights2012'], 516 => [\'Look','LookParametersHighlights2012'] },
	'lookparameterslooktable' => { 514 => [\'Look','LookParametersLookTable'], 516 => [\'Look','LookParametersLookTable'] },
	'lookparametersprocessversion' => { 514 => [\'Look','LookParametersProcessVersion'], 516 => [\'Look','LookParametersProcessVersion'] },
	'lookparametersshadows2012' => { 514 => [\'Look','LookParametersShadows2012'], 516 => [\'Look','LookParametersShadows2012'] },
	'lookparameterstonecurvepv2012' => { 514 => [\'Look','LookParametersToneCurvePV2012'], 516 => [\'Look','LookParametersToneCurvePV2012'] },
	'lookparameterstonecurvepv2012blue' => { 514 => [\'Look','LookParametersToneCurvePV2012Blue'], 516 => [\'Look','LookParametersToneCurvePV2012Blue'] },
	'lookparameterstonecurvepv2012green' => { 514 => [\'Look','LookParametersToneCurvePV2012Green'], 516 => [\'Look','LookParametersToneCurvePV2012Green'] },
	'lookparameterstonecurvepv2012red' => { 514 => [\'Look','LookParametersToneCurvePV2012Red'], 516 => [\'Look','LookParametersToneCurvePV2012Red'] },
	'lookparametersversion' => { 514 => [\'Look','LookParametersVersion'], 516 => [\'Look','LookParametersVersion'] },
	'looksupportsamount' => { 514 => [\'Look','LookSupportsAmount'], 516 => [\'Look','LookSupportsAmount'] },
	'looksupportsmonochrome' => { 514 => [\'Look','LookSupportsMonochrome'], 516 => [\'Look','LookSupportsMonochrome'] },
	'looksupportsoutputreferred' => { 514 => [\'Look','LookSupportsOutputReferred'], 516 => [\'Look','LookSupportsOutputReferred'] },
	'lookuuid' => { 514 => [\'Look','LookUUID'], 516 => [\'Look','LookUUID'] },
	'loop' => { 543 => 'loop' },
	'loopstyle' => { 410 => 'LOOP' },
	'lowestbiostratigraphiczone' => { 122 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 514 => 'LuminanceAdjustmentAqua', 516 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 514 => 'LuminanceAdjustmentBlue', 516 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 514 => 'LuminanceAdjustmentGreen', 516 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 514 => 'LuminanceAdjustmentMagenta', 516 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 514 => 'LuminanceAdjustmentOrange', 516 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 514 => 'LuminanceAdjustmentPurple', 516 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 514 => 'LuminanceAdjustmentRed', 516 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 514 => 'LuminanceAdjustmentYellow', 516 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 112 => 0x150 },
	'luminancecurvepoints' => { 112 => 0x126 },
	'luminancenoiseamplitude' => { 1 => 0x1d },
	'luminancenoisereduction' => { 107 => 0x20600, 113 => 0x5f, 427 => 0x1b },
	'luminancenoisereductioncontrast' => { 514 => 'LuminanceNoiseReductionContrast', 516 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 514 => 'LuminanceNoiseReductionDetail', 516 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 113 => 0x6d },
	'luminancesmoothing' => { 514 => 'LuminanceSmoothing', 516 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 88 => [0x40b,0x40c] },
	'lyrics' => { 402 => "\xa9lyr", 410 => "\xa9lyr", 543 => 'lyrics' },
	'lyricsuri' => { 410 => 'lrcu' },
	'm16cversion' => { 344 => 0x333 },
	'macatom' => { 515 => 'macAtom' },
	'macatomapplicationcode' => { 515 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 515 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 515 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 122 => 'MachineObservation' },
	'machineobservationday' => { 122 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 122 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 122 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 122 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 122 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 122 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 122 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationfieldnotes' => { 122 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 122 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 122 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 122 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 122 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 122 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 122 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 122 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 122 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 122 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 122 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 122 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 122 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 131 => 0x1020, 133 => 0x202, 155 => 0x2b, 330 => 0x202, 416 => 0x21, 426 => 0x202, 451 => 0xb040 },
	'macroled' => { 328 => 0x120a },
	'macromagnification' => { 7 => 0x1b, 11 => 0x1b, 14 => 0x1b, 15 => 0x1b, 19 => 0x1b, 20 => 0x1b, 59 => 0x10 },
	'macromode' => { 36 => 0x1, 185 => 0xb, 325 => 0x300, 349 => 0x1c, 417 => 0x1009 },
	'magentahsl' => { 107 => 0x20917 },
	'magicfilter' => { 325 => 0x52c },
	'magnifiedview' => { 90 => 0x11, 92 => 0x9 },
	'mainboardversion' => { 142 => 0x438 },
	'maindialexposurecomp' => { 316 => '0.6' },
	'mainingredient' => { 535 => 'mainIngredient' },
	'majorbrand' => { 404 => 'major_brand' },
	'majorversion' => { 505 => 'MajorVersion' },
	'make' => { 102 => 0x0, 119 => 0x1, 123 => 0x10f, 160 => 'Make', 338 => 'Make', 354 => 0x10f, 404 => 'make', 410 => ['@mak',"\xa9mak"], 532 => 'make', 539 => 'Make' },
	'makernote' => { 520 => 'MakerNote' },
	'makernoteapple' => { 121 => 'MakN', 123 => 0x927c },
	'makernotecanon' => { 85 => 'CMT3', 121 => 'MakN', 123 => 0x927c },
	'makernotecasio' => { 121 => 'MakN', 123 => 0x927c },
	'makernotecasio2' => { 121 => 'MakN', 123 => 0x927c },
	'makernotedji' => { 121 => 'MakN', 123 => 0x927c },
	'makernotedjiinfo' => { 121 => 'MakN', 123 => 0x927c },
	'makernoteflir' => { 121 => 'MakN', 123 => 0x927c },
	'makernotefujifilm' => { 121 => 'MakN', 123 => 0x927c },
	'makernotege' => { 121 => 'MakN', 123 => 0x927c },
	'makernotege2' => { 121 => 'MakN', 123 => 0x927c },
	'makernotehasselblad' => { 121 => 'MakN', 123 => 0x927c },
	'makernotehp' => { 121 => 'MakN', 123 => 0x927c },
	'makernotehp2' => { 121 => 'MakN', 123 => 0x927c },
	'makernotehp4' => { 121 => 'MakN', 123 => 0x927c },
	'makernotehp6' => { 121 => 'MakN', 123 => 0x927c },
	'makernoteisl' => { 121 => 'MakN', 123 => 0x927c },
	'makernotejvc' => { 121 => 'MakN', 123 => 0x927c },
	'makernotejvctext' => { 121 => 'MakN', 123 => 0x927c },
	'makernotekodak10' => { 121 => 'MakN', 123 => 0x927c },
	'makernotekodak11' => { 121 => 'MakN', 123 => 0x927c },
	'makernotekodak12' => { 121 => 'MakN', 123 => 0x927c },
	'makernotekodak1a' => { 121 => 'MakN', 123 => 0x927c },
	'makernotekodak1b' => { 121 => 'MakN', 123 => 0x927c },
	'makernotekodak2' => { 121 => 'MakN', 123 => 0x927c },
	'makernotekodak3' => { 121 => 'MakN', 123 => 0x927c },
	'makernotekodak4' => { 121 => 'MakN', 123 => 0x927c },
	'makernotekodak5' => { 121 => 'MakN', 123 => 0x927c },
	'makernotekodak6a' => { 121 => 'MakN', 123 => 0x927c },
	'makernotekodak6b' => { 121 => 'MakN', 123 => 0x927c },
	'makernotekodak7' => { 121 => 'MakN', 123 => 0x927c },
	'makernotekodak8a' => { 121 => 'MakN', 123 => 0x927c },
	'makernotekodak8b' => { 121 => 'MakN', 123 => 0x927c },
	'makernotekodak8c' => { 121 => 'MakN', 123 => 0x927c },
	'makernotekodak9' => { 121 => 'MakN', 123 => 0x927c },
	'makernotekodakunknown' => { 121 => 'MakN', 123 => 0x927c },
	'makernotekyocera' => { 121 => 'MakN', 123 => 0x927c },
	'makernoteleica' => { 121 => 'MakN', 123 => 0x927c },
	'makernoteleica10' => { 121 => 'MakN', 123 => 0x927c },
	'makernoteleica2' => { 121 => 'MakN', 123 => 0x927c },
	'makernoteleica3' => { 121 => 'MakN', 123 => 0x927c },
	'makernoteleica4' => { 121 => 'MakN', 123 => 0x927c },
	'makernoteleica5' => { 121 => 'MakN', 123 => 0x927c },
	'makernoteleica6' => { 121 => 'MakN', 123 => 0x927c },
	'makernoteleica7' => { 121 => 'MakN', 123 => 0x927c },
	'makernoteleica8' => { 121 => 'MakN', 123 => 0x927c },
	'makernoteleica9' => { 121 => 'MakN', 123 => 0x927c },
	'makernoteminolta' => { 121 => 'MakN', 123 => 0x927c },
	'makernoteminolta2' => { 121 => 'MakN', 123 => 0x927c },
	'makernoteminolta3' => { 121 => 'MakN', 123 => 0x927c },
	'makernotemotorola' => { 121 => 'MakN', 123 => 0x927c },
	'makernotenikon' => { 121 => 'MakN', 123 => 0x927c },
	'makernotenikon2' => { 121 => 'MakN', 123 => 0x927c },
	'makernotenikon3' => { 121 => 'MakN', 123 => 0x927c },
	'makernotenintendo' => { 121 => 'MakN', 123 => 0x927c },
	'makernoteoffset' => { 426 => 0xff },
	'makernoteolympus' => { 121 => 'MakN', 123 => 0x927c },
	'makernoteolympus2' => { 121 => 'MakN', 123 => 0x927c },
	'makernoteolympus3' => { 121 => 'MakN', 123 => 0x927c },
	'makernotepanasonic' => { 121 => 'MakN', 123 => 0x927c },
	'makernotepanasonic2' => { 121 => 'MakN', 123 => 0x927c },
	'makernotepanasonic3' => { 121 => 'MakN', 123 => 0x927c },
	'makernotepentax' => { 121 => 'MakN', 123 => 0x927c },
	'makernotepentax2' => { 121 => 'MakN', 123 => 0x927c },
	'makernotepentax3' => { 121 => 'MakN', 123 => 0x927c },
	'makernotepentax4' => { 121 => 'MakN', 123 => 0x927c },
	'makernotepentax5' => { 121 => 'MakN', 123 => 0x927c },
	'makernotepentax6' => { 121 => 'MakN', 123 => 0x927c },
	'makernotepentaxunknown' => { 410 => 'PXMN' },
	'makernotephaseone' => { 121 => 'MakN', 123 => 0x927c },
	'makernotereconyx' => { 121 => 'MakN', 123 => 0x927c },
	'makernotereconyx2' => { 121 => 'MakN', 123 => 0x927c },
	'makernotereconyx3' => { 121 => 'MakN', 123 => 0x927c },
	'makernotericoh' => { 121 => 'MakN', 123 => 0x927c },
	'makernotericoh2' => { 121 => 'MakN', 123 => 0x927c },
	'makernotericohpentax' => { 121 => 'MakN', 123 => 0x927c },
	'makernotericohtext' => { 121 => 'MakN', 123 => 0x927c },
	'makernotesafety' => { 123 => 0xc635 },
	'makernotesamsung1a' => { 121 => 'MakN', 123 => 0x927c },
	'makernotesamsung1b' => { 121 => 'MakN', 123 => 0x927c },
	'makernotesamsung2' => { 121 => 'MakN', 123 => 0x927c },
	'makernotesanyo' => { 121 => 'MakN', 123 => 0x927c },
	'makernotesanyoc4' => { 121 => 'MakN', 123 => 0x927c },
	'makernotesanyopatch' => { 121 => 'MakN', 123 => 0x927c },
	'makernotesigma' => { 121 => 'MakN', 123 => 0x927c },
	'makernotesony' => { 121 => 'MakN', 123 => 0x927c },
	'makernotesony2' => { 121 => 'MakN', 123 => 0x927c },
	'makernotesony3' => { 121 => 'MakN', 123 => 0x927c },
	'makernotesony4' => { 121 => 'MakN', 123 => 0x927c },
	'makernotesony5' => { 121 => 'MakN', 123 => 0x927c },
	'makernotesonyericsson' => { 121 => 'MakN', 123 => 0x927c },
	'makernotesonysrf' => { 121 => 'MakN', 123 => 0x927c },
	'makernotetype' => { 417 => 0x1 },
	'makernoteunknown' => { 121 => 'MakN', 123 => 0x927c },
	'makernoteunknownbinary' => { 121 => 'MakN', 123 => 0x927c },
	'makernoteunknowntext' => { 121 => 'MakN', 123 => 0x927c },
	'makernoteversion' => { 1 => 0x1, 190 => 0x0, 240 => 0x1, 330 => 0x0, 349 => 0x8000, 421 => 0x0, 424 => 0x1, 427 => [0x1d,0x1f], 440 => 0x2000 },
	'makerurl' => { 410 => "\xa9mal" },
	'managedfrom' => { 544 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 544 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 544 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 544 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 544 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 544 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 544 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 544 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 544 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 544 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 544 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 544 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 544 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 544 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 544 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 544 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 544 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 544 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 544 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 544 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 544 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 544 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 544 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 544 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 544 => 'Manager' },
	'managervariant' => { 544 => 'ManagerVariant' },
	'manageto' => { 544 => 'ManageTo' },
	'manageui' => { 544 => 'ManageUI' },
	'manifest' => { 544 => 'Manifest' },
	'manifestlinkform' => { 544 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 544 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 544 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 544 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 544 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 544 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 544 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 544 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 544 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 544 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 544 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 544 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 544 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 544 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 544 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 544 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 544 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 544 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 544 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 544 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 544 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 544 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 544 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 544 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 544 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 544 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 544 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 544 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 325 => 0x900, 349 => 0x86 },
	'manometerreading' => { 325 => 0x901 },
	'manualafpointselectpattern' => { 88 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 328 => 0x1209 },
	'manualflashoutput' => { 36 => 0x29, 307 => '8.2', 310 => '22.2', 311 => '23.1', 312 => '23.2', 314 => '16.2', 315 => '23.2', 316 => '8.2', 317 => '23.2', 320 => '24.2', 417 => 0x100c },
	'manualflashstrength' => { 325 => 0x406 },
	'manualfocusdistance' => { 240 => 0x85, 330 => 0x100c, 426 => 0x223 },
	'manualfocuspointillumination' => { 321 => 0x17, 322 => 0x17, 323 => 0x17 },
	'manualfocusringinafmode' => { 321 => 0x1a, 322 => 0x1a, 323 => 0x1a },
	'manualtv' => { 87 => 0x5, 88 => 0x705 },
	'manufacturedate' => { 195 => 0x6705, 364 => 0x1 },
	'manufacturedate1' => { 419 => 0x4 },
	'manufacturedate2' => { 419 => 0x5 },
	'manufacturer' => { 499 => 'Manufacturer', 532 => 'manufacturer' },
	'mariahchromablursize' => { 142 => 0xf0d },
	'mariahmaphithreshold' => { 142 => 0xf0c },
	'mariahmaplothreshold' => { 142 => 0xf0b },
	'mariahsigmathreshold' => { 142 => 0xf0e },
	'mariahtexturethreshold' => { 142 => 0xf0a },
	'marked' => { 530 => 'Marked', 547 => 'Marked' },
	'markers' => { 543 => 'markers' },
	'markerscomment' => { 543 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 543 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 543 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 543 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 543 => [\'markers','markersCuePointType'] },
	'markersduration' => { 543 => [\'markers','markersDuration'] },
	'markerslocation' => { 543 => [\'markers','markersLocation'] },
	'markersname' => { 543 => [\'markers','markersName'] },
	'markersprobability' => { 543 => [\'markers','markersProbability'] },
	'markersspeaker' => { 543 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 543 => [\'markers','markersStartTime'] },
	'markerstarget' => { 543 => [\'markers','markersTarget'] },
	'markerstype' => { 543 => [\'markers','markersType'] },
	'maskedareas' => { 123 => 0xc68e },
	'maskgroupbasedcorractive' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'] },
	'maskgroupbasedcorramount' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'] },
	'maskgroupbasedcorrblacks2012' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'] },
	'maskgroupbasedcorrbrightness' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'] },
	'maskgroupbasedcorrclarity' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'] },
	'maskgroupbasedcorrclarity2012' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'] },
	'maskgroupbasedcorrcontrast' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'] },
	'maskgroupbasedcorrcontrast2012' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'] },
	'maskgroupbasedcorrcorrectionname' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'] },
	'maskgroupbasedcorrcorrectionsyncid' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'] },
	'maskgroupbasedcorrdefringe' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'] },
	'maskgroupbasedcorrdehaze' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'] },
	'maskgroupbasedcorrections' => { 514 => 'MaskGroupBasedCorrections', 516 => 'MaskGroupBasedCorrections' },
	'maskgroupbasedcorrexposure' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'] },
	'maskgroupbasedcorrexposure2012' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'] },
	'maskgroupbasedcorrhighlights2012' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'] },
	'maskgroupbasedcorrhue' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'] },
	'maskgroupbasedcorrluminancenoise' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'] },
	'maskgroupbasedcorrmask' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'] },
	'maskgroupbasedcorrmaskalpha' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'] },
	'maskgroupbasedcorrmaskangle' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'] },
	'maskgroupbasedcorrmaskbottom' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'] },
	'maskgroupbasedcorrmaskcentervalue' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'] },
	'maskgroupbasedcorrmaskcenterweight' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'] },
	'maskgroupbasedcorrmaskdabs' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'] },
	'maskgroupbasedcorrmaskfeather' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'] },
	'maskgroupbasedcorrmaskflipped' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'] },
	'maskgroupbasedcorrmaskflow' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'] },
	'maskgroupbasedcorrmaskfullx' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'] },
	'maskgroupbasedcorrmaskfully' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'] },
	'maskgroupbasedcorrmaskinputdigest' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'] },
	'maskgroupbasedcorrmaskleft' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'] },
	'maskgroupbasedcorrmaskmaskactive' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'] },
	'maskgroupbasedcorrmaskmaskblendmode' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmaskdigest' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmaskinverted' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmaskname' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'] },
	'maskgroupbasedcorrmaskmasks' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'] },
	'maskgroupbasedcorrmaskmasksalpha' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'maskgroupbasedcorrmaskmasksangle' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'] },
	'maskgroupbasedcorrmaskmasksbottom' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'] },
	'maskgroupbasedcorrmaskmaskscentervalue' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'maskgroupbasedcorrmaskmaskscenterweight' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'maskgroupbasedcorrmaskmasksdabs' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'] },
	'maskgroupbasedcorrmaskmasksfeather' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'] },
	'maskgroupbasedcorrmaskmasksflipped' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'maskgroupbasedcorrmaskmasksflow' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'] },
	'maskgroupbasedcorrmaskmasksfullx' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'] },
	'maskgroupbasedcorrmaskmasksfully' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'] },
	'maskgroupbasedcorrmaskmasksinputdigest' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'maskgroupbasedcorrmaskmasksleft' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'] },
	'maskgroupbasedcorrmaskmasksmaskactive' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'maskgroupbasedcorrmaskmasksmaskblendmode' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmasksmaskdigest' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmasksmaskinverted' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmasksmaskname' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'maskgroupbasedcorrmaskmasksmasksubtype' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksmasksyncid' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmasksmaskversion' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmasksmidpoint' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'maskgroupbasedcorrmaskmasksorigin' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'maskgroupbasedcorrmaskmasksperimetervalue' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskmasksradius' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'] },
	'maskgroupbasedcorrmaskmasksreferencepoint' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'maskgroupbasedcorrmaskmasksright' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'] },
	'maskgroupbasedcorrmaskmasksroundness' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'maskgroupbasedcorrmaskmaskssizex' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'maskgroupbasedcorrmaskmaskssizey' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'maskgroupbasedcorrmaskmaskstop' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'] },
	'maskgroupbasedcorrmaskmasksubtype' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksvalue' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'maskgroupbasedcorrmaskmasksversion' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'] },
	'maskgroupbasedcorrmaskmaskswhat' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'] },
	'maskgroupbasedcorrmaskmaskswholeimagearea' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskmasksx' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'] },
	'maskgroupbasedcorrmaskmasksy' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'] },
	'maskgroupbasedcorrmaskmasksyncid' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmaskszerox' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'maskgroupbasedcorrmaskmaskszeroy' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'maskgroupbasedcorrmaskmaskversion' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmidpoint' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'] },
	'maskgroupbasedcorrmaskorigin' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'] },
	'maskgroupbasedcorrmaskperimetervalue' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskradius' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'] },
	'maskgroupbasedcorrmaskrange' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'maskgroupbasedcorrmaskrangeareamodels' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrmaskrangeareamodelscolorsampleinfo' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrmaskrangeareamodelscomponents' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrmaskrangecoloramount' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrmaskrangedepthfeather' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrmaskrangedepthmax' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrmaskrangedepthmin' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrmaskrangeinvert' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrmaskrangelumfeather' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrmaskrangeluminancedepthsampleinfo' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrmaskrangelummax' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrmaskrangelummin' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrmaskrangelumrange' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrmaskrangesampletype' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrmaskrangetype' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'maskgroupbasedcorrmaskrangeversion' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrmaskreferencepoint' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'] },
	'maskgroupbasedcorrmaskright' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'] },
	'maskgroupbasedcorrmaskroundness' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'] },
	'maskgroupbasedcorrmasksizex' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'] },
	'maskgroupbasedcorrmasksizey' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'] },
	'maskgroupbasedcorrmasktop' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'] },
	'maskgroupbasedcorrmaskvalue' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'] },
	'maskgroupbasedcorrmaskversion' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'] },
	'maskgroupbasedcorrmaskwhat' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'] },
	'maskgroupbasedcorrmaskwholeimagearea' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskx' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'] },
	'maskgroupbasedcorrmasky' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'] },
	'maskgroupbasedcorrmaskzerox' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'] },
	'maskgroupbasedcorrmaskzeroy' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'] },
	'maskgroupbasedcorrmoire' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'] },
	'maskgroupbasedcorrrangemask' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'] },
	'maskgroupbasedcorrrangemaskareamodels' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrrangemaskareamodelscolorsampleinfo' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrrangemaskareamodelscomponents' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrrangemaskcoloramount' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrrangemaskdepthfeather' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrrangemaskdepthmax' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrrangemaskdepthmin' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrrangemaskinvert' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrrangemasklumfeather' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrrangemaskluminancedepthsampleinfo' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrrangemasklummax' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrrangemasklummin' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrrangemasklumrange' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrrangemasksampletype' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrrangemasktype' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'] },
	'maskgroupbasedcorrrangemaskversion' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrsaturation' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'] },
	'maskgroupbasedcorrshadows2012' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'] },
	'maskgroupbasedcorrsharpness' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'] },
	'maskgroupbasedcorrtemperature' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'] },
	'maskgroupbasedcorrtexture' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'] },
	'maskgroupbasedcorrtint' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'] },
	'maskgroupbasedcorrtoninghue' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'] },
	'maskgroupbasedcorrtoningsaturation' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'] },
	'maskgroupbasedcorrwhat' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'] },
	'maskgroupbasedcorrwhites2012' => { 514 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'], 516 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'] },
	'masterdocumentid' => { 135 => 0xb9 },
	'mastergain' => { 264 => 0x50 },
	'materialsample' => { 122 => 'MaterialSample' },
	'materialsampleid' => { 122 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 306 => '50.1', 308 => '48.1', 309 => '48.1', 318 => '48.1', 319 => '48.1', 321 => 0x233, 322 => 0x233, 323 => 0x24b },
	'matrixselectk' => { 142 => 0x91b },
	'matrixselectthreshold' => { 142 => 0x91a },
	'matrixselectthreshold1' => { 142 => 0x91e },
	'matrixselectthreshold2' => { 142 => 0x91f },
	'matrixstructure' => { 409 => 0xa },
	'maxaperture' => { 36 => 0x1a, 142 => 0x3f9, 148 => 0x6103, 167 => 'MaxAperture', 185 => 0x17, 191 => 0x49c5, 238 => 0x36, 326 => 0x20a, 375 => '14.1' },
	'maxapertureatmaxfocal' => { 131 => 0x1407, 167 => 'MaxApertureAtMaxFocal', 232 => 0xb, 233 => 0x10, 234 => 0x11, 238 => 0x12, 326 => 0x206 },
	'maxapertureatminfocal' => { 131 => 0x1406, 232 => 0xa, 233 => 0xf, 234 => 0x10, 238 => 0x11, 326 => 0x205 },
	'maxaperturevalue' => { 123 => 0x9205, 394 => 0x414, 520 => 'MaxApertureValue' },
	'maxavailheight' => { 528 => 'MaxAvailHeight' },
	'maxavailwidth' => { 528 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 305 => 0xb, 306 => 0xc, 308 => '12.1', 309 => '12.1', 314 => 0xc, 315 => 0xb, 318 => '12.1', 319 => '12.1', 321 => 0x3d, 322 => 0x3d, 323 => 0x3d },
	'maxfaces' => { 329 => 0x1202 },
	'maxfocallength' => { 7 => 0xe6, 8 => 0x10, 9 => 0x1ab, 10 => 0x13, 11 => 0x115, 12 => 0x13, 13 => 0x153, 14 => 0xda, 16 => 0xfa, 17 => 0xee, 18 => 0x103, 19 => 0x95, 20 => 0xea, 21 => 0x157, 22 => 0xee, 23 => 0xec, 24 => 0x12b, 25 => 0x165, 26 => 0x16a, 27 => 0x188, 28 => 0x116, 29 => 0x18d, 36 => 0x17, 131 => 0x1405, 167 => 'MaxFocalLength', 232 => 0x9, 233 => 0xe, 234 => 0xf, 238 => 0x10, 326 => 0x208, 464 => 0x127c, 465 => 0x1138, 466 => 0x330, 467 => 0x330, 468 => 0x30e },
	'maxfocallength2' => { 64 => 0x9 },
	'maximumdensityrange' => { 137 => 0x8c },
	'maxpagesize' => { 548 => 'MaxPageSize' },
	'maxpagesizeh' => { 548 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 548 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 548 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 142 => 0xc7d },
	'maxsamplevalue' => { 123 => 0x119 },
	'maxstorage' => { 538 => 'maxstorage' },
	'mb-d10batteries' => { 305 => '12.6' },
	'mb-d10batterytype' => { 314 => '13.3' },
	'mb-d11batterytype' => { 315 => '2.3' },
	'mb-d12batterytype' => { 318 => '3.2' },
	'mb-d80batteries' => { 316 => '6.5' },
	'mb-d80batterytype' => { 320 => '3.2' },
	'mcuversion' => { 232 => 0xc, 233 => 0x11, 234 => 0x12, 238 => 0x13 },
	'md5digest' => { 168 => 'zmd5' },
	'mditemfindercomment' => { 177 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 177 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 177 => 'MDItemFSLabel' },
	'mditemusertags' => { 177 => 'MDItemUserTags' },
	'meal' => { 535 => 'meal' },
	'measuredev' => { 28 => 0x9, 80 => 0x3, 101 => 0x1814, 160 => 'MeasuredEV' },
	'measuredev2' => { 13 => 0x8, 28 => 0x8, 80 => 0x17 },
	'measuredev3' => { 13 => 0x9 },
	'measuredlv' => { 191 => 0x690, 344 => 0x312, 347 => 0x312, 348 => 0x312, 351 => 0x3407 },
	'measuredrggb' => { 68 => 0x1 },
	'measuredrggbdata' => { 46 => 0x287 },
	'measurementaccuracy' => { 122 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 122 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 122 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 122 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 122 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 122 => 'MeasurementOrFact' },
	'measurementremarks' => { 122 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 122 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 122 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 122 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 499 => 'MeasureType' },
	'mechanicalshuttercount' => { 240 => 0x37 },
	'mediaclassprimaryid' => { 183 => 'WM/MediaClassPrimaryID' },
	'mediaclasssecondaryid' => { 183 => 'WM/MediaClassSecondaryID' },
	'mediaconstraints' => { 335 => 'MediaConstraints' },
	'mediacreatedate' => { 406 => 0x1 },
	'mediaeventiddate' => { 504 => 'MediaEventIdDate' },
	'mediamodifydate' => { 406 => 0x2 },
	'mediasummarycode' => { 335 => 'MediaSummaryCode' },
	'mediatype' => { 402 => 'stik' },
	'memoaudioquality' => { 88 => 0x812 },
	'memorycardconfiguration' => { 443 => 0x16 },
	'memorycardnumber' => { 217 => 0x2 },
	'menubuttondisplayposition' => { 86 => 0xb, 89 => 0xa, 90 => 0xb, 93 => 0xb },
	'menubuttonreturn' => { 94 => 0xb },
	'menumonitorofftime' => { 305 => '26.1', 306 => '22.1', 308 => '22.1', 309 => '22.1', 313 => '21.1', 314 => '8.2', 315 => '21.1', 318 => '22.1', 319 => '22.1', 320 => '22.1', 321 => 0x35, 322 => 0x35, 323 => 0x35 },
	'mergedimages' => { 349 => 0x76 },
	'metadataauthority' => { 528 => 'metadataAuthority' },
	'metadataauthorityidentifier' => { 528 => [\'metadataAuthority','metadataAuthorityIdentifier'] },
	'metadataauthorityname' => { 528 => [\'metadataAuthority','metadataAuthorityName'] },
	'metadatadate' => { 541 => 'MetadataDate' },
	'metadataeditingsoftware' => { 123 => 0xa43c },
	'metadatalastedited' => { 528 => 'metadataLastEdited' },
	'metadatalasteditor' => { 528 => 'metadataLastEditor' },
	'metadatalasteditoridentifier' => { 528 => [\'metadataLastEditor','metadataLastEditorIdentifier'] },
	'metadatalasteditorname' => { 528 => [\'metadataLastEditor','metadataLastEditorName'] },
	'metadatamoddate' => { 543 => 'metadataModDate' },
	'metaversion' => { 459 => 0x34 },
	'meterinfo1row1' => { 452 => 0x0, 453 => 0x0 },
	'meterinfo1row2' => { 452 => 0x6c, 453 => 0x5a },
	'meterinfo1row3' => { 452 => 0xd8, 453 => 0xb4 },
	'meterinfo1row4' => { 452 => 0x144, 453 => 0x10e },
	'meterinfo1row5' => { 452 => 0x1b0, 453 => 0x168 },
	'meterinfo1row6' => { 452 => 0x21c, 453 => 0x1c2 },
	'meterinfo1row7' => { 452 => 0x288, 453 => 0x21c },
	'meterinfo2row1' => { 452 => 0x2f4, 453 => 0x276 },
	'meterinfo2row2' => { 452 => 0x378, 453 => 0x2e4 },
	'meterinfo2row3' => { 452 => 0x3fc, 453 => 0x352 },
	'meterinfo2row4' => { 452 => 0x480, 453 => 0x3c0 },
	'meterinfo2row5' => { 452 => 0x504, 453 => 0x42e },
	'meterinfo2row6' => { 452 => 0x588, 453 => 0x49c },
	'meterinfo2row7' => { 452 => 0x60c, 453 => 0x50a },
	'meterinfo2row8' => { 452 => 0x690, 453 => 0x578 },
	'meterinfo2row9' => { 452 => 0x714, 453 => 0x5e6 },
	'metering' => { 307 => '6.1' },
	'meteringmode' => { 36 => 0x11, 123 => 0x9207, 144 => 0x1c, 185 => 0x7, 186 => 0x25, 188 => 0x12, 325 => 0x202, 385 => 0x17, 427 => 0x9, 437 => 0x15, 438 => 0x13, 439 => 0x7, 456 => 0x3, 460 => 0x1174, 461 => 0x1178, 462 => 0x1154, 463 => 0x11d0, 464 => 0x11ac, 465 => 0x1064, 466 => 0x25c, 467 => 0x25c, 468 => 0x24b, 520 => 'MeteringMode' },
	'meteringmode2' => { 365 => '2.1', 451 => 0x202c },
	'meteringmode3' => { 365 => '16.1' },
	'meteringoffscaleindicator' => { 188 => 0x53 },
	'meteringtime' => { 305 => '22.2', 307 => '3.2', 310 => '17.1', 311 => '18.1', 314 => '7.3', 315 => '18.1', 316 => '3.2', 320 => '19.1' },
	'micro1version' => { 412 => 0x1f },
	'micro2version' => { 412 => 0x2d },
	'microphoneattenuator' => { 245 => 0x34e, 246 => 0x34e, 247 => 0x2d2, 248 => 0x2fa, 249 => 0x2fa },
	'microphonefrequencyresponse' => { 245 => 0x350, 246 => 0x350, 247 => 0x2d4, 248 => 0x2fc, 249 => 0x2fc },
	'microphonejackpower' => { 245 => 0x376, 246 => 0x376, 247 => 0x2fa, 248 => 0x322, 249 => 0x322 },
	'microphonesensitivity' => { 245 => 0x34c, 246 => 0x34c, 247 => 0x2d0, 248 => 0x2f8, 249 => 0x2f8 },
	'microvideo' => { 496 => 'MicroVideo' },
	'microvideooffset' => { 496 => 'MicroVideoOffset' },
	'microvideopresentationtimestampus' => { 496 => 'MicroVideoPresentationTimestampUs' },
	'microvideoversion' => { 496 => 'MicroVideoVersion' },
	'midrangesharpness' => { 258 => 0x3b },
	'mieversion' => { 168 => '0Vers' },
	'mime' => { 499 => 'Mime' },
	'minaperture' => { 36 => 0x1b, 142 => 0x3f8, 167 => 'MinAperture', 375 => '0.2' },
	'minaperturevalue' => { 394 => 0x415 },
	'minfocallength' => { 7 => 0xe4, 8 => 0xe, 9 => 0x1a9, 10 => 0x11, 11 => 0x113, 12 => 0x11, 13 => 0x151, 14 => 0xd8, 16 => 0xf8, 17 => 0xec, 18 => 0x101, 19 => 0x93, 20 => 0xe8, 21 => 0x155, 22 => 0xec, 23 => 0xea, 24 => 0x129, 25 => 0x163, 26 => 0x168, 27 => 0x186, 28 => 0x114, 29 => 0x18b, 36 => 0x18, 131 => 0x1404, 167 => 'MinFocalLength', 232 => 0x8, 233 => 0xd, 234 => 0xe, 238 => 0xf, 326 => 0x207, 464 => 0x127a, 465 => 0x1136, 466 => 0x32e, 467 => 0x32e, 468 => 0x30c },
	'minfocallength2' => { 64 => 0x8 },
	'minfocusdistance' => { 375 => 0x3 },
	'minimumiso' => { 349 => 0xe8 },
	'minintegrationrows' => { 142 => 0x1874 },
	'minoltadate' => { 185 => 0x15 },
	'minoltaimagesize' => { 185 => 0x4, 186 => 0xc, 187 => 0x2, 190 => 0x103 },
	'minoltamodelid' => { 185 => 0x25 },
	'minoltaquality' => { 185 => 0x5, 186 => 0xd, 187 => 0x3, 190 => [0x102,0x103] },
	'minoltatime' => { 185 => 0x16 },
	'minormodelagedisclosure' => { 335 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 404 => 'minor_version', 505 => 'MinorVersion' },
	'minsamplevalue' => { 123 => 0x118 },
	'mirrorlockup' => { 86 => 0xc, 87 => 0xc, 88 => 0x60f, 89 => 0xb, 90 => 0xc, 91 => 0x6, 92 => 0x6, 93 => 0xc, 94 => 0x3 },
	'mobilecountrycode' => { 513 => 'mcc' },
	'mobilenetworkcode' => { 513 => 'mnc' },
	'moddate' => { 338 => 'modify-date', 530 => 'ModDate' },
	'modedialposition' => { 443 => 0x14 },
	'model' => { 102 => 0x6, 123 => 0x110, 160 => 'Model', 338 => 'Model', 354 => 0x110, 385 => 0x23f, 404 => 'model', 410 => ['@mod','CNMN','cmnm',"\xa9mdl","\xa9mod"], 427 => 0x84, 499 => 'Model', 532 => 'model', 539 => 'Model' },
	'modelage' => { 528 => 'ModelAge' },
	'modelid' => { 324 => 0x0 },
	'modelingflash' => { 305 => '21.4', 306 => '31.1', 308 => '31.1', 309 => '31.1', 314 => '26.4', 315 => '30.2', 316 => '7.4', 317 => '30.1', 318 => '31.1', 319 => '31.1', 320 => '31.3', 321 => 0x5d, 322 => 0x5d, 323 => 0x5d },
	'modelreleaseid' => { 335 => 'ModelReleaseID' },
	'modelreleasestatus' => { 335 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 474 => 0x52, 475 => 0x46, 476 => 0x53 },
	'modeltiepoint' => { 123 => 0x8482 },
	'modeltransform' => { 123 => 0x85d8 },
	'modelyear' => { 532 => 'modelYear' },
	'modificationdate' => { 533 => 'modificationDate' },
	'modifiedcolortemp' => { 69 => 0x9 },
	'modifieddigitalgain' => { 69 => 0xb },
	'modifiedparamflag' => { 60 => 0x1 },
	'modifiedpicturestyle' => { 69 => 0xa },
	'modifiedsaturation' => { 325 => 0x504 },
	'modifiedsensorbluelevel' => { 69 => 0x5 },
	'modifiedsensorredlevel' => { 69 => 0x4 },
	'modifiedsharpness' => { 69 => 0x2 },
	'modifiedsharpnessfreq' => { 69 => 0x3 },
	'modifiedtonecurve' => { 69 => 0x1 },
	'modifiedwhitebalance' => { 69 => 0x8 },
	'modifiedwhitebalanceblue' => { 69 => 0x7 },
	'modifiedwhitebalancered' => { 69 => 0x6 },
	'modifydate' => { 123 => 0x132, 161 => 'ModifyDate', 334 => 'ModDate', 336 => 'tIME', 401 => 'ModDate', 407 => 0x2, 541 => 'ModifyDate' },
	'moirefilter' => { 123 => 0xfe58, 514 => 'MoireFilter', 516 => 'MoireFilter' },
	'monitorbrightness' => { 245 => 0x69a, 246 => 0x6aa, 247 => 0x59a, 248 => 0x5ca, 249 => 0x5e2 },
	'monitordisplayoff' => { 188 => 0x4c },
	'monitormatrix' => { 142 => 0x8fc },
	'monitorofftime' => { 305 => '18.2', 307 => '3.1', 316 => '3.1' },
	'monochromecolor' => { 325 => 0x53b },
	'monochromecontrast' => { 113 => 0x3c },
	'monochromefiltereffect' => { 107 => 0x20307, 113 => 0x3a, 349 => 0xac, 385 => 0x73 },
	'monochromegraineffect' => { 349 => 0xd2 },
	'monochromelinear' => { 113 => 0x3d },
	'monochromeoutputhighlightpoint' => { 113 => 0x41 },
	'monochromeoutputshadowpoint' => { 113 => 0x42 },
	'monochromeprofilesettings' => { 325 => 0x537 },
	'monochromerawhighlight' => { 113 => 0x7a },
	'monochromerawhighlightpoint' => { 113 => 0x3f },
	'monochromerawshadow' => { 113 => 0x83 },
	'monochromerawshadowpoint' => { 113 => 0x40 },
	'monochromesharpness' => { 113 => 0x3e },
	'monochrometoning' => { 385 => 0x74 },
	'monochrometoningeffect' => { 107 => 0x20306, 113 => 0x3b },
	'monochromeunsharpmaskfineness' => { 113 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 113 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 113 => 0xb4 },
	'monochromevignetting' => { 325 => 0x53a },
	'monthdaycreated' => { 144 => 0x12, 153 => 0xe },
	'mood' => { 183 => 'WM/Mood' },
	'moonphase' => { 411 => 0x12, 412 => 0x43, 413 => 0x4c },
	'morepermissions' => { 512 => 'morePermissions' },
	'motionphoto' => { 496 => 'MotionPhoto' },
	'motionphotopresentationtimestampus' => { 496 => 'MotionPhotoPresentationTimestampUs' },
	'motionphotoversion' => { 496 => 'MotionPhotoVersion' },
	'motionphotovideo' => { 405 => 'mpvd' },
	'motionsensitivity' => { 411 => 0x29, 413 => 0x60 },
	'movementcount' => { 402 => "\xa9mvc" },
	'movementname' => { 402 => "\xa9mvn" },
	'movementnumber' => { 402 => "\xa9mvi" },
	'movieactived-lighting' => { 244 => 0x238, 245 => 0x334, 246 => 0x334, 247 => 0x2b8, 248 => 0x2e0, 249 => 0x2e0 },
	'movieaelockbuttonassignment' => { 318 => '40.1' },
	'movieaf-onbutton' => { 321 => 0xcb, 322 => 0xcb, 323 => 0xcb },
	'movieafareamode' => { 245 => 0x342, 246 => 0x342, 247 => 0x2c6, 248 => 0x2ee, 249 => 0x2ee, 321 => 0x203, 322 => 0x203, 323 => 0x21b },
	'movieafspeed' => { 321 => 0xdd, 322 => 0xdd, 323 => 0xdd },
	'movieafspeedapply' => { 321 => 0xdf, 322 => 0xdf, 323 => 0xdf },
	'movieaftrackingsensitivity' => { 321 => 0xe1, 322 => 0xe1, 323 => 0xe1 },
	'movieaperturelock' => { 321 => 0x259, 322 => 0x259, 323 => 0x271 },
	'movieautodistortioncontrol' => { 244 => 0x242 },
	'moviediffractioncompensation' => { 244 => 0x241 },
	'moviedxcropalert' => { 245 => 0x377, 246 => 0x377, 247 => 0x2fb, 248 => 0x323, 249 => 0x323 },
	'movieelectronicvr' => { 245 => 0x348, 246 => 0x348, 247 => 0x2cc, 248 => 0x2f4, 249 => 0x2f4 },
	'movieevfgrid' => { 321 => 0x21d, 322 => 0x21d, 323 => 0x235 },
	'movieflickerreduction' => { 245 => 0x33c, 246 => 0x33c, 247 => 0x2c0, 248 => 0x2e8, 249 => 0x2e8 },
	'moviefocusmode' => { 244 => 0x248, 245 => 0x340, 246 => 0x340, 247 => 0x2c4, 248 => 0x2ec, 249 => 0x2ec },
	'moviefocuspointlock' => { 321 => 0x226, 322 => 0x226, 323 => 0x23e },
	'movieframerate' => { 244 => 0x1f8, 245 => 0x374, 246 => 0x370, 247 => 0x2f4, 248 => 0x31c, 249 => 0x31c },
	'movieframesize' => { 244 => 0x1f6, 245 => 0x372, 246 => 0x36e, 247 => 0x2f2, 248 => 0x31a, 249 => 0x31a },
	'moviefunc1button' => { 308 => '41.1', 309 => '41.1', 319 => '41.1', 321 => 0xc3, 322 => 0xc3, 323 => 0xc3 },
	'moviefunc2button' => { 321 => 0xc7, 322 => 0xc7, 323 => 0xc7 },
	'moviefunc3button' => { 322 => 0x127, 323 => 0x13f },
	'moviefunctionbutton' => { 306 => '41.1', 318 => '41.1' },
	'moviefunctionbuttonplusdials' => { 306 => '52.1' },
	'moviehighisonoisereduction' => { 244 => 0x23c, 245 => 0x336, 246 => 0x336, 247 => 0x2ba, 248 => 0x2e2, 249 => 0x2e2 },
	'moviehighlightdisplaythreshold' => { 321 => 0x215, 322 => 0x215, 323 => 0x22d },
	'moviehighreszoom' => { 245 => 0x380, 246 => 0x380, 248 => 0x32c, 249 => 0x32c },
	'movieimagearea' => { 245 => 0x2da, 246 => 0x2da, 247 => 0x25c, 248 => 0x286, 249 => 0x286 },
	'movieisoautocontrolmanualmode' => { 245 => 0x2e8, 246 => 0x2e8, 247 => 0x26a, 248 => 0x294, 249 => 0x294 },
	'movieisoautohilimit' => { 245 => 0x2e6, 246 => 0x2e6, 247 => 0x268, 248 => 0x292, 249 => 0x292 },
	'movieisoautomanualmode' => { 244 => 0x204, 245 => 0x2ea, 246 => 0x2ea, 247 => 0x26c, 248 => 0x296, 249 => 0x296 },
	'movielenscontrolring' => { 321 => 0xd7, 322 => 0xd7, 323 => 0xd7 },
	'moviemeteringmode' => { 245 => 0x33e, 246 => 0x33e, 247 => 0x2c2, 248 => 0x2ea, 249 => 0x2ea },
	'moviemidtonedisplayrange' => { 321 => 0x219, 322 => 0x219, 323 => 0x231 },
	'moviemidtonedisplayvalue' => { 321 => 0x217, 322 => 0x217, 323 => 0x22f },
	'moviemultiselector' => { 321 => 0xd9, 322 => 0xcf, 323 => 0xcf },
	'moviepreviewbutton' => { 306 => '41.2', 308 => '41.2', 309 => '41.2', 318 => '41.2', 319 => '41.2' },
	'moviepreviewbuttonplusdials' => { 306 => '52.2' },
	'movierecordbuttonplaybackmode' => { 321 => 0x1b5, 322 => 0x1b5, 323 => 0x1cd },
	'movieshutterbutton' => { 306 => '38.3', 308 => '38.3', 309 => '38.3', 318 => '38.3', 319 => '38.3' },
	'movieshutterspeedlock' => { 321 => 0x225, 322 => 0x225, 323 => 0x23d },
	'movieslowmotion' => { 244 => 0x1fa },
	'moviesoundrecording' => { 245 => 0x34a, 246 => 0x34a, 247 => 0x2ce, 248 => 0x2f6, 249 => 0x2f6 },
	'moviesubjectdetection' => { 245 => 0x378, 246 => 0x378, 247 => 0x2fc, 248 => 0x324, 249 => 0x324 },
	'moviesubselectorassignment' => { 306 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 306 => '53.1' },
	'movietonemap' => { 247 => 0x2ec, 248 => 0x314, 249 => 0x314 },
	'movietype' => { 229 => 0x2ca, 244 => 0x1fe, 245 => 0x2e4, 246 => 0x2e4, 247 => 0x266, 248 => 0x290, 249 => 0x290 },
	'movievibrationreduction' => { 244 => 0x24e },
	'movievibrationreductionsameasphoto' => { 244 => 0x24f },
	'movievignettecontrol' => { 244 => 0x23e, 245 => 0x1b0, 246 => 0x1b0, 247 => 0x1a0, 248 => 0x1b4, 249 => 0x1b4 },
	'movievignettecontrolsameasphoto' => { 244 => 0x240 },
	'movievrmode' => { 245 => 0x344, 246 => 0x344, 247 => 0x2c8, 248 => 0x2f0, 249 => 0x2f0 },
	'moviezebrapattern' => { 321 => 0x213, 322 => 0x213, 323 => 0x22b },
	'multiburstimageheight' => { 451 => 0x1002 },
	'multiburstimagewidth' => { 451 => 0x1001 },
	'multiburstmode' => { 451 => 0x1000 },
	'multicontrollerwhilemetering' => { 88 => 0x517 },
	'multiexposure' => { 71 => 0x1, 349 => 0xb4 },
	'multiexposureautogain' => { 251 => 0x3 },
	'multiexposurecontrol' => { 71 => 0x2 },
	'multiexposuremode' => { 251 => 0x1, 252 => 0x1 },
	'multiexposureoverlaymode' => { 252 => 0x3 },
	'multiexposureshots' => { 71 => 0x3, 245 => 0x9a, 246 => 0x9a, 247 => 0x8e, 248 => 0x9c, 249 => 0x9c, 251 => 0x2, 252 => 0x2 },
	'multiframenoisereduction' => { 439 => 0x35, 451 => 0x200b, 456 => 0x15 },
	'multiframenreffect' => { 451 => 0x2023 },
	'multifunctionlock' => { 88 => 0x70f },
	'multipleexposuremode' => { 245 => 0x98, 246 => 0x98, 247 => 0x8c, 248 => 0x9a, 249 => 0x9a, 329 => 0x101c },
	'multipleexposureset' => { 365 => '10.1' },
	'multisample' => { 264 => 0x40 },
	'multiselector' => { 305 => '9.4', 306 => '10.3', 308 => '10.3', 309 => '10.3', 314 => '27.4', 318 => '10.3', 319 => '10.3' },
	'multiselectorliveview' => { 305 => '4.3', 308 => '37.1', 309 => '37.1', 318 => '37.1', 319 => '37.1' },
	'multiselectorliveviewmode' => { 278 => 0x18c2 },
	'multiselectorplaybackmode' => { 305 => ['13.5','9.2'], 306 => '10.2', 309 => '10.2', 314 => '27.2', 318 => '10.2', 319 => '10.2', 321 => 0xb3, 322 => 0xb3, 323 => 0xb3 },
	'multiselectorshootmode' => { 305 => '9.1', 306 => '10.1', 308 => '10.1', 309 => '10.1', 314 => '27.1', 318 => '10.1', 319 => '10.1', 321 => 0xaf, 322 => 0xaf, 323 => 0xaf },
	'multishot' => { 354 => 0x121 },
	'mute' => { 404 => 'player.movie.audio.mute' },
	'mycolormode' => { 72 => 0x2 },
	'name' => { 410 => 'name', 514 => 'Name', 516 => 'Name' },
	'narrator' => { 402 => "\xa9nrt" },
	'nationalcatalognumber' => { 533 => 'nationalCatalogNumber' },
	'nativedigest' => { 520 => 'NativeDigest', 539 => 'NativeDigest' },
	'ndfilter' => { 80 => 0x1c, 325 => 0x204, 417 => 0x1019 },
	'near' => { 499 => 'Near' },
	'nefbitdepth' => { 240 => 0xe22 },
	'nefcompression' => { 240 => 0x93, 241 => 0xa },
	'neflinearizationtable' => { 240 => 0x96 },
	'negativecachelargepreviewsize' => { 514 => 'NegativeCacheLargePreviewSize', 516 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 514 => 'NegativeCacheMaximumSize', 516 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 514 => 'NegativeCachePath', 516 => 'NegativeCachePath' },
	'neutraldensityfactor' => { 511 => 'NeutralDensityFactor' },
	'neutraldensityfilter' => { 385 => 0x88 },
	'neutraloutputhighlightpoint' => { 113 => 0x2f },
	'neutraloutputshadowpoint' => { 113 => 0x30 },
	'neutralrawcolortone' => { 113 => 0x28 },
	'neutralrawcontrast' => { 113 => 0x2a },
	'neutralrawhighlight' => { 113 => 0x78 },
	'neutralrawhighlightpoint' => { 113 => 0x2d },
	'neutralrawlinear' => { 113 => 0x2b },
	'neutralrawsaturation' => { 113 => 0x29 },
	'neutralrawshadow' => { 113 => 0x81 },
	'neutralrawshadowpoint' => { 113 => 0x2e },
	'neutralrawsharpness' => { 113 => 0x2c },
	'neutralunsharpmaskfineness' => { 113 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 113 => 0xa8 },
	'neutraunsharpmaskstrength' => { 113 => 0xa4 },
	'newlensdata' => { 238 => 0x2f },
	'newrawimagedigest' => { 123 => 0xc7a7 },
	'newsphotoversion' => { 137 => 0x0 },
	'nickname' => { 541 => 'Nickname' },
	'nikoncapturedata' => { 240 => 0xe01 },
	'nikoncaptureeditversions' => { 240 => 0xe13 },
	'nikoncaptureoffsets' => { 240 => 0xe0e },
	'nikoncaptureoutput' => { 240 => 0xe1e },
	'nikoncaptureversion' => { 240 => 0xe09 },
	'nikoniccprofile' => { 240 => 0xe1d },
	'nikonimagesize' => { 275 => '723.1', 276 => '732.1', 284 => 0x2c4 },
	'nikonmeteringmode' => { 203 => 0x17, 244 => 0x146, 255 => 0x214 },
	'nikonsettings' => { 240 => 0x4e },
	'noisefilter' => { 325 => 0x527 },
	'noiseprofile' => { 123 => 0xc761 },
	'noisereduction' => { 131 => [0x100b,0x100e], 186 => 0xb0, 187 => 0x60, 188 => 0x3f, 240 => 0x95, 298 => 0x753dcbc0, 299 => 0x17, 325 => 0x50a, 330 => 0x103a, 349 => 0x2d, 385 => 0x49, 417 => 0x100f, 419 => 0x2a },
	'noisereduction2' => { 329 => 0x1010 },
	'noisereductionapplied' => { 123 => 0xc6f7 },
	'noisereductionintensity' => { 299 => 0x9 },
	'noisereductionmethod' => { 299 => 0x11 },
	'noisereductionmode' => { 488 => 0x801e },
	'noisereductionparametersatcapture' => { 142 => 0xe73 },
	'noisereductionparameterscamera' => { 142 => 0xe72 },
	'noisereductionparametershost3mp' => { 142 => 0xe71 },
	'noisereductionparametershost6mp' => { 142 => 0xe70 },
	'noisereductionparametershostrgb' => { 142 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 142 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 142 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 142 => 0xe63 },
	'noisereductionparams' => { 354 => 0x1b },
	'noisereductionsharpness' => { 299 => 0xd },
	'noisereductionstrength' => { 349 => 0xd6 },
	'noisereductionvalue' => { 488 => 0x8027 },
	'nomemorycard' => { 305 => '22.1', 306 => '4.2', 307 => '0.3', 310 => '2.4', 311 => '3.2', 312 => '3.2', 314 => '33.7', 315 => '3.2', 316 => '0.3', 318 => '4.2', 320 => '4.5' },
	'nominalmaxaperture' => { 375 => 0xa },
	'nominalminaperture' => { 375 => '10.1' },
	'noncpulens10focallength' => { 245 => 0x6c6, 246 => 0x6d6, 249 => 0x620 },
	'noncpulens10maxaperture' => { 245 => 0x6ee, 246 => 0x738, 249 => 0x670 },
	'noncpulens11focallength' => { 245 => 0x6c8, 246 => 0x6d8, 249 => 0x624 },
	'noncpulens11maxaperture' => { 245 => 0x6f0, 246 => 0x73c, 249 => 0x674 },
	'noncpulens12focallength' => { 245 => 0x6ca, 246 => 0x6da, 249 => 0x628 },
	'noncpulens12maxaperture' => { 245 => 0x6f2, 246 => 0x740, 249 => 0x678 },
	'noncpulens13focallength' => { 245 => 0x6cc, 246 => 0x6dc, 249 => 0x62c },
	'noncpulens13maxaperture' => { 245 => 0x6f4, 246 => 0x744, 249 => 0x67c },
	'noncpulens14focallength' => { 245 => 0x6ce, 246 => 0x6de, 249 => 0x630 },
	'noncpulens14maxaperture' => { 245 => 0x6f6, 246 => 0x748, 249 => 0x680 },
	'noncpulens15focallength' => { 245 => 0x6d0, 246 => 0x6e0, 249 => 0x634 },
	'noncpulens15maxaperture' => { 245 => 0x6f8, 246 => 0x74c, 249 => 0x684 },
	'noncpulens16focallength' => { 245 => 0x6d2, 246 => 0x6e2, 249 => 0x638 },
	'noncpulens16maxaperture' => { 245 => 0x6fa, 246 => 0x750, 249 => 0x688 },
	'noncpulens17focallength' => { 245 => 0x6d4, 246 => 0x6e4, 249 => 0x63c },
	'noncpulens17maxaperture' => { 245 => 0x6fc, 246 => 0x754, 249 => 0x68c },
	'noncpulens18focallength' => { 245 => 0x6d6, 246 => 0x6e6, 249 => 0x640 },
	'noncpulens18maxaperture' => { 245 => 0x6fe, 246 => 0x758, 249 => 0x690 },
	'noncpulens19focallength' => { 245 => 0x6d8, 246 => 0x6e8, 249 => 0x644 },
	'noncpulens19maxaperture' => { 245 => 0x700, 246 => 0x75c, 249 => 0x694 },
	'noncpulens1focallength' => { 245 => 0x6b4, 246 => 0x6c4, 249 => 0x5fc },
	'noncpulens1maxaperture' => { 245 => 0x6dc, 246 => 0x714, 249 => 0x64c },
	'noncpulens20focallength' => { 245 => 0x6da, 246 => 0x6ea, 249 => 0x648 },
	'noncpulens20maxaperture' => { 245 => 0x702, 246 => 0x760, 249 => 0x698 },
	'noncpulens2focallength' => { 245 => 0x6b6, 246 => 0x6c6, 249 => 0x600 },
	'noncpulens2maxaperture' => { 245 => 0x6de, 246 => 0x718, 249 => 0x650 },
	'noncpulens3focallength' => { 245 => 0x6b8, 246 => 0x6c8, 249 => 0x604 },
	'noncpulens3maxaperture' => { 245 => 0x6e0, 246 => 0x71c, 249 => 0x654 },
	'noncpulens4focallength' => { 245 => 0x6ba, 246 => 0x6ca, 249 => 0x608 },
	'noncpulens4maxaperture' => { 245 => 0x6e2, 249 => 0x658 },
	'noncpulens5focallength' => { 245 => 0x6bc, 246 => 0x6cc, 249 => 0x60c },
	'noncpulens5maxaperture' => { 245 => 0x6e4, 246 => 0x724, 249 => 0x65c },
	'noncpulens6focallength' => { 245 => 0x6be, 246 => 0x6ce, 249 => 0x610 },
	'noncpulens6maxaperture' => { 245 => 0x6e6, 246 => 0x728, 249 => 0x660 },
	'noncpulens7focallength' => { 245 => 0x6c0, 246 => 0x6d0, 249 => 0x614 },
	'noncpulens7maxaperture' => { 245 => 0x6e8, 246 => 0x72c, 249 => 0x664 },
	'noncpulens8focallength' => { 245 => 0x6c2, 246 => 0x6d2, 249 => 0x618 },
	'noncpulens8maxaperture' => { 245 => 0x6ea, 246 => 0x730, 249 => 0x668 },
	'noncpulens9focallength' => { 245 => 0x6c4, 246 => 0x6d4, 249 => 0x61c },
	'noncpulens9maxaperture' => { 245 => 0x6ec, 246 => 0x734, 249 => 0x66c },
	'normalizedcropcorners' => { 339 => 'NormalizedCropCorners' },
	'normallinetime' => { 142 => 0x186a },
	'normalwhitelevel' => { 43 => 0x32a, 44 => 0x280, 47 => [0x2b8,0x2cf,0x2d3], 48 => 0x569, 49 => 0x1e3, 50 => [0x1fc,0x2dc], 51 => [0x230,0x30e], 52 => 0x31c },
	'notes' => { 490 => 'Notes', 509 => 'notes' },
	'npages' => { 548 => 'NPages' },
	'nullrecord' => { 101 => 0x0 },
	'numafpoints' => { 361 => 0x2 },
	'number' => { 533 => 'number' },
	'numberofbeats' => { 543 => 'numberOfBeats' },
	'numberoffocuspoints' => { 308 => '1.3', 309 => '1.3', 312 => '0.2', 313 => '0.3', 315 => '0.3' },
	'numfaceelements' => { 131 => 0x4200 },
	'numfacepositions' => { 341 => 0x0 },
	'numindexentries' => { 137 => 0x54 },
	'numwbentries' => { 355 => 0x0, 356 => 0x0 },
	'object' => { 533 => 'object' },
	'objectattributereference' => { 135 => 0x4 },
	'objectcycle' => { 135 => 0x4b, 509 => 'ObjectCycle' },
	'objectdescription' => { 532 => 'objectDescription' },
	'objectdistance' => { 116 => 0x6, 117 => 0x2022 },
	'objectname' => { 135 => 0x5 },
	'objectpreviewdata' => { 135 => 0xca },
	'objectpreviewfileformat' => { 135 => 0xc8 },
	'objectpreviewfileversion' => { 135 => 0xc9 },
	'objectsubtype' => { 532 => 'objectSubtype' },
	'objecttype' => { 532 => 'objectType' },
	'objecttypereference' => { 135 => 0x3 },
	'occurrence' => { 122 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 122 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 122 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 122 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 122 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 122 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 122 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 122 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedegreeofestablishment' => { 122 => [\'Occurrence','OccurrenceDegreeOfEstablishment'] },
	'occurrencedetails' => { 122 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 122 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 122 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrencegeoreferenceverificationstatus' => { 122 => [\'Occurrence','OccurrenceGeoreferenceVerificationStatus'] },
	'occurrenceid' => { 122 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 122 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 122 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 122 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 122 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 122 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 122 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepathway' => { 122 => [\'Occurrence','OccurrencePathway'] },
	'occurrencepreparations' => { 122 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 122 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 122 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordedbyid' => { 122 => [\'Occurrence','OccurrenceRecordedByID'] },
	'occurrencerecordnumber' => { 122 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 122 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 122 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 122 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 122 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 520 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 520 => [\'OECF','OECFNames'] },
	'oecfrows' => { 520 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 520 => [\'OECF','OECFValues'] },
	'offsaledate' => { 533 => 'offSaleDate' },
	'offsaledatea-platform' => { 533 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 533 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 142 => 0x190a },
	'offsethdr' => { 525 => 'OffsetHDR' },
	'offsetschema' => { 123 => 0xea1d },
	'offsetsdr' => { 525 => 'OffsetSDR' },
	'offsettime' => { 123 => 0x9010 },
	'offsettimedigitized' => { 123 => 0x9012 },
	'offsettimeoriginal' => { 123 => 0x9011 },
	'oismode' => { 1 => 0xf },
	'okbutton' => { 315 => '15.1', 320 => '16.1' },
	'oldsubfiletype' => { 123 => 0xff },
	'olympusimageheight' => { 330 => 0x102f },
	'olympusimagewidth' => { 330 => 0x102e },
	'omenatcapturestrength' => { 142 => 0xa60 },
	'omenautostrength' => { 142 => 0xa5f },
	'omenearlystrength' => { 142 => 0xa5e },
	'omenfocallengthlimit' => { 142 => 0xa62 },
	'omeninitialipfstrength' => { 142 => 0xa5d },
	'omensurfaceindex' => { 142 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 330 => 0x302 },
	'onsaledate' => { 533 => 'onSaleDate' },
	'onsaledatea-platform' => { 533 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 533 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 533 => 'onSaleDay' },
	'onsaledaya-platform' => { 533 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 533 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 123 => 0xc740 },
	'opcodelist2' => { 123 => 0xc741 },
	'opcodelist3' => { 123 => 0xc74e },
	'opticalzoom' => { 146 => 0xfa3d, 148 => [0x6006,0xf006], 149 => 0x1000, 150 => 0xf, 153 => 0x1e, 155 => 0x20, 156 => 0x1c, 167 => 'OpticalZoom' },
	'opticalzoomcode' => { 80 => 0xa },
	'opticalzoommode' => { 349 => 0x34 },
	'opticalzoomon' => { 426 => 0x219 },
	'optionenddate' => { 536 => 'optionEndDate' },
	'opto-electricconvfactor' => { 520 => 'OECF' },
	'orangehsl' => { 107 => 0x20911 },
	'ordernumber' => { 131 => 0x8002 },
	'organisationinimagecode' => { 528 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 528 => 'OrganisationInImageName' },
	'organism' => { 122 => 'Organism' },
	'organismassociatedoccurrences' => { 122 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 122 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 122 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 122 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 122 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 122 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 122 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 533 => 'organization' },
	'orientation' => { 123 => 0x112, 354 => 0x112, 532 => 'orientation', 539 => 'Orientation' },
	'orientation2' => { 456 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 88 => 0x516 },
	'originalalbumtitle' => { 183 => 'WM/OriginalAlbumTitle' },
	'originalartist' => { 183 => 'WM/OriginalArtist', 402 => "\xa9ope" },
	'originalbestqualitysize' => { 123 => 0xc792 },
	'originalcreatedatetime' => { 504 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 118 => 'Canon-OriginalDecisionData' },
	'originaldecisiondataoffset' => { 67 => 0x83 },
	'originaldefaultcropsize' => { 123 => 0xc793 },
	'originaldefaultfinalsize' => { 123 => 0xc791 },
	'originaldirectory' => { 346 => 0x408 },
	'originaldocumentid' => { 544 => 'OriginalDocumentID' },
	'originalfilename' => { 101 => 0x816, 142 => 0x3e9, 154 => 0x20, 346 => 0x407, 504 => 'OriginalFilename' },
	'originalimagehash' => { 493 => 'OriginalImageHash' },
	'originalimagehashtype' => { 493 => 'OriginalImageHashType' },
	'originalimageheight' => { 82 => 0xc, 127 => 0x1 },
	'originalimagemd5' => { 493 => 'OriginalImageMD5' },
	'originalimagesize' => { 166 => 'OriginalImageSize' },
	'originalimagewidth' => { 82 => 0xb, 127 => 0x0 },
	'originallyricist' => { 183 => 'WM/OriginalLyricist' },
	'originalrawfiledata' => { 123 => 0xc68c },
	'originalrawfiledigest' => { 123 => 0xc71d },
	'originalrawfilename' => { 123 => 0xc68b },
	'originaltransmissionreference' => { 135 => 0x67 },
	'originatingprogram' => { 135 => 0x41, 509 => 'OriginatingProgram' },
	'originplatform' => { 533 => 'originPlatform' },
	'os' => { 518 => 'os' },
	'otherconditions' => { 335 => 'OtherConditions' },
	'otherconstraints' => { 335 => 'OtherConstraints' },
	'otherimage' => { 118 => 'Exif-OtherImage' },
	'otherimageinfo' => { 335 => 'OtherImageInfo' },
	'otherimagelength' => { 123 => 0x202 },
	'otherimagestart' => { 123 => 0x201 },
	'otherlicensedocuments' => { 335 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 335 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 335 => 'OtherLicenseRequirements' },
	'outcue' => { 543 => 'outCue' },
	'outcuescale' => { 543 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 543 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 204 => 0x3 },
	'outputimagewidth' => { 204 => 0x2 },
	'outputlut' => { 349 => 0xa7 },
	'outputprofile' => { 142 => 0x138b },
	'outputresolution' => { 204 => 0x4 },
	'overclockcols' => { 142 => 0x189c },
	'overclockrows' => { 142 => 0x18c4 },
	'overridelookvignette' => { 514 => 'OverrideLookVignette', 516 => 'OverrideLookVignette' },
	'owner' => { 402 => 'ownr', 547 => 'Owner' },
	'ownerid' => { 135 => 0xbc },
	'ownername' => { 15 => 0x10f, 67 => 0x9, 101 => 0x810, 123 => [0xa430,0xfde8], 160 => 'OwnerName', 511 => 'OwnerName', 521 => 'CameraOwnerName' },
	'padding' => { 123 => 0xea1c },
	'pagecount' => { 533 => 'pageCount' },
	'pageimage' => { 541 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 541 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 541 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 541 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 541 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 541 => 'PageInfo' },
	'pagename' => { 123 => 0x11d },
	'pagenumber' => { 123 => 0x129 },
	'pageprogressiondirection' => { 533 => 'pageProgressionDirection' },
	'pagerange' => { 533 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 514 => 'PaintBasedCorrections', 516 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionblacks2012' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'] },
	'paintcorrectionbrightness' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectioncorrectionname' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'] },
	'paintcorrectioncorrectionsyncid' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'] },
	'paintcorrectiondefringe' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectiondehaze' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'] },
	'paintcorrectionexposure' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'] },
	'paintcorrectionluminancenoise' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskinputdigest' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'] },
	'paintcorrectionmaskleft' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmaskactive' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'] },
	'paintcorrectionmaskmaskblendmode' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'paintcorrectionmaskmaskdigest' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'] },
	'paintcorrectionmaskmaskinverted' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'] },
	'paintcorrectionmaskmaskname' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'] },
	'paintcorrectionmaskmasks' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'] },
	'paintcorrectionmaskmasksalpha' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'paintcorrectionmaskmasksangle' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'] },
	'paintcorrectionmaskmasksbottom' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'] },
	'paintcorrectionmaskmaskscentervalue' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'paintcorrectionmaskmaskscenterweight' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'paintcorrectionmaskmasksdabs' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'] },
	'paintcorrectionmaskmasksfeather' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'] },
	'paintcorrectionmaskmasksflipped' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'paintcorrectionmaskmasksflow' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'] },
	'paintcorrectionmaskmasksfullx' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'] },
	'paintcorrectionmaskmasksfully' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'] },
	'paintcorrectionmaskmasksinputdigest' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'paintcorrectionmaskmasksleft' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'] },
	'paintcorrectionmaskmasksmaskactive' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'paintcorrectionmaskmasksmaskblendmode' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'paintcorrectionmaskmasksmaskdigest' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'paintcorrectionmaskmasksmaskinverted' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'paintcorrectionmaskmasksmaskname' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'paintcorrectionmaskmasksmasksubtype' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'paintcorrectionmaskmasksmasksyncid' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'paintcorrectionmaskmasksmaskversion' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'paintcorrectionmaskmasksmidpoint' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'paintcorrectionmaskmasksorigin' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'paintcorrectionmaskmasksperimetervalue' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'paintcorrectionmaskmasksradius' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'] },
	'paintcorrectionmaskmasksreferencepoint' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'paintcorrectionmaskmasksright' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'] },
	'paintcorrectionmaskmasksroundness' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'paintcorrectionmaskmaskssizex' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'paintcorrectionmaskmaskssizey' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'paintcorrectionmaskmaskstop' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'] },
	'paintcorrectionmaskmasksubtype' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'] },
	'paintcorrectionmaskmasksvalue' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'paintcorrectionmaskmasksversion' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'] },
	'paintcorrectionmaskmaskswhat' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'] },
	'paintcorrectionmaskmaskswholeimagearea' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'paintcorrectionmaskmasksx' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'] },
	'paintcorrectionmaskmasksy' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'] },
	'paintcorrectionmaskmasksyncid' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'paintcorrectionmaskmaskszerox' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'paintcorrectionmaskmaskszeroy' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'paintcorrectionmaskmaskversion' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'] },
	'paintcorrectionmaskmidpoint' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskorigin' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'] },
	'paintcorrectionmaskperimetervalue' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskrange' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'paintcorrectionmaskrangeareamodels' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'paintcorrectionmaskrangeareamodelscolorsampleinfo' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionmaskrangeareamodelscomponents' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionmaskrangecoloramount' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'paintcorrectionmaskrangedepthfeather' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionmaskrangedepthmax' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'paintcorrectionmaskrangedepthmin' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'paintcorrectionmaskrangeinvert' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'paintcorrectionmaskrangelumfeather' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'paintcorrectionmaskrangeluminancedepthsampleinfo' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionmaskrangelummax' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'paintcorrectionmaskrangelummin' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'paintcorrectionmaskrangelumrange' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'paintcorrectionmaskrangesampletype' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'paintcorrectionmaskrangetype' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'paintcorrectionmaskrangeversion' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'paintcorrectionmaskreferencepoint' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'] },
	'paintcorrectionmaskright' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskwholeimagearea' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'paintcorrectionmaskx' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionrangemask' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'] },
	'paintcorrectionrangemaskareamodels' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'paintcorrectionrangemaskareamodelscolorsampleinfo' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionrangemaskareamodelscomponents' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionrangemaskcoloramount' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'paintcorrectionrangemaskdepthfeather' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionrangemaskdepthmax' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'paintcorrectionrangemaskdepthmin' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'paintcorrectionrangemaskinvert' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'] },
	'paintcorrectionrangemasklumfeather' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'paintcorrectionrangemaskluminancedepthsampleinfo' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionrangemasklummax' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'paintcorrectionrangemasklummin' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'paintcorrectionrangemasklumrange' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'paintcorrectionrangemasksampletype' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'paintcorrectionrangemasktype' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'] },
	'paintcorrectionrangemaskversion' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'] },
	'paintcorrectionsaturation' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'] },
	'paintcorrectionshadows2012' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontexture' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'] },
	'paintcorrectiontint' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectiontoninghue' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectiontoningsaturation' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionwhat' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'paintcorrectionwhites2012' => { 514 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'], 516 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'] },
	'panasonicdatetime' => { 352 => 0x0 },
	'panasonicexifversion' => { 349 => 0x26 },
	'panasonicimageheight' => { 349 => 0x4c },
	'panasonicimagewidth' => { 349 => 0x4b },
	'panasonicrawversion' => { 354 => 0x1 },
	'panasonictitle' => { 123 => 0xc6d2 },
	'panasonictitle2' => { 123 => 0xc6d3 },
	'panoramaangle' => { 131 => 0x1153 },
	'panoramacropbottom' => { 457 => 0x7 },
	'panoramacropleft' => { 457 => 0x4 },
	'panoramacropright' => { 457 => 0x6 },
	'panoramacroptop' => { 457 => 0x5 },
	'panoramadirection' => { 75 => 0x5, 131 => 0x1154, 457 => 0x3 },
	'panoramaframeheight' => { 457 => 0x9 },
	'panoramaframenumber' => { 75 => 0x2 },
	'panoramaframewidth' => { 457 => 0x8 },
	'panoramafullheight' => { 457 => 0x2 },
	'panoramafullwidth' => { 457 => 0x1 },
	'panoramamode' => { 144 => 0x3c, 325 => 0x601 },
	'panoramasize3d' => { 439 => 0x38 },
	'panoramasourceheight' => { 457 => 0xb },
	'panoramasourcewidth' => { 457 => 0xa },
	'panoramicstitchcameramotion' => { 180 => 'PanoramicStitchCameraMotion', 181 => 0x1 },
	'panoramicstitchmaptype' => { 180 => 'PanoramicStitchMapType', 181 => 0x2 },
	'panoramicstitchphi0' => { 180 => 'PanoramicStitchPhi0', 181 => 0x5 },
	'panoramicstitchphi1' => { 180 => 'PanoramicStitchPhi1', 181 => 0x6 },
	'panoramicstitchtheta0' => { 180 => 'PanoramicStitchTheta0', 181 => 0x3 },
	'panoramicstitchtheta1' => { 180 => 'PanoramicStitchTheta1', 181 => 0x4 },
	'panoramicstitchversion' => { 181 => 0x0 },
	'pantry' => { 544 => 'Pantry' },
	'pantryinstanceid' => { 544 => [\'Pantry','PantryInstanceID'] },
	'parallax' => { 131 => 0xb211, 324 => 0x28 },
	'parameters' => { 338 => 'parameters' },
	'parametricdarks' => { 514 => 'ParametricDarks', 516 => 'ParametricDarks' },
	'parametrichighlights' => { 514 => 'ParametricHighlights', 516 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 514 => 'ParametricHighlightSplit', 516 => 'ParametricHighlightSplit' },
	'parametriclights' => { 514 => 'ParametricLights', 516 => 'ParametricLights' },
	'parametricmidtonesplit' => { 514 => 'ParametricMidtoneSplit', 516 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 514 => 'ParametricShadows', 516 => 'ParametricShadows' },
	'parametricshadowsplit' => { 514 => 'ParametricShadowSplit', 516 => 'ParametricShadowSplit' },
	'parentalrating' => { 183 => 'WM/ParentalRating' },
	'parentid' => { 528 => 'parentId' },
	'parentmediaeventid' => { 504 => 'ParentMediaEventID' },
	'parentmeid' => { 504 => 'ParentMEID' },
	'parentproductid' => { 402 => '@ppi' },
	'parentreference1' => { 526 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 526 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 526 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 526 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 526 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 526 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentshorttitle' => { 402 => '@PST' },
	'parenttitle' => { 402 => '@pti' },
	'partialactivecols1' => { 142 => 0x17e8 },
	'partialactivecols2' => { 142 => 0x17f2 },
	'partialactiverows1' => { 142 => 0x17fc },
	'partialactiverows2' => { 142 => 0x1806 },
	'partofcompilation' => { 543 => 'partOfCompilation' },
	'patientbirthdate' => { 491 => 'PatientDOB' },
	'patientid' => { 491 => 'PatientID' },
	'patientname' => { 491 => 'PatientName' },
	'patientsex' => { 491 => 'PatientSex' },
	'patternareaheight' => { 142 => 0x963 },
	'patternareawidth' => { 142 => 0x962 },
	'patterncorrectionfactorscale' => { 142 => 0x969 },
	'patterncropcols1' => { 142 => 0x96c },
	'patterncropcols2' => { 142 => 0x96d },
	'patterncroprows1' => { 142 => 0x96a },
	'patterncroprows2' => { 142 => 0x96b },
	'patternimagerheight' => { 142 => 0x961 },
	'patternimagerwidth' => { 142 => 0x960 },
	'patternx' => { 142 => 0x966 },
	'patterny' => { 142 => 0x967 },
	'pdfversion' => { 530 => 'PDFVersion' },
	'pentaximagesize' => { 385 => 0x9 },
	'pentaxmodelid' => { 364 => 0x0, 385 => 0x5 },
	'pentaxmodeltype' => { 385 => 0x1 },
	'pentaxversion' => { 385 => 0x0 },
	'people' => { 494 => 'People', 507 => 'People' },
	'perchannelblacklevel' => { 43 => 0x157, 44 => 0x16b, 46 => 0xc4, 47 => [0x2b4,0x2cb,0x2cf], 48 => [0x108,0x14d], 49 => 0x1df, 50 => [0x1f8,0x2d8], 51 => [0x22c,0x30a], 52 => 0x149 },
	'performer' => { 402 => 'perf', 410 => 'perf' },
	'performerkeywords' => { 410 => "\xa9prk" },
	'performers' => { 410 => "\xa9prf" },
	'performerurl' => { 410 => "\xa9prl" },
	'period' => { 183 => 'WM/Period' },
	'peripheralillumcentralradius' => { 488 => 0x8030 },
	'peripheralillumcentralvalue' => { 488 => 0x8031 },
	'peripheralillumination' => { 107 => 0x20702, 113 => 0x68 },
	'peripheralilluminationcorr' => { 65 => 0x1, 374 => 0x2 },
	'peripheralilluminationon' => { 107 => '0x20702.0', 113 => 0x64 },
	'peripheralillumperiphvalue' => { 488 => 0x8032 },
	'peripherallighting' => { 82 => 0x2, 131 => 0x3804 },
	'peripherallightingsetting' => { 83 => 0x5 },
	'peripherallightingvalue' => { 82 => 0x6 },
	'permissions' => { 536 => 'permissions' },
	'permits' => { 512 => 'permits' },
	'person' => { 533 => 'person' },
	'personality' => { 504 => 'Personality' },
	'personheard' => { 528 => 'PersonHeard' },
	'personheardidentifier' => { 528 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 528 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 528 => 'PersonInImage' },
	'personinimagecharacteristic' => { 528 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 528 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 528 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 528 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 528 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 528 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 528 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 528 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 528 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 514 => 'PerspectiveAspect', 516 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 514 => 'PerspectiveHorizontal', 516 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 514 => 'PerspectiveRotate', 516 => 'PerspectiveRotate' },
	'perspectivescale' => { 514 => 'PerspectiveScale', 516 => 'PerspectiveScale' },
	'perspectiveupright' => { 514 => 'PerspectiveUpright', 516 => 'PerspectiveUpright' },
	'perspectivevertical' => { 514 => 'PerspectiveVertical', 516 => 'PerspectiveVertical' },
	'perspectivex' => { 514 => 'PerspectiveX', 516 => 'PerspectiveX' },
	'perspectivey' => { 514 => 'PerspectiveY', 516 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 96 => 0x1 },
	'pf10retainprogramshift' => { 96 => 0xb },
	'pf13drivepriority' => { 96 => 0xe },
	'pf14disablefocussearch' => { 96 => 0xf },
	'pf15disableafassistbeam' => { 96 => 0x10 },
	'pf16autofocuspointshoot' => { 96 => 0x11 },
	'pf17disableafpointsel' => { 96 => 0x12 },
	'pf18enableautoafpointsel' => { 96 => 0x13 },
	'pf19continuousshootspeed' => { 96 => 0x14 },
	'pf19shootingspeedhigh' => { 95 => 0xa },
	'pf19shootingspeedlow' => { 95 => 0x9 },
	'pf1disableshootingmodes' => { 96 => 0x2 },
	'pf1value' => { 95 => 0x1 },
	'pf20limitcontinousshots' => { 96 => 0x15 },
	'pf20maxcontinousshots' => { 95 => 0xb },
	'pf21enablequietoperation' => { 96 => 0x16 },
	'pf23felocktime' => { 95 => 0xd },
	'pf23postreleasetime' => { 95 => 0xe },
	'pf23settimerlengths' => { 96 => 0x18 },
	'pf23shutterbuttontime' => { 95 => 0xc },
	'pf24lightlcdduringbulb' => { 96 => 0x19 },
	'pf25aemode' => { 95 => 0xf },
	'pf25afmode' => { 95 => 0x12 },
	'pf25afpointsel' => { 95 => 0x13 },
	'pf25colormatrix' => { 95 => 0x17 },
	'pf25defaultclearsettings' => { 96 => 0x1a },
	'pf25drivemode' => { 95 => 0x11 },
	'pf25imagesize' => { 95 => 0x14 },
	'pf25meteringmode' => { 95 => 0x10 },
	'pf25parameters' => { 95 => 0x16 },
	'pf25wbmode' => { 95 => 0x15 },
	'pf26shortenreleaselag' => { 96 => 0x1b },
	'pf27reversedialrotation' => { 96 => 0x1c },
	'pf27value' => { 95 => 0x18 },
	'pf28noquickdialexpcomp' => { 96 => 0x1d },
	'pf29quickdialswitchoff' => { 96 => 0x1e },
	'pf2disablemeteringmodes' => { 96 => 0x3 },
	'pf2value' => { 95 => 0x2 },
	'pf30enlargementmode' => { 96 => 0x1f },
	'pf31originaldecisiondata' => { 96 => 0x20 },
	'pf3manualexposuremetering' => { 96 => 0x4 },
	'pf3value' => { 95 => 0x3 },
	'pf4exposuretimelimits' => { 96 => 0x5 },
	'pf4exposuretimemax' => { 95 => 0x5 },
	'pf4exposuretimemin' => { 95 => 0x4 },
	'pf5aperturelimits' => { 96 => 0x6 },
	'pf5aperturemax' => { 95 => 0x7 },
	'pf5aperturemin' => { 95 => 0x6 },
	'pf6presetshootingmodes' => { 96 => 0x7 },
	'pf7bracketcontinuousshoot' => { 96 => 0x8 },
	'pf8bracketshots' => { 95 => 0x8 },
	'pf8setbracketshots' => { 96 => 0x9 },
	'pf9changebracketsequence' => { 96 => 0xa },
	'phasedetectaf' => { 197 => 0x6 },
	'phonenumber' => { 161 => 'Phone' },
	'photoeffect' => { 36 => 0x28 },
	'photoeffecthistoryxml' => { 298 => 0xe9651831 },
	'photoeffects' => { 298 => 0xab5eca5e },
	'photoeffectsblue' => { 300 => 0x8 },
	'photoeffectsgreen' => { 300 => 0x6 },
	'photoeffectsred' => { 300 => 0x4 },
	'photoeffectstype' => { 300 => 0x0 },
	'photographer' => { 123 => 0xa437 },
	'photographicsensitivity' => { 521 => 'PhotographicSensitivity' },
	'photoidentifier' => { 1 => 0x2b },
	'photoinfoplayback' => { 305 => '17.6', 314 => '33.6' },
	'photometricinterpretation' => { 123 => 0x106, 539 => 'PhotometricInterpretation' },
	'photosappfeatureflags' => { 1 => 0x1f },
	'photoshootingmenubank' => { 245 => 0x11e, 246 => 0x11e, 247 => 0x112, 248 => 0x122, 249 => 0x122, 250 => 0x24, 268 => 0x0 },
	'photoshootingmenubankimagearea' => { 243 => 0x6dd, 245 => 0x144, 246 => 0x144, 247 => 0x134, 248 => 0x148, 249 => 0x148, 268 => '7.1' },
	'photoshopbgrthumbnail' => { 399 => 0x409 },
	'photoshopquality' => { 398 => 0x0 },
	'photoshopthumbnail' => { 399 => 0x40c },
	'photostyle' => { 349 => 0x89 },
	'picasawebgphotoid' => { 519 => 'picasawebGPhotoId' },
	'pick' => { 543 => 'pick' },
	'picklabel' => { 519 => 'PickLabel' },
	'pictinfo' => { 426 => 0x208 },
	'picturecontrol' => { 298 => 0xe2173c47 },
	'picturecontrolactive' => { 301 => 0x0 },
	'picturecontroladjust' => { 256 => 0x30, 257 => 0x30, 258 => 0x36 },
	'picturecontrolbase' => { 256 => 0x18, 257 => 0x18, 258 => 0x1c },
	'picturecontroldata' => { 240 => [0xbd,0x23] },
	'picturecontrolmode' => { 301 => 0x13 },
	'picturecontrolname' => { 256 => 0x4, 257 => 0x4, 258 => 0x8 },
	'picturecontrolquickadjust' => { 256 => 0x31, 257 => 0x31, 258 => 0x37 },
	'pictureeffect' => { 451 => 0x200e },
	'pictureeffect2' => { 460 => 0x1163, 461 => 0x1167, 462 => 0x1143, 463 => 0x11bf, 464 => 0x119b, 465 => 0x1053, 466 => 0x24b, 467 => 0x24b, 468 => 0x23c, 483 => 0x46 },
	'picturefinish' => { 186 => 0x71 },
	'picturemode' => { 131 => 0x1031, 325 => 0x520, 385 => [0xb,0x33], 427 => 0x3d },
	'picturemode2' => { 365 => 0x0 },
	'picturemodebwfilter' => { 325 => 0x525 },
	'picturemodecontrast' => { 325 => 0x523 },
	'picturemodeeffect' => { 325 => 0x52d },
	'picturemodehue' => { 325 => 0x522 },
	'picturemodesaturation' => { 325 => 0x521 },
	'picturemodesharpness' => { 325 => 0x524 },
	'picturemodetone' => { 325 => 0x526 },
	'pictureprofile' => { 460 => [0x115e,0x115f], 461 => [0x1162,0x1163], 462 => [0x113e,0x113f], 463 => [0x11ba,0x11bb], 464 => [0x1196,0x1197], 465 => [0x104e,0x104f], 466 => [0x246,0x247], 467 => [0x246,0x247], 468 => [0x237,0x238] },
	'picturestyle' => { 8 => [0x4b,0x51], 9 => 0xf4, 10 => 0x6c, 11 => 0x86, 12 => 0x73, 16 => 0xab, 17 => 0xa7, 18 => 0xb0, 19 => 0x6c, 20 => 0xa7, 21 => 0xf4, 22 => 0xb3, 24 => 0xf4, 25 => 0xfa, 27 => 0x169, 77 => 0xa, 107 => 0x20301, 113 => 0x2 },
	'picturestylepc' => { 67 => 0x4009 },
	'picturestyleuserdef' => { 67 => 0x4008 },
	'picturewizard' => { 424 => 0x21 },
	'picturewizardcolor' => { 423 => 0x1 },
	'picturewizardcontrast' => { 423 => 0x4 },
	'picturewizardmode' => { 423 => 0x0 },
	'picturewizardsaturation' => { 423 => 0x2 },
	'picturewizardsharpness' => { 423 => 0x3 },
	'pipelineversion' => { 180 => 'PipelineVersion' },
	'pitch' => { 119 => 0x6, 306 => '4.1', 318 => '4.1', 410 => ['ptch',"\xa9fpt"] },
	'pitchangle' => { 64 => 0x5, 254 => 0x4, 325 => 0x904, 339 => 'PitchAngle', 349 => 0x91, 383 => 0x2, 384 => 0x5, 422 => 0x1 },
	'pitchshift' => { 404 => 'player.movie.audio.pitchshift' },
	'pixelaspectratio' => { 403 => 'pasp' },
	'pixelclockfrequency' => { 142 => 0x40b },
	'pixelcorrectionoffset' => { 142 => 0x972 },
	'pixelcorrectionscale' => { 142 => 0x971 },
	'pixelscale' => { 123 => 0x830e },
	'pixelshiftdelay' => { 246 => 0x802 },
	'pixelshiftinfo' => { 451 => 0x202f },
	'pixelshiftnumbershots' => { 246 => 0x800 },
	'pixelshiftoffset' => { 131 => 0x1106 },
	'pixelshiftresolution' => { 386 => 0x0 },
	'pixelshiftshooting' => { 246 => 0x7fe },
	'pixelshiftshots' => { 131 => 0x1105 },
	'pixelsperunitx' => { 337 => 0x0 },
	'pixelsperunity' => { 337 => 0x4 },
	'pixelunits' => { 337 => 0x8 },
	'planarconfiguration' => { 123 => 0x11c, 539 => 'PlanarConfiguration' },
	'plane' => { 492 => [\'Planes','PlanesPlane'] },
	'planeboundary' => { 492 => [\'Planes','PlanesPlaneBoundary'] },
	'planeboundaryvertexcount' => { 492 => [\'Planes','PlanesPlaneBoundaryVertexCount'] },
	'planeextentx' => { 492 => [\'Planes','PlanesPlaneExtentX'] },
	'planeextentz' => { 492 => [\'Planes','PlanesPlaneExtentZ'] },
	'planepose' => { 492 => [\'Planes','PlanesPlanePose'] },
	'planeposepositionx' => { 492 => [\'Planes','PlanesPlanePosePositionX'] },
	'planeposepositiony' => { 492 => [\'Planes','PlanesPlanePosePositionY'] },
	'planeposepositionz' => { 492 => [\'Planes','PlanesPlanePosePositionZ'] },
	'planeposerotationw' => { 492 => [\'Planes','PlanesPlanePoseRotationW'] },
	'planeposerotationx' => { 492 => [\'Planes','PlanesPlanePoseRotationX'] },
	'planeposerotationy' => { 492 => [\'Planes','PlanesPlanePoseRotationY'] },
	'planeposerotationz' => { 492 => [\'Planes','PlanesPlanePoseRotationZ'] },
	'planeposetimestamp' => { 492 => [\'Planes','PlanesPlanePoseTimestamp'] },
	'planes' => { 492 => 'Planes' },
	'planningref' => { 528 => 'PlanningRef' },
	'planningrefidentifier' => { 528 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 528 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 528 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 548 => 'PlateNames' },
	'platform' => { 533 => 'platform' },
	'playallframes' => { 410 => 'AllF' },
	'playbackbutton' => { 246 => 0x804, 249 => 0x808 },
	'playbackbuttonplaybackmode' => { 246 => 0x80e, 249 => 0x814 },
	'playbackflickdown' => { 321 => 0x159, 322 => 0x159, 323 => 0x171 },
	'playbackflickup' => { 321 => 0x155, 322 => 0x155, 323 => 0x16d },
	'playbackmenustime' => { 310 => '20.1', 311 => '21.1', 312 => '21.1' },
	'playbackmonitorofftime' => { 305 => '25.2', 306 => '36.1', 308 => '36.1', 309 => '36.1', 313 => '35.1', 314 => '8.1', 315 => '35.1', 318 => '36.1', 319 => '36.1', 320 => '21.1', 321 => 0x33, 322 => 0x33, 323 => 0x33 },
	'playbackzoom' => { 306 => '37.1' },
	'playdisplay' => { 188 => 0x4e },
	'playerversion' => { 404 => 'player.version' },
	'playgap' => { 402 => 'pgap' },
	'playmode' => { 410 => 'SDLN' },
	'playselection' => { 410 => 'SelO' },
	'plusversion' => { 335 => 'Version' },
	'pmversion' => { 397 => 'PMVersion' },
	'pngwarning' => { 338 => 'Warning' },
	'podcast' => { 402 => 'pcst' },
	'podcasturl' => { 402 => 'purl' },
	'poilevel' => { 239 => 0x8 },
	'portraitimpressionbalance' => { 245 => 0x26e, 246 => 0x26e, 259 => 0xa0 },
	'portraitnote' => { 496 => 'PortraitNote' },
	'portraitoutputhighlightpoint' => { 113 => 0x1d },
	'portraitoutputshadowpoint' => { 113 => 0x1e },
	'portraitrawcolortone' => { 113 => 0x16 },
	'portraitrawcontrast' => { 113 => 0x18 },
	'portraitrawhighlight' => { 113 => 0x76 },
	'portraitrawhighlightpoint' => { 113 => 0x1b },
	'portraitrawlinear' => { 113 => 0x19 },
	'portraitrawsaturation' => { 113 => 0x17 },
	'portraitrawshadow' => { 113 => 0x7f },
	'portraitrawshadowpoint' => { 113 => 0x1c },
	'portraitrawsharpness' => { 113 => 0x1a },
	'portraitrefiner' => { 117 => 0x302b },
	'portraitrequest' => { 496 => 'PortraitRequest' },
	'portraitunsharpmaskfineness' => { 113 => 0x9a },
	'portraitunsharpmaskstrength' => { 113 => 0x98 },
	'portraitunsharpmaskthreshold' => { 113 => 0x9c },
	'portraitversion' => { 496 => 'PortraitVersion' },
	'pose' => { 492 => 'Pose' },
	'poseheadingdegrees' => { 502 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 502 => 'PosePitchDegrees' },
	'posepositionx' => { 492 => [\'Pose','PosePositionX'] },
	'posepositiony' => { 492 => [\'Pose','PosePositionY'] },
	'posepositionz' => { 492 => [\'Pose','PosePositionZ'] },
	'poserolldegrees' => { 502 => 'PoseRollDegrees' },
	'poserotationw' => { 492 => [\'Pose','PoseRotationW'] },
	'poserotationx' => { 492 => [\'Pose','PoseRotationX'] },
	'poserotationy' => { 492 => [\'Pose','PoseRotationY'] },
	'poserotationz' => { 492 => [\'Pose','PoseRotationZ'] },
	'posetimestamp' => { 492 => [\'Pose','PoseTimestamp'] },
	'positiondescriptor' => { 532 => 'positionDescriptor' },
	'postalcode' => { 165 => 'PostalCode' },
	'postcropvignetteamount' => { 514 => 'PostCropVignetteAmount', 516 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 514 => 'PostCropVignetteFeather', 516 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 514 => 'PostCropVignetteHighlightContrast', 516 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 514 => 'PostCropVignetteMidpoint', 516 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 514 => 'PostCropVignetteRoundness', 516 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 514 => 'PostCropVignetteStyle', 516 => 'PostCropVignetteStyle' },
	'postfocusmerging' => { 349 => 0xbf },
	'postreleaseburstlength' => { 248 => 0x714, 249 => 0x784, 321 => 0x289 },
	'potentialface1position' => { 447 => 0xb },
	'potentialface2position' => { 447 => 0x15 },
	'potentialface3position' => { 447 => 0x1f },
	'potentialface4position' => { 447 => 0x29 },
	'potentialface5position' => { 447 => 0x33 },
	'potentialface6position' => { 447 => 0x3d },
	'potentialface7position' => { 447 => 0x47 },
	'potentialface8position' => { 447 => 0x51 },
	'poweravailable' => { 363 => '0.2' },
	'powersource' => { 363 => '0.1' },
	'poweruptime' => { 240 => 0xb6 },
	'preaf' => { 130 => '0.2' },
	'precaptureframes' => { 330 => 0x300 },
	'predictor' => { 123 => 0x13d },
	'preflashreturnstrength' => { 276 => 0x28a },
	'prefs' => { 135 => 0xdd, 397 => 'Prefs' },
	'prereadfastresetcount' => { 142 => 0x187e },
	'prereleaseburstlength' => { 248 => 0x712, 249 => 0x782, 321 => 0x287 },
	'preservedfilename' => { 544 => 'PreservedFileName' },
	'preservedspecimen' => { 122 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 122 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presettype' => { 514 => 'PresetType', 516 => 'PresetType' },
	'presetwhitebalance' => { 188 => 0x24, 488 => 0x8002 },
	'presetwhitebalanceadj' => { 488 => 0x8014 },
	'pressure' => { 123 => 0x9402, 521 => 'Pressure' },
	'previewapplicationname' => { 123 => 0xc716 },
	'previewapplicationversion' => { 123 => 0xc717 },
	'previewbutton' => { 305 => ['14.1','15.1'], 306 => '15.1', 308 => '15.1', 309 => '15.1', 314 => '29.1', 315 => '14.1', 318 => '15.1', 319 => '15.1' },
	'previewbuttonplusdials' => { 305 => ['14.2','15.2'], 306 => '15.2', 308 => '43.1', 309 => '43.1', 314 => '31.2', 318 => '43.1', 319 => '43.1' },
	'previewcolorspace' => { 123 => 0xc71a },
	'previewcropbottom' => { 396 => 0xef },
	'previewcropleft' => { 396 => 0xec },
	'previewcropright' => { 396 => 0xee },
	'previewcroptop' => { 396 => 0xed },
	'previewdate' => { 408 => 0x0 },
	'previewdatetime' => { 123 => 0xc71b },
	'previewimage' => { 117 => 0x2000, 118 => 'Exif-PreviewImage', 124 => 'PreviewImage', 126 => 0x4, 170 => 'data', 190 => 0x81, 330 => 0x280, 347 => 0x300, 402 => 'snal', 410 => 'mcvr', 451 => 0x2001 },
	'previewimageborders' => { 385 => 0x3e },
	'previewimageheight' => { 76 => 0x4, 146 => 0xfa58 },
	'previewimagelength' => { 76 => 0x2, 117 => 0x3, 123 => [0x117,0x202], 190 => 0x89, 260 => 0x202, 325 => 0x102, 330 => 0x1037, 385 => 0x3, 416 => 0x1e, 421 => 0x3, 427 => [0x1b,0x1d], 440 => 0x202 },
	'previewimagename' => { 170 => '1Name' },
	'previewimagesize' => { 117 => 0x2, 151 => 0x2, 170 => 'ImageSize', 385 => 0x2, 427 => [0x1c,0x1e], 451 => 0xb02c, 488 => 0x9012 },
	'previewimagestart' => { 76 => 0x5, 117 => 0x4, 123 => [0x111,0x201], 190 => 0x88, 260 => 0x201, 325 => 0x101, 330 => 0x1036, 385 => 0x4, 416 => 0x1c, 421 => 0x2, 427 => [0x1a,0x1c], 440 => 0x201 },
	'previewimagetype' => { 170 => '0Type' },
	'previewimagevalid' => { 325 => 0x100, 330 => 0x1035 },
	'previewimagewidth' => { 76 => 0x3, 146 => 0xfa57 },
	'previewquality' => { 76 => 0x1 },
	'previewsettingsdigest' => { 123 => 0xc719 },
	'previewsettingsname' => { 123 => 0xc718 },
	'primaryafpoint' => { 197 => [0x38,0x44,0x7,0x8] },
	'primarychromaticities' => { 123 => 0x13f, 539 => 'PrimaryChromaticities' },
	'primaryftp' => { 504 => 'PrimaryFTP' },
	'primaryslot' => { 250 => 0x25, 268 => 0x2 },
	'printim' => { 123 => 0xc4a5 },
	'prioritysetinawb' => { 451 => 0x202b },
	'prioritysetupshutterrelease' => { 188 => 0x1d, 437 => 0x28 },
	'privatertkinfo' => { 506 => 'privateRTKInfo' },
	'processbordercolsleft' => { 142 => 0xc61 },
	'processbordercolsright' => { 142 => 0xc62 },
	'processborderrowsbottom' => { 142 => 0xc64 },
	'processborderrowstop' => { 142 => 0xc63 },
	'processingsoftware' => { 123 => 0xb },
	'processversion' => { 514 => 'ProcessVersion', 516 => 'ProcessVersion' },
	'producer' => { 183 => 'WM/Producer', 334 => 'Producer', 402 => "\xa9prd", 404 => 'producer', 410 => "\xa9prd", 530 => 'Producer' },
	'producerkeywords' => { 410 => "\xa9pdk" },
	'productcode' => { 533 => 'productCode' },
	'productid' => { 136 => 0x32, 402 => 'prID', 532 => 'productID' },
	'productidtype' => { 532 => 'productIDType' },
	'productinimage' => { 528 => 'ProductInImage' },
	'productinimagedescription' => { 528 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 528 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 528 => [\'ProductInImage','ProductInImageProductName'] },
	'productinimageproductid' => { 528 => [\'ProductInImage','ProductInImageProductId'] },
	'productioncode' => { 364 => 0x2 },
	'productorserviceconstraints' => { 335 => 'ProductOrServiceConstraints' },
	'productversion' => { 402 => 'VERS' },
	'profession' => { 533 => 'profession' },
	'profile' => { 492 => [\'Profiles','ProfilesProfile'] },
	'profilecalibrationsig' => { 123 => 0xc6f4 },
	'profilecameraindices' => { 492 => [\'Profiles','ProfilesProfileCameraIndices'] },
	'profilecopyright' => { 123 => 0xc6fe },
	'profiledynamicrange' => { 123 => 0xcd47 },
	'profileembedpolicy' => { 123 => 0xc6fd },
	'profilegaintablemap' => { 123 => 0xcd2d },
	'profilegaintablemap2' => { 123 => 0xcd40 },
	'profilegroupname' => { 123 => 0xcd48 },
	'profilehuesatmapdata1' => { 123 => 0xc6fa },
	'profilehuesatmapdata2' => { 123 => 0xc6fb },
	'profilehuesatmapdata3' => { 123 => 0xcd39 },
	'profilehuesatmapdims' => { 123 => 0xc6f9 },
	'profilehuesatmapencoding' => { 123 => 0xc7a3 },
	'profilelooktabledata' => { 123 => 0xc726 },
	'profilelooktabledims' => { 123 => 0xc725 },
	'profilelooktableencoding' => { 123 => 0xc7a4 },
	'profilename' => { 123 => 0xc6f8, 336 => 'iCCP-name' },
	'profiles' => { 492 => 'Profiles' },
	'profiletonecurve' => { 123 => 0xc6fc },
	'profiletype' => { 492 => [\'Profiles','ProfilesProfileType'] },
	'programiso' => { 349 => 0x3c },
	'programline' => { 365 => '1.1' },
	'programmode' => { 193 => 0x5 },
	'programshift' => { 240 => 0xd },
	'programversion' => { 135 => 0x46 },
	'prohibits' => { 512 => 'prohibits' },
	'projectiontype' => { 502 => 'ProjectionType', 503 => 'ProjectionType' },
	'projectname' => { 543 => 'projectName' },
	'projectref' => { 543 => 'projectRef' },
	'projectrefpath' => { 543 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 543 => [\'projectRef','projectRefType'] },
	'promotionurl' => { 183 => 'WM/PromotionURL' },
	'propertyreleaseid' => { 335 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 335 => 'PropertyReleaseStatus' },
	'provider' => { 183 => 'WM/Provider' },
	'province-state' => { 135 => 0x5f },
	'publicationdate' => { 533 => 'publicationDate' },
	'publicationdatea-platform' => { 533 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 533 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 533 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 533 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 533 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 528 => 'PublicationEvent' },
	'publicationeventdate' => { 528 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 528 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 528 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 533 => 'publicationName' },
	'publisher' => { 183 => 'WM/Publisher', 402 => "\xa9pub", 404 => 'publisher', 517 => 'publisher' },
	'publishingfrequency' => { 533 => 'publishingFrequency' },
	'pulldown' => { 543 => 'pullDown' },
	'purchasedate' => { 402 => 'purd' },
	'purplehsl' => { 107 => 0x20916 },
	'pxshiftperiphedgenr' => { 488 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 488 => 0x9014 },
	'quality' => { 0 => 0x1, 36 => 0x3, 116 => 0x2, 117 => 0x3002, 131 => 0x1000, 144 => 0x9, 240 => 0x4, 287 => 0x3, 330 => 0x201, 344 => 0x300, 385 => 0x8, 392 => 0x2, 427 => 0x16, 437 => 0x56, 438 => 0x56, 439 => 0xb, 451 => [0x102,0x202e] },
	'quality2' => { 460 => 0x1170, 461 => 0x1174, 462 => 0x1150, 464 => 0x11a8, 465 => 0x1060, 466 => 0x258, 467 => 0x258, 468 => 0x247, 474 => 0x29, 475 => 0x25, 476 => 0x2a },
	'qualitybutton' => { 322 => 0x17d, 323 => 0x195 },
	'qualitybuttonplaybackmode' => { 322 => 0x1bf, 323 => 0x1d7 },
	'qualityhint' => { 1 => 0x1a },
	'qualitymode' => { 117 => 0x8 },
	'quantizationmethod' => { 137 => 0x78 },
	'quickadjust' => { 301 => 0x2a },
	'quickcontroldialinmeter' => { 88 => 0x703 },
	'quickfix' => { 298 => 0x416391c6 },
	'quickshot' => { 426 => 0x213 },
	'quiettime' => { 142 => 0x188a },
	'radialdistortioncoefficient1' => { 215 => 0x14 },
	'radialdistortioncoefficient2' => { 215 => 0x1c },
	'radialdistortioncoefficient3' => { 215 => 0x24 },
	'rads' => { 410 => 'rads' },
	'rangefinder' => { 310 => '4.1', 311 => '5.1', 312 => '5.1' },
	'rangemask' => { 514 => 'RangeMaskMapInfo', 516 => 'RangeMaskMapInfo' },
	'rangemaskmapinfo' => { 514 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'], 516 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'] },
	'rangemaskmapinfolabmax' => { 514 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'], 516 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'] },
	'rangemaskmapinfolabmin' => { 514 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'], 516 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'] },
	'rangemaskmapinfolumeq' => { 514 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'], 516 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'] },
	'rangemaskmapinforgbmax' => { 514 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'], 516 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'] },
	'rangemaskmapinforgbmin' => { 514 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'], 516 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'] },
	'rasterizedcaption' => { 135 => 0x7d },
	'rating' => { 107 => 0x10100, 123 => 0x4746, 131 => 0x1431, 396 => 0xdf, 402 => 'rtng', 410 => 'rtng', 451 => 0x2002, 509 => 'rating', 518 => 'rating', 528 => 'Rating', 533 => 'rating', 541 => 'Rating' },
	'ratingpercent' => { 123 => 0x4749, 182 => 'Rating', 402 => 'rate', 541 => 'RatingPercent' },
	'ratingregion' => { 528 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 528 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 528 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 528 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 528 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpsaltituderef' => { 528 => [\'Rating','RatingRatingRegionGPSAltitudeRef'] },
	'ratingregiongpslatitude' => { 528 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 528 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 528 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 528 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 528 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 528 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 528 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 528 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 528 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 528 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 528 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 528 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 528 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 86 => 0x8, 190 => 0x109, 365 => 0xd },
	'rawbrightnessadj' => { 107 => 0x20001, 112 => 0x38 },
	'rawburstimagecount' => { 78 => 0x2 },
	'rawburstimagenum' => { 78 => 0x1 },
	'rawcoloradj' => { 112 => 0x2e },
	'rawcropbottom' => { 396 => 0xd4 },
	'rawcropleft' => { 396 => 0xd1 },
	'rawcropright' => { 396 => 0xd3 },
	'rawcroptop' => { 396 => 0xd2 },
	'rawcustomsaturation' => { 112 => 0x30 },
	'rawcustomtone' => { 112 => 0x34 },
	'rawdata' => { 424 => 0xa048 },
	'rawdatabyteorder' => { 424 => 0x40 },
	'rawdatacfapattern' => { 424 => 0x50 },
	'rawdatauniqueid' => { 123 => 0xc65d },
	'rawdepth' => { 192 => 0x10 },
	'rawdevartfilter' => { 332 => 0x121 },
	'rawdevautogradation' => { 332 => 0x119 },
	'rawdevcolorspace' => { 331 => 0x108, 332 => 0x109 },
	'rawdevcontrastvalue' => { 331 => 0x106, 332 => 0x105 },
	'rawdeveditstatus' => { 331 => 0x10b },
	'rawdevelopingsoftware' => { 123 => 0xa43a },
	'rawdevelopmentprocess' => { 385 => 0x62 },
	'rawdevengine' => { 331 => 0x109, 332 => 0x10b },
	'rawdevexposurebiasvalue' => { 331 => 0x100, 332 => 0x100 },
	'rawdevgradation' => { 332 => 0x112 },
	'rawdevgraypoint' => { 331 => 0x103, 332 => 0x104 },
	'rawdevmemorycoloremphasis' => { 331 => 0x105, 332 => 0x108 },
	'rawdevnoisereduction' => { 331 => 0x10a, 332 => 0x10a },
	'rawdevpicturemode' => { 332 => 0x10c },
	'rawdevpm_bwfilter' => { 332 => 0x110 },
	'rawdevpmcontrast' => { 332 => 0x10e },
	'rawdevpmnoisefilter' => { 332 => 0x120 },
	'rawdevpmpicturetone' => { 332 => 0x111 },
	'rawdevpmsaturation' => { 332 => 0x10d },
	'rawdevpmsharpness' => { 332 => 0x10f },
	'rawdevsaturation3' => { 332 => 0x113 },
	'rawdevsaturationemphasis' => { 331 => 0x104, 332 => 0x107 },
	'rawdevsettings' => { 331 => 0x10c },
	'rawdevsharpnessvalue' => { 331 => 0x107, 332 => 0x106 },
	'rawdevversion' => { 331 => 0x0, 332 => 0x0 },
	'rawdevwbfineadjustment' => { 331 => 0x102, 332 => 0x103 },
	'rawdevwhitebalance' => { 332 => 0x101 },
	'rawdevwhitebalancevalue' => { 331 => 0x101, 332 => 0x102 },
	'rawfile' => { 123 => 0xfe4c },
	'rawfilename' => { 514 => 'RawFileName', 516 => 'RawFileName' },
	'rawfiletype' => { 451 => 0x2029 },
	'rawformat' => { 354 => 0x2d, 394 => 0x10e },
	'rawimagecenter' => { 240 => 0x99 },
	'rawimagedigest' => { 123 => 0xc71c },
	'rawimagesize' => { 385 => 0x39 },
	'rawinfoversion' => { 333 => 0x0 },
	'rawjpgheight' => { 103 => 0x4 },
	'rawjpgquality' => { 59 => 0x6, 103 => 0x1 },
	'rawjpgsize' => { 59 => 0x7, 103 => 0x2 },
	'rawjpgwidth' => { 103 => 0x3 },
	'rawmeasuredrggb' => { 45 => 0x26a, 47 => 0x280, 49 => 0x194, 50 => [0x1ad,0x26b] },
	'rawrppused' => { 509 => 'rawrppused' },
	'rawtopreviewgain' => { 123 => 0xc7a8 },
	'readouttypeactual' => { 142 => 0x1903 },
	'readouttyperequested' => { 142 => 0x1902 },
	'reardisplay' => { 305 => '12.3', 306 => '6.2' },
	'recdevice' => { 528 => 'RecDevice' },
	'recdeviceattlensdescription' => { 528 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 528 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 528 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 528 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 528 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 535 => 'recipeEndingPage' },
	'recipepagerange' => { 535 => 'recipePageRange' },
	'recipesource' => { 535 => 'recipeSource' },
	'recipestartingpage' => { 535 => 'recipeStartingPage' },
	'recipetitle' => { 535 => 'recipeTitle' },
	'recognizedface1age' => { 342 => 0x20 },
	'recognizedface1name' => { 342 => 0x4 },
	'recognizedface1position' => { 342 => 0x18 },
	'recognizedface2age' => { 342 => 0x50 },
	'recognizedface2name' => { 342 => 0x34 },
	'recognizedface2position' => { 342 => 0x48 },
	'recognizedface3age' => { 342 => 0x80 },
	'recognizedface3name' => { 342 => 0x64 },
	'recognizedface3position' => { 342 => 0x78 },
	'recognizedfaceflags' => { 349 => 0x63 },
	'recommendedexposureindex' => { 123 => 0x8832, 521 => 'RecommendedExposureIndex' },
	'record' => { 122 => 'Record' },
	'recordbasisofrecord' => { 122 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 122 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 122 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 122 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 122 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 122 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 188 => 0x4d },
	'recorddynamicproperties' => { 122 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 101 => 0x1804 },
	'recordinformationwithheld' => { 122 => [\'Record','RecordInformationWithheld'] },
	'recordingcopyright' => { 410 => "\xa9phg" },
	'recordingformat' => { 417 => 0x1000 },
	'recordingmode' => { 116 => 0x1, 392 => 0x1 },
	'recordinstitutioncode' => { 122 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 122 => [\'Record','RecordInstitutionID'] },
	'recordlabelname' => { 410 => "\xa9lab" },
	'recordlabelurl' => { 410 => "\xa9lal" },
	'recordlocationdata' => { 247 => 0x660, 248 => 0x690, 249 => 0x6f8 },
	'recordmode' => { 36 => 0x9, 117 => 0x3000 },
	'recordownerinstitutioncode' => { 122 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 426 => 0x217 },
	'redbalance' => { 330 => 0x1017, 354 => 0x11, 385 => 0x1c },
	'redcurvelimits' => { 112 => 0x18a },
	'redcurvepoints' => { 111 => 0x2d, 112 => 0x160 },
	'redeyecorrection' => { 302 => 0x0 },
	'redeyeinfo' => { 514 => 'RedEyeInfo', 516 => 'RedEyeInfo' },
	'redeyereduction' => { 188 => 0x41, 437 => 0x6a, 439 => 0x28 },
	'redeyeremoval' => { 349 => 0xb9 },
	'redhsl' => { 107 => 0x20910 },
	'redhue' => { 514 => 'RedHue', 516 => 'RedHue' },
	'redsaturation' => { 514 => 'RedSaturation', 516 => 'RedSaturation' },
	'reductionmatrix1' => { 123 => 0xc625 },
	'reductionmatrix2' => { 123 => 0xc626 },
	'reductionmatrix3' => { 123 => 0xcd3a },
	'reelname' => { 123 => 0xc789, 410 => 'reel' },
	'reference1' => { 526 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 526 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 526 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 526 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 526 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 526 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 123 => 0x214, 539 => 'ReferenceBlackWhite' },
	'referencedate' => { 135 => 0x2f },
	'referencenumber' => { 135 => 0x32 },
	'references' => { 161 => 'References' },
	'referenceservice' => { 135 => 0x2d },
	'regionappliedtodimensions' => { 176 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 176 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 176 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 176 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 176 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 176 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 176 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 176 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 176 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 176 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 176 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 176 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 335 => 'RegionConstraints' },
	'regiondescription' => { 176 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 176 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 176 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 176 => 'Regions' },
	'regioninfoacdsee' => { 489 => 'Regions' },
	'regioninfodateregionsvalid' => { 179 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 179 => 'RegionInfo' },
	'regioninforegions' => { 179 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 176 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 176 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 179 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 179 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 179 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 179 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 179 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 176 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 176 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 176 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 528 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 528 => 'RegistryId' },
	'registryitemid' => { 528 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 528 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 159 => 'data' },
	'relatedaudiofilename' => { 159 => '1Name' },
	'relatedaudiofiletype' => { 159 => '0Type' },
	'relatedimagefileformat' => { 123 => 0x1000 },
	'relatedimageheight' => { 123 => 0x1002 },
	'relatedimagewidth' => { 123 => 0x1001 },
	'relatedresourceid' => { 122 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 123 => 0xa004, 520 => 'RelatedSoundFile' },
	'relatedvideofile' => { 173 => 'data' },
	'relatedvideofilename' => { 173 => '1Name' },
	'relatedvideofiletype' => { 173 => '0Type' },
	'relation' => { 517 => 'relation' },
	'relationshipaccordingto' => { 122 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 122 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 122 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipofresourceid' => { 122 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResourceID'] },
	'relationshipremarks' => { 122 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 120 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 543 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 543 => 'relativeTimestamp' },
	'relativetimestampscale' => { 543 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 543 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 305 => '17.8', 306 => '18.5', 308 => '18.4', 309 => '18.4', 314 => '33.8', 315 => '17.6', 318 => '18.5', 319 => '18.4' },
	'releasedate' => { 135 => 0x1e, 402 => 'rldt', 509 => 'ReleaseDate', 543 => 'releaseDate' },
	'releasemode' => { 117 => 0x3001, 244 => 0x5c, 278 => 0x184d, 451 => 0xb049 },
	'releasemode2' => { 460 => 0x112c, 461 => [0x112c,0x8], 462 => [0x1108,0x8], 463 => [0x1184,0x8], 464 => [0x1160,0x8], 465 => [0x4,0x1018], 466 => [0x4,0x210], 467 => [0x4,0x210], 468 => [0x4,0x208], 470 => [0x67,0x3f], 471 => [0x6b,0x6d,0x73,0x4b], 472 => [0x6b,0x4b], 473 => 0x1f, 474 => 0x10, 475 => 0x10, 476 => 0x9, 483 => 0x34 },
	'releasemode3' => { 460 => 0x1128, 461 => 0x1128, 462 => 0x1104, 463 => 0x1180, 464 => 0x115c, 465 => 0x1014, 466 => 0x20c, 467 => 0x20c, 468 => 0x204 },
	'releaseready' => { 528 => 'ReleaseReady' },
	'releasesetting' => { 101 => 0x1016 },
	'releasetime' => { 135 => 0x23, 509 => 'ReleaseTime' },
	'remoteonduration' => { 307 => '3.4', 310 => '17.2', 311 => '18.2', 312 => '18.2', 313 => '18.2', 315 => '18.2', 316 => '4.3', 320 => '19.2' },
	'renditionclass' => { 544 => 'RenditionClass' },
	'renditionof' => { 544 => 'RenditionOf' },
	'renditionofalternatepaths' => { 544 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 544 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 544 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 544 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 544 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 544 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 544 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 544 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 544 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 544 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 544 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 544 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 544 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 544 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 544 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 544 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 544 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 544 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 544 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 544 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 544 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 544 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 544 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 544 => 'RenditionParams' },
	'repeatingflashcount' => { 218 => 0xd, 219 => 0xe, 220 => 0xe, 221 => 0xe, 222 => 0xe, 223 => 0xe, 314 => '17.2', 315 => '24.2', 316 => '9.2', 317 => '24.2', 320 => '25.2' },
	'repeatingflashcountbuilt-in' => { 285 => 0x4db },
	'repeatingflashcountexternal' => { 285 => 0x4c3 },
	'repeatingflashoutput' => { 314 => '17.1', 315 => '24.1', 316 => '9.1', 317 => '24.1', 320 => '25.1' },
	'repeatingflashoutputexternal' => { 285 => 0x4c0 },
	'repeatingflashrate' => { 218 => 0xc, 219 => 0xd, 220 => 0xd, 221 => 0xd, 222 => 0xd, 223 => 0xd, 314 => '18.1', 315 => '25.1', 316 => '10.1', 317 => '25.1', 320 => '26.1' },
	'repeatingflashratebuilt-in' => { 285 => 0x4da },
	'repeatingflashrateexternal' => { 285 => 0x4c2 },
	'requirements' => { 410 => "\xa9req" },
	'requires' => { 512 => 'requires' },
	'resampleparams' => { 543 => 'resampleParams' },
	'resampleparamsquality' => { 543 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 142 => 0xe50 },
	'resamplingkerneldenominators067' => { 142 => 0xe4f },
	'resamplingkerneldenominators100' => { 142 => 0xe51 },
	'resaved' => { 426 => 0x21e },
	'resetblacksegrows' => { 142 => 0x181a },
	'resolution' => { 166 => 'Resolution' },
	'resolutionmode' => { 427 => [0x87,0x4] },
	'resolutionunit' => { 123 => 0x128, 138 => 0x2, 539 => 'ResolutionUnit' },
	'resourceid' => { 122 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 122 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 122 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 88 => 0x612 },
	'restrictions' => { 536 => 'restrictions' },
	'retouchareafeather' => { 514 => [\'RetouchAreas','RetouchAreasFeather'], 516 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 514 => [\'RetouchAreas','RetouchAreasMasksAlpha'], 516 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 514 => [\'RetouchAreas','RetouchAreasMasksAngle'], 516 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 514 => [\'RetouchAreas','RetouchAreasMasksBottom'], 516 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 514 => [\'RetouchAreas','RetouchAreasMasksCenterValue'], 516 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 514 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'], 516 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 514 => [\'RetouchAreas','RetouchAreasMasksDabs'], 516 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 514 => [\'RetouchAreas','RetouchAreasMasksFeather'], 516 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 514 => [\'RetouchAreas','RetouchAreasMasksFlipped'], 516 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 514 => [\'RetouchAreas','RetouchAreasMasksFlow'], 516 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 514 => [\'RetouchAreas','RetouchAreasMasksFullX'], 516 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 514 => [\'RetouchAreas','RetouchAreasMasksFullY'], 516 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskinputdigest' => { 514 => [\'RetouchAreas','RetouchAreasMasksInputDigest'], 516 => [\'RetouchAreas','RetouchAreasMasksInputDigest'] },
	'retouchareamaskleft' => { 514 => [\'RetouchAreas','RetouchAreasMasksLeft'], 516 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmaskactive' => { 514 => [\'RetouchAreas','RetouchAreasMasksMaskActive'], 516 => [\'RetouchAreas','RetouchAreasMasksMaskActive'] },
	'retouchareamaskmaskblendmode' => { 514 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'], 516 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'] },
	'retouchareamaskmaskdigest' => { 514 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'], 516 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'] },
	'retouchareamaskmaskinverted' => { 514 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'], 516 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'] },
	'retouchareamaskmaskname' => { 514 => [\'RetouchAreas','RetouchAreasMasksMaskName'], 516 => [\'RetouchAreas','RetouchAreasMasksMaskName'] },
	'retouchareamaskmasks' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasks'], 516 => [\'RetouchAreas','RetouchAreasMasksMasks'] },
	'retouchareamaskmasksalpha' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'] },
	'retouchareamaskmasksangle' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'] },
	'retouchareamaskmasksbottom' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'] },
	'retouchareamaskmaskscentervalue' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'] },
	'retouchareamaskmaskscenterweight' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'] },
	'retouchareamaskmasksdabs' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'] },
	'retouchareamaskmasksfeather' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'] },
	'retouchareamaskmasksflipped' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'] },
	'retouchareamaskmasksflow' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'] },
	'retouchareamaskmasksfullx' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'] },
	'retouchareamaskmasksfully' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'] },
	'retouchareamaskmasksinputdigest' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'] },
	'retouchareamaskmasksleft' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'] },
	'retouchareamaskmasksmaskactive' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'] },
	'retouchareamaskmasksmaskblendmode' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'] },
	'retouchareamaskmasksmaskdigest' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'] },
	'retouchareamaskmasksmaskinverted' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'] },
	'retouchareamaskmasksmaskname' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'] },
	'retouchareamaskmasksmasksubtype' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'] },
	'retouchareamaskmasksmasksyncid' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'] },
	'retouchareamaskmasksmaskversion' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'] },
	'retouchareamaskmasksmidpoint' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'] },
	'retouchareamaskmasksorigin' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'] },
	'retouchareamaskmasksperimetervalue' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'] },
	'retouchareamaskmasksradius' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'] },
	'retouchareamaskmasksreferencepoint' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'] },
	'retouchareamaskmasksright' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksRight'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksRight'] },
	'retouchareamaskmasksroundness' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'] },
	'retouchareamaskmaskssizex' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'] },
	'retouchareamaskmaskssizey' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'] },
	'retouchareamaskmaskstop' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksTop'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksTop'] },
	'retouchareamaskmasksubtype' => { 514 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'], 516 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'] },
	'retouchareamaskmasksvalue' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'] },
	'retouchareamaskmasksversion' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'] },
	'retouchareamaskmaskswhat' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'] },
	'retouchareamaskmaskswholeimagearea' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'] },
	'retouchareamaskmasksx' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksX'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksX'] },
	'retouchareamaskmasksy' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksY'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksY'] },
	'retouchareamaskmasksyncid' => { 514 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'], 516 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'] },
	'retouchareamaskmaskszerox' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'] },
	'retouchareamaskmaskszeroy' => { 514 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'], 516 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'] },
	'retouchareamaskmaskversion' => { 514 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'], 516 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'] },
	'retouchareamaskmidpoint' => { 514 => [\'RetouchAreas','RetouchAreasMasksMidpoint'], 516 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskorigin' => { 514 => [\'RetouchAreas','RetouchAreasMasksOrigin'], 516 => [\'RetouchAreas','RetouchAreasMasksOrigin'] },
	'retouchareamaskperimetervalue' => { 514 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'], 516 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 514 => [\'RetouchAreas','RetouchAreasMasksRadius'], 516 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskrange' => { 514 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'], 516 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'] },
	'retouchareamaskrangeareamodels' => { 514 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'], 516 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'] },
	'retouchareamaskrangeareamodelscolorsampleinfo' => { 514 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 516 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'retouchareamaskrangeareamodelscomponents' => { 514 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'], 516 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'retouchareamaskrangecoloramount' => { 514 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'], 516 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'] },
	'retouchareamaskrangedepthfeather' => { 514 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'], 516 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'] },
	'retouchareamaskrangedepthmax' => { 514 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'], 516 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'] },
	'retouchareamaskrangedepthmin' => { 514 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'], 516 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'] },
	'retouchareamaskrangeinvert' => { 514 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'], 516 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'] },
	'retouchareamaskrangelumfeather' => { 514 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'], 516 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'] },
	'retouchareamaskrangeluminancedepthsampleinfo' => { 514 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 516 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'retouchareamaskrangelummax' => { 514 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'], 516 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'] },
	'retouchareamaskrangelummin' => { 514 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'], 516 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'] },
	'retouchareamaskrangelumrange' => { 514 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'], 516 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'] },
	'retouchareamaskrangesampletype' => { 514 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'], 516 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'] },
	'retouchareamaskrangetype' => { 514 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'], 516 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'] },
	'retouchareamaskrangeversion' => { 514 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'], 516 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'] },
	'retouchareamaskreferencepoint' => { 514 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'], 516 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'] },
	'retouchareamaskright' => { 514 => [\'RetouchAreas','RetouchAreasMasksRight'], 516 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 514 => [\'RetouchAreas','RetouchAreasMasksRoundness'], 516 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 514 => [\'RetouchAreas','RetouchAreasMasks'], 516 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 514 => [\'RetouchAreas','RetouchAreasMasksSizeX'], 516 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 514 => [\'RetouchAreas','RetouchAreasMasksSizeY'], 516 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 514 => [\'RetouchAreas','RetouchAreasMasksTop'], 516 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 514 => [\'RetouchAreas','RetouchAreasMasksMaskValue'], 516 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 514 => [\'RetouchAreas','RetouchAreasMasksVersion'], 516 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 514 => [\'RetouchAreas','RetouchAreasMasksWhat'], 516 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskwholeimagearea' => { 514 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'], 516 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'] },
	'retouchareamaskx' => { 514 => [\'RetouchAreas','RetouchAreasMasksX'], 516 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 514 => [\'RetouchAreas','RetouchAreasMasksY'], 516 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 514 => [\'RetouchAreas','RetouchAreasMasksZeroX'], 516 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 514 => [\'RetouchAreas','RetouchAreasMasksZeroY'], 516 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 514 => [\'RetouchAreas','RetouchAreasMethod'], 516 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 514 => [\'RetouchAreas','RetouchAreasOffsetY'], 516 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 514 => [\'RetouchAreas','RetouchAreasOpacity'], 516 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 514 => 'RetouchAreas', 516 => 'RetouchAreas' },
	'retouchareaseed' => { 514 => [\'RetouchAreas','RetouchAreasSeed'], 516 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 514 => [\'RetouchAreas','RetouchAreasSourceState'], 516 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 514 => [\'RetouchAreas','RetouchAreasSourceX'], 516 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 514 => [\'RetouchAreas','RetouchAreasSpotType'], 516 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 240 => 0x9e },
	'retouchinfo' => { 514 => 'RetouchInfo', 516 => 'RetouchInfo' },
	'retouchnefprocessing' => { 262 => 0x5 },
	'retractlensonpoweroff' => { 88 => 0x814 },
	'reuse' => { 335 => 'Reuse' },
	'reuseallowed' => { 546 => 'ReuseAllowed' },
	'reuseprohibited' => { 536 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 312 => '5.2' },
	'reversefocusring' => { 321 => 0x163, 322 => 0x163, 323 => 0x17b },
	'reverseindicators' => { 305 => '12.1', 306 => '6.1', 308 => '6.1', 309 => '6.1', 310 => '4.3', 311 => '5.2', 312 => '5.4', 314 => '33.5', 315 => '5.1', 318 => '6.1', 319 => '6.1', 320 => '6.2', 321 => 0xc1, 322 => 0xc1, 323 => 0xc1 },
	'reverseshutterspeedaperture' => { 312 => '5.3' },
	'revision' => { 518 => 'revision' },
	'rflensmffocusringsensitivity' => { 88 => 0x714 },
	'rflenstype' => { 59 => 0x3d },
	'rgbcurvelimits' => { 112 => 0x238 },
	'rgbcurvepoints' => { 111 => 0x7, 112 => 0x20e },
	'rgbtables' => { 123 => 0xcd3f },
	'richtextcomment' => { 523 => 'RichTextComment' },
	'ricohdate' => { 416 => 0x6 },
	'ricohimageheight' => { 416 => 0x2 },
	'ricohimagewidth' => { 416 => 0x0 },
	'rightalbedo' => { 505 => 'RightAlbedo' },
	'rightascension' => { 169 => 'RightAscension' },
	'rights' => { 517 => 'rights' },
	'rightsagent' => { 536 => 'rightsAgent' },
	'rightsowner' => { 536 => 'rightsOwner' },
	'roll' => { 119 => 0x8, 410 => ['roll',"\xa9frl"] },
	'rollangle' => { 64 => 0x4, 131 => 0x144d, 254 => 0x0, 325 => 0x903, 339 => 'RollAngle', 349 => 0x90, 383 => 0x1, 384 => 0x3, 422 => 0x2 },
	'romoperationmode' => { 101 => 0x80d },
	'rotation' => { 31 => 0x17, 32 => 0x18, 100 => 0x3, 107 => 0x10002, 112 => 0x26e, 118 => 'QuickTime-Rotation', 127 => 0x4, 169 => 'Rotation', 186 => [0x65,0x50], 187 => 0x46, 188 => 0x5a, 191 => 0x10, 263 => 0x1a, 278 => 0x3693, 284 => '590.1', 298 => 0x76a43207, 349 => 0x30, 365 => '17.2', 396 => 0xd8, 403 => 'irot', 437 => 0x3f, 438 => 0x3f, 448 => 0x10 },
	'routedto' => { 522 => 'RoutedTo' },
	'routing' => { 401 => 'Routing' },
	'routingdestinations' => { 504 => 'RoutingDestinations' },
	'routingexclusions' => { 504 => 'RoutingExclusions' },
	'routingnotes' => { 522 => 'RoutingNotes' },
	'rowsperstrip' => { 123 => 0x116 },
	'rpp' => { 509 => 'rpp' },
	'rtkflag' => { 120 => 'RtkFlag' },
	'rtkstdhgt' => { 120 => 'RtkStdHgt' },
	'rtkstdlat' => { 120 => 'RtkStdLat' },
	'rtkstdlon' => { 120 => 'RtkStdLon' },
	'safetyshift' => { 88 => 0x108 },
	'safetyshiftinavortv' => { 86 => 0x10, 87 => 0x10, 89 => 0xf, 90 => 0x10, 93 => 0x10 },
	'sameexposurefornewaperture' => { 88 => 0x112 },
	'samplebits' => { 159 => 'SampleBits' },
	'samplepagerange' => { 533 => 'samplePageRange' },
	'samplerate' => { 159 => 'SampleRate' },
	'samplesperpixel' => { 123 => 0x115, 354 => 0x8, 539 => 'SamplesPerPixel' },
	'samplestructure' => { 137 => 0x5a },
	'samsungmodelid' => { 424 => 0x3 },
	'sanyoquality' => { 426 => 0x201 },
	'sanyothumbnail' => { 426 => 0x100 },
	'saturation' => { 10 => 0x6e, 12 => 0x76, 36 => 0xe, 53 => 0x1, 66 => 0x7, 116 => 0xd, 117 => [0x3013,0x1f], 123 => [0xa409,0xfe55], 131 => 0x1003, 160 => 'Saturation', 185 => 0x1f, 186 => 0x32, 187 => 0x28, 188 => 0x1a, 193 => 0x1, 240 => 0xaa, 256 => 0x35, 257 => 0x3b, 258 => 0x43, 349 => 0x40, 351 => 0x300d, 385 => 0x1f, 392 => 0xd, 411 => 0x27, 413 => 0x58, 416 => 0x28, 417 => 0x1013, 427 => 0x10, 437 => 0x1e, 438 => 0x1b, 451 => 0x2005, 514 => 'Saturation', 516 => 'Saturation', 520 => 'Saturation' },
	'saturationadj' => { 107 => 0x20901, 112 => 0x116, 240 => 0x94, 297 => 0x1, 301 => 0x2e, 488 => 0x8016 },
	'saturationadjustmentaqua' => { 514 => 'SaturationAdjustmentAqua', 516 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 514 => 'SaturationAdjustmentBlue', 516 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 514 => 'SaturationAdjustmentGreen', 516 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 514 => 'SaturationAdjustmentMagenta', 516 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 514 => 'SaturationAdjustmentOrange', 516 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 514 => 'SaturationAdjustmentPurple', 516 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 514 => 'SaturationAdjustmentRed', 516 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 514 => 'SaturationAdjustmentYellow', 516 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 74 => 0x98 },
	'saturationfaithful' => { 19 => 0xfe, 73 => 0x68, 74 => 0x68 },
	'saturationlandscape' => { 19 => 0xfc, 73 => 0x38, 74 => 0x38 },
	'saturationmonochrome' => { 73 => 0x80, 74 => 0x80 },
	'saturationneutral' => { 19 => 0xfd, 73 => 0x50, 74 => 0x50 },
	'saturationportrait' => { 19 => 0xfb, 73 => 0x20, 74 => 0x20 },
	'saturationsetting' => { 333 => 0x1010, 439 => 0x11, 456 => 0x9 },
	'saturationstandard' => { 19 => 0xfa, 73 => 0x8, 74 => 0x8 },
	'saturationuserdef1' => { 19 => 0x100, 73 => 0x98, 74 => 0xb0 },
	'saturationuserdef2' => { 19 => 0x101, 73 => 0xb0, 74 => 0xc8 },
	'saturationuserdef3' => { 19 => 0x102, 73 => 0xc8, 74 => 0xe0 },
	'saveid' => { 544 => 'SaveID' },
	'sbaanalysiscomplete' => { 142 => 0xc35 },
	'sbablack' => { 142 => 0xc25 },
	'sbagmoffset' => { 142 => 0xc4a },
	'sbagray' => { 142 => 0xc26 },
	'sbagreenmagentabal' => { 142 => 0xc33 },
	'sbahighgray' => { 142 => 0xc46 },
	'sbailloffset' => { 142 => 0xc49 },
	'sbailluminantbal' => { 142 => 0xc34 },
	'sbalowgray' => { 142 => 0xc47 },
	'sbaneutralbal' => { 142 => 0xc32 },
	'sbawhite' => { 142 => 0xc27 },
	'scaletype' => { 543 => 'scaleType' },
	'scalingfactorheight' => { 339 => 'ScalingFactorHeight' },
	'scanimageenhancer' => { 264 => 0x60 },
	'scanningdirection' => { 137 => 0x64 },
	'scene' => { 410 => 'scen', 527 => 'Scene', 543 => 'scene' },
	'scenearea' => { 328 => 0x211, 330 => 0x1031 },
	'sceneassist' => { 240 => 0x9c },
	'scenecapturetype' => { 123 => 0xa406, 520 => 'SceneCaptureType' },
	'scenedetect' => { 328 => 0x210, 330 => 0x1030 },
	'scenedetectdata' => { 328 => 0x212, 330 => 0x1033 },
	'sceneflags' => { 1 => 0x25 },
	'scenemode' => { 146 => 0xfa02, 190 => 0x100, 240 => 0x8f, 325 => 0x509, 330 => 0x403, 349 => 0x8001, 358 => 0xf, 451 => 0xb023 },
	'scenemodeused' => { 148 => [0x6002,0xf002] },
	'scenerecognition' => { 131 => 0x1425 },
	'scenereferred' => { 524 => 'scene_referred' },
	'sceneselect' => { 426 => 0x21f },
	'scenetype' => { 123 => 0xa301, 520 => 'SceneType' },
	'screentips' => { 305 => '12.7', 306 => '5.3', 314 => '13.1', 315 => '4.4', 318 => '5.4', 320 => '5.1' },
	'scriptversion' => { 142 => 0x1770 },
	'sdrblend' => { 514 => 'SDRBlend', 516 => 'SDRBlend' },
	'sdrbrightness' => { 514 => 'SDRBrightness', 516 => 'SDRBrightness' },
	'sdrcontrast' => { 514 => 'SDRContrast', 516 => 'SDRContrast' },
	'sdrhighlights' => { 514 => 'SDRHighlights', 516 => 'SDRHighlights' },
	'sdrshadows' => { 514 => 'SDRShadows', 516 => 'SDRShadows' },
	'sdrwhites' => { 514 => 'SDRWhites', 516 => 'SDRWhites' },
	'season' => { 528 => 'Season', 532 => 'season' },
	'seasonidentifier' => { 528 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 528 => [\'Season','SeasonName'] },
	'seasonnumber' => { 528 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 504 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 245 => 0x240, 246 => 0x240, 247 => 0x22c, 248 => 0x240, 249 => 0x240, 267 => 0x13c, 278 => 0x1d0 },
	'section' => { 533 => 'section' },
	'securityclassification' => { 123 => 0x9212 },
	'selectableafpoint' => { 88 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 88 => 0x512 },
	'selfdata' => { 120 => 'SelfData' },
	'selftimer' => { 36 => 0x2, 349 => 0x2e, 426 => 0x214, 460 => 0x1134, 461 => 0x1134, 462 => 0x1110, 463 => 0x118c, 464 => 0x1168, 465 => 0x1020, 466 => 0x218, 467 => 0x218, 468 => 0x210 },
	'selftimer2' => { 80 => 0x1d },
	'selftimerinterval' => { 315 => '19.2' },
	'selftimermode' => { 123 => 0x882b },
	'selftimershotcount' => { 306 => '20.2', 308 => '20.3', 309 => '20.3', 310 => '18.2', 311 => '19.2', 312 => '19.2', 313 => '19.3', 315 => '19.3', 318 => '20.3', 319 => '20.3', 320 => '20.2', 321 => 0x2d, 322 => 0x2d, 323 => 0x2d },
	'selftimershotinterval' => { 306 => '20.3', 308 => '20.2', 309 => '20.2', 313 => '19.2', 318 => '20.2', 319 => '20.2', 321 => 0x31, 322 => 0x31, 323 => 0x31 },
	'selftimertime' => { 101 => 0x1806, 188 => 0x1f, 305 => '18.1', 306 => '20.1', 307 => '3.3', 308 => '20.1', 309 => '20.1', 310 => '18.1', 311 => '19.1', 312 => '19.1', 313 => '19.1', 314 => '7.2', 315 => '19.1', 316 => '3.3', 318 => '20.1', 319 => '20.1', 320 => '20.1', 321 => 0x2b, 322 => 0x2b, 323 => 0x2b },
	'sellingagency' => { 533 => 'sellingAgency' },
	'semanticstyle' => { 1 => 0x40 },
	'semanticstylepreset' => { 1 => 0x42 },
	'semanticstylerenderingver' => { 1 => 0x41 },
	'seminfo' => { 123 => 0x8546 },
	'sensingmethod' => { 123 => 0xa217, 520 => 'SensingMethod' },
	'sensitivityadjust' => { 385 => 0x40 },
	'sensitivitysteps' => { 365 => ['14.3','17.4'], 367 => 0x1 },
	'sensitivitytype' => { 123 => 0x8830, 521 => 'SensitivityType' },
	'sensor' => { 195 => 0x665e },
	'sensorarea' => { 330 => 0x400 },
	'sensorareas' => { 424 => 0xa010 },
	'sensorbitdepth' => { 351 => 0x312d },
	'sensorbluelevel' => { 77 => 0x5 },
	'sensorcalibration' => { 329 => 0x805 },
	'sensorcleaning' => { 94 => 0xd },
	'sensorfullheight' => { 141 => 0xf904 },
	'sensorfullwidth' => { 141 => 0xf903 },
	'sensorheight' => { 141 => 0xf901, 146 => 0xfa21, 192 => 0x8, 351 => 0x312c, 394 => 0x109, 417 => 0x1602 },
	'sensorimageheight' => { 142 => 0x3ee },
	'sensorimagewidth' => { 142 => 0x3ed },
	'sensorleftborder' => { 142 => 0x3eb },
	'sensorleftmargin' => { 394 => 0x10a },
	'sensorpixelsize' => { 240 => 0x9a },
	'sensorredlevel' => { 77 => 0x4 },
	'sensorserialnumber' => { 142 => 0x9ce },
	'sensorshield' => { 245 => 0x76b, 246 => 0x77b, 247 => 0x66d, 248 => 0x69d, 249 => 0x705 },
	'sensorsize' => { 160 => 'SensorSize', 385 => 0x35 },
	'sensortemperature' => { 328 => 0x1500, 330 => 0x1007, 390 => 0xc, 394 => 0x210, 427 => [0x39,0x55] },
	'sensortemperature2' => { 390 => 0xe, 394 => 0x211 },
	'sensortopborder' => { 142 => 0x3ec },
	'sensortopmargin' => { 394 => 0x10b },
	'sensortype' => { 349 => 0xca },
	'sensorwidth' => { 141 => 0xf900, 146 => 0xfa20, 192 => 0xa, 351 => 0x312b, 394 => 0x108, 417 => 0x1601 },
	'sequence' => { 411 => 0x7, 412 => 0x35, 413 => 0x36 },
	'sequencefilenumber' => { 461 => 0x4, 462 => 0x4, 463 => 0x4, 464 => 0x4, 474 => 0xc, 475 => 0xc, 476 => 0x1a },
	'sequenceimagenumber' => { 461 => 0x0, 462 => 0x0, 463 => 0x0, 464 => 0x0, 474 => 0x8, 475 => 0x8, 476 => 0x12, 483 => 0x24 },
	'sequencelength' => { 474 => 0x22, 475 => 0x1e, 476 => [0x16,0x1e] },
	'sequencename' => { 532 => 'sequenceName' },
	'sequencenumber' => { 80 => 0x9, 117 => 0x301c, 131 => 0x1101, 144 => 0x1d, 285 => 0x51c, 349 => 0x2b, 439 => [0x10c,0x30c], 451 => 0xb04a, 532 => 'sequenceNumber' },
	'sequenceshotinterval' => { 426 => 0x224 },
	'sequencetotalnumber' => { 532 => 'sequenceTotalNumber' },
	'sequentialshot' => { 426 => 0x20e },
	'serialnumber' => { 67 => 0xc, 101 => 0x180b, 123 => [0xa431,0xfde9], 141 => 0xfa04, 143 => 0xfa00, 145 => 0xc354, 146 => 0xfa19, 157 => 0x0, 160 => 'SerialNumber', 195 => 0x5501, 240 => [0xa0,0x1d], 326 => 0x101, 330 => [0x404,0x101a], 344 => 0x303, 346 => 0x305, 351 => 0x3103, 385 => 0x229, 394 => 0x102, 395 => 0x407, 410 => ['SNum','slno'], 411 => 0x15, 412 => 0x4b, 413 => 0x7e, 417 => 0x5, 424 => 0xa002, 427 => 0x2, 451 => 0x2031, 511 => 'SerialNumber', 521 => 'BodySerialNumber' },
	'serialnumberformat' => { 67 => 0x15, 101 => 0x183b },
	'serialnumberhash' => { 410 => 'CAME' },
	'series' => { 528 => 'Series' },
	'seriesdatetime' => { 491 => 'SeriesDateTime' },
	'seriesdescription' => { 491 => 'SeriesDescription' },
	'seriesidentifier' => { 528 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 491 => 'SeriesModality' },
	'seriesname' => { 528 => [\'Series','SeriesName'] },
	'seriesnumber' => { 491 => 'SeriesNumber', 533 => 'seriesNumber' },
	'seriestitle' => { 533 => 'seriesTitle' },
	'serviceidentifier' => { 136 => 0x1e },
	'servingsize' => { 535 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 91 => 0x0, 92 => 0x0 },
	'setbuttonwhenshooting' => { 86 => 0x1, 88 => 0x704, 94 => 0xc },
	'setclockfromlocationdata' => { 247 => 0x61d, 248 => 0x64d, 249 => 0x6b5 },
	'setfunctionwhenshooting' => { 89 => 0x0, 90 => 0x1, 93 => 0x1 },
	'setting' => { 532 => 'setting' },
	'shadingcompensation' => { 325 => 0x50c, 349 => 0x8a },
	'shadingcompensation2' => { 329 => 0x1012 },
	'shadow' => { 427 => 0xe },
	'shadowadj' => { 107 => 0x2030b },
	'shadowcorrection' => { 385 => 0x79 },
	'shadowprotection' => { 297 => 0x0 },
	'shadows' => { 123 => 0xfe52, 451 => 0x2032, 508 => 'Shadows', 514 => 'Shadows', 516 => 'Shadows' },
	'shadows2012' => { 514 => 'Shadows2012', 516 => 'Shadows2012' },
	'shadowsadj' => { 488 => 0x901a },
	'shadowscale' => { 123 => 0xc633 },
	'shadowtint' => { 514 => 'ShadowTint', 516 => 'ShadowTint' },
	'shadowtone' => { 131 => 0x1040 },
	'shakereduction' => { 387 => 0x1, 388 => 0x1 },
	'shareduserrating' => { 183 => 'WM/SharedUserRating' },
	'sharpendetail' => { 514 => 'SharpenDetail', 516 => 'SharpenDetail' },
	'sharpenedgemasking' => { 514 => 'SharpenEdgeMasking', 516 => 'SharpenEdgeMasking' },
	'sharpening' => { 351 => 0x300b },
	'sharpeningadj' => { 301 => 0x2b },
	'sharpeningkernel' => { 142 => 0x92f },
	'sharpenradius' => { 514 => 'SharpenRadius', 516 => 'SharpenRadius' },
	'sharpness' => { 8 => [0x42,0x48], 10 => 0x72, 12 => 0x74, 36 => 0xf, 66 => 0x6, 77 => 0x2, 116 => 0xb, 117 => [0x3011,0x21], 123 => [0xa40a,0xfe56], 131 => 0x1001, 144 => 0x6b, 153 => 0x37, 160 => 'Sharpness', 185 => 0x21, 186 => 0x30, 187 => 0x26, 188 => 0x18, 193 => 0x3, 240 => 0x6, 256 => 0x32, 257 => 0x33, 258 => 0x39, 330 => 0x100f, 349 => 0x41, 385 => 0x21, 392 => 0xb, 411 => 0x26, 413 => 0x56, 416 => 0x22, 417 => [0x1003,0x1014], 427 => 0x11, 437 => 0x1c, 438 => 0x19, 451 => 0x2006, 483 => 0x52, 514 => 'Sharpness', 516 => 'Sharpness', 520 => 'Sharpness' },
	'sharpnessadj' => { 107 => 0x20310, 112 => 0x25a, 488 => 0x801a },
	'sharpnessadjon' => { 107 => '0x20310.0' },
	'sharpnessauto' => { 74 => 0x94 },
	'sharpnessfactor' => { 330 => 0x102a },
	'sharpnessfaithful' => { 19 => 0xf5, 73 => 0x64, 74 => 0x64 },
	'sharpnessfrequency' => { 8 => [0x41,0x47], 77 => 0x3 },
	'sharpnesslandscape' => { 19 => 0xf3, 73 => 0x34, 74 => 0x34 },
	'sharpnessmonochrome' => { 19 => 0xf6, 73 => 0x7c, 74 => 0x7c },
	'sharpnessneutral' => { 19 => 0xf4, 73 => 0x4c, 74 => 0x4c },
	'sharpnessovershoot' => { 488 => 0x801b },
	'sharpnessportrait' => { 19 => 0xf2, 73 => 0x1c, 74 => 0x1c },
	'sharpnessrange' => { 451 => 0x2035 },
	'sharpnesssetting' => { 325 => 0x506, 333 => 0x1013, 439 => 0x12, 456 => 0xa },
	'sharpnessstandard' => { 19 => 0xf1, 73 => 0x4, 74 => 0x4 },
	'sharpnessstrength' => { 107 => 0x20311 },
	'sharpnessthreshold' => { 488 => 0x801d },
	'sharpnessundershoot' => { 488 => 0x801c },
	'sharpnessuserdef1' => { 19 => 0xf7, 73 => 0x94, 74 => 0xac },
	'sharpnessuserdef2' => { 19 => 0xf8, 73 => 0xac, 74 => 0xc4 },
	'sharpnessuserdef3' => { 19 => 0xf9, 73 => 0xc4, 74 => 0xdc },
	'shiftcols' => { 142 => 0xc70 },
	'shootid' => { 532 => 'shootID' },
	'shootingdistance' => { 107 => 0x20701 },
	'shootinginfodisplay' => { 305 => '13.2', 306 => '5.1', 314 => '10.2', 315 => '4.1', 318 => '5.1', 320 => '5.3' },
	'shootinginfomonitorofftime' => { 305 => '26.2', 306 => '22.2', 308 => '22.2', 309 => '22.2', 313 => '21.2', 314 => '9.1', 315 => '21.2', 318 => '22.2', 319 => '22.2', 320 => '22.2', 321 => 0x37, 322 => 0x37, 323 => 0x37 },
	'shootingmode' => { 160 => 'ShootingMode', 240 => 0x89, 349 => 0x1f },
	'shootingmodesetting' => { 307 => '5.1' },
	'shortdescription' => { 518 => 'shortdescription' },
	'shortdocumentid' => { 135 => 0xba },
	'shortname' => { 514 => 'ShortName', 516 => 'ShortName' },
	'shortownername' => { 19 => 0xac },
	'shortreleasetimelag' => { 88 => 0x80d },
	'shorttitle' => { 402 => '@sti' },
	'shotdate' => { 543 => 'shotDate' },
	'shotday' => { 543 => 'shotDay' },
	'shotlocation' => { 543 => 'shotLocation' },
	'shotlogdata' => { 496 => 'shot_log_data' },
	'shotname' => { 410 => 'shot', 543 => 'shotName' },
	'shotnumber' => { 543 => 'shotNumber' },
	'shotnumbersincepowerup' => { 455 => 0x44e, 474 => 0x1a, 475 => 0x16, 476 => 0xa },
	'shotnumbersincepowerup2' => { 439 => 0x200 },
	'shotsize' => { 543 => 'shotSize' },
	'shotsperinterval' => { 229 => 0x180, 244 => 0xb4, 245 => 0xcc, 246 => 0xcc, 247 => 0xc0, 248 => 0xd0, 249 => 0xd0 },
	'showmovement' => { 402 => 'shwm' },
	'shownevent' => { 528 => 'EventExt' },
	'showneventidentifier' => { 528 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 528 => [\'EventExt','EventExtName'] },
	'shutter' => { 470 => 0x20, 471 => 0x26, 472 => 0x26 },
	'shutter-aelock' => { 86 => 0x4, 88 => 0x701, 89 => 0x3, 90 => 0x4, 91 => 0x3, 92 => 0x3, 93 => 0x4, 94 => 0x2 },
	'shutteraelbutton' => { 87 => 0x4 },
	'shutterbuttonafonbutton' => { 88 => 0x701 },
	'shuttercount' => { 11 => 0x176, 30 => [0xa95,0x293], 33 => 0xaf1, 59 => 0x1, 240 => 0xa7, 269 => [0x6a,0x157,0x24d], 270 => 0x286, 271 => 0x279, 272 => 0x284, 273 => 0x242, 274 => 0x280, 275 => 0x276, 276 => [0x27d,0x27f], 277 => 0x246, 279 => 0x2d6, 280 => 0x321, 281 => 0xbd8, 282 => 0x287, 283 => 0x320, 284 => 0x24a, 285 => 0x5fb, 286 => 0x2d5, 385 => 0x5d, 448 => 0x846, 454 => [0x125,0x14a], 470 => 0x32, 471 => 0x3a, 472 => 0x3a, 473 => 0xa },
	'shuttercount2' => { 470 => 0x4c, 471 => [0x50,0x52,0x58], 472 => 0x50 },
	'shuttercount3' => { 470 => [0x1a0,0x1aa,0x1bd], 471 => [0x19f,0x1cb,0x1cd] },
	'shuttercurtainsync' => { 86 => 0xf, 87 => 0xf, 88 => 0x305, 89 => 0xe, 90 => 0xf, 91 => 0x8, 92 => 0x8, 93 => 0xf, 94 => 0x8 },
	'shuttermode' => { 59 => 0x17, 144 => 0x1b, 240 => 0x34 },
	'shutterreleasebuttonae-l' => { 305 => '17.7', 306 => '18.4', 308 => '78.4', 309 => '78.4', 310 => '16.1', 311 => '17.1', 312 => '17.1', 313 => '17.1', 314 => '7.1', 315 => '17.5', 318 => '18.4', 319 => '78.4', 320 => '18.2', 321 => 0x29, 322 => 0x29, 323 => 0x29 },
	'shutterreleasemethod' => { 101 => 0x1010 },
	'shutterreleasenocfcard' => { 86 => 0x2, 87 => 0x2, 94 => 0xf },
	'shutterreleasetiming' => { 101 => 0x1011 },
	'shutterreleasewithoutlens' => { 88 => 0x711 },
	'shutterspeedlock' => { 306 => '38.1', 308 => '38.1', 309 => '38.1', 318 => '38.1', 319 => '38.1', 321 => 0xb7, 322 => 0xb7, 323 => 0xb7 },
	'shutterspeedrange' => { 88 => 0x10c },
	'shutterspeedsetting' => { 188 => 0x6, 437 => 0x2f, 438 => 0x28, 439 => 0x0 },
	'shutterspeedvalue' => { 97 => 0x1, 123 => 0x9201, 330 => 0x1000, 394 => 0x400, 520 => 'ShutterSpeedValue' },
	'shuttertype' => { 131 => 0x1050, 349 => 0x9f, 385 => 0x87, 476 => [0x133,0x139,0x13f] },
	'sidecarforextension' => { 531 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 142 => 0xe0d },
	'sigmascalingfactorcamera' => { 142 => 0xe0c },
	'sigmascalingfactorlowres' => { 142 => 0xe0b },
	'sigmasizetable' => { 142 => 0xe0f },
	'signaltonoiseratio' => { 1 => 0x27 },
	'signaltonoiseratiotype' => { 1 => 0x26 },
	'silentphotography' => { 240 => 0xbf },
	'similarityindex' => { 135 => 0xe4 },
	'singleframebracketing' => { 188 => 0x21 },
	'skilllevel' => { 535 => 'skillLevel' },
	'skintonecorrection' => { 385 => 0x95 },
	'skiplinetime' => { 142 => 0x184e },
	'slaveflashmeteringsegments' => { 385 => 0x20b },
	'slideshowname' => { 532 => 'slideshowName' },
	'slideshownumber' => { 532 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 532 => 'slideshowTotalNumber' },
	'slot2jpgsize' => { 245 => 0x24a, 246 => 0x24a, 249 => 0x24a },
	'slowshutter' => { 80 => 0x8 },
	'slowsync' => { 131 => 0x1030 },
	'smartalbumcolor' => { 424 => 0x20 },
	'smartrange' => { 424 => 0xa012 },
	'smileshutter' => { 439 => 0x31 },
	'smileshuttermode' => { 439 => 0x27 },
	'smoothness' => { 123 => 0xfe57, 514 => 'Smoothness', 516 => 'Smoothness' },
	'snapshot' => { 528 => 'SnapshotLink' },
	'snapshotformat' => { 528 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 528 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 528 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 528 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 528 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 509 => 'Snapshots' },
	'snapshotusedvideoframe' => { 528 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 528 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 528 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 528 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 528 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 451 => 0x200f },
	'software' => { 123 => 0x131, 161 => 'Software', 338 => 'Software', 394 => 0x203, 404 => 'software', 427 => 0x18, 499 => 'Software', 539 => 'Software' },
	'softwareversion' => { 410 => ['@swr',"\xa9swr"], 426 => 0x207 },
	'soloist' => { 402 => "\xa9sol" },
	'songwriter' => { 410 => "\xa9swf" },
	'songwriterkeywords' => { 410 => "\xa9swk" },
	'sonycropsize' => { 123 => 0x74c8 },
	'sonycroptopleft' => { 123 => 0x74c7 },
	'sonydatetime' => { 459 => 0x6, 461 => 0x1b6, 462 => 0x210, 463 => 0x1fe, 464 => 0x22c },
	'sonydatetime2' => { 470 => 0x51 },
	'sonyexposuretime' => { 470 => 0x3a, 471 => 0x46, 472 => [0x66,0x46], 473 => 0x1a },
	'sonyexposuretime2' => { 483 => 0xe },
	'sonyfnumber' => { 470 => 0x3c, 471 => 0x48, 472 => [0x68,0x48], 473 => 0x1c, 483 => 0x14 },
	'sonyimageheight' => { 459 => 0x1a, 474 => 0x44, 475 => 0x3f },
	'sonyimageheightmax' => { 483 => 0x40 },
	'sonyimagesize' => { 188 => 0x3b, 437 => 0x54, 438 => 0x54, 439 => 0x9 },
	'sonyimagewidth' => { 459 => 0x1c },
	'sonyimagewidthmax' => { 483 => 0x3e },
	'sonyiso' => { 461 => 0x1218, 462 => 0x11f4, 463 => 0x1270, 464 => [0x1254,0x1258,0x1280], 465 => 0x113c, 466 => 0x344, 467 => 0x346, 468 => 0x320, 483 => 0x4 },
	'sonymaxaperture' => { 470 => 0x0, 471 => 0x0 },
	'sonymaxaperturevalue' => { 483 => 0x16 },
	'sonyminaperture' => { 470 => 0x1, 471 => 0x1 },
	'sonymodelid' => { 451 => 0xb001 },
	'sonyquality' => { 188 => 0x3c },
	'sonyrawimagesize' => { 123 => 0x7038 },
	'sonytimeminsec' => { 471 => 0x61 },
	'sortalbum' => { 402 => 'soal' },
	'sortalbumartist' => { 402 => 'soaa' },
	'sortartist' => { 402 => 'soar' },
	'sortcomposer' => { 402 => 'soco' },
	'sortname' => { 402 => 'sonm', 514 => 'SortName', 516 => 'SortName' },
	'sortshow' => { 402 => 'sosn' },
	'soundengineer' => { 402 => "\xa9sne" },
	'source' => { 135 => 0x73, 338 => 'Source', 517 => 'source', 518 => 'source', 531 => 'Source' },
	'sourcecount' => { 503 => 'SourceCount' },
	'sourcecredits' => { 410 => "\xa9src" },
	'sourcedirectoryindex' => { 371 => 0x0 },
	'sourcefileindex' => { 371 => 0x2 },
	'sourcephotoscount' => { 502 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 142 => 0x1390 },
	'spatialfrequencyresponse' => { 520 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 520 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 520 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 520 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 520 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 543 => 'speakerPlacement' },
	'specialeffectlevel' => { 117 => 0x3030 },
	'specialeffectmode' => { 117 => 0x2076 },
	'specialeffectsetting' => { 117 => 0x3031 },
	'specialinstructions' => { 135 => 0x28 },
	'specialmode' => { 330 => 0x200, 426 => 0x200 },
	'specialoccasion' => { 535 => 'specialOccasion' },
	'specialtypeid' => { 496 => 'SpecialTypeID' },
	'spectralsensitivity' => { 123 => 0x8824, 520 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 43 => 0x32b, 44 => 0x281, 47 => [0x2b9,0x2d0,0x2d4], 48 => [0x56a,0x296], 49 => 0x1e4, 50 => [0x1fd,0x2dd], 51 => [0x231,0x30f], 52 => 0x31d },
	'speedx' => { 119 => 0x3, 410 => "\xa9xsp" },
	'speedy' => { 119 => 0x4, 410 => "\xa9ysp" },
	'speedz' => { 119 => 0x5, 410 => "\xa9zsp" },
	'spherical' => { 503 => 'Spherical' },
	'sphericalvideoxml' => { 124 => 'SphericalVideoXML' },
	'splitcolumn' => { 394 => 0x222 },
	'splittoningbalance' => { 514 => 'SplitToningBalance', 516 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 514 => 'SplitToningHighlightHue', 516 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 514 => 'SplitToningHighlightSaturation', 516 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 514 => 'SplitToningShadowHue', 516 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 514 => 'SplitToningShadowSaturation', 516 => 'SplitToningShadowSaturation' },
	'sport' => { 533 => 'sport' },
	'spotfocuspointx' => { 185 => 0x2d },
	'spotfocuspointy' => { 185 => 0x2e },
	'spotmeteringmode' => { 36 => 0x27 },
	'spotmeterlinktoafpoint' => { 88 => 0x107 },
	'sractive' => { 365 => '17.1' },
	'srawquality' => { 36 => 0x2e },
	'srfocallength' => { 387 => 0x3 },
	'srgbrendering' => { 336 => 'sRGB' },
	'srhalfpresstime' => { 387 => 0x2 },
	'srresult' => { 387 => 0x0, 388 => 0x0 },
	'stackedimage' => { 325 => 0x804 },
	'standardmatrixcustom' => { 142 => 0x7d4 },
	'standardmatrixdaylight' => { 142 => 0x7d0 },
	'standardmatrixflash' => { 142 => 0x7d3 },
	'standardmatrixfluorescent' => { 142 => 0x7d2 },
	'standardmatrixtungsten' => { 142 => 0x7d1 },
	'standardoutputhighlightpoint' => { 113 => 0x14 },
	'standardoutputsensitivity' => { 123 => 0x8831, 521 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 113 => 0x15 },
	'standardrawcolortone' => { 113 => 0xd },
	'standardrawcontrast' => { 113 => 0xf },
	'standardrawhighlight' => { 113 => 0x75 },
	'standardrawhighlightpoint' => { 113 => 0x12 },
	'standardrawlinear' => { 113 => 0x10 },
	'standardrawsaturation' => { 113 => 0xe },
	'standardrawshadow' => { 113 => 0x7e },
	'standardrawshadowpoint' => { 113 => 0x13 },
	'standardrawsharpness' => { 113 => 0x11 },
	'standardunsharpmaskfineness' => { 113 => 0x94 },
	'standardunsharpmaskstrength' => { 113 => 0x92 },
	'standardunsharpmaskthreshold' => { 113 => 0x96 },
	'standardwhitecustom' => { 142 => 0x838 },
	'standardwhitedaylight' => { 142 => 0x834 },
	'standardwhiteflash' => { 142 => 0x837 },
	'standardwhitefluorescent' => { 142 => 0x836 },
	'standardwhitetungsten' => { 142 => 0x835 },
	'standbytimer' => { 306 => '19.1', 308 => '19.1', 309 => '19.1', 312 => '18.1', 313 => '18.1', 318 => '19.1', 319 => '19.1' },
	'starlightview' => { 321 => 0x249, 322 => 0x249, 323 => 0x261 },
	'startingpage' => { 533 => 'startingPage' },
	'startmovieshooting' => { 88 => 0x70d },
	'starttimecode' => { 410 => "\xa9TIM", 543 => 'startTimecode' },
	'starttimecodetimeformat' => { 543 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 543 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 543 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 410 => "\xa9TSZ", 543 => 'startTimeSampleSize' },
	'starttimescale' => { 410 => "\xa9TSC", 543 => 'startTimeScale' },
	'state' => { 165 => 'State', 349 => 0x6b, 531 => 'State' },
	'status' => { 494 => 'Status', 507 => 'Status' },
	'stereomode' => { 503 => 'StereoMode' },
	'stitched' => { 503 => 'Stitched' },
	'stitchingsoftware' => { 502 => 'StitchingSoftware', 503 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 460 => 0x113e, 461 => 0x113e, 462 => 0x111a, 463 => 0x1196, 464 => 0x1172, 465 => 0x102a, 466 => 0x222, 467 => 0x222, 468 => 0x217, 483 => 0xa },
	'storagemethod' => { 192 => 0x12 },
	'storebyorientation' => { 306 => '46.3', 308 => '47.3', 309 => '47.3', 318 => '47.3', 319 => '47.3', 321 => 0xd, 322 => 0xd, 323 => 0xd },
	'storedescription' => { 402 => 'sdes' },
	'storylineidentifier' => { 528 => 'StorylineIdentifier' },
	'straightenangle' => { 298 => 0x2fc08431 },
	'streamready' => { 528 => 'StreamReady' },
	'streamtype' => { 180 => 'StreamType' },
	'stretchmode' => { 543 => 'stretchMode' },
	'studydatetime' => { 491 => 'StudyDateTime' },
	'studydescription' => { 491 => 'StudyDescription' },
	'studyid' => { 491 => 'StudyID' },
	'studyphysician' => { 491 => 'StudyPhysician' },
	'styleperiod' => { 528 => 'StylePeriod' },
	'sub-location' => { 135 => 0x5c },
	'subcommanddialframeadvancezoom' => { 249 => 0x806 },
	'subcommanddialplaybackmode' => { 321 => 0x1cf, 322 => 0x1cf, 323 => 0x1e7 },
	'subcommanddialvideoplaybackmode' => { 321 => 0x1d1, 323 => 0x1e9 },
	'subfiledata' => { 168 => 'data' },
	'subfiledirectory' => { 168 => '1Directory' },
	'subfilemimetype' => { 168 => '2MIME' },
	'subfilename' => { 168 => '1Name' },
	'subfileresource' => { 168 => 'rsrc' },
	'subfiletype' => { 123 => 0xfe, 168 => '0Type' },
	'subject' => { 334 => 'Subject', 401 => 'Subject', 517 => 'subject', 530 => 'Subject', 544 => 'subject' },
	'subjectarea' => { 123 => 0x9214, 520 => 'SubjectArea' },
	'subjectcode' => { 527 => 'SubjectCode' },
	'subjectdetection' => { 245 => 0x252, 246 => 0x252, 247 => 0x23e, 248 => 0x252, 249 => 0x252 },
	'subjectdistance' => { 123 => 0x9206, 144 => 0x3e, 520 => 'SubjectDistance' },
	'subjectdistancerange' => { 123 => 0xa40c, 520 => 'SubjectDistanceRange' },
	'subjectlocation' => { 123 => 0xa214, 520 => 'SubjectLocation' },
	'subjectmotion' => { 308 => '78.2', 309 => '78.2', 319 => '78.2', 321 => 0x103, 322 => 0x103, 323 => 0x119 },
	'subjectprogram' => { 185 => 0x22 },
	'subjectreference' => { 135 => 0xc },
	'subjecttodetect' => { 2 => 0x14 },
	'sublabels1' => { 526 => [\'TagStructure','TagStructureSubLabels'] },
	'sublabels2' => { 526 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublabels3' => { 526 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'sublabels4' => { 526 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 526 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 118 => 'Exif-SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 118 => 'Exif-SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 118 => 'Exif-SubSecModifyDate' },
	'subsectime' => { 123 => 0x9290 },
	'subsectimedigitized' => { 123 => 0x9292 },
	'subsectimeoriginal' => { 123 => 0x9291 },
	'subsection1' => { 533 => 'subsection1' },
	'subsection2' => { 533 => 'subsection2' },
	'subsection3' => { 533 => 'subsection3' },
	'subsection4' => { 533 => 'subsection4' },
	'subselector' => { 306 => '49.1', 308 => '71.1', 309 => '71.1', 319 => '71.1', 321 => 0x8f, 322 => 0x8f, 323 => 0x8f },
	'subselectorassignment' => { 306 => '48.1' },
	'subselectorcenter' => { 308 => '72.1', 309 => '72.1', 319 => '72.1' },
	'subselectorplusdials' => { 306 => '49.2', 308 => '73.1', 309 => '73.1', 319 => '73.1' },
	'subtitle' => { 183 => 'WM/SubTitle', 402 => "\xa9st3", 410 => "\xa9snm", 533 => 'subtitle' },
	'subtitlekeywords' => { 410 => "\xa9snk" },
	'subversionfilename' => { 526 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 526 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 526 => 'SubVersions' },
	'superimposeddisplay' => { 86 => 0xa, 88 => 0x510, 89 => 0x9, 90 => 0xa, 93 => 0xa, 94 => 0xe },
	'supermacro' => { 67 => 0x1a },
	'supplementalcategories' => { 135 => 0x14, 531 => 'SupplementalCategories' },
	'supplementaltype' => { 137 => 0x37 },
	'supplementdisplayid' => { 533 => 'supplementDisplayID' },
	'supplementstartingpage' => { 533 => 'supplementStartingPage' },
	'supplementtitle' => { 533 => 'supplementTitle' },
	'supplychainsource' => { 528 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 528 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 528 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'supportsamount' => { 514 => 'SupportsAmount', 516 => 'SupportsAmount' },
	'supportscolor' => { 514 => 'SupportsColor', 516 => 'SupportsColor' },
	'supportshighdynamicrange' => { 514 => 'SupportsHighDynamicRange', 516 => 'SupportsHighDynamicRange' },
	'supportsmonochrome' => { 514 => 'SupportsMonochrome', 516 => 'SupportsMonochrome' },
	'supportsnormaldynamicrange' => { 514 => 'SupportsNormalDynamicRange', 516 => 'SupportsNormalDynamicRange' },
	'supportsoutputreferred' => { 514 => 'SupportsOutputReferred', 516 => 'SupportsOutputReferred' },
	'supportsscenereferred' => { 514 => 'SupportsSceneReferred', 516 => 'SupportsSceneReferred' },
	'svisosetting' => { 365 => 0x14 },
	'swatchcoloranta' => { 548 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 548 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 548 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 548 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 548 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 548 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 548 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 548 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 548 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 548 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 548 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 548 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 548 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 548 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 548 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 548 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 548 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 548 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 548 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 349 => 0x93, 439 => 0x33 },
	'sweeppanoramafieldofview' => { 349 => 0x94 },
	'sweeppanoramasize' => { 439 => 0x32 },
	'switchtoregisteredafpoint' => { 87 => 0x12, 88 => 0x50a },
	'symlink' => { 124 => 'SymLink' },
	'syncreleasemode' => { 308 => '77.1', 309 => '77.1', 319 => '77.1', 321 => 0x41, 322 => 0x41, 323 => 0x41 },
	'system' => { 394 => 0x204 },
	'tagged' => { 396 => 0xdd, 397 => 'Tagged', 509 => 'tagged' },
	'tagslist' => { 519 => 'TagsList' },
	'tagstructure' => { 526 => 'TagStructure' },
	'takenumber' => { 543 => 'takeNumber' },
	'tapename' => { 543 => 'tapeName' },
	'targetaperture' => { 80 => 0x4 },
	'targetaspectratio' => { 339 => 'TargetAspectRatio' },
	'targetcompressionratio' => { 99 => 0x1 },
	'targetdistancesetting' => { 101 => 0x1807 },
	'targetexposuretime' => { 80 => 0x5 },
	'targetimagetype' => { 101 => 0x100a },
	'targetprinter' => { 123 => 0x151 },
	'taxon' => { 122 => 'Taxon' },
	'taxonacceptednameusage' => { 122 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 122 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 122 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 122 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxoncultivarepithet' => { 122 => [\'Taxon','TaxonCultivarEpithet'] },
	'taxonfamily' => { 122 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 122 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 122 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 122 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 122 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 122 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 122 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 122 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 122 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 122 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 122 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 122 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 122 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 122 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 122 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 122 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 122 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 122 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 122 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 122 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 122 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 122 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 122 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 122 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 122 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 122 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 122 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 122 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 122 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 142 => 0x196f },
	'tda1edgepolarity' => { 142 => 0x1971 },
	'tda1gain' => { 142 => 0x1970 },
	'tda1offset' => { 142 => 0x196e },
	'tda2bandwidth' => { 142 => 0x1979 },
	'tda2edgepolarity' => { 142 => 0x197b },
	'tda2gain' => { 142 => 0x197a },
	'tda2offset' => { 142 => 0x1978 },
	'tda3bandwidth' => { 142 => 0x1983 },
	'tda3edgepolarity' => { 142 => 0x1985 },
	'tda3gain' => { 142 => 0x1984 },
	'tda3offset' => { 142 => 0x1982 },
	'tda4bandwidth' => { 142 => 0x198d },
	'tda4edgepolarity' => { 142 => 0x198f },
	'tda4gain' => { 142 => 0x198e },
	'tda4offset' => { 142 => 0x198c },
	'teaser' => { 533 => 'teaser' },
	'teleconverter' => { 190 => 0x105, 451 => 0x105 },
	'tempampgainx100' => { 142 => 0x1914 },
	'tempo' => { 543 => 'tempo' },
	'temporalcoverage' => { 528 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 528 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 528 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 335 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 335 => 'TermsAndConditionsURL' },
	'testname' => { 124 => 'TestName' },
	'textencoding' => { 239 => 0x4 },
	'textlayername' => { 531 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 531 => 'TextLayers' },
	'textlayertext' => { 531 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 349 => [0x8008,0x8009,0x3b,0x3e] },
	'texture' => { 514 => 'Texture', 516 => 'Texture' },
	'three-dtrackingfacedetection' => { 308 => '1.4', 309 => '1.4', 319 => '1.4' },
	'three-dtrackingwatcharea' => { 308 => '78.1', 309 => '78.1', 319 => '78.1' },
	'thresholding' => { 123 => 0x107 },
	'thumbnailfilename' => { 101 => 0x817 },
	'thumbnailformat' => { 541 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 146 => 0xfa55, 541 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 6 => 'CNDA', 101 => 0x2008, 118 => 'Exif-ThumbnailImage', 126 => 0x3, 171 => 'data', 330 => 0x100, 402 => 'tnal', 410 => 'thmb', 541 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 171 => '1Name' },
	'thumbnailimagesize' => { 171 => 'ImageSize' },
	'thumbnailimagetype' => { 171 => '0Type' },
	'thumbnailimagevalidarea' => { 67 => 0x13 },
	'thumbnaillength' => { 123 => 0x202 },
	'thumbnailoffset' => { 123 => 0x201 },
	'thumbnailpng' => { 410 => 'thmb' },
	'thumbnails' => { 541 => 'Thumbnails' },
	'thumbnailwidth' => { 146 => 0xfa54, 541 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 533 => 'ticker' },
	'tiffhandling' => { 514 => 'TIFFHandling', 516 => 'TIFFHandling' },
	'tiffmeteringimage' => { 191 => 0x104c, 448 => 0x1110 },
	'tilelength' => { 123 => 0x143 },
	'tilewidth' => { 123 => 0x142 },
	'time' => { 142 => 0x401, 385 => 0x7 },
	'timecodes' => { 123 => 0xc763 },
	'timecreated' => { 135 => 0x3c, 144 => 0x14, 153 => 0x10, 397 => 'TimeCreated' },
	'timelapseshotnumber' => { 352 => 0x10 },
	'timeperiod' => { 533 => 'timePeriod' },
	'timerfunctionbutton' => { 307 => '5.2', 310 => '12.1', 311 => '13.1' },
	'timerlength' => { 88 => 0x80c },
	'timerrecording' => { 349 => 0x96 },
	'timescaleparams' => { 543 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 543 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 543 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 543 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 136 => 0x50 },
	'timeshot' => { 504 => 'TimeShot' },
	'timesignature' => { 543 => 'timeSignature' },
	'timesincepoweron' => { 349 => 0x29 },
	'timestamp' => { 11 => 0x45e, 19 => 0x11c, 324 => 0x8, 338 => 'TimeStamp', 349 => 0xaf, 503 => 'Timestamp', 510 => 'Timestamp', 526 => 'TimeStamp' },
	'timestamp1' => { 11 => 0x45a },
	'timezone' => { 81 => 0x1, 245 => 0x694, 246 => 0x6a4, 247 => 0x594, 248 => 0x5c4, 249 => 0x5dc, 290 => 0x0, 420 => 0xa },
	'timezonecity' => { 81 => 0x2 },
	'timezonecode' => { 104 => 0x1 },
	'timezoneinfo' => { 104 => 0x2 },
	'timezoneoffset' => { 123 => 0x882a },
	'tint' => { 404 => 'player.movie.visual.tint', 514 => 'Tint', 516 => 'Tint' },
	'title' => { 123 => 0xa436, 161 => 'Title', 334 => 'Title', 338 => 'Title', 349 => 0x65, 401 => 'Title', 402 => ['titl',"\xa9nam"], 404 => 'title', 410 => ['titl',"\xa9nam"], 517 => 'title', 530 => 'Title', 541 => 'Title' },
	'togglestyleamount' => { 514 => 'ToggleStyleAmount', 516 => 'ToggleStyleAmount' },
	'togglestyledigest' => { 514 => 'ToggleStyleDigest', 516 => 'ToggleStyleDigest' },
	'tonecomp' => { 240 => 0x81 },
	'tonecurve' => { 77 => 0x1, 385 => 0x402, 514 => 'ToneCurve', 516 => 'ToneCurve' },
	'tonecurveactive' => { 112 => 0x110 },
	'tonecurveadobergb' => { 424 => 0xa043 },
	'tonecurveadobergbdefault' => { 424 => 0xa041 },
	'tonecurveblue' => { 514 => 'ToneCurveBlue', 516 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 488 => 0x9003 },
	'tonecurvebluey' => { 488 => 0x9007 },
	'tonecurvebrightness' => { 107 => 0x20410 },
	'tonecurvebrightnessx' => { 488 => 0x9000 },
	'tonecurvebrightnessy' => { 488 => 0x9004 },
	'tonecurvecolorspace' => { 111 => 0x0 },
	'tonecurvecontrast' => { 107 => 0x20411 },
	'tonecurvegreen' => { 514 => 'ToneCurveGreen', 516 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 488 => 0x9002 },
	'tonecurvegreeny' => { 488 => 0x9006 },
	'tonecurveinputrange' => { 111 => 0x3 },
	'tonecurveinterpolation' => { 112 => 0x159 },
	'tonecurvemode' => { 112 => 0x113 },
	'tonecurvename' => { 514 => 'ToneCurveName', 516 => 'ToneCurveName' },
	'tonecurvename2012' => { 514 => 'ToneCurveName2012', 516 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 107 => '0x20400.1' },
	'tonecurveoutputrange' => { 111 => 0x5 },
	'tonecurveprofilename' => { 142 => 0x1391 },
	'tonecurveproperty' => { 112 => 0x3c },
	'tonecurvepv2012' => { 514 => 'ToneCurvePV2012', 516 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 514 => 'ToneCurvePV2012Blue', 516 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 514 => 'ToneCurvePV2012Green', 516 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 514 => 'ToneCurvePV2012Red', 516 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 514 => 'ToneCurveRed', 516 => 'ToneCurveRed' },
	'tonecurveredx' => { 488 => 0x9001 },
	'tonecurveredy' => { 488 => 0x9005 },
	'tonecurves' => { 385 => 0x403 },
	'tonecurveshape' => { 111 => 0x1 },
	'tonecurvesrgb' => { 424 => 0xa042 },
	'tonecurvesrgbdefault' => { 424 => 0xa040 },
	'tonecurvex' => { 111 => 0xa },
	'tonecurvey' => { 111 => 0xb },
	'tonelevel' => { 325 => 0x52e },
	'tonemap' => { 245 => 0x26a, 246 => 0x26a },
	'tonemapstrength' => { 514 => 'ToneMapStrength', 516 => 'ToneMapStrength' },
	'toningeffect' => { 59 => 0xf, 240 => 0xb3, 256 => 0x38, 257 => 0x40, 258 => 0x48, 417 => 0x1015 },
	'toningeffectauto' => { 74 => 0xa4 },
	'toningeffectfaithful' => { 73 => 0x74, 74 => 0x74 },
	'toningeffectlandscape' => { 73 => 0x44, 74 => 0x44 },
	'toningeffectmonochrome' => { 19 => 0x108, 73 => 0x8c, 74 => 0x8c },
	'toningeffectneutral' => { 73 => 0x5c, 74 => 0x5c },
	'toningeffectportrait' => { 73 => 0x2c, 74 => 0x2c },
	'toningeffectstandard' => { 73 => 0x14, 74 => 0x14 },
	'toningeffectuserdef1' => { 73 => 0xa4, 74 => 0xbc },
	'toningeffectuserdef2' => { 73 => 0xbc, 74 => 0xd4 },
	'toningeffectuserdef3' => { 73 => 0xd4, 74 => 0xec },
	'toningsaturation' => { 256 => 0x39, 257 => 0x41, 258 => 0x49 },
	'totalzoom' => { 144 => 0x62 },
	'touchae' => { 349 => 0xab },
	'track' => { 402 => "\xa9trk", 410 => "\xa9trk" },
	'trackcreatedate' => { 409 => 0x1 },
	'trackmodifydate' => { 409 => 0x2 },
	'tracknumber' => { 402 => 'trkn', 543 => 'trackNumber' },
	'tracks' => { 543 => 'Tracks' },
	'tracksframerate' => { 543 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 543 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 543 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 543 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 543 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 543 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 543 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 543 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 543 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 543 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 543 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 543 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 543 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 543 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 543 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 543 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 543 => [\'Tracks','TracksTrackType'] },
	'tracktype' => { 410 => 'kgtt' },
	'trailer' => { 124 => 'Trailer' },
	'trailersignature' => { 168 => 'zmie' },
	'transcript' => { 528 => 'Transcript' },
	'transcriptlink' => { 528 => 'TranscriptLink' },
	'transcriptlinklink' => { 528 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 528 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 123 => 0x12d, 539 => 'TransferFunction' },
	'transfertimenormal' => { 142 => 0x1888 },
	'transfertimetest' => { 142 => 0x1889 },
	'transform' => { 349 => [0x8012,0x59] },
	'transformation' => { 529 => 'Transformation' },
	'transmissionreference' => { 531 => 'TransmissionReference' },
	'trapped' => { 334 => 'Trapped', 530 => 'Trapped' },
	'trashbuttonfunction' => { 88 => 0x710 },
	'travelday' => { 349 => 0x36 },
	'treble' => { 404 => 'player.movie.audio.treble' },
	'triggermode' => { 411 => 0x6, 412 => 0x34, 413 => 0x34 },
	'tstop' => { 123 => 0xc772 },
	'ttl_da_adown' => { 372 => 0x5 },
	'ttl_da_aup' => { 372 => 0x4 },
	'ttl_da_bdown' => { 372 => 0x7 },
	'ttl_da_bup' => { 372 => 0x6 },
	'tungstenawb' => { 362 => 0x1 },
	'tvepisode' => { 402 => 'tves' },
	'tvepisodeid' => { 402 => 'tven' },
	'tvexposuretimesetting' => { 365 => 0x12 },
	'tvnetworkname' => { 402 => 'tvnn' },
	'tvseason' => { 402 => 'tvsn' },
	'tvshow' => { 402 => 'tvsh' },
	'type' => { 498 => 'Type', 517 => 'type', 538 => 'type' },
	'typestatus' => { 122 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 123 => 0xc614 },
	'uniquedocumentid' => { 135 => 0xbb },
	'uniquematrixauto' => { 142 => 0x7e9 },
	'uniquematrixcustom' => { 142 => 0x7e8 },
	'uniquematrixdaylight' => { 142 => 0x7e4 },
	'uniquematrixflash' => { 142 => 0x7e7 },
	'uniquematrixfluorescent' => { 142 => 0x7e6 },
	'uniquematrixtungsten' => { 142 => 0x7e5 },
	'uniqueobjectname' => { 136 => 0x64 },
	'units' => { 499 => 'Units' },
	'unknown_aacr' => { 402 => 'AACR' },
	'unknown_cdek' => { 402 => 'CDEK' },
	'unknown_cdet' => { 402 => 'CDET' },
	'unknownblock' => { 385 => 0x405 },
	'unknownblock1' => { 329 => 0x635 },
	'unknownblock2' => { 329 => 0x636 },
	'unknownblock3' => { 329 => 0x1103 },
	'unknownblock4' => { 329 => 0x1104 },
	'unknowncontrast' => { 113 => 0x45 },
	'unknowndate' => { 394 => 0x212 },
	'unknownev' => { 142 => 0x1 },
	'unknownlinear' => { 113 => 0x46 },
	'unknownnumber' => { 101 => 0x180b },
	'unknownoutputhighlightpoint' => { 113 => 0x4a },
	'unknownoutputshadowpoint' => { 113 => 0x4b },
	'unknownrawhighlight' => { 113 => 0x7b },
	'unknownrawhighlightpoint' => { 113 => 0x48 },
	'unknownrawshadow' => { 113 => 0x84 },
	'unknownrawshadowpoint' => { 113 => 0x49 },
	'unknownsharpness' => { 113 => 0x47 },
	'unknowntags' => { 410 => 'TAGS' },
	'unknowntemperature' => { 125 => 0x4 },
	'unknownthumbnail' => { 410 => 'thmb' },
	'unsharp1color' => { 303 => 0x13 },
	'unsharp1halowidth' => { 303 => 0x19 },
	'unsharp1intensity' => { 303 => 0x17 },
	'unsharp1threshold' => { 303 => 0x1b },
	'unsharp2color' => { 303 => 0x2e },
	'unsharp2halowidth' => { 303 => 0x34 },
	'unsharp2intensity' => { 303 => 0x32 },
	'unsharp2threshold' => { 303 => 0x36 },
	'unsharp3color' => { 303 => 0x49 },
	'unsharp3halowidth' => { 303 => 0x4f },
	'unsharp3intensity' => { 303 => 0x4d },
	'unsharp3threshold' => { 303 => 0x51 },
	'unsharp4color' => { 303 => 0x64 },
	'unsharp4halowidth' => { 303 => 0x6a },
	'unsharp4intensity' => { 303 => 0x68 },
	'unsharp4threshold' => { 303 => 0x6c },
	'unsharpcount' => { 303 => 0x0 },
	'unsharpmask' => { 113 => 0x90, 298 => 0x76a43200 },
	'unsharpmaskfineness' => { 77 => 0xe, 107 => 0x20309 },
	'unsharpmaskstrength' => { 107 => 0x20308 },
	'unsharpmaskthreshold' => { 77 => 0xf, 107 => 0x2030a },
	'uprightcentermode' => { 514 => 'UprightCenterMode', 516 => 'UprightCenterMode' },
	'uprightcenternormx' => { 514 => 'UprightCenterNormX', 516 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 514 => 'UprightCenterNormY', 516 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 514 => 'UprightDependentDigest', 516 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 514 => 'UprightFocalLength35mm', 516 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 514 => 'UprightFocalMode', 516 => 'UprightFocalMode' },
	'uprightfoursegments_0' => { 514 => 'UprightFourSegments_0', 516 => 'UprightFourSegments_0' },
	'uprightfoursegments_1' => { 514 => 'UprightFourSegments_1', 516 => 'UprightFourSegments_1' },
	'uprightfoursegments_2' => { 514 => 'UprightFourSegments_2', 516 => 'UprightFourSegments_2' },
	'uprightfoursegments_3' => { 514 => 'UprightFourSegments_3', 516 => 'UprightFourSegments_3' },
	'uprightfoursegmentscount' => { 514 => 'UprightFourSegmentsCount', 516 => 'UprightFourSegmentsCount' },
	'uprightguideddependentdigest' => { 514 => 'UprightGuidedDependentDigest', 516 => 'UprightGuidedDependentDigest' },
	'uprightpreview' => { 514 => 'UprightPreview', 516 => 'UprightPreview' },
	'uprighttransform_0' => { 514 => 'UprightTransform_0', 516 => 'UprightTransform_0' },
	'uprighttransform_1' => { 514 => 'UprightTransform_1', 516 => 'UprightTransform_1' },
	'uprighttransform_2' => { 514 => 'UprightTransform_2', 516 => 'UprightTransform_2' },
	'uprighttransform_3' => { 514 => 'UprightTransform_3', 516 => 'UprightTransform_3' },
	'uprighttransform_4' => { 514 => 'UprightTransform_4', 516 => 'UprightTransform_4' },
	'uprighttransform_5' => { 514 => 'UprightTransform_5', 516 => 'UprightTransform_5' },
	'uprighttransformcount' => { 514 => 'UprightTransformCount', 516 => 'UprightTransformCount' },
	'uprightversion' => { 514 => 'UprightVersion', 516 => 'UprightVersion' },
	'urgency' => { 135 => 0xa, 531 => 'Urgency' },
	'url' => { 161 => 'URL', 338 => 'URL', 399 => 0x40b, 533 => 'url' },
	'url_list' => { 399 => 0x41e },
	'urla-platform' => { 533 => [\'url','urlA-platform'] },
	'urlurl' => { 533 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 88 => 0x10a },
	'usableshootingmodes' => { 88 => 0x109 },
	'usage' => { 534 => 'usage' },
	'usageterms' => { 547 => 'UsageTerms' },
	'usbpowerdelivery' => { 245 => 0x762, 246 => 0x772, 247 => 0x664, 248 => 0x694, 249 => 0x6fc },
	'usedialwithouthold' => { 321 => 0xbf, 322 => 0xbf, 323 => 0xbf },
	'useguidelines' => { 512 => 'useGuidelines' },
	'usepanoramaviewer' => { 502 => 'UsePanoramaViewer' },
	'usercollection' => { 404 => 'collection.user' },
	'usercomment' => { 101 => 0x805, 123 => 0x9286, 520 => 'UserComment' },
	'userdef1picturestyle' => { 19 => 0x10c, 73 => 0xd8, 74 => 0xf0 },
	'userdef2picturestyle' => { 19 => 0x10e, 73 => 0xda, 74 => 0xf2 },
	'userdef3picturestyle' => { 19 => 0x110, 73 => 0xdc, 74 => 0xf4 },
	'userfields' => { 507 => 'UserFields' },
	'userlabel' => { 411 => 0x2b, 412 => 0x5a, 413 => 0x68 },
	'userprofile' => { 344 => 0x302, 348 => 0x34c, 351 => 0x3038 },
	'userrating' => { 404 => 'rating.user', 410 => 'urat' },
	'usmlenselectronicmf' => { 2 => 0x7, 87 => 0x7, 88 => 0x501 },
	'uspsnumber' => { 533 => 'uspsNumber' },
	'utmeasting' => { 172 => 'Easting' },
	'utmmapdatum' => { 172 => 'Datum' },
	'utmnorthing' => { 172 => 'Northing' },
	'utmzone' => { 172 => 'Zone' },
	'uuid' => { 514 => 'UUID', 516 => 'UUID' },
	'uv-irfiltercorrection' => { 344 => 0x325 },
	'validbits' => { 329 => 0x611, 330 => 0x102c },
	'validcropcorners' => { 339 => 'ValidCropCorners' },
	'validpixeldepth' => { 333 => 0x611 },
	'variablelowpassfilter' => { 451 => 0x2028 },
	'variousmodes' => { 144 => 0x26 },
	'variousmodes2' => { 144 => 0x3a },
	'variprogram' => { 240 => 0xab },
	'varraydacnominalvalues' => { 142 => 0x191e },
	'vendor' => { 410 => 'vndr' },
	'vendorinfo' => { 492 => 'VendorInfo' },
	'vendorinfomanufacturer' => { 492 => [\'VendorInfo','VendorInfoManufacturer'] },
	'vendorinfomodel' => { 492 => [\'VendorInfo','VendorInfoModel'] },
	'vendorinfonotes' => { 492 => [\'VendorInfo','VendorInfoNotes'] },
	'verbatimidentification' => { 122 => [\'Identification','IdentificationVerbatimIdentification'] },
	'version' => { 131 => 0x0, 339 => 'Version', 401 => 'Version', 404 => 'version', 514 => 'Version', 516 => 'Version', 525 => 'Version' },
	'versioncreatedate' => { 488 => 0xd100 },
	'versionid' => { 544 => 'VersionID' },
	'versionidentifier' => { 533 => 'versionIdentifier' },
	'versionmodifydate' => { 488 => 0xd101 },
	'versions' => { 544 => 'Versions' },
	'versionscomments' => { 544 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 544 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 544 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 544 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 544 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 544 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 544 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 544 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 544 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 544 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 544 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 305 => '3.2', 306 => '47.2', 308 => '79.1', 322 => 0x11d, 323 => 0x135 },
	'verticalclockoverlaps' => { 142 => 0x412 },
	'verticalfuncbutton' => { 306 => '42.2', 308 => '67.1', 322 => 0x115, 323 => 0x12d },
	'verticalfuncbuttonplaybackmode' => { 322 => 0x1b7, 323 => 0x1cf },
	'verticalfuncbuttonplusdials' => { 306 => '43.1' },
	'verticalfuncplusdials' => { 308 => '68.1' },
	'verticalisobutton' => { 249 => 0x792 },
	'verticalmovieafonbutton' => { 322 => 0x1f9, 323 => 0x211 },
	'verticalmoviefuncbutton' => { 322 => 0x1e1, 323 => 0x1f9 },
	'verticalmultiselector' => { 306 => '42.1', 308 => '66.1', 309 => '66.1', 319 => '66.1', 322 => 0x18f, 323 => 0x1a7 },
	'verticalmultiselectorplaybackmode' => { 322 => 0x125, 323 => 0x13d },
	'vfdisplayillumination' => { 2 => 0x11, 88 => [0x510,0x51d] },
	'vibrance' => { 508 => 'Vibrance', 514 => 'Vibrance', 516 => 'Vibrance' },
	'vibrationreduction' => { 269 => [0x75,0x82,0x1ae], 277 => '586.1', 284 => '590.2', 288 => 0x4 },
	'videoalphamode' => { 543 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 543 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 543 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 543 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 543 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 543 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 543 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 543 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 543 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 543 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 543 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 543 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 543 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 543 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 543 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 543 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 543 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 543 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 528 => 'videoBitRate' },
	'videobitratemode' => { 528 => 'videoBitRateMode' },
	'videoburstmode' => { 349 => 0xbb },
	'videoburstresolution' => { 349 => 0xb3 },
	'videocodec' => { 70 => 0x74 },
	'videocolorspace' => { 543 => 'videoColorSpace' },
	'videocompression' => { 131 => 0x3806 },
	'videocompressor' => { 543 => 'videoCompressor' },
	'videodisplayaspectratio' => { 528 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 528 => 'videoEncodingProfile' },
	'videofieldorder' => { 543 => 'videoFieldOrder' },
	'videoframerate' => { 349 => 0x27, 543 => 'videoFrameRate' },
	'videoframesize' => { 543 => 'videoFrameSize' },
	'videoframesizeh' => { 543 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 543 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 543 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 543 => 'videoModDate' },
	'videopixelaspectratio' => { 543 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 543 => 'videoPixelDepth' },
	'videopreburst' => { 349 => 0xc1 },
	'videoquality' => { 117 => 0x4003 },
	'videorecordingmode' => { 131 => 0x3803 },
	'videoshottype' => { 528 => 'VideoShotType' },
	'videoshottypeidentifier' => { 528 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 528 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 528 => 'videoStreamsCount' },
	'viewfinder' => { 394 => 0x455 },
	'viewfinderdisplay' => { 305 => '12.4', 306 => '6.3' },
	'viewfinderwarning' => { 305 => '13.4', 315 => '3.5', 316 => '6.2', 320 => '4.4' },
	'viewfinderwarnings' => { 88 => 0x40a },
	'viewinfoduringexposure' => { 88 => 0x407 },
	'viewingmode' => { 439 => 0x2f, 456 => 0x18 },
	'viewingmode2' => { 439 => [0x85,0x285] },
	'viewmodeshoweffectsofsettings' => { 249 => 0x7d2, 321 => 0x2a9 },
	'viewpoint' => { 532 => 'viewpoint' },
	'vignetteamount' => { 514 => 'VignetteAmount', 516 => 'VignetteAmount' },
	'vignettecoefficient1' => { 289 => 0x24 },
	'vignettecoefficient2' => { 289 => 0x34 },
	'vignettecoefficient3' => { 289 => 0x44 },
	'vignettecontrol' => { 240 => 0x2a, 298 => 0x76a43205 },
	'vignettecontrolintensity' => { 298 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 511 => 'VignetteCorrectionAlreadyApplied' },
	'vignettecorrectionversion' => { 289 => 0x0 },
	'vignettemidpoint' => { 514 => 'VignetteMidpoint', 516 => 'VignetteMidpoint' },
	'vignetting' => { 417 => 0x1011, 424 => 0xa052 },
	'vignettingcorrection' => { 123 => 0x7031, 424 => 0xa053, 451 => 0x2011 },
	'vignettingcorrparams' => { 123 => 0x7032, 482 => 0x64a, 483 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 424 => 0xa054 },
	'virtualfocallength' => { 529 => 'VirtualFocalLength' },
	'virtualhorizonstyle' => { 321 => 0x167, 322 => 0x167, 323 => 0x17f },
	'virtualimagexcenter' => { 529 => 'VirtualImageXCenter' },
	'virtualimageycenter' => { 529 => 'VirtualImageYCenter' },
	'visualcolor' => { 528 => 'VisualColour' },
	'visualtechnique' => { 532 => 'visualTechnique' },
	'voicememo' => { 426 => 0x216 },
	'volume' => { 533 => 'volume' },
	'vr_0x66' => { 269 => 0x66 },
	'vrdoffset' => { 67 => 0xd0 },
	'vrmode' => { 245 => 0x226, 246 => 0x226, 247 => 0x212, 248 => 0x226, 249 => 0x226, 288 => 0x6 },
	'vrtype' => { 288 => 0x8 },
	'waterdepth' => { 123 => 0x9403, 521 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 191 => 0x19a },
	'wb_bluelevel6500k' => { 191 => 0x18a },
	'wb_bluelevelcustom' => { 191 => 0x18e },
	'wb_bluelevelscloudy' => { 191 => 0x106 },
	'wb_bluelevelsdaylight' => { 191 => 0xea },
	'wb_bluelevelsflash' => { 191 => 0x122 },
	'wb_bluelevelsfluorescent' => { 191 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 191 => 0x254 },
	'wb_bluelevelsshade' => { 191 => 0x176 },
	'wb_bluelevelstungsten' => { 191 => 0xce },
	'wb_gbrglevels' => { 191 => 0xae, 194 => 0x4 },
	'wb_glevel' => { 329 => 0x11f },
	'wb_glevel3000k' => { 329 => 0x113 },
	'wb_glevel3300k' => { 329 => 0x114 },
	'wb_glevel3600k' => { 329 => 0x115 },
	'wb_glevel3900k' => { 329 => 0x116 },
	'wb_glevel4000k' => { 329 => 0x117 },
	'wb_glevel4300k' => { 329 => 0x118 },
	'wb_glevel4500k' => { 329 => 0x119 },
	'wb_glevel4800k' => { 329 => 0x11a },
	'wb_glevel5300k' => { 329 => 0x11b },
	'wb_glevel6000k' => { 329 => 0x11c },
	'wb_glevel6600k' => { 329 => 0x11d },
	'wb_glevel7500k' => { 329 => 0x11e },
	'wb_grbglevels' => { 208 => 0x0, 458 => 0x7303 },
	'wb_grbglevelsauto' => { 84 => 0x2, 458 => 0x7302 },
	'wb_grbglevelscloudy' => { 84 => 0x12 },
	'wb_grbglevelscustom1' => { 84 => 0x42 },
	'wb_grbglevelscustom2' => { 84 => 0x4a },
	'wb_grbglevelsdaylight' => { 84 => 0xa },
	'wb_grbglevelsflash' => { 84 => 0x32 },
	'wb_grbglevelsfluorescent' => { 84 => 0x22 },
	'wb_grbglevelsfluorhigh' => { 84 => 0x2a },
	'wb_grbglevelstungsten' => { 84 => 0x1a },
	'wb_grbglevelsunderwater' => { 84 => 0x3a },
	'wb_rbgglevels' => { 205 => 0x0 },
	'wb_rblevels' => { 209 => 0x270, 240 => 0xc, 329 => 0x100 },
	'wb_rblevels1' => { 355 => 0x2 },
	'wb_rblevels2' => { 355 => 0x5 },
	'wb_rblevels3' => { 355 => 0x8 },
	'wb_rblevels3000k' => { 329 => 0x102 },
	'wb_rblevels3300k' => { 329 => 0x103 },
	'wb_rblevels3500k' => { 191 => 0x430 },
	'wb_rblevels3600k' => { 329 => 0x104 },
	'wb_rblevels3900k' => { 329 => 0x105 },
	'wb_rblevels4' => { 355 => 0xb },
	'wb_rblevels4000k' => { 329 => 0x106 },
	'wb_rblevels4300k' => { 329 => 0x107 },
	'wb_rblevels4500k' => { 329 => 0x108 },
	'wb_rblevels4800k' => { 329 => 0x109 },
	'wb_rblevels5' => { 355 => 0xe },
	'wb_rblevels5300k' => { 329 => 0x10a },
	'wb_rblevels6' => { 355 => 0x11 },
	'wb_rblevels6000k' => { 329 => 0x10b },
	'wb_rblevels6500k' => { 191 => 0x420 },
	'wb_rblevels6600k' => { 329 => 0x10c },
	'wb_rblevels7' => { 355 => 0x14 },
	'wb_rblevels7500k' => { 329 => 0x10d },
	'wb_rblevelsauto' => { 209 => 0x272, 333 => 0x110 },
	'wb_rblevelscloudy' => { 191 => 0x3f0, 193 => 0x10, 209 => 0x296, 333 => 0x121 },
	'wb_rblevelscoolwhitef' => { 191 => 0x308, 193 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 333 => 0x132 },
	'wb_rblevelscustom' => { 191 => 0x424, 193 => 0x1c },
	'wb_rblevelscwb1' => { 329 => 0x10e },
	'wb_rblevelscwb2' => { 329 => 0x10f },
	'wb_rblevelscwb3' => { 329 => 0x110 },
	'wb_rblevelscwb4' => { 329 => 0x111 },
	'wb_rblevelsdaylight' => { 191 => [0x3ec,0x528], 193 => 0xc, 209 => 0x274 },
	'wb_rblevelsdaylightf' => { 193 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 333 => 0x130 },
	'wb_rblevelsdaywhitef' => { 193 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 333 => 0x131 },
	'wb_rblevelseveningsunlight' => { 333 => 0x124 },
	'wb_rblevelsfineweather' => { 333 => 0x122 },
	'wb_rblevelsflash' => { 191 => [0x3f4,0x304], 193 => 0x18, 209 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 209 => 0x290 },
	'wb_rblevelsincandescent' => { 209 => 0x282 },
	'wb_rblevelsshade' => { 191 => 0x418, 193 => 0x20, 209 => 0x2b2, 333 => 0x120 },
	'wb_rblevelstungsten' => { 191 => 0x3e8, 193 => 0x8, 333 => 0x123 },
	'wb_rblevelsused' => { 333 => 0x100 },
	'wb_rblevelswhitef' => { 193 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 333 => 0x133 },
	'wb_redlevel3500k' => { 191 => 0x198 },
	'wb_redlevel6500k' => { 191 => 0x188 },
	'wb_redlevelcustom' => { 191 => 0x18c },
	'wb_redlevelscloudy' => { 191 => 0xf8 },
	'wb_redlevelsdaylight' => { 191 => 0xdc },
	'wb_redlevelsflash' => { 191 => 0x114 },
	'wb_redlevelsfluorescent' => { 191 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 191 => 0x1be },
	'wb_redlevelsshade' => { 191 => 0x168 },
	'wb_redlevelstungsten' => { 191 => 0xc0 },
	'wb_rgbglevels' => { 207 => 0x0 },
	'wb_rgblevels' => { 191 => [0x546,0x96], 345 => 0xd, 346 => 0x413, 351 => 0x3036, 394 => 0x107, 460 => 0x117c, 461 => 0x1180, 462 => 0x115c, 463 => 0x11d8, 464 => 0x11b4, 465 => 0x106c, 466 => 0x264, 467 => 0x264, 468 => 0x252 },
	'wb_rgblevels1' => { 356 => 0x2 },
	'wb_rgblevels2' => { 356 => 0x6 },
	'wb_rgblevels2500k' => { 458 => 0x782d },
	'wb_rgblevels3' => { 356 => 0xa },
	'wb_rgblevels3200k' => { 458 => 0x782c },
	'wb_rgblevels4' => { 356 => 0xe },
	'wb_rgblevels4500k' => { 458 => [0x7484,0x7824] },
	'wb_rgblevels5' => { 356 => 0x12 },
	'wb_rgblevels6' => { 356 => 0x16 },
	'wb_rgblevels6000k' => { 458 => 0x782b },
	'wb_rgblevels7' => { 356 => 0x1a },
	'wb_rgblevels8500k' => { 458 => 0x782a },
	'wb_rgblevelsauto' => { 428 => 0x0 },
	'wb_rgblevelscloudy' => { 458 => [0x7481,0x7821] },
	'wb_rgblevelscustom1' => { 428 => 0x15 },
	'wb_rgblevelscustom2' => { 428 => 0x18 },
	'wb_rgblevelscustom3' => { 428 => 0x1b },
	'wb_rgblevelsdaylight' => { 428 => 0x3, 458 => [0x7480,0x7820] },
	'wb_rgblevelsflash' => { 428 => 0x12, 458 => [0x7483,0x7823] },
	'wb_rgblevelsfluorescent' => { 428 => 0xf, 458 => [0x7486,0x7826] },
	'wb_rgblevelsfluorescentm1' => { 458 => 0x7829 },
	'wb_rgblevelsfluorescentp1' => { 458 => 0x7827 },
	'wb_rgblevelsfluorescentp2' => { 458 => 0x7828 },
	'wb_rgblevelsincandescent' => { 428 => 0xc },
	'wb_rgblevelsovercast' => { 428 => 0x9 },
	'wb_rgblevelsshade' => { 428 => 0x6, 458 => 0x7825 },
	'wb_rgblevelstungsten' => { 458 => [0x7482,0x7822] },
	'wb_rgblevelsunknown0' => { 429 => 0x0 },
	'wb_rgblevelsunknown1' => { 429 => 0x3 },
	'wb_rgblevelsunknown2' => { 429 => 0x6 },
	'wb_rgblevelsunknown3' => { 429 => 0x9 },
	'wb_rgblevelsunknown4' => { 429 => 0xc },
	'wb_rgblevelsunknown5' => { 429 => 0xf },
	'wb_rgblevelsunknown6' => { 429 => 0x12 },
	'wb_rgblevelsunknown7' => { 429 => 0x15 },
	'wb_rgblevelsunknown8' => { 429 => 0x18 },
	'wb_rgblevelsunknown9' => { 429 => 0x1b },
	'wb_rgbmuldaylight' => { 142 => 0x852 },
	'wb_rgbmulflash' => { 142 => 0x855 },
	'wb_rgbmulfluorescent' => { 142 => 0x854 },
	'wb_rgbmultungsten' => { 142 => 0x853 },
	'wb_rggbblacklevels' => { 37 => 0x25 },
	'wb_rggblevels' => { 123 => 0x7313, 194 => 0x4, 206 => 0x0, 210 => 0x13e8, 211 => 0x38, 458 => 0x7313 },
	'wb_rggblevelsasshot' => { 40 => 0x0, 41 => 0x0, 42 => 0x19, 43 => 0x55, 44 => 0x69, 45 => 0x22, 46 => 0x3f, 49 => 0x3f, 50 => 0x3f, 51 => 0x3f, 52 => 0x47 },
	'wb_rggblevelsauto' => { 37 => 0x1, 40 => 0x5, 41 => 0x8, 42 => 0x1e, 43 => 0x5a, 44 => 0x6e, 45 => 0x18, 46 => 0x44, 49 => 0x44, 50 => 0x44, 51 => 0x44, 52 => 0x4c, 210 => 0x1478, 211 => 0x114, 424 => 0xa022, 458 => 0x7312 },
	'wb_rggblevelsblack' => { 424 => 0xa028 },
	'wb_rggblevelscloudy' => { 37 => 0xd, 40 => 0x1e, 41 => 0x30, 42 => 0x2d, 43 => 0xa0, 44 => 0xd7, 45 => 0x31, 46 => 0x58, 49 => 0x71, 50 => 0x8a, 51 => 0x8f, 52 => 0x92, 210 => 0x1408, 211 => 0x60, 385 => 0x20f, 393 => 0x14 },
	'wb_rggblevelscustom' => { 37 => 0x1d, 46 => 0x80, 210 => 0x1468, 211 => 0x100 },
	'wb_rggblevelscustom1' => { 42 => 0x41 },
	'wb_rggblevelscustom2' => { 42 => 0x46 },
	'wb_rggblevelsdaylight' => { 37 => 0x5, 40 => 0x14, 41 => 0x20, 42 => 0x23, 43 => 0x96, 44 => 0xcd, 45 => 0x27, 46 => 0x4e, 49 => 0x67, 50 => 0x80, 51 => 0x85, 52 => 0x88, 210 => 0x13f8, 211 => 0x4c, 385 => 0x20d, 393 => 0x2 },
	'wb_rggblevelsflash' => { 37 => 0x19, 40 => 0x32, 41 => 0x50, 42 => 0x3c, 43 => 0xb4, 44 => 0xeb, 45 => 0x45, 46 => 0x6c, 49 => 0x85, 50 => 0x9e, 51 => 0xa3, 52 => 0xa6, 210 => 0x1448, 385 => 0x214, 393 => 0x41 },
	'wb_rggblevelsfluorescent' => { 37 => 0x15, 40 => 0x28, 41 => 0x40, 42 => 0x37, 43 => 0xaa, 44 => 0xe1, 45 => 0x3b, 46 => 0x62, 49 => 0x7b, 50 => 0x94, 51 => 0x99, 52 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 211 => 0xc4, 385 => 0x211, 393 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 393 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 211 => 0xb0, 385 => 0x212, 393 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 210 => 0x1438, 211 => 0x9c, 385 => 0x213, 393 => 0x38 },
	'wb_rggblevelshtmercury' => { 211 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 424 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 424 => 0xa024 },
	'wb_rggblevelskelvin' => { 37 => 0x21, 40 => 0x2d, 41 => 0x48, 43 => 0xaf, 44 => 0xe6, 45 => 0x40, 46 => 0x67, 49 => 0x80, 50 => 0x99, 51 => 0x9e, 52 => 0xa1 },
	'wb_rggblevelsmeasured' => { 40 => 0xa, 41 => 0x10, 43 => 0x5f, 44 => 0x73, 46 => 0x49, 49 => 0x49, 50 => 0x49, 51 => 0x49, 52 => 0x51 },
	'wb_rggblevelspc1' => { 45 => 0x90, 46 => 0x71 },
	'wb_rggblevelspc2' => { 45 => 0x95, 46 => 0x76 },
	'wb_rggblevelspc3' => { 45 => 0x9a, 46 => 0x7b },
	'wb_rggblevelsshade' => { 37 => 0x9, 40 => 0x19, 41 => 0x28, 42 => 0x28, 43 => 0x9b, 44 => 0xd2, 45 => 0x2c, 46 => 0x53, 49 => 0x6c, 50 => 0x85, 51 => 0x8a, 52 => 0x8d, 211 => 0x74, 385 => 0x20e, 393 => 0xb },
	'wb_rggblevelstungsten' => { 37 => 0x11, 40 => 0x23, 41 => 0x38, 42 => 0x32, 43 => 0xa5, 44 => 0xdc, 45 => 0x36, 46 => 0x5d, 49 => 0x76, 50 => 0x8f, 51 => 0x94, 52 => 0x97, 210 => 0x1428, 211 => 0x88, 385 => 0x210, 393 => 0x1d },
	'wb_rggblevelsuncorrected' => { 424 => 0xa021 },
	'wb_rggblevelsunknown' => { 40 => 0xf, 41 => 0x18, 43 => 0x64, 44 => 0x78, 45 => 0x1d, 49 => 0x4e, 50 => 0x4e, 51 => 0x4e, 52 => 0x56, 393 => 0x53 },
	'wb_rggblevelsunknown10' => { 40 => 0x5f, 41 => 0x98, 43 => 0x91, 44 => 0xa5, 45 => 0x72, 49 => 0x9e, 50 => 0x7b, 51 => 0x7b, 52 => 0x83 },
	'wb_rggblevelsunknown11' => { 40 => 0x64, 41 => 0xa0, 43 => 0xb9, 44 => [0xaa,0xaf], 45 => 0x77, 49 => 0xa3, 50 => 0xa3, 51 => 0x80, 52 => 0xab },
	'wb_rggblevelsunknown12' => { 40 => 0x69, 41 => 0xa8, 43 => 0xbe, 44 => 0xb4, 45 => 0x7c, 49 => 0xa8, 50 => 0xa8, 51 => 0xa8, 52 => 0xb0 },
	'wb_rggblevelsunknown13' => { 40 => 0x6e, 41 => 0xb0, 43 => 0xc3, 44 => 0xb9, 45 => 0x81, 49 => 0xad, 50 => 0xad, 51 => 0xad, 52 => 0xb5 },
	'wb_rggblevelsunknown14' => { 43 => 0xc8, 44 => 0xbe, 45 => 0x86, 49 => 0xb2, 50 => 0xb2, 51 => 0xb2, 52 => 0xba },
	'wb_rggblevelsunknown15' => { 43 => 0xcd, 44 => 0xc3, 45 => 0x8b, 49 => 0xb7, 50 => 0xb7, 51 => 0xb7, 52 => 0xbf },
	'wb_rggblevelsunknown16' => { 43 => 0xd2, 44 => 0xc8, 45 => 0x9f, 50 => 0xbc, 51 => 0xbc, 52 => 0xc4 },
	'wb_rggblevelsunknown17' => { 43 => 0xd7, 44 => 0xf0, 50 => 0xc1, 51 => 0xc1, 52 => 0xc9 },
	'wb_rggblevelsunknown18' => { 43 => 0xdc, 44 => 0xf5, 50 => 0xc6, 51 => 0xc6, 52 => 0xce },
	'wb_rggblevelsunknown19' => { 43 => 0xe1, 44 => 0xfa, 50 => 0xcb, 51 => 0xcb, 52 => 0xd3 },
	'wb_rggblevelsunknown2' => { 40 => 0x37, 41 => 0x58, 43 => 0x69, 44 => 0x7d, 45 => 0x4a, 49 => 0x53, 50 => 0x53, 51 => 0x53, 52 => 0x5b },
	'wb_rggblevelsunknown20' => { 43 => 0xe6, 44 => 0xff, 50 => 0xd0, 51 => 0xd0, 52 => 0xd8 },
	'wb_rggblevelsunknown21' => { 43 => 0xeb, 44 => 0x104, 51 => 0xd5, 52 => 0xdd },
	'wb_rggblevelsunknown22' => { 43 => 0xf0, 44 => 0x109, 51 => 0xda, 52 => 0xe2 },
	'wb_rggblevelsunknown23' => { 43 => 0xf5, 44 => 0x10e, 51 => 0xdf, 52 => 0xe7 },
	'wb_rggblevelsunknown24' => { 43 => 0xfa, 44 => 0x113, 51 => 0xe4, 52 => 0xec },
	'wb_rggblevelsunknown25' => { 43 => 0xff, 44 => 0x118, 51 => 0xe9, 52 => 0xf1 },
	'wb_rggblevelsunknown26' => { 43 => 0x104, 44 => 0x11d, 51 => 0xee, 52 => 0xf6 },
	'wb_rggblevelsunknown27' => { 43 => 0x109, 44 => 0x122, 51 => 0xf3, 52 => 0xfb },
	'wb_rggblevelsunknown28' => { 43 => 0x10e, 51 => 0xf8, 52 => 0x100 },
	'wb_rggblevelsunknown29' => { 43 => 0x113, 51 => 0xfd, 52 => 0x105 },
	'wb_rggblevelsunknown3' => { 40 => 0x3c, 41 => 0x60, 43 => 0x6e, 44 => 0x82, 45 => 0x4f, 49 => 0x58, 50 => 0x58, 51 => 0x58, 52 => 0x60 },
	'wb_rggblevelsunknown30' => { 51 => 0x102 },
	'wb_rggblevelsunknown4' => { 40 => 0x41, 41 => 0x68, 43 => 0x73, 44 => 0x87, 45 => 0x54, 49 => 0x5d, 50 => 0x5d, 51 => 0x5d, 52 => 0x65 },
	'wb_rggblevelsunknown5' => { 40 => 0x46, 41 => 0x70, 43 => 0x78, 44 => 0x8c, 45 => 0x59, 49 => 0x62, 50 => 0x62, 51 => 0x62, 52 => 0x6a },
	'wb_rggblevelsunknown6' => { 40 => 0x4b, 41 => 0x78, 43 => 0x7d, 44 => 0x91, 45 => 0x5e, 49 => 0x8a, 50 => 0x67, 51 => 0x67, 52 => 0x6f },
	'wb_rggblevelsunknown7' => { 40 => 0x50, 41 => 0x80, 43 => 0x82, 44 => 0x96, 45 => 0x63, 49 => 0x8f, 50 => 0x6c, 51 => 0x6c, 52 => 0x74 },
	'wb_rggblevelsunknown8' => { 40 => 0x55, 41 => 0x88, 43 => 0x87, 44 => 0x9b, 45 => 0x68, 49 => 0x94, 50 => 0x71, 51 => 0x71, 52 => 0x79 },
	'wb_rggblevelsunknown9' => { 40 => 0x5a, 41 => 0x90, 43 => 0x8c, 44 => 0xa0, 45 => 0x6d, 49 => 0x99, 50 => 0x76, 51 => 0x76, 52 => 0x7e },
	'wb_rggblevelsuserselected' => { 393 => 0x5c },
	'wbadjblueamber' => { 107 => 0x20106 },
	'wbadjbluebalance' => { 304 => 0x8 },
	'wbadjcolortemp' => { 107 => 0x20102, 112 => 0x1a },
	'wbadjlighting' => { 304 => 0x14 },
	'wbadjmagentagreen' => { 107 => 0x20105 },
	'wbadjmode' => { 304 => 0x10 },
	'wbadjredbalance' => { 304 => 0x0 },
	'wbadjrggblevels' => { 107 => 0x20125, 112 => 0x6 },
	'wbadjtemperature' => { 304 => 0x18 },
	'wbadjtint' => { 304 => 0x25 },
	'wbbluelevel' => { 344 => 0x324, 349 => 0x8006, 354 => 0x26 },
	'wbbracketingsteps' => { 202 => 0x10, 203 => 0x10, 278 => 0x174d },
	'wbbracketmode' => { 59 => 0x9 },
	'wbbracketshotnumber' => { 191 => 0x2b, 417 => 0x101a },
	'wbbracketvalueab' => { 59 => 0xc },
	'wbbracketvaluegm' => { 59 => 0xd },
	'wbbutton' => { 246 => 0x806, 249 => 0x80a },
	'wbbuttonplaybackmode' => { 321 => 0x1c5 },
	'wbfinetuneactive' => { 112 => 0x24 },
	'wbfinetunesaturation' => { 112 => 0x28 },
	'wbfinetunetone' => { 112 => 0x2c },
	'wbgreenlevel' => { 344 => 0x323, 349 => 0x8005, 354 => 0x25 },
	'wbmediaimagesizesetting' => { 88 => 0x708 },
	'wbmode' => { 193 => 0x4, 330 => 0x1015 },
	'wbredlevel' => { 344 => 0x322, 349 => 0x8004, 354 => 0x24 },
	'wbscale' => { 194 => 0x0 },
	'wbshiftab' => { 77 => 0xc, 349 => 0x46, 366 => 0x10 },
	'wbshiftab_gm' => { 451 => 0x2014 },
	'wbshiftab_gm_precise' => { 451 => 0x2026 },
	'wbshiftcreativecontrol' => { 349 => 0x92 },
	'wbshiftgm' => { 77 => 0xd, 349 => 0x47, 366 => 0x11 },
	'wbshiftintelligentauto' => { 349 => 0x8b },
	'wbtype1' => { 355 => 0x1, 356 => 0x1 },
	'wbtype2' => { 355 => 0x4, 356 => 0x5 },
	'wbtype3' => { 355 => 0x7, 356 => 0x9 },
	'wbtype4' => { 355 => 0xa, 356 => 0xd },
	'wbtype5' => { 355 => 0xd, 356 => 0x11 },
	'wbtype6' => { 355 => 0x10, 356 => 0x15 },
	'wbtype7' => { 355 => 0x13, 356 => 0x19 },
	'webstatement' => { 547 => 'WebStatement' },
	'weightedflatsubject' => { 506 => 'weightedFlatSubject' },
	'what' => { 514 => 'What', 516 => 'What' },
	'whitebalance' => { 7 => 0x6f, 8 => [0x44,0x4a], 9 => 0xbc, 10 => 0x36, 11 => 0x5e, 12 => 0x36, 13 => 0x78, 14 => 0x6f, 15 => 0x6f, 16 => 0x73, 17 => 0x6f, 18 => 0x78, 19 => 0x54, 20 => 0x6f, 21 => 0xbc, 22 => 0x7b, 24 => 0xbc, 25 => 0xc2, 27 => 0x131, 28 => 0x77, 77 => 0x8, 80 => 0x7, 116 => 0x7, 117 => [0x19,0x2012], 123 => [0xa403,0xfe4e], 131 => 0x1002, 142 => 0x3fc, 143 => 0xfa0d, 144 => 0x40, 155 => 0x1a, 185 => 0x3, 186 => 0xe, 187 => 0x4, 188 => 0xb, 190 => 0x115, 240 => 0x5, 287 => 0x7, 344 => 0x304, 349 => 0x3, 351 => 0x3033, 385 => 0x19, 392 => 0x7, 416 => 0x26, 417 => 0x1003, 427 => [0x88,0x3c,0x7,0x58], 437 => 0xf, 438 => 0xe, 451 => [0x115,0xb054], 514 => 'WhiteBalance', 516 => 'WhiteBalance', 520 => 'WhiteBalance' },
	'whitebalance0' => { 180 => 'WhiteBalance0' },
	'whitebalance1' => { 180 => 'WhiteBalance1' },
	'whitebalance2' => { 180 => 'WhiteBalance2', 325 => 0x500 },
	'whitebalanceadj' => { 107 => 0x20101, 112 => 0x18, 298 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 362 => 0x0 },
	'whitebalancebias' => { 117 => 0x2011, 330 => 0x304, 349 => 0x23 },
	'whitebalanceblue' => { 77 => 0x7 },
	'whitebalancebracket' => { 325 => 0x502, 330 => 0x303 },
	'whitebalancebracketing' => { 188 => 0x22, 191 => 0x2c, 448 => 0x2c },
	'whitebalancebuttonplaybackmode' => { 322 => 0x1c5, 323 => 0x1dd },
	'whitebalancecomp' => { 333 => 0x1001 },
	'whitebalancedetected' => { 142 => 0x3fb },
	'whitebalancefinetune' => { 131 => 0x100a, 188 => 0x38, 190 => 0x112, 240 => [0xb,0x3f], 417 => 0x1004, 437 => 0x6, 438 => 0x5, 451 => 0x112 },
	'whitebalancemode' => { 142 => 0x3fa, 385 => 0x1a },
	'whitebalancered' => { 77 => 0x6 },
	'whitebalanceset' => { 365 => 0xa },
	'whitebalancesetting' => { 188 => 0x23, 437 => 0x5, 438 => 0x4, 439 => 0x16, 456 => 0xd },
	'whitebalancesetup' => { 424 => 0x41 },
	'whitebalancetemperature' => { 325 => 0x501 },
	'whiteboard' => { 330 => 0x301 },
	'whitelevel' => { 123 => 0xc61d, 385 => 0x7e, 458 => 0x787f },
	'whitepoint' => { 123 => 0x13e, 348 => 0x35d, 385 => 0x201, 539 => 'WhitePoint' },
	'whites2012' => { 514 => 'Whites2012', 516 => 'Whites2012' },
	'whitesadj' => { 488 => 0x9017 },
	'wideadapter' => { 417 => 0x1017 },
	'widefocuszone' => { 185 => 0x2f },
	'widerange' => { 426 => 0x20f },
	'windmode' => { 142 => 0x3f4 },
	'windnoisereduction' => { 245 => 0x352, 246 => 0x352, 247 => 0x2d6, 248 => 0x2fe, 249 => 0x2fe },
	'windowlocation' => { 410 => 'WLOC' },
	'windowsatom' => { 515 => 'windowsAtom' },
	'windowsatomextension' => { 515 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 515 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 515 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 533 => 'wordCount' },
	'work' => { 402 => "\xa9wrk" },
	'workcolorspace' => { 107 => 0x10200, 112 => 0x270 },
	'workflowtag' => { 528 => 'WorkflowTag' },
	'workflowtagcvid' => { 528 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 528 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 528 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 528 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 522 => 'WorkToDo' },
	'worldtimelocation' => { 349 => 0x3a, 385 => 0x22, 391 => '0.1' },
	'writer' => { 183 => 'WM/Writer' },
	'writer-editor' => { 135 => 0x7a },
	'x3filllight' => { 427 => 0x12 },
	'xattrmditemwherefroms' => { 178 => 'com.apple.metadata:kMDItemWhereFroms' },
	'xattrquarantine' => { 178 => 'com.apple.quarantine' },
	'xiaomimodel' => { 123 => 0x9a00 },
	'xiaomisettings' => { 123 => 0x9999 },
	'xilinxversion' => { 142 => 0x414 },
	'xml' => { 140 => 'xml ' },
	'xmp' => { 110 => 0xffff00f6, 124 => 'XMP' },
	'xmptoolkit' => { 540 => 'xmptk' },
	'xpauthor' => { 123 => 0x9c9d },
	'xpcomment' => { 123 => 0x9c9c },
	'xpkeywords' => { 123 => 0x9c9e },
	'xposition' => { 123 => 0x11e },
	'xpsubject' => { 123 => 0x9c9f },
	'xptitle' => { 123 => 0x9c9b },
	'xresolution' => { 123 => 0x11a, 138 => 0x3, 400 => 0x0, 539 => 'XResolution' },
	'xyresolution' => { 127 => 0x3 },
	'yaw' => { 119 => 0x7, 410 => ['_yaw',"\xa9fyw"] },
	'yawangle' => { 254 => 0x8, 422 => 0x0 },
	'ycbcrcoefficients' => { 123 => 0x211, 539 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 123 => 0x213, 539 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 123 => 0x212, 539 => 'YCbCrSubSampling' },
	'year' => { 402 => 'yrrc', 404 => 'year', 410 => 'yrrc' },
	'yearcreated' => { 144 => 0x10, 153 => 0xc },
	'yellowhsl' => { 107 => 0x20912 },
	'yield' => { 535 => 'yield' },
	'yposition' => { 123 => 0x11f },
	'yresolution' => { 123 => 0x11b, 138 => 0x5, 400 => 0x4, 539 => 'YResolution' },
	'zebrapatterntonerange' => { 321 => 0x211, 322 => 0x211, 323 => 0x229 },
	'zoneidentifier' => { 124 => 'ZoneIdentifier' },
	'zonematching' => { 190 => 0x10a, 193 => [0x3a,0x4a], 451 => 0xb024 },
	'zonematchingmode' => { 188 => 0x14 },
	'zonematchingon' => { 187 => 0x75 },
	'zonematchingvalue' => { 437 => 0x1f },
	'zoomedpreviewlength' => { 330 => 0xf05 },
	'zoomedpreviewsize' => { 330 => 0xf06 },
	'zoomedpreviewstart' => { 330 => 0xf04 },
	'zoomsourcewidth' => { 36 => 0x24 },
	'zoomstepcount' => { 328 => 0x300, 330 => 0x100d },
	'zoomtargetwidth' => { 36 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_misb' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accel360fly' => 1,
	'acceldata' => 1,
	'accelerometermatrix' => 1,
	'accelerometertime' => 1,
	'accelerometerunknown' => 1,
	'accelmode' => 1,
	'accelypr' => 1,
	'accessdate' => 1,
	'accessrights' => 1,
	'accompaniment' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acdsee-rs' => 1,
	'acidizer' => 1,
	'acidizerflags' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actors' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'additionalinfo' => 1,
	'adjdebuginfo' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aedebuginfo' => 1,
	'aeflags' => 1,
	'aehistograminfo' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'aeliveviewhistograminfo' => 1,
	'aeliveviewlocalhistogram' => 1,
	'aelocalhistogram' => 1,
	'af' => 1,
	'af-cprioritysel' => 1,
	'af-sprioritysel' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'afdebuginfo' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airfieldbarometricpressure' => 1,
	'airfieldelevation' => 1,
	'airspeed' => 1,
	'airtemperature' => 1,
	'airulerunits' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartistsortorder' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitlesortorder' => 1,
	'alerts' => 1,
	'alexa' => 1,
	'alexa-paireddevicename' => 1,
	'alexa-pairing' => 1,
	'alexa-privacymode' => 1,
	'alexa-wakewordlanguage' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternatealtitude' => 1,
	'alternateduotonecolors' => 1,
	'alternateellipsoidheight' => 1,
	'alternateellipsoidheightextended' => 1,
	'alternateheading' => 1,
	'alternatelatitude' => 1,
	'alternatelongitude' => 1,
	'alternatename' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'altitudefromtakeoff' => 1,
	'ambienceinfo' => 1,
	'ambisonicchannelmap' => 1,
	'ambisonicchannelordering' => 1,
	'ambisonicchannels' => 1,
	'ambisonicnormalization' => 1,
	'ambisonicorder' => 1,
	'ambisonictype' => 1,
	'amendlocalset' => 1,
	'angleaxis' => 1,
	'angleofattack' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'appledataoffsets' => 1,
	'applemaildatereceived' => 1,
	'applemaildatesent' => 1,
	'applemailflagged' => 1,
	'applemailisremoteattachment' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'application' => 1,
	'application_riff' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationunknown' => 1,
	'applicationversion' => 1,
	'applysettingstoliveview' => 1,
	'appname' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'arcoreaccel' => 1,
	'arcorecustom' => 1,
	'arcoregyro' => 1,
	'arcorevideo' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artists' => 1,
	'artisturl' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantdirector' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'associateddatalist' => 1,
	'associatedimagefile' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'ast' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atob3' => 1,
	'atom0' => 1,
	'atsccontent' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attr' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiolevel' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoridentifier' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorname' => 1,
	'authors' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'autoareaafstartingpoint' => 1,
	'autocaptureoffset' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'automationanimation' => 1,
	'automationflags' => 1,
	'autopoweroff' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimageref' => 1,
	'auxiliaryimagetype' => 1,
	'av1configuration' => 1,
	'av1configurationversion' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averageframerate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbdebuginfo' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'axml' => 1,
	'b1' => 1,
	'b2' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barcodes' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'basename' => 1,
	'baseviewpointnum' => 1,
	'basicfileinfo' => 1,
	'basisobject' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats' => 1,
	'beats-per-minute' => 1,
	'beautycolorlevel' => 1,
	'beautyretouchlevel' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bibliographicreferences' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binarydata' => 1,
	'binarydatatype' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'binning' => 1,
	'birthday' => 1,
	'bitdepthchroma' => 1,
	'bitdepthluma' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetoothmacaddress' => 1,
	'bluetoothname' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'blurstrength' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'body' => 1,
	'bokehshape' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bpm' => 1,
	'bps' => 1,
	'bracketingburstoptions' => 1,
	'bracketingcounter' => 1,
	'bracketingmode' => 1,
	'bracketingoffset' => 1,
	'bracketingstep' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'brdfatob0' => 1,
	'brdfatob1' => 1,
	'brdfatob2' => 1,
	'brdfatob3' => 1,
	'brdfbtoa0' => 1,
	'brdfbtoa1' => 1,
	'brdfbtoa2' => 1,
	'brdfbtoa3' => 1,
	'brdfbtod0' => 1,
	'brdfbtod1' => 1,
	'brdfbtod2' => 1,
	'brdfbtod3' => 1,
	'brdfcolorimetricparam0' => 1,
	'brdfcolorimetricparam1' => 1,
	'brdfcolorimetricparam2' => 1,
	'brdfcolorimetricparam3' => 1,
	'brdfdtob0' => 1,
	'brdfdtob1' => 1,
	'brdfdtob2' => 1,
	'brdfdtob3' => 1,
	'brdfmtob0' => 1,
	'brdfmtob1' => 1,
	'brdfmtob2' => 1,
	'brdfmtob3' => 1,
	'brdfmtos0' => 1,
	'brdfmtos1' => 1,
	'brdfmtos2' => 1,
	'brdfmtos3' => 1,
	'brdfspectralparam0' => 1,
	'brdfspectralparam1' => 1,
	'brdfspectralparam2' => 1,
	'brdfspectralparam3' => 1,
	'breakchar' => 1,
	'briefdescription' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'brotliexif' => 1,
	'brotlijumb' => 1,
	'brotlixmp' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btoa3' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwf_umid' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'byteordermark' => 1,
	'bytes' => 1,
	'bytesperline' => 1,
	'bytesperminute' => 1,
	'c2pasalthash' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'callsign' => 1,
	'camcore' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapan' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'cameratilt' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfog5xii' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfor6' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'car' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'catalognumber' => 1,
	'caveats' => 1,
	'cbor' => 1,
	'cbordata' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel01' => 1,
	'channel01description' => 1,
	'channel01dispmax' => 1,
	'channel01dispmin' => 1,
	'channel01flags' => 1,
	'channel01id' => 1,
	'channel01interval' => 1,
	'channel01max' => 1,
	'channel01min' => 1,
	'channel01multiplier' => 1,
	'channel01name' => 1,
	'channel01num' => 1,
	'channel01offset' => 1,
	'channel01type' => 1,
	'channel01units' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'character' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'checksum' => 1,
	'children' => 1,
	'chmversion' => 1,
	'choregrapher' => 1,
	'chromaformat' => 1,
	'chromasampleposition' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chrominancetable' => 1,
	'chunkcount' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'churchillnav' => 1,
	'cicodepoints' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classificationandmarkingsystem' => 1,
	'classificationcomments' => 1,
	'classificationreason' => 1,
	'classifiedby' => 1,
	'classifyingcountry' => 1,
	'classifyingcountrycodemethod' => 1,
	'classifyingcountrycodingmethoddate' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmddialsaperturesetting' => 1,
	'cmddialschangemainsub' => 1,
	'cmddialschangemainsubexposure' => 1,
	'cmddialsmenuandplayback' => 1,
	'cmddialsreverserotexposurecomp' => 1,
	'cmmflags' => 1,
	'cmp1' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantinfoout' => 1,
	'colorantorder' => 1,
	'colorantorderout' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalance0219' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown1' => 1,
	'colorbalanceunknown2' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata10' => 1,
	'colordata11' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorencodingparams' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetricspecification' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorpopstrength' => 1,
	'colorprimaries' => 1,
	'colorprofiles' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspacename' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransferfunction' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columncount' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblefontname' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composernationality' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositeimaginglocalset' => 1,
	'compositinglayerheader' => 1,
	'compositionlocation' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressioncodecs' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'constantframerate' => 1,
	'constraintindicatorflags' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentlightlevel' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstatus' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'coproducer' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'cornerlatitude1' => 1,
	'cornerlatitude2' => 1,
	'cornerlatitude3' => 1,
	'cornerlatitude4' => 1,
	'cornerlongitude1' => 1,
	'cornerlongitude2' => 1,
	'cornerlongitude3' => 1,
	'cornerlongitude4' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crc' => 1,
	'crcdevelparams' => 1,
	'crd' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapp' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatormodule' => 1,
	'creatoros' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs0' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepointlabel' => 1,
	'cuepointnote' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'customsettingsz8' => 1,
	'customsettingsz9' => 1,
	'customsettingsz9v4' => 1,
	'customtostandardpcc' => 1,
	'cxf' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'd2' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'date1' => 1,
	'date2' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateencoded' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datepurchased' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetagged' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'datewritten' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'db' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'declassificationdate' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultcmyk' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultsettings' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delimiter' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'densityaltitude' => 1,
	'densityaltitudeextended' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthhwheight' => 1,
	'depthhwwidth' => 1,
	'depthmapdata' => 1,
	'depthmapdata2' => 1,
	'depthmapheight' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'depthswheight' => 1,
	'depthswwidth' => 1,
	'derivedimageref' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'deviceorientation' => 1,
	'devicesettings' => 1,
	'devicesounds' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'differentialpressure' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directionalatob0' => 1,
	'directionalatob1' => 1,
	'directionalatob2' => 1,
	'directionalatob3' => 1,
	'directionalbtoa0' => 1,
	'directionalbtoa1' => 1,
	'directionalbtoa2' => 1,
	'directionalbtoa3' => 1,
	'directionalbtod0' => 1,
	'directionalbtod1' => 1,
	'directionalbtod2' => 1,
	'directionalbtod3' => 1,
	'directionaldtob0' => 1,
	'directionaldtob1' => 1,
	'directionaldtob2' => 1,
	'directionaldtob3' => 1,
	'directorofphotography' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distance' => 1,
	'distancefromhome' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'dji-dbg' => 1,
	'dji_dtat' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'docversion' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dronepitch' => 1,
	'dronequaternion' => 1,
	'droneroll' => 1,
	'droneyaw' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualfiles' => 1,
	'dualshotextra' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'dynamicranger128' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit4data' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'ef' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectstrength' => 1,
	'effectsvisible' => 1,
	'effecttype' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electricalextendermagnification' => 1,
	'electronicimagestabilization' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimage2' => 1,
	'embeddedimageclass' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagerectangle' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideo' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emergencysos' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endianness' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'et' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'eventstarttime' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimes' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedalbumname' => 1,
	'extendedartistname' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedtracktitle' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'extremeweathermode' => 1,
	'f-stop' => 1,
	'f_' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'fax' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fcc-id' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileguid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterparametersbinary' => 1,
	'filterparameterscustomcustomdata' => 1,
	'filterparametersexportexportdata' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finetune' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firmwareversion51' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfo0300' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flightdegree' => 1,
	'flightspeed' => 1,
	'flipstatus' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'flirdata' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'flyingstate' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusframesize' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspointbrightness' => 1,
	'focuspointselectionspeed' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'follow-meanimation' => 1,
	'follow-memode' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formatsdcard' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fps' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framebaseview' => 1,
	'framecenterelevation' => 1,
	'framecenterheightaboveellipsoid' => 1,
	'framecenterlatitude' => 1,
	'framecenterlongitude' => 1,
	'framedelay' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'frameview' => 1,
	'framinggriddisplay' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fuelremaining' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullangleofattack' => 1,
	'fullname' => 1,
	'fullpitchangle' => 1,
	'fullrollangle' => 1,
	'fullscreen' => 1,
	'fullsideslipangle' => 1,
	'fusion360fly' => 1,
	'fusionmode' => 1,
	'fusionypr' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gainmapimage' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gamutboundarydescription0' => 1,
	'gamutboundarydescription1' => 1,
	'gamutboundarydescription2' => 1,
	'gamutboundarydescription3' => 1,
	'gapless' => 1,
	'garmingps' => 1,
	'garminmodel' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gcamera' => 1,
	'gcontainer' => 1,
	'gcreations' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generalencapsulatedobject' => 1,
	'generallevelidc' => 1,
	'generalprofileidc' => 1,
	'generalprofilespace' => 1,
	'generaltierflag' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genericflagdata01' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genprofilecompatibilityflags' => 1,
	'genr' => 1,
	'geo' => 1,
	'geob-data' => 1,
	'geob-desc' => 1,
	'geob-file' => 1,
	'geob-mime' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geolocationbearing' => 1,
	'geolocationcity' => 1,
	'geolocationcountry' => 1,
	'geolocationcountrycode' => 1,
	'geolocationdistance' => 1,
	'geolocationfeaturecode' => 1,
	'geolocationfeaturetype' => 1,
	'geolocationpopulation' => 1,
	'geolocationposition' => 1,
	'geolocationregion' => 1,
	'geolocationsubregion' => 1,
	'geolocationtimezone' => 1,
	'geolocationwarning' => 1,
	'geometricdistortionparams' => 1,
	'georegistrationlocalset' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbaldegree' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalpalette' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'gpano' => 1,
	'gpmd_fmas' => 1,
	'gpmd_gopro' => 1,
	'gpmd_kingslim' => 1,
	'gpmd_rove' => 1,
	'gpmd_wolfbox' => 1,
	'gps' => 1,
	'gps360fly' => 1,
	'gpsaltituderaw' => 1,
	'gpsaltitudesystem' => 1,
	'gpsdata' => 1,
	'gpsdatalist' => 1,
	'gpsdatalist2' => 1,
	'gpsdatetimeraw' => 1,
	'gpsdestaltitude' => 1,
	'gpsframingaltitude' => 1,
	'gpsframinglatitude' => 1,
	'gpsframinglongitude' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpslatitude2' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongitude2' => 1,
	'gpslongituderaw' => 1,
	'gpsmode' => 1,
	'gpspos' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpsstamp' => 1,
	'gpstargetaltitude' => 1,
	'gpstargetlatitude' => 1,
	'gpstargetlongitude' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocitydown' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'gravityvector' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'gridsize' => 1,
	'groundrange' => 1,
	'groupareac1' => 1,
	'groupcaption' => 1,
	'groupmutualexclusion' => 1,
	'groups' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guano' => 1,
	'gyro360fly' => 1,
	'gyromode' => 1,
	'gyroscope' => 1,
	'gyroscopeunknown' => 1,
	'gyroypr' => 1,
	'halftonedegree' => 1,
	'halftonelpi' => 1,
	'halftonelpiunit' => 1,
	'halftonemisc' => 1,
	'halftonescreen' => 1,
	'halftoneshape' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasselbladexif' => 1,
	'hasselbladrawimage' => 1,
	'hasselbladxml' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdmibitdepth' => 1,
	'hdmiexternalrecorder' => 1,
	'hdmioutputhdr' => 1,
	'hdmioutputrange' => 1,
	'hdrgm' => 1,
	'hdrinfo' => 1,
	'hdrinfo2' => 1,
	'hdrinfoversion' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hevcconfigurationversion' => 1,
	'hiddendata' => 1,
	'hiddeninfo' => 1,
	'hiddenslides' => 1,
	'highbitdepth' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'highnote' => 1,
	'highvelocity' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintmaxoutputvalue' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalfieldofview' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'hotspotx' => 1,
	'hotspoty' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huawei' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlapsdebuginfo' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'iad1' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iccprofilelocation' => 1,
	'icingdetected' => 1,
	'icondir' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idsbasevalue' => 1,
	'idstring' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagecoordinatesystem' => 1,
	'imagedatadiscard' => 1,
	'imagedatahash' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imagegeometry' => 1,
	'imageheader' => 1,
	'imageheightinches' => 1,
	'imagehorizonpixelpack' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagelocation' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imagepixeloffset' => 1,
	'imagepixelstorage' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesampleformat' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestabilisation' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imagewidthinches' => 1,
	'imageworkstationmake' => 1,
	'imagingdata' => 1,
	'imdb' => 1,
	'imdb_id' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexbackground' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'indextransparent' => 1,
	'indicatedairspeed' => 1,
	'indications' => 1,
	'infirayfactory' => 1,
	'infirayisothermal' => 1,
	'infiraymixmode' => 1,
	'infirayopmode' => 1,
	'infiraypicture' => 1,
	'infiraysensor' => 1,
	'infirayversion' => 1,
	'info' => 1,
	'ingrreserved' => 1,
	'initialdelaysamples' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'inputheight' => 1,
	'inputorientation' => 1,
	'inputuniformity' => 1,
	'inputwidth' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'insta360' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'instruments' => 1,
	'insv' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'intervaloffset' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isartbokeh' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoautooffset' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemdesignatorid' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'ixml' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpegimagelength' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jpgfromraw2' => 1,
	'jpginfooffset' => 1,
	'jplcartoifd' => 1,
	'jps' => 1,
	'jpscomment' => 1,
	'jpsflags' => 1,
	'jpslayout' => 1,
	'jpsseparation' => 1,
	'jpstype' => 1,
	'jsondata' => 1,
	'jsonmetadata' => 1,
	'jumbf' => 1,
	'jumbfbox' => 1,
	'jumbfdescr' => 1,
	'jumdid' => 1,
	'jumdlabel' => 1,
	'jumdsignature' => 1,
	'jumdtoggles' => 1,
	'jumdtype' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'jxlcodestream' => 1,
	'k1' => 1,
	'k2' => 1,
	'k3' => 1,
	'k4' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepexposurewithteleconverter' => 1,
	'keepuntil' => 1,
	'keepusersettings' => 1,
	'kelvinwb' => 1,
	'kenwooddata' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf' => 1,
	'kf8coveruri' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kilocalories' => 1,
	'kinds' => 1,
	'kj' => 1,
	'kk' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelcode' => 1,
	'labeledtext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'languages' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'laserprfcode' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'lawrating' => 1,
	'layerblendmodes' => 1,
	'layercolors' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layersections' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layervisible' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lccn' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'leftmargin' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdata0402' => 1,
	'lensdata0403' => 1,
	'lensdata0800' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfacing' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'levelinfo' => 1,
	'levelinfok3iii' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'ligo_json' => 1,
	'limage' => 1,
	'limitaf-areamodeselautoanimals' => 1,
	'limitaf-areamodeselautopeople' => 1,
	'limitaf-areamodeseldynamic' => 1,
	'limitaf-areamodeselwidelanimals' => 1,
	'limitaf-areamodeselwidelpeople' => 1,
	'limitafareamodesel3d' => 1,
	'limitafareamodeseld105' => 1,
	'limitafareamodeseld25' => 1,
	'limitafareamodeseld49' => 1,
	'limitafareamodeseld9' => 1,
	'limitafareamodeselgroup' => 1,
	'limitafareamodeselgroupc1' => 1,
	'limitafareamodeselgroupc2' => 1,
	'limitreleasemodeselmirror-up' => 1,
	'limitreleasemodeselq' => 1,
	'limitreleasemodeseltimer' => 1,
	'limitselectableimagearea5to4' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'linecount' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedfilename' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkgoodput' => 1,
	'linkinfo' => 1,
	'linkquality' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'linux' => 1,
	'listtype' => 1,
	'lit' => 1,
	'livephotoinfo' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationinfo' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loginfo' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopcount' => 1,
	'lotus' => 1,
	'lowlightaf' => 1,
	'lownote' => 1,
	'lowvelocity' => 1,
	'lr' => 1,
	'lslv' => 1,
	'lucasjunk' => 1,
	'lumaaverage' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'luminancetable' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'mag360fly' => 1,
	'magmode' => 1,
	'magneticfield' => 1,
	'magneticheading' => 1,
	'magnetometer' => 1,
	'magnetometerxyz' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'marl' => 1,
	'marlindataversion' => 1,
	'marlindictionary' => 1,
	'marlinheader' => 1,
	'marlinvalues' => 1,
	'masksubarea' => 1,
	'masteredby' => 1,
	'mastergainadjustment' => 1,
	'matrixcoefficients' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxcontentlightlevel' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumshutterangle' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxpicaveragelightlevel' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mccdata' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemaudiobitrate' => 1,
	'mditemaudiochannelcount' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcodecs' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentcreationdateranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditemdurationseconds' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditeminterestingdateranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlastuseddate_ranking' => 1,
	'mditemlatitude' => 1,
	'mditemlensmodel' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemmediatypes' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemstreamable' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemtotalbitrate' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemuserdownloadeddate' => 1,
	'mditemuserdownloadeduserhandle' => 1,
	'mditemusersharedreceiveddate' => 1,
	'mditemusersharedreceivedrecipient' => 1,
	'mditemusersharedreceivedrecipienthandle' => 1,
	'mditemusersharedreceivedsender' => 1,
	'mditemusersharedreceivedsenderhandle' => 1,
	'mditemusersharedreceivedtransport' => 1,
	'mditemversion' => 1,
	'mditemvideobitrate' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measure' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementinputinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediadataoffset' => 1,
	'mediadatasize' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediauniqueid' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'menuoffset' => 1,
	'menusettingsoffset' => 1,
	'menusettingsoffsetz7ii' => 1,
	'menusettingsoffsetz8' => 1,
	'menusettingsoffsetz8v2' => 1,
	'menusettingsoffsetz9' => 1,
	'menusettingsoffsetz9v3' => 1,
	'menusettingsoffsetz9v4' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metadataversion' => 1,
	'metaformat' => 1,
	'metaimagesize' => 1,
	'metarelation' => 1,
	'metasampledesc' => 1,
	'metatype' => 1,
	'metdata' => 1,
	'meter' => 1,
	'meterinfo' => 1,
	'meteringbutton' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'mett' => 1,
	'microphonewet' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midipitchfraction' => 1,
	'midisong' => 1,
	'midiunitynote' => 1,
	'mie' => 1,
	'miiscoreidentifier' => 1,
	'mileage' => 1,
	'mimeencoding' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'minspatialsegmentationidc' => 1,
	'mintransmissiontime' => 1,
	'missionid' => 1,
	'mixedby' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modelstamp' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monostrength' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'moresettingsoffset' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviefragment' => 1,
	'moviefragmentheader' => 1,
	'moviefragmentsequence' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'moviehighlightdisplaypattern' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'moviewhitebalancesameasphoto' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'mtoa0' => 1,
	'mtob0' => 1,
	'mtob1' => 1,
	'mtob2' => 1,
	'mtob3' => 1,
	'mtos0' => 1,
	'mtos1' => 1,
	'mtos2' => 1,
	'mtos3' => 1,
	'multiexp' => 1,
	'multiexposure2' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiplexdefaultvalues' => 1,
	'multiplextypearray' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'mynextbase-paireddevicename' => 1,
	'mynextbase-pairing' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'nbcd' => 1,
	'ncc' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'newlines' => 1,
	'nextbasemeta' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikonapp' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonnefinfo' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'nine' => 1,
	'nineedits' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'normallinetransfertiming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlicenseplate' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numplanes' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numsampleloops' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'numtemporallayers' => 1,
	'objectcountrycodes' => 1,
	'objectcountrycodingmethod' => 1,
	'objectcountrycodingmethoddate' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectorientation' => 1,
	'objectsizeannounced' => 1,
	'observationdate' => 1,
	'observationdateend' => 1,
	'observationtime' => 1,
	'observationtimeend' => 1,
	'observer' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offset13' => 1,
	'offsetcornerlatitude1' => 1,
	'offsetcornerlatitude2' => 1,
	'offsetcornerlatitude3' => 1,
	'offsetcornerlatitude4' => 1,
	'offsetcornerlongitude1' => 1,
	'offsetcornerlongitude2' => 1,
	'offsetcornerlongitude3' => 1,
	'offsetcornerlongitude4' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'oleinfo' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'on1_settingsdata' => 1,
	'on1_settingsmetadatacreated' => 1,
	'on1_settingsmetadatamodified' => 1,
	'on1_settingsmetadataname' => 1,
	'on1_settingsmetadatapluginid' => 1,
	'on1_settingsmetadatatimestamp' => 1,
	'on1_settingsmetadatausage' => 1,
	'on1_settingsmetadatavisibletouser' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationalmode' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'opticalvr' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'orientationoffset' => 1,
	'orientoffset' => 1,
	'original' => 1,
	'originalalbum' => 1,
	'originaldate' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originalmedia' => 1,
	'originalmediatype' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originalyear' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'othermeta' => 1,
	'othername' => 1,
	'otheroffset' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputheight' => 1,
	'outputorientation' => 1,
	'outputresponse' => 1,
	'outputwidth' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parallelismtype' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalratingreason' => 1,
	'parkingmode' => 1,
	'parrotautomation' => 1,
	'parrotfollowme' => 1,
	'parrottimestamp' => 1,
	'parrotv1' => 1,
	'parrotv2' => 1,
	'parrotv3' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialjxlcodestream' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partoffset' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'pdrversion' => 1,
	'peakbitrate' => 1,
	'peaklevelr128' => 1,
	'peaklevelsample' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'peg_info' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'perfmode' => 1,
	'performersortorder' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'phone' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pilotingmode' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchrollyaw' => 1,
	'pittasoft' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'playbackflickdownrating' => 1,
	'playbackflickuprating' => 1,
	'playbackframerate' => 1,
	'playcounter' => 1,
	'playlist' => 1,
	'playlistdelay' => 1,
	'playlistindex' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraitmatrix' => 1,
	'portraitoffset' => 1,
	'portraittonescaletable' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'prediminanthue' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'prefersubselectorcenter' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewjxl' => 1,
	'previewjxllength' => 1,
	'previewjxlstart' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryfileguid' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsbleedwidth' => 1,
	'printflagsbleedwidthscale' => 1,
	'printflagscrop' => 1,
	'printflagsinfo' => 1,
	'printflagsversion' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productioncopyright' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversionnumber' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesequenceinfo' => 1,
	'profilesize' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projectidcode' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protune' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'ptrh' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasecurrency' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purchaseitem' => 1,
	'purchaseowner' => 1,
	'purchaseprice' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'quietshuttershootingspeed' => 1,
	'quoting' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafcompression' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rangeimagelocalset' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawburstmoderoll' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimageaspectratio' => 1,
	'rawimagecroppedsize' => 1,
	'rawimagecroptopleft' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagenumber' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawvaluerangemax' => 1,
	'rawvaluerangemin' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'rearcontropaneldisplay' => 1,
	'recallshootfuncaf-on' => 1,
	'recallshootfuncafareamode' => 1,
	'recallshootfuncaperture' => 1,
	'recallshootfuncexposurecomp' => 1,
	'recallshootfuncexposuremode' => 1,
	'recallshootfuncfocustracking' => 1,
	'recallshootfunciso' => 1,
	'recallshootfuncmeteringmode' => 1,
	'recallshootfuncshutterspeed' => 1,
	'recallshootfuncwhitebalance' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingdates' => 1,
	'recordinghistory' => 1,
	'recordinglocation' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'records' => 1,
	'recordsv2' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencename' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectedtemperature' => 1,
	'reflection' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relatedresources' => 1,
	'relationship' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'releasinginstructions' => 1,
	'remasterinfo' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'remixedby' => 1,
	'remotefuncbutton' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaingain' => 1,
	'replaygainpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replaytrackgain' => 1,
	'replaytrackpeak' => 1,
	'replayvolumelevel' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resolutioninfo' => 1,
	'resolutionxlengthunit' => 1,
	'resolutionxunit' => 1,
	'resolutionylengthunit' => 1,
	'resolutionyunit' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'reversingcamera' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohinfo' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrdta' => 1,
	'ricohrdtb' => 1,
	'ricohrdtc' => 1,
	'ricohrdtg' => 1,
	'ricohrdtl' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rootnote' => 1,
	'rot360fly' => 1,
	'rotationangle' => 1,
	'rotationinfooffset' => 1,
	'rotationxyz' => 1,
	'rotmode' => 1,
	'roundtripversion' => 1,
	'rowcount' => 1,
	'rowinterleavefactor' => 1,
	'rsrc' => 1,
	'rtmd' => 1,
	'rtos' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	'rvtlocalset' => 1,
	's2n' => 1,
	'sample' => 1,
	'sampleblacksequence' => 1,
	'sampledatetime' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'sampleperiod' => 1,
	'sampler' => 1,
	'samplerate2' => 1,
	'samplerdata' => 1,
	'samplerdatalen' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungcaptureinfo' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungmodel' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'samsungtrailer' => 1,
	'samsunguniqueid' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'sarmotionimagerydata' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'savefocus' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'sceneclassification' => 1,
	'scenecolorimetryestimates' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screendimming' => 1,
	'screenheight' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenplayby' => 1,
	'screensaver' => 1,
	'screenwidth' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'script' => 1,
	'scriptcommand' => 1,
	'sdc' => 1,
	'sdcardclass' => 1,
	'sdcardformat' => 1,
	'sdcardmanfdate' => 1,
	'sdcardmanfid' => 1,
	'sdcardmodelno' => 1,
	'sdcardoemid' => 1,
	'sdcardserialno' => 1,
	'sdcardsize' => 1,
	'sdcardtype' => 1,
	'sdcardusedspace' => 1,
	'sdcc-flp' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondcam' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'securitylocalmetadataset' => 1,
	'securitysci-shiinformation' => 1,
	'securityversion' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'segheight' => 1,
	'segmentlocalset' => 1,
	'segwidth' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'semanticinstanceid' => 1,
	'semanticname' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensitivityvalue' => 1,
	'sensorbottomborder' => 1,
	'sensordata' => 1,
	'sensordefects' => 1,
	'sensorellipsoidheight' => 1,
	'sensorellipsoidheightextended' => 1,
	'sensorfieldofviewname' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorname' => 1,
	'sensorreadouttime' => 1,
	'sensorrelativeazimuthangle' => 1,
	'sensorrelativeelevationangle' => 1,
	'sensorrelativerollangle' => 1,
	'sensorrightborder' => 1,
	'sensorvelocityeast' => 1,
	'sensorvelocitynorth' => 1,
	'seqcount' => 1,
	'seqfinal' => 1,
	'seqframeinfo' => 1,
	'seqid' => 1,
	'seqindex' => 1,
	'seqlevelidx0' => 1,
	'seqprofile' => 1,
	'seqtier0' => 1,
	'seqtype' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'sequenceoffset' => 1,
	'serialinfo' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'settingsoffset' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod6' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod7500' => 1,
	'shotinfod780' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'shotinfoz7ii' => 1,
	'shotinfoz8' => 1,
	'shotinfoz9' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutterangle' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sidelightstrength' => 1,
	'sideslipangle' => 1,
	'sigma' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'singleshotdepthmap' => 1,
	'singleshotdepthmaptiff' => 1,
	'singleshotmeta' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'skipinfo' => 1,
	'slantrange' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'smpteformat' => 1,
	'smpteoffset' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sony_0x9416' => 1,
	'sonyfnumber2' => 1,
	'sonyhiddendata' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'sortwith' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialaudio' => 1,
	'spatialaudioversion' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'spectralviewingconditions' => 1,
	'spectralwhitepoint' => 1,
	'speed' => 1,
	'speedstamp' => 1,
	'speedunits' => 1,
	'sphericalvideo' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spinstrength' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'standardtocustompcc' => 1,
	'standbymonitorofftime' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'staticpressure' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stillimagetime' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streamid' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdialframeadvance' => 1,
	'subdialframeadvancerating0' => 1,
	'subdialframeadvancerating1' => 1,
	'subdialframeadvancerating2' => 1,
	'subdialframeadvancerating3' => 1,
	'subdialframeadvancerating4' => 1,
	'subdialframeadvancerating5' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surfacemap' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'synopsis' => 1,
	'systeminfo' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9050c' => 1,
	'tag9050d' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9401' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag9406b' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'tag9416_0000' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tailnumber' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targeterrorestimatece90' => 1,
	'targeterrorestimatele90' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetlocationcovariancematrix' => 1,
	'targetlocationelevation' => 1,
	'targetlocationlatitude' => 1,
	'targetlocationlongitude' => 1,
	'targettrackgateheight' => 1,
	'targettrackgatewidth' => 1,
	'targetwidth' => 1,
	'targetwidthextended' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telescope' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporalidnested' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'thanksto' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thermalcalibration' => 1,
	'thermaldata' => 1,
	'thermalparams' => 1,
	'thermalparams2' => 1,
	'thermalparams3' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailartist' => 1,
	'thumbnailbitspersample' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcolordepth' => 1,
	'thumbnailcompressedsize' => 1,
	'thumbnailcompression' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailcopyright' => 1,
	'thumbnaildata' => 1,
	'thumbnaildatetime' => 1,
	'thumbnaildescription' => 1,
	'thumbnailequipmake' => 1,
	'thumbnailequipmodel' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailhash' => 1,
	'thumbnailimageheight' => 1,
	'thumbnailimagewidth' => 1,
	'thumbnailorientation' => 1,
	'thumbnailphotometricinterp' => 1,
	'thumbnailplanarconfig' => 1,
	'thumbnailplanes' => 1,
	'thumbnailprimarychromaticities' => 1,
	'thumbnailrawbytes' => 1,
	'thumbnailref' => 1,
	'thumbnailrefblackwhite' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailresolutionunit' => 1,
	'thumbnailresolutionx' => 1,
	'thumbnailresolutiony' => 1,
	'thumbnailrowsperstrip' => 1,
	'thumbnailsamplesperpixel' => 1,
	'thumbnailsoftware' => 1,
	'thumbnailstripbytecounts' => 1,
	'thumbnailstripoffsets' => 1,
	'thumbnailtiff' => 1,
	'thumbnailtransferfunction' => 1,
	'thumbnailurl' => 1,
	'thumbnailwhitepoint' => 1,
	'thumbnailycbcrcoefficients' => 1,
	'thumbnailycbcrpositioning' => 1,
	'thumbnailycbcrsubsampling' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'time1' => 1,
	'time2' => 1,
	'timeanddate' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelapse' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamplist' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'timezonedst' => 1,
	'tipl' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'tmdb' => 1,
	'tmdb_id' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tomtomad' => 1,
	'tomtomhl' => 1,
	'tomtomid' => 1,
	'tomtommetadata' => 1,
	'tomtomvd' => 1,
	'tomtomvi' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'topmargin' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalparts' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transfercharacteristic' => 1,
	'transfercharacteristics' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentcolor' => 1,
	'transparentindex' => 1,
	'transportstreamid' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'trim' => 1,
	'trueairspeed' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'tuning' => 1,
	'tvdb' => 1,
	'twelvebit' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'uas_lsversionnumber' => 1,
	'uasdatalink' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'umid' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'uniqueid' => 1,
	'unknown' => 1,
	'unknown00' => 1,
	'unknown01' => 1,
	'unknown02' => 1,
	'unknown03' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknownexif' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unsharpdata' => 1,
	'unshiftednote' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'usertext' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-c2paclaimsignature' => 1,
	'uuid-canon' => 1,
	'uuid-canon2' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-signature' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalaf-onbutton' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalfieldofview' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalspeed' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videofullrangeflag' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videolength' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotimestamp' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignetteinfo' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'vintagestrength' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmtidataset' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumelevelr128' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelscustom' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wbsettings' => 1,
	'wbsettings2' => 1,
	'wcsprofiles' => 1,
	'weaponfired' => 1,
	'weaponload' => 1,
	'webp_flags' => 1,
	'webpage' => 1,
	'weight' => 1,
	'what3words' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wi-fimacaddress' => 1,
	'wi-fipassword' => 1,
	'wi-fissid' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'wifirssi' => 1,
	'winddirection' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'windprocessing' => 1,
	'windspeed' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wpgversion' => 1,
	'wrapmodes' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrapplemaildatereceived' => 1,
	'xattrapplemaildatesent' => 1,
	'xattrapplemailisremoteattachment' => 1,
	'xattrfinderinfo' => 1,
	'xattrlastuseddate' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xidiri' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmlpackets' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpdsa' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilecomment' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zisrawversion' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zoomstrength' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'gpslatitude' => 'Image::ExifTool::GPS',
	'gpslongitude' => 'Image::ExifTool::GPS',
	'gpsposition' => 'Image::ExifTool::Exif',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names to lookup corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level structure
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                my $lcFlat = $$newInfo{FlatName} ? lc($$newInfo{FlatName}) : $lcTag;
                AddFields($tagTablePtr, $tagID, $lcFlat, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (sort { $a <=> $b } keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        no strict 'refs';
                        $reload = 1 if &$writeProc();
                    }
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2024, Phil Harvey (philharvey66 at gmail.com)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
