=head1 NAME

iPE::Comments - Handling of comments for output.  Inherits from iPE::XML::Object.

=head1 DESCRIPTION

=over 8

=cut

package iPE::Comments;
use base("iPE::XML::Object");

=item addComment (comment)

Adds a comment to the comments field.  A newline is automatically generated.  Pass nothing to add an empty comment

=cut
sub addComment {
    my ($this, $str) = @_;
    
    my $comment = "";
    $comment .= $str if defined $str;
    $this->addPCData($comment."\n");
}

=item addList (title, listarrayref)

Adds a list of items to the comments field.  If the title is defined, the title is printed first, followed by a colon, then the list separated by newlines.

=cut
sub addList {
    my ($this, $title, $aref) = @_;

    if(defined $title)    { $this->addPCData($title.":\n");      }
    for my $item (@$aref) { $this->addPCData("    ".$item."\n"); }
}

=item getZoeComments ()

Returns the comments in zoe format.

=cut
sub getZoeComments {
    my ($this) = @_;

    my @lines = split('\n', $this->getPCData);
    my $zComments = "";
    for my $line (@lines) {
        $zComments .= "# ".$line."\n";
    }

    return $zComments;
}

=back

=head1 SEE ALSO

L<iPE>, L<iPE::XML::Object>

=head1 AUTHOR

Bob Zimmermann (rpz@cs.wustl.edu)

=cut

1;
