//===----------------------------------------------------------------------===//
// Copyright © 2024 Apple Inc. and the Pkl project authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//===----------------------------------------------------------------------===//
abstract module GradleJob

import ".../pkl-pantry/packages/com.circleci.v2/CircleCI.pkl"

/// Whether this is a release build or not.
isRelease: Boolean = false

fixed gradleArgs = new Listing {
  "--info"
  "--stacktrace"
  when (isRelease) {
    "-DreleaseBuild=true"
  }
}.join(" ")

steps: Listing<CircleCI.Step>

job: CircleCI.Job = new {
  environment {
    ["LANG"] = "en_US.UTF-8"
  }
  steps {
    "checkout"
    ...module.steps
    new CircleCI.RunStep {
      // find all test results and write them to the home dir
      name = "Gather test results"
      command = """
        mkdir ~/test-results/
        find . -type f -regex ".*/build/test-results/.*xml" -exec cp {} ~/test-results/ \\;
        """
      `when` = "always"
    }
    new CircleCI.StoreTestResults {
      path = "~/test-results"
    }
  }
}
