amends ".../snippetTest.pkl"

local class Foo

local renderer = new YamlRenderer { isStream = true }

examples {
  ["multiline string at end of document"] {
    renderer.renderDocument(new Listing {
      new Dynamic {
        x = "one\ntwo"
      }
      new Dynamic {
        x = "other"
      }
    })
  }
  ["multiline string at end of stream"] {
    renderer.renderDocument(new Listing {
      new Dynamic {
        x = "other"
      }
      new Dynamic {
        x = "one\ntwo"
      }
    })
  }
  ["invalid top level value"] {
    module.catch(() -> renderer.renderDocument(5))
    module.catch(() -> renderer.renderDocument(new Foo {}))
  }
}
