amends "../snippetTest.pkl"

facts {
  ["isPositive"] {
    0.mb.isPositive
    0.0.mb.isPositive
    1.mb.isPositive
    0.1.mb.isPositive
    (-0).mb.isPositive
    (-0.0).mb.isPositive
    !(-1).mb.isPositive
    !(-0.1).mb.isPositive
  }

  ["isBinaryUnit"] {
    1.pib.isBinaryUnit
    2.tib.isBinaryUnit
    3.gib.isBinaryUnit
    4.mib.isBinaryUnit
    5.kib.isBinaryUnit
    6.b.isBinaryUnit

    !1.pb.isBinaryUnit
    !2.tb.isBinaryUnit
    !3.gb.isBinaryUnit
    !4.mb.isBinaryUnit
    !5.kb.isBinaryUnit
  }

  ["isDecimalUnit"] {
    1.pb.isDecimalUnit
    2.tb.isDecimalUnit
    3.gb.isDecimalUnit
    4.mb.isDecimalUnit
    5.kb.isDecimalUnit
    6.b.isDecimalUnit

    !1.pib.isDecimalUnit
    !2.tib.isDecimalUnit
    !3.gib.isDecimalUnit
    !4.mib.isDecimalUnit
    !5.kib.isDecimalUnit
  }

  ["isBetween"] {
    3.kb.isBetween(2.kb, 4.kb)
    3.kb.isBetween(3.kb, 4.kb)
    3.kb.isBetween(2.kb, 3.kb)
    3.kb.isBetween(3.kb, 3.kb)
    3.kb.isBetween(2000.b, 3000.b)
    !3.kb.isBetween(1.kb, 2.kb)
    !3.kb.isBetween(4.kb, 2.kb)

    3.3.kb.isBetween(2.2.kb, 4.4.kb)
    3.3.kb.isBetween(3.3.kb, 4.4.kb)
    3.3.kb.isBetween(2.2.kb, 3.3.kb)
    3.3.kb.isBetween(3.3.kb, 3.3.kb)
    3.3.kb.isBetween(2000.b, 3300.b)
    !3.3.kb.isBetween(1.1.kb, 2.2.kb)
    !3.3.kb.isBetween(4.4.kb, 2.2.kb)
  }
}

examples {
  ["value"] {
    1.b.value
    2.2.kb.value
    3.kib.value
    4.4.mb.value
    5.mib.value
    6.6.gb.value
    7.gib.value
    8.8.tb.value
    9.tib.value
    10.1.pb.value
    11.pib.value
    List(1, 2.2, 3).map((d) -> d.mb.value)
  }

  ["unit"] {
    1.b.unit
    2.2.kb.unit
    3.kib.unit
    4.4.mb.unit
    5.mib.unit
    6.6.gb.unit
    7.gib.unit
    8.8.tb.unit
    9.tib.unit
    10.1.pb.unit
    11.pib.unit
  }


  ["toUnit()"] {
    1.pb.toUnit("pb")
    1.pb.toUnit("tb")
    1.pb.toUnit("gb")
    1.pb.toUnit("mb")
    1.pb.toUnit("kb")
    1.pb.toUnit("b")

    local b = 1.pb.toUnit("b")
    b.toUnit("pb")
    b.toUnit("tb")
    b.toUnit("gb")
    b.toUnit("mb")
    b.toUnit("kb")
    b.toUnit("b")

    1.pib.toUnit("pib")
    1.pib.toUnit("tib")
    1.pib.toUnit("gib")
    1.pib.toUnit("mib")
    1.pib.toUnit("kib")
    1.pib.toUnit("b")

    local b2 = 1.pib.toUnit("b")
    b2.toUnit("pib")
    b2.toUnit("tib")
    b2.toUnit("gib")
    b2.toUnit("mib")
    b2.toUnit("kib")
    b2.toUnit("b")

    module.catch(() -> 1.pb.toUnit("foo"))
    0.5.gb.toUnit("kb")
    0.5.gb.toUnit("gib")
  }

  ["toBinaryUnit()"] {
    1.024.pb.toBinaryUnit()
    1.024.tb.toBinaryUnit()
    1.024.gb.toBinaryUnit()
    1.024.mb.toBinaryUnit()
    1.024.kb.toBinaryUnit()
    1.024.b.toBinaryUnit()

    1.024.pib.toBinaryUnit()
    1.024.tib.toBinaryUnit()
    1.024.gib.toBinaryUnit()
    1.024.mib.toBinaryUnit()
    1.024.kib.toBinaryUnit()
  }

  ["toDecimalUnit()"] {
    1.pb.toDecimalUnit()
    1.tb.toDecimalUnit()
    1.gb.toDecimalUnit()
    1.mb.toDecimalUnit()
    1.kb.toDecimalUnit()
    1.b.toDecimalUnit()

    1.pib.toDecimalUnit()
    1.tib.toDecimalUnit()
    1.gib.toDecimalUnit()
    1.mib.toDecimalUnit()
    1.kib.toDecimalUnit()
  }
}
