import "pkl:yaml"
import "pkl:test"

local parser = new yaml.Parser {}

res1 = parser.parse("""
  msg1: &one This is a message.
  msg2: *one
  """)

// merge keys were dropped in yaml 1.2; `<<` is now a normal key
res2 = parser.parse("""
  pigeon: &one
    name: pigeon
    age: 42
  pigeon2:
    <<: *one
    age: 21
  """)

res3 = parser.parse("""
  # comment
  name: pigeon
  # comment 2
  age: 42
  """)

res4 = parser.parse("""
  %YAML 1.2
  ---
  name: pigeon
  age: 42
  """)

res5 = parser.parse("""
  ---
  name: pigeon
  age: 42
  ...
  """)

res6 = parser.parse("")

res7 = test.catch(() -> parser.parse("""
  ---
  name: pigeon
  ---
  age: 42
  """))

/// "nothing"
res8 = parser.parseAll("")
res9 = parser.parseAll("   ")

// empty document
res10 = parser.parseAll("""
---
""")

// empty documents
res11 = parser.parseAll("""
---
---
---
""")

// empty document between non-empty documents
res12 = parser.parseAll("""
---
123
---
---
456
""")

res13 = parser.parseAll("""
  name: pigeon
  """)

res14 = parser.parseAll("""
  ---
  name: pigeon
  """)

res15 = parser.parseAll("""
  ---
  name: pigeon
  ---
  age: 42
  ---
  hobby: surfing
  ...
  """)
