/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.completions;

import apex.jorje.data.ast.LiteralType;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.semantic.ast.expression.LiteralExpression;
import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import org.eclipse.lsp4j.Position;

public class StringCompletionActivationStrategy {
    private final ApexCompilerService compilerService;
    private final Document document;
    private final Position position;
    private ContextDeterminer contextDeterminer;

    @AssistedInject
    public StringCompletionActivationStrategy(ApexCompilerService compilerService, @Assisted Document document, @Assisted Position position) {
        this.compilerService = compilerService;
        this.document = document;
        this.position = position;
    }

    void analyze() throws BadLocationException {
        int lineOffset = this.document.getLineOffset(this.position.getLine());
        int offset = lineOffset + this.position.getCharacter();
        this.contextDeterminer = new ContextDeterminer(offset);
        this.compilerService.compile(this.document, this.contextDeterminer);
    }

    boolean isStringLiteral() {
        assert (this.contextDeterminer != null) : "Call analyze() to begin analysis first";
        return this.contextDeterminer != null && this.contextDeterminer.isString();
    }

    static final class ContextDeterminer
    extends AstVisitor<AdditionalPassScope> {
        private final int activationOffset;
        private boolean isString;

        ContextDeterminer(int activationOffset) {
            this.activationOffset = activationOffset;
        }

        public boolean isString() {
            return this.isString;
        }

        @Override
        protected boolean defaultVisit() {
            return true;
        }

        @Override
        public void visitEnd(LiteralExpression node, AdditionalPassScope scope) {
            boolean isStringLiteral;
            super.visitEnd(node, scope);
            int startIndex = node.getLoc().getStartIndex();
            int endIndex = node.getLoc().getEndIndex();
            boolean bl = isStringLiteral = node.getLiteralType() == LiteralType.STRING;
            if (isStringLiteral && this.activationOffset >= startIndex && endIndex >= this.activationOffset) {
                this.isString = true;
            }
        }
    }
}

