/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.diagnostics;

import apex.jorje.lsp.impl.codeActions.quickFix.QuickFixException;
import apex.jorje.lsp.impl.debug.DebugOptions;
import apex.jorje.lsp.impl.diagnostics.CompilationExceptionVisitor;
import apex.jorje.lsp.impl.utils.Locations;
import apex.jorje.semantic.exception.DependentTypeException;
import apex.jorje.semantic.exception.SemanticException;
import apex.jorje.services.exception.CompilationException;
import apex.jorje.services.exception.InternalException;
import apex.jorje.services.exception.ParseException;
import java.util.Optional;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;

class DiagnosticCompilationExceptionVisitor
implements CompilationExceptionVisitor<Optional<Diagnostic>> {
    DiagnosticCompilationExceptionVisitor() {
    }

    private Optional<Diagnostic> toDiagnostic(CompilationException exception, DiagnosticSeverity severity) {
        Diagnostic diagnostic = new Diagnostic();
        diagnostic.setSeverity(severity);
        diagnostic.setMessage(exception.getError());
        diagnostic.setRange(Locations.Ranges.from(exception.getLoc()));
        return Optional.of(diagnostic);
    }

    @Override
    public Optional<Diagnostic> visit(InternalException exception) {
        if (DebugOptions.shouldReportInternalErrors()) {
            return this.toDiagnostic(exception, DiagnosticSeverity.Warning);
        }
        return Optional.empty();
    }

    @Override
    public Optional<Diagnostic> visit(ParseException exception) {
        return this.toDiagnostic(exception, DiagnosticSeverity.Error);
    }

    @Override
    public Optional<Diagnostic> visit(SemanticException exception) {
        if (DebugOptions.shouldReportSemanticErrors()) {
            return this.toDiagnostic(exception, DiagnosticSeverity.Warning);
        }
        return Optional.empty();
    }

    @Override
    public Optional<Diagnostic> visit(QuickFixException exception) {
        if (!DebugOptions.shouldReportSemanticErrors()) {
            return this.toDiagnostic(exception, DiagnosticSeverity.Information);
        }
        return Optional.empty();
    }

    @Override
    public Optional<Diagnostic> visit(DependentTypeException exception) {
        return Optional.empty();
    }
}

