/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.document;

import apex.jorje.lsp.api.document.DocumentLifecycleHandler;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class DocumentLifecycleDispatcher
implements DocumentLifecycleHandler {
    private static final Logger logger = LoggerFactory.getLogger(DocumentLifecycleDispatcher.class);
    private final ApexDocumentService sourceService;
    private final Set<DocumentLifecycleHandler> handlers;
    private final Provider<ExecutorService> executorProvider;

    @Inject
    public DocumentLifecycleDispatcher(ApexDocumentService sourceService, Set<DocumentLifecycleHandler> handlers, Provider<ExecutorService> executorProvider) {
        this.sourceService = sourceService;
        this.handlers = handlers;
        this.executorProvider = executorProvider;
    }

    @Override
    public void handleDidOpen(DidOpenTextDocumentParams params) {
        this.sourceService.store(URI.create(params.getTextDocument().getUri()), params.getTextDocument().getText());
        ExecutorService executor = (ExecutorService)this.executorProvider.get();
        this.handlers.forEach(handler -> {
            try {
                executor.submit(() -> handler.handleDidOpen(params));
            }
            catch (Exception e) {
                logger.error("Encountered an error with {}", handler, (Object)e);
            }
        });
    }

    @Override
    public void handleDidChange(DidChangeTextDocumentParams params) {
        TextDocumentContentChangeEvent lastChange = (TextDocumentContentChangeEvent)Iterables.getLast(params.getContentChanges());
        this.sourceService.store(URI.create(params.getTextDocument().getUri()), lastChange.getText());
        ExecutorService executor = (ExecutorService)this.executorProvider.get();
        this.handlers.forEach(handler -> {
            try {
                executor.submit(() -> handler.handleDidChange(params));
            }
            catch (Exception e) {
                logger.error("Encountered an error with {}", handler, (Object)e);
            }
        });
    }

    @Override
    public void handleDidClose(DidCloseTextDocumentParams params) {
        this.sourceService.remove(URI.create(params.getTextDocument().getUri()));
        ExecutorService executor = (ExecutorService)this.executorProvider.get();
        this.handlers.forEach(handler -> {
            try {
                executor.submit(() -> handler.handleDidClose(params));
            }
            catch (Exception e) {
                logger.error("Encountered an error with {}", handler, (Object)e);
            }
        });
    }

    @Override
    public void handleDidSave(DidSaveTextDocumentParams params) {
        ExecutorService executor = (ExecutorService)this.executorProvider.get();
        this.handlers.forEach(handler -> {
            try {
                executor.submit(() -> handler.handleDidSave(params));
            }
            catch (Exception e) {
                logger.error("Encountered an error with {}", handler, (Object)e);
            }
        });
    }
}

