/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common.iterable;

import java.util.List;
import java.util.StringJoiner;
import java.util.function.Function;

public final class LessStrings {
    private LessStrings() {
    }

    public static <T> String toString(List<T> values, StringJoiner joiner) {
        return LessStrings.toString(values, Object::toString, joiner);
    }

    public static <T> String toString(List<? extends T> values, Function<? super T, String> function, StringJoiner joiner) {
        for (int i = 0; i < values.size(); ++i) {
            joiner.add(function.apply(values.get(i)));
        }
        return joiner.toString();
    }

    public static <T> String toStringWithSizing(List<? extends T> values, Function<? super T, String> function, String delimiter, String prefix, String suffix) {
        int size = 0;
        for (int i = 0; i < values.size(); ++i) {
            if (i != 0) {
                size += delimiter.length();
            }
            size += function.apply(values.get(i)).length();
        }
        StringBuilder builder = new StringBuilder(size += prefix.length() + suffix.length());
        builder.append(prefix);
        for (int i = 0; i < values.size(); ++i) {
            if (i != 0) {
                builder.append(delimiter);
            }
            builder.append(function.apply(values.get(i)));
        }
        builder.append(suffix);
        return builder.toString();
    }
}

