/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ImmutableList;
import java.util.List;

final class ConcatenatedLists<T>
extends ImmutableList<T> {
    private final List<? extends T> head;
    private final List<? extends T> tail;

    ConcatenatedLists(List<? extends T> head, List<? extends T> tail) {
        this.head = head;
        this.tail = tail;
    }

    @Override
    public int size() {
        return this.head.size() + this.tail.size();
    }

    @Override
    public T get(int index) {
        if (index < this.head.size()) {
            return this.head.get(index);
        }
        int newIndex = index - this.head.size();
        return this.tail.get(newIndex);
    }

    @Override
    boolean isPartialView() {
        return false;
    }
}

