/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.treeexport;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Pattern;
import net.sourceforge.pmd.annotation.Experimental;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.xpath.Attribute;
import net.sourceforge.pmd.util.treeexport.TreeRenderer;
import org.apache.commons.lang3.StringUtils;

@Experimental
public final class XmlTreeRenderer
implements TreeRenderer {
    private static final String XML_START_CHAR = "[:A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\x{2FF}\\x{370}-\\x{37D}\\x{37F}-\\x{1FFF}\\x{200C}-\\x{200D}\\x{2070}-\\x{218F}\\x{2C00}-\\x{2FEF}\\x{3001}-\\x{D7FF}\\x{F900}-\\x{FDCF}\\x{FDF0}-\\x{FFFD}\\x{10000}-\\x{EFFFF}]";
    private static final String XML_CHAR = "[[:A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\x{2FF}\\x{370}-\\x{37D}\\x{37F}-\\x{1FFF}\\x{200C}-\\x{200D}\\x{2070}-\\x{218F}\\x{2C00}-\\x{2FEF}\\x{3001}-\\x{D7FF}\\x{F900}-\\x{FDCF}\\x{FDF0}-\\x{FFFD}\\x{10000}-\\x{EFFFF}].\\-0-9\\xB7\\x{0300}-\\x{036F}\\x{203F}-\\x{2040}]";
    private static final Pattern XML_NAME = Pattern.compile("[:A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\x{2FF}\\x{370}-\\x{37D}\\x{37F}-\\x{1FFF}\\x{200C}-\\x{200D}\\x{2070}-\\x{218F}\\x{2C00}-\\x{2FEF}\\x{3001}-\\x{D7FF}\\x{F900}-\\x{FDCF}\\x{FDF0}-\\x{FFFD}\\x{10000}-\\x{EFFFF}][[:A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\x{2FF}\\x{370}-\\x{37D}\\x{37F}-\\x{1FFF}\\x{200C}-\\x{200D}\\x{2070}-\\x{218F}\\x{2C00}-\\x{2FEF}\\x{3001}-\\x{D7FF}\\x{F900}-\\x{FDCF}\\x{FDF0}-\\x{FFFD}\\x{10000}-\\x{EFFFF}].\\-0-9\\xB7\\x{0300}-\\x{036F}\\x{203F}-\\x{2040}]*");
    private final XmlRenderingConfig strategy;
    private final char attrDelim;

    public XmlTreeRenderer(XmlRenderingConfig strategy) {
        this.strategy = strategy;
        this.attrDelim = (char)(strategy.singleQuoteAttributes ? 39 : 34);
    }

    public XmlTreeRenderer() {
        this(new XmlRenderingConfig());
    }

    @Override
    public void renderSubtree(Node node, Appendable out) throws IOException {
        if (this.strategy.renderProlog) {
            this.renderProlog(out);
        }
        this.renderSubtree(0, node, out);
        out.append(this.strategy.lineSeparator);
    }

    private void renderProlog(Appendable out) throws IOException {
        out.append("<?xml version=").append(this.attrDelim).append("1.0").append(this.attrDelim).append(" encoding=").append(this.attrDelim).append("UTF-8").append(this.attrDelim).append(" ?>").append(this.strategy.lineSeparator);
    }

    private void renderSubtree(int depth, Node node, Appendable out) throws IOException {
        String eltName = node.getXPathNodeName();
        this.checkValidName(eltName);
        this.indent(depth, out).append('<').append(eltName);
        Map attributes = this.strategy.getXmlAttributes(node);
        for (String attrName : attributes.keySet()) {
            this.appendAttribute(out, attrName, (String)attributes.get(attrName));
        }
        if (node.getNumChildren() == 0) {
            out.append(" />");
            return;
        }
        out.append(">");
        for (int i = 0; i < node.getNumChildren(); ++i) {
            out.append(this.strategy.lineSeparator);
            this.renderSubtree(depth + 1, node.getChild(i), out);
        }
        out.append(this.strategy.lineSeparator);
        this.indent(depth, out).append("</").append(eltName).append('>');
    }

    private void appendAttribute(Appendable out, String name, String value) throws IOException {
        this.checkValidName(name);
        out.append(' ').append(name).append('=').append(this.attrDelim).append(XmlTreeRenderer.escapeXmlAttribute(value, this.strategy.singleQuoteAttributes)).append(this.attrDelim);
    }

    private void checkValidName(String name) {
        if (!XmlTreeRenderer.isValidXmlName(name) || XmlTreeRenderer.isReservedXmlName(name)) {
            throw new IllegalArgumentException(name + " is not a valid XML name");
        }
    }

    private Appendable indent(int depth, Appendable out) throws IOException {
        while (depth-- > 0) {
            out.append(this.strategy.indentString);
        }
        return out;
    }

    private static String escapeXmlText(String xml) {
        return xml.replaceAll("<", "&lt;").replaceAll("&", "&amp;");
    }

    private static String escapeXmlAttribute(String xml, boolean isSingleQuoted) {
        return isSingleQuoted ? XmlTreeRenderer.escapeXmlText(xml).replaceAll("'", "&apos;") : XmlTreeRenderer.escapeXmlText(xml).replaceAll("\"", "&quot;");
    }

    private static boolean isValidXmlName(String xml) {
        return XML_NAME.matcher(xml).matches();
    }

    private static boolean isReservedXmlName(String xml) {
        return StringUtils.startsWithIgnoreCase((CharSequence)xml, (CharSequence)"xml");
    }

    @Experimental
    public static class XmlRenderingConfig {
        private String indentString = "    ";
        private String lineSeparator = System.lineSeparator();
        private boolean singleQuoteAttributes = true;
        private boolean renderProlog = true;

        private Map<String, String> getXmlAttributes(Node node) {
            TreeMap<String, String> attrs = new TreeMap<String, String>();
            Iterator<Attribute> iter = node.getXPathAttributesIterator();
            while (iter.hasNext()) {
                Attribute next = iter.next();
                if (!this.takeAttribute(node, next)) continue;
                try {
                    attrs.put(next.getName(), next.getStringValue());
                }
                catch (Exception e) {
                    this.handleAttributeFetchException(next, e);
                }
            }
            return attrs;
        }

        protected void handleAttributeFetchException(Attribute attr, Exception e) {
        }

        protected boolean takeAttribute(Node node, Attribute attribute) {
            return true;
        }

        public XmlRenderingConfig lineSeparator(String lineSeparator) {
            this.lineSeparator = Objects.requireNonNull(lineSeparator);
            return this;
        }

        public XmlRenderingConfig singleQuoteAttributes(boolean useSingleQuote) {
            this.singleQuoteAttributes = useSingleQuote;
            return this;
        }

        public XmlRenderingConfig renderProlog(boolean renderProlog) {
            this.renderProlog = renderProlog;
            return this;
        }

        public XmlRenderingConfig indentWith(String indentString) {
            this.indentString = Objects.requireNonNull(indentString);
            return this;
        }
    }
}

