/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data;

import apex.common.collect.MoreIterables;
import apex.jorje.data.Identifier;
import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.AnnotationValue;
import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.data.ast.TypeRefs;
import apex.jorje.data.ast.WhenCase;
import apex.jorje.data.errors.LexicalError;
import apex.jorje.data.errors.SyntaxError;
import apex.jorje.data.errors.UserError;
import com.google.common.collect.Iterables;
import java.util.List;

final class LocationBlocks {
    static final CompilationUnit.MatchBlock<Location> COMPILATION_UNIT_LOC = new CompilationUnit.MatchBlock<Location>(){

        @Override
        public Location _case(CompilationUnit.TriggerDeclUnit x) {
            return x.name.getLoc();
        }

        @Override
        public Location _case(CompilationUnit.AnonymousBlockUnit x) {
            return Locations.ANONYMOUS_BLOCK;
        }

        @Override
        public Location _case(CompilationUnit.EnumDeclUnit x) {
            return x.body.name.getLoc();
        }

        @Override
        public Location _case(CompilationUnit.ClassDeclUnit x) {
            return x.body.name.getLoc();
        }

        @Override
        public Location _case(CompilationUnit.InterfaceDeclUnit x) {
            return x.body.name.getLoc();
        }

        @Override
        public Location _case(CompilationUnit.InvalidDeclUnit x) {
            return Locations.NONE;
        }
    };
    static final LexicalError.MatchBlock<Location> LEXICAL_ERROR_LOC = new LexicalError.MatchBlock<Location>(){

        @Override
        public Location _case(LexicalError.UnexpectedLexicalError x) {
            return x.loc;
        }

        @Override
        public Location _case(LexicalError.UnrecognizedSymbol x) {
            return x.loc;
        }

        @Override
        public Location _case(LexicalError.UnexpectedSymbol x) {
            return x.loc;
        }

        @Override
        public Location _case(LexicalError.SymbolNotInExpectedSet x) {
            return x.loc;
        }

        @Override
        public Location _case(LexicalError.SymbolInUnexpectedSet x) {
            return x.loc;
        }

        @Override
        public Location _case(LexicalError.SymbolNotInRange x) {
            return x.loc;
        }

        @Override
        public Location _case(LexicalError.UnterminatedString x) {
            return x.loc;
        }

        @Override
        public Location _case(LexicalError.UnterminatedComment x) {
            return x.loc;
        }

        @Override
        public Location _case(LexicalError.InvalidIdentifier x) {
            return x.loc;
        }

        @Override
        public Location _case(LexicalError.InvalidControlChar x) {
            return x.loc;
        }

        @Override
        public Location _case(LexicalError.InvalidSymbol x) {
            return x.loc;
        }

        @Override
        public Location _case(LexicalError.InvalidTime x) {
            return x.loc;
        }

        @Override
        public Location _case(LexicalError.InvalidDate x) {
            return x.loc;
        }

        @Override
        public Location _case(LexicalError.InvalidDateTime x) {
            return x.loc;
        }
    };
    static final SyntaxError.MatchBlock<Location> SYNTAX_ERROR_LOC = new SyntaxError.MatchBlock<Location>(){

        @Override
        public Location _case(SyntaxError.MismatchedSyntax x) {
            return x.loc;
        }

        @Override
        public Location _case(SyntaxError.MissingSyntax x) {
            return x.loc;
        }

        @Override
        public Location _case(SyntaxError.UnmatchedSyntax x) {
            return x.loc;
        }

        @Override
        public Location _case(SyntaxError.UnexpectedSyntaxError x) {
            return x.loc;
        }

        @Override
        public Location _case(SyntaxError.UnexpectedToken x) {
            return x.loc;
        }

        @Override
        public Location _case(SyntaxError.UnexpectedEof x) {
            return x.loc;
        }

        @Override
        public Location _case(SyntaxError.IllegalStringLiteral x) {
            return x.loc;
        }

        @Override
        public Location _case(SyntaxError.IllegalIntegerLiteral x) {
            return x.loc;
        }

        @Override
        public Location _case(SyntaxError.IllegalLongLiteral x) {
            return x.loc;
        }

        @Override
        public Location _case(SyntaxError.IllegalDoubleLiteral x) {
            return x.loc;
        }

        @Override
        public Location _case(SyntaxError.IllegalDecimalLiteral x) {
            return x.loc;
        }
    };
    static final UserError.MatchBlock<Location> USER_ERROR_LOC = new UserError.MatchBlock<Location>(){

        @Override
        public Location _case(UserError.Lexical x) {
            return Locations.from(x.error);
        }

        @Override
        public Location _case(UserError.Syntax x) {
            return Locations.from(x.error);
        }
    };
    static final Expr.MatchBlock<Location> EXPRESSION_LOC = new Expr.MatchBlock<Location>(){

        @Override
        public Location _case(Expr.AssignmentExpr x) {
            return Locations.from(x.left);
        }

        @Override
        public Location _case(Expr.TernaryExpr x) {
            return Locations.from(x.condition);
        }

        @Override
        public Location _case(Expr.BinaryExpr x) {
            return Locations.from(x.left);
        }

        @Override
        public Location _case(Expr.CastExpr x) {
            return x.loc;
        }

        @Override
        public Location _case(Expr.InstanceOf x) {
            return Locations.from(x.expr);
        }

        @Override
        public Location _case(Expr.BooleanExpr x) {
            return Locations.from(x.left);
        }

        @Override
        public Location _case(Expr.TriggerVariableExpr x) {
            return x.loc;
        }

        @Override
        public Location _case(Expr.PackageVersionExpr x) {
            return x.loc;
        }

        @Override
        public Location _case(Expr.PrefixExpr x) {
            return x.loc;
        }

        @Override
        public Location _case(Expr.PostfixExpr x) {
            return x.loc;
        }

        @Override
        public Location _case(Expr.ArrayExpr x) {
            return Locations.from(x.expr);
        }

        @Override
        public Location _case(Expr.VariableExpr x) {
            assert (!x.names.isEmpty());
            return Locations.from(MoreIterables.getFirst(x.names).getLoc(), Iterables.getLast(x.names).getLoc());
        }

        @Override
        public Location _case(Expr.MethodCallExpr x) {
            assert (!x.names.isEmpty());
            return Iterables.getLast(x.names).getLoc();
        }

        @Override
        public Location _case(Expr.JavaMethodCallExpr x) {
            return x.loc;
        }

        @Override
        public Location _case(Expr.JavaVariableExpr x) {
            return x.loc;
        }

        @Override
        public Location _case(Expr.SuperMethodCallExpr x) {
            return x.loc;
        }

        @Override
        public Location _case(Expr.SuperVariableExpr x) {
            return x.loc;
        }

        @Override
        public Location _case(Expr.ThisMethodCallExpr x) {
            return x.loc;
        }

        @Override
        public Location _case(Expr.ThisVariableExpr x) {
            return x.loc;
        }

        @Override
        public Location _case(Expr.ClassRefExpr x) {
            return x.loc;
        }

        @Override
        public Location _case(Expr.LiteralExpr x) {
            return x.loc;
        }

        @Override
        public Location _case(Expr.NewExpr x) {
            return x.loc;
        }

        @Override
        public Location _case(Expr.NestedExpr x) {
            return Locations.from(x.expr);
        }

        @Override
        public Location _case(Expr.SoqlExpr x) {
            return x.loc;
        }

        @Override
        public Location _case(Expr.SoslExpr x) {
            return x.loc;
        }
    };
    static final TypeRef.Visitor<Location> TYPE_REF_LOC = new TypeRef.Visitor<Location>(){

        @Override
        public Location visit(TypeRefs.JavaTypeRef typeRef) {
            assert (!typeRef.getNames().isEmpty()) : "names should be non empty";
            List<Identifier> names = typeRef.getNames();
            return Locations.from(MoreIterables.getFirst(names).getLoc(), Iterables.getLast(names).getLoc());
        }

        @Override
        public Location visit(TypeRefs.ClassTypeRef typeRef) {
            assert (!typeRef.getNames().isEmpty()) : "names should be non empty";
            List<Identifier> names = typeRef.getNames();
            return Locations.from(MoreIterables.getFirst(names).getLoc(), Iterables.getLast(names).getLoc());
        }

        @Override
        public Location visit(TypeRefs.ArrayTypeRef typeRef) {
            assert (!typeRef.getNames().isEmpty()) : "names should be non empty";
            List<Identifier> names = typeRef.getNames();
            return Locations.from(MoreIterables.getFirst(names).getLoc(), Iterables.getLast(names).getLoc());
        }
    };
    static final Stmnt.MatchBlock<Location> STATEMENT_LOC = new Stmnt.MatchBlock<Location>(){

        @Override
        public Location _case(Stmnt.BlockStmnt x) {
            return x.loc;
        }

        @Override
        public Location _case(Stmnt.ExpressionStmnt x) {
            return x.loc;
        }

        @Override
        public Location _case(Stmnt.ReturnStmnt x) {
            return x.loc;
        }

        @Override
        public Location _case(Stmnt.ThrowStmnt x) {
            return x.loc;
        }

        @Override
        public Location _case(Stmnt.BreakStmnt x) {
            return x.loc;
        }

        @Override
        public Location _case(Stmnt.ContinueStmnt x) {
            return x.loc;
        }

        @Override
        public Location _case(Stmnt.DmlInsertStmnt x) {
            return x.loc;
        }

        @Override
        public Location _case(Stmnt.DmlUpdateStmnt x) {
            return x.loc;
        }

        @Override
        public Location _case(Stmnt.DmlUpsertStmnt x) {
            return x.loc;
        }

        @Override
        public Location _case(Stmnt.DmlDeleteStmnt x) {
            return x.loc;
        }

        @Override
        public Location _case(Stmnt.DmlUndeleteStmnt x) {
            return x.loc;
        }

        @Override
        public Location _case(Stmnt.DmlMergeStmnt x) {
            return x.loc;
        }

        @Override
        public Location _case(Stmnt.WhileLoop x) {
            return x.loc;
        }

        @Override
        public Location _case(Stmnt.DoLoop x) {
            return x.loc;
        }

        @Override
        public Location _case(Stmnt.IfElseBlock x) {
            assert (!x.ifBlocks.isEmpty());
            return Locations.from(Locations.from(x.ifBlocks.get(0)), Locations.from(Iterables.getLast(x.ifBlocks)));
        }

        @Override
        public Location _case(Stmnt.RunAsBlock x) {
            return x.loc;
        }

        @Override
        public Location _case(Stmnt.TryCatchFinallyBlock x) {
            return x.loc;
        }

        @Override
        public Location _case(Stmnt.VariableDeclStmnt x) {
            assert (!x.variableDecls.decls.isEmpty());
            return Locations.from(Locations.from(x.variableDecls.type), Locations.from(Iterables.getLast(x.variableDecls.decls).name));
        }

        @Override
        public Location _case(Stmnt.ForLoop x) {
            return x.loc;
        }

        @Override
        public Location _case(Stmnt.SwitchStmnt x) {
            return x.loc;
        }
    };
    static final AnnotationValue.MatchBlock<Location> ANNOTATION_VALUE_LOC = new AnnotationValue.MatchBlock<Location>(){

        @Override
        public Location _case(AnnotationValue.TrueAnnotationValue x) {
            return x.loc;
        }

        @Override
        public Location _case(AnnotationValue.FalseAnnotationValue x) {
            return x.loc;
        }

        @Override
        public Location _case(AnnotationValue.StringAnnotationValue x) {
            return x.loc;
        }
    };
    static final WhenCase.MatchBlock<Location> WHEN_CASE_LOC = new WhenCase.MatchBlock<Location>(){

        @Override
        public Location _case(WhenCase.EnumCase x) {
            return Locations.from(x.identifiers);
        }

        @Override
        public Location _case(WhenCase.LiteralCase x) {
            return Locations.from(x.expr);
        }
    };

    private LocationBlocks() {
    }
}

