/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.services;

import apex.jorje.lsp.api.index.converter.ConverterFactory;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.telemetry.TelemetryHandler;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.completions.Namespaces;
import apex.jorje.lsp.impl.index.ApexIndex;
import apex.jorje.lsp.impl.index.ApexIndexer;
import apex.jorje.lsp.impl.index.converter.TypeInfoConverter;
import apex.jorje.lsp.impl.index.node.ApexResourceFile;
import apex.jorje.lsp.impl.symbols.ApexStandardTypeInfos;
import apex.jorje.lsp.impl.symbols.DatabaseSymbols;
import apex.jorje.lsp.impl.telemetry.TelemetryData;
import apex.jorje.lsp.impl.utils.TypeInfoCache;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.NoopScope;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.internal.core.nd.IProgressMonitor;
import org.eclipse.jdt.internal.core.nd.IReader;
import org.eclipse.jdt.internal.core.nd.Nd;
import org.eclipse.jdt.internal.core.nd.NullProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ApexPreludeManagedService
extends AbstractIdleService {
    public static final String APEX_BUILT_IN_TYPES_URI = "memory://apex-built-in-types";
    public static final String STANDARD_APEX_LIBRARY = "StandardApexLibrary";
    public static final String JAR_URI_SCHEME = "jar://";
    private static final Logger logger = LoggerFactory.getLogger(ApexPreludeManagedService.class);
    private final ApexCompilerService compilerService;
    private final Provider<ApexIndex> apexIndexProvider;
    private final ConverterFactory converterFactory;
    private final ApexIndexer apexIndexer;
    private final TelemetryHandler telemetryHandler;
    private final ApexDocumentService documentService;

    @Inject
    public ApexPreludeManagedService(Provider<ApexIndex> apexIndexProvider, ApexCompilerService compilerService, ConverterFactory converterFactory, ApexIndexer apexIndexer, TelemetryHandler telemetryHandler, ApexDocumentService documentService) {
        this.compilerService = compilerService;
        this.apexIndexProvider = apexIndexProvider;
        this.converterFactory = converterFactory;
        this.apexIndexer = apexIndexer;
        this.telemetryHandler = telemetryHandler;
        this.documentService = documentService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startUp() throws Exception {
        Stopwatch stopwatch = Stopwatch.createStarted();
        TelemetryData telemetryData = new TelemetryData("ApexPrelude-startup");
        logger.info("Scanning built-in and system Apex types.");
        try {
            this.scanBuiltinTypeInfosIfNecessary();
            URI standardLibUri = ApexPreludeManagedService.class.getClassLoader().getResource(STANDARD_APEX_LIBRARY).toURI();
            SourceFilesCollector sourceCollector = new SourceFilesCollector(standardLibUri, this.documentService);
            this.scanApexStandardLibraryIfNecessary(sourceCollector.collectSources());
            this.apexIndexer.startAsync();
        }
        catch (Exception e) {
            telemetryData.add(e);
        }
        finally {
            stopwatch.stop();
            telemetryData.addExecutionTime(stopwatch.elapsed(TimeUnit.MILLISECONDS));
            this.telemetryHandler.send(telemetryData);
        }
        logger.info("Scanning built-in and system Apex types took {} ms.", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    @Override
    public void shutDown() throws Exception {
        logger.info("Prelude Service shutting down.");
    }

    @Override
    public String serviceName() {
        return "Apex Prelude Service";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void scanBuiltinTypeInfosIfNecessary() {
        ApexIndex apexIndex = (ApexIndex)this.apexIndexProvider.get();
        Nd nd = apexIndex.getNd();
        try (IReader ignored = nd.acquireReadLock();){
            if (apexIndex.getResourceFile(APEX_BUILT_IN_TYPES_URI) != null) {
                return;
            }
        }
        nd.acquireWriteLock((IProgressMonitor)new NullProgressMonitor());
        try {
            ApexResourceFile resourceFile = new ApexResourceFile(nd);
            resourceFile.setFilename(APEX_BUILT_IN_TYPES_URI);
            resourceFile.setTimeLastScanned(System.currentTimeMillis());
            resourceFile.setError(false);
            TypeInfoConverter converter = this.converterFactory.createTypeInfoConverter(resourceFile);
            HashSet<TypeInfo> builtInTypes = Sets.newHashSet(TypeInfos.OBJECT, TypeInfos.BLOB, TypeInfos.CURRENCY, TypeInfos.ID, TypeInfos.VOID, TypeInfos.DECIMAL, TypeInfos.DOUBLE, TypeInfos.LONG, TypeInfos.INTEGER, TypeInfos.BOOLEAN, TypeInfos.STRING, TypeInfos.DATE_TIME, TypeInfos.DATE, TypeInfos.LIST, TypeInfos.SET, TypeInfos.MAP, TypeInfos.EXCEPTION, TypeInfos.SOBJECT, InternalTypeInfos.ENUM, ApexStandardTypeInfos.APEX_OBJECT, ApexStandardTypeInfos.APEX_EXCEPTION);
            for (TypeInfo builtInType : builtInTypes) {
                converter.addType(builtInType);
                TypeInfoCache.addBuiltInTypeInfo(builtInType);
            }
        }
        finally {
            nd.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private void scanApexStandardLibraryIfNecessary(List<SourceFile> sourceFiles) {
        ApexIndex apexIndex = (ApexIndex)this.apexIndexProvider.get();
        final Nd nd = apexIndex.getNd();
        for (final CodeUnit codeUnit : this.compilerService.compile(sourceFiles)) {
            IReader ignored = nd.acquireReadLock();
            Throwable throwable = null;
            try {
                if (apexIndex.getResourceFile(codeUnit.getSourceFile().getKnownName()) != null) {
                    continue;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored == null) continue;
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ignored.close();
                continue;
            }
            nd.acquireWriteLock((IProgressMonitor)new NullProgressMonitor());
            try {
                final ApexResourceFile resourceFile = new ApexResourceFile(nd);
                resourceFile.setFilename(codeUnit.getSourceFile().getKnownName());
                resourceFile.setTimeLastScanned(System.currentTimeMillis());
                resourceFile.setError(!codeUnit.getErrors().isEmpty());
                TypeInfoConverter converter = this.converterFactory.createTypeInfoConverter(resourceFile);
                converter.addType(codeUnit.getType());
                codeUnit.getNode().traverse(new AstVisitor<NoopScope>(){

                    @Override
                    public boolean visit(UserClass node, NoopScope scope) {
                        return true;
                    }

                    @Override
                    public void visitEnd(UserClass node, NoopScope scope) {
                        super.visitEnd(node, scope);
                        if (!TypeInfoUtil.isTopLevel(node.getDefiningType())) {
                            this.insertTypeInfo(codeUnit, nd, node.getDefiningType());
                        }
                    }

                    private void insertTypeInfo(CodeUnit codeUnit2, Nd nd2, TypeInfo type) {
                        TypeInfoConverter converter = ApexPreludeManagedService.this.converterFactory.createTypeInfoConverter(resourceFile);
                        converter.addType(type);
                    }
                }, NoopScope.get());
            }
            finally {
                nd.releaseWriteLock();
            }
            if (!codeUnit.getSourceFile().getKnownName().contains("Database.cls")) continue;
            logger.info("Patching standard library for System.Database.* methods");
            new DatabaseSymbols().patch((ApexIndex)this.apexIndexProvider.get());
            logger.info("Done patching standard library for System.Database.* methods");
        }
    }

    @VisibleForTesting
    static final class SourceFilesCollector {
        static final int NAMESPACE_AND_CLASS_PARTS = 2;
        private final URI uri;
        private final ApexDocumentService documentService;

        SourceFilesCollector(URI uri, ApexDocumentService documentService) {
            this.uri = uri;
            this.documentService = documentService;
        }

        List<SourceFile> collectSources() {
            final ArrayList<SourceFile> sourceFiles = Lists.newArrayList();
            try {
                this.loadAndVisitSources(new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        this.addApexClassFiles(file, sourceFiles);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                logger.error("Unable to analyze built-in standard type from filesystem", (Throwable)e);
            }
            return sourceFiles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void loadAndVisitSources(SimpleFileVisitor<Path> visitor) throws IOException {
            Path path;
            FileSystem fs = null;
            if (this.uri.getScheme().startsWith("jar")) {
                fs = FileSystems.newFileSystem(this.uri, Maps.newHashMap());
                path = fs.getPath(ApexPreludeManagedService.STANDARD_APEX_LIBRARY, new String[0]);
            } else {
                path = Paths.get(this.uri);
            }
            try {
                Files.walkFileTree(path, visitor);
            }
            finally {
                if (fs != null) {
                    fs.close();
                }
            }
        }

        void addApexClassFiles(Path file, List<SourceFile> sourceFiles) throws IOException {
            if (file.toString().endsWith(".cls")) {
                String namespace = "";
                if (file.getNameCount() > 2) {
                    namespace = file.getName(file.getNameCount() - 2).toString();
                }
                this.addKosherNamespacedClass(file, sourceFiles, namespace);
            }
        }

        void addKosherNamespacedClass(Path file, List<SourceFile> sourceFiles, String namespace) throws IOException {
            if (Namespaces.NAMESPACES.contains(namespace) || Strings.isNullOrEmpty(namespace)) {
                String fileName = file.toUri().toString();
                int index = Math.max(0, fileName.indexOf("/StandardApexLibrary"));
                String uriPath = ApexPreludeManagedService.JAR_URI_SCHEME + fileName.substring(index);
                SourceFile sourceFile = SourceFile.builder().setNamespace(apex.jorje.semantic.compiler.Namespaces.create(namespace)).setBody(new String(Files.readAllBytes(file))).setKnownName(uriPath).build();
                sourceFiles.add(sourceFile);
                this.documentService.store(URI.create(uriPath), sourceFile.getBody(), namespace);
            }
        }
    }
}

