/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member;

import apex.jorje.data.Location;
import apex.jorje.data.ast.PropertyDecl;
import apex.jorje.data.ast.TypeRefs;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.member.AccessorFactory;
import apex.jorje.semantic.ast.member.AccessorModifierUtil;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.FieldFactory;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.PropertyDescriptor;
import apex.jorje.semantic.ast.member.PropertyInfo;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierGroupBuilder;
import apex.jorje.semantic.ast.modifier.ModifierNode;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.common.util.VersionUtil;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.member.IdentifierValidator;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.AbstractFieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.StandardPropertyInfo;
import apex.jorje.semantic.symbol.member.variable.TriggerPropertyInfo;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.UnresolvedErrorCalculator;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import java.util.Optional;

public class Property
implements AstNode,
PropertyDescriptor {
    private final TypeInfo definingType;
    private final Location loc;
    private final ModifierNode modifiers;
    private final ModifierGroup modifiersInfo;
    private final Method getter;
    private final Method setter;
    private final AbstractFieldInfo.Builder<? extends AbstractFieldInfo.Builder, ? extends FieldInfo> builder;
    private final Field underlyingField;
    private final PropertyInfo info;
    private FieldInfo fieldInfo;

    public Property(Errors errors, AstNode definingNode, PropertyDecl body) {
        this.definingType = definingNode.getDefiningType();
        this.loc = body.name.getLoc();
        ModifierGroupBuilder modifiersBuilder = ModifierGroup.builder().setLoc(this.loc).addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED).addAstModifiers(body.modifiers);
        if (this.definingType.getUnitType() == UnitType.TRIGGER) {
            modifiersBuilder.removeModifiers(ModifierTypeInfos.STATIC);
        } else if (this.definingType.getUnitType() == UnitType.ANONYMOUS) {
            modifiersBuilder.removeModifiers(ModifierTypeInfos.STATIC);
            modifiersBuilder.addModifiers(ModifierTypeInfos.STATIC);
        }
        this.modifiersInfo = modifiersBuilder.build();
        this.modifiers = new ModifierNode(this, this.modifiersInfo);
        ModifierGroup fieldModifiers = ModifierGroup.builder().addModifiers(ModifierTypeInfos.PRIVATE, ModifierTypeInfos.HIDDEN).addIntersectionOfModifiers(this.modifiersInfo, ModifierTypeInfos.STATIC, ModifierTypeInfos.TRANSIENT, ModifierTypeInfos.FINAL).build();
        boolean isVoid = AccessorFactory.isVoidRef(body.type);
        this.underlyingField = FieldFactory.createAccessorField(this, isVoid ? TypeRefs.OBJECT : body.type, fieldModifiers, body.name);
        switch (this.definingType.getUnitType()) {
            case TRIGGER: {
                this.builder = ((TriggerPropertyInfo.Builder)((TriggerPropertyInfo.Builder)((TriggerPropertyInfo.Builder)((TriggerPropertyInfo.Builder)TriggerPropertyInfo.builder().setName(body.name)).setTypeRef(body.type)).setModifiers(this.modifiersInfo)).setDefiningType(this.definingType)).setProperty(this).setUnderlyingField(this.underlyingField);
                break;
            }
            default: {
                this.builder = ((StandardPropertyInfo.Builder)((StandardPropertyInfo.Builder)((StandardPropertyInfo.Builder)((StandardPropertyInfo.Builder)StandardPropertyInfo.builder().setName(body.name)).setTypeRef(body.type)).setModifiers(this.modifiersInfo)).setDefiningType(this.definingType)).setProperty(this).setUnderlyingField(this.underlyingField);
            }
        }
        ModifierGroup getterModifiers = AccessorModifierUtil.calculateGetterModifiers(this, errors, this.modifiersInfo, body, this.getDefiningType().getCodeUnitDetails().getVersion());
        ModifierGroup setterModifiers = AccessorModifierUtil.calculateSetterModifiers(this, errors, this.modifiersInfo, body, this.getDefiningType().getCodeUnitDetails().getVersion());
        this.getter = AccessorFactory.createGetter(this, body, isVoid, getterModifiers);
        this.setter = AccessorFactory.createSetter(this, body, isVoid, setterModifiers);
        this.info = new PropertyInfo(this, body, getterModifiers, setterModifiers);
    }

    public ModifierGroup getModifiers() {
        return this.modifiersInfo;
    }

    public ModifierNode getModifiersNode() {
        return this.modifiers;
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.modifiers.traverse(visitor, scope);
            this.underlyingField.traverse(visitor, scope);
            this.setter.traverse(visitor, scope);
            this.getter.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        scope.push(this);
        try {
            scope.getErrors().addIfError((AstNode)this, this.info.getLoc(), IdentifierValidator.get().validate(this.getDefiningType(), this.info.getName().getValue(), IdentifierValidator.Type.VARIABLE, false, false));
            if (!this.fieldInfo.getType().isResolved()) {
                scope.getErrors().markInvalid((AstNode)this, UnresolvedErrorCalculator.getErrors(this.fieldInfo.getType()));
                return;
            }
            if (!Visibility.isTypeVisible(symbols.getAccessEvaluator(), this.definingType, this.fieldInfo.getType(), Visibility.ReferencedFromTestMethod.NO, Visibility.CheckGenericTypeArguments.YES)) {
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("type.not.visible", this.fieldInfo.getType()));
                return;
            }
            if (TypeInfoEquivalence.isEquivalent(this.fieldInfo.getType(), TypeInfos.VOID) && Version.V188.isLessThanOrEqual(VersionUtil.get(this))) {
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.void.property"));
                return;
            }
            this.underlyingField.validate(symbols, scope);
            this.getter.validate(symbols, scope);
            this.setter.validate(symbols, scope);
            if (scope.getErrors().isInvalid(this.underlyingField, this.getter, this.setter)) {
                scope.getErrors().markInvalid(this);
            }
        }
        finally {
            scope.pop(this);
        }
    }

    @Override
    public void emit(Emitter emitter) {
        this.underlyingField.emit(emitter);
        emitter.setEmitRawProperty(this.fieldInfo);
        this.setter.emit(emitter);
        this.getter.emit(emitter);
        emitter.setEmitRawProperty(null);
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.definingType;
    }

    public FieldInfo getFieldInfo() {
        assert (this.fieldInfo != null);
        return this.fieldInfo;
    }

    public void resolve(SymbolResolver symbols) {
        assert (this.fieldInfo == null);
        this.fieldInfo = this.builder.build(symbols);
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public PropertyInfo getInfo() {
        return this.info;
    }

    @Override
    public MethodInfo getGetter() {
        return this.getter.getMethodInfo();
    }

    @Override
    public MethodInfo getSetter() {
        return this.setter.getMethodInfo();
    }

    public String toString() {
        return Optional.ofNullable(this.fieldInfo).map(Object::toString).orElse(this.builder.toString());
    }
}

