/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier.rule;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.rule.AnnotationContextRule;
import apex.jorje.semantic.ast.modifier.rule.Element;
import apex.jorje.semantic.ast.visitor.SymbolScope;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.services.Version;

public abstract class AnnotationContext {
    private final AstNode node;
    private final SymbolScope scope;

    AnnotationContext(AstNode node, SymbolScope scope) {
        this.node = node;
        this.scope = scope;
    }

    public abstract TypeInfo getDefiningType();

    public abstract Element getElement();

    public abstract ModifierGroup getModifiers();

    public abstract void accept(AnnotationContextRule var1);

    public final AstNode getNode() {
        return this.node;
    }

    public Version getVersion() {
        return this.node.getDefiningType().getCodeUnitDetails().getVersion();
    }

    public SymbolResolver getSymbols() {
        return this.scope.getSymbols();
    }

    public Errors getErrors() {
        return this.scope.getErrors();
    }

    public SymbolScope getScope() {
        return this.scope;
    }

    public void addError(String error) {
        this.scope.getErrors().markInvalid(this.getNode(), this.getModifiers().getLoc(), error);
    }

    public void addNodeError(String error) {
        this.scope.getErrors().markInvalid(this.getNode(), this.getNode().getLoc(), error);
    }
}

