/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor;

import apex.common.tuple.IntHolder;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.statement.BlockStatement;
import apex.jorje.semantic.ast.statement.DoLoopStatement;
import apex.jorje.semantic.ast.statement.ForEachStatement;
import apex.jorje.semantic.ast.statement.ForLoopStatement;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.statement.WhileLoopStatement;
import apex.jorje.semantic.ast.visitor.SymbolScope;
import apex.jorje.semantic.compiler.ValidationSettings;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodUtil;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import com.google.common.collect.Queues;
import java.util.Deque;
import java.util.List;

public class ValidationScope
extends SymbolScope {
    private final Deque<IntHolder> blocks;
    private final Deque<List<Statement>> classStatements;
    private final ValidationSettings settings;
    private Integer looping;
    private MethodInfo method;

    public ValidationScope(SymbolResolver symbols, Errors errors, ValidationSettings settings) {
        super(symbols, errors);
        this.settings = settings;
        this.looping = 0;
        this.blocks = Queues.newArrayDeque();
        this.classStatements = Queues.newArrayDeque();
    }

    @Override
    public void push(UserClass node) {
        super.push(node);
        this.classStatements.push(node.getStatements());
    }

    @Override
    public void pop(UserClass node) {
        this.classStatements.pop();
        super.pop(node);
    }

    @Override
    public void push(DoLoopStatement node) {
        super.push(node);
        Integer n = this.looping;
        Integer n2 = this.looping = Integer.valueOf(this.looping + 1);
    }

    @Override
    public void pop(DoLoopStatement node) {
        Integer n = this.looping;
        Integer n2 = this.looping = Integer.valueOf(this.looping - 1);
        super.pop(node);
    }

    @Override
    public void push(WhileLoopStatement node) {
        super.push(node);
        Integer n = this.looping;
        Integer n2 = this.looping = Integer.valueOf(this.looping + 1);
    }

    @Override
    public void pop(WhileLoopStatement node) {
        Integer n = this.looping;
        Integer n2 = this.looping = Integer.valueOf(this.looping - 1);
        super.pop(node);
    }

    @Override
    public void push(BlockStatement node) {
        super.push(node);
        this.blocks.push(new IntHolder(0));
    }

    @Override
    public void pop(BlockStatement node) {
        this.blocks.pop();
        super.pop(node);
    }

    @Override
    public void push(ForEachStatement node) {
        super.push(node);
        Integer n = this.looping;
        Integer n2 = this.looping = Integer.valueOf(this.looping + 1);
    }

    @Override
    public void pop(ForEachStatement node) {
        Integer n = this.looping;
        Integer n2 = this.looping = Integer.valueOf(this.looping - 1);
        super.pop(node);
    }

    @Override
    public void push(ForLoopStatement node) {
        super.push(node);
        Integer n = this.looping;
        Integer n2 = this.looping = Integer.valueOf(this.looping + 1);
    }

    @Override
    public void pop(ForLoopStatement node) {
        Integer n = this.looping;
        Integer n2 = this.looping = Integer.valueOf(this.looping - 1);
        super.pop(node);
    }

    @Override
    public void push(Method node) {
        super.push(node);
        this.method = node.getMethodInfo();
    }

    @Override
    public void pop(Method node) {
        this.method = null;
        super.pop(node);
    }

    public void pushAnonymousPseudoBlock() {
        this.blocks.push(new IntHolder(0));
    }

    public void popAnonymousPseudoBlock() {
        this.blocks.pop();
    }

    public MethodInfo getMethod() {
        return this.method;
    }

    public boolean isTestMethod() {
        return this.method != null && this.method.getModifiers().isTest();
    }

    public boolean isLooping() {
        return this.looping > 0;
    }

    public void incrementBlock() {
        ++this.blocks.peek().value;
    }

    public boolean isTopLevelBlock() {
        return this.blocks.size() == 1;
    }

    public boolean isFirstStatementInBlock() {
        return this.blocks.peek().value == 0;
    }

    public boolean isOutsideMethod() {
        return MethodUtil.isInitializationBlock(this.method);
    }

    public List<Statement> getClassStatements() {
        return this.classStatements.peek();
    }

    public ValidationSettings.ValidationBehavior getBehavior() {
        return this.settings.getValidationBehavior();
    }
}

