/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ImmutableList;
import java.util.List;

final class SinglePrependList<T>
extends ImmutableList<T> {
    private final T head;
    private final List<? extends T> tail;

    SinglePrependList(T head, List<? extends T> tail) {
        this.head = head;
        this.tail = tail;
    }

    @Override
    public T get(int index) {
        return index == 0 ? this.head : this.tail.get(index - 1);
    }

    @Override
    public int size() {
        return this.tail.size() + 1;
    }

    @Override
    boolean isPartialView() {
        return false;
    }
}

