/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.symboltable;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.plsql.ast.ASTArguments;
import net.sourceforge.pmd.lang.plsql.ast.ASTName;
import net.sourceforge.pmd.lang.plsql.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.plsql.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.plsql.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLNode;
import net.sourceforge.pmd.lang.plsql.symboltable.PLSQLNameOccurrence;

public class NameFinder {
    private List<PLSQLNameOccurrence> names = new ArrayList<PLSQLNameOccurrence>();

    public NameFinder(ASTPrimaryExpression node) {
        ASTPrimaryPrefix prefix;
        Node simpleNode = node.getChild(0);
        if (simpleNode instanceof ASTPrimaryPrefix && (prefix = (ASTPrimaryPrefix)simpleNode).usesSelfModifier()) {
            this.add(new PLSQLNameOccurrence(prefix, "this"));
        }
        for (int i = 0; i < node.getNumChildren(); ++i) {
            this.checkForNameChild(node.getChild(i));
        }
    }

    public List<PLSQLNameOccurrence> getNames() {
        return this.names;
    }

    private void checkForNameChild(Node node) {
        ASTPrimarySuffix suffix;
        if (node.getImage() != null) {
            this.add(new PLSQLNameOccurrence((PLSQLNode)node, node.getImage()));
        }
        if (node.getNumChildren() > 0 && node.getChild(0) instanceof ASTName) {
            ASTName grandchild = (ASTName)node.getChild(0);
            StringTokenizer st = new StringTokenizer(grandchild.getImage(), ".");
            while (st.hasMoreTokens()) {
                this.add(new PLSQLNameOccurrence(grandchild, st.nextToken()));
            }
        }
        if (node instanceof ASTPrimarySuffix && (suffix = (ASTPrimarySuffix)node).isArguments()) {
            PLSQLNameOccurrence occurrence = this.names.get(this.names.size() - 1);
            occurrence.setIsMethodOrConstructorInvocation();
            ASTArguments args = (ASTArguments)((ASTPrimarySuffix)node).getChild(0);
            occurrence.setArgumentCount(args.getArgumentCount());
        }
    }

    private void add(PLSQLNameOccurrence name) {
        this.names.add(name);
        if (this.names.size() > 1) {
            PLSQLNameOccurrence qualifiedName = this.names.get(this.names.size() - 2);
            qualifiedName.setNameWhichThisQualifies(name);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (PLSQLNameOccurrence occ : this.names) {
            result.append(occ.getImage());
        }
        return result.toString();
    }
}

