/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.ThreadSafeReportListener;
import net.sourceforge.pmd.lang.dfa.report.ReportTree;
import net.sourceforge.pmd.stat.Metric;
import net.sourceforge.pmd.util.DateTimeUtil;
import net.sourceforge.pmd.util.NumericConstants;
import org.apache.commons.lang3.StringUtils;

public class Report
implements Iterable<RuleViolation> {
    private final ReportTree violationTree = new ReportTree();
    private final List<RuleViolation> violations = new ArrayList<RuleViolation>();
    private final Set<Metric> metrics = new HashSet<Metric>();
    private final List<ThreadSafeReportListener> listeners = new ArrayList<ThreadSafeReportListener>();
    private final List<ProcessingError> errors = new ArrayList<ProcessingError>();
    private final List<ConfigurationError> configErrors = new ArrayList<ConfigurationError>();
    private final Object lock = new Object();
    private Map<Integer, String> linesToSuppress = new HashMap<Integer, String>();
    private long start;
    private long end;
    private final List<SuppressedViolation> suppressedRuleViolations = new ArrayList<SuppressedViolation>();

    public static Report createReport(RuleContext ctx, String fileName) {
        Report report = new Report();
        report.addListeners(ctx.getReport().getListeners());
        ctx.setReport(report);
        ctx.setSourceCodeFile(new File(fileName));
        return report;
    }

    public void suppress(Map<Integer, String> lines) {
        this.linesToSuppress = lines;
    }

    private static String keyFor(RuleViolation rv) {
        return StringUtils.isNotBlank((CharSequence)rv.getPackageName()) ? rv.getPackageName() + '.' + rv.getClassName() : "";
    }

    @Deprecated
    public Map<String, Integer> getCountSummary() {
        HashMap<String, Integer> summary = new HashMap<String, Integer>();
        for (RuleViolation rv : this.violationTree) {
            String key;
            Integer o = (Integer)summary.get(key = Report.keyFor(rv));
            summary.put(key, o == null ? NumericConstants.ONE : o + 1);
        }
        return summary;
    }

    @Deprecated
    public ReportTree getViolationTree() {
        return this.violationTree;
    }

    @Deprecated
    public Map<String, Integer> getSummary() {
        HashMap<String, Integer> summary = new HashMap<String, Integer>();
        for (RuleViolation rv : this.violations) {
            String name = rv.getRule().getName();
            if (!summary.containsKey(name)) {
                summary.put(name, NumericConstants.ZERO);
            }
            Integer count = (Integer)summary.get(name);
            summary.put(name, count + 1);
        }
        return summary;
    }

    @Deprecated
    public void addListener(ThreadSafeReportListener listener) {
        this.listeners.add(listener);
    }

    @Deprecated
    public List<SuppressedViolation> getSuppressedRuleViolations() {
        return this.suppressedRuleViolations;
    }

    public void addRuleViolation(RuleViolation violation) {
        int line = violation.getBeginLine();
        if (this.linesToSuppress.containsKey(line)) {
            this.suppressedRuleViolations.add(new SuppressedViolation(violation, true, this.linesToSuppress.get(line)));
            return;
        }
        if (violation.isSuppressed()) {
            this.suppressedRuleViolations.add(new SuppressedViolation(violation, false, null));
            return;
        }
        int index = Collections.binarySearch(this.violations, violation, RuleViolation.DEFAULT_COMPARATOR);
        this.violations.add(index < 0 ? -index - 1 : index, violation);
        this.violationTree.addRuleViolation(violation);
        for (ThreadSafeReportListener listener : this.listeners) {
            listener.ruleViolationAdded(violation);
        }
    }

    @Deprecated
    public void addMetric(Metric metric) {
        this.metrics.add(metric);
        for (ThreadSafeReportListener listener : this.listeners) {
            listener.metricAdded(metric);
        }
    }

    public void addConfigError(ConfigurationError error) {
        this.configErrors.add(error);
    }

    public void addError(ProcessingError error) {
        this.errors.add(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(Report r) {
        Object object = this.lock;
        synchronized (object) {
            this.errors.addAll(r.errors);
            this.configErrors.addAll(r.configErrors);
            this.metrics.addAll(r.metrics);
            this.suppressedRuleViolations.addAll(r.suppressedRuleViolations);
            for (RuleViolation violation : r.getViolations()) {
                int index = Collections.binarySearch(this.violations, violation, RuleViolation.DEFAULT_COMPARATOR);
                this.violations.add(index < 0 ? -index - 1 : index, violation);
                this.violationTree.addRuleViolation(violation);
            }
        }
    }

    @Deprecated
    public boolean hasMetrics() {
        return !this.metrics.isEmpty();
    }

    @Deprecated
    public Iterator<Metric> metrics() {
        return this.metrics.iterator();
    }

    @Deprecated
    public boolean isEmpty() {
        return !this.violations.iterator().hasNext() && !this.hasErrors();
    }

    @Deprecated
    public boolean hasErrors() {
        return !this.getProcessingErrors().isEmpty();
    }

    @Deprecated
    public boolean hasConfigErrors() {
        return !this.getConfigurationErrors().isEmpty();
    }

    @Deprecated
    public boolean treeIsEmpty() {
        return !this.violationTree.iterator().hasNext();
    }

    @Deprecated
    public Iterator<RuleViolation> treeIterator() {
        return this.violationTree.iterator();
    }

    @Override
    @Deprecated
    public Iterator<RuleViolation> iterator() {
        return this.violations.iterator();
    }

    public final List<SuppressedViolation> getSuppressedViolations() {
        return Collections.unmodifiableList(this.suppressedRuleViolations);
    }

    public final List<RuleViolation> getViolations() {
        return Collections.unmodifiableList(this.violations);
    }

    public final List<ProcessingError> getProcessingErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public final List<ConfigurationError> getConfigurationErrors() {
        return Collections.unmodifiableList(this.configErrors);
    }

    @Deprecated
    public Iterator<ProcessingError> errors() {
        return this.getProcessingErrors().iterator();
    }

    @Deprecated
    public Iterator<ConfigurationError> configErrors() {
        return this.getConfigurationErrors().iterator();
    }

    @Deprecated
    public int treeSize() {
        return this.violationTree.size();
    }

    @Deprecated
    public int size() {
        return this.violations.size();
    }

    @Deprecated
    public void start() {
        this.start = System.currentTimeMillis();
    }

    @Deprecated
    public void end() {
        this.end = System.currentTimeMillis();
    }

    @Deprecated
    public long getElapsedTimeInMillis() {
        return this.end - this.start;
    }

    @Deprecated
    public List<ThreadSafeReportListener> getListeners() {
        return this.listeners;
    }

    @Deprecated
    public void addListeners(List<ThreadSafeReportListener> allListeners) {
        this.listeners.addAll(allListeners);
    }

    public static class SuppressedViolation {
        private final RuleViolation rv;
        private final boolean isNOPMD;
        private final String userMessage;

        public SuppressedViolation(RuleViolation rv, boolean isNOPMD, String userMessage) {
            this.isNOPMD = isNOPMD;
            this.rv = rv;
            this.userMessage = userMessage;
        }

        public boolean suppressedByNOPMD() {
            return this.isNOPMD;
        }

        public boolean suppressedByAnnotation() {
            return !this.isNOPMD;
        }

        public RuleViolation getRuleViolation() {
            return this.rv;
        }

        public String getUserMessage() {
            return this.userMessage;
        }
    }

    public static class ProcessingError {
        private final Throwable error;
        private final String file;

        public ProcessingError(Throwable error, String file) {
            this.error = error;
            this.file = file;
        }

        public String getMsg() {
            return this.error.getClass().getSimpleName() + ": " + this.error.getMessage();
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public String getDetail() {
            try (StringWriter stringWriter = new StringWriter();){
                PrintWriter writer = new PrintWriter(stringWriter);
                try {
                    this.error.printStackTrace(writer);
                    String string = stringWriter.toString();
                    writer.close();
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String getFile() {
            return this.file;
        }

        public Throwable getError() {
            return this.error;
        }
    }

    public static class ConfigurationError {
        private final Rule rule;
        private final String issue;

        public ConfigurationError(Rule theRule, String theIssue) {
            this.rule = theRule;
            this.issue = theIssue;
        }

        public Rule rule() {
            return this.rule;
        }

        public String issue() {
            return this.issue;
        }
    }

    @Deprecated
    public static class ReadableDuration {
        private final long duration;

        public ReadableDuration(long duration) {
            this.duration = duration;
        }

        public String getTime() {
            return DateTimeUtil.asHoursMinutesSeconds(this.duration);
        }
    }
}

