/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.debug;

import apex.jorje.lsp.api.debug.DebuggerService;
import apex.jorje.lsp.api.debug.ExceptionBreakpointInfo;
import apex.jorje.lsp.api.debug.LineBreakpointInfo;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.completions.CompletionItemTransformer;
import apex.jorje.lsp.impl.index.ApexIndex;
import apex.jorje.lsp.impl.index.node.ApexTypeId;
import apex.jorje.lsp.impl.utils.SfdxProjects;
import apex.jorje.lsp.impl.visitors.ExceptionBreakpointVisitor;
import apex.jorje.lsp.impl.visitors.LineBreakpointVisitor;
import apex.jorje.semantic.compiler.CodeUnit;
import com.google.common.collect.Lists;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import org.eclipse.jdt.internal.core.nd.IReader;
import org.eclipse.lsp4j.CompletionItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ApexDebuggerService
implements DebuggerService {
    private static final Logger logger = LoggerFactory.getLogger(ApexDebuggerService.class);
    private static final String SYSTEM_DOT = "System.";
    private static final String EXCEPTION_TYPEREF_PREFIX = "com/salesforce/api/exception/";
    private static final String EXCEPTION_NAME_SUFFIX = "Exception";
    private final ApexDocumentService apexDocumentService;
    private final ApexCompilerService compilerService;
    private final SfdxProjects sfdxProjectUtil;
    private final Provider<ApexIndex> apexIndexProvider;

    @Inject
    public ApexDebuggerService(ApexDocumentService apexDocumentService, ApexCompilerService compilerService, SfdxProjects sfdxProjectUtil, Provider<ApexIndex> apexIndexProvider) {
        this.apexDocumentService = apexDocumentService;
        this.compilerService = compilerService;
        this.sfdxProjectUtil = sfdxProjectUtil;
        this.apexIndexProvider = apexIndexProvider;
    }

    @Override
    public CompletableFuture<List<LineBreakpointInfo>> lineBreakpoints() {
        ArrayList result = Lists.newArrayList();
        try {
            Map<String, Set<URI>> apexUris = this.sfdxProjectUtil.getSfdxFiles();
            for (Map.Entry<String, Set<URI>> entry : apexUris.entrySet()) {
                for (URI apexUri : entry.getValue()) {
                    Optional<Document> optDoc = this.apexDocumentService.retrieve(apexUri);
                    optDoc.ifPresent(doc -> {
                        LineBreakpointVisitor visitor = new LineBreakpointVisitor();
                        CodeUnit codeUnit = this.compilerService.compile((Document)doc, (String)entry.getKey());
                        codeUnit.additionalValidate(visitor);
                        Map<String, TreeSet<Integer>> lineNumberMapping = visitor.getLineNumberMapping();
                        for (String typeref : lineNumberMapping.keySet()) {
                            result.add(new LineBreakpointInfo(apexUri, typeref, lineNumberMapping.get(typeref)));
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            logger.error("Error trying to get line breakpoint info", (Throwable)e);
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.completedFuture(result);
    }

    @Override
    public CompletableFuture<List<ExceptionBreakpointInfo>> exceptionBreakpoints() {
        ArrayList<ExceptionBreakpointInfo> result = Lists.newArrayList();
        try {
            Map<String, Set<URI>> apexUris = this.sfdxProjectUtil.getSfdxFiles();
            for (Map.Entry<String, Set<URI>> entry : apexUris.entrySet()) {
                for (URI apexUri : entry.getValue()) {
                    Optional<Document> optDoc = this.apexDocumentService.retrieve(apexUri);
                    optDoc.ifPresent(doc -> {
                        ExceptionBreakpointVisitor visitor = new ExceptionBreakpointVisitor();
                        CodeUnit codeUnit = this.compilerService.compile((Document)doc, (String)entry.getKey());
                        codeUnit.additionalValidate(visitor);
                        Map<String, String> userDefinedExceptions = visitor.getUserDefinedExceptions();
                        for (String typeref : userDefinedExceptions.keySet()) {
                            result.add(new ExceptionBreakpointInfo(apexUri, typeref, userDefinedExceptions.get(typeref)));
                        }
                    });
                }
            }
            ApexIndex apexIndex = (ApexIndex)this.apexIndexProvider.get();
            IReader ignored = apexIndex.getNd().acquireReadLock();
            Object object = null;
            try {
                List<ApexTypeId> typeIds = apexIndex.fuzzyFindTypeIds(SYSTEM_DOT);
                List<CompletionItem> completionItems = CompletionItemTransformer.transform("", typeIds);
                for (CompletionItem completionItem : completionItems) {
                    if (!completionItem.getLabel().endsWith(EXCEPTION_NAME_SUFFIX)) continue;
                    result.add(new ExceptionBreakpointInfo(null, EXCEPTION_TYPEREF_PREFIX + completionItem.getLabel(), SYSTEM_DOT + completionItem.getLabel()));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ignored != null) {
                    if (object != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ignored.close();
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Error trying to get exception breakpoint info ", (Throwable)e);
            return CompletableFuture.completedFuture(null);
        }
        result.sort(Comparator.comparing(ExceptionBreakpointInfo::getLabel));
        return CompletableFuture.completedFuture(result);
    }
}

