/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.definition;

import apex.jorje.data.Identifier;
import apex.jorje.data.Location;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.lsp.api.definition.DefinitionStrategy;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.search.MemberDefinitionLocator;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.lsp.impl.utils.Locations;
import apex.jorje.lsp.impl.utils.ParentTableUtil;
import apex.jorje.lsp.impl.utils.ParentTableVisitor;
import apex.jorje.lsp.impl.utils.TypeUsageSiteProcessor;
import apex.jorje.lsp.impl.utils.TypeUsageSiteUtil;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.compilation.UserInterface;
import apex.jorje.semantic.ast.compilation.UserTrigger;
import apex.jorje.semantic.ast.expression.CastExpression;
import apex.jorje.semantic.ast.expression.InstanceOfExpression;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.NewListInitExpression;
import apex.jorje.semantic.ast.expression.NewListLiteralExpression;
import apex.jorje.semantic.ast.expression.NewMapInitExpression;
import apex.jorje.semantic.ast.expression.NewMapLiteralExpression;
import apex.jorje.semantic.ast.expression.NewObjectExpression;
import apex.jorje.semantic.ast.expression.NewSetInitExpression;
import apex.jorje.semantic.ast.expression.NewSetLiteralExpression;
import apex.jorje.semantic.ast.expression.ReferenceExpression;
import apex.jorje.semantic.ast.expression.SuperMethodCallExpression;
import apex.jorje.semantic.ast.expression.ThisMethodCallExpression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.statement.CatchBlockStatement;
import apex.jorje.semantic.ast.statement.FieldDeclaration;
import apex.jorje.semantic.ast.statement.TypeWhenBlock;
import apex.jorje.semantic.ast.statement.VariableDeclaration;
import apex.jorje.semantic.ast.statement.WhenCases;
import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardSymbolsDefinitionStrategy
implements DefinitionStrategy {
    private static final Logger logger = LoggerFactory.getLogger(StandardSymbolsDefinitionStrategy.class);
    private final ApexCompilerService compilerService;
    private final ApexDocumentService documentService;
    private final MemberDefinitionLocator definitionLocator;

    @Inject
    public StandardSymbolsDefinitionStrategy(ApexCompilerService compilerService, ApexDocumentService documentService, MemberDefinitionLocator definitionLocator) {
        this.compilerService = compilerService;
        this.documentService = documentService;
        this.definitionLocator = definitionLocator;
    }

    @Override
    public List<? extends org.eclipse.lsp4j.Location> provideDefinition(TextDocumentPositionParams params) {
        String docUriString = params.getTextDocument().getUri();
        Optional<Document> optDoc = this.documentService.retrieve(URI.create(docUriString));
        ArrayList items = Lists.newArrayList();
        optDoc.ifPresent(doc -> {
            try {
                LocalSymbolVisitor localSymbolVisitor = new LocalSymbolVisitor(this.definitionLocator, (Document)doc, Locations.getOffset(doc, params.getPosition()));
                this.compilerService.compile((Document)doc, localSymbolVisitor);
                localSymbolVisitor.getLocation().ifPresent(items::add);
            }
            catch (BadLocationException ble) {
                logger.error("Encountered a bad location while providing definition", (Throwable)ble);
            }
        });
        return items;
    }

    static final class LocalSymbolVisitor
    extends AstVisitor<AdditionalPassScope> {
        final int selectionOffset;
        private final MemberDefinitionLocator definitionLocator;
        private final Document doc;
        private Optional<org.eclipse.lsp4j.Location> location = Optional.empty();

        LocalSymbolVisitor(MemberDefinitionLocator definitionLocator, Document doc, int selectionOffset) {
            this.definitionLocator = definitionLocator;
            this.doc = doc;
            this.selectionOffset = selectionOffset;
        }

        @Override
        protected boolean defaultVisit() {
            return true;
        }

        @Override
        public boolean visit(UserClass node, AdditionalPassScope scope) {
            return true;
        }

        @Override
        public void visitEnd(UserClass node, AdditionalPassScope scope) {
            super.visitEnd(node, scope);
            ParentTableUtil.walkUserClassParentTable(node, new FindParentTableSelectLocation(this.selectionOffset));
        }

        @Override
        public void visitEnd(UserInterface node, AdditionalPassScope scope) {
            super.visitEnd(node, scope);
            ParentTableUtil.walkInterfaceParentTable(node, new FindParentTableSelectLocation(this.selectionOffset));
        }

        @Override
        public void visitEnd(UserTrigger node, AdditionalPassScope scope) {
            super.visitEnd(node, scope);
            if (this.selectionOffset >= node.getLoc().getStartIndex() && node.getLoc().getEndIndex() >= this.selectionOffset) {
                return;
            }
            List<Identifier> names = node.getTargetName();
            Location location = Iterables.getLast(names).getLoc();
            if (this.selectionOffset >= location.getStartIndex() && location.getEndIndex() >= this.selectionOffset) {
                this.setLocation(this.from(node.getTargetType()));
            }
        }

        @Override
        public void visitEnd(CastExpression castExpression, AdditionalPassScope scope) {
            super.visitEnd(castExpression, scope);
            if (castExpression != null && castExpression.getCastType() != null) {
                TypeUsageSiteUtil.processTypeUsageSite(castExpression.getTypeRef(), castExpression.getCastType(), (TypeUsageSiteProcessor)new SetTypeUsageLocation(this.selectionOffset));
            }
        }

        @Override
        public void visitEnd(InstanceOfExpression instanceExpression, AdditionalPassScope scope) {
            super.visitEnd(instanceExpression, scope);
            if (instanceExpression != null) {
                TypeUsageSiteUtil.processTypeUsageSite(instanceExpression.getTypeRef(), instanceExpression.getInstanceOfType(), (TypeUsageSiteProcessor)new SetTypeUsageLocation(this.selectionOffset));
            }
        }

        @Override
        public void visitEnd(ReferenceExpression node, AdditionalPassScope scope) {
            super.visitEnd(node, scope);
            if (!Iterables.isEmpty(node.getNames())) {
                int startIndex = node.getLoc().getStartIndex();
                int endIndex = node.getLoc().getEndIndex();
                if (this.selectionOffset >= startIndex && endIndex >= this.selectionOffset) {
                    List<Identifier> names = node.getNames();
                    List<Variable> variables = node.getVariables();
                    List<Identifier> nonVariableNames = names.subList(0, names.size() - variables.size());
                    List<Identifier> variableNames = names.subList(nonVariableNames.size(), names.size());
                    if (!nonVariableNames.isEmpty()) {
                        TypeUsageSiteUtil.processTypeUsageSite(nonVariableNames, node.getType(), (TypeUsageSiteProcessor)new SetTypeUsageLocation(this.selectionOffset));
                    }
                    IntStream.range(0, variableNames.size()).filter(i -> this.selectionOffset >= ((Identifier)variableNames.get(i)).getLoc().getStartIndex() && ((Identifier)variableNames.get(i)).getLoc().getEndIndex() >= this.selectionOffset).findFirst().ifPresent(index -> {
                        Variable variable;
                        if (variables != null && !variables.isEmpty() && (variable = (Variable)variables.get(index)) != null) {
                            this.location = this.from(variable, this.getSourceFile(variable.getDefiningType()), variable.getLoc());
                        }
                    });
                }
            }
        }

        @Override
        public void visitEnd(MethodCallExpression node, AdditionalPassScope scope) {
            Optional<MethodInfo> method;
            super.visitEnd(node, scope);
            int startIndex = node.getLoc().getStartIndex();
            int endIndex = node.getLoc().getEndIndex();
            if (this.selectionOffset >= startIndex && endIndex >= this.selectionOffset && (method = node.getMethod()).isPresent()) {
                this.location = this.from(method.get(), this.getSourceFile(method.get().getDefiningType()), method.get().getLoc());
            }
        }

        @Override
        public void visitEnd(NewListInitExpression listInit, AdditionalPassScope scope) {
            super.visitEnd(listInit, scope);
            if (listInit != null) {
                TypeUsageSiteUtil.processTypeUsageSite(listInit.getTypeRef(), listInit.getTypeInfo(), (TypeUsageSiteProcessor)new SetTypeUsageLocation(this.selectionOffset));
            }
        }

        @Override
        public void visitEnd(NewMapInitExpression mapInit, AdditionalPassScope scope) {
            super.visitEnd(mapInit, scope);
            if (mapInit != null) {
                TypeUsageSiteUtil.processTypeUsageSite(mapInit.getTypeRef(), mapInit.getTypeInfo(), (TypeUsageSiteProcessor)new SetTypeUsageLocation(this.selectionOffset));
            }
        }

        @Override
        public void visitEnd(NewSetInitExpression setInit, AdditionalPassScope scope) {
            super.visitEnd(setInit, scope);
            if (setInit != null) {
                TypeUsageSiteUtil.processTypeUsageSite(setInit.getTypeRef(), setInit.getTypeInfo(), (TypeUsageSiteProcessor)new SetTypeUsageLocation(this.selectionOffset));
            }
        }

        @Override
        public void visitEnd(NewListLiteralExpression listInit, AdditionalPassScope scope) {
            super.visitEnd(listInit, scope);
            if (listInit != null) {
                TypeUsageSiteUtil.processTypeUsageSite(listInit.getTypeRef(), listInit.getTypeInfo(), (TypeUsageSiteProcessor)new SetTypeUsageLocation(this.selectionOffset));
            }
        }

        @Override
        public void visitEnd(NewSetLiteralExpression setInit, AdditionalPassScope scope) {
            super.visitEnd(setInit, scope);
            if (setInit != null) {
                TypeUsageSiteUtil.processTypeUsageSite(setInit.getTypeRef(), setInit.getTypeInfo(), (TypeUsageSiteProcessor)new SetTypeUsageLocation(this.selectionOffset));
            }
        }

        @Override
        public void visitEnd(NewMapLiteralExpression mapInit, AdditionalPassScope scope) {
            super.visitEnd(mapInit, scope);
            if (mapInit != null) {
                TypeUsageSiteUtil.processTypeUsageSite(mapInit.getTypeRef(), mapInit.getTypeInfo(), (TypeUsageSiteProcessor)new SetTypeUsageLocation(this.selectionOffset));
            }
        }

        @Override
        public void visitEnd(NewObjectExpression node, AdditionalPassScope scope) {
            super.visitEnd(node, scope);
            Optional<MethodInfo> constructor = node.getConstructor();
            if (constructor.isPresent()) {
                Location range = apex.jorje.data.Locations.from(node.getTypeRef().getNames().get(0).getLoc(), Iterables.getLast(node.getTypeRef().getNames()).getLoc());
                int startIndex = range.getStartIndex();
                int endIndex = range.getEndIndex();
                if (this.selectionOffset >= startIndex && endIndex >= this.selectionOffset) {
                    Location constructorLoc = constructor.get().getLoc();
                    this.location = Objects.equals(constructorLoc, apex.jorje.data.Locations.NONE) ? this.from(constructor.get().getDefiningType()) : this.from(constructor.get(), this.getSourceFile(constructor.get().getDefiningType()), constructorLoc);
                }
            }
        }

        @Override
        public void visitEnd(VariableExpression node, AdditionalPassScope scope) {
            Variable variable;
            super.visitEnd(node, scope);
            int startIndex = node.getLoc().getStartIndex();
            int endIndex = node.getLoc().getEndIndex();
            if (this.selectionOffset >= startIndex && endIndex >= this.selectionOffset && (variable = node.getVariable()) != null) {
                this.location = this.from(variable, this.getSourceFile(variable.getDefiningType()), variable.getLoc());
            }
        }

        @Override
        public void visitEnd(FieldDeclaration field, AdditionalPassScope scope) {
            super.visitEnd(field, scope);
            if (field != null) {
                TypeUsageSiteUtil.processTypeUsageSite(field.getTypeNameUsed(), field.getTypeInfoUsed(), (TypeUsageSiteProcessor)new SetTypeUsageLocation(this.selectionOffset));
            }
        }

        @Override
        public void visitEnd(VariableDeclaration variable, AdditionalPassScope scope) {
            super.visitEnd(variable, scope);
            if (variable != null) {
                TypeUsageSiteUtil.processTypeUsageSite(variable.getTypeNameUsed(), variable.getTypeInfoUsed(), (TypeUsageSiteProcessor)new SetTypeUsageLocation(this.selectionOffset));
            }
        }

        @Override
        public void visitEnd(CatchBlockStatement catchStatement, AdditionalPassScope scope) {
            super.visitEnd(catchStatement, scope);
            if (catchStatement != null) {
                TypeUsageSiteUtil.processTypeUsageSite(catchStatement.getTypeRef(), catchStatement.getVariable().getType(), (TypeUsageSiteProcessor)new SetTypeUsageLocation(this.selectionOffset));
            }
        }

        @Override
        public void visitEnd(Method node, AdditionalPassScope scope) {
            super.visitEnd(node, scope);
            int startIndex = node.getLoc().getStartIndex();
            int endIndex = node.getLoc().getEndIndex();
            if (this.selectionOffset >= startIndex && endIndex >= this.selectionOffset) {
                return;
            }
            MethodInfo methodInfo = node.getMethodInfo();
            for (Parameter param : methodInfo.getParameters()) {
                TypeUsageSiteUtil.processTypeUsageSite(param.getTypeRef(), param.getType(), (TypeUsageSiteProcessor)new SetTypeUsageLocation(this.selectionOffset));
            }
            TypeRef returnTypeRef = node.getReturnTypeRef();
            if (!returnTypeRef.getNames().isEmpty()) {
                TypeUsageSiteUtil.processTypeUsageSite(returnTypeRef, methodInfo.getReturnType(), (TypeUsageSiteProcessor)new SetTypeUsageLocation(this.selectionOffset));
            }
        }

        @Override
        public void visitEnd(SuperMethodCallExpression node, AdditionalPassScope scope) {
            Optional<MethodInfo> method;
            super.visit(node, scope);
            int startIndex = node.getLoc().getStartIndex();
            int endIndex = node.getLoc().getEndIndex();
            if (this.selectionOffset >= startIndex && endIndex >= this.selectionOffset && (method = node.getMethod()).isPresent()) {
                Location constructorLoc = method.get().getLoc();
                if (Objects.equals(constructorLoc, apex.jorje.data.Locations.NONE)) {
                    constructorLoc = method.get().getDefiningType().getCodeUnitDetails().getLoc();
                }
                this.location = this.from(method.get(), this.getSourceFile(method.get().getDefiningType()), constructorLoc);
            }
        }

        @Override
        public void visitEnd(ThisMethodCallExpression node, AdditionalPassScope scope) {
            Optional<MethodInfo> method;
            super.visit(node, scope);
            int startIndex = node.getLoc().getStartIndex();
            int endIndex = node.getLoc().getEndIndex();
            if (this.selectionOffset >= startIndex && endIndex >= this.selectionOffset && (method = node.getMethod()).isPresent()) {
                this.location = this.from(method.get(), this.getSourceFile(method.get().getDefiningType()), method.get().getLoc());
            }
        }

        @Override
        public void visitEnd(WhenCases.IdentifierCase node, AdditionalPassScope scope) {
            int startIndex = node.getLoc().getStartIndex();
            int endIndex = node.getLoc().getEndIndex();
            if (this.selectionOffset >= startIndex && endIndex >= this.selectionOffset) {
                this.location = this.from(node.getFieldInfo(), this.getSourceFile(node.getType()), node.getFieldInfo().getLoc());
            }
        }

        @Override
        public void visitEnd(TypeWhenBlock node, AdditionalPassScope scope) {
            super.visitEnd(node, scope);
            if (node != null) {
                TypeUsageSiteUtil.processTypeUsageSite(node.getTypeRef(), node.getType(), (TypeUsageSiteProcessor)new SetTypeUsageLocation(this.selectionOffset));
            }
        }

        Optional<SourceFile> getSourceFile(TypeInfo typeInfo) {
            try {
                return Optional.of(typeInfo.getCodeUnitDetails().getSource());
            }
            catch (UnsupportedOperationException uoe) {
                return Optional.empty();
            }
        }

        @VisibleForTesting
        Optional<org.eclipse.lsp4j.Location> from(Member member, Optional<SourceFile> optSourceFile, Location location) {
            SourceFile sourceFile;
            if (optSourceFile.isPresent() && (sourceFile = optSourceFile.get()).getKnownName() != null) {
                URI uri = URI.create(sourceFile.getKnownName());
                if (this.isDefinitionInCurrentFile(sourceFile)) {
                    if (Objects.equals(location, apex.jorje.data.Locations.NONE)) {
                        return Optional.empty();
                    }
                    return Optional.of(Locations.from(this.doc.getUri(), location));
                }
                if (this.isDefinitionInAnotherFile(uri)) {
                    return this.definitionLocator.locate(member, uri);
                }
            }
            return Optional.empty();
        }

        @VisibleForTesting
        Optional<org.eclipse.lsp4j.Location> from(TypeInfo info, Optional<SourceFile> optSourceFile) {
            if (optSourceFile.isPresent()) {
                String knownName = optSourceFile.get().getKnownName();
                URI uri = URI.create(knownName);
                return this.definitionLocator.locate(info, uri);
            }
            return Optional.empty();
        }

        @VisibleForTesting
        Optional<org.eclipse.lsp4j.Location> from(TypeInfo info) {
            return this.from(info, this.getSourceFile(info));
        }

        private boolean isDefinitionInAnotherFile(URI uri) {
            return uri.getScheme() != null && uri.getScheme().equalsIgnoreCase("file");
        }

        private boolean isDefinitionInCurrentFile(SourceFile sourceFile) {
            return sourceFile.getBody().equalsIgnoreCase(this.doc.getSource());
        }

        Optional<org.eclipse.lsp4j.Location> getLocation() {
            return this.location;
        }

        private void setLocation(Optional<org.eclipse.lsp4j.Location> selectedLocation) {
            this.location = selectedLocation;
        }

        private class FindParentTableSelectLocation
        implements ParentTableVisitor {
            private final int selectOffset;

            public FindParentTableSelectLocation(int selectionOffset) {
                this.selectOffset = selectionOffset;
            }

            @Override
            public boolean visit(Compilation node) {
                return true;
            }

            @Override
            public boolean visit(TypeRef typeRef, TypeInfo typeInfo) {
                TypeUsageSiteUtil.processTypeUsageSite(typeRef, typeInfo, (TypeUsageSiteProcessor)new SetTypeUsageLocation(this.selectOffset));
                return true;
            }
        }

        private class SetTypeUsageLocation
        implements TypeUsageSiteProcessor {
            private final int selectOffset;

            public SetTypeUsageLocation(int selectOffset) {
                this.selectOffset = selectOffset;
            }

            @Override
            public void processSite(String refName, TypeInfo apexType, Location location) {
                if (this.selectOffset >= location.getStartIndex() && location.getEndIndex() >= this.selectOffset) {
                    LocalSymbolVisitor.this.setLocation(LocalSymbolVisitor.this.from(apexType));
                }
            }
        }
    }
}

