/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Location;
import apex.jorje.data.ast.WhenBlock;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.statement.SwitchStatement;
import apex.jorje.semantic.ast.statement.WhenBlock;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;

public class ElseWhenBlock
implements WhenBlock {
    private final Statement statement;
    private final SwitchStatement switchStatement;

    ElseWhenBlock(SwitchStatement switchStatement, WhenBlock.ElseWhen elseLabel) {
        this.switchStatement = switchStatement;
        this.statement = AstNodes.get().create((AstNode)switchStatement, elseLabel.stmnt);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.statement.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.statement.validate(symbols, scope);
        Errors errors = scope.getErrors();
        if (errors.isInvalid(this.statement)) {
            errors.markInvalid(this);
        }
    }

    @Override
    public void emit(Emitter emitter) {
        this.statement.emit(emitter);
        if (!this.statement.isReturnable()) {
            emitter.emitJump(this.switchStatement.getLoc(), 167, this.switchStatement.getExit());
        }
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.switchStatement.getDefiningType();
    }

    @Override
    public Location getLoc() {
        return this.switchStatement.getLoc();
    }

    @Override
    public Statement getBlock() {
        return this.statement;
    }
}

