/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.PropertyDescriptor;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.variable.AbstractFieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.PropertyInfo;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;

public class TriggerPropertyInfo
extends AbstractFieldInfo
implements PropertyInfo {
    private final PropertyDescriptor property;
    private final Field underlyingField;

    private TriggerPropertyInfo(Builder builder) {
        super(builder);
        this.property = builder.property;
        this.underlyingField = builder.underlyingField;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public PropertyDescriptor getProperty() {
        return this.property;
    }

    @Override
    public FieldInfo getUnderlyingField() {
        return this.underlyingField.getFieldInfo();
    }

    @Override
    public <T, C> T accept(VariableVisitor<T, C> visitor, C context) {
        return visitor.visit(this, context);
    }

    @Override
    public Member.Type getMemberType() {
        return Member.Type.PROPERTY;
    }

    public static class Builder
    extends AbstractFieldInfo.Builder<Builder, TriggerPropertyInfo> {
        private PropertyDescriptor property;
        private Field underlyingField;

        private Builder() {
        }

        @Override
        protected TriggerPropertyInfo creator() {
            return new TriggerPropertyInfo(this);
        }

        public Builder setProperty(PropertyDescriptor property) {
            this.property = property;
            return this;
        }

        public Builder setUnderlyingField(Field underlyingField) {
            this.underlyingField = underlyingField;
            return this;
        }
    }
}

