/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers;

import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class ListPrinter<T>
implements Printer<List<T>> {
    private final Printer<T> elementPrinter;
    private final Collector<CharSequence, ?, String> joiner;

    private ListPrinter(Printer<T> elementPrinter, String separator, String nonEmptyPredecessor, String nonEmptyTrailer) {
        this.elementPrinter = elementPrinter;
        this.joiner = Collectors.joining(separator, nonEmptyPredecessor, nonEmptyTrailer);
    }

    public static <T> Printer<List<T>> create(Printer<T> elementPrinter, String separator, String nonEmptyPredecessor, String nonEmptyTrailer) {
        return new ListPrinter<T>(elementPrinter, separator, nonEmptyPredecessor, nonEmptyTrailer);
    }

    @Override
    public String print(List<T> elements, PrintContext ctx) {
        if (!elements.isEmpty()) {
            return elements.stream().map(element -> this.elementPrinter.print(element, ctx)).collect(this.joiner);
        }
        return "";
    }
}

