/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers;

import apex.jorje.data.Identifier;
import apex.jorje.data.Location;
import apex.jorje.data.ast.BlockMember;
import apex.jorje.data.ast.CatchBlock;
import apex.jorje.data.ast.ClassDecl;
import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.data.ast.ElseBlock;
import apex.jorje.data.ast.EnumDecl;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.FinallyBlock;
import apex.jorje.data.ast.ForControl;
import apex.jorje.data.ast.IfBlock;
import apex.jorje.data.ast.InterfaceDecl;
import apex.jorje.data.ast.MethodDecl;
import apex.jorje.data.ast.Modifier;
import apex.jorje.data.ast.NameValueParameter;
import apex.jorje.data.ast.NewObject;
import apex.jorje.data.ast.ParameterRef;
import apex.jorje.data.ast.PropertyDecl;
import apex.jorje.data.ast.PropertyGetter;
import apex.jorje.data.ast.PropertySetter;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.data.ast.VariableDecl;
import apex.jorje.data.ast.VariableDecls;
import apex.jorje.data.ast.WhenBlock;
import apex.jorje.data.ast.WhenCase;
import apex.jorje.data.errors.LexicalError;
import apex.jorje.data.errors.SyntaxError;
import apex.jorje.data.errors.UserError;
import apex.jorje.data.soql.Field;
import apex.jorje.data.soql.FieldIdentifier;
import apex.jorje.data.soql.Query;
import apex.jorje.data.sosl.Search;
import apex.jorje.services.printers.ListPrinter;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.PrinterFactory;
import apex.jorje.services.printers.ast.BlockMemberPrinter;
import apex.jorje.services.printers.ast.CatchBlockPrinter;
import apex.jorje.services.printers.ast.ClassDeclPrinter;
import apex.jorje.services.printers.ast.CompilationUnitPrinter;
import apex.jorje.services.printers.ast.ElseBlockPrinter;
import apex.jorje.services.printers.ast.EnumDeclPrinter;
import apex.jorje.services.printers.ast.ExprPrinter;
import apex.jorje.services.printers.ast.FinallyBlockPrinter;
import apex.jorje.services.printers.ast.ForControlPrinter;
import apex.jorje.services.printers.ast.IdentifierPrinter;
import apex.jorje.services.printers.ast.IfBlockPrinter;
import apex.jorje.services.printers.ast.InterfaceDeclPrinter;
import apex.jorje.services.printers.ast.MethodDeclPrinter;
import apex.jorje.services.printers.ast.ModifierPrinter;
import apex.jorje.services.printers.ast.NameValueParameterPrinter;
import apex.jorje.services.printers.ast.NewObjectPrinter;
import apex.jorje.services.printers.ast.OptionalNestedStatementPrinter;
import apex.jorje.services.printers.ast.OptionalPrinter;
import apex.jorje.services.printers.ast.ParameterRefPrinter;
import apex.jorje.services.printers.ast.PropertyDeclPrinter;
import apex.jorje.services.printers.ast.PropertyGetterPrinter;
import apex.jorje.services.printers.ast.PropertySetterPrinter;
import apex.jorje.services.printers.ast.StmntPrinter;
import apex.jorje.services.printers.ast.TypeRefPrinter;
import apex.jorje.services.printers.ast.VariableDeclPrinter;
import apex.jorje.services.printers.ast.VariableDeclsPrinter;
import apex.jorje.services.printers.ast.WhenBlockPrinter;
import apex.jorje.services.printers.ast.WhenCasePrinter;
import apex.jorje.services.printers.errors.LexicalErrorPrinter;
import apex.jorje.services.printers.errors.SyntaxErrorPrinter;
import apex.jorje.services.printers.errors.UserErrorPrinter;
import apex.jorje.services.printers.location.LocPrinter;
import apex.jorje.services.printers.soql.FieldIdentifierPrinter;
import apex.jorje.services.printers.soql.FieldPrinter;
import apex.jorje.services.printers.soql.QueryPrinter;
import apex.jorje.services.printers.sosl.SearchPrinter;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Optional;

public class StandardPrinterFactory
implements PrinterFactory {
    private static final Printer<Optional<List<Identifier>>> OPTIONAL_IDENTIFIERS_PRINTER = OptionalPrinter.create(ListPrinter.create(IdentifierPrinter.get(), ", ", "<", ">"), "", "", "");
    private static final Printer<ParameterRef> PARAMETER_PRINTER = new ParameterRefPrinter(ModifierPrinter.getModifiers(), TypeRefPrinter.get(), IdentifierPrinter.get());
    private static final Printer<List<ParameterRef>> PARAMETER_REFS_PRINTER = ListPrinter.create(PARAMETER_PRINTER, ", ", "", "");
    private final int indentLevel;
    private final String indent;
    private final String singleIndent;
    private final Printer<NewObject> newObjectPrinter;
    private final Printer<Expr> exprPrinter;
    private final Printer<List<Expr>> exprListPrinter;
    private final Printer<PropertyGetter> propertyGetterPrinter;
    private final Printer<PropertySetter> propertySetterPrinter;
    private final Printer<PropertyDecl> propertyDeclPrinter;
    private final Printer<MethodDecl> methodDeclPrinter;
    private final Printer<Stmnt> stmntPrinter;
    private final Printer<Optional<Stmnt>> optionalNestedStatementPrinter;
    private final Printer<VariableDecl> variableDeclPrinter;
    private final Printer<ClassDecl> classDeclPrinter;
    private final Printer<InterfaceDecl> interfaceDeclPrinter;
    private final Printer<VariableDecls> variableDeclsPrinter;
    private final Printer<EnumDecl> enumDeclPrinter;
    private final Printer<BlockMember> blockMemberPrinter;
    private final Printer<CompilationUnit> compilationUnitPrinter;
    private final Printer<WhenBlock> whenBlockPrinter;
    private final Printer<WhenCase> whenCasePrinter;
    private final Printer<Location> locPrinter;
    private final Printer<ForControl> forControlPrinter;
    private final Printer<NameValueParameter> nameValueParameterPrinter;
    private final Printer<IfBlock> ifBlockPrinter;
    private final Printer<ElseBlock> elseBlockPrinter;
    private final Printer<CatchBlock> catchBlockPrinter;
    private final Printer<FinallyBlock> finallyBlockPrinter;
    private PrinterFactory nestedASTPrinterFactory;

    StandardPrinterFactory(int indentLevel, String singleIndent) {
        this.indentLevel = indentLevel;
        this.singleIndent = singleIndent;
        this.indent = Strings.repeat(singleIndent, indentLevel);
        this.locPrinter = new LocPrinter();
        this.stmntPrinter = new StmntPrinter(this);
        this.optionalNestedStatementPrinter = new OptionalNestedStatementPrinter(this);
        this.propertyGetterPrinter = new PropertyGetterPrinter(this);
        this.propertySetterPrinter = new PropertySetterPrinter(this);
        this.propertyDeclPrinter = new PropertyDeclPrinter(this);
        this.methodDeclPrinter = new MethodDeclPrinter(this);
        this.variableDeclPrinter = new VariableDeclPrinter(this);
        this.variableDeclsPrinter = new VariableDeclsPrinter(this);
        this.classDeclPrinter = new ClassDeclPrinter(this);
        this.interfaceDeclPrinter = new InterfaceDeclPrinter(this);
        this.enumDeclPrinter = new EnumDeclPrinter(this);
        this.blockMemberPrinter = new BlockMemberPrinter(this);
        this.compilationUnitPrinter = new CompilationUnitPrinter(this);
        this.forControlPrinter = new ForControlPrinter(this);
        this.nameValueParameterPrinter = new NameValueParameterPrinter(this);
        this.ifBlockPrinter = new IfBlockPrinter(this);
        this.elseBlockPrinter = new ElseBlockPrinter(this);
        this.catchBlockPrinter = new CatchBlockPrinter(this);
        this.finallyBlockPrinter = new FinallyBlockPrinter(this);
        this.exprPrinter = new ExprPrinter(this);
        this.exprListPrinter = ListPrinter.create(this.exprPrinter, ", ", "", "");
        this.newObjectPrinter = new NewObjectPrinter(this);
        this.whenBlockPrinter = new WhenBlockPrinter(this);
        this.whenCasePrinter = new WhenCasePrinter(IdentifierPrinter.get(), this.exprPrinter);
    }

    @Override
    public synchronized PrinterFactory nestedPrinterFactory() {
        if (this.nestedASTPrinterFactory == null) {
            this.nestedASTPrinterFactory = new StandardPrinterFactory(this.indentLevel + 1, this.singleIndent);
        }
        return this.nestedASTPrinterFactory;
    }

    @Override
    public String indent() {
        return this.indent;
    }

    @Override
    public Printer<List<Identifier>> dottedIdentifier() {
        return IdentifierPrinter.getDotted();
    }

    @Override
    public Printer<Optional<Stmnt>> optionalNestedStmntPrinter() {
        return this.optionalNestedStatementPrinter;
    }

    @Override
    public Printer<Stmnt> stmntPrinter() {
        return this.stmntPrinter;
    }

    @Override
    public Printer<MethodDecl> methodDeclPrinter() {
        return this.methodDeclPrinter;
    }

    @Override
    public Printer<PropertyDecl> propertyDeclPrinter() {
        return this.propertyDeclPrinter;
    }

    @Override
    public Printer<PropertySetter> propertySetterPrinter() {
        return this.propertySetterPrinter;
    }

    @Override
    public Printer<PropertyGetter> propertyGetterPrinter() {
        return this.propertyGetterPrinter;
    }

    @Override
    public Printer<ClassDecl> classDeclPrinter() {
        return this.classDeclPrinter;
    }

    @Override
    public Printer<InterfaceDecl> interfaceDeclPrinter() {
        return this.interfaceDeclPrinter;
    }

    @Override
    public Printer<Expr> exprPrinter() {
        return this.exprPrinter;
    }

    @Override
    public Printer<TypeRef> typeRefPrinter() {
        return TypeRefPrinter.get();
    }

    @Override
    public Printer<EnumDecl> enumDeclPrinter() {
        return this.enumDeclPrinter;
    }

    @Override
    public Printer<VariableDecls> variableDeclsPrinter() {
        return this.variableDeclsPrinter;
    }

    @Override
    public Printer<VariableDecl> variableDeclPrinter() {
        return this.variableDeclPrinter;
    }

    @Override
    public Printer<BlockMember> blockMemberPrinter() {
        return this.blockMemberPrinter;
    }

    @Override
    public Printer<List<Modifier>> modifiersPrinter() {
        return ModifierPrinter.getModifiers();
    }

    @Override
    public Printer<CompilationUnit> compilationUnitPrinter() {
        return this.compilationUnitPrinter;
    }

    @Override
    public Printer<Optional<List<Identifier>>> optionalIdentifiersPrinter() {
        return OPTIONAL_IDENTIFIERS_PRINTER;
    }

    @Override
    public Printer<List<Identifier>> identifiersPrinter() {
        return IdentifierPrinter.getComma();
    }

    @Override
    public Printer<List<ParameterRef>> parameterRefsPrinter() {
        return PARAMETER_REFS_PRINTER;
    }

    @Override
    public Printer<List<Expr>> exprListPrinter() {
        return this.exprListPrinter;
    }

    @Override
    public Printer<ParameterRef> parameterRefPrinter() {
        return PARAMETER_PRINTER;
    }

    @Override
    public Printer<Identifier> identifierPrinter() {
        return IdentifierPrinter.get();
    }

    @Override
    public Printer<Modifier> modifierPrinter() {
        return ModifierPrinter.getModifier();
    }

    @Override
    public Printer<WhenBlock> whenBlockPrinter() {
        return this.whenBlockPrinter;
    }

    @Override
    public Printer<WhenCase> whenCasePrinter() {
        return this.whenCasePrinter;
    }

    @Override
    public Printer<Query> queryPrinter() {
        return QueryPrinter.get().get();
    }

    @Override
    public Printer<Field> fieldPrinter() {
        return FieldPrinter.get();
    }

    @Override
    public Printer<FieldIdentifier> fieldIdentifierPrinter() {
        return FieldIdentifierPrinter.get();
    }

    @Override
    public Printer<Search> searchPrinter() {
        return SearchPrinter.get();
    }

    @Override
    public Printer<Location> loc() {
        return this.locPrinter;
    }

    @Override
    public Printer<LexicalError> lexicalErrorPrinter() {
        return LexicalErrorPrinter.get();
    }

    @Override
    public Printer<SyntaxError> syntaxErrorPrinter() {
        return SyntaxErrorPrinter.get();
    }

    @Override
    public Printer<UserError> userErrorPrinter() {
        return UserErrorPrinter.get();
    }

    @Override
    public Printer<ForControl> forControlPrinter() {
        return this.forControlPrinter;
    }

    @Override
    public Printer<NameValueParameter> nameValueParameter() {
        return this.nameValueParameterPrinter;
    }

    @Override
    public Printer<IfBlock> ifBlockPrinter() {
        return this.ifBlockPrinter;
    }

    @Override
    public Printer<ElseBlock> elseBlockPrinter() {
        return this.elseBlockPrinter;
    }

    @Override
    public Printer<CatchBlock> catchBlockPrinter() {
        return this.catchBlockPrinter;
    }

    @Override
    public Printer<FinallyBlock> finallyBlockPrinter() {
        return this.finallyBlockPrinter;
    }

    @Override
    public Printer<NewObject> newObjectPrinter() {
        return this.newObjectPrinter;
    }
}

