/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.ast;

import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import java.util.Optional;

public class OptionalPrinter<T>
implements Printer<Optional<T>> {
    private final String empty;
    private final String leading;
    private final String trailing;
    private final Printer<T> printer;

    private OptionalPrinter(String empty, String leading, String trailing, Printer<T> printer) {
        this.empty = empty;
        this.leading = leading;
        this.trailing = trailing;
        this.printer = printer;
    }

    public static <T> Printer<Optional<T>> create(Printer<T> printer, String empty, String leading, String trailing) {
        return new OptionalPrinter<T>(empty, leading, trailing, printer);
    }

    @Override
    public String print(Optional<T> x, PrintContext ctx) {
        return x.map(value -> this.leading + this.printer.print(value, ctx) + this.trailing).orElse(this.empty);
    }
}

