/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast.internal;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;

public final class ImportWrapper {
    private static final Logger LOG = Logger.getLogger(ImportWrapper.class.getName());
    private final ASTImportDeclaration node;
    private final String name;
    private final String fullname;
    private final Set<String> allStaticDemands;

    public ImportWrapper(ASTImportDeclaration node) {
        this.node = node;
        this.fullname = node.getImportedName();
        this.name = node.getImportedSimpleName();
        this.allStaticDemands = this.collectStaticFieldsAndMethods(node);
    }

    private Set<String> collectStaticFieldsAndMethods(ASTImportDeclaration node) {
        if (!this.isStaticOnDemand() || node == null || node.getType() == null) {
            return Collections.emptySet();
        }
        try {
            HashSet<String> names = new HashSet<String>();
            for (Class<?> type = node.getType(); type != null; type = type.getSuperclass()) {
                for (Field field : type.getDeclaredFields()) {
                    if (!Modifier.isStatic(field.getModifiers())) continue;
                    names.add(field.getName());
                }
                for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
                    if (!Modifier.isStatic(((Method)accessibleObject).getModifiers())) continue;
                    names.add(((Method)accessibleObject).getName());
                }
            }
            return names;
        }
        catch (LinkageError e) {
            LOG.log(Level.FINE, "Possible incomplete auxclasspath: Error while processing imports", e);
            return Collections.emptySet();
        }
    }

    public boolean matches(String fullName, String name) {
        if (this.isStaticOnDemand() && this.allStaticDemands.contains(fullName)) {
            return true;
        }
        if (this.name == null && name == null) {
            return fullName.equals(this.fullname);
        }
        return name.equals(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportWrapper that = (ImportWrapper)o;
        return Objects.equals(this.node.isStatic(), that.node.isStatic()) && Objects.equals(this.isOnDemand(), that.isOnDemand()) && Objects.equals(this.node.getImportedName(), that.node.getImportedName());
    }

    public int hashCode() {
        return Objects.hash(this.node.isStatic(), this.node.isImportOnDemand(), this.node.getImportedName());
    }

    public String getName() {
        return this.name;
    }

    public String getPackageName() {
        return this.node.getPackageName();
    }

    public String getFullName() {
        return this.fullname;
    }

    public ASTImportDeclaration getNode() {
        return this.node;
    }

    public boolean isStaticOnDemand() {
        return this.node.isStatic() && this.node.isImportOnDemand();
    }

    public String toString() {
        return "Import[name=" + this.name + ",fullname=" + this.fullname + ",static*=" + this.isStaticOnDemand() + ']';
    }

    public boolean isOnDemand() {
        return this.node.isImportOnDemand();
    }
}

