/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.documentation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.Comment;
import net.sourceforge.pmd.lang.java.rule.documentation.AbstractCommentRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import org.apache.commons.lang3.StringUtils;

public class CommentContentRule
extends AbstractCommentRule {
    private boolean caseSensitive;
    private List<String> originalBadWords;
    private List<String> currentBadWords;
    public static final PropertyDescriptor<Boolean> CASE_SENSITIVE_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"caseSensitive").defaultValue((Object)false)).desc("Case sensitive")).build();
    public static final PropertyDescriptor<List<String>> DISSALLOWED_TERMS_DESCRIPTOR = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"disallowedTerms").desc("Illegal terms or phrases")).defaultValues((Object)"idiot", (Object[])new String[]{"jerk"}).build();
    private static final Set<PropertyDescriptor<?>> NON_REGEX_PROPERTIES = new HashSet(1);

    public CommentContentRule() {
        this.definePropertyDescriptor(CASE_SENSITIVE_DESCRIPTOR);
        this.definePropertyDescriptor(DISSALLOWED_TERMS_DESCRIPTOR);
    }

    public void start(RuleContext ctx) {
        this.originalBadWords = (List)this.getProperty(DISSALLOWED_TERMS_DESCRIPTOR);
        this.caseSensitive = (Boolean)this.getProperty(CASE_SENSITIVE_DESCRIPTOR);
        if (this.caseSensitive) {
            this.currentBadWords = this.originalBadWords;
        } else {
            this.currentBadWords = new ArrayList<String>();
            for (String badWord : this.originalBadWords) {
                this.currentBadWords.add(badWord.toUpperCase(Locale.ROOT));
            }
        }
    }

    public void end(RuleContext ctx) {
    }

    private List<String> illegalTermsIn(Comment comment) {
        if (this.currentBadWords.isEmpty()) {
            return Collections.emptyList();
        }
        String commentText = this.filteredCommentIn(comment);
        if (StringUtils.isBlank((CharSequence)commentText)) {
            return Collections.emptyList();
        }
        if (!this.caseSensitive) {
            commentText = commentText.toUpperCase(Locale.ROOT);
        }
        ArrayList<String> foundWords = new ArrayList<String>();
        for (int i = 0; i < this.currentBadWords.size(); ++i) {
            if (!commentText.contains(this.currentBadWords.get(i))) continue;
            foundWords.add(this.originalBadWords.get(i));
        }
        return foundWords;
    }

    private String errorMsgFor(List<String> badWords) {
        StringBuilder msg = new StringBuilder(this.getMessage()).append(": ");
        if (badWords.size() == 1) {
            msg.append("Invalid term: '").append(badWords.get(0)).append('\'');
        } else {
            msg.append("Invalid terms: '");
            msg.append(badWords.get(0));
            for (int i = 1; i < badWords.size(); ++i) {
                msg.append("', '").append(badWords.get(i));
            }
            msg.append('\'');
        }
        return msg.toString();
    }

    @Override
    public Object visit(ASTCompilationUnit cUnit, Object data) {
        if (this.currentBadWords == null) {
            this.start(null);
        }
        for (Comment comment : cUnit.getComments()) {
            List<String> badWords = this.illegalTermsIn(comment);
            if (badWords.isEmpty()) continue;
            this.addViolationWithMessage(data, (Node)cUnit, this.errorMsgFor(badWords), comment.getBeginLine(), comment.getEndLine());
        }
        return super.visit(cUnit, data);
    }

    private boolean hasDisallowedTerms() {
        List terms = (List)this.getProperty(DISSALLOWED_TERMS_DESCRIPTOR);
        return !terms.isEmpty();
    }

    @Deprecated
    public boolean hasDissallowedTerms() {
        return this.hasDisallowedTerms();
    }

    public String dysfunctionReason() {
        return this.hasDissallowedTerms() ? null : "No disallowed terms specified";
    }

    static {
        NON_REGEX_PROPERTIES.add(CASE_SENSITIVE_DESCRIPTOR);
    }
}

