/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.List;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class ProperCloneImplementationRule
extends AbstractJavaRule {
    public ProperCloneImplementationRule() {
        this.addRuleChainVisit(ASTMethodDeclaration.class);
    }

    @Override
    public Object visit(ASTMethodDeclaration method, Object data) {
        ASTClassOrInterfaceDeclaration classDecl;
        if (this.isCloneMethod(method) && this.isNotAbstractMethod(method) && this.isNotFinal(classDecl = (ASTClassOrInterfaceDeclaration)method.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class)) && this.hasAnyAllocationOfClass(method, classDecl.getSimpleName())) {
            this.addViolation(data, method);
        }
        return data;
    }

    private boolean isCloneMethod(ASTMethodDeclaration method) {
        return "clone".equals(method.getName()) && method.getArity() == 0;
    }

    private boolean isNotAbstractMethod(ASTMethodDeclaration method) {
        return !method.isAbstract();
    }

    private boolean isNotFinal(ASTClassOrInterfaceDeclaration classOrInterfaceDecl) {
        return !classOrInterfaceDecl.isFinal();
    }

    private boolean hasAnyAllocationOfClass(ASTMethodDeclaration method, String className) {
        List allocations = method.findDescendantsOfType(ASTAllocationExpression.class);
        for (ASTAllocationExpression allocation : allocations) {
            ASTClassOrInterfaceType allocatedType = (ASTClassOrInterfaceType)allocation.getFirstChildOfType(ASTClassOrInterfaceType.class);
            if (!this.isSimpleNameOfType(className, allocatedType)) continue;
            return true;
        }
        return false;
    }

    private boolean isSimpleNameOfType(String simpleName, ASTClassOrInterfaceType type) {
        return type != null && type.hasImageEqualTo(simpleName);
    }
}

